#modname "Hellenika 2.20i Ersatz 1.01"
#description "This mod pack by AetherNomad focuses on the Early Ages and the ancient Mediterranean world; it includes the following:
- 14 EA mod nations with enhanced mutual compatibility: Thalamanth v1.37, Triliax v1.31, Nephelococcygia v1.39, Isphenople v1.30, Arcadeia v1.26, Nabatem v1.30, Karanaac v1.34, Cyanautha v1.21, Zun v1.22, U v1.19, Bethel She'em v1.15, Ylthule v1.10 and, in Hellenika-specific versions, Knoss (by Zonk) & Makedon (by Mirokan);
- 31 modified EA vanilla nations with new mechanics, sprites and lore: Arcoscephale, Ermor (Old Ermor & New Ermor), Ulm, Marverni, Sauromatia, T'ien Ch'i, Machaka, Mictlan (Nok), Abysia, Caelum, C'tis, Pangaea, Agartha, Tir na n'Og, Fomoria, Vanheim (Midgård), Niefelheim, Rus, Kailasa, Lanka, Yomi (Subartu), Hinnom, Ur (Eridu), Berytos, Mekone, Ubar, Atlantis (Iapeto), R'lyeh (Aulgyaththu), Pelagia, Oceania & Therodos; additionally, Helheim & Xibalba were removed;
- 16 vanilla nations converted from MA/LA to EA with new mechanics, sprites and lore: MA Asphodel, MA Caelum (Hararat), MA Bandar Log, MA Uruk (Akkad), MA Phlegra, MA Phaeacia, MA Ind, MA Na'Ba (Sa'Ba), MA Atlantis, MA Ys, LA Arcoscephale (Delphanes), LA C'tis (Aabydum), LA Ragha, LA Phlegra (Porphyrion), LA R'lyeh & LA Erytheia;
- Pantheon Reborn v1.26, a general pretender balance mod that buffs the majority of vanilla pretenders;
- Rebirth v1.06, a simple utility mod that slowly repopulates dead provinces while under Growth scales and friendly dominion if no Blood mage is present;
- Arena Reborn v1.01, a simple utility mod that improves the arena mechanics mostly by making rewards generate gold and by giving their bearers the slayed soul affliction;
- A few extra balance changes (twiceborn, transformation, elementals, raiding, coast starts) and a secret quest with epic rewards for any nation to investigate;
- If downloaded via dominionsmods.com or Steam, a detailed .pdf listing all changes.
Discord: https://discord.gg/m2BknaY
Mail: aethernomad@gmail.com"
#icon "./Hellenika/Hellenika_banner.tga"
#version Ersatz1.01-2.20i

---------------- USED IDs
--new weapon IDs -- 1100-1249
--new armor IDs -- 797-814 879-888
--new monster IDs -- ||6000-6361 6363-6953 6955 6957-7336 7338-7776 -- DON'T GO LOWER
--new montags -- 4105-4168
--new item IDs -- 770-800 857-870
--new item restrictions -- 8055-8095
--new nametypes -- 236-240
--new site IDs -- 1741-1998|| -- CAN'T GO HIGHER
--new nation IDs -- 170 180-181 220-231
--new enchantment IDs -- 500-750
--new event IDs -- 311-320
--new event codes -- -3250
--events: 2999/2999 (0 left)

-- The Iron Walls, Crumble, Revive Wights, Revive Bane, Revive Bane Lord, Contact Trolls, Contact Sea Trolls, Contact Forest Trolls, Pack of Wolves, Summon Crocodiles, Summon Horned Serpents, Summon Asp Turtle, Summon Ogres, Reanimation, Vermin Feast and Locust Swarm spells were modified for use of #onebattlespell and replaced with identical copies. This doesn't affect the game but might cause incompatibilities with mods that use/modify these spells.

###

---------- WEAPONS

#newweapon 1246
#copyweapon 611 -- Ice Spear
#name "Ice Pick"
#blunt
#len 1
#armorpiercing
#end

#newweapon 1247
#copyweapon 612 -- Ice Blade
#name "Ice Fang"
#dt_weapondrain
#end

#newweapon 1248
#copyweapon 612 -- Ice Blade
#name "Ice Axe"
#def 1
#att 3
#dt_small
#end

#newweapon 1249
#copyweapon 77 -- Ice Sword
#name "Ice Spur"
#len 3
#dmg 10
#att 5
#def 5
#pierce
#end

#newweapon 1244
#name "Beak"
#len 0
#slash
#att 1
#def -1
#dmg 15
#nostr
#bonus
#end

#newweapon 1245
#name "Wing Buff"
#len 0
#blunt
#att -1
#def -1
#dmg 12
#nostr
#bonus
#end

#newweapon 1238
#name "True Gnomon"
#dmg 2
#pierce
#armornegating
#nostr
#len 1
#nratt 1
#att 2
#def 1
#end

#newweapon 1242
#copyweapon 715 -- Tremor Stun
#name "Stunning Blow"
#dt_realstun
#aoe 1
#end

#newweapon 1243
#copyweapon 181 -- Implementor Axe
#name "Royal Labrys"
#secondaryeffectalways 1242
#end

#newweapon 1241
#copyweapon 728 -- Double Axe
#name "Knossian Labrys"
#secondaryeffectalways 1242
#dmg 9
#end

#newweapon 1240
#copyweapon 698 -- Bronze Battleaxe
#name "Knossian Sagaris"
#secondaryeffectalways 1242
#end

#newweapon 1239
#copyweapon 613 -- Enchanted Bow
#name "Bow of Winds"
#ammo 30
#range 100
#end

#newweapon 1237
#copyweapon 273 -- Pincer
#name "Coral Pincer"
#dmg 4
#halfstr
#end

#selectweapon 720 -- Ritual Baton
#magic
#secondaryeffectalways 441 -- Banish to Inferno
#end

#newweapon 1236
#copyweapon 63 -- Life Drain
#name "Invisible drain"
#unrepel
#end

#newweapon 1235
#copyweapon 282 -- Paralyze
#name "Invisible touch"
#unrepel
#end

#newweapon 1234
#copyweapon 744 -- Enchanted No-Dachi
#name "Divine Blade"
#armornegating
#end

#newweapon 1233
#copyweapon 532 -- Tail Sweep
#name "Stomp"
#sound 17
#dmg 7
#aoe 8
#armorpiercing
#friendlyimmune
#nostr
#norepel
#unrepel
#flyingimmune
#end

#newweapon 1232
#copyweapon 520 -- Dawn Blade
#name "Anathema Blade"
#dt_magic
#secondaryeffect 694 -- Curse and Curse Luck
#end

#selectweapon 582 -- Snake Skirt
#name "Snake Cloak"
#nratt 9
#end

#newweapon 1231
#copyweapon 116 -- Strangulation
#bonus
#def 0
#end

#newweapon 1230
#copyweapon 552 -- Soul Rending
#mrnegateseasily
#end

#newweapon 1229
#copyweapon 20 -- Bite
#name "Soul Rending Bite"
#magic
#secondaryeffect 1230
#end

#newweapon 1228
#copyweapon 401 -- Soul Death
#mrnegateseasily
#end

#newweapon 1227
#copyweapon 20 -- Bite
#name "Devour Soul"
#magic
#secondaryeffect 1228
#end

#newweapon 1226
#copyweapon 735 -- Serpent Leg
#name "Snake Arm"
#dmg 0
#att 0
#def -1
#end

#newweapon 1225
#copyweapon 238 -- Magic Staff
#name "Rain Idol"
#len 4
#att -1
#dmg 5
#def 5
#end

#newweapon 1224
#copyweapon 7 -- Quarterstaff
#name "Sun Idol"
#len 4
#att -2
#dmg 5
#def 4
#rcost 5
#end

#selectweapon 288 -- Obsidian Club Sword
#name "Obsidian Battleaxe"
#end

#selectweapon 451 -- Obsidian Club Sword
#name "Obsidian Axe"
#end

#newweapon 1223
#name "Draw Blood"
#nratt 1
#sizeresist
#nostr
#armornegating
#dt_aff 8192
#end

#newweapon 1222
#copyweapon 288 -- Obsidian Battleaxe
#name "Leopard Saw-Blade"
#secondaryeffect 1223
#end

#newweapon 1221
#copyweapon 696 -- Petrifying Gas
#name "Petrifying Gaze"
#friendlyimmune
#ammo 12
#end

#selectweapon 383 -- Throw Flames
#bonus
#end

#newweapon 1220
#copyweapon 249 -- Venomous Claw
#name "Coral Arm"
#pierce
#armorpiercing
#end

#newweapon 1219
#copyweapon 395 -- Shadow Brand
#name "Twilight Fire Blade"
#twohanded
#len 2
#def 3
#end

#newweapon 1217
#name "Death Scythe"
#dmg 12
#att 5
#def -2
#len 3
#nratt 1
#twohanded
#slash
#magic
#secondaryeffect 112 -- Heart Finding
#end

#newweapon 1216
#name "Ardent Blade"
#dmg 8
#att 3
#len 1
#nratt 1
#armorpiercing
#slash
#magic
#dt_holy
#secondaryeffectalways 216
#end

#newweapon 1215
#copyweapon 646 -- Bronze Hatchet
#name "Enki's Fang"
#dmg 6
#magic
#soulslaying
#end

#newweapon 1214
#name "Subartan Glaive"
#dmg 8
#att 2
#def 2
#len 3
#nratt 1
#twohanded
#slash
#end

#newweapon 1213
#name "Ancient Glaive"
#dmg 9
#att 3
#def 3
#len 3
#nratt 1
#twohanded
#slash
#magic
#secondaryeffect 440
#end

#newweapon 1212
#copyweapon 502 -- Yak Tail Fly Whisk
#name "Ceremonial Bough"
#magic
#armorpiercing
#dmg 1
#secondaryeffect 52 -- Death Poison
#end

#newweapon 1211
#name "Dark Crystal Spear"
#dmg 10
#att 3
#def -1
#len 3
#nratt 1
#armorpiercing
#pierce
#magic
#sound 18
#secondaryeffectalways 63 -- Life Drain
#end

#selectweapon 531 -- Mighty Yari
#dt_large
#secondaryeffect 247 -- Slay magic
#end

#newweapon 1210
#copyweapon 510 -- Divine Grasp
#name "Kami Bite"
#bonus
#slash
#dmg 2
#def -1
#secondaryeffectalways 509 -- Bane of Heresy
#end

#selectweapon 344 -- Demon-Slayer
#len 2
#dmg 12
#armorpiercing
#end

#newweapon 1209
#copyweapon 322
#name "Thundering Bite"
#magic
#secondaryeffect 738 -- Shock
#end

#selectweapon 483 -- Gae Bulga
#soulslaying
#att 100
#armornegating
#end

#selectweapon 486 -- Gae Assail
#att 100
#end

#selectweapon 388 -- Pearl Spear
#dt_magic
#end

#selectweapon 389 -- Pearl Trident
#dt_magic
#end

#selectweapon 665 -- Pearl Blade
#dt_magic
#end

#newweapon 1119
#name "Golden Battleaxe"
#dmg 12
#att 1
#len 2
#nratt 1
#twohanded
#slash
#magic
#end

#newweapon 1208
#name "Wall Smasher"
#rcost 3
#range 0
#dmg 11
#def -1
#att -1
#nratt 1
#len 3
#twohanded
#blunt
#end

#newweapon 1207
#name "Divine Will"
#dmg 0
#aoe 3
#nratt 1
#att 0
#def 0
#len 0
#sound 89
#explspr 10102
#armornegating
#magic
#halfstr
#hardmrneg
#friendlyimmune
#norepel
#unrepel
#natural
#bonus
#end

#newweapon 1206
#copyweapon 230 -- Owl
#name "Bird"
#dmg 9
#pierce
#end

#newweapon 1111
#copyweapon 651 -- Bronze Lance
#name "Mortalbane Lance"
#dmg 6
#att 1
#def 1
#end

#newweapon 1112
#copyweapon 651 -- Bronze Lance
#name "Giantbane Lance"
#dt_large
#len 5
#end

#newweapon 1113
#copyweapon 651 -- Bronze Lance
#name "Demonbane Lance"
#dt_holy
#end

#newweapon 1114
#copyweapon 651 -- Bronze Lance
#name "Magicbane Lance"
#dt_magic
#magic
#end

#newweapon 1115
#copyweapon 651 -- Bronze Lance
#name "Heavenly Lance"
#dmg 6
#att 1
#def 1
#len 5
#dt_demon
#armorpiercing
#magic
#end

#selectweapon 427 -- Granite Glaive
#dmg 12
#end

#newweapon 1198
#copyweapon 56 -- Hoof
#name "Wing Buff"
#att -1
#def -1
#dmg 10
#end

#newweapon 1109
#copyweapon 264 -- Composite bow
#range050
#end

#newweapon 1110
#copyweapon 23 -- Short bow
#range050
#end

#selectweapon 522 -- Golden Horns
#dt_magic
#end

#selectweapon 758 -- Silver Horns
#dt_holy
#end

#newweapon 1100
#copyweapon 344 -- Demon-Slayer
#name "Immaculate Blade"
#len 2
#pierce
#att 3
#def 3
#end

#selectweapon 118 -- Curse
#norepel
#unrepel
#end

#selectweapon 442 -- Dimensional Shift
#norepel
#unrepel
#end

#newweapon 1107
#copyweapon 589 -- Tail Slap
#name "Giant Pipe"
#dmg -2
#len 4
#def 2
#end

#newweapon 1205
#copyweapon 32
#dmg 2
#att 1
#name "Coral Dagger"
#end

#newweapon 1204
#name "Asp's Bite"
#dmg 2
#att 2
#nratt 1
#len 0
#ammo 1
#armorpiercing
#norepel
#bonus
#pierce
#secondaryeffect 52
#skip
#end

#newweapon 1108
#copyweapon 23 -- Short Bow
#name "Elite Short Bow"
#dmg 7
#nratt 2
#ammo 30
#end

#newweapon 1116
#copyweapon 86 -- Mind Blast
#name "Greater Mind Blast"
#ammo 30
#end

#selectweapon 706 -- Gastraphetes
#dmg 9
#end

#newweapon 1117
#name "Ice Shard"
#dmg 8
#nratt 1
#cold
#magic
#nostr
#armorpiercing
#secondaryeffectalways 607 -- Freeze
#end

#selectweapon 606 -- Frost bow
#secondaryeffectalways 1117
#end

#selectweapon 642 -- Meteorite Trident
#att 2
#def 3
#end

#newweapon 1122
#copyweapon 478 -- Unholy Spear
#name "Unholy Lance"
#charge
#end

#newweapon 1118
#copyweapon 442
#sound 114
#hardmrneg
#end

#selectweapon 145 -- Heavenly Horn
#friendlyimmune
#end

#newweapon 1121
#copyweapon 387 -- Sleep Touch
#name "Angelic Touch"
#dmg 50
#end

#newweapon 1120
#name "Infinity Blade"
#armornegating
#att 5
#def 3
#len 1
#nratt 1
#dmg 15
#magic
#dt_holy
#soulslaying
#secondaryeffectalways 1218
#end

#newweapon 1218
#name "Eternity Wound"
#armornegating
#dmg 8
#nratt 1
#aoe 3
#nostr
#magic
#dt_holy
#soulslaying
#friendlyimmune
#norepel
#unrepel
#explspr 10215
#end

#newweapon 1106
#copyweapon 408
#name "Silver Talons"
#armorpiercing
#nratt 2
#ironweapon
#end

#selectweapon 426 -- Obsidian Glaive
#secondaryeffect 118 -- Curse
#end

#newweapon 1104
#copyweapon 532 -- Tail Sweep
#nostr
#dmg 7
#len 2
#end

#newweapon 1123
#copyweapon 8 -- Fire Brand - for sound effect
#name "Banefire Brand"
#dmg 8
#att 3
#len 1
#nratt 1
#armorpiercing
#slash
#magic
#secondaryeffectalways 1124
#end

#newweapon 1124
#name "Small Area Banefire"
#dmg 14
#nratt 1
#aoe 1
#armorpiercing
#magic
#nostr
#norepel
#unrepel
#secondaryeffectalways 432 -- Small Area Decay
#explspr 10107
#end

#newweapon 1125
#name "Dance of blades"
#att 5
#def 5
#dmg 12
#len 1
#nratt 4
#magic
#slash
#end

#newweapon 1126
#name "Spirit Mace"
#dmg 11
#att 1
#def 1
#len 2
#dt_large
#magic
#blunt
#secondaryeffectalways 564
#end

#newweapon 1128
#copyweapon 92 -- Fist
#name "God-Slayer Pankration"
#att 0
#magic
#secondaryeffectalways 509 -- Bane of Heresy
#end

#newweapon 1129
#copyweapon 723 -- Bronze Discus
#name "God-Slayer Discus"
#magic
#dmg 7
#prec -2
#end

#newweapon 1130
#copyweapon 509 -- Bane of Heresy
#name "Bane of the Gods"
#aoe 2
#dmg 25
#friendlyimmune
#end

#newweapon 1131
#copyweapon 171 -- Small Area Fire
#secondaryeffectalways 1130
#aoe 2
#friendlyimmune
#end

#newweapon 1132
#name "Ichor Drinking Strike"
#dmg 1125899906842624
#dt_aff
#magic
#friendlyimmune
#secondaryeffectalways 1131
#end

#newweapon 1133
#copyweapon 277 -- Demon Whip
#name "God-Slayer Whip"
#aoe 2
#len 5
#dmg 1
#nratt 1
#nostr
#dt_weapondrain
#armornegating
#friendlyimmune
#secondaryeffectalways 1132
#end

#newweapon 1203
#name "Banefire"
#dmg 8
#nratt 1
#magic
#armorpiercing
#nostr
#secondaryeffectalways 64 -- Decay
#end

#newweapon 1202
#name "Banefire Falchion"
#dmg 8
#len 1
#nratt 1
#slash
#magic
#rcost 0
#secondaryeffectalways 1203
#end

#newweapon 1200
#copyweapon 644 -- Bronze Long Spear
#name "Sarissa"
#len 6
#rcost 3
#end

#newweapon 1199
#copyweapon 644 -- Bronze Long Spear
#name "Celestial Sarissa"
#len 6
#dmg 7
#att 3
#def 1
#magic
#end

#newweapon 1136
#copyweapon 599 -- Corrosive Spit
#ammo 8
#end

#newweapon 1139
#copyweapon 175 -- Chi Kick
#name "Dance of the Foot"
#nratt 1
#att 2
#def 2
#dmg 4
#len 2
#end

#newweapon 1150
#copyweapon 671 -- Stone Dagger
#name "Sharp Flint"
#att 0
#end

#newweapon 1151
#copyweapon 22 -- Sling
#name "Pebble"
#range -1
#ammo 1
#dmg -2
#end

#newweapon 1152
#copyweapon 605 -- Throw Rocks
#name "Rock"
#ammo 1
#dmg -15
#range -2
#end

#newweapon 1153
#copyweapon 27
#name "Huge Boulder"
#aoe 1
#ammo 1
#dmg 0
#explspr 10189
#end

#newweapon 1127
#name "Small Area Fatigue"
#aoe 1
#dmg 10
#nratt 1
#norepel
#unrepel
#nostr
#armornegating
#dt_stun
#end

#newweapon 1201
#name "Shockwave"
#aoe 1
#dmg 1
#explspr 10189
#armornegating
#nostr
#norepel
#unrepel
#secondaryeffectalways 1127
#end

#selectweapon 27 -- Boulder -- Niefelheim, Phlegra, Porphyrion
#secondaryeffectalways 1201
#end

#selectweapon 424 -- Boulder -- Agartha
#secondaryeffectalways 1201
#end

#selectweapon 546 -- Boulder -- The Pebble Pouch
#secondaryeffectalways 1201
#end

#newweapon 1135
#copyweapon 411 -- Small Area Fatigue
#name "Large Area Fatigue"
#aoe 5
#friendlyimmune
#explspr -1
#end

#newweapon 1138
#copyweapon 524 -- Pillar of Laws
#name "Column"
#dmg 6
#aoe 1
#def 3
#att -1
#secondaryeffectalways 1135
#end

#newweapon 1193
#copyweapon 532 -- Tail Sweep
#name "Giant Boulder"
#sound 17
#dmg 4
#att -4
#len 1
#end

#newweapon 1137
#copyweapon 532 -- Tail Sweep
#name "Squash"
#sound 17
#dmg 1
#aoe 12
#friendlyimmune
#end

#newweapon 1192
#copyweapon 542 -- Acid
#aoe 1
#end

#newweapon 1191
#copyweapon 532 -- Tail Sweep
#name "Acid Crush"
#secondaryeffectalways 1192
#end

#newweapon 1134
#copyweapon 532 -- Tail Sweep
#name "Wing Buff"
#secondaryeffectalways 688 -- Freezing Mist
#end

#selectweapon 567 -- Drake Fire
#bonus
#end

#newweapon 1149
#name "Blessed Falchion"
#slash
#magic
#dmg 8
#len 1
#att 1
#def 1
#nratt 1
#sound 8
#end

#newweapon 1101
#copyweapon 584 -- Lightning
#name "Thundercrack"
#ammo 30
#secondaryeffectalways 1102
#end

#newweapon 1102
#name "Area Shock"
#shock
#magic
#armornegating
#nostr
#norepel
#unrepel
#aoe 1
#dmg 8
#nratt 1
#explspr 10245
#end

#newweapon 1103
#copyweapon 230 -- Owl
#name "Raven"
#secondaryeffect 333 -- Eyeloss
#end

#newweapon 1154
#copyweapon 532 -- Tail Sweep
#name "Squash"
#sound 17
#dmg 1
#end

#newweapon 1148
#name "Falx"
#dmg 10
#nratt 1
#att 0
#def 1
#len 2
#twohanded
#sound 12
#rcost 5
#slash
#ironweapon
#flail
#end

#newweapon 1143
#copyweapon 4
#name "Bronze Lance"
#dmg 3
#len 3
#pierce
#norepel
#end

#newweapon 1144
#copyweapon 4
#name "Hero Lance"
#dmg 5
#att 2
#len 3
#pierce
#norepel
#dt_large
#magic
#end

#newweapon 1145
#copyweapon 4
#name "Lance of Titans"
#armorpiercing
#dmg 7
#att 3
#len 3
#pierce
#norepel
#dt_large
#magic
#end

#newweapon 1146
#copyweapon 474
#name "Hero Sword"
#dt_large
#end

#newweapon 1147
#copyweapon 518
#name "Sword of Titans"
#armorpiercing
#dt_large
#end

#newweapon 1155
#copyweapon 243
#name "Thunder Bow"
#end

#newweapon 1140
#name "Fatigue"
#dmg 0
#nratt 1
#blunt
#armorpiercing
#mrnegates
#dt_stun
#end

#newweapon 1141
#copyweapon 92 -- fist
#name "Fatiguing Blow"
#dmg 0
#nratt 1
#att 0
#def 0
#secondaryeffectalways 1140
#end

#newweapon 1142
#name "Bow of Alconis"
#dmg 9
#nratt 13
#range 50
#ammo 12
#twohanded
#sound 14
#pierce
#magic
#bowstr
#flyspr 109 1
#end

#newweapon 1190
#name "Blade of the Sky"
#dmg 12
#nratt 1
#att 5
#def 6
#len 2
#slash
#magic
#rcost 0
#sound 24
#secondaryeffect 114
#end

#newweapon 1197
#copyweapon 401 -- Soul Death
#hardmrneg
#end

#newweapon 1194
#copyweapon 52 -- Death poison
#secondaryeffect 1197
#dmg 25
#end

#newweapon 1196
#name "Divine Longbow"
#dmg 12
#twohanded
#pierce
#att 30
#def 0
#nratt 1
#ammo 12
#range 45
#len 0
#rcost 0
#sound 14
#magic
#dt_normal
#bowstr
#flyspr 109 1
#secondaryeffect 1194
#end

#newweapon 1181
#copyweapon 243 -- Lightning
#name "Thundercrack"
#bonus
#att 0
#aoe 1
#dmg 7
#flyspr -1 -- 210
#explspr 10241 -- 10219, 10241, 10244
#nouw
#end

#newweapon 1182
#copyweapon 185 -- Lightning Swarm
#explspr 10244
#end

#newweapon 1183
#name "Golden Feathers"
#nostr
#magic
#ammo 1
#range 2
#aoe 1
#nratt 1
#dmg 5
#pierce
#bonus
#nostr
#sound 46 --12 or 46
#range0
#flyspr -1
#explspr 10151 --10146 or 10151
#end

#newweapon 1184
#name "Eyeloss"
#nostr
#nratt 1
#dt_aff
#dmg 524288 -- Eyeloss
#mrnegates
#norepel
#unrepel
#magic
#end

#newweapon 1189
#copyweapon 196
#name "Rainbow Burst"
#aoe 1
#len 0
#norepel
#unrepel
#secondaryeffect 1184
#end

#newweapon 1188
#copyweapon 408
#name "Golden Talons"
#dmg 2
#magic
#end

#newweapon 1187
#copyweapon 404
#name "Golden Beak"
#dmg 2
#magic
#end

#newweapon 1186
#name "Eyeloss"
#nostr
#nratt 1
#dt_aff
#dmg 524288 -- Lost eye
#end

#newweapon 1185
#copyweapon 408
#name "Vicious Talons"
#armorpiercing
#secondaryeffect 1186
#end

#newweapon 1180
#name "Fencing Quill"
#dmg 8
#nratt 1
#att 1
#def 0
#len 2
#rcost 0
#sound 15
#magic
#armornegating
#nostr
#end

#newweapon 1179
#name "Throwing Quill"
#dmg 4
#nratt 1
#att 1
#def 0
#ammo 6
#range 10
#rcost 0
#sound 15
#flyspr 403 1
#magic
#armornegating
#nostr
#nouw
#end

#newweapon 1178
#name "Slashing Scroll"
#dmg 10
#nratt 2
#att 1
#def 1
#len 2
#rcost 0
#sound 15
#magic
#armornegating
#nostr
#end

#newweapon 1177
#copyweapon 459
#att 3
#ammo 6
#dmg 2
#nratt 3
#end

#newweapon 1176
#copyweapon 216
#dmg 4
#end

#newweapon 1175
#name "Cold"
#dmg 4
#nratt 1
#cold
#armorpiercing
#magic
#nostr
#end

#newweapon 1174
#name "Shock"
#dmg 4
#nratt 1
#shock
#armorpiercing
#magic
#nostr
#end

#newweapon 1173
#name "Antimagic"
#dmg 2
#nratt 1
#dt_magic
#armornegating
#magic
#nostr
#end

#newweapon 1172
#copyweapon 8
#name "Fire Enchanted Sword"
#secondaryeffect 1176
#magic
#dmg 5
#end

#newweapon 1171
#copyweapon 8
#name "Cold Enchanted Sword"
#secondaryeffect 1175
#magic
#dmg 5
#end

#newweapon 1170
#copyweapon 8
#name "Shock Enchanted Sword"
#secondaryeffect 1174
#magic
#dmg 5
#end

#newweapon 1169
#copyweapon 8
#name "Antimagic Sword"
#secondaryeffect 1173
#magic
#dmg 5
#end

#newweapon 1168
#name "Pure magic"
#dmg 8
#nratt 1
#armornegating
#magic
#nostr
#end

#newweapon 1167
#copyweapon 8
#name "Sword of the Conclave"
#secondaryeffect 1168
#magic
#end

#newweapon 1166
#copyweapon 20
#name "Enchanted Bite"
#secondaryeffect 1168
#magic
#end

#newweapon 1165
#copyweapon 399
#name "Enchanted Gore"
#secondaryeffect 1168
#magic
#end

#newweapon 1161
#name "Purification"
#dmg 10
#nratt 1
#magic
#nostr
#armornegating
#hardmrneg
#dt_constructonly
#undeadonly
#end

#newweapon 1162
#name "Unbearable Splendor"
#dmg 10
#nratt 1
#magic
#nostr
#armornegating
#hardmrneg
#dt_constructonly
#mind
#undeadimmune
#secondaryeffectalways 1161
#end

#newweapon 1163
#name "Destructive Light"
#dmg 10
#nratt 1
#aoe 7
#norepel
#unrepel
#magic
#nostr
#armornegating
#hardmrneg
#inanimateimmune
#secondaryeffectalways 1162
#explspr 10215
#end

#newweapon 1164
#name "Unutterable Blade"
#dmg 15
#att 5
#def 3
#len 2
#nratt 1
#slash
#magic
#sound 8
#armorpiercing
#secondaryeffectalways 1163
#end

#newweapon 1160
#copyweapon 475
#name "Meteorite Lance"
#secondaryeffectalways 509
#end

#newweapon 1195
#copyweapon 473 -- Golden Spear
#name "Golden Long Spear"
#rcost 6 -- 4 more than normal long spear, 1 more than normal golden spear
#len 4
#end

#newweapon 1159
#copyweapon 388 -- Pearl Spear
#name "Pearl Long Spear"
#rcost 3 -- 1 more than normal long spear
#def -1 -- like long spear
#len 4 -- like long spear
#end

#newweapon 1158
#copyweapon 474 -- Golden Sword
#rcost 7 -- 1 more than normal bronze sword
#pierce -- in addition to slash, like Bronze Sword and Pearl Blade
#end

#newweapon 1105
#copyweapon 333 -- Eyeloss
#hardmrneg
#end

#newweapon 1156
#copyweapon 171 -- Small Area Fire
#name "Ignition"
#secondaryeffectalways 1105
#dmg 6
#end

#newweapon 1157
#name "Mirror Lens"
#bonus
#ammo 30
#nratt -2
#range 50
#att 5
#aoe 1
#dmg 6
#rcost 12
#sound 3
#norepel
#unrepel
#natural
#armornegating
#magic
#explspr 10243
#nouw
#nostr
#secondaryeffectalways 1156
#end


---------- ARMORS

#newarmor 813
#copyarmor 226 -- Ice Cap
#name "Ice Helm"
#prot 20
#end

#newarmor 814
#copyarmor 226 -- Ice Cap
#name "Ice Crown"
#prot 24
#end

#newarmor 812
#copyarmor 1 -- Buckler
#name "Buckler of Winds"
#magicarmor
#end

#newarmor 811
#copyarmor 139
#name "Kulullu Barding"
#prot 18
#end

#newarmor 810
#copyarmor 2 -- Shield
#name "Winter Shield"
#prot 18
#def 5
#end

#selectarmor 139 -- Ichtycentaur Barding
#prot 18
#end

#newarmor 808
#copyarmor 113 -- Skull Necklace
#name "Skull Talismans"
#end

#newarmor 807
#name "Plundered Amulet"
#type 4
#prot 3
#def 8
#magicarmor
#end

#newarmor 806
#copyarmor 121 -- Leather Hood
#name "Reinforced Leather Hood"
#prot 9
#end

#newarmor 805
#copyarmor 212 -- Magic Crown
#name "Crown of Sorcery"
#prot 14
#end

#newarmor 804
#copyarmor 187 -- Wooden Mask
#name "Nok Mask"
#def 0
#end

#newarmor 809
#copyarmor 187 -- Wooden Mask
#name "Nok War Mask"
#prot 17
#def 0
#end

#selectarmor 104 -- Mictlan Armor
#name "Nok Armor"
#end

#selectarmor 106 -- Mictlan Copper Scale Armor
#name "Nok Copper Scale Armor"
#end

#newarmor 879
#copyarmor 101 -- Bronze Hauberk
#name "Dendra Panoply"
#prot 21
#end

#selectarmor 190 -- Coral Barding
#prot 14
#end

#newarmor 803
#copyarmor 182 -- Immaculate Shield
#name "Empyreal Shield"
#end

#newarmor 802
#name "Royal Pelt"
#prot 15
#def 0
#enc 0
#magicarmor
#end

#newarmor 888
#copyarmor 28 -- Ice Aegis
#name "Silver Aegis"
#end

#selectarmor 210 -- Meteorite Cuirass
#prot 20
#end

#newarmor 797
#name "Dance of Blades"
#rcost 0
#type 4
#enc 0
#prot 25
#def 6
#end

#newarmor 798
#name "Giant Boulder"
#type 4
#magicarmor
#rcost 50
#def 12
#prot 40
#enc 5
#end

#newarmor 799
#name "Bronze Hauberk of Heroes"
#magicarmor
#prot 18
#rcost 10
#type 5
#def -1
#enc 2
#end

#newarmor 800
#copyarmor 143
#name "Bronze Tower Shield"
#end

#newarmor 801
#name "Hauberk of Titans"
#magicarmor
#prot 21
#rcost 10
#type 5
#def -1
#enc 2
#end

#newarmor 880
#copyarmor 76
#name "Scroll of Protection"
#end

#newarmor 881
#copyarmor 92
#name "Meteorite Shield"
#def 5
#end

#newarmor 882
#copyarmor 181 -- Golden Hoplon
#rcost 7 -- 4 more than normal hoplon
#end

#newarmor 883
#copyarmor 213 -- Golden Helmet
#prot 22 -- a bit more than a normal Hoplite Helmet, like Golden Hoplon has more than a normal Hoplon
#rcost 9 -- 4 more than normal hoplite helmet
#end

#newarmor 884
#copyarmor 214 -- Golden Armor
#name "Golden Hauberk"
#rcost 25 -- 5 more than normal plate hauberk
#prot 22 -- 4 more than normal plate hauberk
#end

#newarmor 885
#copyarmor 189 -- Pearl Shield
#name "Pearl Hoplon"
#rcost 9 -- 6 more than normal hoplon
#prot 19 -- same as normal hoplon
#def 5 -- 1 more than normal hoplon
#end

#newarmor 886
#copyarmor 123 -- Hoplite Helmet
#name "Pearl Helmet"
#rcost 11 -- 6 more than normal hoplite helmet
#magicarmor
#def 0 -- 1 more than normal hoplite helmet 
#end

#newarmor 887
#copyarmor 101 -- Bronze Hauberk
#name "Pearl Hauberk"
#rcost 26 -- 6 more than normal plate hauberk
#prot 18 -- like normal plate hauberk
#magicarmor
#enc 3 -- 1 less than normal plate hauberk
#end


---------- UNITS

#selectmonster 24 -- indie Light Cavalry
#spr1 "./Hellenika/0024_1.tga"
#spr2 "./Hellenika/0024_2.tga"
#end

#selectmonster 1751 -- Sidhe Warrior
#magicpower 1
#end

#selectmonster 2989 -- Rusian Hunter
#addupkeep -10
#end

#selectmonster 2990 -- Rusian Warrior (spear)
#addupkeep -10
#end

#selectmonster 2991 -- Rusian Warrior (axe)
#addupkeep -10
#end

#selectmonster 2995 -- Bear Warrior
#addupkeep -18
#end

#selectmonster 2993 -- Chud Warrior
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2992 -- Chud Hunter
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2994 -- Chud Berserker
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2997 -- Chud Skinshifter
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2996 -- Werebear (Chud Skinshifter)
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 3061 -- Hell Spawn
#hp 42
#end

#selectmonster 3062 -- Hellbred Giant
#hp 81
#end

#selectmonster 3063 -- Hellbred Horite
#hp 43
#end

#selectmonster 2222 -- Frog
#name "Frog"
#descr "A small amphibian. Legend has it that some frogs are actually princes transformed by the witches of Ys."
#end

#selectmonster 2929 -- Swan
#name "Swan"
#descr "Since ancient times Swans are revered in Kernou and the land of the ever young. Swans have often settled in sacred groves and castle gardens of the Tuatha and the Kernou tribe considered the birds almost sacred. With the reemergence of Ker-Ys blessed swans were given the Kernou by their Morgen rulers and now every sacred grove is attended by a swanherd caring for his flock. Swans are not very strong, but they can be aggressive when defending their homes or when responding to the calls of their swanherds. In battle they are mostly used to harass archers and lightly armed troops."
#holy
#end

#selectmonster 2907 -- Ysian Militia
#name "Ysian Militia"
#descr "Most of the inhabitants of Ker-Ys are Merrow, a strange breed of merfolk that resemble ugly, fish-eyed, green-skinned men with webbed fingers and green hair. Merrow are larger than humans and quite strong. Merrow have no problems leaving the sea, but they prefer the comfort of the waves. In ancient times they made contact with human and Fir Bolg settlements. With time they allied themselves with Tir na n'Og and a clan of Tuatha sorceresses made its way into the sea to study and guide the Merrow and their druids. Ker-Ys was founded and the Merrow gained influence in the underwater realms. When Tir na n'Og banished the Ladies of Ker-Ys, the citadel was hidden beneath the waves and its queens became known as Morgen; the Merrow lost their power and Ker-Ys became a refuge for them or anyone who sided with their new queens. Thus did the Merrow renounce all friendship with the faraway Tuatha who abandoned them. After the sunken city reemerged from the waves, the Merrow gladly renewed their allegience, and now they faithfully follow their Morgen rulers in conquest of the underwater realms."
#gcost 6
#end

#selectmonster 2908 -- Ysian Spearman
#name "Ysian Spearman"
#descr "Most of the inhabitants of Ker-Ys are Merrow, a strange breed of merfolk that resemble ugly, fish-eyed, green-skinned men with webbed fingers and green hair. Merrow are larger than humans and quite strong. Merrow have no problems leaving the sea, but they prefer the comfort of the waves. In ancient times they made contact with human and Fir Bolg settlements. With time they allied themselves with Tir na n'Og and a clan of Tuatha sorceresses made its way into the sea to study and guide the Merrow and their druids. Ker-Ys was founded and the Merrow gained influence in the underwater realms. When Tir na n'Og banished the Ladies of Ker-Ys, the citadel was hidden beneath the waves and its queens became known as Morgen; the Merrow lost their power and Ker-Ys became a refuge for them or anyone who sided with their new queens. Thus did the Merrow renounce all friendship with the faraway Tuatha who abandoned them. After the sunken city reemerged from the waves, the Merrow gladly renewed their allegience, and now they faithfully follow their Morgen rulers in conquest of the underwater realms."
#gcost 9
#end

#selectmonster 2923 -- Ysian Infantry
#name "Ysian Infantry"
#descr "Most of the inhabitants of Ker-Ys are Merrow, a strange breed of merfolk that resemble ugly, fish-eyed, green-skinned men with webbed fingers and green hair. Merrow are larger than humans and quite strong. Merrow have no problems leaving the sea, but they prefer the comfort of the waves. In ancient times they made contact with human and Fir Bolg settlements. With time they allied themselves with Tir na n'Og and a clan of Tuatha sorceresses made its way into the sea to study and guide the Merrow and their druids. Ker-Ys was founded and the Merrow gained influence in the underwater realms. When Tir na n'Og banished the Ladies of Ker-Ys, the citadel was hidden beneath the waves and its queens became known as Morgen; the Merrow lost their power and Ker-Ys became a refuge for them or anyone who sided with their new queens. Thus did the Merrow renounce all friendship with the faraway Tuatha who abandoned them. After the sunken city reemerged from the waves, the Merrow gladly renewed their allegience, and now they faithfully follow their Morgen rulers in conquest of the underwater realms. The Merrow of Ys have mastered metal-working skills unknown to other Merrow and Ysian Soldiers and Men at Arms fight with armaments made of bronze."
#gcost 9
#end

#selectmonster 2909 -- Ysian Man at Arms
#name "Ysian Man at Arms"
#descr "Most of the inhabitants of Ker-Ys are Merrow, a strange breed of merfolk that resemble ugly, fish-eyed, green-skinned men with webbed fingers and green hair. Merrow are larger than humans and quite strong. Merrow have no problems leaving the sea, but they prefer the comfort of the waves. In ancient times they made contact with human and Fir Bolg settlements. With time they allied themselves with Tir na n'Og and a clan of Tuatha sorceresses made its way into the sea to study and guide the Merrow and their druids. Ker-Ys was founded and the Merrow gained influence in the underwater realms. When Tir na n'Og banished the Ladies of Ker-Ys, the citadel was hidden beneath the waves and its queens became known as Morgen; the Merrow lost their power and Ker-Ys became a refuge for them or anyone who sided with their new queens. Thus did the Merrow renounce all friendship with the faraway Tuatha who abandoned them. After the sunken city reemerged from the waves, the Merrow gladly renewed their allegience, and now they faithfully follow their Morgen rulers in conquest of the underwater realms. The Merrow of Ys have mastered metal-working skills unknown to other Merrow and Ysian Soldiers and Men at Arms fight with armaments made of bronze."
#gcost 11
#end

#selectmonster 2910 -- Knight of Ys (UW)
#name "Knight of Ys"
#descr "The Knights of Ys are noble-born Merrow trained for battle from a young age. The Knights of Ys resemble the human knights of the feudal kingdoms, but they ride shape shifting Kelpies instead of horses and are not as heavily armored. Kelpies are able to change their shape into that of a horse and the Knights of Ys have been known to raid coastal settlements in Ermor and Marverni."
#mapmove 24
#gcost 30
#end

#selectmonster 2911 -- Knight of Ys (land)
#name "Knight of Ys"
#descr "The Knights of Ys are noble-born Merrow trained for battle from a young age. The Knights of Ys resemble the human knights of the feudal kingdoms, but they ride shape shifting Kelpies instead of horses and are not as heavily armored. Kelpies are able to change their shape into that of a horse and the Knights of Ys have been known to raid coastal settlements in Ermor and Marverni."
#gcost 30
#end

#selectmonster 2897 -- Kernou Warrior
#name "Kernou Warrior"
#descr "The Kernou was a small Marverni tribe that fell under the sway of the Tuatha of Tir na n'Og. When the city of Bronze and Crystal rose to power the inhabitants of Kernou became ever more dependent on the gifts of the Tuatha. When Tir na n'Og banned the Morgen and Ker-Ys vanished beneath the waves the Kernou tribe succumbed to Marverni rule and lost much of the lore and riches once bestowed upon them by the Tuatha. But Marverni also was threatened by greater powers, and in the ensuing instability the remaining Kernou tribesmen were able to take their independence back and survive long enough to witness the reemergence of Ker-Ys. The former servants of the Tuatha now flock to the call of the Morgen, ready to receive their blessing anew. Benefitting from the technological advancements of their past conquerors, Kernou Warriors fight and arm themselves with light Marverni chainmail and weapons, but warriors never fight bare chested and the nobles of the tribe use heavy mail hauberks. The Morgen's wondrous gifts and secrets have made the Kernou particularly resistant to fear and magic."
#mr 13
#mor 13
#end

#selectmonster 2898 -- Kernou Noble Warrior
#name "Kernou Noble Warrior"
#descr "The Kernou was a small Marverni tribe that fell under the sway of the Tuatha of Tir na n'Og. When the city of Bronze and Crystal rose to power the inhabitants of Kernou became ever more dependent on the gifts of the Tuatha. When Tir na n'Og banned the Morgen and Ker-Ys vanished beneath the waves the Kernou tribe succumbed to Marverni rule and lost much of the lore and riches once bestowed upon them by the Tuatha. But Marverni also was threatened by greater powers, and in the ensuing instability the remaining Kernou tribesmen were able to take their independence back and survive long enough to witness the reemergence of Ker-Ys. The former servants of the Tuatha now flock to the call of the Morgen, ready to receive their blessing anew. Benefitting from the technological advancements of their past conquerors, Kernou Warriors fight and arm themselves with light Marverni chainmail and weapons, but warriors never fight bare chested and the nobles of the tribe use heavy mail hauberks. The Morgen's wondrous gifts and secrets have made the Kernou particularly resistant to fear and magic."
#mr 13
#mor 14
#end

#selectmonster 2899 -- Kernou Cavalry
#name "Kernou Cavalry"
#descr "Before their subjugation by Marverni the Kernou never used horses, but with developments in other lands and the return of the Morgen, the Kernou humans have adopted new tactics. The Kernou are now training cavalry besides the common warriors. While not as skilled as the Morvarc'h Knights, the Karnou cavalry is still a force to be reckoned with."
#mr 13
#mor 14
#end

#selectmonster 2915 -- Morvarc'h Knight (UW)
#name "Morvarc'h Knight"
#descr "The Morgen rivals of the Tuatha are to the merrow and humans of Ys what the Tuatha and Sidhe are to the Fir Bolg of Tir na n'Og, semi-divine beings endowed with mystical powers. The Morgen live in the city of Bronze and Crystal and are rarely seen by the Kernou humans. But now, with the return of the sleeping God, the Morgen have taken up the arms of the Tuatha and mounted the legendary steeds known as Morvarc'h to conquer a world once taken from them. The Morvarc'h are black sea-horses with flaming nostrils and burning manes. They are able to gallop on the sea and swim under water. They can only be ridden by their Morgen mistresses, but no one else would probably try. Morgen are close cousins of the Tuatha and like them can use glamour to confuse enemies, but the burning manes and fiery breath of the Morvarc'h are not easily hidden. They are also sensitive to iron and use armaments of bronze or enchanted metals. The Morvarc'h Knights are revered and sacred to the people of Ys, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost. Although they are ever present in the capital, their recruitment in other undersea castles requires the presence of a Morgen Princess or hero for their training."
#mapmove 28
#ap 36
#enchrebate50p 59
#end

#selectmonster 2916 -- Morvarc'h Knight (land)
#name "Morvarc'h Knight"
#descr "The Morgen rivals of the Tuatha are to the merrow and humans of Ys what the Tuatha and Sidhe are to the Fir Bolg of Tir na n'Og, semi-divine beings endowed with mystical powers. The Morgen live in the city of Bronze and Crystal and are rarely seen by the Kernou humans. But now, with the return of the sleeping God, the Morgen have taken up the arms of the Tuatha and mounted the legendary steeds known as Morvarc'h to conquer a world once taken from them. The Morvarc'h are black sea-horses with flaming nostrils and burning manes. They are able to gallop on the sea and swim under water. They can only be ridden by their Morgen mistresses, but no one else would probably try. Morgen are close cousins of the Tuatha and like them can use glamour to confuse enemies, but the burning manes and fiery breath of the Morvarc'h are not easily hidden. They are also sensitive to iron and use armaments of bronze or enchanted metals. The Morvarc'h Knights are revered and sacred to the people of Ys, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost. Although they are ever present in the capital, their recruitment in other undersea castles requires the presence of a Morgen Princess or hero for their training."
#enchrebate50p 59
#end

#newmonster 6614
#name "Morvarc'h Knight"
#descr "The Morgen rivals of the Tuatha are to the merrow and humans of Ys what the Tuatha and Sidhe are to the Fir Bolg of Tir na n'Og, semi-divine beings endowed with mystical powers. The Morgen live in the city of Bronze and Crystal and are rarely seen by the Kernou humans. But now, with the return of the sleeping God, the Morgen have taken up the arms of the Tuatha and mounted the legendary steeds known as Morvarc'h to conquer a world once taken from them. The Morvarc'h are black sea-horses with flaming nostrils and burning manes. They are able to gallop on the sea and swim under water. They can only be ridden by their Morgen mistresses, but no one else would probably try. Morgen are close cousins of the Tuatha and like them can use glamour to confuse enemies, but the burning manes and fiery breath of the Morvarc'h are not easily hidden. They are also sensitive to iron and use armaments of bronze or enchanted metals. The Morvarc'h Knights are revered and sacred to the people of Ys, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost. Although they are ever present in the capital, their recruitment in other undersea castles requires the presence of a Morgen Princess or hero for their training."
#copystats 2915 -- Morvarc'h Knight
#copyspr 2915
#landshape 4615
#monpresentrec -4106
#reclimit 1
#enchrebate50p 59
#end

#newmonster 6615
#name "Morvarc'h Knight"
#descr "The Morgen rivals of the Tuatha are to the merrow and humans of Ys what the Tuatha and Sidhe are to the Fir Bolg of Tir na n'Og, semi-divine beings endowed with mystical powers. The Morgen live in the city of Bronze and Crystal and are rarely seen by the Kernou humans. But now, with the return of the sleeping God, the Morgen have taken up the arms of the Tuatha and mounted the legendary steeds known as Morvarc'h to conquer a world once taken from them. The Morvarc'h are black sea-horses with flaming nostrils and burning manes. They are able to gallop on the sea and swim under water. They can only be ridden by their Morgen mistresses, but no one else would probably try. Morgen are close cousins of the Tuatha and like them can use glamour to confuse enemies, but the burning manes and fiery breath of the Morvarc'h are not easily hidden. They are also sensitive to iron and use armaments of bronze or enchanted metals. The Morvarc'h Knights are revered and sacred to the people of Ys, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost. Although they are ever present in the capital, their recruitment in other undersea castles requires the presence of a Morgen Princess or hero for their training."
#copystats 2916 -- Morvarc'h Knight
#copyspr 2916
#watershape 4614
#monpresentrec -4106
#reclimit 1
#enchrebate50p 59
#end

#selectmonster 1508 -- Huskarl
#pillagebonus 1
#end

#selectmonster 1509 -- Huskarl
#pillagebonus 1
#end

#selectmonster 1510 -- Hirdman
#pillagebonus 1
#end

#selectmonster 1504 -- Mounted Hirdman
#pillagebonus 2
#end

#selectmonster 400 -- Skinshifter
#name "Skinshifter"
#descr "Skinshifters are Van followers of the Galdermen who have learned from them the esoteric traditions and the ability to change shape. Skinshifters fight as Vanir until they become seriously hurt and then turn into halfmen of wolven appearance. Skinshifters regenerate in both human and wolven form."
#maxage 300
#mr 14
#illusion
#stealthy 25
#att 11
#def 11
#berserk 2
#gcost 35
#end

#selectmonster 399 -- Werewolf (Skinshifter)
#maxage 300
#mr 16
#illusion
#stealthy 25
#berserk 2
#gcost 35
#end

#selectmonster 1503 -- Helhirding
#darkpower 3
#end

#selectmonster 663 -- Fay Boar
#name "Fay Boar"
#descr "The fay boar is a breed of magical swine known to exist only in Midgård. The creatures are sometimes used in warfare, but it is their immortality, not their physical power, that makes them invaluable. The swine are slain each evening to feed the soldiers, but at dawn they are again alive and well, ready to march with the armies of Midgård."
#addupkeep -100
#end

#selectmonster 3400 -- Thrymshirding
#name "Thrymshirding"
#descr "There are a few Jotun spread across Niefelheim who unlike most of their brethren carry the legacy of the great Niefel in their blood. Those are blessed with divine parentage and can claim some distant connection to the legendary Tjatse, ancient founder of the citadel of Thrymsheim. Stronger than their kin and sanctified by the cold breath of the Niefel Giants they have become the paragons of Jotunkin. Although weaker, shorter and lower than the true Niefel, they are like them children of the Eternal Winter and are more powerful in cold climates. Like all Jotunkin they cannot stand lightning and fear thunder."
#hp 61
#gcost 100
#reclimit 1
#mountainsurvival
#end

#selectmonster 1310 -- Ulfhedin
#name "Ulfhedin"
#descr "Ulfhednar are Jotun warriors enchanted with the magic of the Jarnvidjur. They are trained and armed in the darkest reaches of the Iron Wood. They fight with wild battleaxes and wear enchanted wolf skins that allows the wearer to change shape into a beast-wolf. When the skin is bloodied, the wearer howls in pain and rage and is forced to take beast form. The blood magic of the skin gives the warrior regenerative powers and unrivaled ferocity. The wolf skins are only given to a select few deemed worthy by the Jarnvidjur."
#copyspr 784 -- Garmhirding
#hp 50
#gcost 70
#mountainsurvival
#clearweapons
#weapon 18 -- Battleaxe
#end

#selectmonster 1651 -- Jotun Werewolf
#hp 61
#gcost 70
#mountainsurvival
#end

#selectmonster 1302 -- Jotun Bondi
#copystats 277
#copyspr 277
#hp 46
#gcost 20
#mountainsurvival
#end

#selectmonster 276 -- Jotun Javelinist
#hp 49
#gcost 30
#mountainsurvival
#end

#selectmonster 1303 -- Jotun Warrior (spear)
#copystats 278
#copyspr 278
#name "Jotun Spearman"
#descr "While most Jotuns farm and fight for their local Herse, an increasing number has chosen a martial career with the imminent Awakening of the Lord. If their chieftain is rich they may equip themselves with armors of metal-reinforced leather, but most use inexpensive armors of fur and leather. The spear is the most popular weapon, but axes and javelins are also used."
#hp 49
#gcost 30
#mountainsurvival
#end

#selectmonster 1304 -- Jotun Warrior (axe)
#copystats 279
#copyspr 279
#name "Jotun Axeman"
#descr "While most Jotuns farm and fight for their local Herse, an increasing number has chosen a martial career with the imminent Awakening of the Lord. If their chieftain is rich they may equip themselves with armors of metal-reinforced leather, but most use inexpensive armors of fur and leather. The spear is the most popular weapon, but axes and javelins are also used."
#hp 49
#gcost 30
#mountainsurvival
#end

#selectmonster 1305 -- Jotun Hurler
#copystats 300
#copyspr 300
#hp 49
#gcost 30
#mountainsurvival
#end

#selectmonster 1306 -- Jotun Huskarl
#copystats 840
#copyspr 840
#hp 52
#gcost 35
#mountainsurvival
#end

#selectmonster 1307 -- Godihuskarl
#copystats 841
#copyspr 841
#hp 54
#gcost 40
#mountainsurvival
#end

#selectmonster 1308 -- Jotun Hirdman
#copystats 842
#copyspr 842
#hp 57
#gcost 50
#mountainsurvival
#end

#selectmonster 845 -- Niefel Giant
#hp 104
#gcost 140
#mor 16
#mountainsurvival
#cleararmor
#armor 15
#armor 810
#armor 20
#end

#newmonster 7553
#copystats 3302 -- Piconye Peasant
#copyspr 3302
#name "Piconye Peasant"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. Had it not been for their horns they might be mistaken for the hoburg people. Piconye Peasants rarely take up arms, but will defend their land should enemies attack. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3302
#gcost 0
#end

#selectmonster 3302 -- Piconye Peasant
#name "Piconye Peasant"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. Had it not been for their horns they might be mistaken for the hoburg people. Piconye Peasants rarely take up arms, but will defend their land should enemies attack. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5553
#end

#newmonster 7554
#copystats 3303 -- Piconye Slinger
#copyspr 3303
#name "Piconye Slinger"
#descr "In Magnificent Ind there is a land called Piconye. Here lives little horned men who serve he Prester King in all his endeavors. In times of need Piconye mostly relies on the armies of the Prester King, but they are able to defend for themselves. Every year Piconye is attacked by strange birds, and the Piconye King gathers his soldiers and peasants armed with slings to take down the airborne threat. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3303
#gcost 0
#end

#selectmonster 3303 -- Piconye Slinger
#name "Piconye Slinger"
#descr "In Magnificent Ind there is a land called Piconye. Here lives little horned men who serve he Prester King in all his endeavors. In times of need Piconye mostly relies on the armies of the Prester King, but they are able to defend for themselves. Every year Piconye is attacked by strange birds, and the Piconye King gathers his soldiers and peasants armed with slings to take down the airborne threat. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5554
#end

#newmonster 7555
#copystats 3304 -- Piconye Spearman
#copyspr 3304
#name "Piconye Spearman"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. While ugly and menacing-looking they are righteous and loyal and vigilantly follow their king to defend their land from the strange birds that attack every year. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3304
#gcost 0
#end

#selectmonster 3304 -- Piconye Spearman
#name "Piconye Spearman"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. While ugly and menacing-looking they are righteous and loyal and vigilantly follow their king to defend their land from the strange birds that attack every year. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5555
#end

#newmonster 7556
#copystats 3305 -- Piconye Soldier
#copyspr 3305
#name "Piconye Soldier"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. While ugly and menacing-looking they are righteous and loyal and vigilantly follow their king to defend their land from the strange birds that attack every year. The Piconye Soldiers are the elites of the kingdom and fight with shortswords instead of spears. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3305
#gcost 0
#end

#selectmonster 3305 -- Piconye Soldier
#name "Piconye Soldier"
#descr "In Magnificent Ind there is a land of little horned men who serve the Prester King. While ugly and menacing-looking they are righteous and loyal and vigilantly follow their king to defend their land from the strange birds that attack every year. The Piconye Soldiers are the elites of the kingdom and fight with shortswords instead of spears. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5556
#end

#newmonster 7557
#copystats 3307 -- Satyr Slave
#copyspr 3307
#name "Satyr Slave"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3307
#gcost 0
#chaospower 1
#end

#selectmonster 3307 -- Satyr Slave
#name "Satyr Slave"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5557
#chaospower 1
#end

#newmonster 7558
#copystats 3308 -- Centaur Chariot
#copyspr 3308
#name "Centaur Chariot"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. Since the half-men are brighter and braver than horses, they are used to pull scythe-wheeled archer chariots. As long as there are riders on the chariot the half-man pulling it follows orders as expected. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3308
#gcost 0
#end

#selectmonster 3308 -- Centaur Chariot
#name "Centaur Chariot"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. Since the half-men are brighter and braver than horses, they are used to pull scythe-wheeled archer chariots. As long as there are riders on the chariot the half-man pulling it follows orders as expected. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5558
#end

#newmonster 7559
#copystats 3310 -- Lady Warrior
#copyspr 3310
#name "Lady Warrior"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Soldier Priests of Ind, the Lady Warriors of the Queendom fight more bravely than the men of any other land. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3310
#gcost 0
#end

#selectmonster 3310 -- Lady Warrior
#name "Lady Warrior"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Soldier Priests of Ind, the Lady Warriors of the Queendom fight more bravely than the men of any other land. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5559
#end

#newmonster 7560
#copystats 3311 -- Lady Knight
#copyspr 3311
#name "Lady Knight"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Soldier Priests of Ind, the Lady Knights of the Queendom fight more bravely than the men of any other land. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3311
#gcost 0
#end

#selectmonster 3311 -- Lady Knight
#name "Lady Knight"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Soldier Priests of Ind, the Lady Knights of the Queendom fight more bravely than the men of any other land. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5560
#end

#newmonster 7561
#copystats 3319 -- Centaur Slave
#copyspr 3319
#name "Centaur Slave"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. No other archer equals the might and skill of the beast-men of Great Orionde. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3319
#gcost 0
#end

#selectmonster 3319 -- Centaur Slave
#name "Centaur Slave"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Although Great Orionde fields great armies of knights and crossbowmen, it is the half-men and beasts of the land that attracts the attention of visitors. Strange beings with the lower parts of horses or goats are displayed for laughs at the towns and taverns of the kingdom. But these half-men are also used as warriors in the armies levied by the kings of Orionde to serve at the Prester King's pleasure. No other archer equals the might and skill of the beast-men of Great Orionde. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5561
#end

#newmonster 7562
#copystats 3323 -- Orionde Crossbowman
#copyspr 3323
#name "Orionde Crossbowman"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3323
#gcost 0
#end

#selectmonster 3323 -- Orionde Crossbowman
#name "Orionde Crossbowman"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5562
#end

#newmonster 7563
#copystats 3324 -- Orionde Warrior
#copyspr 3324
#name "Orionde Warrior"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3324
#gcost 0
#end

#selectmonster 3324 -- Orionde Warrior
#name "Orionde Warrior"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5563
#end

#newmonster 7564
#copystats 3325 -- Orionde Knight
#copyspr 3325
#name "Orionde Knight"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. The nobles and knights of the land spend their time honing their skills or hunting half-men in the forests. A noble that can't display at least one satyr at his dining table is likely ridiculed by his peers. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3325
#gcost 0
#end

#selectmonster 3325 -- Orionde Knight
#name "Orionde Knight"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is Great Orionde, a forest kingdom ruled by noble men who have tamed the wild forests and their inhabitants. Great Orionde is a subservient kingdom allowed to keep their hereditary kings and there is no Viceroy of Ind to rule the land. In service to the Prester King Great Orionde fields great armies of knights and crossbowmen. The nobles and knights of the land spend their time honing their skills or hunting half-men in the forests. A noble that can't display at least one satyr at his dining table is likely ridiculed by his peers. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5564
#end

#newmonster 7565
#copystats 3359 -- Lady Archer
#copyspr 3359
#name "Lady Archer"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Archer Priests of Ind, the Lady Archers of the Queendom are second only to the centaurs of Great Orionde in skill with the bow. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#foreignshape 3359
#gcost 0
#end

#selectmonster 3359 -- Lady Archer
#name "Lady Archer"
#descr "The Magnificent Kingdom of Ind has many subservient lands. Among them is the Great Feminie, a land ruled by a group of Queens and their Lady Warriors. Women hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. Even though they are less righteous than the Archer Priests of Ind, the Lady Archers of the Queendom are second only to the centaurs of Great Orionde in skill with the bow. While in their home province, they are supported by their own partly autonomous kingdom and cost no upkeep to Ind as a result."
#homeshape 5565
#end

#selectmonster 2184 -- Enkidu Slave (Hinnom)
#hp 33
#gcost 11
#end

#selectmonster 722 -- Warrior
#spr1 "./Hellenika/NokWarrior.tga"
#spr2 "./Hellenika/NokWarrior2.tga"
#name "Nok Warrior"
#descr "The warriors of the Nok armies use spears, hide shields and unsophisticated ranged weapons such as javelins and slings. Most wear heavy, crude armor made of leather, wood and bone, often adorned with feathers. Feather plumed helmets are worn by more prominent fighters, but all the born citizens of Nok wear a mystical mask which protects their heart from demons and their bodies for malign magic; the Nok never remove their mask even when threatened, for they know that doing so would cause their soul to be lost. Since the development of copperworking, some warriors have donned copper scale armor."
#mr 18
#nametype 126
#cleararmor
#armor 104
#armor 105
#armor 804
#end

#selectmonster 723 -- Warrior
#spr1 "./Hellenika/NokWarriorJavelin.tga"
#spr2 "./Hellenika/NokWarriorJavelin2.tga"
#name "Nok Warrior"
#descr "The warriors of the Nok armies use spears, hide shields and unsophisticated ranged weapons such as javelins and slings. Most wear heavy, crude armor made of leather, wood and bone, often adorned with feathers. Feather plumed helmets are worn by more prominent fighters, but all the born citizens of Nok wear a mystical mask which protects their heart from demons and their bodies for malign magic; the Nok never remove their mask even when threatened, for they know that doing so would cause their soul to be lost. Since the development of copperworking, some warriors have donned copper scale armor."
#mr 18
#nametype 126
#cleararmor
#armor 104
#armor 105
#armor 804
#end

#selectmonster 724 -- Warrior
#spr1 "./Hellenika/NokWarriorMace.tga"
#spr2 "./Hellenika/NokWarriorMace2.tga"
#name "Nok Warrior"
#descr "The warriors of the Nok armies use spears, hide shields and unsophisticated ranged weapons such as javelins and slings. Most wear heavy, crude armor made of leather, wood and bone, often adorned with feathers. Feather plumed helmets are worn by more prominent fighters, but all the born citizens of Nok wear a mystical mask which protects their heart from demons and their bodies for malign magic; the Nok never remove their mask even when threatened, for they know that doing so would cause their soul to be lost. Since the development of copperworking, some warriors have donned copper scale armor."
#mr 18
#nametype 126
#cleararmor
#armor 106
#armor 105
#armor 804
#end

#selectmonster 725 -- Sun Warrior
#spr1 "./Hellenika/NokSunWarrior.tga"
#spr2 "./Hellenika/NokSunWarrior2.tga"
#name "Sun Warrior"
#descr "The Sun Warriors are the elite guard that defends the Nok temples. They have the right to take what they want from the lower citizens, so they only require symbolic pay from the Empire. Their armor is reinforced with small copper plates and they wield copper hatchets. They are sacred and can be blessed."
#mr 18
#gcost 5
#nametype 126
#cleararmor
#armor 106
#armor 105
#armor 809
#end

#selectmonster 726 -- Eagle Warrior
#spr1 "./Hellenika/NokEagleWarrior.tga"
#spr2 "./Hellenika/NokEagleWarrior2.tga"
#name "Eagle Warrior"
#descr "Eagle Warriors are sacred warriors who don feather cloaks. They wield spears and daggers, but wear no armor apart from their precious mask. When blessed, the sacred cloaks give the Eagle Warriors the ability to fly. The blessing of flight is useful in battle, but does not last long enough to allow the Eagle Warriors to fly between provinces. Due to their masters the Sky Priests' status being taboo, the Eagle Warriors are trained to live in autarky without the help of society and therefore require very little pay."
#mr 18
#str 11
#gcost 5
#nametype 126
#cleararmor
#armor 44
#armor 804
#clearweapons
#weapon 708
#weapon 671
#end

#selectmonster 727 -- Jaguar Warrior
#spr1 "./Hellenika/NokJaguarWarriorC.tga"
#spr2 "./Hellenika/NokJaguarWarC2.tga"
#name "Leopard Warrior"
#descr "Also known as the Mforoekpe, the sacred Leopard Warriors are dreaded by all of Nok's neighbouring populations. They don a leopard hide before battle and then waylay their human preys with great clubs of wood that have been fitted with leopard claws and teeths to give them a sharp fang-like edge in the form of their totem-animal's cruel maw. After the battle, the victims' flesh is then cut from their bodies and distributed to the Leopard Warriors for them to consume it in ritual cannibalism, thus gaining their strength for themselves and the entire tribe. As a result of these esoteric practices, the Leopard Warriors have acquired supernatural abilities; when one of them is wounded, the blood from his wounds will cause his sacred leopard hide to merge with his body. This merging results in a fearsome were-leopard. When transformed, the Leopard Warrior drops his saw-blade but the protective power of his mask remains."
#mr 18
#nametype 126
#cleararmor
#armor 44
#armor 804
#clearweapons
#weapon 1222
#end

#selectmonster 728 -- Were Jaguar
#spr1 "./Hellenika/Sturmwere_jag_idleNBG.tga"
#spr2 "./Hellenika/Sturmwere_jag_attackNBG.tga"
#name "Were Leopard"
#descr "A were-leopard is a transformed Leopard Warrior: Half beast, half man. Were-leopards are sacred."
#mr 18
#nametype 126
#end

#selectmonster 859 -- Jaguar (summon)
#name "Leopard"
#descr "The leopard is a great cat of the Nok forest. It is said that the Smoking Mirror, Lord of the Night Sky, sometimes disguises himself as a leopard."
#nametype 126
#end

#selectmonster 860 -- Feathered Warrior
#spr1 "./Hellenika/NokFeatherWarrior.tga"
#spr2 "./Hellenika/NokFeatherWarrior2.tga"
#name "Feathered Warrior"
#descr "Prominent Nok warriors are given helmets with great feather plumes, a headdress which they put over their mask and which can be easily recognized by friendly troops and fills their hearts with extreme zeal. The morale of nearby troops will be bolstered by the presence of a Feathered Warrior."
#mr 18
#mor 16
#gcost 18
#nametype 126
#cleararmor
#armor 106
#armor 105
#armor 804
#end

#selectmonster 1882 -- Moon Warrior
#spr1 "./Hellenika/NokMoonWarrior.tga"
#spr2 "./Hellenika/NokMoonWarrior2.tga"
#name "Moon Warrior"
#descr "There are two faces of God in the Mictlan worship: The Dream Face of the Moon and the Watchful and Angry Face of the Sun. There are two orders of elite warriors corresponding to the two Faces. Moon Warriors are elite warriors who fight in the manner of the Moon, armed with great axes of obsidian, a material of the night. They are blessed by the Moon and are almost considered sacred. Their blessed status has granted them night vision and the protection of the fates."
#curseluckshield 1
#mr 18
#nametype 126
#cleararmor
#armor 106
#armor 809
#end

#selectmonster 721 -- Warrior
#spr1 "./Hellenika/NokBasicWarrior1.tga"
#spr2 "./Hellenika/NokBasicWarrior2.tga"
#name "Nok Warrior"
#descr "The warriors of the Nok armies use spears, hide shields and unsophisticated ranged weapons such as javelins and slings. Most wear heavy, crude armor made of leather, wood and bone, often adorned with feathers. Feather plumed helmets are worn by more prominent fighters, but all the born citizens of Nok wear a mystical mask which protects their heart from demons and their bodies for malign magic; the Nok never remove their mask even when threatened, for they know that doing so would cause their soul to be lost. Since the development of copperworking, some warriors have donned copper scale armor."
#mr 18
#nametype 126
#armor 804
#end

#newmonster 7352
#spr1 "./Hellenika/NokBasicWarrior1.tga"
#spr2 "./Hellenika/NokBasicWarrior2.tga"
#name "Nok Warrior"
#descr "The warriors of the Nok armies use spears, hide shields and unsophisticated ranged weapons such as javelins and slings. Most wear heavy, crude armor made of leather, wood and bone, often adorned with feathers. Feather plumed helmets are worn by more prominent fighters, but all the born citizens of Nok wear a mystical mask which protects their heart from demons and their bodies for malign magic; the Nok never remove their mask even when threatened, for they know that doing so would cause their soul to be lost. Since the development of copperworking, some warriors have donned copper scale armor."
#weapon 373
#weapon 22
#armor 105
#armor 804
#forestsurvival
#ap 12
#mapmove 14
#gcost 9
#rcost 1
#rpcost 10000
#mr 18
#nametype 126
#end

#selectmonster 1610 -- Jaguar Tribe Slinger
#spr1 "./Hellenika/NokJaguarTribe1.tga"
#spr2 "./Hellenika/NokJaguarTribe2.tga"
#name "Leopard Tribe Slinger"
#descr "Tribal peoples of the wild follow their priests and totemic spirits. The slingers of the Leopard Tribes don't use armor."
#nametype 126
#end

#selectmonster 1611 -- Jaguar Tribe Warrior
#spr1 "./Hellenika/NokJaguarTribeWarrior1.tga"
#spr2 "./Hellenika/NokJaguarTribeWarrior2.tga"
#name "Leopard Tribe Warrior"
#descr "Tribal peoples of the wild follow their priests and totemic spirits. The warriors of the Leopard Tribes are skilled in forest survival. They fight with obsidian axes and slings and wear armor made of cloth, wood, stones and feathers."
#nametype 126
#end

#selectmonster 2860 -- Soldier of the Deep
#name "Soldier of the Deep"
#descr "Soldiers of the Deep are martial initiates of a cult of the deep. They serve and protect the temples and the Witnesses of the Deep, preparing for the Atlantian conquest of the world. Soldiers of the Deep are taught the secrets of waterbreathing and are given coral spears as a sign of their devotion. They do not use shields, as this would be awkward when entering the promised land beneath the waves. They are devoted to the Atlantian cause and are often regarded as fanatics, a truth made all the more evident by the fact that they serve their masters out of free will rather than for any pay; because of this, they make for exceptionally cheap combatants and cost no upkeep."
#addupkeep -10
#end

#selectmonster 2030 -- Rephaite Warrior
#hp 63
#end

#selectmonster 2035 -- Avvite Charioteer
#hp 36
#gcost 75
#end

#selectmonster 2015 -- Avvite Spearman
#hp 36
#gcost 25
#end

#selectmonster 2018 -- Horite
#hp 38
#gcost 20
#end

#selectmonster 2019 -- Horite Champion
#hp 41
#gcost 25
#end

#selectmonster 2021 -- Avvite Light Infantry
#hp 36
#gcost 25
#end

#selectmonster 2022 -- Avvite Swordsman
#hp 36
#gcost 25
#end

#selectmonster 2034 -- Horite Hunter
#hp 39
#gcost 23
#end

#selectmonster 2036 -- Avvite Horn Blower
#hp 36
#gcost 35
#end

#selectmonster 2037 -- Dawn Guard
#hp 38
#gcost 40
#end

#selectmonster 2059 -- Avvite Heavy Archer
#hp 36
#gcost 25
#end

#selectmonster 1796 -- Fomorian Militia
#hp 45
#gcost 15
#weapon 331
#end

#selectmonster 1797 -- Fomorian Javelinist
#hp 45
#gcost 20
#weapon 331
#end

#selectmonster 1798 -- Fomorian Spearman
#hp 45
#gcost 20
#weapon 331
#end

#selectmonster 1799 -- Fomorian Warrior
#hp 50
#gcost 30
#weapon 331
#end

#selectmonster 1801 -- Fomorian Giant
#hp 96
#gcost 75
#end

#newmonster 7475
#copyspr 1801
#copystats 1801
#reclimit 1
#end

#selectmonster 1817 -- Unmarked
#hp 53
#gcost 55
#weapon 331
#end

#newmonster 7477
#copystats 1817
#copyspr 1817
#reclimit 1
#end

#selectmonster 1245 -- Aka-Oni Samurai
#name "Samurai"
#descr "In the ancient times, the samurai were the noblest warriors of Jomon's feudal society, loyal followers of the rebel warlords who fought T'ien Ch'i for so long to escape its domination. Despite their zeal and ferocity, they were eventually defeated and after most were executed their traditions were nearly lost. Yet this fate was not to come to pass. Indeed, legend says that some time after Jomon's subjugation the Imperial City was once threatened by a massive army of demons. The besieging forces summoned Red Devils to break down the walls and ravage the city. In this time, the Jomonese were only slaves and seen as worthless, but a company of samurai led by Hashi Saburo came out of hiding and painted their armors red. They snuck out during the night and butchered the sorcerers summoning the devils. The besieging forces thought that the devils had turned on their masters and were swiftly routed. The cavalry of the city was released and the besieging army was butchered to the last man. After this feat, the subjugated people of Jomon became respected for its warriors, honor and determination. Hashi's company took the name of the Red Devils and under their tutelage, no longer forbidden and hunted down, the samurai traditions were reborn. Ever since, all samurai paint their armor red and claim some lineage to this legend, such that the martial elites of Jomon may be treated as noble vassals of the Celestial Bureaucracy rather than nationalistic rebels. They are among the most well known and feared of the Jomonese special forces at T'ien Ch'i's disposal."
#mor 18
#mr 14
#att 18
#str 13
#hp 12
#reclimit 3
#monpresentrec 1258
#end

#selectmonster 1238 -- Ashigaru
#name "Ashigaru"
#descr "Ashigaru are light infantry levied from the peasant population of Jomonese minorities. They are armed with long two-handed spears and don light scale armor and war hats. The hats are made of iron and used to cook rice when not worn."
#gcost 5
#monpresentrec 1258
#end

#selectmonster 1270 -- Ronin
#gcost 15
#reclimit 1
#str 13
#def 13
#att 18
#mr 14
#mor 18
#rpcost 1
#rcost -7
#monpresentrec 1258
#end

#selectmonster 2827 -- Therodian Archer
#name "Therodian Archer"
#descr "In the rich lands of ancient Therodos most soldiers were given iron armor, but a few peltasts and archers would often accompany the hoplites. Today, due to the scarcity of resources, the use of archers is more common. Like most living human soldiers of Therodos, they willingly serve the Telkhine Spectre out of fear and respect without daring to ask for any more pay than necessary for their survival, but they still require resources and supplies."
#gcost 1
#rpcost 9
#end

#selectmonster 2828 -- Therodian Peltast
#name "Therodian Peltast"
#descr "Peltasts are light Therodian infantry armed with javelins and spears, recruited in new-founded Therodian colonies. In the rich lands of ancient Therodos most soldiers were given iron armor, but a few peltasts and archers would often accompany the hoplites. Today, due to the scarcity of resources, the use of peltasts is more common. Like most living human soldiers of Therodos, they willingly serve the Telkhine Spectre out of fear and respect without daring to ask for any more pay than necessary for their survival, but they still require resources and supplies."
#gcost 1
#rpcost 9
#end

#selectmonster 2829 -- Therodian Hoplite
#name "Therodian Hoplite"
#descr "The armies of ancient Therodos were vastly superior to their neighbors. Well-drilled hoplites clad in Telkhine iron conquered all lands that the God-kings would covet. When the Telkhine kingdom was shattered and drowned the skills of metalcrafting were kept by the Kaberoi guilds. Now, with the reemergence of Therodos, Kaberoi guilds once more make armors of plate for the soldiers of the kingdom. Therodian hoplites are living human soldiers recruited in newly-founded Therodian colonies. They have armaments superior to most nations, but their skills are average at best and they are not as skilled formation fighters as their predecessors. Like most living human soldiers of Therodos, they willingly serve the Telkhine Spectre out of fear and respect without daring to ask for any more pay than necessary for their survival, but they still require resources and supplies."
#gcost 1
#rpcost 9
#end

#selectmonster 1690 -- Living Pillar
#name "Living Pillar"
#descr "The Living Pillars are sacred guardians of the Basalt City. They are equipped with turtle-shell shields, enchanted basalt spears and incredibly heavy basalt armor enchanted by the Basalt Kings. The Living Pillars stand guard at the five gates of the city and could easily be mistaken for statues, were it not for their glowing antennae. The Living Pillars are rarely seen outside the city and when they are, they are most likely accompanying a Basalt King or Queen, who they guard with inhuman vigilance and discipline. Ever unsleeping, Living Pillars indeed are the most tireless bodyguards in the world and can counter any assassin's patience, an eerie feat which they achieve by being mentally attuned to crystal shards worn by their commanders."
#gcost 35
#fear 5
#hp 46
#castledef 10
#bodyguard 10
#voidsanity 5
#end

#selectmonster 1682 -- Reef Dweller
#name "Reef Dweller"
#descr "Reef dwellers are pale green Atlantians of shallow waters. They live on coral reefs and across the centuries have developed coral crafting to make weapons and armor, little by little settling near coastal provinces under the intrigued eyes of the Tritons. Now, with the Fall of the Star, most of them have fled Iapeto to found the young nation of Atlantis near the shores, so Reef Dwellers are often seen with suspicion in the Basalt City - yet, they are particularly important in quelling the rebellion, as they know more about it than the children of the dark usually do. Reef dwellers can be recruited in coastal castles."
#end

#selectmonster 206 -- Shambler (Atlantis & indie)
#hp 33
#gcost 20
#end

#selectmonster 208 -- War Shambler (Atlantis)
#hp 34
#gcost 25
#end

#selectmonster 209 -- Mother Guard
#gcost 40
#hp 38
#end

#selectmonster 2862 -- Shambler Guard (Atlantis)
#hp 33
#gcost 22
#end

#selectmonster 1683 -- Shambler (Iapeto)
#hp 33
#gcost 20
#end

#selectmonster 1684 -- War Shambler (Iapeto)
#hp 33
#gcost 25
#end

#selectmonster 1685 -- Coral Guard (Iapeto)
#hp 36
#gcost 30
#end

#selectmonster 1688 -- Shambler of the Deep
#gcost 20
#hp 39
#end

#selectmonster 1689 -- Warrior of the Deep
#hp 41
#gcost 25
#end

#selectmonster 1105 -- Triarius
#att 14
#def 13
#mor 14
#end

#selectmonster 1657 -- Longdead Triarius
#att 14
#def 10
#end

#selectmonster 668 -- Sceleria Standard
#woundfend 1
#mor 11
#att 11
#def 11
#invulnerable 15
#end

#selectmonster 662 -- Sceleria Velite
#woundfend 1
#mor 11
#att 11
#def 11
#invulnerable 15
#end

#selectmonster 663 -- Sceleria Legionnaire
#woundfend 1
#mor 11
#att 11
#def 11
#invulnerable 15
#end

#selectmonster 664 -- Sceleria Hastatus
#woundfend 1
#mor 12
#att 11
#def 11
#invulnerable 15
#end

#selectmonster 665 -- Sceleria Principe
#woundfend 1
#mor 13
#att 12
#def 12
#invulnerable 15
#end

#selectmonster 666 -- Sceleria Triarius
#woundfend 1
#mor 15
#att 15
#def 14
#invulnerable 15
#end

#selectmonster 689 -- Pythium Standard
#woundfend 1
#mor 12
#att 12
#def 12
#mr 12
#end

#selectmonster 684 -- Pythium Velite
#woundfend 1
#mor 12
#att 12
#def 12
#mr 12
#end

#selectmonster 685 -- Pythium Legionnaire
#woundfend 1
#mor 12
#att 12
#def 12
#mr 12
#end

#selectmonster 686 -- Pythium Hastatus
#woundfend 1
#mor 13
#att 12
#def 12
#mr 12
#end

#selectmonster 687 -- Pythium Principe
#woundfend 1
#mor 14
#att 13
#def 13
#mr 12
#end

#selectmonster 688 -- Pythium Triarius
#woundfend 1
#mor 16
#att 16
#def 15
#mr 12
#end

#selectmonster 1152 -- Axe Warrior (Ulm)
#gcost 0
#mor 10
#skirmisher 3
#rpcost 6
#rcost 5
#end

#selectmonster 1153 -- Warrior (Ulm)
#gcost 0
#mor 10
#skirmisher 3
#rcost -3
#rpcost 13
#end

#selectmonster 1162 -- Archer (Ulm)
#gcost 0
#mor 10
#skirmisher 3
#rpcost 5
#rcost 3
#end

#selectmonster 1154 -- Forest Warrior (Ulm)
#gcost 0
#mor 11
#skirmisher 3
#rpcost 14
#rcost 1
#hp 14
#att 12
#mor 15
#mapmove 18
#end

#selectmonster 1155 -- Mountain Warrior (Ulm)
#gcost 0
#mor 11
#skirmisher 3
#rpcost 14
#rcost 1
#hp 14
#att 12
#mor 15
#mapmove 18
#end

#selectmonster 1156 -- Iron Warrior (Ulm)
#gcost 0
#berserk 5
#skirmisher 3
#rpcost 22
#rcost 4
#mor 15
#hp 16
#reinvigoration 2
#end

#selectmonster 1163 -- Warrior Maiden (Ulm)
#gcost 0
#mor 11
#enc 2
#prec 14
#pillagebonus 2
#berserk 3
#skirmisher 3
#rpcost 17
#rcost 4
#end

#selectmonster 1164 -- Steel Maiden (Ulm)
#gcost 0
#mor 12
#def 14
#berserk 3
#skirmisher 3
#rpcost 22
#rcost 4
#end

#selectmonster 1165 -- Shield Maiden (Ulm)
#gcost 0
#mor 12
#berserk 3
#skirmisher 3
#rpcost 20
#rcost 4
#end

#selectmonster 1157 -- Steel Warrior (Ulm)
#gcost 27
#rpcost 31
#rcost 1
#mor 18
#mr 18
#hp 16
#haltheretic 1
#skirmisher 3
#clearweapons
#weapon 469 -- Ancestor Sword
#end

#selectmonster 1808 -- Iron Boar
#mr 8
#end

#selectmonster 3283 -- Archer Priest (Ind)
#gcost 11
#rpcost 6
#end

#selectmonster 2963 -- Mushussu Chariot
#name "Mushussu Chariot"
#descr "Since the founding of the Great Temple of the Moon old traditions have become less prominent. The old faith revering the forces of nature is all but forgotten. Not even the Mushussus are considered sacred anymore. But the dragon-kin have always been used in warfare, and regardless of the loss of their sacred status they are still formidable beasts of war blessed with spring immortality. Now they are trained to pull chariots and obey their Enkidu charioteers. Each Mushussu is cared for by a retinue of trainers and caretakers; as such, while in its home province it won't cost any upkeep, and if the charioteer is killed in battle a new one will replace them after the battle."
#hp 28
#gcost 200
#addupkeep -200
#immortal
#springimmortal
#foreignshape 5443
#heal
#end

#selectmonster 2964 -- Mushussu
#name "Mushussu Chariot"
#descr "Since the founding of the Great Temple of the Moon old traditions have become less prominent. The old faith revering the forces of nature is all but forgotten. Not even the Mushussus are considered sacred anymore. But the dragon-kin have always been used in warfare, and regardless of the loss of their sacred status they are still formidable beasts of war blessed with spring immortality. Now they are trained to pull chariots and obey their Enkidu charioteers. Each Mushussu is cared for by a retinue of skilled trainers and caretakers; as such, while in its home province it won't cost any upkeep, and if the charioteer is killed in battle a new one will replace them after the battle."
#addupkeep -200
#immortal
#springimmortal
#clearweapons
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#foreignshape 5444
#heal
#end

#newmonster 7443
#copyspr 2963
#copystats 2963 -- Mushussu Chariot
#name "Mushussu Chariot"
#descr "Since the founding of the Great Temple of the Moon old traditions have become less prominent. The old faith revering the forces of nature is all but forgotten. Not even the Mushussus are considered sacred anymore. But the dragon-kin have always been used in warfare, and regardless of the loss of their sacred status they are still formidable beasts of war blessed with spring immortality. Now they are trained to pull chariots and obey their Enkidu charioteers. Each Mushussu is cared for by a retinue of trainers and caretakers; as such, while in its home province it won't cost any upkeep, and if the charioteer is killed in battle a new one will replace them after the battle."
#hp 28
#gcost 200
#addupkeep 0
#immortal
#springimmortal
#homeshape 2963
#heal
#end

#newmonster 7444
#copyspr 2964
#copystats 2964 -- Mushussu
#name "Mushussu Chariot"
#descr "Since the founding of the Great Temple of the Moon old traditions have become less prominent. The old faith revering the forces of nature is all but forgotten. Not even the Mushussus are considered sacred anymore. But the dragon-kin have always been used in warfare, and regardless of the loss of their sacred status they are still formidable beasts of war blessed with spring immortality. Now they are trained to pull chariots and obey their Enkidu charioteers. Each Mushussu is cared for by a retinue of skilled trainers and caretakers; as such, while in its home province it won't cost any upkeep, and if the charioteer is killed in battle a new one will replace them after the battle."
#addupkeep 0
#immortal
#springimmortal
#clearweapons
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#homeshape 2964
#heal
#end

#newmonster 7439
#copystats 2963
#spr1 "./Hellenika/AkkadChariot1a.tga"
#spr2 "./Hellenika/AkkadChariot2a.tga"
#name "Guild Chariot"
#descr "The City of Guilds is the largest Akkadian City State after the City of Gods. Over time, it has grown to be a powerful rival to the capital, but now that they were joined by the Awakening God they may wage war and prosper under the same banner. Like its ancestral competitor, the City of Guilds has secured the ability to breed, train and equip mighty Mushussu Chariots for warfare. The City of Guilds prefers using iron and steel rather than bronze to arm its charioteers. Like the recruits of all City States, they may only be hired under the command of a great Enkidu King or Ensi."
#secondshape 5440
#cleararmor
#armor 9
#monpresentrec -4168
#foreignshape 5441
#heal
#end

#newmonster 7440
#copystats 2964
#spr1 "./Hellenika/AkkadChariot1b.tga"
#spr2 "./Hellenika/AkkadChariot2b.tga"
#name "Guild Chariot"
#descr "The City of Guilds is the largest Akkadian City State after the City of Gods. Over time, it has grown to be a powerful rival to the capital, but now that they were joined by the Awakening God they may wage war and prosper under the same banner. Like its ancestral competitor, the City of Guilds has secured the ability to breed, train and equip mighty Mushussu Chariots for warfare. The City of Guilds prefers using iron and steel rather than bronze to arm its charioteers. Like the recruits of all City States, they may only be hired under the command of a great Enkidu King or Ensi."
#firstshape 5439
#foreignshape 5442
#heal
#end

#newmonster 7441
#copystats 2963
#spr1 "./Hellenika/AkkadChariot1a.tga"
#spr2 "./Hellenika/AkkadChariot2a.tga"
#name "Guild Chariot"
#descr "The City of Guilds is the largest Akkadian City State after the City of Gods. Over time, it has grown to be a powerful rival to the capital, but now that they were joined by the Awakening God they may wage war and prosper under the same banner. Like its ancestral competitor, the City of Guilds has secured the ability to breed, train and equip mighty Mushussu Chariots for warfare. The City of Guilds prefers using iron and steel rather than bronze to arm its charioteers. Like the recruits of all City States, they may only be hired under the command of a great Enkidu King or Ensi."
#secondshape 5440
#cleararmor
#armor 9
#monpresentrec -4168
#homeshape 5439
#addupkeep 0
#heal
#end

#newmonster 7442
#copystats 2964
#spr1 "./Hellenika/AkkadChariot1b.tga"
#spr2 "./Hellenika/AkkadChariot2b.tga"
#name "Guild Chariot"
#descr "The City of Guilds is the largest Akkadian City State after the City of Gods. Over time, it has grown to be a powerful rival to the capital, but now that they were joined by the Awakening God they may wage war and prosper under the same banner. Like its ancestral competitor, the City of Guilds has secured the ability to breed, train and equip mighty Mushussu Chariots for warfare. The City of Guilds prefers using iron and steel rather than bronze to arm its charioteers. Like the recruits of all City States, they may only be hired under the command of a great Enkidu King or Ensi."
#firstshape 5439
#homeshape 5440
#addupkeep 0
#heal
#end

#selectmonster 2953 -- Maiden of the Moon
#name "Maiden of the Moon"
#descr "With the transfer of religious power from the First City to the City of Gods, the sacred warriors and priests of old lost their influence in all Enkidy cities save for Eridu. Fewer and fewer Enkidus were sent to the Primordial City to be trained as Enki's Chosen. The end of the old order came when the Entu of the Moon, prophetess of the Awakening God, founded a new military order in honor of the Moon. Since the priesthood of the Moon was a predominantly female institution, so too would the new order be. Partly as a political move to avoid dependence on the Ensis and the wealthy, the Order of the Moon is comprised entirely of orphan girls and infants given to the temple by mothers unable to care for their daughters. Trained from an early age, they are taught to rely on each other and are drilled to fight with unwavering loyalty in close formations. The Maidens of the Moon are traditionally equipped with bronze for religious reasons."
#userestricteditem 8069
#twiceborn 6675
#hp 31
#gcost 27
#end

#selectmonster 2940 -- Enkidu Iron Warrior
#gcost 22
#hp 39
#end

#selectmonster 2941 -- Enkidu Royal Guard
#name "Enkidu Royal Guard"
#descr "During the time of strife, when new cities rose to power in competition with the First City, the self-proclaimed Ensis gathered their best warriors to protect themselves. These royal guards were not tasked with the city defence like the Ur-Guards of Eridu, but rather with the protection of the person of the Ensi. With the unification of Akkad's City States and the return of a fragile peace with Eridu, there is less need for royal bodyguards, but suspicion and old traditions are slow to die."
#gcost 20
#hp 39
#end

#selectmonster 2939 -- Enkidu Soldier
#name "Enkidu Soldier"
#descr "When the kingdom of Ur was divided and the city states of Akkad emerged much changed. The City of Trade made contact with other kingdoms and new trade routes were established. Iron-working and other foreign technologies became available to the Enkidus. Now all Ensis have equipped their troops with iron armaments."
#hp 36
#gcost 16
#end

#selectmonster 2938 -- Enkidu Heavy Archer
#name "Enkidu Heavy Archer"
#descr "When the kingdom of Ur was divided and the city states of Akkad emerged much changed. The City of Trade made contact with other kingdoms and new trade routes were established. Iron-working and other foreign technologies became available to the Enkidus. Now all Ensis have equipped their troops with iron armaments."
#hp 36
#gcost 16
#end

#selectmonster 2937 -- Enkidu Warrior
#hp 39
#gcost 16
#end

#selectmonster 2936 -- Enkidu Spearman
#name "Enkidu Spearman"
#descr "When the kingdom of Ur was divided and the city states of Akkad emerged much changed. The City of Trade made contact with other kingdoms and new trade routes were established. Iron-working and other foreign technologies became available to the Enkidus. Now all Ensis have equipped their troops with iron armaments."
#hp 36
#gcost 16
#end

#selectmonster 2935 -- Enkidu Archer
#name "Enkidu Archer"
#descr "When the kingdom of Ur was divided and the city states of Akkad emerged much changed. The City of Trade made contact with other kingdoms and new trade routes were established. Iron-working and other foreign technologies became available to the Enkidus. Now all Ensis have equipped their troops with iron armaments."
#hp 36
#gcost 16
#end

#selectmonster 3089 -- Kulullu
#name "Kulullu"
#descr "The Kulullus are an ancient race of strange beings whose bodies resemble a combination of Enkidu and fish. The Kulullus have lived in the seas near Ur since before the First City was founded and they claim to have founded the first of the kingdoms underneath the waves. Some sages even believe that when U'an the Apkallu emerged from the sea to bring civilization to Ur he had already brought his gifts to the Kulullus. But war and strife brought by less peaceful beings almost destroyed the Kulullu kingdom. Kulullu myths claim that an apostle of U'an will one day arrive from dry land to rebuild the old Kulullu kingdom."
#hp 42
#gcost 18
#end

#selectmonster 3090 -- Kulullu Soldier
#hp 42
#gcost 18
#end

#newmonster 7715
#copystats 3090 -- Kulullu Soldier
#spr1 "Hellenika/KululluCataphract1.tga"
#spr2 "Hellenika/KululluCataphract2.tga"
#name "Kulullu Cataphract"
#descr "When the apostles of U'an came to the broken Kulullu kingdom they were celebrated as saviors. For centuries the Kulullus had weathered constant attacks from Atlantians, Tritons and the wild beings of the kelp forests, and the gifts of U'an were almost lost. With the newly formed alliance with the Enkidus the Kulullus are gathering their forces and the ancient kingdom is mustering. Kulullu cataphracts are the elites of their armies and wear heavy bronze scale bardings fit for their unique body shape."
#clearweapons
#weapon 651
#cleararmor
#armor 811
#armor 2
#hp 44
#gcost 25
#att 11
#mor 11
#end

#newmonster 7111
#spr1 "Hellenika/EnkiduDemolisher1.tga"
#spr2 "Hellenika/EnkiduDemolisher2.tga"
#name "Enkidu Demolisher"
#descr "Since the First War against the Avvim and their unholy lords, the doctrine of the One and Only City has been placed at the center of Eridu's preoccupations. Sure, with the betrayal and growth of Akkad, dangers have multiplied in Eridu's surroundings; and so, it hasn't always been possible to apply this doctrine. Too often are the lesser cities tolerated in the name of compromise and survival, too often are they allowed to prosper as a result of Ur's pressing needs for allies and of its attempts to restore the Enkidus' unity. But it remains that at the very heart of the Primordial City's strategy is the ultimate goal of shattering the foundations of all its rivals and epigones and of reinstating the original balance of nature and civilization once and for all. Thus, little by little, the armies of Eridu succeed in securing more territory both militarily and diplomatically; and, one by one, the cities it captures eventually are razed following the Dawn Warrior's holy doctrine; for such is the will of the Royal Couple, and such is necessary to revive the Enkidus' trust in ever-nascent civilization. Led by Ur's generals and kings, the Enkidu Demolishers are the primary executioners of this great mission. Although most are barely civilized at all and by no means educated in religious science, they take great pride in their abilities for sheer destruction. While not the most dextrous or enduring of the Enkidu soldiers, they are the strongest by far and wield terrifyingly large and heavy bronze mauls called Wall Smashers. With these seemingly primitive yet very studied armaments, they are able to shatter even the toughest stones and will be the first to change into rubble the strongholds of Eridu's enemies."
#gcost 19
#rpcost 5
#rcost -5
#hp 39
#size 3
#prot 2
#mr 11
#mor 11
#str 17
#att 10
#def 8
#prec 10
#ap 14
#mapmove 18
#enc 4
#maxage 50
#weapon 1208
#armor 142
#nametype 151
#siegebonus 5
#end

#selectmonster 2162 -- Enkidu
#name "Enkidu"
#descr "Enkidus are large, hairy wild men with horns and unkempt hair. They live and frolic with the beasts of the wilderness and have only a vague notion of the concept of civilization. Since the First War ages ago, a great traumatism has marked the Enkidu race, and to most civilization now means Avvite slavers. Some efforts have been made by the Royal Couple and its followers to change this, but only as far as could be done while preserving their people's trust and respecting the divine principles of balance taught by the Apkallu. As a result, not much has changed for Eridu in the last few millenia; but nonetheless, slowly increasing numbers of the wild men are adopting the ever-nascent ways of farming and metalworking. Still, most Enkidus live pastoral lives in small tribal groups."
#hp 36
#gcost 16
#end

#selectmonster 2163 -- Enkidu Archer
#name "Enkidu Archer"
#descr "Enkidus are large, hairy wild men with horns and unkempt hair. They live and frolic with the beasts of the wilderness and have only a vague notion of the concept of civilization. Since the First War ages ago, a great traumatism has marked the Enkidu race, and to most civilization now means Avvite slavers. Some efforts have been made by the Royal Couple and its followers to change this, but only as far as could be done while preserving their people's trust and respecting the divine principles of balance taught by the Apkallu. As a result, not much has changed for Eridu in the last few millenia; but nonetheless, slowly increasing numbers of the wild men are adopting the ever-nascent ways of farming and metalworking. Still, most Enkidus live pastoral lives in small tribal groups."
#hp 36
#gcost 16
#end

#selectmonster 2164 -- Enkidu Warrior
#hp 36
#gcost 16
#end

#selectmonster 2168 -- Enkidu Hunter
#hp 36
#gcost 16
#rpcost 5
#end

#selectmonster 2172 -- Enkidu Soldier (Hatchet)
#name "Enkidu Soldier"
#descr "Enkidus are large, hairy wild men with horns and unkempt hair. They live and frolic with the beasts of the wilderness and have only a vague notion of the concept of civilization. Since the First War ages ago, a great traumatism has marked the Enkidu race, and to most civilization now means Avvite slavers. Some efforts have been made by the Royal Couple and its followers to change this, but only as far as could be done while preserving their people's trust and respecting the divine principles of balance taught by the Apkallu. As a result, not much has changed for Eridu in the last few millenia; but nonetheless, slowly increasing numbers of the wild men are adopting the ever-nascent ways of farming and metalworking. Still, most Enkidus live pastoral lives in small tribal groups."
#rpcost 4
#rcost -3
#gcost 16
#hp 36
#end

#selectmonster 2175 -- Ur-Guard
#castledef 5
#name "Ur-Guard"
#descr "Since the founding of the Primordial City millenia ago, wealth has been accumulating and need has been found for organized defence. With the ever-nascent discovery of metalcrafting, it became possible to arm soldiers with modern weapons and armor. The Ur-Guards are elite soldiers entrusted with the defence of the capital."
#rpcost 7
#rcost -5
#gcost 19
#hp 39
#end

#selectmonster 2174 -- Enkidu Spear Guard
#name "Enkidu Spear Guard"
#descr "Since the founding of the Primordial City millenia ago, wealth has been accumulating and need has been found for organized defence. With the ever-nascent discovery of metalcrafting, it became possible to arm soldiers with modern weapons and armor. The Spear Guards are now the standard defensive force of the Cities of Ur."
#rpcost 4
#rcost -5
#gcost 16
#hp 36
#end

#selectmonster 2173 -- Enkidu Horn Blower
#rpcost 11
#rcost 0
#standard 2
#gcost 35
#hp 36
#end

#selectmonster 2176 -- Enki's Chosen
#name "Enki's Chosen"
#descr "In the center of the First City lies an enormous temple ground. At the heart of the vast compound lies The House of Water, the high temple to the Wise Principle of the Waters Underground. Here priests and sacred warriors are trained. The Chosen of Enki are the sacred guard of the temple and serve as personal guard of the Ensi Priest-Kings; as such, they may only be recruited in their presence. They are sometimes nicknamed the Destroyers of Demons because they wield enchanted and consecrated hatchets that can harm ethereal beings and prevent immortal foes from returning to life."
#rpcost 9
#rcost -7
#gcost 29
#hp 41
#monpresentrec -4168
#clearweapons
#weapon 1215
#end

#selectmonster 2183 -- Enkidu Reaver
#gcost 26
#hp 41
#rpcost 12
#end

#selectmonster 2164 -- Enkidu Warrior
#hp 36
#gcost 16
#end

#selectmonster 2165 -- Enkidu Warrior
#hp 36
#gcost 16
#end

#newmonster 7502 -- Mushussu
#copystats 2962
#copyspr 2962
#name "Mushussu"
#descr "The Mushussu is a wingless dragon of the swamps of Ur. It is a guardian being of the kingdom and is sacred to the Enkidus. It has a scaled body, the paws of a lion, the hindlegs of an eagle and a serpent tail. Shorter and tamer than the divine Sirrush, it may be recruited without the assistance of a temple or its attendants and doesn't cost upkeep while in the dominion of the deity it heralds. Some claim it is the most ancient of all dragon-kin, and like the phoenix it indeed seems to be blessed with eternal life, for if killed it regenerates with spring."
#rpcost 5
#gcost 175
#immortal
#springimmortal
#clearweapons
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#noreqtemple
#domshape 2962
#heal
#end

#selectmonster 2962 -- Mushussu
#name "Mushussu"
#descr "The Mushussu is a wingless dragon of the swamps of Ur. It is a guardian being of the kingdom and is sacred to the Enkidus. It has a scaled body, the paws of a lion, the hindlegs of an eagle and a serpent tail. Shorter and tamer than the divine Sirrush, it may be recruited without the assistance of a temple or its attendants and doesn't cost upkeep while in the dominion of the deity it heralds. Some claim it is the most ancient of all dragon-kin, and like the phoenix it indeed seems to be blessed with eternal life, for if killed it regenerates with spring."
#rpcost 5
#immortal
#springimmortal
#clearweapons
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#noreqtemple
#addupkeep -150
#notdomshape 5502
#heal
#end

#newmonster 7437 -- Sirrush
#spr1 "./Hellenika/Sirrush1.tga"
#spr2 "./Hellenika/Sirrush2.tga"
#name "Sirrush"
#descr "The elder Sirrush is a huge wingless dragon of the swamps of Ur, allegedly belonging to the first generation of the Mushussu, its progeny. The rarest and mightiest of the Mushussu, it is only found in the heartlands of Eridu, where the temple compounds are uniquely designed to care for it and for its upkeep. It radiates a divine aura that awes mortals and commands their faith; living symbol of the First City, it is a guardian being of the kingdom and is sacred to the Enkidus. It has a scaled body, the paws of a lion, the hindlegs of an eagle and a serpent tail. Some claim it is the most ancient of all dragon-kin, and like the phoenix it indeed seems to be blessed with eternal life, for if killed it regenerates with spring. Sadly, this noble creature has fallen prey to a mysterious disease and has been growing rarer through the centuries as a result; despite its immortality, some fear it might be heading towards extinction, and indeed the Swamps of Ur are the last place on Earth where it remains entirely unaffected by that plague. Sirrushes can only be recruited after one has willingly joined the nation, a feat that may be achieved through the divine coupling of Ur's rightful King and Queen using the Sandals of the Divine Soil and Flood."
#maxage 1000
#hp 102
#prot 17
#size 6
#mr 18
#mor 18
#str 23
#att 14
#def 11
#prec 10
#ap 18
#mapmove 20
#enc 3
#immortal
#springimmortal
#holy
#swampsurvival
--#magicbeing
#poormagicleader
#fear 15
#poisonres 15
#unsurr 1
#awe 1
#animalawe 5
#gcost 750
#addupkeep -750
#rpcost 200
#reclimit 1
#spreaddom 1
#heal
#rcost 1
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#foreignshape 5501
#quadruped
#berserk 5
#montag 4169
#ownsmonrec -4169
#homesick 10
#end

#newmonster 7501 -- Sirrush
#spr1 "./Hellenika/Sirrush1.tga"
#spr2 "./Hellenika/Sirrush2.tga"
#name "Sirrush"
#descr "The elder Sirrush is a huge wingless dragon of the swamps of Ur, allegedly belonging to the first generation of the Mushussu, its progeny. The rarest and mightiest of the Mushussu, it is only found in the heartlands of Eridu, where the temple compounds are uniquely designed to care for it and for its upkeep. It radiates a divine aura that awes mortals and commands their faith; living symbol of the First City, it is a guardian being of the kingdom and is sacred to the Enkidus. It has a scaled body, the paws of a lion, the hindlegs of an eagle and a serpent tail. Some claim it is the most ancient of all dragon-kin, and like the phoenix it indeed seems to be blessed with eternal life, for if killed it regenerates with spring. Sadly, this noble creature has fallen prey to a mysterious disease and has been growing rarer through the centuries as a result; despite its immortality, some fear it might be heading towards extinction, and indeed the Swamps of Ur are the last place on Earth where it remains entirely unaffected by that plague. Sirrushes can only be recruited after one has willingly joined the nation, a feat that may be achieved through the divine coupling of Ur's rightful King and Queen using the Sandals of the Divine Soil and Flood."
#maxage 1000
#hp 102
#prot 17
#size 6
#mr 18
#mor 18
#str 23
#att 14
#def 11
#prec 10
#ap 18
#mapmove 20
#enc 3
#immortal
#springimmortal
#holy
#swampsurvival
--#magicbeing
#poormagicleader
#fear 15
#poisonres 15
#unsurr 1
#awe 1
#animalawe 5
#gcost 750
#rpcost 100
#reclimit 1
#spreaddom 1
#heal
#rcost 1
#weapon 399
#weapon 29
#weapon 398
#weapon 631
#homeshape 5437
#quadruped
#berserk 5
#montag 4169
#ownsmonrec -4169
#homesick 10
#end

#selectmonster 1347 -- vanilla Sirrush, broken
#nowish
#end

#selectmonster 3363 -- Lion of Strange Color (Red)
#fireres 15
#end

#selectmonster 3364 -- Lion of Strange Color (Black)
#shockres 15
#end

#selectmonster 3365 -- Lion of Strange Color (Green)
#poisonres 15
#end

#selectmonster 3366 -- Lion of Strange Color (Blue)
#coldres 15
#end

#selectmonster 3320 -- Giant of the Lost Tribe
#name "Giant of the Lost Tribe"
#descr "In Magnificent Ind there is a wasteland inhabited by six-fingered giants with skin as pale as death. In ancient times these giants were immensely large and powerful enough to threaten the gods themselves. They are bound to their land by a divine decree, lest they overtake the world. Now they are lesser in stature and might, but the decree still holds and the Giants of the Lost Tribe cannot leave their home for an extended period of time. In exchange for their limited autonomy within the confines of their mystical prison, the Giants of the Lost Tribe have taken upon themselves to take care of their own and as a result cost no upkeep even when they risk their life to brave the law that binds them to their land."
#addupkeep -50
#hp 75
#gcost 50
#heal
#clearweapons
#weapon 1232
#weapon 331
#end

#selectmonster 3141 -- Cyclops Shepherd Shaman
#hp 60
#gcost 105
#end

#selectmonster 3135 -- Cyclops Chieftain
#hp 59
#gcost 60
#end

#selectmonster 3136 -- Cyclops Warrior
#hp 52
#gcost 35
#end

#selectmonster 3137 -- Cyclops Hurler
#hp 52
#gcost 35
#end

#newmonster 6501
#copystats 3137 -- Cyclops Hurler
#copyspr 3137
#name "Cyclops Hurler"
#descr "There are in Ind many strange men. Large men, small men, and men with eyes in the back. There are also Cyclopes living in Magnificent Ind. Called forth by the wise sages and Primate Kings, these giants can sometimes be seen in the armies of the Prester King. Additionally, if heathens are being mobilized in a cave province with at least five cyclopes of the same kind, an extra local cyclops of that type per month will join the armies of the Prester King for free in that province."
#gcost 0
#end

#selectmonster 3381 -- Cyclops (Ind)
#name "Cyclops"
#descr "There are in Ind many strange men. Large men, small men, and men with eyes in the back. There are also Cyclopes living in Magnificent Ind. Called forth by the wise sages and Primate Kings, these giants can sometimes be seen in the armies of the Prester King. Additionally, if heathens are being mobilized in a cave province with at least five cyclopes of the same kind, an extra local cyclops of that type per month will join the armies of the Prester King for free in that province."
#hp 52
#end

#selectmonster 1074 -- Wind Rider
#spr1 "Hellenika/WindRiderEx1strong.tga"
#spr2 "Hellenika/WindRiderEx2strong.tga"
#name "Wind Rider"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders, sacred warriors with masterwork bronze plate armor and heroic weapons. There are four kinds of Wind Rider, each wielding a masterwork lance with different properties. This particular type of Wind Rider is equipped with an exceptionally well balanced lance which is very effective against most foes."
#mr 14
#mor 14
#str 12
#att 13
#clearweapons
#weapon 1111
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#newmonster 6550
#spr1 "Hellenika/WindRiderEx1antigia.tga"
#spr2 "Hellenika/WindRiderEx2antigia.tga"
#copystats 1074 -- Wind Rider
#name "Wind Rider"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders, sacred warriors with masterwork bronze plate armor and heroic weapons. There are four kinds of Wind Rider, each wielding a masterwork lance with different properties. This particular type of Wind Rider is equipped with a very long and heavy lance which was designed specifically to slay giants and frighten wild beasts."
#mr 14
#mor 14
#str 12
#att 13
#animalawe 1
#clearweapons
#weapon 1112
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#newmonster 6551
#spr1 "Hellenika/WindRiderEx1antidem.tga"
#spr2 "Hellenika/WindRiderEx2antidem.tga"
#copystats 1074 -- Wind Rider
#name "Wind Rider"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders, sacred warriors with masterwork bronze plate armor and heroic weapons. There are four kinds of Wind Rider, each wielding a masterwork lance with different properties. This particular type of Wind Rider is equipped with a silver-tipped lance whose blessed metal destroys undead and demonic beings with ease."
#mr 14
#mor 14
#str 12
#att 13
#clearweapons
#weapon 1113
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#newmonster 6552
#spr1 "Hellenika/WindRiderEx1antimag.tga"
#spr2 "Hellenika/WindRiderEx2antimag.tga"
#copystats 1074 -- Wind Rider
#name "Wind Rider"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders, sacred warriors with masterwork bronze plate armor and heroic weapons. There are four kinds of Wind Rider, each wielding a masterwork lance with different properties. This particular type of Wind Rider is equipped with a celestial lance that was enchanted by starlight to bypass magical wards and unravel the essence of supernatural beings."
#mr 14
#mor 14
#str 12
#att 13
#clearweapons
#weapon 1114
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#selectmonster 1749 -- Fir Bolg Militia
#gcost 9
#end

#selectmonster 1756 -- Fir Bolg Warrior (axe)
#berserk 2
#pillagebonus 2
#castledef 2
#skirmisher 1
#cleararmor
#armor 136 -- Bronze Scale Hauberk
#armor 2
#rcost -4
#reinvigoration 1
#end

#selectmonster 1757 -- Fir Bolg Warrior (javelin)
#berserk 1
#pillagebonus 1
#castledef 1
#skirmisher 1
#end

#selectmonster 1758 -- Fir Bolg Slinger
#gcost 9
#end

#selectmonster 1812 -- Fir Bolg Warrior (axe)
#berserk 2
#pillagebonus 2
#castledef 2
#skirmisher 1
#cleararmor
#armor 136 -- Bronze Scale Hauberk
#armor 2
#rcost -4
#reinvigoration 1
#end

#selectmonster 1813 -- Fir Bolg Warrior (javelin)
#berserk 1
#pillagebonus 1
#castledef 1
#skirmisher 1
#end

#selectmonster 1814 -- Fir Bolg Slinger
#gcost 9
#end

#selectmonster 1007 -- Mad Deep One
#gcost 0
#end

#selectmonster 1566 -- Mad One
#gcost 0
#end

#selectmonster 1567 -- Mad Merman
#gcost 0
#end

#selectmonster 1568 -- Mad Merman
#gcost 0
#end

#selectmonster 1569 -- Mad Triton
#gcost 0
#end

#selectmonster 1576 -- Mad Hybrid
#gcost 0
#end

#selectmonster 1570 -- Dreamer
#gcost 0
#end

#selectmonster 1571 -- Deep One Dreamer
#gcost 0
#end

#selectmonster 1572 -- Merman Dreamer
#gcost 0
#end

#selectmonster 1573 -- Merman Dreamer
#gcost 0
#end

#selectmonster 1574 -- Merman Dreamer
#gcost 0
#end

#selectmonster 2592 -- Iceclad Zhayedan
#name "Iceclad Zhayedan"
#descr "When the rebel Airyas fled the great civil war in Caelum, they found refuge in the desolate plain of Ragha, where they had once fought the Turan people. The last of the rebel Iceclads protected the last of the rebel Seraphs during the negotiations with the Turan Shah and they became guardians of the emerging priestly caste. The Iceclads soon adopted the Turan concept of the sacred Immortals. The Immortals, Zhayedan, is a sacred elite force of limited numbers, replaced only when one of their numbers is slain. While the Turan Immortals bring righteous wrath to the enemies, the Airya Iceclads became serene guardians of the sacred flames and upholders of the faith."
#mor 14
#mr 14
#att 13
#bodyguard 3
#patrolbonus 3
#gcost 19
#end

#selectmonster 1753 -- Tuatha Warrior
#name "Tuatha Warrior"
#descr "The Tuatha are the rulers of Tir na n'Og, the Land of the Ever Young. They are descendants of the Nemedians who warred with the Fomorians in ancient times. The Tuatha arrived in the lands of the Fir Bolg, conquered them and turned to the lands of the Fomorian giants. They failed and when they returned to their Blessed Island they turned their energy toward crafts, poetry and magic. The Tuatha are sacred to the Fir Bolg and Sidhe inhabitants of the realm. In times of war they emerge from their Blessed Isle with their glamour and the magical armaments that let them conquer the numerically superior Fir Bolg. In addition, being essentially linked to the Faery realm, they cost half of their normal price while Fata Morgana is active and this global will also cause every fully controlled temple with maximal Luck scales and friendly dominion to automatically let another Tuatha Warrior enter the mortal world for free every month."
#enchrebate50p 53
#yearturn 5
#magicpower 1
#hp 15
#def 15
#enc 1
#end

#newmonster 6959
#copystats 708 -- Reveler
#spr1 "Hellenika/SuperReveler1.tga"
#spr2 "Hellenika/SuperReveler2.tga"
#name "Child of Revelry"
#descr "Satyrs are wild and emotional beings. While most satyrs are driven by their fears and lusts, there were once those who would lose themselves to battle lust and revelry. It has been a long time since these Revelers were heard of, but with the emergence of the new Lord, young satyrs have once again become filled with lust for battle and lust for life. Revelers cause unrest in the province where they dwell, and when blessed by the lord in a bath of wine and blood, they don the merry mantle of a Child of Revelry."
#gcost 0
#incunrest 10
#bloodvengeance 1
#hp 17
#str 14
#att 13
#def 15
#mor 14
#enc 1
#chaospower 1
#end

#selectmonster 708 -- Reveler
#name "Reveler"
#descr "Satyrs are wild and emotional beings. While most satyrs are driven by their fears and lusts, there were once those who would lose themselves to battle lust and revelry. It has been a long time since these Revelers were heard of, but with the emergence of the new Lord, young satyrs have once again become filled with lust for battle and lust for life. Revelers cause unrest in the province where they dwell, and when blessed by the lord in a bath of wine and blood, they don the merry mantle of a Child of Revelry."
#addupkeep -8
#chaospower 1
#end

#selectmonster 239 -- Harpy
#addupkeep -4
#chaospower 1
#end

#selectmonster 227 -- Satyr Sneak
#addupkeep -5
#chaospower 1
#end

#selectmonster 228 -- Satyr
#addupkeep -5
#chaospower 1
#end

#selectmonster 230 -- Satyr Hoplite
#addupkeep -7
#chaospower 1
#end

#selectmonster 1041 -- Ichtysatyr (UW)
#addupkeep -5
#gcost 9
#regeneration 10
#chaospower 1
#end

#selectmonster 1042 -- Ichtysatyr (land)
#gcost 9
#addupkeep -5
#regeneration 10
#chaospower 1
#end

#selectmonster 1043 -- Ichtysatyr Soldier (UW)
#addupkeep -5
#regeneration 10
#gcost 10
#chaospower 1
#end

#selectmonster 1044 -- Ichtysatyr Soldier (land)
#gcost 10
#regeneration 10
#addupkeep -5
#chaospower 1
#end

#selectmonster 1532 -- Satyr Warrior
#att 13
#addupkeep -7
#chaospower 1
#end

#selectmonster 2376 -- Ichtysatyr (UW)
#addupkeep -5
#regeneration 10
#gcost 9
#chaospower 1
#end

#selectmonster 2377 -- Ichtysatyr (land)
#addupkeep -5
#regeneration 10
#gcost 9
#chaospower 1
#end

#selectmonster 2378 -- Ichtysatyr Warrior (UW)
#addupkeep -5
#regeneration 10
#gcost 10
#chaospower 1
#end

#selectmonster 2379 -- Ichtysatyr Warrior (land)
#addupkeep -5
#regeneration 10
#gcost 10
#chaospower 1
#end

#selectmonster 2404 -- Ichtysatyr (UW)
#addupkeep -5
#regeneration 10
#gcost 9
#chaospower 1
#end

#selectmonster 2405 -- Ichtysatyr (land)
#gcost 9
#regeneration 10
#addupkeep -5
#chaospower 1
#end

#selectmonster 2406 -- Ichtysatyr (UW)
#addupkeep -5
#regeneration 10
#gcost 9
#chaospower 1
#end

#selectmonster 2407 -- Ichtysatyr (land)
#gcost 9
#regeneration 10
#addupkeep -5
#chaospower 1
#end

#selectmonster 2408 -- Ichtysatyr Soldier (UW)
#addupkeep -5
#regeneration 10
#gcost 10
#chaospower 1
#end

#selectmonster 2409 -- Ichtysatyr Soldier (land)
#gcost 10
#regeneration 10
#addupkeep -5
#chaospower 1
#end

#selectmonster 2478 -- Satyr Sniper
#addupkeep -6
#chaospower 1
#end

#selectmonster 27 -- Centaur archer
#gcost 20
#patrolbonus 2
#end

#selectmonster 2156 -- Centauride archer
#gcost 20
#patrolbonus 2
#armor 148
#end

#selectmonster 2157 -- Centauride Warrior
#armor 148
#female
#end

#selectmonster 234 -- Minotaur
#hp 32
#prot 6
#att 10
#def 10
#unsurr 1
#reinvigoration 4
#end

#selectmonster 235 -- War Minotaur
#hp 32
#prot 6
#att 11
#def 10
#unsurr 2
#reinvigoration 4
#end

#selectmonster 700 -- Minotaur Soldier
#hp 29
#prot 6
#att 11
#def 11
#unsurr 1
#reinvigoration 4
#end

#selectmonster 1533 -- Minotaur Warrior
#hp 34
#prot 6
#att 11
#def 10
#unsurr 2
#reinvigoration 4
#end

#selectmonster 2380 -- EA Ichtytaur (UW)
#hp 33
#prot 6
#att 11
#def 11
#unsurr 1
#reinvigoration 4
#regeneration 10
#gcost 40
#end

#selectmonster 2381 -- EA Ichtytaur (land)
#hp 28
#prot 6
#att 10
#def 10
#unsurr 1
#reinvigoration 4
#regeneration 10
#gcost 40
#end

#selectmonster 2412 -- MA Ichtytaur (UW) (unused)
#hp 33
#prot 6
#att 11
#def 11
#unsurr 1
#reinvigoration 4
#regeneration 10
#gcost 40
#end

#selectmonster 2413 -- MA Ichtytaur (land) (unused)
#hp 28
#prot 6
#att 10
#def 10
#unsurr 1
#reinvigoration 4
#regeneration 10
#gcost 40
#end

#selectmonster 1408 -- Ichtycentaur (UW)
#regeneration 10
#gcost 30
#mapmove 24
#clearweapons
#weapon 651
#weapon 55
#end

#selectmonster 1409 -- Ichtycentaur (land)
#regeneration 10
#gcost 30
#clearweapons
#weapon 651
#weapon 55
#end

#selectmonster 2401 -- Aphroi (UW)
#name "Aphroi"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as sacred warriors equipped with lances and symbiotic armors of living coral which help them crush their foes with their terrifying pincers."
#regeneration 10
#gcost 70
#mapmove 24
#clearweapons
#weapon 651
#weapon 55
#weapon 1237 -- pincer
#end

#selectmonster 2402 -- Aphroi (land)
#name "Aphroi"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as sacred warriors equipped with lances and symbiotic armors of living coral which help them crush their foes with their terrifying pincers."
#regeneration 10
#gcost 70
#clearweapons
#weapon 651
#weapon 55
#weapon 1237 -- pincer
#end

#selectmonster 970 -- Hybrid
#name "Hybrid"
#descr "All coastal forts of R'lyeh have a special well where women can submerge themselves in the hope of being impregnated by a Great One. However, most will be taken by Deep Ones instead and the women's offspring will be strange, fishlike humanoids instead of the noble Starchildren they wanted. These half-human hybrids are usually devoted to the cause of putting mankind below the sea and often join the armies of R'lyeh free of charge. The hybrid is one such strange cross between a human and a Deep One. This being is usually the result of a human female, a Deep One and the influences of R'lyeh."
#end

#selectmonster 971 -- Hybrid Trooper
#name "Hybrid Trooper"
#descr "All coastal forts of R'lyeh have a special well where women can submerge themselves in the hope of being impregnated by a Great One. However, most will be taken by Deep Ones instead and the women's offspring will be strange, fishlike humanoids instead of the noble Starchildren they wanted. These half-human hybrids are usually devoted to the cause of putting mankind below the sea and often join the armies of R'lyeh free of charge. The hybrid is one such strange cross between a human and a Deep One. This being is usually the result of a human female, a Deep One and the influences of R'lyeh."
#end

#selectmonster 972 -- Hybrid Soldier
#name "Hybrid Soldier"
#descr "All coastal forts of R'lyeh have a special well where women can submerge themselves in the hope of being impregnated by a Great One. However, most will be taken by Deep Ones instead and the women's offspring will be strange, fishlike humanoids instead of the noble Starchildren they wanted. These half-human hybrids are usually devoted to the cause of putting mankind below the sea and often join the armies of R'lyeh free of charge. The hybrid is one such strange cross between a human and a Deep One. This being is usually the result of a human female, a Deep One and the influences of R'lyeh."
#end

#selectmonster 967 -- Hybrid freespawn
#gcost 0
#end

#selectmonster 968 -- Hybrid freespawn
#gcost 0
#end

#selectmonster 969 -- Hybrid freespawn
#gcost 0
#end

#selectmonster 1576 -- Hybrid freespawn
#gcost 0
#end

#selectmonster 243 -- Crab Hybrid
#hp 38
#gcost 35
#end

#selectmonster 331 -- Illithid
#clearweapons
#weapon 1116
#weapon 63
#userestricteditem 8088
#gcost 40
#montag 4144
#voidret 10
#end

#selectmonster 607 -- Illithid Soldier
#userestricteditem 8088
#montag 4144
#voidret 10
#end

#selectmonster 621 -- MA and LA Storm Guard
#name "Storm Guard"
#descr "Since they left Caelum and rejected the Eagle Kings' reign, the exiled Spire Horn Caelians have become the martial clan of the magocracy. Skilled Spire Horn Warriors are rewarded with status as Storm Guards. Their ancestry and special training has given them the ability to fly even during heavy storms. They are considered pure and are allowed to use ice cuirasses and ice aegii. Their training and armor give them increased resistance to cold and lightning compared to regular Spire Horn Warriors. The protection gained from the ice armor depends on the temperature of the province. Their ice lances are magical weapons capable of hurting ethereal beings."
#end

#selectmonster 128 -- MA Spire Horn Archer
#name "Spire Horn Archer"
#descr "Since they left Caelum and rejected the Eagle Kings' reign, the exiled Spire Horn Caelians have become the martial clan of the magocracy. The Caelians of Spire Horn Mountain trace their lineage from the Kavi heroes of old, blessed by the Mainyus of the wind and storms. They have partial resistance to cold and lightning. The Spire Horn Caelians are known for their skill in marksmanship. Archery is much preferred over melee combat and most of the Caelian army is comprised of quick and efficient archers."
#end

#selectmonster 131 -- MA Spire Horn Warrior
#name "Spire Horn Warrior"
#descr "Since they left Caelum and rejected the Eagle Kings' reign, the exiled Spire Horn Caelians have become the martial clan of the magocracy. The Caelians of Spire Horn Mountain trace their lineage from the Kavi heroes of old, blessed by the Mainyus of the wind and storms. They have partial resistance to cold and lightning. Many of the Spire Horn Caelians use bows, but the warriors of the clan are remarkably skilled fliers and they are known to swoop down and attack unsuspecting armies during raging storms. Their ice lances are magical weapons capable of hurting ethereal beings."
#end

#selectmonster 132 -- MA Iceclad
#name "Iceclad"
#descr "The Iceclads are the elites of the Airya clan. Since the exile from High Caelum more of the Airyas have turned to martial occupations. The Airyas are blessed with a remarkable resistance to cold and they are the only clan that is considered pure enough to use the ice hauberks made by the Ice Crafters. They wield ice blades and are protected by a transparent shield of ice known as an ice aegis. The ice armor is difficult to make and time consuming to forge. The protection gained from ice armor depends on the temperature of the province. Their ice blades are magical weapons capable of hurting ethereal beings."
#end

#selectmonster 2558 -- Kavi Archer
#name "Kavi Archer"
#descr "There are three Caelian clans. The Caelians of Spire Horn Mountain trace their lineage from the Kavi heroes of old. The Kavi Archers are the last descendants of the heroic ancestors blessed by the Yazatas. They are marksmen of unsurpassed skill and can fly during storms. The Kavi use armor studded with bronze, a metal closely attuned to thunder. They are so talented with the bow that they are able to shot several arrows with each attack and still hit their targets."
#gcost 15
#clearweapons
#weapon 1108
#weapon 35
#end

#selectmonster 1289 -- Airya Temple Guard
#name "Airya Temple Guard"
#descr "The ice temples and Seraphines are guarded by fanatical Airya soldiers who have given up the ability to fly. By cutting off their wings, they lose the freedom so highly valued in Caelian society and commit themselves to serving their God and Master. The loss of wings grants them greater agility on the ground and lets them fight in dense formations. The Temple Guards don icicle mail that magically tempers with colder climate. Their ice blades are magical weapons capable of hurting ethereal beings. They can only be recruited in provinces where an Airya Seraphine is present to initiate them to the sacred rites of Fire worship, cut off their wings and anoint them."
#gcost 15
#monpresentrec 2557 -- Airya Seraphine
#end

#selectmonster 2559 -- Mairya Warrior
#gcost 15
#end

#selectmonster 2547 -- MA Blizzard Warrior
#copyspr 127
#copystats 127 -- EA Blizzard Warrior
#name "Blizzard Sentinel"
#descr "Even more skilled than their relatives of Caelum, the Blizzard Sentinels of Hararat are sacred soldiers trained in the high temples of the realm. Elite archers of the Airya clan, they strike from the icy winds with arrows of ice. While the Immaculate Guards defend the sacred lands and temples of High Hararat, the Blizzard Sentinels bring winter and snow to the enemies of the faith. They use ice-tipped arrows enchanted with frost magic that can freeze their targets and are trained by Spire Horn Seraphs to master flight during storms and bad weather."
#holy
#gcost 20
#ap 12
#enc 3
#end

#selectmonster 127 -- EA Blizzard Warrior
#gcost 10
#end

#selectmonster 414 -- Wingless
#slave
#end

#selectmonster 358 -- MA Temple Guard
#copyspr 2575 -- Airya Noble
#copystats 132 -- Iceclad
#name "Immaculate Guard"
#descr "The Immaculate Guards are sacred warriors named after the exceptional purity of their ice equipment and chosen among the Iceclads to protect the temples of Hararat. Replacing the Temple Guards of High Caelum in their tribe's exile, they no longer have the luxury of sacrificing such a precious gift as flight and now bring glory to the Awakening God of Hararat even in the skies. They bear the same abilities and don the same equipment as their profane iceclad relatives except that they traditionally use a sword rather than a lance. They are blessed with great nimbleness and none in Hararat masters the art of aerial warfare better than them, except for the Blizzard Sentinels in case of bad weather."
#clearweapons
#weapon 77
#holy
#gcost 20
#hp 10
#mr 13
#mor 13
#str 10
#att 12
#def 12
#prec 11
#ap 12
#enc 3
#bodyguard 1
#end

#selectmonster 1543 -- Burning One
#gcost 45
#end

#selectmonster 1661 -- Misbred
#gcost 15
#end

#newmonster 6530
#copystats 1090
#spr1 "Hellenika/AbysianAxeThrower1.tga"
#spr2 "Hellenika/AbysianAxeThrower2.tga"
#name "Abysian Axe Thrower"
#descr "The Abysians are a race of hellish humanoids with magma bodies. They radiate a furnace-like heat and are impervious to all forms of fire, but are vulnerable to cold. The chill of winter slows them down and lowers their morale. Abysian infantry uses heavy iron armor and heavy weapons that will not burn away in their smoldering hands. Although they only rarely use missile weapons, a few among them are trained to throw axes at a range."
#hp 15
#enc 2
#fireres 25
#darkvision 50
#heat 3
#gcost 20
#end

#selectmonster 313 -- Manikin
#name "Manikin"
#descr "A human skeleton reanimated by living vines and roots. Its vines strike like whips and their touch can make men fall asleep. Like all manikins, it spreads its infection to its victims and therefore will raise as a new temporary manikin anyone that it kills in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 314 -- Mandragora
#name "Mandragora"
#descr "A human skeleton reanimated by living vines and roots. Its vines strike like whips and their touch can make men fall asleep. It spreads its infection to its victims and therefore will raise as a new temporary mandragora anyone that it kills in battle."
#raiseonkill 100
#raiseshape 314 -- Mandragora
#end

#selectmonster 712 -- Satyr Manikin
#name "Satyr Manikin"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead satyrs, creating the satyr manikins. Like all manikins, Satyr Manikins spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 713 -- Harpy Manikin
#name "Harpy Manikin"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of a dead harpy. The strange apparition lacks the ability to fly and can only hop. Like all manikins, they will spread their infection to their victims and therefore raise as a new temporary manikin anyone that they kill in battle."
#raiseonkill 100
#mapmove 20
#raiseshape 313 -- Manikin
#clearweapons
#weapon 71
#weapon 408
#end

#selectmonster 715 -- Carrion Beast
#name "Carrion Beast"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead animals, creating the carrion beasts. Like all manikins, Carrion Beasts spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 716 -- Carrion Beast
#name "Carrion Beast"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead animals, creating the carrion beasts. Like all manikins, Carrion Beasts spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 717 -- Carrion Beast
#name "Carrion Beast"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead animals, creating the carrion beasts. Like all manikins, Carrion Beasts spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 718 -- Carrion Beast
#name "Carrion Beast"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead animals, creating the carrion beasts. Like all manikins, Carrion Beasts spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 1005 -- Minotaur Manikin
#name "Minotaur Manikin"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead minotaurs, creating the minotaur manikins. Like all manikins, Minotaur Manikins spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#hp 36
#end

#selectmonster 1006 -- Carrion Beast
#name "Carrion Beast"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead animals, creating the carrion beasts. Like all manikins, Carrion Beasts spread their infection to their victims and therefore will raise as new temporary manikins anyone that they kill in battle."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 1093 -- Sagittarian Carcass
#name "Sagittarian Carcass"
#descr "Unholy rites performed by the Carrion Lords have caused vines and roots to reanimate the bones of dead Hierophants. The unholy power of the Vengeful God has granted the sagittarian carcass magical weapons made of wood and vines. Sagittarian carcasses are holy to the followers of the Vengeful God, and like all manikins they spread their infection to their victims, thus raising as new temporary manikins anyone that they kill in battle."
#plant
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 1179 -- Serpent
#poisonskin 20
#montag 4153 -- can cast Transformation
#poisonres 5
#end

#selectmonster 1831 -- Hydra (recruitable)
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. They are traditionally tamed and bred by the Androphags in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 170
#montag 4153 -- can cast Transformation
#end

#selectmonster 1832 -- Hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. They are traditionally tamed and bred by the Androphags in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 1
#end

#selectmonster 1833 -- Hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. They are traditionally tamed and bred by the Androphags in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 2
#end

#selectmonster 1834 -- Hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. They are traditionally tamed and bred by the Androphags in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 3
#end

#selectmonster 1835 -- Hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. They are traditionally tamed and bred by the Androphags in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 170
#montag 4153 -- can cast Transformation
#end

#selectmonster 1850 -- Sacred hydra (summoned)
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. As primordial monsters of immense power, they are sacred to the people of Triliax."
#gcost 170
#montag 4153 -- can cast Transformation
#end

#selectmonster 1851 -- Sacred hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. As primordial monsters of immense power, they are sacred to the people of Triliax."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 1
#end

#selectmonster 1852 -- Sacred hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. As primordial monsters of immense power, they are sacred to the people of Triliax."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 2
#end

#selectmonster 1853 -- Sacred hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. As primordial monsters of immense power, they are sacred to the people of Triliax."
#gcost 170
#montag 4153 -- can cast Transformation
#berserk 3
#end

#selectmonster 1854 -- Sacred hydra
#name "Hydra"
#descr "In the misty swamps of Pythia in Sauromatia dwell the huge, noxious fume breathing, many-headed serpents of legend, hydras. The regenerative powers of the hydra are truly formidable and should one of its heads be cut off, it will regrow within hours. The bite and breath of a hydra is poisonous. When sufficiently wounded, hydras enter an indomitable rage until reaching the brink of death. Hydras are commonly used in the pits and arenas of Ermor and are deeply feared by soldiers and gladiators alike. As primordial monsters of immense power, they are sacred to the people of Triliax."
#gcost 170
#montag 4153 -- can cast Transformation
#end

#selectmonster 1840 -- Hydra Hatchling (recruitable)
#name "Hydra Hatchling"
#descr "The hydra hatchling is a newborn hydra. The hatchlings have not yet grown five heads, but are still surrounded by noxious fumes and able to regenerate wounds. At this early age hydras are much easier to control than when they grow to monstrous proportions and they therefore cost no upkeep. Like Hydras, they are traditionally tamed and bred in the Swamps of Pythia but may also be captured in other marshlands under strong dominion."
#gcost 30
#addupkeep -30
#montag 4153 -- can cast Transformation
#end

#selectmonster 1841 -- Hydra Hatchling
#name "Hydra Hatchling"
#descr "The hydra hatchling is a newborn hydra. The hatchlings have not yet grown five heads, but are still surrounded by noxious fumes and able to regenerate wounds. At this early age hydras are much easier to control than when they grow to monstrous proportions and they therefore cost no upkeep."
#gcost 30
#addupkeep -30
#montag 4153 -- can cast Transformation
#end

#selectmonster 1842 -- Hydra Hatchling
#name "Hydra Hatchling"
#descr "The hydra hatchling is a newborn hydra. The hatchlings have not yet grown five heads, but are still surrounded by noxious fumes and able to regenerate wounds. At this early age hydras are much easier to control than when they grow to monstrous proportions and they therefore cost no upkeep."
#gcost 30
#addupkeep -30
#montag 4153 -- can cast Transformation
#end

#selectmonster 1176 -- Androphag
#gcost 55
#clearweapons
#weapon 1122 -- Unholy Lance
#weapon 495 -- Poisonous Bite
#weapon 263 -- Net
#poisonres 5
#end

#selectmonster 1183 -- Androphag Archer
#gcost 10
#swampsurvival
#end

#selectmonster 1185 -- Oiorpata
#gcost 40
#end

#newmonster 7714
#copystats 1185
#copyspr 1185
#gcost 0
#end

#selectmonster 1168 -- Raider
#gcost 17
#rpcost 1
#end

#selectmonster 1167 -- Lancer
#gcost 17
#rpcost 1
#end

#selectmonster 1170 -- Sauromatian Lancer
#gcost 20
#rcost -10
#rpcost 23
#end

#newmonster 7711
#copystats 1170
#copyspr 1170
#gcost 0
#end

#selectmonster 1171 -- Sauromatian Raider
#gcost 20
#rcost -8
#rpcost 23
#end

#newmonster 7712
#copystats 1171
#copyspr 1171
#gcost 0
#end

#selectmonster 1172 -- Sauromatian Cataphract
#gcost 25
#mor 16
#end

#newmonster 7710
#copystats 1172
#copyspr 1172
#gcost 0
#end

#selectmonster 1184 -- Sauromatian Archer
#gcost 9
#end

#selectmonster 1669 -- Sauromatian Amazon
#gcost 10
#mapmove 16
#berserk 1
#bodyguard 3
#def 12
#end

#selectmonster 647 -- Troglodyte
#name "Troglodyte"
#descr "Troglodytes are huge, stupid subterranean beings of great strength. Troglodytes sometimes side with the Pale Ones of Agartha, who know the secret of how to manage their hordes. As such, should at least five troglodytes and a troglodyte lord be present in a province fully controlled by Agartha, a new troglodyte would appear for free to join the horde once every other month on average."
#end

#selectmonster 1452 -- Pale One Militia
#hp 22
#gcost 6
#end

#selectmonster 1453 -- Pale One Warrior (heavy armor)
#hp 22
#gcost 9
#end

#selectmonster 1462 -- Cavern Guard
#gcost 12
#hp 26
#end

#selectmonster 1464 -- Pale One Warrior (light armor)
#gcost 9
#hp 22
#end

#selectmonster 1465 -- Pale One
#hp 22
#gcost 9
#end

#selectmonster 1489 -- Wet One
#hp 22
#gcost 9
#end

#selectmonster 1491 -- Wet One
#hp 22
#gcost 9
#end

#selectmonster 1501 -- Cavern Wight
#hp 38
#end

#selectmonster 1636 -- Wet One (armored)
#hp 18
#gcost 9
#end

#selectmonster 1455 -- Ancient Wet One
#hp 63
#end

#selectmonster 1456 -- Seal Guard
#hp 66
#end

#selectmonster 1469 -- Ancient One
#hp 60
#end

#selectmonster 1488 -- Ancient Stone Hurler
#hp 63
#end

#selectmonster 1495 -- Ancient Stone Hurler (armored)
#hp 63
#end

#selectmonster 2489 -- Ancient Wet One (armored)
#hp 63
#end

#selectmonster 2490 -- Ancient Wet One (armored, swimming)
#hp 63
#end

#selectmonster 2188 -- Ancient One (MA)
#hp 60
#end

#selectmonster 2189 -- Ancient Stone Hurler (MA)
#hp 63
#end

#newmonster 6960
#copystats 720 -- Mictlan Slave
#copyspr 720
#name "Lobotomized Slave"
#descr "Aulgyaththu has very little concern for the well-being of mortals. The Aboleths firmly believe that the entire world is theirs by right and treat younger and less intelligent species as mere cattle, especially humans, who never posed a threat to them and can't even breathe underwater without being touched by their secretions. Considered no good for anything but hard work, captured humans are most of the time immediately lobotomized, this operation entirely removing their free will and most of their cognitive abilities. Although they require the presence of a mage overseer to direct their actions, the resulting workers are obedient and might even accept death without a word if life essentials aren't provided to them. While weaker than lobo guards in combat, they are more efficient at using tools for crafting and extracting purposes, and they can be mass produced easily even far from the coast. However, the human body tolerates that treatment much worse than the Atlantian's, and therefore lobotomized humans have an extremely short life expectancy."
#magicbeing
#mor 50
#mr 5
#gcost 4
#startage 1
#maxage 5
#resources 1
#clearweapons
#weapon 1
#end

#selectmonster 335 -- Slave Trooper
#name "Slave Trooper"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 336 -- Slave Guardian
#name "Slave Guardian"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 335 -- Slave Trooper
#name "Slave Trooper"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1515 -- Slave Trooper
#name "Slave Trooper"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1516 -- Slave Trooper
#name "Slave Trooper"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1517 -- Slave Trooper
#name "Slave Trooper"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1524 -- Slave Guardian
#name "Slave Guardian"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1525 -- Slave Guardian
#name "Slave Guardian"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1526 -- Slave Guardian
#name "Slave Guardian"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 1619 -- Slave Guardian
#name "Slave Guardian"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The slaves are used even in war and comprise most of the armies of these nations."
#end

#selectmonster 337 -- Lobo Guard
#name "Lobo Guard"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. The lowest and most trusted of the slaves are the Lobo Guards. These beasts are mindless Atlantians who have served as slaves until mental abuse has broken them. Now they serve as perfectly loyal guards and arrow fodder."
#end

#selectmonster 625 -- Shambler Thrall
#name "Shambler Thrall"
#descr "Shamblers are Atlantians grown to huge proportions. The shambler thrall is an Atlantian shambler enslaved and corrupted by the masters of Aulgyaththu or R'lyeh. Since shamblers are proud and strong, they cannot be trusted unless totally lobotomized. Thralls are fanatically loyal, but too stupid to carry armaments. A shambler thrall can trample opponents in battle."
#resources 2
#hp 36
#gcost 20
#end

#selectmonster 1522 -- Gibodai
#name "Gibodai"
#descr "When nurtured by the Polypal Mothers, some spawn get a different kind of nutrition. Whether this is caused by an act of will or randomness is not known, because the Mothers do not speak, they only scream. The spawn are given special care and soon develop a bond with their Mother. Small tentacles sprout around their mouths and they use them to search the ocean floor for life force needed by the Mothers. The Gibodai consume life force and accumulate it for their Mothers. Some suspect that the Gibodai and their ability to steal and carry life force is the key to the power of the Aboleths. Even though only adult members of the elder race are usually considered sacred in the eyes of the Aboleths, Gibodai make exception for their nature and their task closely associate them with the polypal mothers' mysterious will."
#gcost 40
#darkpower 1
#poisonskin 8
#voidsanity 5
#poisonres 7
#twiceborn 3452
#heal
#end

#selectmonster 1403 -- Giboleth
#name "Giboleth"
#descr "Aboleths are ancient beings sprung from the depths of the ocean. They resemble huge, mud-crawling fish with tentacles and large, dark eyes covering their foreheads. The Giboleth is a young Aboleth that has survived its spawn age and grown independent of its Polypal Mother. It has begun to shed its scales, but its hide is still thick and dark. The Giboleth is beginning to develop the strength of mind characteristic of the race and it can project its will on lesser beings. Should it survive for some centuries, it will shed the last of its scales and become a full grown Aboleth, able to dominate other beings and granted sacred status. A Giboleth fights with the strength of its mind and its tentacles."
#darkpower 1
#gcost 30
#poisonskin 8
#voidsanity 5
#poisonres 7
#twiceborn 3452
#heal
#end

#selectmonster 1404 -- Polypal Spawn
#darkpower 1
#att 11
#mor 9
#poisonskin 4
#voidsanity 5
#poisonres 7
#twiceborn 3452
#heal
#end

#selectmonster 2884 -- Androleth
#gcost 35
#end

#newmonster 7505 -- New Ermor
#copystats 2 -- Old Ermor Standard
#copyspr 2
#end

#newmonster 7506 -- New Ermor
#copystats 11 -- Old Ermor Retiarius
#copyspr 11
-- no montag is intended
#end

#newmonster 7507 -- New Ermor
#copystats 12 -- Old Ermor Gladiator
#copyspr 12
-- no montag is intended
#end

#newmonster 7508 -- New Ermor
#copystats 50 -- Old Ermor Slinger
#copyspr 50
#end

#newmonster 7509 -- New Ermor
#copystats 1100 -- Old Ermor Leve
#copyspr 1100
#end

#newmonster 7510 -- New Ermor
#copystats 1101 -- Old Ermor Accensus
#copyspr 1101
#end

#newmonster 7511 -- New Ermor
#copystats 1102 -- Old Ermor Rorarus
#copyspr 1102
#end

#newmonster 7512 -- New Ermor
#copystats 1103 -- Old Ermor Hastatus
#copyspr 1103
#end

#newmonster 7513 -- New Ermor
#copystats 1104 -- Old Ermor Principe
#copyspr 1104
#end

#newmonster 7514 -- New Ermor
#copystats 1105 -- Old Ermor Triarius
#copyspr 1105
#att 14
#def 13
#mor 14
#end

#newmonster 7515 -- New Ermor
#copystats 1106 -- Old Ermor Lizard Auxiliare
#copyspr 1106
#end

#newmonster 7516 -- New Ermor
#copystats 1107 -- Old Ermor Equite
#copyspr 1107
#end

#newmonster 7517 -- New Ermor
#copystats 1108 -- Old Ermor Equite of the Sacred Shroud
#copyspr 1108
#end

#selectmonster 12 -- Retiarus
#montag 4121
#end

#selectmonster 11 -- Gladiator
#montag 4121
#end

#newmonster 7541 -- New Ermor
#spr1 "Hellenika/EternalKnight1a.tga"
#spr2 "Hellenika/EternalKnight2a.tga"
#name "Eternal Knight"
#descr "With the proclamation of the Decree of Sanctity, the Eternal Knights swore to serve the Holy Father of Eldregate and were granted immortality by the God. Should one day Ermor Fall and their masters be corrupted, they would fight against even them and defend the Holy Sepulchre at all costs. The Eternal Knights wield great, flaming swords that shred the flesh of undead beings. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#hp 14
#size 2
#prot 0
#mr 14
#mor 30
#str 12
#att 12
#def 12
#prec 10
#ap 12
#mapmove 16
#enc 3
#maxage 1000
#startage 30
#weapon 95
#armor 9
#armor 20
#regeneration 10
#fireres 15
#holy
#magicskill 8 2
#domimmortal
#gcost 50
#nametype 106
#rpcost 32
#end

#newmonster 6636
#spr1 "Hellenika/EternalKnight1a.tga"
#spr2 "Hellenika/EternalKnight2a.tga"
#name "Eternal Knight"
#descr "With the proclamation of the Decree of Sanctity, the Eternal Knights swore to serve the Holy Father of Eldregate and were granted immortality by the God. Should one day Ermor Fall and their masters be corrupted, they would fight against even them and defend the Holy Sepulchre at all costs. The Eternal Knights wield great, flaming swords that shred the flesh of undead beings. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#hp 14
#size 2
#prot 0
#mr 14
#mor 30
#str 12
#att 12
#def 12
#prec 10
#ap 12
#mapmove 16
#enc 3
#maxage 1000
#startage 30
#weapon 95
#armor 9
#armor 20
#regeneration 10
#fireres 15
#holy
#magicskill 8 2
#domimmortal
#gcost 50
#nametype 106
#rpcost 32
#end

#newmonster 7542 -- New Ermor
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/Saint1a.tga"
#spr2 "Hellenika/Saint2a.tga"
#name "Saint"
#descr "Saints are people of uncorruptible faith that were granted immortality by the God as a reward for their good actions, words and sacrifices when the Decree of Sanctity was proclaimed. They are sacred and, since they ask nothing from others for their sustenance, they cost no upkeep. Although they are non-violent and won't use any other weapon than their gentle touch, they still are useful in battle as they have the blessing of the Holy Sepulchre and inspire awe to the kind of heart. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#domimmortal
#gcost 20
#addupkeep -25
#weapon 282
#awe 1
#mr 16
#mor 18
#rpcost 8
#nametype 106
#end

#newmonster 6961
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/Saint1a.tga"
#spr2 "Hellenika/Saint2a.tga"
#name "Saint"
#descr "Saints are people of uncorruptible faith that were granted immortality by the God as a reward for their good actions, words and sacrifices when the Decree of Sanctity was proclaimed. They are sacred and, since they ask nothing from others for their sustenance, they cost no upkeep. Although they are non-violent and won't use any other weapon than their gentle touch, they still are useful in battle as they have the blessing of the Holy Sepulchre and inspire awe to the kind of heart. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#domimmortal
#gcost 20
#addupkeep -25
#weapon 282
#awe 1
#mr 16
#mor 18
#rpcost 8
#nametype 106
#end

#newmonster 7543 -- New Ermor
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/Martyr1a.tga"
#spr2 "Hellenika/Martyr1b.tga"
#name "Martyr"
#descr "Martyrs are saints of incredible zeal that selflessly sacrificed their life and blood in the name of the God. They share all of the Saints' abilities but are truly immortal and also inspire such awe and existential bliss that anyone who attempts to hurt them might hurt himself instead. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#immortal
#gcost 120
#addupkeep -120
#weapon 282
#awe 3
#damagerev 1
#enc 0
#mr 18
#mor 30
#magicskill 8 3
#standard 2
#rpcost 16
#nametype 106
#reclimit 1
#startage 33
#end

#newmonster 6962
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/Martyr1a.tga"
#spr2 "Hellenika/Martyr1b.tga"
#name "Martyr"
#descr "Martyrs are saints of incredible zeal that selflessly sacrificed their life and blood in the name of the God. They share all of the Saints' abilities but are truly immortal and also inspire such awe and existential bliss that anyone who attempts to hurt them might hurt himself instead. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#immortal
#gcost 160
#addupkeep -160
#weapon 282
#awe 3
#damagerev 1
#enc 0
#mr 18
#mor 30
#magicskill 8 3
#standard 2
#rpcost 16
#nametype 106
#reclimit 1
#startage 33
#end

#selectmonster 2126 -- Pygmy
#addupkeep -3
#end

#selectmonster 2298 -- Machaka Militia
#addupkeep -4
#rpcost 1
#end

#selectmonster 2299 -- Bird Clan Archer
#addupkeep -5
#prec 16
#end

#selectmonster 2300 -- Machaka Warrior
#addupkeep -5
#rpcost 5
#end

#selectmonster 2301 -- Spider Clan Archer
#name "Spider Clan Archer"
#descr "The Spider Clan is possibly the smallest of the clans, and they are rarely found outside the Forest of Spider. They are shorter than most Machakans and use wits and malice to achieve their ends. Influenced by Spider, the archers of the clan use arrows dipped in poison made by their witch doctors. Thus, a laboratory is necessary to recruit them."
#addupkeep -6
#reqlab
#end

#newmonster 7365
#copyspr 2301
#copystats 2301
#reclimit 3
#end

#selectmonster 2302 -- Spider Clan Warrior
#name "Spider Clan Warrior"
#descr "The Spider Clan is possibly the smallest of the clans, and they are rarely found outside the Forest of Spider. They are shorter than most Machakans and use wits and malice to achieve their ends. Influenced by Spider, the warriors of the clan use spears dipped in poison made by their witch doctors. Thus, a laboratory is necessary to recruit them."
#addupkeep -6
#reqlab
#end

#newmonster 7366
#copyspr 2302
#copystats 2302
#reclimit 3
#end

#selectmonster 2308 -- Spider Rider
#addupkeep -15
#end

#newmonster 7367
#copyspr 2308
#copystats 2308
#reclimit 1
#end

#selectmonster 2303 -- Hyena Clan Warrior
#addupkeep -5
#stealthy
#end

#selectmonster 2304 -- Rhino Clan Warrior
#woundfend 1
#prot 1
#att 11
#rcost 0
#addupkeep -7
#end

#selectmonster 2305 -- Lion Clan Warrior
#hp 14
#str 12
#mor 16
#mr 13
#enc 2
#att 12
#addupkeep -7
#end

#selectmonster 2306 -- War Lion
#berserk 2
#addupkeep -10
#end

#selectmonster 2309 -- Lion Warrior
#hp 25
#str 17
#att 13
#def 13
#gcost 30
#rcost -5
#end

#newmonster 7544 -- New Ermor
#copystats 1654 -- Lictor
#copyspr 1654
#name "Lictor"
#descr "Lictors were once Ermorian dignitaries entrusted with keeping the peace during the heyday of the Empire. With the proclamation of the Decree of Thaumaturgy and the emergence of the Death Cult, their responsibilities have changed. Now they form a sacred elite force charged with the task of keeping the dead in line with axes blessed by the Thaumaturgs to halt the dead. Should they be granted imperial authority with Divine Name, Lictors would also become able to spend each month training one more of their own. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#makemonsters1 1654
#end

#selectmonster 1654 -- Lictor
#name "Lictor"
#descr "Lictors were once Ermorian dignitaries entrusted with keeping the peace during the heyday of the Empire. With the proclamation of the Decree of Thaumaturgy and the emergence of the Death Cult, their responsibilities have changed. Now they form a sacred elite force charged with the task of keeping the dead in line with axes blessed by the Thaumaturgs to halt the dead. Should they be granted imperial authority with Divine Name, Lictors would also become able to spend each month training one more of their own. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#makemonsters1 1654
#end

#newmonster 7545 -- New Ermor
#copystats 667 -- Praetorian Guard
#copyspr 667
#name "Praetorian Guard"
#descr "The Praetorian Guards serve as the bodyguards of the Thaumaturgs, who reward them with a blessing of supernatural invulnerability. The Guard consists of old veterans given the honor when they left their old careers. The members of the Praetorian Guard are all very skilled and brave, but their age makes them weak and many have old wounds that have never healed. They wear heavy plate armor and are armed with broadswords. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#str 13
#att 16
#def 16
#mor 16
#mr 13
#woundfend 1
#invulnerable 15
#end

#selectmonster 667 -- Praetorian Guard
#name "Praetorian Guard"
#descr "The Praetorian Guards serve as the bodyguards of the Thaumaturgs, who reward them with a blessing of supernatural invulnerability. The Guard consists of old veterans given the honor when they left their old careers. The members of the Praetorian Guard are all very skilled and brave, but their age makes them weak and many have old wounds that have never healed. They wear heavy plate armor and are armed with broadswords. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#str 13
#att 16
#def 16
#mor 16
#mr 13
#woundfend 1
#invulnerable 15
#end

#newmonster 7546 -- New Ermor
#copystats 809 -- Shadow Vestal
#copyspr 809
#name "Shadow Vestal"
#descr "Shadow Vestals are the result of a dark rite known as Shadow Merging. Young girls are trained in the Temple of the Dead to prepare them for the merging. When ready, a girl surrenders herself and is buried alive in the Campus Sceleris, the Field of Wickedness. When her heart stops her body and soul is merged with the ghost of an ancient Vestal Virgin and her life is spared. Her body is exhumed and she is given a new name and a new life. The Shadow Vestal is an ethereal being, part living and part dead, and doesn't cost any upkeep. Shadow Vestals are sacred and can be blessed. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#gcost 40
#addupkeep -40
#curseluckshield 1
#darkpower 3
#illusion
#end

#selectmonster 809 -- Shadow Vestal
#name "Shadow Vestal"
#descr "Shadow Vestals are the result of a dark rite known as Shadow Merging. Young girls are trained in the Temple of the Dead to prepare them for the merging. When ready, a girl surrenders herself and is buried alive in the Campus Sceleris, the Field of Wickedness. When her heart stops her body and soul is merged with the ghost of an ancient Vestal Virgin and her life is spared. Her body is exhumed and she is given a new name and a new life. The Shadow Vestal is an ethereal being, part living and part dead, and doesn't cost any upkeep. Shadow Vestals are sacred and can be blessed. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#gcost 40
#addupkeep -40
#curseluckshield 1
#darkpower 3
#illusion
#end

#selectmonster 3159 -- Orichalcum Guard
#name "Orichalcum Guard"
#descr "Not all Colossi nobles study magic. Some serve their queens as sacred guardians of the Orichalcum Palace. Trained from a young age they are only matched in combat prowess by the Gigantes of Black Korkyra. In Phaeacia a strange golden red metal of exceptional durability has been found and mined. It is used to embellish the royal palace, to craft jewelry of unequalled beauty, and most notably used to make the armaments of the Orichalcum Guard. Orichalcum is very difficult to work and only the most accomplished phaeacian craftsmen are able to forge the armaments used by the Orichalcum Guard. Like all Colossi nobles from the capital, in addition to sacred status, Orichalcum Guards receive a golden apple diet which allows them to recover from all wounds."
#hp 26
#att 13
#def 13
#mor 15
#mr 14
#str 18
#heal
#shockres 5
#fireres 5
#woundfend 1
#bodyguard 3
#end

#newmonster 6963
#copystats 191
#copyspr 191
#montag 4118
#end

#newmonster 6964
#copystats 192
#copyspr 192
#montag 4118
#end

#newmonster 6965
#copystats 193
#copyspr 193
#montag 4118
#end

#newmonster 6966
#copystats 194
#copyspr 194
#montag 4118
#end

#newmonster 6967
#copystats 195
#copyspr 195
#montag 4118
#end

#newmonster 6968
#copystats 196
#copyspr 196
#montag 4118
#end

#newmonster 7611
#copystats 187 -- Longdead Legionnaire
#spr1 "./Hellenika/LongdeadStandard1.tga"
#spr2 "./Hellenika/LongdeadStandard2.tga"
#name "Longdead Standard"
#descr "Skeletal legionnaires risen from the ashen fields of Ermor, they are armed with rusty spears and tower shields and wear armor of dried leather and rusty iron. Fearless and skilled in combat, they march upon the living to reclaim their dead empire. They do not rout unless all undead commanders are killed. The longdead are mindless and will quickly dissolve if they are broken on the battlefield. Their standards carry high in battle the devastated symbols of the Fallen Empire, spreading fear among the enemy ranks."
#fear 5
#clearweapons
#weapon 6
#weapon 21
#end

#newmonster 7612
#copystats 187 -- Longdead Legionnaire
#spr1 "./Hellenika/LongdeadStandard1.tga"
#spr2 "./Hellenika/LongdeadStandard2.tga"
#name "Longdead Standard"
#descr "Skeletal legionnaires risen from the ashen fields of Ermor, they are armed with rusty spears and tower shields and wear armor of dried leather and rusty iron. Fearless and skilled in combat, they march upon the living to reclaim their dead empire. They do not rout unless all undead commanders are killed. The longdead are mindless and will quickly dissolve if they are broken on the battlefield. Their standards carry high in battle the devastated symbols of the Fallen Empire, spreading fear among the enemy ranks."
#fear 5
#clearweapons
#weapon 6
#weapon 21
#immobile
#ap 0
#secondshape 5611
#end

#selectmonster 186
#montag 4117
#end

#selectmonster 187
#montag 4117
#end

#selectmonster 1657
#montag 4117
#end

#selectmonster 1658
#montag 4117
#end

#newmonster 7547 -- New Ermor
#copystats 51 -- Battle Vestal
#copyspr 51
#name "Battle Vestal"
#descr "When a noble lady gives birth to an illegitimate daughter she has the opportunity of redeeming herself by giving her daughter away to the Church to become trained as a priestly maiden. From the age of six they are trained in battle and athletic sports otherwise restricted to men. When they reach maturity they are inaugurated as priestesses and given their first spear. While before the proclamation of the Decree of Theurgy they only fought in the arenas or in holy ceremonies, now that the Theurgs have come to power they have largely encouraged the Vestals to train for war against the false Gods. They carry no armor, relying on their quickness and faith to avoid their enemies' weapons. While they can be recruited even in forts without temples, a Battle Deacon must be present to train them. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#monpresentrec 5528 -- Battle Deacon
#noreqtemple
#gcost 10
#end

#selectmonster 71 -- Battle Vestal
#name "Battle Vestal"
#descr "When a noble lady gives birth to an illegitimate daughter she has the opportunity of redeeming herself by giving her daughter away to the Church to become trained as a priestly maiden. From the age of six they are trained in battle and athletic sports otherwise restricted to men. When they reach maturity they are inaugurated as priestesses and given their first spear. While before the proclamation of the Decree of Theurgy they only fought in the arenas or in holy ceremonies, now that the Theurgs have come to power they have largely encouraged the Vestals to train for war against the false Gods. They carry no armor, relying on their quickness and faith to avoid their enemies' weapons. While they can be recruited even in forts without temples, a Battle Deacon must be present to train them. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#monpresentrec 52 -- Battle Deacon
#noreqtemple
#gcost 10
#end

#newmonster 7548 -- New Ermor
#copystats 538 -- Theurg Communicant
#copyspr 538
#name "Theurg Communicant"
#descr "The Theurgs of Pythium are masters of arcane communion. This communion allows them to cast more powerful spells in combat. Theurg Communicants are acolytes trained in the Theurgical arts. They lack the arcane skills of true Theurgs, but are able to strengthen the magic of senior Theurgs by acting as communion slaves. The Communicants automatically cast the Communion Slave spell before combat, ready to lend their strength to the senior Theurgs. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#end

#selectmonster 738 -- Theurg Communicant
#name "Theurg Communicant"
#descr "The Theurgs of Pythium are masters of arcane communion. This communion allows them to cast more powerful spells in combat. Theurg Communicants are acolytes trained in the Theurgical arts. They lack the arcane skills of true Theurgs, but are able to strengthen the magic of senior Theurgs by acting as communion slaves. The Communicants automatically cast the Communion Slave spell before combat, ready to lend their strength to the senior Theurgs. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#end

#selectmonster 2840 -- Spectral Archer
#montag 4149
#end

#selectmonster 2841 -- Spectral Peltast
#montag 4149
#end

#selectmonster 2842 -- Spectral Hoplite
#montag 4149
#end

#selectmonster 2839 -- Kourete
#rpcost 23
#end

#selectmonster 3101 -- Helote Peltast
#rcost 0
#rpcost 3
#gcost 6
#mor 6
#xpshape 20
#end

#selectmonster 3103 -- Helote Ekdromos
#rcost -1
#xpshape 20
#end

#selectmonster 3105 -- Helote Hoplite
#rcost -3
#xpshape 20
#end

#selectmonster 3107 -- Perioeci Scout
#hp 11
#str 11
#att 11
#prec 12
#mor 10
#end

#selectmonster 3100 -- Perioeci Peltast
#hp 11
#str 11
#att 11
#prec 12
#mor 11
#end

#selectmonster 3104 -- Neodamode Ekdromos
#hp 11
#str 11
#att 11
#prec 12
#mor 12
#end

#selectmonster 3106 -- Neodamode Hoplite
#hp 11
#str 11
#att 11
#prec 12
#mor 12
#end

#selectmonster 3108 -- Neodamode Commander
#hp 13
#str 12
#att 12
#prec 12
#mor 13
#end

#selectmonster 3109 -- Gigante Ekdromos
#haltheretic 1
#gcost 40
#hp 45
#end

#selectmonster 3110 -- Gigante Hoplite
#haltheretic 1
#gcost 40
#hp 45
#end

#selectmonster 3120 -- Discobolus
#spr1 "Hellenika/Discobolus1.tga"
#spr2 "Hellenika/Discobolus2.tga"
#haltheretic 1
#gcost 30
#hp 48
#end

#newmonster 6652
#copystats 3109 -- Gigante Ekdromos
#copyspr 3109
#xpshape 40
#end

#newmonster 6653
#copystats 3109 -- Sacred Gigante Ekdromos
#spr1 "Hellenika/SacredEkdromos1.tga"
#spr2 "Hellenika/SacredEkdromos2.tga"
#holy
#clearweapons
#weapon 722
#end

#newmonster 6656
#copystats 3110 -- Gigante Hoplite
#copyspr 3110
#xpshape 40
#end

#newmonster 6657
#copystats 3110 -- Sacred Gigante Hoplite
#spr1 "Hellenika/SacredGigante1.tga"
#spr2 "Hellenika/SacredGigante2.tga"
#holy
#clearweapons
#weapon 722
#end

#newmonster 6654
#copystats 3120 -- Discobolus
#spr1 "Hellenika/Discobolus1.tga"
#spr2 "Hellenika/Discobolus2.tga"
#copyspr 3120
#xpshape 40
#end

#newmonster 6655
#copystats 3120 -- Sacred Discobolus
#spr1 "Hellenika/SacredDiscobolus1.tga"
#spr2 "Hellenika/SacredDiscobolus2.tga"
#holy
#clearweapons
#weapon 1128
#weapon 1128
#weapon 1129
#end

#selectmonster 164 -- Swamp Guard
#name "Swamp Guard"
#descr "The Swamp Guards of C'tis are the elites of the kingdom. They are very disciplined, experienced and physically imposing and serve the New Dynasty with great zeal. They protect the marshes of C'tis from intruders and serve as guardians of the Temple of the Lizard Kings. They don full scale armor and wield heavy falchions blessed by the High Priests of C'tis in combat."
#clearweapons
#weapon 1149
#bodyguard 3
#patrolbonus 3
#hp 14
#mor 13
#att 13
#str 13
#mr 14
#woundfend 1
#end

#selectmonster 783 -- Serpent Dancer
#name "Serpent Dancer"
#descr "Serpent Dancers are cultic dancers of the Great Temple of C'tis. They intoxicate themselves with serpent venom and perform whirling ritual dances. During these dances, they may strike someone in the audience with their poisonous staffs. Should the target survive the poisoning, it is considered a most fortunate event and his hatchlings would be accepted as acolytes in the Temple. Sometimes the Serpent Dancers are called upon to join the armies of C'tis as sacred, fanatic warriors. They wield magical snake staffs, but they never don armor as it would hamper their ritual adulations. The snake staffs are magical and capable of hurting ethereal beings. Each one also carries a small, single-use ampule of snake venom which throw upon their opponents when charging them, before replenishing it once the battle is over. Serpent Dancers are highly resistant to most forms of poison, and when blessed they enter a berserker trance under the effect of the psychoactive toxins they consume."
#blessbers
#end

#selectmonster 1118 -- Markata
#name "Markata"
#descr "Bandar Log is a very hierarchical society, and so is the nascent simian culture of Kailasa. Markatas are the smallest of the monkey people and their intellect is barely above that of simple beasts. Markatas are small, noisy and annoying, especially when met in large numbers. If alone, they can be used as scouts, but when in greater numbers, they quickly become bored and start to make noise and play with each other. They are generally despised by the larger monkeys and apes. They are sometimes given small bows. This pleases them no end, but they are still not very useful soldiers."
#end

#selectmonster 1120 -- Markata Archer
#name "Markata Archer"
#descr "Bandar Log is a very hierarchical society, and so is the nascent simian culture of Kailasa. Markatas are the smallest of the monkey people and their intellect is barely above that of simple beasts. Markatas are small, noisy and annoying, especially when met in large numbers. If alone, they can be used as scouts, but when in greater numbers, they quickly become bored and start to make noise and play with each other. They are generally despised by the larger monkeys and apes. They are sometimes given small bows. This pleases them no end, but they are still not very useful soldiers."
#end

#selectmonster 1121 -- Atavi Archer
#name "Atavi Archer"
#descr "The Vanara are the most common of the four castes of Bandar Log and Kailasa. They are about as big as humans. Many Vanaras live in tribal societies in the dense forests of these realms. The warriors of the forest tribes are called Atavi. They use bows and maces, but do not wear armor. All Atavi are stealthy."
#end

#selectmonster 1122 -- Atavi Infantry
#name "Atavi Infantry"
#descr "The Vanara are the most common of the four castes of Bandar Log and Kailasa. They are about as big as humans. Many Vanaras live in tribal societies in the dense forests of these realms. The warriors of the forest tribes are called Atavi. They use bows and maces, but do not wear armor. All Atavi are stealthy."
#end

#selectmonster 1130 -- Light Bandar Archer
#name "Light Bandar Archer"
#descr "The Bandar are large, black apes who tower over their fellow apes and monkeys. Bandar light archers are lowly Bandar, barely above the Vanara in status. They are not given armor nor are they allowed to fight in melee, as this would give them honor and the possibility to climb in the social hierarchy and get noble mates. While the Bandar of Bandar Log are proud of being part of the Great Kingdom of the Apes and of dominating the lesser monkeys, those of Kailasa resent them, at the same time jealous of their superior power, angry against their tyrannical and violent behavior and convinced of the fact that their own subserviance towards the Yakshas makes them better than them."
#end

#selectmonster 1326 -- Guhyaka
#name "Guhyaka"
#descr "A Guhyaka is a lowly Yaksha warrior. Although their services are more expensive than the Yavana's, they are far more common and once bought their loyalty is inconditional, requiring no upkeep. Like the Yavanas, they are semi-divine beings gifted with Celestial Splendor that strikes lowly beings with awe. Their mystical powers have made them rulers over the monkey people, who worship them as sacred benefactors. Guhyakas are armed with spears."
#addupkeep -27
#clearweapons
#weapon 1
#weapon 397
#weapon 22
#end

#selectmonster 1327 -- Yavana
#name "Yavana"
#descr "A Yavana is a Yaksha warrior of the sacred Mount Kailasa. They are semi-divine beings gifted with Celestial Splendor that strikes lowly beings with awe. Their mystical powers have made them rulers over the monkey people, who worship them as sacred benefactors. Yavanas are armed with falchion and buckler or a longbow."
#gcost 5
#end

#selectmonster 1328 -- Yavana Archer
#name "Yavana Archer"
#descr "A Yavana is a Yaksha warrior of the sacred Mount Kailasa. They are semi-divine beings gifted with Celestial Splendor that strikes lowly beings with awe. Their mystical powers have made them rulers over the monkey people, who worship them as sacred benefactors. Yavanas are armed with falchion and buckler or a longbow."
#gcost 5
#rpcost 5
#end

#selectmonster 3211 -- Helote Archer
#name "Helote Archer"
#descr "While mankind toil and serve, the Cyclopes wage war upon inferior races. However, the Cyclopes are few in numbers and much of the Porphyrian armies are still composed of human slaves armed and coerced into military service by human taskmasters. While many Porphyrian slave soldiers have good armaments, lightly armed slaves archers are still levied in masses."
#end

#selectmonster 3212 -- Helote Crossbowman
#name "Helote Crossbowman"
#descr "Knowing that unlike the Phlegran Tyrants they lack semidivine blood and other extraordinary powers, the Oppressors have long been worried about the perennity of their rule. Thus, they have never ceased thinking of new ways to ensure their survival both against the people and against exterior threats such as other more magically powerful nations or the terrifying perspective of the Laestrygonians' return. Weaving contacts with powerful mercenary lords and putting the mighty Cyclops military on their side have been two of their oldest ideas, already serving them in the old war against Phlegra; but the Oppressors haven't stopped there, and, enslaving the Elder Cyclopes and shackling them in their dark dungeons, they have relentlessly spent their efforts and resources in supporting technological progress in service of their armies - the only way they could ever compete with the Gigantes and other formidable creatures that still roam this world. Therefore, it is no surprise that the Porphyrian mastery of metallurgy, architecture and engineering is so advanced compared to other nations of this age. Crossbows also are one of the greatest marvels of Porphyrian manufacturing, a secret weapon that the Oppressors mass produced and won't hesitate to use as soon as they can - after all, the Cyclopes are there to keep the human slaves in check, so there are no qualms about giving human soldiers good arms."
#end

#selectmonster 3213 -- Helote Soldier
#name "Helote Soldier"
#descr "While mankind toil and serve, the Cyclopes wage war upon inferior races. However, the Cyclopes are few in numbers and much of the Porphyrian armies are still composed of human slaves armed and coerced into military service by human taskmasters. Since humans cannot compete with the strength of the cyclopes there are no qualms about giving them good arms. Porphyrian slave soldiers have equipment matching the highly advanced knowledge metallurgy developed by the shackled smiths and their Oppressors in their quest for unbreakable rule. Skilled Helote Soldiers can receive the dubious honor of promotion. Given heavy armor and an enchanted Iron Band the slave soldier's loyalty is ensured. Called Iron Bound, these soldiers are known never to rout from battle."
#end

#selectmonster 3214 -- Iron Bound
#name "Iron Bound"
#descr "A Helote Soldier that survives long enough to become recognized will eventually be promoted to the ranks of the Iron Bound. The Iron Bound are Porphyrian elite soldiers that never retreat from battle. The reason is to be found in the iron bands given them by the Oppressors. These iron bands demand total loyalty from its wearer. If the wearer disobeys or routs from a battle the iron band will cause excruciating pain and possibly death. Thus the Iron Bound almost never rout, even though their morale and loyalty is the same as that of most slave soldiers. The coerced bravery makes the Iron Bound fight more aggressively and they care less about defending themselves. They can only be commanded by mages able to control the collars. If all friendly mages are routed or killed the Iron Bound might end up dying."
#end

#selectmonster 3215 -- Mouflon Cataphract
#name "Mouflon Cataphract"
#descr "Since old times the wild Cyclopes of Porphyrion and Phlegra have herded great mouflon sheep. In preparation for the great war against Phlegra a few generations ago and under the advice of the Oppressors, the Cyclopes have bred and trained the great sheep to carry human riders in an attempt to mimic the mounted tactics of other nations and surprise the Phlegran Tyrants with the strength of their military. This tactic has greatly helped Porphyrion in obtaining victory and independence from the Gigantes, and as such it has persisted to this day, now being complemented by the very advanced armaments produced by the Porphyrian exceptional arts of metallurgy. The mouflon are not as fast as horses, but they are stronger and they can provide supplies for the army. Mouflon Cataphracts are slave soldiers and serve out of fear rather than loyalty. They have abysmal morale compared to the knights and cataphracts of other nations, but can be pushed to bravery by cruel taskmasters."
#end

#selectmonster 3216 -- Iron Guard
#name "Iron Guard"
#descr "The Iron Guards are elite slave soldiers trained from a young age in Telepylos. Chosen for their physical strength and robustness they are superior to all but the Cyclops soldiers. The Iron Guards never retreat from battle. They might get killed to the last man, but they never rout. Or at least that is how they are perceived by Porphyrion's neighbors. The truth is a bit more sinister. Since the independence of Porphyrion and even before then, humans have given their services to their Tyrant and Oppressor masters to gain power over their fellow men. The first Oppressors managed to enslave magically skilled humans with the aid of enchanted collars designed with the aid of the Elder Cyclopes. With the necessity for unbreakable strength against the threats of revolution, other more magically powerful nations and the terrifying perspective of the Laestrygonians' eventual return, the mages of Porphyrion have honed their skills and now not only mages are bound by magical shackles. The Iron Guards are given enchanted slave bands to ensure that they never break in battle. These slave bands do not enhance morale per se, but should the slaves abandon orders or rout from battle the band will cause excruciating pain and possibly kill the wearer. The Iron Guards are braver than most slave warriors, and the knowledge that they might die should they flee makes them almost unbreakable in combat. The Iron Guards can only be commanded by mages able to control the collars. If all friendly mages are routed or killed they might end up dying. The Iron Guards are privileged as slaves go and serve as personal guards of the Oppressors and elite shock troops used only in the most important battles."
#woundfend 3
#str 13
#enc 2
#prot 1
#bodyguard 3
#end

#newmonster 6642
#copystats 3178 -- Wight Shaman
#spr1 "Hellenika/MarjanaamaWight1.tga"
#spr2 "Hellenika/MarjanaamaWight2.tga"
#name "Blemmye Wight"
#descr "A blemmye wight is the corpse of a sciapod necromancer strong enough to avoid death itself. Its dried and leathery body is stronger than it was in life. The blemmye wight is constantly surrounded by an icy wind."
#troglodyte
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#weapon 1150
#weapon 20
#popkill 1
#incunrest 10
#userestricteditem 8066
#fixforgebonus -1
#voidsanity 10
#end

#newmonster 6971
#spr1 "Hellenika/Limb_a1.tga"
#spr2 "Hellenika/Limb_a2.tga"
#name "Protozoon"
#descr "Protozoons are strange creatures theorized by the philosophers of Arcoscephale to be the origins of life as we know it. They take the form of independent limbs or bodyparts animated with a life of their own. According to cosmogonists, they existed at a time when there was no animal on earth yet. Neckless heads, arms without shoulders, legs walking without a body, these fragmentary structures that do not reproduce but instead are spontaneously generated from the earth originally weren't designed to work together. Vegetative yet mobile, they lacked both a mind and the need to eat, drink or breathe and were drawn by immediate desire alone. This time is known as the reign of love, and it ended when the protozoons started to assemble in complex structures as they were compelled by nature and the force of amity. Thus appeared the first humans and animals, thus began the reign of hatred. Since then, protozoons have disappeared, for they needed the strength of association to form organisms and fight in this new existence of strife - or so was thought for a long time. But in truth, they never really went extinct. Instead, it is animals that conquered the world and soon left the cradle of the earth, which still generates thousands of new protozoons every day. Although these deep caves of rich mud, silt, clay or soil are seldom visited by civilized explorers, they are very often guarded and worshipped by blemmyes of all kinds, and especially sciapods, who are very conscious of their importance. Indeed, if blemmyes are sexless just like protozoons, this is no accident: incapable of reproducing like humans, they instead are formed naturally from the spontaneous association of random protozoons, which also led some erudites to posit that blemmyes are in fact proto-humans - our very ancestors. And now, the innumerable protozoons, devoid of will and intelligence, are sometimes used in war by the blemmyes as swarms of crawling, wiggling, jumping limbs that do not feel fear or pain."
#nametype 240
#size 1
#hp 3
#prot 0
#mr 12
#mor 50
#str 4
#att 9
#def 11
#prec 25
#ap 10
#mapmove 3
#enc 3
#maxage 5
#miscshape
#weapon 397
#itemslots 6144 -- 1 feet, 1 misc
#blind
#eyes 0
#mountainsurvival
#noleader
#gcost 1
#addupkeep -1
#rpcost 1
#rcost 1
#coldres -3
#magicbeing
#poormagicleader
#neednoteat
#patrolbonus -1
#undisciplined
#montag 4146
#userestricteditem 8066
#end

#newmonster 6701
#spr1 "Hellenika/Limb_b1.tga"
#spr2 "Hellenika/Limb_b2.tga"
#name "Protozoon"
#descr "Protozoons are strange creatures theorized by the philosophers of Arcoscephale to be the origins of life as we know it. They take the form of independent limbs or bodyparts animated with a life of their own. According to cosmogonists, they existed at a time when there was no animal on earth yet. Neckless heads, arms without shoulders, legs walking without a body, these fragmentary structures that do not reproduce but instead are spontaneously generated from the earth originally weren't designed to work together. Vegetative yet mobile, they lacked both a mind and the need to eat, drink or breathe and were drawn by immediate desire alone. This time is known as the reign of love, and it ended when the protozoons started to assemble in complex structures as they were compelled by nature and the force of amity. Thus appeared the first humans and animals, thus began the reign of hatred. Since then, protozoons have disappeared, for they needed the strength of association to form organisms and fight in this new existence of strife - or so was thought for a long time. But in truth, they never really went extinct. Instead, it is animals that conquered the world and soon left the cradle of the earth, which still generates thousands of new protozoons every day. Although these deep caves of rich mud, silt, clay or soil are seldom visited by civilized explorers, they are very often guarded and worshipped by blemmyes of all kinds, and especially sciapods, who are very conscious of their importance. Indeed, if blemmyes are sexless just like protozoons, this is no accident: incapable of reproducing like humans, they instead are formed naturally from the spontaneous association of random protozoons, which also led some erudites to posit that blemmyes are in fact proto-humans - our very ancestors. And now, the innumerable protozoons, devoid of will and intelligence, are sometimes used in war by the blemmyes as swarms of crawling, wiggling, jumping limbs that do not feel fear or pain."
#nametype 240
#size 1
#hp 3
#prot 0
#mr 12
#mor 50
#str 3
#att 10
#def 9
#prec 25
#ap 10
#mapmove 3
#enc 3
#maxage 5
#miscshape
#weapon 116
#itemslots 12288 -- 2 misc
#blind
#eyes 0
#mountainsurvival
#noleader
#gcost 1
#addupkeep -1
#rpcost 1
#rcost 1
#coldres -3
#magicbeing
#poormagicleader
#neednoteat
#patrolbonus -1
#undisciplined
#montag 4146
#userestricteditem 8066
#end

#newmonster 6702
#spr1 "Hellenika/Limb_a1.tga"
#spr2 "Hellenika/Limb_a2.tga"
#name "Protozoon"
#descr "Protozoons are strange creatures theorized by the philosophers of Arcoscephale to be the origins of life as we know it. They take the form of independent limbs or bodyparts animated with a life of their own. According to cosmogonists, they existed at a time when there was no animal on earth yet. Neckless heads, arms without shoulders, legs walking without a body, these fragmentary structures that do not reproduce but instead are spontaneously generated from the earth originally weren't designed to work together. Vegetative yet mobile, they lacked both a mind and the need to eat, drink or breathe and were drawn by immediate desire alone. This time is known as the reign of love, and it ended when the protozoons started to assemble in complex structures as they were compelled by nature and the force of amity. Thus appeared the first humans and animals, thus began the reign of hatred. Since then, protozoons have disappeared, for they needed the strength of association to form organisms and fight in this new existence of strife - or so was thought for a long time. But in truth, they never really went extinct. Instead, it is animals that conquered the world and soon left the cradle of the earth, which still generates thousands of new protozoons every day. Although these deep caves of rich mud, silt, clay or soil are seldom visited by civilized explorers, they are very often guarded and worshipped by blemmyes of all kinds, and especially sciapods, who are very conscious of their importance. Indeed, if blemmyes are sexless just like protozoons, this is no accident: incapable of reproducing like humans, they instead are formed naturally from the spontaneous association of random protozoons, which also led some erudites to posit that blemmyes are in fact proto-humans - our very ancestors. And now, the innumerable protozoons, devoid of will and intelligence, are sometimes used in war by the blemmyes as swarms of crawling, wiggling, jumping limbs that do not feel fear or pain."
#nametype 240
#size 1
#hp 3
#prot 0
#mr 12
#mor 50
#str 4
#att 9
#def 11
#prec 25
#ap 10
#mapmove 3
#enc 3
#maxage 5
#miscshape
#weapon 397
#itemslots 6144 -- 1 feet, 1 misc
#blind
#eyes 0
#mountainsurvival
#noleader
#gcost 1
#addupkeep -1
#rpcost 1
#rcost 1
#coldres -3
#magicbeing
#poormagicleader
#neednoteat
#patrolbonus -1
#undisciplined
#firstshape -4146
#userestricteditem 8066
#end

#newmonster 6972
#spr1 "Hellenika/Triskelion1.tga"
#spr2 "Hellenika/Triskelion2.tga"
#name "Triskelios"
#descr "Triskelioi are strange creatures born from the spontaneous aggregation of three leg protozoons. Considering the fact that legs and arms are equally common among protozoons, the existence of triskelioi is inevitable, since sciapods - the most numerous of sentient blemmyes - have two arms for one leg. As such, triskelioi are widely believed to be formed of the many legs in surplus. Still, their generation doesn't follow any preordained plan, and just like protozoons, with whom they share most of their qualities, they are completely devoid of intelligence. Since their entire body is made of nothing but legs, triskelioi are known in the lands of U as one of the fastest terrestrial creatures in existence. In order to avoid losing balance, triskelioi never walk. Instead, unable to ever stop their course, they continuously roll forward not unlike a wheel, and when numerous enough they mindlessly trample everything in their path, repeatedly kicking with great agility, speed and strength anything too large to be climbed over."
#nametype 240
#size 3
#hp 10
#prot 0
#mr 13
#mor 50
#str 10
#att 13
#def 13
#prec 10
#ap 32
#mapmove 26
#enc 3
#maxage 20
#miscshape
#magicbeing
#weapon 397
#weapon 397
#weapon 397
#trample
#itemslots 14336 -- 1 feet, 2 misc
#blind
#eyes 0
#mountainsurvival
#noleader
#coldres -3
#goodmagicleader
#neednoteat
#gcost 9
#rcost 1
#rpcost 30
#formationfighter 3
#userestricteditem 8066
#undisciplined
#end

#newmonster 6973
#spr1 "Hellenika/EpiphagosE1.tga"
#spr2 "Hellenika/EpiphagosE2.tga"
#name "Epiphagos"
#descr "Probably the most primitive of sentient blemmyes, Epiphagoi are degenerate sciapods who are known and feared for their cannibalistic practices and cruelty towards weaker beings and humans. Living a troglodyte lifestyle apart from the rest of their race, they are barely more intelligent than most animals and clearly more violent and noxious. Everywhere they go they bring havoc and more than one welcoming land became a waste due to their destructive and unclean behavior. The only thing they respect is strength, which is part of the reason why only the toughest and sturdiest of sciapods are fit to lead the people of U. In battle, Epiphagoi are exactly as fearsome as they sound: they always attempt to attack their targets in greater numbers and they strike them with extreme brutality, using both their muscular arms and their powerful jaws as weapons, and entering a devastating berserker rage as soon as they are hurt. Although they are extremely voracious and as such vulnerable to starvation, they never seem to stop reproducing, consuming and depleting their environment, regardless of the suffering this will cause them. As such, they always find a way to survive even in the most inhospitable lands, especially since they can still eat each other or weaker, unfortunate blemmyes when in shortage of supplies. Therefore, any province where there are at least five Epiphagoi will suffer the loss of twenty inhabitants per month, in exchange causing an additional Epiphagos to spawn unless the province is entirely devoid of life. Sometimes, an Anthropophagos will even appear to guide them in barbarity, and for as long as at least one is doing so, an additional Epiphagos will join his tribe a month out of two on average."
#nametype 240
#size 2
#hp 15
#prot 1
#mr 7
#mor 10
#str 14
#att 10
#def 7
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 90
#weapon 20
#weapon 1151
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#supplybonus -6
#incunrest 3
#berserk 3
#gcost 7
#rpcost 10
#coldres -3
#poormagicleader
#wastesurvival
#userestricteditem 8066
#twiceborn 6642
#end

#newmonster 6974
#spr1 "Hellenika/Lilliput_D1.tga"
#spr2 "Hellenika/Lilliput_D2.tga"
#name "Lilliputian"
#descr "Lilliputians are xenophobic sciapods of tiny size that especially hate humans and pygmies and live in aggressive tribes separately from the rest of blemmyes. Although their society is less organized than those of other sciapods - Epiphagoi excepted -, they are clever enough to see that the God of U welcomes them more than any other and to willingly serve him. They also are renowned among blemmyes for their unique interest in technology; indeed, they have developed primitive crafting techniques and frequently make use of stone spears and nets in war. Yet, they certainly are not any more intelligent than regular sciapods, as for most other matters they appear to be both short-sighted and short-tempered, and their understanding of long term planning and strategy is often extremely superficial, making them easy to trick. Still, while unskilled, their very disorganized military makes an efficient use of their innate strengths: hard to catch due to their size, quickness and agility, Lilliputian warriors always travel in group and try to outnumber their enemies as well as to harass them until they can no longer defend themselves. In addition to being recruitable in all forts, Lilliputians can be gathered in great numbers by their Sophotatos leaders."
#nametype 240
#size 1
#hp 3
#prot 0
#mr 7
#mor 8
#str 5
#att 9
#def 13
#prec 9
#ap 10
#mapmove 3
#enc 3
#maxage 20
#troglodyte
#weapon 373
#weapon 263
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#gcost 3
#rpcost 8
#rcost 5
#coldres -3
#poormagicleader
#undisciplined
#userestricteditem 8066
#twiceborn 6642
#end

#newmonster 6975
#spr1 "Hellenika/SciapodB1.tga"
#spr2 "Hellenika/SciapodB2.tga"
#name "Sciapod Tribesman"
#descr "The most common and the least uncivilized of sciapods, tribesmen are also the closest to humans. They form the caste of the weak, and although their society is primitive, it is still built on mutual aid and cooperation, at least for as long as the strong who rule them let them be. Rather unfit physically when compared to other sciapods, they prefer to live in a peaceful environment, which makes them more docile than most other members of their species and incites them to count on their intelligence rather than on their strength. In spite of these qualities, they remain generally very unskilled, poor, uneducated and not very bright, unless they are brave enough to leave blemmye society and explore the world as either outcasts or military scouts, or embrace the true strength or their kin by joining the priestly caste in the temples. Still, not everyone is born to become a priest and most tribesmen have to accept that they'll better care for their loved ones and themselves by fulfilling other, less prestigious functions, such as those of hunter, breeder or stone carver. But even that is not a chance one can take for granted in the unforgiving lands of U: for several reasons - a weak intellectual capacity, the fear of jealousy from the strong, the cult of the body and its innate abilities, distrust of mankind and anything that comes from it... -, blemmyes almost entirely eschew technology, which causes craftsmanship to be of very minor use in U, and agriculture is similarly underdeveloped due to the barren state of the lands of blemmyes. As a consequence, unable to make themselves useful to their leaders, many tribesmen are forced to live as scavengers in idleness and suffering, which can even lead some to lose their last semblance of humanity by becoming cannibalistic Epiphagoi. Although a few try to avoid that fate by becoming soldiers and, one day hopefully, athletes among the strong, most only fight when ordered so by their chieftains, naked and unarmed."
#nametype 240
#size 2
#hp 12
#prot 0
#mr 7
#mor 8
#str 10
#att 10
#def 11
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 92
#weapon 397
#weapon 1151
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#gcost 3
#rpcost 5
#coldres -3
#poormagicleader
#userestricteditem 8066
#twiceborn 6642
#end

#newmonster 6976
#spr1 "Hellenika/SciapodA1.tga"
#spr2 "Hellenika/SciapodA2.tga"
#name "Sciapod Athlete"
#descr "While sciapods eschew technology and often live as troglodytes, the least uncivilized of their tribes still have a proper culture - a language, a society, a religion, rites, arts and traditions. In that regard, one of the most obvious and important manifestations of sciapods' aesthetics and philosophy might be their cult of the body, its strength and its beauty. In U, gymnastics, bodybuilding and sports in general have a sacred status and are considered to express the inherent nobility of sciapods the most perfectly. The ever-growing refinement and surpassing of the self, the constant mental and physical struggle for performance both alone and in fraternal competition, the intimate knowledge of one's own limitations and how to overcome them, and finally the refusal to do so while cheating with external help: those are some of the most important values of sciapods as taught by the Priests of U. It is no wonder, then, if they refuse to use artificial tools - as they dishonor the innate ability of the body - or even clothes - which would hide the body instead of making it shine with health, might and pride. The most virtuous followers of this doctrine, sciapod athletes are deeply admired and loved by regular tribesmen, who greatly enjoy watching them fight for glory in the Teratomachic games and dream of one day reaching their heights - for they are living examples of the fact that it is indeed possible, for one of the weak, to eventually become one of the strong and reach a higher social status through sheer effort and merit. Although they consider their efficiency as warriors to be a very secondary effect of their training, sciapod athletes are among the greatest martial artists of U. These oiled wrestlers' capabilities are directly proportionate to the amount of time and energy they spend working out daily, so they are much stronger in lands of Production while being weaker in lands of Sloth - a true athlete never has any time to spare in vain pursuits."
#nametype 240
#size 3
#hp 21
#prot 1
#mr 9
#mor 12
#str 17
#att 14
#def 15
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 397
#weapon 1151
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#slothpower -1
#mountainsurvival
#gcost 10
#rpcost 14
#coldres -3
#poormagicleader
#userestricteditem 8066
#swimming
#twiceborn 6642
#end

#newmonster 6977
#spr1 "Hellenika/SciapodC1.tga"
#spr2 "Hellenika/SciapodC2.tga"
#name "Sciapod Champion"
#descr "The strongest of all sciapods besides Gavagai giants, the proud sciapod champions form the elite of the caste of the strong. These brutal and stupid half-giants reign over lesser blemmyes by sheer strength and are happy to serve their chieftain for as long as he remains the strongest. They do not tolerate disrespect from weaker than them and refuse to obey commanders of a smaller size. Just like athletes, with which they share their unconditional love of strength training, they somewhat lose shape when they give in to Sloth and become mightier instead when in lands of effort, work and Production. Still, even when at their lowest, they remain formidable warriors, living mountains of brawn and muscle that fight with great discipline and without a second thought for their victims."
#nametype 240
#size 4
#hp 40
#prot 3
#mr 9
#mor 14
#str 21
#att 14
#def 12
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 90
#weapon 397
#weapon 1152
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#slothpower -1
#mountainsurvival
#gcost 20
#reclimit 3
#formationfighter 2
#rpcost 18
#coldres -3
#poormagicleader
#userestricteditem 8066
#swimming
#minsizeleader 4
#twiceborn 6642
#end

#newmonster 6978
#spr1 "Hellenika/WarBoulder.tga"
#spr2 "Hellenika/WarBoulder.tga"
#name "War Boulder"
#descr "One of the mightiest mundane weapons known to blemmyes, War Boulders are huge, round rocks that are pushed around on the battlefield by the strongest of sciapods, protecting their operators like giant shields and crushing their foes like insects. Although blemmyes rarely use any equipment at all, polishing a great stone and making it roll is a simple enough concept for their limited intellect to grasp and for their primitive tools to execute, and their immense muscular power also allows them to be much more efficient than humans when using such a crude armament in warfare. Although creating and displacing War Boulders takes a great amount of work and resources, which makes them slow both to construct and to move around, their very low cost as well as their great impact both in battle and in siegecraft explain their continuous importance in blemmye strategy. This may seem surprising to foreigners, as pushing a huge weight uphill at first sounds impossible with only one leg: at least two appear to be required to stop the boulder from rolling down all the while advancing alongside it. But onlookers know that this is not a real issue to blemmyes, thanks to their lack of head. Indeed, everytime the boulder's operator reaches the maximal extension of his arms, he blocks the giant stone with his headless shoulders, maintains his posture by grasping the ground with his hands, and uses that time period to displace his unique foot closer to the rock before starting that cycle anew, thus ensuring a steady march regardless of the slope he has to escalate. With enough strength, endurance and training, the greatest of sciapod athletes are thus able to handle that formidable weapon with uncanny ease. When a War Boulder is finally destroyed or otherwise rendered useless, its operator abandons it and continues fighting on his own as a regular Sciapod Champion."
#nametype 240
#hp 40
#size 4
#prot 3
#mr 9
#mor 18
#str 21
#att 14
#def 10
#prec 10
#ap 12
#mapmove 1
#enc 3
#maxage 40
#noleader
#weapon 1193
#armor 798
#darkvision 100
#troglodyte
#itemslots 7168 -- 1 body, 1 feet, 1 misc
#coldres -3
#trample
#gcost 25
#rpcost 18
#rcost 0
#woundfend 3
#siegebonus 25
#castledef 25
#formationfighter -2
#minsizeleader 4
#secondshape "Sciapod Champion"
#noriverpass
#twiceborn 6642
#end

#newmonster 6979
#spr1 "Hellenika/GavagaiB1.tga"
#spr2 "Hellenika/GavagaiB2.tga"
#name "Gavagai"
#descr "Gavagai giants are a species of blemmyes of titanic size with anatomical traits similar to that of sciapods. While usually less intelligent than them to the point of having noticeable troubles using language, they also are much stronger and sturdier, which, along with their towering height, makes them terrifying opponents and largely explains why they generally don't need to use their brains to survive. Rumored to be able to displace mountains single-handedly, they evidently surpass even the most muscular sciapods in physical might and are truly capable of incredible feats of strength, such as throwing huge boulders in battle or using them to destroy fortifications. Still, it may be that their inner differences with sciapods are the greatest; in most cases indeed, the mind of these solitary creatures is as soft as it is slow, and their kind heart is vulnerable to pain and manipulation alike. Thus, a few less naive and more ambitious Gavagais exploit these weaknesses to force their brothers into submission and wage permanent war against each other, at such a large scale that it only rarely affects other blemmyes. In any case, either under the command of these brutal tyrants - generally called their chieftains - or out of genuine love for their tiny cousins, Gavagais are among the greatest defenders of U, and without them it may be that blemmyes would have been enslaved or eradicated long ago, making of them the seemingly eternal keepers of the entire blemmye race."
#nametype 240
#size 6
#hp 90
#prot 5
#mr 8
#mor 12
#str 28
#att 12
#def 9
#prec 12
#ap 18
#mapmove 20
#enc 3
#maxage 200
#troglodyte
#weapon 90
#weapon 90
#weapon 397
#weapon 1153
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#fear 5
#patrolbonus 25
#siegebonus 25
#castledef 25
#mountainsurvival
#gcost 75
#reclimit 1
#rpcost 40
#poormagicleader
#userestricteditem 8066
#minsizeleader 4
#twiceborn 775
#end

#newmonster 6980
#spr1 "Hellenika/BlemmyeDancer_1.tga"
#spr2 "Hellenika/BlemmyeDancer_2.tga"
#name "Dancer of the Foot"
#descr "Like all blemmyes, due to the natural mechanism of their birth from random protozoons, sciapods are extremely diverse anatomically. This is mostly true of their size, but sometimes also of their proportions, so it is not exceedingly rare for them to be born with one or more hypertrophied limbs. In particular, those that are gifted with an unusually large foot are considered blessed by the God and often become traditional dancers in the temples, attaining sacred, untouchable status. Their strange discipline is one of the greatest manifestations of blemmye art and, while very hard to perform without training, is considered the most beautiful and meaningful way to express oneself in U. As such, even regular sciapods are often taught the very basics of that dance since childhood so that they are able to take part in the happiest celebration there is to blemmyes, a monthly social gathering during which the whole tribe assembles in joy and harmony regardless of social status to pray, dance and sing for the Awakening God. While regular tribesmen can dance however they want in this circumstance, they still try to emulate the sacred dancers' very codified technique, which, except for a few moves entailing some use of the back or the shoulders, involves standing on one's hands alone, all the while rhythmically waving one's unique foot in the air in diversified patterns and doing various acrobatic jumps or quick rotations of the body. To achieve such skill, they seldom stand on their foot even outside religious context, instead walking on their hands almost permanently, a feat which would be impossible without their natural lack of head and immense agility. Misunderstanding that weird behavior, foreign onlookers have speculated that sciapods use their foot to shield themselves from the sun, which explains why their name means shadow-foot; but they nonetheless know that U's acrobats are extraordinary warriors capable of beheading a man with a single hit of their powerful foot."
#size 3
#hp 18
#prot 1
#mr 9
#mor 13
#str 17
#att 15
#def 14
#prec 10
#ap 18
#mapmove 16
#enc 2
#maxage 40
#troglodyte
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#weapon 1139
#mountainsurvival
#gcost 12
#rpcost 16
#coldres -3
#holy
#poormagicleader
#userestricteditem 8066
#twiceborn 6642
#end

#selectmonster 1094 -- Desert Ranger
#spr1 "Hellenika/AabMerc_1.tga"
#spr2 "Hellenika/AabMerc_2.tga"
#name "Desert Ranger"
#descr "The Desert Rangers are elite warriors who patrol the Desert of Tombs to prevent looters and enemies from entering the Sacred Tombs. Although loyal, they are very independent and, like mercenaries, take care of their own equipment. They can only be recruited in wastelands and are trained to resist extreme heats."
#rpcost 1
#rcost -14
#reclimit 10
#fireres 5
#addupkeep -7
#end

#newmonster 6981
#copystats 168 -- C'tissian Militia
#spr1 "Hellenika/AabMilitia_1.tga"
#spr2 "Hellenika/AabMilitia_2.tga"
#name "Desert Militia"
#descr "The militia of Aabydum are the lightest and most cowardly of the desert kingdom's troops."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#addupkeep -2
#end

#newmonster 6982
#copystats 167 -- C'tissian Light Infantry
#spr1 "Hellenika/AabLightInf_1.tga"
#spr2 "Hellenika/AabLightInf_2.tga"
#name "Desert Light Infantry"
#descr "The light infantry of Aabydum are armed with spears and javelins. For protection, they rely upon their scaly skin and round shields."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#addupkeep -3
#end

#newmonster 6983
#copystats 166 -- C'tissian City Guard
#spr1 "Hellenika/AabCityGuard_1.tga"
#spr2 "Hellenika/AabCityGuard_2.tga"
#name "Desert City Guard"
#descr "The City Guard wear light scale mail cuirass and use spears and shields. They are trained to defend cities and are very effective when defending fortresses."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#addupkeep -3
#end

#newmonster 6984
#copystats 165 -- C'tissian Heavy Infantry
#spr1 "Hellenika/AabHeavInf_1.tga"
#spr2 "Hellenika/AabHeavInf_2.tga"
#name "Desert Heavy Infantry"
#descr "Heavy scale hauberks cover the bodies of these reptilian soldiers. They use spears and shields."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#addupkeep -3
#end

#newmonster 6958
#copystats 504 -- C'tissian Falchioneer
#spr1 "Hellenika/AabFalchioneer_1.tga"
#spr2 "Hellenika/AabFalchioneer_2.tga"
#name "Desert Falchioneer"
#descr "Falchioneers are among the most fearsome troops in the army of Aabydum. They wield two huge falchions in battle and don light armor. The use of two large weapons is exhausting, which is why falchioneers do not use heavy armor."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#addupkeep -4
#end

#selectmonster 173 -- C'tissian Runner
#name "Runner"
#descr "The runner is a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. They carry light spears, but no other equipment or armor. They have partial resistance to poison and, since their subjugation by the Lizard Kings, have also received their blessing in the form of a great resistance to diseases."
#end

#selectmonster 172 -- C'tissian Elite Warrior
#name "Elite Warrior"
#descr "Some prominent slave warriors receive additional training and scale cuirass for protection. They are feared by ordinary C'tissians, but are disciplined enough not to kill and eat their masters. They have partial resistance to poison and, since their subjugation by the Lizard Kings, have also received their blessing in the form of a great resistance to diseases."
#end

#selectmonster 171 -- C'tissian Slave Warrior
#name "Slave Warrior"
#descr "In the C'tissian society, predator lizards are considered stupid, aggressive and untrustworthy. Members of the predator race are enslaved and forced to perform manual labor. Their temperament and strength make them well suited for combat, so they are trained in warfare by special Taskmasters. The slave warriors are armed with tridents and can use their jaws to bite opponents in close combat. They have partial resistance to poison and, since their subjugation by the Lizard Kings, have also received their blessing in the form of a great resistance to diseases."
#end

#selectmonster 1166 -- Tomb Guard
#spr1 "Hellenika/AabSacred_1.tga"
#spr2 "Hellenika/AabSacred_2.tga"
#name "Tomb Guard"
#descr "Selected among the most loyal and skilled of the Desert Rangers, the Tomb Guards are the elite force of Aabydum. Armed with blades enchanted by the Sauromancers with eerie banefire from the Underworld, they serve the Keepers of the Tombs and protect the ancient structures of the desert with blind zeal. They rarely leave the Sacred Desert, but when they do, the enemies of Aabydum tremble. The Tomb Guards are larger and stronger than their brethren and their dust-colored skins are almost impregnable."
#clearweapons
#weapon 1202
#gcost 25
#fireres 5
#addupkeep -6
#end

#selectmonster 703 -- Poison Slinger
#spr1 "Hellenika/AabSlinger_1.tga"
#spr2 "Hellenika/AabSlinger_2.tga"
#name "Poison Slinger"
#descr "In the Empoisoners' Guild, apprentices are trained to make poison bullets. These bullets crack open on impact, releasing poisonous fumes. The poison slingers use these bullets with slings to increase the range of their weapons. The guild is very active in ancient Aabydum, where its novices can also be trained in all wasteland provinces where highly venomous rattlesnakes can be found, but they cannot be recruited without the presence of an Empoisoner to teach them. The younger but more properous nation of C'tis is however becoming wary of its jealous cousins and has beginning hiring poison slinger mercenaries to guard its cities' walls against intrusions, which the Empoisoners' Guild has accepted to study its dominion of Miasma."
#prot 6
#rpcost 6
#reclimit 10
#wastesurvival
#monpresentrec -4148
#addupkeep -6
#end

#selectmonster 2186 -- Sacred Crocodile
#name "Sacred Crocodile"
#descr "All crocodiles are more or less sacred to the populaces of Aabydum and C'tis. In the temple marshes some crocodiles are fed slaves and captives. These crocodiles grow to huge proportions. When fed they return into the marshes with their prize and legend has it that they feed their father, a spawn of God, in the depths of the marsh. Blessed by his magic they return to the temples and wait for another sacrifice."
#end

#newmonster 6985
#copystats 295 -- Sacred Serpent
#spr1 "Hellenika/AabSerp_1.tga"
#spr2 "Hellenika/AabSerp_2.tga"
#name "Sacred Rattlesnake"
#descr "The priests of Aabydum keep large, venomous rattlesnakes in the dark and humid caverns beneath their temples. The snakes seem to be intelligent and easy to train. They are revered by the people of Aabydum and are considered good luck in difficult times. The sight of a sacred rattlesnake raises the spirits of soldiers and gives them hope of victory."
#wastesurvival
#addupkeep -3
#end

#newmonster 6986
#copystats 351
#spr1 "Hellenika/GarnetHoplite_1.tga"
#spr2 "Hellenika/GarnetHoplite_2.tga"
#name "Garnet Hoplite"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. Garnet Hoplites probably are the best representatives of the former. Unlike their sisters the Furies, they are stronger in lands of Order and weaker in lands of Turmoil. These strict heralds of law and justice are the elite of the nation. They fight in dense formations and have a nearly unbreakable morale. They are equipped with shock-resistant heavy armor and long spears that allow them to repel damage with far greater efficiency than their brethren, and their scarlet standard is the sure sign of victory."
#gcost 12
#mor 14
#hp 12
#str 12
#def 15
#att 13
#enc 2
#chaospower -1
#formationfighter 2
#shockres 5
#woundfend 1
#montag 4142
#clearweapons
#weapon 644
#cleararmor
#armor 101
#armor 123
#armor 209
#end

#newmonster 6987
#copystats 351
#spr1 "Hellenika/GarnetFury_1.tga"
#spr2 "Hellenika/GarnetFury_2.tga"
#name "Garnet Fury"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 15
#rpcost 12
#hp 11
#str 10
#def 15
#enc 2
#chaospower 1
#berserk 3
#woundfend 1
#chaosrec 2
#ambidextrous 3
#addupkeep -7
#montag 4142
#cleararmor
#armor 148
#weapon 6
#weapon 253
#xpshape 45
#pillagebonus 3
#end

#newmonster 6988
#copystats 351
#spr1 "Hellenika/GarnetSlayer_1.tga"
#spr2 "Hellenika/GarnetSlayer_2.tga"
#name "Garnet Demon"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 0
#rpcost 12
#hp 13
#str 12
#def 15
#mr 13
#mor 18
#enc 1
#chaospower 1
#berserk 3
#woundfend 1
#ambidextrous 3
#fear 5
#supplybonus -1
#holy
#cleararmor
#armor 148
#weapon 397
#weapon 253
#weapon 253
#firstshape -4138
#pillagebonus 3
#makemonsters4 4987
#makemonsters1 -4138
#inspirational 2
#magicskill 8 1
#end

#newmonster 6989
#copystats 351
#spr1 "Hellenika/GarnetSlayer_1.tga"
#spr2 "Hellenika/GarnetSlayer_2.tga"
#name "Garnet Demon"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 0
#rpcost 12
#hp 13
#str 12
#def 15
#mr 13
#mor 18
#enc 1
#chaospower 1
#berserk 3
#woundfend 1
#ambidextrous 3
#fear 5
#supplybonus -1
#holy
#cleararmor
#armor 148
#weapon 397
#weapon 253
#weapon 253
#montag 4138
#pillagebonus 3
#makemonsters4 4987
#makemonsters1 -4138
#inspirational 2
#magicskill 8 1
#end

#newmonster 6990
#copystats 351
#spr1 "Hellenika/GarnetBerserker_1.tga"
#spr2 "Hellenika/GarnetBerserker_2.tga"
#name "Garnet Demon"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 0
#rpcost 12
#hp 13
#str 12
#def 15
#mr 13
#mor 18
#enc 1
#chaospower 1
#berserk 3
#woundfend 1
#ambidextrous 3
#fear 5
#supplybonus -1
#holy
#cleararmor
#armor 148
#weapon 397
#weapon 6
#weapon 253
#montag 4138
#pillagebonus 3
#makemonsters4 4987
#makemonsters1 -4138
#inspirational 2
#magicskill 8 1
#end

#newmonster 6991
#copystats 351
#spr1 "Hellenika/GarnetSlaughterer_1.tga"
#spr2 "Hellenika/GarnetSlaughterer_2.tga"
#name "Garnet Demon"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 0
#rpcost 12
#hp 13
#str 12
#def 15
#mr 13
#mor 18
#enc 1
#chaospower 1
#berserk 3
#woundfend 1
#ambidextrous 3
#fear 5
#supplybonus -1
#holy
#cleararmor
#armor 148
#weapon 397
#weapon 253
#weapon 253
#montag 4138
#pillagebonus 3
#makemonsters4 4987
#makemonsters1 -4138
#inspirational 2
#magicskill 8 1
#end

#newmonster 6992
#copystats 351
#spr1 "Hellenika/GarnetDemon_1.tga"
#spr2 "Hellenika/GarnetDemon_2.tga"
#name "Garnet Demon"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. The Furies probably are the best representatives of the latter. Unlike their Hoplite sisters, they are stronger in lands of Turmoil and weaker in lands of Order. They formerly were anarchists and criminals that were only tolerated because of their great bloodlust and efficiency in the chaos of battle as well as of their lower upkeep cost, but since then a sense of pride in their accomplishments has emerged and now some Amazons also willingly join their ranks as elite dancers of death. Cloaked in characteristic scarlet cloth, these war maidens fight unarmored like demons with indomitable rage and cruelty, and their great mental and physical toughness allows them to resist most wounds. Those among them who are promoted to the rank of Garnet Demon for their holy thirst for carnage are even capable of training more of their own each month should they first be dubbed commanders through Gift of Reason."
#gcost 0
#rpcost 12
#hp 13
#str 12
#def 15
#mr 13
#mor 18
#enc 1
#chaospower 1
#berserk 3
#woundfend 1
#ambidextrous 3
#fear 5
#supplybonus -1
#holy
#cleararmor
#armor 148
#weapon 397
#weapon 253
#weapon 253
#montag 4138
#pillagebonus 3
#makemonsters4 4987
#makemonsters1 -4138
#inspirational 2
#magicskill 8 1
#end

#newmonster 6993
#copystats 351
#spr1 "Hellenika/GarnetSoldier_1.tga"
#spr2 "Hellenika/GarnetSoldier_2.tga"
#name "Garnet Soldier"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. The Amazon community is comprised of four tribes led by sorceresses and priestesses trained in magic. The Garnet Amazons are said to have sprung from an early breeding experiment of the Warlocks of Smouldercone. They are resistant to fire and use Blood and Fire magic as the Abysians do. They are more aggressive and arrogant than the other tribes. Thanks to their supernatural origins, they are strong of body and easy to train as soldiers. Thus, the armies of Zun are vast and disciplined."
#gcost 7
#str 10
#end

#newmonster 6994
#copystats 348
#spr1 "Hellenika/GarnetArcher_1.tga"
#spr2 "Hellenika/GarnetArcher_2.tga"
#name "Garnet Archer"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. The Amazon community is comprised of four tribes led by sorceresses and priestesses trained in magic. The Garnet Amazons are said to have sprung from an early breeding experiment of the Warlocks of Smouldercone. They are resistant to fire and use Blood and Fire magic as the Abysians do. They are more aggressive and arrogant than the other tribes. Thanks to their supernatural origins, they are strong of body and easy to train as soldiers. Thus, the armies of Zun are vast and disciplined."
#wastesurvival
#fireres 15
#gcost 8
#end

#newmonster 6995
#copystats 348
#spr1 "Hellenika/FireArcher_1.tga"
#spr2 "Hellenika/FireArcher_2.tga"
#name "Vestal Novice"
#descr "At the center of the temple-city of Zun, there is an utterly thin mountainous pike that points towards the sky like a needle piercing the clouds. This very peculiar geological formation, sacred to the Amazons of Zun, is called the Spire of Justice and towers over a vast region like the throne of a god. Its very narrow summit, covered in pure snow and only accessible by secret stairways or by flight, is an altar of utmost importance to the holy order of Vestals, mage-priestesses of Fire, Vengeance and Femininity who use it for their scrying and their sacrifices. On these natural templegrounds, maidens are trained to become Vestals and represent Amazon-kind before the whole world. Vestal Novices are too young and inexperienced to be allowed to use magic on their own, but they are remarkable sacred warriors nonetheless. These elite archers are able to conjure sacred fire to light their arrows aflame and burn their foes."
#wastesurvival
#fireres 15
#gcost 18
#prec 14
#mor 13
#mr 14
#str 12
#hp 11
#def 13
#att 12
#holy
#clearweapons
#cleararmor
#weapon 212
#weapon 1149
#armor 123
#armor 100
#end

#newmonster 6505
#copystats 368
#copyspr 368
#quadruped
#def 11
#att 14
#enc 3
#end

#newmonster 6787
#copystats 368
#copyspr 368
#firstshape 4788
#quadruped
#def 11
#att 14
#enc 3
#end

#newmonster 6788
#copyspr 612
#name "Gryphon Rider"
#descr "In the Garnet tribes, gryphons are trained from birth by warrior maidens of the temples. Gryphons are large, winged beasts of tremendous ferocity. Gryphon Riders are sacred troops and can be blessed. In addition, the Gryphon Riders of Zun are trained to be very adaptable and new riders will automatically replace their fallen brethren once the battle is over, provided that the gryphon itself still lives."
#gcost 90
#rcost 1
#ressize 2
#rpcost 46
#hp 12
#size 5
#prot 0
#mr 11
#mor 14
#str 12
#att 13
#def 13
#prec 13
#ap 15
#mapmove 20
#flying
#enc 4
#maxage 50
#fireres 15
#holy
#mounted
#wastesurvival
#mountainsurvival
#female
#weapon 357
#weapon 236
#weapon 237
#armor 7
#armor 20
#armor 2
#secondshape 4787
--#monpresentrec 4791 -- Gryphon General -- However, only the mighty Gryphon Generals are allowed to train new Zunnite Gryphon Riders, so the presence of such a commander is required in the province for their recruitment.
#reclimit 3
#cleanshape
#xploss 100
#end

#newmonster 6996
#copystats 2254 -- Berytian Militia
#name "Makedonian Citizen Hoplite"
#spr1 "Hellenika/militiapike1.tga"
#spr2 "Hellenika/militiapike2.tga"
#clearweapons
#cleararmor
#mor 9
#weapon 644
#armor 2
#armor 183
#armor 120
#descr "Makedonian citizen militia are quickly levied in times of war, and given basic equipment and bronze spears. They are given basic training, and cannot fight in dense formations like their more elite counterparts."
#rpcost 5
#end

#newmonster 6997
#copystats 201 -- Peltast
#name "Kaeonian Peltast"
#descr "Lightly armored Kaeonian Peltasts from the northern hills of Makedon form the bulk of the royal army's skirmishing capacity. The barbarians of Kaeonia were once the primary rival to the Makedonian state along with a collection of petty kingdoms, but after a decisive victory the Kaeonians became a client state to the royal kingdom."
#clearweapons
#armor 5
#armor 120
#armor 207
#weapon 643
#weapon 21
#enc 3
#skirmisher 1
#spr1 "Hellenika/peltast1.tga"
#spr2 "Hellenika/peltast2.tga"
#mapmove 14
#gcost 10
#rcost 0
#mor 10
#forestsurvival
#mountainsurvival
#end

#newmonster 6998
#copystats 139 -- Barbarian
#name "Kaeonian Falxman"
#spr1 "Hellenika/falxman1.tga"
#spr2 "Hellenika/falxman2.tga"
#descr "For the most stubborn of foes, a two-handed falx wielded by unruly Kaeonians is a good solution. Few men survive being cleaved in two from head to toe, and falxes are especially good against those who cower behind shields. Unlike the peltasts and slingers, they are not trained to fight in loose formations, and a dense formation of falxes is much more effective. The barbarians of Kaeonia were once the primary rival to the Makedonian state along with a collection of petty kingdoms, but after a decisive victory the Kaeonians became a client state to the royal kingdom."
#clear
#hp 13
#mr 9
#str 12
#att 10
#def 10
#prec 10
#enc 3
#ap 13
#weapon 1148
#armor 5
#armor 120
#mapmove 14
#gcost 10
#rcost 0
#mor 10
#forestsurvival
#mountainsurvival
#end

#newmonster 6999
#copystats 201 -- Peltast
#name "Kaeonian Slinger"
#descr "Lightly armored Kaeonian Slingers from the northern hills of Makedon are highly capable of whittling down annoying foes. The barbarians of Kaeonia were once the primary rival to the Makedonian state along with a collection of petty kingdoms, but after a decisive victory the Kaeonians became a client state to the royal kingdom."
#clearweapons
#weapon 674
#weapon 22
#armor 5
#armor 120
#armor 207
#enc 3
#spr1 "Hellenika/slinger1.tga"
#spr2 "Hellenika/slinger2.tga"
#mapmove 14
#gcost 8
#rcost 0
#mor 10
#forestsurvival
#mountainsurvival
#rpcost 3
#skirmisher 1
#end

#newmonster 7000
#spr1 "./Hellenika/pike1.tga"
#spr2 "./Hellenika/pike2.tga"
#name "Makedonian Hoplite"
#descr "Few foes can penetrate a dense formation of Makedonian longspears. Even Telkhine hoplites found it difficult to fight the kingdom of Makedon, despite their superior armor and training."
#mor 11
#hp 10
#att 10
#def 10
#enc 3
#formationfighter 2
#weapon 644
#armor 209
#armor 183
#armor 135
#gcost 10
#rcost 1
#mapmove 14
#rpcost 10
#end

#newmonster 7001
#copystats 2260 -- Berytian Lancer
#name "Makedonian Lancer"
#spr1 "./Hellenika/lancer1.tga"
#spr2 "./Hellenika/lancer2.tga"
#descr "Makedonians and Kaeonians both are famed for their well-trained cavalrymen. Many foes of Royal Makedon have died between a wall of longspears and flanking lancers."
#cleararmor
#clearweapons
#prec 11
#mapmove 20
#mounted
#weapon 1143
#weapon 645
#armor 2
#armor 183
#armor 135
#gcost 20
#rcost 1
#rpcost 24
#end

#newmonster 7002
#copystats 2260 -- Berytian Lancer
#name "Kaeonian Prodromoi"
#spr1 "./Hellenika/prodromoi1.tga"
#spr2 "./Hellenika/prodromoi2.tga"
#descr "Kaeonian skirmisher cavalry can harass heavily armed troops before going in for the kill. The barbarians of Kaeonia were once the primary rival to the Makedonian state along with a collection of petty kingdoms, but after a decisive victory the Kaeonians became a client state to the royal kingdom."
#cleararmor
#clearweapons
#prec 11
#mapmove 20
#mounted
#weapon 21
#weapon 645
#armor 2
#armor 183
#armor 135
#gcost 20
#rcost 2
#rpcost 24
#forestsurvival
#mountainsurvival
#end

#newmonster 7003
#spr1 "./Hellenika/sacredpike1b.tga"
#spr2 "./Hellenika/sacredpike2b.tga"
#name "Sacred Band Hoplite"
#descr "While the cult of heroes primarily appeals to members of the well-off warrior-aristocracy, the Sacred Band was founded as a volunteer corps of elite hoplites in order to give the lowborn the chance to fight for glory and prove their valour in the name of the awakening god. Its soldiers are famous for being armed with the longest spears in the known world, the formidable sarissas, and fight in dense ranks that highly benefit from the spiky shield formed by these extraordinary weapons."
#hp 13
#att 11
#def 11
#str 11
#enc 3
#formationfighter 2
#mor 13
#mr 10
#holy
#mapmove 14
#weapon 1200
#armor 209
#armor 100
#armor 135
#gcost 10016
#rcost 1
#rpcost 20
#end

#newmonster 7004
#name "Royal Makedonian Lancer"
#spr1 "./Hellenika/sacredcav1.tga"
#spr2 "./Hellenika/sacredcav2.tga"
#descr "For the sons of petty nobles and barbarian princes of client states, service in the Royal Lancers is one of the quickest paths to fame and glory. It is rumored that the best among them are initiated into the hero cult, but the lancer corps suffers enough casualties and sudden reassignments that a few missing men are seldom noticed."
#size 3
#ressize 2
#hp 13
#mor 13
#mr 12
#str 10
#att 12
#def 12
#enc 4
#ap 22
#mapmove 20
#holy
#mounted
#weapon 1144
#weapon 645
#weapon 56
#armor 2
#armor 100
#armor 135
#gcost 10025
#rcost 1
#rpcost 48
#end

#newmonster 7005
#name "Knossian Raider"
#descr "Many Knossians turn to piracy and banditry and are employed by the nobles and Bull Kings as mercenaries to harass their foes."
#spr1 "./Hellenika/raider1.tga"
#spr2 "./Hellenika/raider2.tga"
#chaosrec 1
#gcost 12
#rpcost 9
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mr 10
#mor 9
#enc 3
#pillagebonus 1
#incunrest 3
#swimming
#stealthy 0
#weapon 645 -- bronze sword
#weapon 21 -- javelin
#armor 5
#armor 120
#armor 1
#nametype 107
#end

#newmonster 7006
#name "Knossian Spearman"
#descr "In Knoss the axe rather than the spear is the most popular melee weapon, but spearmen are still occasionally trained and used in situations where a long weapon proves more convenient."
#spr1 "./Hellenika/spearman1.tga"
#spr2 "./Hellenika/spearman2.tga"
#gcost 10
#rpcost 9
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mr 10
#mor 10
#enc 3
#weapon 643
#armor 2
#armor 142 -- bronze scale cuirass
#armor 135 -- bronze cap
#nametype 107
#end

#newmonster 7007
#name "Knossian Archer"
#spr1 "./Hellenika/archer1.tga"
#spr2 "./Hellenika/archer2.tga"
#descr "The archers of Knoss use more advanced bows than those of most other nations and are trained to fire while using a small shield. They are renowned for their skill and are considered one of the greatest assets of the royal army."
#gcost 10
#rpcost 9
#hp 10
#str 10
#att 10
#def 10
#mr 10
#mor 10
#enc 3
#nametype 107
#prec 11
#weapon 674 -- bronze dagger
#weapon 264 -- composite bow
#armor 5
#armor 120
#armor 1
#end

#newmonster 7008
#name "Knossian Axeman"
#descr "The common soldiers of Knoss use light one-handed axes, shields and medium armor. Axes are an important symbol of Knossian culture, and thus axemen have better morale than spearmen."
#spr1 "./Hellenika/axeman1.tga"
#spr2 "./Hellenika/axeman2.tga"
#gcost 10
#rpcost 9
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mr 10
#enc 3
#armor 2
#armor 142 -- bronze scale cuirass
#armor 135 -- bronze cap
#nametype 107
#mor 11
#weapon 646 -- bronze hatchet
#end

#newmonster 7009
#name "Knossian Royal Axeman"
#descr "The elite of the Knossian army are equipped with heavy armor and formidable axes of archaic design. They are tasked with acting as both shock troops and bodyguards for the nobles."
#spr1 "./Hellenika/royalaxeman1.tga"
#spr2 "./Hellenika/royalaxeman2.tga"
#prec 10
#mr 10
#enc 3
#nametype 107
#gcost 18
#rpcost 16
#hp 12
#str 11
#att 11
#def 11
#mor 13
#bodyguard 2
#weapon 1240
#armor 100 -- bronze cuirass
#armor 135
#end

#newmonster 7010
#name "Temple Dancer"
#descr "Dancing is an important part of many Knossian rituals, especially those involving sacrifice both animal and human. Sacred dancers are trained in every temple of the kingdom and in battle their agility is sometimes useful to dazzle beasts and stun foes, although their total lack of armor makes them very vulnerable to projectiles. The result of an esoteric training whose origins are lost to time, their hypnotic motions are capable of forcing their living witnesses to sleep."
#spr1 "./Hellenika/dancer1.tga"
#spr2 "./Hellenika/dancer2.tga"
#gcost 13
#rpcost 9
#hp 11
#str 10
#att 11
#def 15
#prec 10
#mr 11
#mor 13
#enc 2
#ap 14
#weapon 1141 -- fatiguing blow
#holy
#swimming
#animalawe 1
#skirmisher 1
#formationfighter -2
#itemslots 12288
#poorleader
#nametype 107
#sleepaura 5
#end

#newmonster 7011
#name "Bull Warrior"
#descr "Lesser noblemen of Knoss not fit to be mage-priests are trained as sacred warriors instead. They are not as large or strong as the true minotaurs of Pangaea, but they are no less ferocious and are still much stronger and tougher than common men. In battle they enjoy goring their opponents with their horns. Like all Knossian nobles, as the bearers of the curse they are known to eat human flesh in great feasts, causing constant suffering to the population; but as the lowest ones in the ranks of nobility, they are only permitted to do so outside the capital - whose children belong to the tyrants and their lieutenants - and, being allowed by their kings to keep the possessions of those they murder, they must pay for their own expenses in times of war and therefore no longer cost upkeep when they leave it."
#spr1 "./Hellenika/warrior1.tga"
#spr2 "./Hellenika/warrior2.tga"
#gcost 26
#rpcost 20
#hp 15
#str 13
#att 12
#def 10
#prec 10
#prot 2
#mr 11
#mor 14
#enc 2
#berserk 4
#holy
#weapon 1240
#weapon 331 -- gore
#armor 100
#armor 135
#nametype 107
#pillagebonus 1
#bodyguard 2
#foreignshape 4658
#end

#newmonster 6658
#name "Bull Warrior"
#descr "Lesser noblemen of Knoss not fit to be mage-priests are trained as sacred warriors instead. They are not as large or strong as the true minotaurs of Pangaea, but they are no less ferocious and are still much stronger and tougher than common men. In battle they enjoy goring their opponents with their horns. Like all Knossian nobles, as the bearers of the curse they are known to eat human flesh in great feasts, causing constant suffering to the population; but as the lowest ones in the ranks of nobility, they are only permitted to do so outside the capital - whose children belong to the tyrants and their lieutenants - and, being allowed by their kings to keep the possessions of those they murder, they must pay for their own expenses in times of war and therefore no longer cost upkeep when they leave it."
#spr1 "./Hellenika/warrior1.tga"
#spr2 "./Hellenika/warrior2.tga"
#gcost 26
#rpcost 20
#hp 15
#str 13
#att 12
#def 10
#prec 10
#prot 2
#mr 11
#mor 14
#enc 2
#berserk 4
#popkill 1
#holy
#weapon 1240
#weapon 331 -- gore
#armor 100
#armor 135
#nametype 107
#addupkeep -1000
#pillagebonus 1
#bodyguard 2
#homeshape 5011
#end

#newmonster 6770
#copystats 612
#copyspr 612
#gcost 50
#mountedhumanoid
#end

#newmonster 6771
#copystats 370
#copyspr 370
#gcost 22
#mountedhumanoid
#end

#newmonster 6772
#copystats 369
#copyspr 369
#gcost 37
#mountedhumanoid
#end

#newmonster 7012
#spr1 "./Hellenika/Wind_Tribe_Archer_1.tga"
#spr2 "./Hellenika/Wind_Tribe_Archer_2.tga"
#name "Wind Tribe Archer"
#descr "Unlike the Amazons, the carefree people of the Wind Tribe are not warriors and prefer times of peace. However, they still are well-reputed archers, mainly because they have long lived as hunter-gatherers. By ancient custom, each boy or girl who doesn't wish to live a sedentary life must craft his or her own bow at the age of thirteen, and then hunt his first prey alone with it; once he or she succeeds, a great party is held with the rest of the clan, and the young hunter is considered an adult from that day on, albeit a very inexperienced one. Most members of the Wind Tribe also love to keep beautiful feathers as decorative talismans which they wear proudly on their clothes or in their hair, both as a spiritual habit and an aesthetic one; this is also done for arrows, and each one is adorned with a uniquely colored fletching."
#armor 120
#armor 5
#weapon 9
#weapon 264
#hp 10
#size 2
#prot 0
#mr 9
#mor 11
#str 10
#att 10
#def 10
#prec 12
#ap 12
#mapmove 14
#enc 3
#maxage 50
#gcost 11
#rcost 1
#rpcost 7
#end

#newmonster 7013
#copystats 450 -- Horse Brother
#spr1 "./Hellenika/Wind_Tribe_Cavalry_1.tga"
#spr2 "./Hellenika/Wind_Tribe_Cavalry_2.tga"
#name "Wind Tribe Cavalry"
#descr "Although the Wind Tribe now worships birds rather than horses, it hasn't abandoned all its Horse Tribe roots, far from it; riding a horse across the steppes is the closest one gets to flying, and the Tribe's legends say that, if the sacred friendship between a horse and his rider is strong enough, they might become one with the wind. Horses are an integral part of the Wind Tribe's everyday life in the vast plains that surround Thalamanth. There are a few Wind Tribe people that live a sedentary life, building small relays for travelers and their horses, where both can rest in beds or stables. But most are nomads, and moving from one relay to another, they explore the lands and live together with their animals. In the Wind Tribe, horses are thought to have a soul like humans and are almost considered their equals. Therefore, it is no surprise that the Wind Tribe also uses horses in warfare."
#att 10
#mr 9
#prec 9
#weapon 1
#weapon 264
#armor 11
#armor 1
#armor 120
#gcost 23
#rcost 1
#rpcost 20
#mountedhumanoid
#end

#newmonster 7014
#spr1 "./Hellenika/amazon_infantry_1.tga"
#spr2 "./Hellenika/amazon_infantry_2.tga"
#name "Crystal Infantry"
#descr "In Thalamanth, Amazons are sacred warriors who dedicate their life to the defense of the Crystal Ark. Therefore, their whole culture is centered around warfare and prowess in combat. Although the Crystal Tribe's warriors usually much prefer fighting from afar with a bow or riding on the back of a pegasus, some elite infantry has always been trained to protect the city. All of them are very well trained and wear heavy armor."
#hp 13
#size 2
#prot 0
#mr 11
#mor 13
#str 11
#att 12
#def 13
#prec 12
#enc 3
#mapmove 14
#ap 12
#gcost 10014
#rcost 1
#rpcost 16
#weapon 1
#armor 8
#armor 20
#armor 2
#maxage 50
#bodyguard 3
#shockres 5
#female
#holy
#end

#newmonster 7015
#spr1 "./Hellenika/ThunderGuard.tga"
#spr2 "./Hellenika/ThunderGuard2.tga"
#name "Thunder Guard"
#descr "Thunder Guards are fanatical Amazons that have received the wisdom and authority of one of Thalamanth's Demi-Gods. They share the Crystal Infantry's elite combat skills, but in addition their armaments are enchanted with divine lightning, which makes them even more formidable warriors. They can be recruited in any fort, provided that one of Thalamanth's three Demi-Gods is bringing justice to the kingdom."
#hp 13
#size 2
#prot 0
#mr 11
#mor 13
#str 11
#att 12
#def 13
#prec 12
#enc 3
#mapmove 14
#ap 12
#gcost 10014
#rcost 1
#rpcost 16
#weapon 278
#armor 8
#armor 20
#armor 2
#maxage 50
#bodyguard 3
#shockres 5
#female
#holy
#overcharged 8
#ownsmonrec -4160
#stormpower 1
#end

#newmonster 7016
#spr1 "Hellenika/CrystArcher1.tga"
#spr2 "Hellenika/CrystArcher2.tga"
#name "Amazon Archer"
#descr "In Thalamanth, Amazons are sacred warriors who dedicate their life to the defense of the Crystal Ark. Therefore, their whole culture is centered around warfare and prowess in combat. Crystal Amazons are excellent archers but usually unfit for melee. In addition, those of Thalamanth received elite training and are able to strike with the bow even in the harshest of storms."
#hp 10
#size 2
#prot 0
#mr 11
#mor 11
#str 9
#att 11
#def 12
#prec 13
#enc 3
#mapmove 14
#ap 13
#gcost 10012
#rcost 1
#rpcost 15
#weapon 264
#weapon 9
#armor 5
#armor 120
#maxage 50
#female
#holy
#stormimmune
#end

#newmonster 7017
#copystats 1074
#spr1 "./Hellenika/Amazon_Wind_Rider_1b.tga"
#spr2 "./Hellenika/Amazon_Wind_Rider_2b.tga"
#name "Crystal Maiden"
#descr "In the Crystal tribes, pegasi are trained from birth by warrior maidens of the temples. There, the pegasi learn to trust no one but their masters. This tradition lives the strongest in Thalamanth, where some of the best wind riders of the world may be found. Both master archers and riders, the sacred Crystal Maidens are the elite of Thalamanth's military. They are known to ritually cut off their breasts, sacrificing their femininity as a symbol of holy fervor and for the sake of martial efficiency, an affliction from which they can heal all the while retaining its benefits. Fast and nimble, their pure mounts are disciplined and trained to attack with both hooves and wings. Furthermore, their handlers do not lack skills themselves. Their advanced techniques allow them to very swiftly swap their weapons and sometimes even shoot arrows while engaged in melee. In addition, they are trained to fly, fight and strike with the bow even in the harshest of storms. While particularly vulnerable to arrows and very lightly armored compared to Arcoscephale's elites, who also are physically stronger than them, they still are better protected than the pegasus riders of independent Crystal tribes and by far outclass them in aptitude. Thanks to their great mental rectitude and willpower, they are able to resist magic more easily than most troops and make very efficient mage-hunters on the battlefield. Ever-graceful knights of the skies, they embody the Amazons' ideals and are the pride and spearhead of the nation."
#hp 11
#mr 16
#mor 15
#str 12
#prec 15
#def 17
#att 13
#enc 2
#mapmove 28
#ap 32
#weapon 357
#weapon 56
#weapon 1198
#weapon 1109
#armor 7
#armor 20
#armor 1
#female
#stormimmune
#shockres 5
#gcost 45
#mountedhumanoid
#startingaff 8388608
#end

#newmonster 7018
#copystats 367
#spr1 "./Hellenika/ThunderRider_1b.tga"
#spr2 "./Hellenika/ThunderRider_2b.tga"
#name "Wind Maiden"
#descr "In the Crystal tribes, pegasi are trained from birth by warrior maidens of the temples. There, the pegasi learn to trust no one but their masters. This tradition lives the strongest in Thalamanth, where some of the best wind riders of the world may be found. Wind Maidens are similar to Crystal Maidens but lack the expertise of their elder sisters. Like them, they are sacred troops and can be blessed. Fast and nimble, their pure mounts are disciplined and trained to attack with both hooves and wings. Furthermore, their handlers do not lack skills themselves. Their advanced techniques allow them to very swiftly swap their weapons and sometimes even shoot arrows while engaged in melee. In addition, they are trained to fly, fight and strike with the bow even in the harshest of storms. While particularly vulnerable to arrows and very lightly armored compared to Arcoscephale's elites, who also are physically stronger than them, they still are better protected than the pegasus riders of independent Crystal tribes and by far outclass them in aptitude. Thanks to their great mental rectitude and willpower, they are able to resist magic more easily than most troops and make very efficient mage-hunters on the battlefield. Ever-graceful knights of the skies, they embody the Amazons' ideals and are the pride and spearhead of the nation."
#stormimmune
#gcost 45
#shockres 5
#mr 14
#mor 13
#ap 32
#def 15
#str 10
#rpcost 58
#weapon 357
#weapon 56
#weapon 1198
#weapon 1110
#armor 6
#armor 20
#armor 1
#mountedhumanoid
#end

#newmonster 7019
#spr1 "./Hellenika/Aurae_Warrior_1.tga"
#spr2 "./Hellenika/Aurae_Warrior_2.tga"
#name "Aurae Warrior"
#descr "Aurae are lesser divinities of the wind that manifest themselves as incredibly beautiful women. Few mortals would dream of harming an Aurae. Aurae very rarely show themselves at other times than in the sweetest of twilights, except to wreak vengeance upon those who desecrate the sky, the poetry of the breeze or the peaks that are their sanctuaries. In the mountains of Thalamanth, the two best known of these primeval natural sanctuaries, one facing the Dusk and the other facing the Dawn, predate even the first human settlers; but another one can be found hidden on the summit of Mount Ida, in Arcadeia. The Aurae that live here are worshipped by Amazons and Arcadeians alike as the incorruptible, living embodiments and benevolent protectors of purity, gentleness and spontaneity unrestrained. When they descend from their remote homes to punish the unfaithful, they wear gleaming bronze armor and their mere presence is enough to heighten the hearts of Arcadeians, Amazons and Wind Tribe warriors alike. Since their physical bodies are as translucent and evanescent as their veilings of wind-borne glamour, they are often mistaken for ghosts and are very difficult to harm. Wind stills itself at their silent command and they are ever-graceful even in the harshest of storms. As the natural enemies of unfair violence and unclean magic, they will always answer the call of the Kindly Ones when it is sounded and their recruitment cost will be vastly reduced in such circumstances. So light that they only require morning dew and whispering poetry for their sustenance, they are free from most earthly needs and neither cost upkeep nor need to eat."
#hp 10
#size 2
#mr 15
#mor 15
#str 11
#att 13
#def 13
#prec 12
#enc 2
#mapmove 28
#ap 12
#maxage 1000
#weapon 645
#armor 100
#armor 123
#armor 2
#gcost 80
#addupkeep -80
#rpcost 1
#rcost -23
#standard 1
#female
#illusion
#stormimmune
#flying
#awe 4
#holy
#reclimit 2
#shockres 5
#enchrebate50 80
#neednoteat
#end

#newmonster 6876
#spr1 "./Hellenika/Amazon_Initiate_1.tga"
#spr2 "./Hellenika/Amazon_Initiate_2.tga"
#name "Amazon Initiate"
#descr "When a woman who wasn't born an Amazon wishes to become one, she can achieve this goal provided that she is not lacking in faith or bravery. Amazon Initiates mostly come from the Wind Tribe, which they abandon joyfully to start a new life, and often dream of becoming the Amazon ideal of an inflexible sacred warrior, thus emulating both the fighting and living styles of the Amazon Exemplars. To test their courage and purity, they are not allowed to wear armor or use a bow. Those who distinguish themselves in battle may become sacred Exemplars and lead their sisters to victory. Temples are usually needed to educate them but Pythias also teach them wherever they go."
#hp 10
#prot 0
#mr 11
#mor 12
#str 9
#att 12
#def 13
#prec 11
#enc 3
#mapmove 18
#ap 12
#maxage 50
#gcost 10
#weapon 651
#weapon 21
#armor 2
#berserk 2
#female
#reqtemple
#xpshape 45
#rpcost 12
#stormimmune
#end

#newmonster 6877
#spr1 "./Hellenika/AmazonInitiateVeteran.tga"
#spr2 "./Hellenika/AmazonInitiateVeteran2.tga"
#name "Amazon Exemplar"
#descr "The Exemplars are those among the Amazon Initiates who passed all trials set before them, successfully proved their worth on the battlefield, and chose to continue fighting just as they did before, as a testament of their unbreakable faith. They embody the eternal legacy of the first of their order, the Heroine, whose name has been lost to time, but whose great deeds and exceptional faith will never be forgotten. They are incredibly fierce sacred warriors and all Initiates admire them not only as teachers but as paragons of what it means to be an Amazon. Blessing them with the holy sacraments of a new Divine Name allows them to become low-ranking priests able to educate four Initiates and one Exemplar each month."
#hp 12
#prot 0
#mr 15
#mor 15
#str 11
#att 14
#def 15
#prec 13
#enc 2
#mapmove 18
#ap 12
#maxage 50
#gcost 10
#rcost 1
#weapon 651
#weapon 21
#armor 2
#berserk 1
#holy
#female
#magicskill 8 1
#makemonsters4 4876
#makemonsters1 4877
#userestricteditem 8069
#shockres 5
#woundfend 1
#twiceborn 6675
#stormimmune
#inspirational 2
#end

#newmonster 7020
#spr1 "./Hellenika/Bird_Warrior_2.tga"
#spr2 "./Hellenika/Bird_Warrior_1.tga"
#name "Wind Tribe Bird Warrior"
#descr "Bird Warriors are wild and stealthy warriors of the Wind Tribe that emerged in very recent times. The feather cloaks they don are enchanted by the magical knowledge taught to their shamans by the Cloud Sages and allow them to fly. They wield javelins, spears and daggers, but wear no real armor. An Ornithomancer or a Cloud Sage must be present in the province to recruit them. Dai Tengus, Silver Hawk Kings and Cloud Dragons also make good teachers."
#hp 12
#size 2
#prot 0
#mr 10
#mor 12
#str 11
#att 12
#def 12
#prec 12
#enc 3
#mapmove 20
#ap 12
#maxage 50
#weapon 21
#weapon 4
#weapon 9
#armor 44
#armor 120
#gcost 11
#rcost 1
#rpcost 8
#stealthy 0
#ambidextrous 3
#mountainsurvival
#forestsurvival
#flying
#reclimit 10
#monpresentrec -4161
#patrolbonus 2
#end

#newmonster 7021
#spr1 "Hellenika/Triliaxian_archer_1.tga"
#spr2 "Hellenika/Triliaxian_archer_2.tga"
#name "Triliaxian Archer"
#descr "Before the last great war, Triliaxians and Arcoscephaleans alike saw archery as a cowardly and foolish pursuit. But then the forces of Arcosephale and its allies laid siege to the Divine Citadel for ten long and perilous years, and even the elite Myrmidons were powerless before the vast ranks of their foes. It was Pareas-Aleksandros, prince of Triliax and then commander of the armies, who first went to the walls armed with a bow, and his success against the enemy champions was such that the invaders' forces soon faced a withering wall of arrows with each advance, each successful volley inspiring more of the defenders to take up the bow. Pareas-Aleksandros has since been cast down and discredited for his role in bringing the ultimately disastrous war to Triliax, and archers are still mocked and despised in Arcosephale, but none in Triliax will ever disparage them again. Triliaxian archers wear leather armor and crested helmets dyed with the colors of the sea."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 10
#mor 8
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 12
#maxage 50
#weapon 9
#weapon 23
#armor 5
#armor 162
#gcost 10010
#rcost 1
#rpcost 9
#end

#newmonster 7022
#copystats 201 -- Peltast
#spr1 "Hellenika/TriPeltast1.tga"
#spr2 "Hellenika/TriPeltast2.tga"
#name "Triliaxian Peltast"
#descr "The peltasts are the light infantry of Triliax. They wear little armor and are mainly used as javelin throwers."
#end

#newmonster 7023
#copystats 199 -- Cardaces
#spr1 "Hellenika/Triliaxian_cardaces_1.tga"
#spr2 "Hellenika/Triliaxian_cardaces_2.tga"
#name "Triliaxian Cardaces"
#descr "The cardaces are essentially light infantry without javelins. They are somewhat better armed than the peltasts but lack the training of the heavier troops."
#end

#newmonster 7024
#copystats 1077 -- Myrmidon
#spr1 "Hellenika/TriliaxianMyrmidon_1.tga"
#spr2 "Hellenika/TriliaxianMyrmidon_2.tga"
#name "Triliaxian Myrmidon"
#descr "The Myrmidons are the elites of the Divine Citadel. After the Arcoscephalean Myrmidons turned the tide of several battles against Triliax in previous wars, Triliax's military adopted the unit as its own. Since then, it has become a staple of Triliaxian tactics and the proud Triliaxian Myrmidons certainly don't think of themselves as mere epigones. Like all Myrmidons, they wield short swords and carry shields, but unlike others they also bear magical tattoos that remind them of the sacred horses of Trilios, children of foam, a great symbol of nobility that strengthens them when a High Priest of the Sea accompanies them."
#horsetattoo 1
#gcost 15
#rpcost 21
#end

#newmonster 7025
#copystats 3106 -- Neodamode Hoplite
#spr1 "Hellenika/RoyalHoplite_1.tga"
#spr2 "Hellenika/RoyalHoplite_2.tga"
#name "Royal Hoplite"
#descr "Royal Hoplites are elite highblood warriors whose mission is to protect the Basilei and their favourites at all costs. They share most of the Triliaxian Myrmidons' abilities but are generally more skilled, are trained as bodyguards and are equipped as the formidable hoplites of ancient Telkhinis. They can however be recruited only in provinces where a Basileus is present."
#str 13
#att 14
#def 13
#mor 15
#mr 12
#hp 12
#bodyguard 3
#horsetattoo 1
#gcost 15
#rpcost 21
#reclimit 3
#monpresentrec -4115
#end

#newmonster 6900
#copyspr 1704 -- Centaur Warrior
#name "Centaur Slave"
#descr "Although horses are very rare in the region of Triliax, the Citadel's Basilei have found a way to solve this problem. In its old wars against the wild forces of Pangaea before the founding of its sacred walls and civilization, Triliax had the opportunity to enslave some fierce centaur warriors. Since then, the centaur slaves of Triliax have lost some of their skill due to captivity, but they still are valuable both in warfare and for hard labor. Like most slaves, they have poor morale because they lack training, fight unwillingly and are eager to free themselves; and for the same reasons, the enslaved centaurs have also lost their ability to go berserk in battle or to hide in enemy territory, as well as their knowledge of the forest, which they no longer can call home. However, even though they are weaker than their wild counterparts, they are relatively cheap to field, and they still are valuable for their natural quickness, strength and endurance."
#hp 18
#size 3
#prot 3
#mr 12
#mor 8
#str 13
#att 10
#def 13
#prec 12
#enc 3
#mapmove 3
#ap 30
#maxage 90
#heal
#slave
#weapon 357
#weapon 55
#armor 103
#armor 2
#armor 119
#gcost 30
#rcost 1
#rpcost 18
#ressize 2
#itemslots 13446
#end

#newmonster 7026
#spr1 "Hellenika/Cyclops1.tga"
#spr2 "Hellenika/Cyclops2.tga"
#name "Cyclops of the Coast"
#descr "Earthen Cyclopes are one-eyed and stone-skinned giants sprung from the roots of antediluvian mountains, and those from Triliax are even more monstrous and frightening than others of their kin. Some have always lived along the steep and rocky coasts of Triliax, even before the fall of Therodos. They also are the reason why this region remained uncivilized until the arrival of Trilios: their great violence is frightening to men, and many sailors and adventurers found death by unexpectedly encountering a Cyclops' den. The hills of Dardanum are a sacred place to Cyclopes: rather than being of natural origins, they are in fact old tumuli that serve as a cemetery for their kind. Conversely, Cyclopes are sacred to the people of Triliax: as the most perfect of all monsters, they represent all monsterkind and therefore one of the three aspects of the Wrath of the God, which is why they bear mystical tattoos shaped like the hydra and reminiscent of the Living Maelstrom. Without the monster cult of Triliax, never could men have built a kingdom in the region of Dardanum; but since Cyclopes and Triliaxians serve the same God, they cooperate and form a single force. Although they often fight in small numbers with human armies, in times of great need they also form the Monstrous Phalanxes and devastate everything in their path. Due to their size, they are very gluttonous creatures. In battle, they use sheer force against their enemies and crush them with primitive clubs of giant size, and they are able to destroy or repair stone fortifications with ease. A Cyclops commander is required to train them."
#nametype 107
#hp 75
#size 5
#prot 15
#mr 9
#mor 15
#str 25
#att 11
#def 11
#prec 7
#enc 2
#mapmove 3
#ap 14
#maxage 200
#fireres 15
#poisonres 15
#eyes 1
#fear 5
#mountainsurvival
#stonebeing
#weapon 165
#armor 44
#holy
#gcost 95
#rcost 1
#rpcost 25
#supplybonus -5
#siegebonus 5
#castledef 5
#reclimit 1
#monpresentrec -4112
#snaketattoo 2
#end

#newmonster 6519
#copystats 1425 -- Troll Guard
#spr1 "Hellenika/SeaTrollArmor1.tga"
#spr2 "Hellenika/SeaTrollArmor2.tga"
#name "Troll Guard"
#descr "Troll guards are sea troll elites. They are robust humanoid amphibians of immense size. They are larger than ordinary trolls, but their skin is softer. Sea trolls are known to regenerate wounds. The Troll Guards of Triliaxian underwater colonies are equipped with masterwork bronze armaments, including a massive plate armor called the Dendra Panoply, and they can either be recruited with a temple and a laboratory or summoned."
#reclimit 1
#reqtemple
#reqlab
#rpcost 18
#bodyguard 3
#att 13
#cleararmor
#armor 879
#armor 123
#end

#newmonster 7027
#copystats 517 -- Black Hawk
#copyspr 517
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind look a lot like black hawks and are very balanced in their combat abilities."
#montag 4122
#stealthy
#nametype 239
#mor 9
#prec 10
#hp 5
#def 13
#ap 8
#prot 1
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7028
#spr1 "./Hellenika/BirdF5_1.tga"
#spr2 "./Hellenika/BirdF5_2.tga"
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. While best known for their colorful green feathers, birds of this specific kind are also exceptionally clever and can even master human speech. They are able to comprehend and follow complex strategies and have a force of will comparable to that of man. However, they are poorer fighters than other Warriors of the Clouds, both defensively and offensively."
#montag 4122
#gcost 0
#rcost 1
#hp 6
#size 2
#prot 0
#mr 9
#mor 11
#str 5
#att 7
#def 11
#prec 8
#enc 3
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#weapon 753
#weapon 404
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7029
#spr1 "./Hellenika/BirdU7_1.tga"
#spr2 "./Hellenika/BirdU7_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind are well known for their very bright blue feathers and their especially complex songs. They are loved by other birds and their presence will increase their morale, but they are also a lot easier to kill because of their lack of reflexes and of their frailer body."
#montag 4122
#standard 1
#hp 4
#mor 9
#def 10
#stealthy
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7030
#spr1 "./Hellenika/BirdF7_1.tga"
#spr2 "./Hellenika/BirdF7_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind thrive the most during spring because of climate and their diet, but are weaker during fall when their preferred environment disappears completely. They are also very good flyers and will evade half of all projectiles that target them."
#montag 4122
#springpower 70
#stealthy
#mor 9
#hp 6
#def 13
#gcost 0
#rcost 1
#nametype 239
#airshield 50
#rpcost 1
#bird
#end

#newmonster 7031
#spr1 "./Hellenika/BirdB_1.tga"
#spr2 "./Hellenika/BirdB_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind thrive the most during summer because of climate and their diet, but are weaker during winter when their preferred environment disappears completely. They are also very good flyers and will evade half of all projectiles that target them."
#montag 4122
#summerpower 70
#stealthy
#mor 9
#hp 6
#def 13
#gcost 0
#rcost 1
#nametype 239
#airshield 50
#rpcost 1
#bird
#end

#newmonster 7032
#spr1 "./Hellenika/BirdA_1.tga"
#spr2 "./Hellenika/BirdA_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind thrive the most during fall because of climate and their diet, but are weaker during spring when their preferred environment disappears completely. They are also very good flyers and will evade half of all projectiles that target them."
#montag 4122
#fallpower 70
#stealthy
#mor 9
#hp 6
#def 13
#gcost 0
#rcost 1
#nametype 239
#airshield 50
#rpcost 1
#bird
#end

#newmonster 7033
#spr1 "./Hellenika/BirdC2_1.tga"
#spr2 "./Hellenika/BirdC2_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind thrive the most during winter because of climate and their diet, but are weaker during summer when their preferred environment disappears completely. They are also very good flyers and will evade half of all projectiles that target them."
#montag 4122
#winterpower 70
#stealthy
#mor 9
#hp 6
#def 13
#gcost 0
#rcost 1
#nametype 239
#airshield 50
#rpcost 1
#bird
#end

#newmonster 7034
#spr1 "./Hellenika/BirdY_1.tga"
#spr2 "./Hellenika/BirdY_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind are known for their untameable temperament and their love of the most violent winds and the most chaotic weather. Storms not only don't impede their movements, but they also let the birds feel stronger. These birds are also aggressive hunters who fight with both their beak and talons, but are physically lighter and more vulnerable."
#montag 4122
#stormpower 1
#weapon 753
#weapon 408
#weapon 404
#hp 4
#mor 9
#def 13
#stealthy
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7035
#spr1 "./Hellenika/BirdE_1.tga"
#spr2 "./Hellenika/BirdE_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind are known for their love of darkness and prefer to live during the night. They feel stronger when all light is dim, and the dark doesn't hinder their eyes. They are also very stealthy and have a stronger will than other Warriors of the Clouds, but they are weaker fighters, both more vulnerable to strong hits and less effective offensively. They fight with great cunning and will always attack their target's eyes first."
#montag 4122
#darkvision 100
#darkpower 1
#mr 12
#hp 4
#mor 9
#str 3
#def 13
#stealthy 40
#weapon 753
#weapon 1185
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7036
#spr1 "./Hellenika/BirdH_1.tga"
#spr2 "./Hellenika/BirdH_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind are known for the chaos they bring everywhere they go. Acts of vandalism are numerous near them and their lifestyle quickly deteriorates the environment. They are also extremely savage in combat and will go berserk when hurt."
#montag 4122
#hp 8
#def 13
#mor 9
#berserk 2
#incunrest 5
#stealthy
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7037
#spr1 "./Hellenika/BirdA2_1.tga"
#spr2 "./Hellenika/BirdA2_2.tga"
#copystats 517 -- Black Hawk
#name "Warrior of the Clouds"
#descr "There are many different kinds of Warriors of the Clouds. Birds of this specific kind are known for their great resilience. They can endure more hits than their brethren and are able to quickly recover from their wounds. However, they rely too much on their physical abilities to resist the elements and are more vulnerable to them as well as magic."
#montag 4122
#stealthy
#hp 10
#mor 9
#def 13
#heal
#mr 3
#fireres -6
#coldres -6
#shockres -6
#poisonres -6
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 7038
#spr1 "./Hellenika/BirdL3_1.tga"
#spr2 "./Hellenika/BirdL3_2.tga"
#copystats 517 -- Black Hawk
#name "Bird of Gold"
#descr "Birds of Gold are regular, wild birds born with a miraculous plumage of pure gold. Since birds generally love all that is shiny and revere the Sun, those blessed with such a boon are considered sacred by most bird tribes. While being frailer and needing more food than most birds, and while still being undisciplined and afraid of violence, which makes them poor combatants, they can be blessed by the priests of Nephelococcygia and their metallic feathers protect them from all elements. In addition, they also know how to project their feathers in a swarm of deadly darts, thus attacking all soldiers in an entire zone at short distance. Birds of Gold are more frequent in Nephelococcygia than in nature, so Warriors of the Clouds sometimes happen to be Birds of Gold."
#montag 4122
#hp 5
#mor 9
#mr 13
#def 12
#prec 10
#att 9
#holy
#weapon 753
#weapon 1183
#weapon 1188
#fireres 5
#coldres 5
#shockres 5
#poisonres 5
#stealthy
#gcost 12
#rcost 1
#supplybonus -1
#addupkeep -6
#nametype 239
#airshield 20
#rpcost 1
#bird
#end

#newmonster 6880
#copystats 517 -- Black Hawk
#copyspr 517
#name "Warrior of the Clouds"
#descr "Warriors of the Clouds are very simple birds that heard the call of Nephelococcygia and answered it. Since most flying species are represented among them, they are a perfect testimony of the incredible diversity of the people of the birds. This holds true for many different traits: external appearance, physical prowess, personality, intelligence... Thus, one never knows what kind of bird will show up when recruiting a Warrior of the Clouds, and might even get lucky enough to find a Bird of Gold instead. While they are not as clever as a man, and while some are indeed utterly stupid, many Warriors of the Clouds are smart enough to understand basic abstract concepts. As a whole, the birds are far smarter than most humans will admit, and their many songs preserve a rich cultural tradition. Although they usually act more with spontaneity than with reflexion, most Warriors of the Clouds understand that they fight for their kin's supremacy as a whole, or at least for the survival and prosperity of their tribe. A great pride of being a part of the Nation of the Birds links them together and incites to go to war. Still, they are but animals and will flee at the slightest reversal of fortune in battle. They are mostly unable to understand complex strategies, and only a great mass of such birds can overcome a squad of well-trained and equipped men. The better side of things is that they are extremely cheap and wild enough not to cost any upkeep."
#firstshape -4122
#gcost 2
#rcost 1
#mor 9
#prec 10
#hp 5
#def 13
#ap 8
#prot 1
#stealthy
#nametype 239
#airshield 20
#rpcost 1
#addupkeep -2
#bird
#end

#newmonster 7039
#spr1 "./Hellenika/BirdQ_1.tga"
#spr2 "./Hellenika/BirdQ_2.tga"
#name "Warrior of Prey"
#descr "Warriors of Prey are regular bird predators, most of the time great falcons, that have become accustomed not only to hunting but also to killing for the sake of the Republic in the Clouds. Unlike regular Warriors of the Clouds, they truly deserve their title of warriors, although when compared to armored and experienced humans they still are pretty weak. Nevertheless, they are able to withstand a few wounds and continue fighting, are nimble enough to dodge most hits, and are clever enough to follow an actual strategy. They also need more sustenance than most birds, and thus require more supplies."
#gcost 9
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 11
#str 7
#att 11
#def 15
#prec 8
#enc 3
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#swampsurvival
#wastesurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#addupkeep -4
#supplybonus -1
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#chaosrec 1
#end

#newmonster 7040
#spr1 "./Hellenika/DeadTree_1.tga"
#name "Ashen Tree"
#descr "Ashen Trees are the empty shells of long-dead Sky Trees. Having lost their benevolence at the same time as their life and consciousness, they are of no interest to most birds and aren't respected as anything more than simple carcasses. Still, they make good shelters and can be used defensively in case of war, even more so due to the vines and thorns that grow around them. They are also used as occult symbols and meeting places by Wyrd Birds and their masters, which means that an Ashen Tree must be present in the province in order to recruit them."
#nametype 145
#hp 100
#size 6
#prot 15
#mr 12
#mor 50
#str 14
#att 8
#def 0
#prec 8
#enc 0
#mapmove 0
#ap 0
#noleader
#maxage 5000
#older 2500
#fireres -15
#poisonres 25
#eyes 0
#blind
#batstartsum5d6 "Warrior of Prey"
#battlesum4 "Warrior of Prey"
#immobile
#bluntres
#pierceres
#neednoteat
#inanimate
#miscshape
#itemslots 1 -- nothing
#plant
#supplybonus 30
#poisonarmor 5
#gcost 0
#end

#newmonster 7041
#spr1 "./Hellenika/SmallWyrdBird_1.tga"
#spr2 "./Hellenika/SmallWyrdBird_2.tga"
#name "Wyrd Bird"
#descr "Wyrd Birds are ravenous, misshapen scavengers and bringers of misfortune that live apart from other birds. They dwell hidden in dark and sickly places and are often deformed, diseased or lame. The hoi polloi sometimes calls them weird or wyrd, and superstitious or perhaps wise people tell that they form covens to study the mysteries of the occult and conspire against mankind. Although even other birds dislike them, the Republic of the Clouds sometimes uses their services in exchange for the right to approach the utopic Nephelococcygia. They can only be found in provinces with an Ashen Tree, and they'll desert it if a fort is built there. They are much more stealthy and cunning than most other birds."
#gcost 12
#rcost 1
#hp 6
#size 2
#mr 13
#mor 11
#str 4
#att 10
#def 12
#prec 8
#enc 3
#mapmove 20
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy 40
#weapon 753
#weapon 1185
#weapon 404
#addupkeep -6
#supplybonus -1
#nametype 239
#reclimit 5
#monpresentrec "Ashen Tree"
#deathcurse
#darkvision 100
#darkpower 1
#startaff 30
#airshield 20
#rpcost 1
#spiritsight
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7042
#spr1 "./Hellenika/BirdU_1.tga"
#spr2 "./Hellenika/BirdU_2.tga"
#name "Migratory Warrior"
#descr "Migratory Warriors are regular bird predators that spend most their life traveling from a corner of the world to another. In battle, they are very similar to Warriors of Prey, but they are too free-spirited to stay in the same place for long. Therefore, they will only fight until they cause or suffer a wound before leaving on their next trip. Their independence still has some good sides, since it makes them less costly both in gold and supplies, and, like Warriors of the Clouds, allows them not to cost any upkeep. In addition, as great travelers that can fly very high in the sky for very long periods of time without getting tired, they can move further than Warriors of Prey and even cross the oceans. They can be recruited anywhere, but the presence of a bird commander of great stature or of a sentient tree is required to assemble them."
#gcost 3
#addupkeep -3
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 11
#str 6
#att 10
#def 14
#prec 8
#enc 3
#mapmove 34
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#singlebattle
#sailing 2 6
#monpresentrec -4123
#nametype 239
#airshield 20
#rpcost 3
#bird
#reclimit 10
#itemslots 12288 -- 2 misc
#end

#newmonster 7043
#spr1 "./Hellenika/BirdF4_1.tga"
#spr2 "./Hellenika/BirdF4_2.tga"
#name "Spring Warrior"
#descr "Seasonal Warriors are regular bird predators that thrive the most during their preferred season. At that particular time, they are extremely fierce, even more than Warriors of Prey; but in the opposite season, they are very frail and vulnerable. They also resist an element based on their preferred season, and since their survival is so dependant on the right climate, they spend half of their time flying across very long distances to reach distant provinces where they can see better days. For this reason, unlike Warriors of Prey they are able to cross the oceans. Their independence also lets them find most of their food by themselves, which makes them less reliant on supplies than Warriors of Prey. Finally, their exotic songs and colors as well as their strong personality makes them very popular among birds and encourages them in battle. Spring Warriors can be recruited in all forests."
#gcost 8
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 10
#str 7
#att 11
#def 15
#prec 8
#enc 3
#springpower 50
#shockres 5
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#standard 1
#sailing 2 6
#addupkeep -4
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7044
#spr1 "./Hellenika/BirdX6_1.tga"
#spr2 "./Hellenika/BirdX6_2.tga"
#name "Summer Warrior"
#descr "Seasonal Warriors are regular bird predators that thrive the most during their preferred season. At that particular time, they are extremely fierce, even more than Warriors of Prey; but in the opposite season, they are very frail and vulnerable. They also resist an element based on their preferred season, and since their survival is so dependant on the right climate, they spend half of their time flying across very long distances to reach distant provinces where they can see better days. For this reason, unlike Warriors of Prey they are able to cross the oceans. Their independence also lets them find most of their food by themselves, which makes them less reliant on supplies than Warriors of Prey. Finally, their exotic songs and colors as well as their strong personality makes them very popular among birds and encourages them in battle. Summer Warriors can be recruited in all wastes."
#gcost 8
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 10
#str 7
#att 11
#def 15
#prec 8
#enc 3
#summerpower 50
#fireres 5
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#standard 1
#sailing 2 6
#addupkeep -4
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7045
#spr1 "./Hellenika/BirdG_1.tga"
#spr2 "./Hellenika/BirdG_2.tga"
#name "Fall Warrior"
#descr "Seasonal Warriors are regular bird predators that thrive the most during their preferred season. At that particular time, they are extremely fierce, even more than Warriors of Prey; but in the opposite season, they are very frail and vulnerable. They also resist an element based on their preferred season, and since their survival is so dependant on the right climate, they spend half of their time flying across very long distances to reach distant provinces where they can see better days. For this reason, unlike Warriors of Prey they are able to cross the oceans. Their independence also lets them find most of their food by themselves, which makes them less reliant on supplies than Warriors of Prey. Finally, their exotic songs and colors as well as their strong personality makes them very popular among birds and encourages them in battle. Fall Warriors can be recruited in all swamps."
#gcost 8
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 10
#str 7
#att 11
#def 15
#prec 8
#enc 3
#fallpower 50
#poisonres 5
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#standard 1
#sailing 2 6
#addupkeep -4
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7046
#spr1 "./Hellenika/BirdE3_1.tga"
#spr2 "./Hellenika/BirdE3_2.tga"
#name "Winter Warrior"
#descr "Seasonal Warriors are regular bird predators that thrive the most during their preferred season. At that particular time, they are extremely fierce, even more than Warriors of Prey; but in the opposite season, they are very frail and vulnerable. They also resist an element based on their preferred season, and since their survival is so dependant on the right climate, they spend half of their time flying across very long distances to reach distant provinces where they can see better days. For this reason, unlike Warriors of Prey they are able to cross the oceans. Their independence also lets them find most of their food by themselves, which makes them less reliant on supplies than Warriors of Prey. Finally, their exotic songs and colors as well as their strong personality makes them very popular among birds and encourages them in battle. Winter Warriors can be recruited in all mountains."
#gcost 8
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 10
#str 7
#att 11
#def 15
#prec 8
#enc 3
#winterpower 50
#coldres 5
#mapmove 22
#ap 4
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#standard 1
#sailing 2 6
#addupkeep -4
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7047
#spr1 "./Hellenika/BirdR2_1.tga"
#spr2 "./Hellenika/BirdR2_2.tga"
#name "Blood-drinker Bird"
#descr "Although they also look like the most delicate, Blood-drinker birds are in fact the most violent of all birds. For sure, they are smaller and weaker than Terror Falcons or Great Eagles, but none is more blood-thirsty than they are. Their kin was birthed the very day the blood of a man was spilled for the first time upon the holy ground of the City in the Sky. After having dismembered him alive, they drank his blood, bathed in it and shredded the rest of him to pieces. Then, they sealed the Oath of Nephelococcygia against Mankind and the Gods, swearing that none would prevent the rise of the birds to godhood, and their order entered existence at the same time as their cruelty. Since then, whole flocks of them can be seen gracefully gliding across the sky or resting in peaceful places. Woe to the unfortunate soul that would then cross their path and choose to contemplate their gentle wings or the soft pink of their feathers, for they would take great pleasure in mutilating and maiming her. In battle, none could say whether they look more like angels or demons, for clearly they have both the former's purity and the latter's fury. Although Nephelococcygia is the only place where their raising is institutionalized, any blood priest is able to anoint more by ritual sacrifice."
#gcost 22
#rcost 1
#hp 4
#size 2
#prot 0
#mr 6
#mor 11
#str 6
#att 10
#def 14
#prec 8
#enc 3
#mapmove 22
#ap 6
#maxage 14
#animal
#flying
#mountainsurvival
#forestsurvival
#stealthy
#berserk 2
#heal
#weapon 753
#weapon 408
#weapon 404
#damagerev 1
#reclimit 5
#chaospower 1
#incunrest 3
#addupkeep -7
#supplybonus -1
#nametype 239
#airshield 20
#rpcost 1
#bird
#chaosrec 1
#itemslots 12288 -- 2 misc
#end

#newmonster 7048
#spr1 "./Hellenika/WingedAnarchist_1.tga"
#spr2 "./Hellenika/WingedAnarchist_2.tga"
#name "Winged Anarchist"
#descr "Winged Anarchists are natural bird predators whose heart has been filled with rage, anger, cruelty and joyful zeal by the leaders of the Revolution. They are very similar to Warriors of Prey, but they fight far better in lands of turmoil and unrest, and are weaker where order reigns. In addition, just like their anarchistic masters, they are too independent to ever rely on anyone other than themselves and thus they cost no upkeep."
#gcost 0
#rcost 1
#hp 8
#size 2
#prot 0
#mr 6
#mor 11
#str 6
#att 10
#def 15
#prec 8
#enc 3
#mapmove 22
#ap 4
#maxage 14
#chaospower 1
#animal
#flying
#mountainsurvival
#forestsurvival
#swampsurvival
#wastesurvival
#stealthy
#heal
#weapon 753
#weapon 408
#weapon 404
#supplybonus -1
#incunrest 1
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7049
#copystats 1946
#copyspr 1946
#name "Spirit of the Four Seasons"
#descr "The Spirit of the Four Seasons is a legendary magical bird with brightly glowing golden plumage. It is almost immune to the elements and its great beauty discourages mortal minds from harming it. It is ever graceful and entirely unaffected by storms. It attacks its foes with blinding flashes of colored light that can burn away their eyes forever. Its ability to bring good fortune and health makes it a very precious weapon of the Nation of the Birds, and it is considered sacred like all other golden birds. It can both be recruited in Nephelococcygia and summoned. Only wizards and Solar Birds have the magical ability necessary to lead the Spirits of the Four Seasons in combat."
#clearweapons
#weapon 1188
#weapon 1189
#holy
#illusion
#gcost 65
#rcost 1
#coldres 15
#shockres 15
#poisonres 15
#fireres 15
#awe 1
#stormimmune
#addupkeep -32
#nametype 239
#neednoteat
#supplybonus 3
#airshield 20
#rpcost 1
#reclimit 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7050
#spr1 "./Hellenika/GiantBirdC_1.tga"
#spr2 "./Hellenika/GiantBirdC_2.tga"
#name "Terror Falcon"
#descr "Terror Falcons are falcons of immense size that are strong enough to carry a horse and fierce enough to battle a dragon. They are quite intelligent and can understand human speech. Although they are generally weaker than their cousins the Great Eagles, they are also nimbler and more common, especially in non-mountainous regions. They have extraordinarily good eyes as well, and they have no fear of flying for long periods of times, which makes them able to cross the oceans. They expend great amounts of energy in their everyday tasks and must eat huge amounts of food to remain healthy. Their cry is terrifying to animals and men alike and makes them feared by the people of most cultures. Admired by all birds as the royal wings of victory, Terror Falcons are the greatest defenders of Nephelococcygia and are well known for building architecturally complex nests of the size of a great house or a small manor. When they gather in large enough numbers and are helped by flocks of smaller birds, these nests can reach the dimensions of a city and be used as small fortresses in times of war."
#hp 40
#size 6
#prot 7
#mr 13
#mor 16
#str 16
#att 14
#def 14
#prec 15
#enc 3
#mapmove 34
#flying
#ap 8
#weapon 408
#weapon 404
#maxage 50
#siegebonus 10
#patrolbonus 10
#animal
#mountainsurvival
#forestsurvival
#gcost 65
#chaosrec 7
#rcost 1
#fear 5
#sailing 6 6
#addupkeep -32
#supplybonus -4
#nametype 239
#airshield 20
#rpcost 50
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7051
#copyspr 2929
#copystats 2929
#name "Miraculous Goose"
#descr "Miraculous Geese are enchanted birds that almost were blessed with the sacred sign of golden feathers. Instead, they lay eggs of pure gold. This is a very energy-consuming process, so the geese need a lot of supplies to be in good health. These eggs will never hatch but can be harvested and used as a source of economical income. Miraculous Geese are otherwise useless and should be protected from harm at all costs."
#gold 2
#gcost 0
#supplybonus -2
#nametype 239
#bird
#end

#newmonster 7052
#spr1 "./Hellenika/Runner_1b.tga"
#spr2 "./Hellenika/Runner_2g.tga"
#name "Freed Runner"
#descr "Runners are a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. Even though they are able to speak and think, they were always considered primitive, stupid beings by the C'tissians who share their home swamps, barely worth the effort of enslaving them. But recently, the slave prince Ka Rak Kari escaped his jailers and launched a call for the emancipation of all runners. A few more of them escape every day, and most hope to find a new life by joining their audacious prince. Since Runners are distant cousins of the birds, although they are wingless and the targets of the birds' disdain and mockery, Ka Rak Kari answered the universal call of Nephelococcygia and swore allegiance to the Nation of the Birds. While his decision surprised the Republic's leaders, they took it seriously and gave him great authority. For this reason, most freed Runners are now fighting for Nephelococcygia. Freed Runners are barely more effective than they were as slaves, as they lack training and don't really wish to fight for anything else than freedom and survival. Still, they are far stronger in body than Warriors of the Clouds."
#nametype 113
#hp 12
#size 2
#prot 3
#mr 11
#mor 10
#str 11
#att 11
#def 10
#prec 10
#enc 3
#mapmove 18
#ap 16
#maxage 75
#poisonres 5
#coldblood
#swampsurvival
#weapon 1
#weapon 20
#gcost 0
#lizard
#itemslots 15494
#end

#newmonster 7053
#spr1 "./Hellenika/Runner_1h.tga"
#spr2 "./Hellenika/Runner_2h.tga"
#name "Runner Faithful"
#descr "Runners are a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. Even though they are able to speak and think, they were always considered primitive, stupid beings by the C'tissians who share their home swamps, barely worth the effort of enslaving them. But recently, the slave prince Ka Rak Kari escaped his jailers and launched a call for the emancipation of all runners. A few more of them escape every day, and most hope to find a new life by joining their audacious prince. Since Runners are distant cousins of the birds, although they are wingless and the targets of the birds' disdain and mockery, Ka Rak Kari answered the universal call of Nephelococcygia and swore allegiance to the Nation of the Birds. While his decision surprised the Republic's leaders, they took it seriously and gave him great authority. For this reason, most freed Runners are now fighting for Nephelococcygia. Runner Faithfuls are very loyal to their prince and, although they lack proper military training, they will do their best to serve him in battle."
#nametype 113
#hp 12
#size 2
#prot 3
#mr 11
#mor 12
#str 11
#att 11
#def 11
#prec 10
#enc 3
#mapmove 18
#ap 16
#maxage 75
#poisonres 5
#coldblood
#swampsurvival
#weapon 1
#weapon 20
#gcost 0
#heal
#lizard
#itemslots 15494
#end

#newmonster 7054
#spr1 "./Hellenika/Runner_1j.tga"
#spr2 "./Hellenika/Runner_2j.tga"
#name "Runner Zealot"
#descr "Runners are a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. Even though they are able to speak and think, they were always considered primitive, stupid beings by the C'tissians who share their home swamps, barely worth the effort of enslaving them. But recently, the slave prince Ka Rak Kari escaped his jailers and launched a call for the emancipation of all runners. A few more of them escape every day, and most hope to find a new life by joining their audacious prince. Since Runners are distant cousins of the birds, although they are wingless and the targets of the birds' disdain and mockery, Ka Rak Kari answered the universal call of Nephelococcygia and swore allegiance to the Nation of the Birds. While his decision surprised the Republic's leaders, they took it seriously and gave him great authority. For this reason, most freed Runners are now fighting for Nephelococcygia. Runner Zealots are fanatics that wish to receive new wings from the God of Birds and thus fight with extreme bravery. They sincerely believe they are in fact birds and they behave in rather unusual ways, but they are so intently devoted to the cause that they are considered sacred."
#nametype 113
#hp 12
#size 2
#prot 3
#mr 12
#mor 14
#str 12
#att 12
#def 12
#prec 10
#enc 3
#mapmove 18
#ap 16
#maxage 75
#poisonres 5
#coldblood
#swampsurvival
#weapon 357
#weapon 20
#gcost 0
#holy
#heal
#lizard
#itemslots 15494
#end

#newmonster 7055
#spr1 "./Hellenika/Runner_1k.tga"
#spr2 "./Hellenika/Runner_2k.tga"
#name "Runner Talon Warrior"
#descr "Runners are a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. Even though they are able to speak and think, they were always considered primitive, stupid beings by the C'tissians who share their home swamps, barely worth the effort of enslaving them. But recently, the slave prince Ka Rak Kari escaped his jailers and launched a call for the emancipation of all runners. A few more of them escape every day, and most hope to find a new life by joining their audacious prince. Since Runners are distant cousins of the birds, although they are wingless and the targets of the birds' disdain and mockery, Ka Rak Kari answered the universal call of Nephelococcygia and swore allegiance to the Nation of the Birds. While his decision surprised the Republic's leaders, they took it seriously and gave him great authority. For this reason, most freed Runners are now fighting for Nephelococcygia. Runner Talon Warriors are traditional fighters that master a very exotic combat style. At the end of each talon they bear one disproportionate claw of extreme sharpness. They use it in combat to give double kicks with the strength of a crossbow and the surgical efficiency of a long dagger. They are also able to go berserk in battle."
#nametype 113
#hp 12
#size 2
#prot 3
#mr 11
#mor 12
#str 13
#att 13
#def 13
#prec 10
#enc 3
#mapmove 18
#ap 16
#maxage 75
#poisonres 5
#coldblood
#swampsurvival
#weapon 357
#weapon 583
#weapon 583
#weapon 20
#ambidextrous 3
#berserk 3
#gcost 0
#heal
#lizard
#itemslots 15494
#end

#newmonster 7056
#spr1 "./Hellenika/Runner_1i.tga"
#spr2 "./Hellenika/Runner_2i.tga"
#name "Runner Royal Guard"
#descr "Runners are a strange, birdlike breed of predator lizards that can outrun even the fastest of humans. Even though they are able to speak and think, they were always considered primitive, stupid beings by the C'tissians who share their home swamps, barely worth the effort of enslaving them. But recently, the slave prince Ka Rak Kari escaped his jailers and launched a call for the emancipation of all runners. A few more of them escape every day, and most hope to find a new life by joining their audacious prince. Since Runners are distant cousins of the birds, although they are wingless and the targets of the birds' disdain and mockery, Ka Rak Kari answered the universal call of Nephelococcygia and swore allegiance to the Nation of the Birds. While his decision surprised the Republic's leaders, they took it seriously and gave him great authority. For this reason, most freed Runners are now fighting for Nephelococcygia. Runner Royal Guards are the elite of the Runner people. They are very experienced warriors of noble blood that serve their prince with an unbreakable loyalty. They use their very threatening weapons with a cold efficiency and have scales as thick as human armor. They are very few and it will be hard to assemble an entire squad of them."
#nametype 113
#hp 18
#size 2
#prot 7
#mr 14
#mor 15
#str 15
#att 14
#def 15
#prec 10
#enc 3
#mapmove 18
#ap 16
#maxage 75
#poisonres 5
#coldblood
#swampsurvival
#weapon 357
#weapon 323
#heal
#bodyguard 3
#gcost 0
#lizard
#itemslots 15494
#end

#newmonster 7057
#spr1 "Hellenika/IsphiMilitia_1.tga"
#spr2 "Hellenika/IsphiMilitia_2.tga"
#name "Isphenoplian Militia"
#descr "Although the savants, leaders and librarians of Isphenople are usually human, they are only a minority in the ancient city. Most of its population is actually still of C'tissian origins, as it descends from the people of Isphi. While the C'tissians of Isphenople prefer to live peaceful lives as farmers, fishers, crafters and traders, they still have to defend their homes in case of war. They are skilled at surviving swamps and the desert, and like all C'tissians, they have a thick hide, innately resist poisons and are able to swim accross rivers. They however aren't very skilled in combat, and they actually are notorious for their cowardice. Since they expect their human leaders to protect them against invaders, they rarely volunteer in the military and ask for high wages in spite of their general inefficiency. As a testimony to their hybrid culture, they wear Ermorian bronze scale cuirasses but use falchions and round shields of C'tissian design instead of the tower shields standard to the Isphenoplian order of the Guardians of Knowledge."
#gcost 14
#rcost 1
#rpcost 14
#hp 11
#size 2
#prot 5
#mr 11
#mor 8
#str 10
#att 10
#def 10
#prec 10
#ap 10
#mapmove 14
#enc 4
#maxage 50
#weapon 10
#weapon 21
#armor 142
#armor 127
#armor 2
#poisonres 6
#coldblood
#wastesurvival
#swampsurvival
#swimming
#nametype 113
#end

#selectmonster 581
#descr "A juggernaut is a colossal structure made out of religious idols and two pairs of enormous wheels. The machine is powered by Astral magic and requires magical leadership. A construction like this has to be almost as holy as the God himself and will rightfully spread the Dominion of its God just like a Prophet. The juggernaut is covered by a layer of gold to make it look even more religiously important. Building it through means other than rituals requires the presence of an engineer in the province, and it will not require any upkeep in spite of its gold cost."
#gcost 100
#rcost 1000
#rpcost 120
#addupkeep -100
#reclimit 1
#monpresentrec -4126
#end

#newmonster 7058
#copystats 7
#spr1 "Hellenika/Guardian_of_Knowledge_1.tga"
#spr2 "Hellenika/Guardian_of_Knowledge_2.tga"
#name "Guardian of Knowledge"
#descr "Guardians of Knowledge are elite warriors that are ready to protect the Ancient Library and its inestimable treasures with their lives. While their corps was created by the Ermorian Emperor when Isphenople was still Imperial property, a few didn't leave the Scholar Citadel when it became independent, and thus became full citizens of Isphenople. Today, while they are far less numerous than they were during the Imperial period, they are also better armed, as the Library can afford to make its few warriors as formidable as possible and indeed must do so to ensure its security. Thus, each Guardian of Knowledge is equipped with both an enchanted broad sword that either deals additional elemental damage to its target or unravels the substance of magical beings; and with a fire-resistant shield and set of heavy armor. These are very useful to complete his firefighting duties, which are of critical importance to the Conclave, for fire is a worse enemy of the Library than any external foe could ever be - a simple spark could be enough to destroy all the precious work of generations of philosophers and archivists. However, most of the time Guardians of Knowledge fight neither living nor burning foes, and instead vigilantly watch over the Library and its savants. As such, they are very skilled bodyguards and patrollers. In addition, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of fire, astral and earth magic as well as his ability to train a new Guardian of Knowledge each month; furthermore, those that don the Master Librarian Girdle will receive knowledge of astral magic even if they did not previously possess it."
#weapon 1169
#nametype 106
#fireres 5
#mr 13
#patrolbonus 3
#gcost 27
#firstshape -4125
#magicskill 4 1
#magicboost 4 -1
#custommagic 3200 100
#custommagic 3200 100
#custommagic 3200 100
#makemonsters1 -4125
#userestricteditem 8062
#startage 27
#end

#newmonster 7059
#copystats 7
#spr1 "Hellenika/Guardian_of_Knowledge_1.tga"
#spr2 "Hellenika/Guardian_of_Knowledge_2.tga"
#name "Guardian of Knowledge"
#descr "Guardians of Knowledge are elite warriors that are ready to protect the Ancient Library and its inestimable treasures with their lives. While their corps was created by the Ermorian Emperor when Isphenople was still Imperial property, a few didn't leave the Scholar Citadel when it became independent, and thus became full citizens of Isphenople. Today, while they are far less numerous than they were during the Imperial period, they are also better armed, as the Library can afford to make its few warriors as formidable as possible and indeed must do so to ensure its security. Thus, each Guardian of Knowledge is equipped with both an enchanted broad sword that either deals additional elemental damage to its target or unravels the substance of magical beings; and with a fire-resistant shield and set of heavy armor. These are very useful to complete his firefighting duties, which are of critical importance to the Conclave, for fire is a worse enemy of the Library than any external foe could ever be - a simple spark could be enough to destroy all the precious work of generations of philosophers and archivists. However, most of the time Guardians of Knowledge fight neither living nor burning foes, and instead vigilantly watch over the Library and its savants. As such, they are very skilled bodyguards and patrollers. In addition, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of fire, astral and earth magic as well as his ability to train a new Guardian of Knowledge each month; furthermore, those that don the Master Librarian Girdle will receive knowledge of astral magic even if they did not previously possess it."
#weapon 1169
#nametype 106
#fireres 5
#mr 13
#patrolbonus 3
#gcost 27
#montag 4125
#magicskill 4 1
#magicboost 4 -1
#custommagic 3200 100
#custommagic 3200 100
#custommagic 3200 100
#makemonsters1 -4125
#userestricteditem 8062
#startage 27
#end

#newmonster 7060
#copystats 7
#spr1 "Hellenika/Guardian_of_Knowledge_1.tga"
#spr2 "Hellenika/Guardian_of_Knowledge_2.tga"
#name "Guardian of Knowledge"
#descr "Guardians of Knowledge are elite warriors that are ready to protect the Ancient Library and its inestimable treasures with their lives. While their corps was created by the Ermorian Emperor when Isphenople was still Imperial property, a few didn't leave the Scholar Citadel when it became independent, and thus became full citizens of Isphenople. Today, while they are far less numerous than they were during the Imperial period, they are also better armed, as the Library can afford to make its few warriors as formidable as possible and indeed must do so to ensure its security. Thus, each Guardian of Knowledge is equipped with both an enchanted broad sword that either deals additional elemental damage to its target or unravels the substance of magical beings; and with a fire-resistant shield and set of heavy armor. These are very useful to complete his firefighting duties, which are of critical importance to the Conclave, for fire is a worse enemy of the Library than any external foe could ever be - a simple spark could be enough to destroy all the precious work of generations of philosophers and archivists. However, most of the time Guardians of Knowledge fight neither living nor burning foes, and instead vigilantly watch over the Library and its savants. As such, they are very skilled bodyguards and patrollers. In addition, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of fire, astral and earth magic as well as his ability to train a new Guardian of Knowledge each month; furthermore, those that don the Master Librarian Girdle will receive knowledge of astral magic even if they did not previously possess it."
#weapon 1170
#nametype 106
#fireres 5
#mr 13
#patrolbonus 3
#gcost 27
#montag 4125
#magicskill 4 1
#magicboost 4 -1
#custommagic 3200 100
#custommagic 3200 100
#custommagic 3200 100
#makemonsters1 -4125
#userestricteditem 8062
#startage 27
#end

#newmonster 7061
#copystats 7
#spr1 "Hellenika/Guardian_of_Knowledge_1.tga"
#spr2 "Hellenika/Guardian_of_Knowledge_2.tga"
#name "Guardian of Knowledge"
#descr "Guardians of Knowledge are elite warriors that are ready to protect the Ancient Library and its inestimable treasures with their lives. While their corps was created by the Ermorian Emperor when Isphenople was still Imperial property, a few didn't leave the Scholar Citadel when it became independent, and thus became full citizens of Isphenople. Today, while they are far less numerous than they were during the Imperial period, they are also better armed, as the Library can afford to make its few warriors as formidable as possible and indeed must do so to ensure its security. Thus, each Guardian of Knowledge is equipped with both an enchanted broad sword that either deals additional elemental damage to its target or unravels the substance of magical beings; and with a fire-resistant shield and set of heavy armor. These are very useful to complete his firefighting duties, which are of critical importance to the Conclave, for fire is a worse enemy of the Library than any external foe could ever be - a simple spark could be enough to destroy all the precious work of generations of philosophers and archivists. However, most of the time Guardians of Knowledge fight neither living nor burning foes, and instead vigilantly watch over the Library and its savants. As such, they are very skilled bodyguards and patrollers. In addition, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of fire, astral and earth magic as well as his ability to train a new Guardian of Knowledge each month; furthermore, those that don the Master Librarian Girdle will receive knowledge of astral magic even if they did not previously possess it."
#weapon 1171
#nametype 106
#fireres 5
#mr 13
#patrolbonus 3
#gcost 27
#montag 4125
#magicskill 4 1
#magicboost 4 -1
#custommagic 3200 100
#custommagic 3200 100
#custommagic 3200 100
#makemonsters1 -4125
#userestricteditem 8062
#startage 27
#end

#newmonster 7062
#copystats 7
#spr1 "Hellenika/Guardian_of_Knowledge_1.tga"
#spr2 "Hellenika/Guardian_of_Knowledge_2.tga"
#name "Guardian of Knowledge"
#descr "Guardians of Knowledge are elite warriors that are ready to protect the Ancient Library and its inestimable treasures with their lives. While their corps was created by the Ermorian Emperor when Isphenople was still Imperial property, a few didn't leave the Scholar Citadel when it became independent, and thus became full citizens of Isphenople. Today, while they are far less numerous than they were during the Imperial period, they are also better armed, as the Library can afford to make its few warriors as formidable as possible and indeed must do so to ensure its security. Thus, each Guardian of Knowledge is equipped with both an enchanted broad sword that either deals additional elemental damage to its target or unravels the substance of magical beings; and with a fire-resistant shield and set of heavy armor. These are very useful to complete his firefighting duties, which are of critical importance to the Conclave, for fire is a worse enemy of the Library than any external foe could ever be - a simple spark could be enough to destroy all the precious work of generations of philosophers and archivists. However, most of the time Guardians of Knowledge fight neither living nor burning foes, and instead vigilantly watch over the Library and its savants. As such, they are very skilled bodyguards and patrollers. In addition, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of fire, astral and earth magic as well as his ability to train a new Guardian of Knowledge each month; furthermore, those that don the Master Librarian Girdle will receive knowledge of astral magic even if they did not previously possess it."
#weapon 1172
#nametype 106
#fireres 5
#mr 13
#patrolbonus 3
#gcost 27
#montag 4125
#magicskill 4 1
#magicboost 4 -1
#custommagic 3200 100
#custommagic 3200 100
#custommagic 3200 100
#makemonsters1 -4125
#userestricteditem 8062
#startage 27
#end

#newmonster 7549 -- New Ermor
#copystats 7 -- Emerald Guard
#copyspr 7
#name "Emerald Guard"
#descr "The Emerald Guards are the Emperor's personal guards. Only the most skilled and loyal soldiers in the Empire are chosen to serve as Emerald Guards. The mission they were invested with by the Theurgs is so important that they are considered sacred. They are equipped with broadswords, gilded plate hauberks and blessed tower shields which grant them unnatural recuperation from wounds and impenetrable resistance to magic and the elements. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#gcost 25
#mr 16
#mor 16
#att 15
#def 15
#shockres 5
#fireres 5
#coldres 5
#poisonres 5
#woundfend 1
#heal
#holy
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#end

#selectmonster 7 -- Emerald Guard
#name "Emerald Guard"
#descr "The Emerald Guards are the Emperor's personal guards. Only the most skilled and loyal soldiers in the Empire are chosen to serve as Emerald Guards. The mission they were invested with by the Theurgs is so important that they are considered sacred. They are equipped with broadswords, gilded plate hauberks and blessed tower shields which grant them unnatural recuperation from wounds and impenetrable resistance to magic and the elements. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#gcost 25
#mr 16
#mor 16
#att 15
#def 15
#shockres 5
#fireres 5
#coldres 5
#poisonres 5
#woundfend 1
#heal
#holy
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#end

#newmonster 7063
#spr1 "Hellenika/Scribe_Fencer_1.tga"
#spr2 "Hellenika/Scribe_Fencer_2.tga"
#name "Scribe Fencer"
#descr "Scribe Fencers are low-ranking Archivists that have mastered the art of scroll-fencing. While they spend most of their time copying books and scrolls for the Library's usage and haven't yet proven themselves enough to be entrusted with more important activities, they still are erudites and thanks to their very uncommon skills are sometimes called on the battlefield to support Isphenople's heavy troops from a short range. Although slashing scrolls are too expensive for general use in the nation, Scribe Fencers know how to use simple writing quills as deadly magical swords and darts. Like Archivists of greater rank, they are covered in magical parchments whose invisible wardings protect them against mundane attacks but make them more vulnerable to fire, and also like them, they make good use of their spare time to perfect the mastery of their art, which makes them stronger under sloth scales but weaker under production scales. But since they all are scholars whose discipline requires years of learning, Scribe Fencers are rather rare and hard to recruit in great numbers. Still, should one of them become a commander thanks to the Divine Name ritual, he could be of great use thanks to his mastery of air, earth and astral magic as well as of his ability to train a new Scribe Fencer each month."
#hp 9
#size 2
#prot 0
#mr 13
#mor 10
#str 8
#att 14
#def 14
#prec 14
#enc 3
#mapmove 16
#ap 8
#weapon 1180
#weapon 1179
#armor 202
#maxage 50
#startage 44
#gcost 27
#rcost 1
#rpcost 31
#fireres -5
#reclimit 3
#magicskill 1 1
#magicskill 4 1
#custommagic 3328 100
#custommagic 3328 100
#custommagic 3328 100
#invulnerable 10
#userestricteditem 8063
#itemslots 15494 -- standard
#makemonsters1 "Scribe Fencer"
#slothpower 1
#end

#selectmonster 2227 -- Goat
#name "Goat"
#descr "A herbivore. It can defend itself with its horns, but prefers flight to fight. Its milk can be used by the military to feed troops even in hostile lands."
#supplybonus 1
#quadruped
#end

#selectmonster 635 -- Maenad
#name "Maenad"
#descr "Maenads are human females seduced by the wild lure of a Pan's flute or the dreamlike influence of a nymph. They enter a state of rapturous rage in which they shed all clothing and join the armies of Pangaea or Arcadeia to fight with claws and teeth. Maenads are chaotic and difficult to control. They fight well but are almost useless when patrolling. Arcadeian Maenads can only be recruited in provinces with a temple."
#reclimit 2
#rpcost 1
#reqtemple
#patrolbonus 0
#prec 0
#end

#newmonster 6858
#copyspr 932
#copystats 932 -- Woodland Spirit
#name "Woodland Spirit"
#descr "Ancient trees are sometimes inhabited by spirits that can manifest themselves as beautiful women. These spirits are known as Woodland Spirits. Woodland Spirits are stunningly beautiful and few mortals would willingly harm them. Woodland Spirits are ethereal and regenerate wounds as long as their tree is not destroyed. They never willingly leave the province they are summoned to and will waste away and die if forced apart from their forest. They are sacred to the people of Arcadeia."
#holy
#reclimit 1
#rpcost 40
#end

#newmonster 6850
#copyspr 1227
#copystats 1227 -- Kydnid
#descr "Kydnides are warrior naiades, willing to leave their native river to wreak vengeance upon those who harm the rivers of the world. Kydnides manifest themselves as incredibly beautiful women wearing gleaming bronze armor. Unlike other naiades, kydnides do not die if they leave their home. They are sacred to the people of Arcadeia."
#holy
#gcost 20
#rpcost 16
#addupkeep -20
#end

#newmonster 6856 -- Korybant
#copyspr 2837
#copystats 2837
#descr "The Korybantes are sacred war-dancers whose art is a remnant of the lost empire of Therodos cultivated as a tradition by the pastoral people of Arcadeia and the nymphs they revere. In every temple Korybant couples are trained as war-dancers able to enter a berserk frenzy when blessed by the music and poetry of rhapsodes and nymphs. The war-dances are not well suited for formation fighting and Korybants take up more space on the battle field than ordinary troops."
#slothpower 1
#end

#newmonster 6854 -- Peltast
#copyspr 201
#copystats 201
#descr "The peltasts are the light infantry of Arcadeia. They have almost no armor and are mainly used as javelin throwers. Unlike Arcoscephale, which is well versed in the arts of war and discipline, Arcadeia is a peaceful nation that despises work, and for this reason its regular troops are both more expensive and weaker in lands of production, but stronger in lands of sloth."
#slothpower 1
#gcost 12
#rpcost 12
#end

#newmonster 6855 -- Slinger
#copyspr 50
#copystats 50
#descr "Slingers are cheap missile units. They are not very accurate or deadly and they are not good melee units. Unlike Arcoscephale, which is well versed in the arts of war and discipline, Arcadeia is a peaceful nation that despises work, and for this reason its regular troops are both more expensive and weaker in lands of production, but stronger in lands of sloth."
#slothpower 1
#gcost 8
#end

#newmonster 7770
#copystats 2003
#copyspr 2003
#name "Slave Slinger"
#descr "Out of necessity for its survival in a harsh environment and against powerful enemies, the Onyx Tribe's society evolved to become especially ruthless. Thus, slavery is extremely common in Nabatem's lands. Due to the strongly matriarchal nature of Saqaba's culture, males are even more likely than females to be enslaved, and they seldom reach positions of power, usually occupied by females exclusively. In Nabatem, cruelty is encouraged as a mean to strengthen society as a whole as well as the individual's mind and body. Thus, insubordinate slaves and especially males commonly suffer harsh punishments such as the loss of an eye, a finger, a hand or the tongue. Those that are unable to serve in war with efficiency are then used as hard workers until they die. Most prefer to die in combat and will fight with the best of their ability, unless they see an opportunity to free themselves and leave these cursed lands forever."
#mor 10
#deserter 1
#end

#newmonster 7064
#copystats 2004
#copyspr 2004
#name "Slave Infantry"
#descr "Out of necessity for its survival in a harsh environment and against powerful enemies, the Onyx Tribe's society evolved to become especially ruthless. Thus, slavery is extremely common in Nabatem's lands. Due to the strongly matriarchal nature of Saqaba's culture, males are even more likely than females to be enslaved, and they seldom reach positions of power, usually occupied by females exclusively. In Nabatem, cruelty is encouraged as a mean to strengthen society as a whole as well as the individual's mind and body. Thus, insubordinate slaves and especially males commonly suffer harsh punishments such as the loss of an eye, a finger, a hand or the tongue. Those that are unable to serve in war with efficiency are then used as hard workers until they die. Most prefer to die in combat and will fight with the best of their ability, unless they see an opportunity to free themselves and leave these cursed lands forever."
#mor 10
#deserter 1
#end

#newmonster 6852 -- Onyx Amazon
#name "Amazon"
#descr "Amazons are a people of semi-civilized tribes ruled by women. The Amazonian culture is centered around warfare and prowess in combat. The Amazon community is comprised of four tribes led by sorceresses and priestesses trained in magic. The Onyx Amazons use heavier armor than the other tribes. In addition, the warriors of Nabatem are used to a ruthless lifestyle and society, which makes them generally tougher than their cousins in every way."
#copystats 357
#copyspr 357
#gcost 8 -- rather than 12
#woundfend 1
#str 11
#mr 11
#hp 11
#mor 12
#end

#newmonster 6853 -- Nightmare
#copystats 369
#copyspr 369
#gcost 45 -- rather than 75
#rpcost 32
#str 11
#mr 12
#hp 11
#end

#newmonster 7065
#copystats 369
#spr1 "Hellenika/BaetylKnight_1c.tga"
#spr2 "Hellenika/BaetylKnight_2c.tga"
#name "Baetyl Knight"
#descr "The Baetyl Knights are members of an elite unit of Nightmares - Amazon templars riding blessed skeletal horses and controlling them with their own life force. Like regular Nightmares, Baetyl Knights are powerful combatants that inspire great dread on the battlefield, but also like them, this comes at a very high energy cost, meaning that their art is extremely taxing and can make them vulnerable. However, unlike other Nightmares, Baetyl Knights are armed with the most sacred and powerful weapons of the Onyx Tribe: lances, armors and shields made of an eerie black stone fallen from the Stars. Thus, they are among the most heavily armored troops of their age, and more importantly, their attacks will destroy with their dark radiance all that is holy to their enemies, making them especially powerful against sacred units. Finally, they are exceptionally well trained, as shown at the same time by their fighting skills, their exceptional endurance in the practice of their exhausting art, and their ease at patrolling the deserts that surround Saqaba."
#clearweapons
#cleararmor
#nametype 135
#weapon 1160
#weapon 56
#armor 53
#armor 211
#armor 881
#mapmove 24
#mor 16
#hp 12
#str 12
#att 14
#enc 12
#mr 12
#wastesurvival
#gcost 55
#rpcost 54
#mountedhumanoid
#end

#newmonster 7066
#copystats 1363
#spr1 "Hellenika/Baetyl_Guardian_1b.tga"
#spr2 "Hellenika/Baetyl_Guardian_2b.tga"
#name "Baetyl Eidolon"
#descr "A Baetyl Eidolon is the guardian spirit of a baetyl, that is to say, a black stone fallen from the sky and often made of either obsidian or a dark, meteoritic iron. In many cultures, but more than in any other place in Nabatem, baetyls are considered sacred as the alien messengers of divinity and as immaterial celestial beings' homes and sanctuaries. In Saqaba in particular, where the desert seems to attract such meteors and where they are sometimes used as precious, holy materials for temples or idols, baetyls are worshipped as direct signs and manifestations of the awakening God, and therefore it is no surprise that their spiritual inhabitants are venerated as tutelary deities. These beings are what we call Eidolons, which means mirror image or shadow, because they mostly manifest through the dark and silent reflections on the polished surface and edge of black mirrors made from onyx, obsidian or meteoritic iron and used to divine their will and that of the God. Still, should someone profane their altars, they would become hostile and directly influence the material realm with their horrifying presences. In such cases, or when used in their crusades by the Amazons, Baetyl Eidolons can be very dangerous beings. Although individually they are pretty weak, they still are almost impossible to harm by mere mortals, due both to their ethereal nature and their perfect invisibility without the use of black mirrors. In addition, even if they somehow were destroyed, their beings would soon reform an aetheric body inside the meteoric stone to which they are bound, and as such they seem to be perfectly immortal. Thus, being immaterial and indestructible, it's only natural that they cost no upkeep whatsoever."
#immortal
#invisible
#att 11
#def 14
#gcost 50
#rcost 1
#rpcost 1
#addupkeep -50
#saltvul 1
#clearweapons
#weapon 1235
#end

#newmonster 6839
#copystats 2482
#copyspr 2482
#name "Troglodyte Slave"
#descr "Troglodytes are huge, stupid subterranean beings of great strength. In more ancient and uncivilized times, many could be found in the region of Nabatem, where they lived in seemingly unlimitedly vast mazes of red caverns in the ochre desert, where it is believed that they primitively worshipped the supernatural guardian spirits of strange geological structures called fairy chimneys, that some people nowadays associate with Baetyl Eidolons. But the time came when the Onyx Tribe was forced into exile, and it wandered until it reached this place and its particularly hospitable caves. The Troglodytes were chased down mercilessly and eventually hundreds had to leave the belly of the earth to live like mere animals under the sky. For this reason, it isn't rare to find savage Troglodytes in the wastes not far from Nabatem. Although they can be violent, they are easy to track due the trail of devastation they leave in their wake, and the Amazons know they would be foolish not to use them as slaves, either as beasts of burden or living war machines. Thus, they can be recruited in every waste and cave near Nabatem, as well as in the capital where all kinds of slaves can be found easily."
#troglodyte
#gcost 40
#rpcost 30
#end

#newmonster 7068
#copystats 491
#spr1 "Hellenika/DesolatePresence_1.tga"
#spr2 "Hellenika/DesolatePresence_2.tga"
#name "Desolate Presence"
#descr "The Desolate Presence is a powerful spirit born from the extinction of life and the foul rituals of the Bone Tribe. The mere existence of a Desolate Presence will cause disease and despair to spread in a province, rendering it more barren than a natural desert and ensuring the eternal reign of Bones. If controlled by Nabatem, it will also allow for free foreign recruitment of exalted Bone Tribes, as their members are zealous followers of this unsound being and will sacrifice their lives to execute even the least of its whims."
#incscale 3
#spreaddom 1
#regeneration 10
#leper 10
#djinn
#sleepaura 30
#end

#newmonster 6836
#copystats 2817
#copyspr 2817
#name "Bone Tribe Hunter"
#descr "Tribal peoples of the wild follow their shamans and totemic spirits. The Bone Tribes are despised by other tribes as they have abandoned the animal spirits and turned to cannibalism and necromancy. Bone Tribe Hunters adorn themselves in bone charms that give them some protection from malign magic. Living like nomadic scavengers in the wild, barren lands that surround Nabatem, several Bone Tribes became unexpected allies of the Onyx Tribe and could very well serve it in war, provided that the region is sufficiently sick to attract their opportunistic minds and maintain their foul spiritual practices. Although the Amazons merely tolerate their existence and that of their non-matriarchal ways, they still know that some strong similarities exist between their peoples - in particular their great interest for the mysteries of death and their ruthless society forged by the fire of foreign hatred and unhospitable lands -, and as long as these savages avoid the cities and holy sepultures, they are considered useful and sometimes even directly supported in their efforts. Conversely, these Bone Tribes themselves rarely hesitate before catching the opportunities that the Amazons give them, and as such, they consider themselves a lower, more hidden and rustic, but certainly no less important part of the kingdom of Saqaba itself. Nabatem's Bone Tribe warriors and shamans are particularly independent and, unlike non-national ones, cost no upkeep whatsoever. Although they can't be recruited without a summoned Desolate Presence to unite them under its worship in their province, members of Nabatem's Bone Tribes will spontaneously appear in provinces controlled by the Lost Necropolis where a dominion of Death is strong. Temples can also be built to increase their numbers."
#gcost 0
#rpcost 2
#monpresentrec "Desolate Presence"
#end

#newmonster 6835
#copystats 2818
#copyspr 2818
#name "Bone Tribe Beast Hunter"
#descr "Tribal peoples of the wild follow their shamans and totemic spirits. The Bone Tribes are despised by other tribes as they have abandoned the animal spirits and turned to cannibalism and necromancy. Bone Tribe Beast Hunters are prominent warriors that have proven themselves by single handedly slaying a ferocious beast. Like other Bone Tribe hunters they adorn themselves in bone charms that give them some protection from malign magic. Living like nomadic scavengers in the wild, barren lands that surround Nabatem, several Bone Tribes became unexpected allies of the Onyx Tribe and could very well serve it in war, provided that the region is sufficiently sick to attract their opportunistic minds and maintain their foul spiritual practices. Although the Amazons merely tolerate their existence and that of their non-matriarchal ways, they still know that some strong similarities exist between their peoples - in particular their great interest for the mysteries of death and their ruthless society forged by the fire of foreign hatred and unhospitable lands -, and as long as these savages avoid the cities and holy sepultures, they are considered useful and sometimes even directly supported in their efforts. Conversely, these Bone Tribes themselves rarely hesitate before catching the opportunities that the Amazons give them, and as such, they consider themselves a lower, more hidden and rustic, but certainly no less important part of the kingdom of Saqaba itself. Nabatem's Bone Tribe warriors and shamans are particularly independent and, unlike non-national ones, cost no upkeep whatsoever. Although they can't be recruited without a summoned Desolate Presence to unite them under its worship in their province, members of Nabatem's Bone Tribes will spontaneously appear in provinces controlled by the Lost Necropolis where a dominion of Death is strong. Temples can also be built to increase their numbers."
#gcost 0
#rpcost 3
#monpresentrec "Desolate Presence"
#end

#newmonster 6834
#copystats 2819
#copyspr 2819
#name "Bone Tribe Head Hunter"
#descr "The Head Hunters are the ruling elites of the bone tribes. They lead the bone tribes in attacks on the animal spirit tribes as well as civilized men. They feast on the flesh of men and are feared and despised by all. Their bone charms are made from the bones of wise men and mighty enemies, and are stronger than the charms worn by their lesser kin. The Head Hunters are sacred to the bone tribesmen. Living like nomadic scavengers in the wild, barren lands that surround Nabatem, several Bone Tribes became unexpected allies of the Onyx Tribe and could very well serve it in war, provided that the region is sufficiently sick to attract their opportunistic minds and maintain their foul spiritual practices. Although the Amazons merely tolerate their existence and that of their non-matriarchal ways, they still know that some strong similarities exist between their peoples - in particular their great interest for the mysteries of death and their ruthless society forged by the fire of foreign hatred and unhospitable lands -, and as long as these savages avoid the cities and holy sepultures, they are considered useful and sometimes even directly supported in their efforts. Conversely, these Bone Tribes themselves rarely hesitate before catching the opportunities that the Amazons give them, and as such, they consider themselves a lower, more hidden and rustic, but certainly no less important part of the kingdom of Saqaba itself. Nabatem's Bone Tribe warriors and shamans are particularly independent and, unlike non-national ones, cost no upkeep whatsoever. Although they can't be recruited without a summoned Desolate Presence to unite them under its worship in their province, members of Nabatem's Bone Tribes will spontaneously appear in provinces controlled by the Lost Necropolis where a dominion of Death is strong. Temples can also be built to increase their numbers."
#gcost 0
#rpcost 5
#monpresentrec "Desolate Presence"
#end

#newmonster 7069
#spr1 "Hellenika/SingingStoneA.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 20
#size 3
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7070
#spr1 "Hellenika/SingingStoneB.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 20
#size 3
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7071
#spr1 "Hellenika/SingingStoneC.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 20
#size 3
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7072
#spr1 "Hellenika/SingingStoneD.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 30
#size 4
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7073
#spr1 "Hellenika/SingingStoneE.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 20
#size 3
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7074
#spr1 "Hellenika/SingingStoneF.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 30
#size 4
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7075
#spr1 "Hellenika/SingingStoneG.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 30
#size 4
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#montag 4130
#gcost 0
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 6820
#spr1 "Hellenika/SingingStoneA.tga"
#name "Singing Stone"
#descr "Singing Stones are the most common of megaliths, and they are small and crude enough to sometimes be confused with regular rocks and stones. This illusion, however, does not stand a detailed examination, for in addition to their unnatural standing position, they are always accompanied by many others, with which they form strange shapes and figures over vast areas. Most of the time, their disposition is either circular, linear or grid-like, and thus, they seem to delimit a territory within which the laws of the mundane world no longer apply. Like most other megaliths, they have always existed and been feared or worshipped by living beings, even before the Geodetic Awakening, that simply let them progressively recover their sentience. Legends say that Singing Stones are guardians of the lands of the Dead and that the Veil that separates the Two Worlds becomes extremely thin in their vicinity. It is also said that weird faeries and goblins called the korrigans live below Singing Stone alignments or even themselves take the shape of such monoliths during the day, only returning to life at night. But more recently, darker rumors about them have started to be heard. Many people are disappearing in the barren fields over which the Singing Stones watch, and each time, a new Singing Stone seems to appear. It is whispered that anyone that profanes the sacred stone fields of Karanaac will be cursed for the rest of their lives and changed to stone to keep watch over the fields forever. But the fields are growing a little more every day, and soon, the living won't be able to avoid them anymore. Although Singing Stones are useless by themselves, they are almost indestructible and hold a great power when numerous enough. As long as no-one desecrates them, they bear good luck and mimic the framework of the sky, thus preventing bad events from happening; but their principal use to Karanaac resides in their ability to join its great communions, helping their casters tremendously."
#noheal
#hp 20
#size 3
#prot 17
#mr 13
#mor 30
#str 10
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#comslave
#spellsinger
#firstshape -4130
#gcost 20
#rcost 1
#rpcost 15
#addupkeep -20
#nobadevents 1
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7076
#spr1 "Hellenika/Menhir.tga"
#name "Menhir"
#descr "Menhirs are huge and usually very ancient standing stones that can often be found in megalithic arrays, silently watching over singing stones, and revered by men as noble guardians of the spiritual world. Unlike their smaller and cruder brethren, their stature is too great and unmistakable to be that of mere cursed humans, and thus, it is speculated that they are inhabited by souls of another age, which explains why they have a more sacred status in Karanaac. Still, all the while surpassing them in efficiency, they share most of the singing stones' other characteristics, such as their near-invulnerability, their ability to bring or avert misfortune, their participation to geodetic choruses, and the fact that they have always seemed to exist, even before the Awakening and even though they are now increasing in numbers like never before. In addition, menhirs are eternally vigilant and are tall enough to sense undesirable presences over great areas, thus acting much like enchanted scarecrows against even the most clever of intruders."
#noheal
#hp 60
#size 4
#prot 20
#mr 15
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#comslave
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#montag 4132
#patrolbonus 6
#fixedresearch 8
#nobadevents 4
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7077
#spr1 "Hellenika/Menhir2.tga"
#name "Menhir"
#descr "Menhirs are huge and usually very ancient standing stones that can often be found in megalithic arrays, silently watching over singing stones, and revered by men as noble guardians of the spiritual world. Unlike their smaller and cruder brethren, their stature is too great and unmistakable to be that of mere cursed humans, and thus, it is speculated that they are inhabited by souls of another age, which explains why they have a more sacred status in Karanaac. Still, all the while surpassing them in efficiency, they share most of the singing stones' other characteristics, such as their near-invulnerability, their ability to bring or avert misfortune, their participation to geodetic choruses, and the fact that they have always seemed to exist, even before the Awakening and even though they are now increasing in numbers like never before. In addition, menhirs are eternally vigilant and are tall enough to sense undesirable presences over great areas, thus acting much like enchanted scarecrows against even the most clever of intruders."
#noheal
#hp 60
#size 4
#prot 20
#mr 15
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#comslave
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#montag 4132
#patrolbonus 6
#fixedresearch 8
#nobadevents 4
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 7078
#spr1 "Hellenika/Menhir3.tga"
#name "Menhir"
#descr "Menhirs are huge and usually very ancient standing stones that can often be found in megalithic arrays, silently watching over singing stones, and revered by men as noble guardians of the spiritual world. Unlike their smaller and cruder brethren, their stature is too great and unmistakable to be that of mere cursed humans, and thus, it is speculated that they are inhabited by souls of another age, which explains why they have a more sacred status in Karanaac. Still, all the while surpassing them in efficiency, they share most of the singing stones' other characteristics, such as their near-invulnerability, their ability to bring or avert misfortune, their participation to geodetic choruses, and the fact that they have always seemed to exist, even before the Awakening and even though they are now increasing in numbers like never before. In addition, menhirs are eternally vigilant and are tall enough to sense undesirable presences over great areas, thus acting much like enchanted scarecrows against even the most clever of intruders."
#noheal
#hp 60
#size 4
#prot 20
#mr 15
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#comslave
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#montag 4132
#patrolbonus 6
#fixedresearch 8
#nobadevents 4
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 6817
#spr1 "Hellenika/Menhir.tga"
#name "Menhir"
#descr "Menhirs are huge and usually very ancient standing stones that can often be found in megalithic arrays, silently watching over singing stones, and revered by men as noble guardians of the spiritual world. Unlike their smaller and cruder brethren, their stature is too great and unmistakable to be that of mere cursed humans, and thus, it is speculated that they are inhabited by souls of another age, which explains why they have a more sacred status in Karanaac. Still, all the while surpassing them in efficiency, they share most of the singing stones' other characteristics, such as their near-invulnerability, their ability to bring or avert misfortune, their participation to geodetic choruses, and the fact that they have always seemed to exist, even before the Awakening and even though they are now increasing in numbers like never before. In addition, menhirs are eternally vigilant and are tall enough to sense undesirable presences over great areas, thus acting much like enchanted scarecrows against even the most clever of intruders."
#noheal
#hp 60
#size 4
#prot 19
#mr 15
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#comslave
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 55
#rcost 1
#rpcost 35
#addupkeep -55
#holy
#firstshape -4132
#patrolbonus 6
#fixedresearch 8
#nobadevents 4
#weapon 118
#nametype 142
#deathcurse
#end

#newmonster 6804
#copystats 14 -- MA/LA Arcoscephale Hoplite
#spr1 "Hellenika/Hoplite_1.tga"
#spr2 "Hellenika/Hoplite_2.tga"
#name "Hoplite"
#descr "Hoplites are the primary corps of Cyanautha. They carry long spears, shields and cumbersome plate hauberks. Hoplites are quite slow but very efficient. Few enemies can stand against the massive spear wall of a hoplite army. Those that are recruited among the population of the nation's dry land colonies aren't blessed with the ability to breath underwater, but they do not need to be equipped with rust-resistant armaments and therefore use less expensive armor and weaponry."
#gcost 11
#end

#newmonster 7079
#copystats 14 -- MA/LA Arcoscephale Hoplite
#spr1 "Hellenika/PearlHoplite_1.tga"
#spr2 "Hellenika/PearlHoplite_2.tga"
#name "Hydrelephantine Hoplite"
#descr "Hoplites are the primary corps of Cyanautha. They carry long spears, shields and cumbersome plate hauberks. Hoplites are quite slow but very efficient. Few enemies can stand against the massive spear wall of a hoplite army. Cyanautha's hoplites are famed for their nacre armaments made out of the Ivory of the Sea. They are therefore called Hydrelephantine and their equipment both resists rust and allows them to strike true even against the ethereal ghosts of Therodos."
#pooramphibian
#mor 12
#att 12
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 1159 -- Pearl Long Spear
#gcost 13
#rpcost 18
#end

#newmonster 7080
#copystats 14 -- MA/LA Arcoscephale Hoplite
#spr1 "Hellenika/GoldHoplite_1.tga"
#spr2 "Hellenika/GoldHoplite_2.tga"
#name "Chryselephantine Hoplite"
#descr "Hoplites are the primary corps of Cyanautha. They carry long spears, shields and cumbersome plate hauberks. Hoplites are quite slow but very efficient. Few enemies can stand against the massive spear wall of a hoplite army. Throughout the centuries, thanks to clever trade with Pelagia and Berytos as well its heroes' conquests both over and under the waves, Argolinth has accumulated vast treasures and added them to the opulent riches it retained from its glorious past under the Telkhines' leadership. Thus, the bravest of hoplites are rewarded by being allowed to bear Chryselephantine masterwork armaments of gleaming gold and nacre. Although their upkeep is increased by half as a result of the maintenance required to keep their arms and armor in perfect condition, they become awe-inspiring warriors all the while retaining their ability to fight ethereal beings and to resist rust. Chryselephantine hoplites are only recruitable in positive dominion, and a Chryselephantine Commander or Champion must be present to train them."
#pooramphibian
#mor 14
#mr 12
#att 12
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1195 -- Golden Long Spear
#awe 2
#domrec
#reclimit 5
#monpresentrec -4134
#gcost 14
#addupkeep 7
#rpcost 20
#end

#newmonster 6806
#copystats 1077 -- Myrmidon
#spr1 "Hellenika/CyanMyrmidon_1.tga"
#spr2 "Hellenika/CyanMyrmidon_2.tga"
#name "Myrmidon"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes. The Myrmidons of the dry lands are not descendants of the Fifty like their kin beneath the waves, but they have devoted their lives to the imitation of the ancient champions. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their days traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. Although the people of the dry land colonies does not descend from Cyanautha's legendary heroes and was thus born without the God's blessing of water breathing, its troops still are formidable in both skills and armaments."
#holy
#reclimit 3
#sailing 40 6
#gcost 20
#end

#newmonster 7081
#copystats 1077 -- Myrmidon
#spr1 "Hellenika/PearlMyrmidon_1.tga"
#spr2 "Hellenika/PearlMyrmidon_2.tga"
#name "Hydrelephantine Myrmidon"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes. As the children and heirs of the Fifty, they live to imitate and resemble them. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their days traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. As their characteristic ant-like armor as well as their weapons are usually made out of the Ivory of the Sea - iridescent nacre cultivated in clam fields by the people of Argolinth -, they are called Hydrelephantine and are both able to fight underwater without their armaments rusting and to strike true even against the ethereal ghosts of Therodos."
#pooramphibian
#mor 14
#att 13
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 665 -- Pearl Blade
#holy
#reclimit 3
#sailing 40 6
#gcost 22
#rpcost 23
#end

#newmonster 7082
#copystats 1077 -- Myrmidon
#spr1 "Hellenika/GoldMyrmidon_1.tga"
#spr2 "Hellenika/GoldMyrmidon_2.tga"
#name "Chryselephantine Myrmidon"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes. As the children and heirs of the Fifty, they live to imitate and resemble them. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their days traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. Throughout the centuries, thanks to clever trade with Pelagia and Berytos as well its heroes' conquests both over and under the waves, Argolinth has accumulated vast treasures and added them to the opulent riches it retained from its glorious past under the Telkhines' leadership. Thus, those among the myrmidons who prove their worth are rewarded by being allowed to bear Chryselephantine masterwork armaments of gleaming gold and nacre. Although unlike other sacred troops their upkeep, rather than reduced, is increased by half as a result of the maintenance required to keep their arms and armor in perfect condition, they become awe-inspiring warriors all the while retaining their ability to fight ethereal beings and to resist rust."
#pooramphibian
#mor 15
#mr 12
#att 13
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1158 -- Golden Sword
#awe 2
#reclimit 3
#holy
#sailing 40 6
#gcost 25
#addupkeep 50
#rpcost 25
#end

#newmonster 7083
#spr1 "Hellenika/DolphinRider1.tga"
#spr2 "Hellenika/DolphinRider2.tga"
#name "Dolphin Rider"
#descr "Although their fighting style is too different and new from that of the ancient heroes to grant them sacred status, Dolphin Riders are one of the most emblematic troops of Cyanautha since its renewal as a kingdom under the sea after the fall of Therodos. They are Cyanautha's only cavalry and the greatest of its defenders in the deeps. These white knights relentlessly patrol the kingdom and restore order and justice within it when needed. Their noble mounts are both strong and nimble and they truly are the best ally of man in the oceanic realms. They are capable of hitting several enemies at once with broad sweeps of their powerful tail, and their sixth sense allows them to locate even invisible targets."
#att 12
#hp 13
#prot 0
#prec 10
#ap 30
#maxage 50
#aquatic
#size 3
#ressize 2
#mor 15
#mr 12
#def 13
#enc 5
#str 12
#mapmove 24
#mounted
#mountedhumanoid
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 1159 -- Pearl Long Spear
#weapon 1104 -- Tail Sweep
#gcost 55
#rcost 1
#rpcost 46
#patrolbonus 3
#spiritsight
#end

#newmonster 7084
#spr1 "Hellenika/DolphinInterceptor1.tga"
#spr2 "Hellenika/DolphinInterceptor2.tga"
#name "Dolphin Interceptor"
#descr "Dolphin Interceptors are the elite of Cyanautha's underwater military and combine the abilities of Chryselephantine Myrmidons with those of Dolphin Riders. In addition, unlike other Dolphin Riders they ride albino mounts that gift them with wondrous powers of regeneration, and since they are selected from among the direct descendants of the heroes of the ancient times, they are considered sacred even though their fighting style widely differs from their ancestors'. Along with the lesser Dolphin Riders, they are Cyanautha's only cavalry and the greatest of its defenders in the deeps. These golden knights relentlessly patrol the kingdom and restore order and justice within it when needed. Their noble mounts are both strong and nimble and they truly are the best ally of man in the oceanic realms. They are capable of hitting several enemies at once with broad sweeps of their powerful tail, and their sixth sense allows them to locate even invisible targets."
#att 12
#hp 13
#prot 0
#prec 10
#ap 30
#maxage 50
#nametype 107
#aquatic
#size 3
#ressize 2
#mor 16
#mr 14
#def 13
#enc 5
#awe 2
#str 12
#mapmove 24
#holy
#heal
#reclimit 3
#mounted
#mountedhumanoid
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1195 -- Golden Long Spear
#weapon 1104 -- Tail Sweep
#gcost 85
#addupkeep 170
#rcost 1
#rpcost 46
#patrolbonus 5
#spiritsight
#end

#selectmonster 2321 -- Clockwork Soldier
#gcost 5
#reqlab
#addupkeep -5
#rcost 61
#monpresentrec 4802 -- Mage Engineer
#end

#selectmonster 760 -- Siege Golem
#gcost 150
#rcost 300
#reqlab
#rpcost 1
#reclimit 1
#addupkeep -150
#monpresentrec 4802 -- Mage Engineer
#end

#newmonster 7085
#spr1 "Hellenika/Apprentice_1.tga"
#spr2 "Hellenika/Apprentice_2.tga"
#name "Engineer Apprentice"
#descr "Engineer Apprentices are relatively young students of geometry, optics, mechanics and the magic of the Spheres that are taught by the Mage Engineers and help them in their great undertaking of constructing the nation's defensive as well as offensive war machines. In times of war, they can be put to direct use by letting them operate one of the most powerful mundane weapons known to man, an incredibly clever device known as a mirror lens and whose secret is still jealously kept by Cyanautha's leaders and scientists. By astutely redirecting and focusing light on a single point, Engineer Apprentices can use these wondrous arrays to burn away dangerous foes - a slow but very precise process that is entirely inefficient underwater but can pierce armor and blind mortal eyes in a small area. In spite of their great impact in battles and of the fact that the nation's only ranged weapon rests in their hands, Engineer Apprentices are very few in number, for their complex training requires a lot of time and investment as well as very specific infrastructure. Just like clockwork soldiers and siege golems, Engineer Apprentices can only be recruited if a lab and a Mage Engineer are both present in the province."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 13
#mor 9
#str 10
#att 8
#def 8
#prec 10
#ap 10
#mapmove 14
#enc 3
#maxage 50
#older 15
#rpcost 16
#gcost 50
#rcost 1
#reclimit 1
#reqlab
#monpresentrec 4802 -- Mage Engineer
#resources 3
#siegebonus 5
#castledef 5
#weapon 637
#weapon 1157
#end

#selectmonster 201 -- Peltast
#name "Peltast"
#descr "The peltasts are the light infantry of Arcoscephale and are also used by most other similar and concurrent city-state. They have almost no armor and are mainly used as javelin throwers."
#end

#selectmonster 14 -- Hoplite
#name "Hoplite"
#descr "Hoplites are the primary corps of Delphanes. Although they often come from other lands, they are united under the sacred mission of protecting the City of Oracles, and they all receive the same military education from the military commanders of Delphanes. They carry long spears, shields and cumbersome plate hauberks. Hoplites are quite slow but very efficient. Few enemies can stand against the massive spear wall of a hoplite army."
#gcost 11
#end

#selectmonster 1551 -- Phalangite
#gcost 11
#end

#selectmonster 16 -- Hypaspist
#gcost 14
#woundfend 1
#str 12
#att 12
#mr 11
#enc 2
#hp 12
#mor 14
#end

#selectmonster 747 -- Heart Companion
#name "Heart Companion"
#descr "The Heart Companions serve the Priestesses of the temples and are famous throughout Delphanes as the closest and most faithful of their guardians. They live and fight side by side with their lovers and brothers-in-arms and willingly give their earthly possessions to the temples. The Companions are held in high esteem and it would be a most ominous event should they falter in battle."
#gcost 5
#rpcost 23
#enc 2
#mor 16
#end

#selectmonster 1553 -- Agema Companion
#name "Agema Companion"
#descr "The Royal Companions are mounted elite warriors of great skill and discipline. They are often sons of royal blood from other nations that were chosen as a great tribute to the Sibyls, which has given them their name. By renouncing their heritage and swearing life-long allegiance to Delphanes, they ensure the good fortune of their former kingdom, so they'll never betray their engagements."
#gcost 30
#end

#selectmonster 3164 -- Keledone
#name "Keledone"
#descr "Keledones are sacred, singing statues of gold once made by the Titan of the Forge. Their songs are attuned to the music of the spheres and they are constantly joined in an arcane communion. Now they adorn the palaces and temples of Arcoscephale, Delphanes, Phaeacia, Erytheia and Cyanautha, whose craftsmen and mages have learned how to replicate the wondrous automatons. Keledones have the form of beautiful women cast of pure gold. They are too heavy to be moved and cannot move on their own accord."
#holy
#end

#selectmonster 1556 -- Cerulean Warrior
#name "Cerulean Warrior"
#descr "Located close from the mighty kingdom of Bandar Log, Delphanes has always kept close ties with its mystics and its people. Through sheer spiritual influence, it has even gained a valuable ally in the Cerulean Maharaja. The Maharaja gave the generals of Delphanes an army of apes from his personal retinue. The Bandar warriors of the Cerulean Legion joined the City at the Centre of the World where they were given a portion of the capital and a mighty tower to defend. Now the Cerulean Warriors in their blue armor have become known among the enemies of Delphanes as fierce and skillful warriors. Still being armed and paid by their ape lords, they cost no upkeep and are very cheap both in resources and in infrastructure in spite of their formidable strength and discipline."
#rcost -18
#rpcost 1
#addupkeep -18
#reclimit 10
#end

#selectmonster 3016 -- Triton Knight
#name "Triton Knight"
#descr "Many Triton noble families were banished from Pelagia for their involvement in the Civil War. Some took shelter in the parts of the sea that were under the protection of Erytheia and in exchange for their loyalty are now allowed to rule the lands once theirs as administrators and military leaders. They follow old traditions and train hippocampoi steeds just like the sacred Knights of the Deeps they once were. But Tritons are no longer priests in Erytheia, nor are they trained as holy warriors of the Setting Sun's faith. Now they are but soldiers and generals expected to lead the Triton armies in conquest for the King of Both Worlds."
#mapmove 24
#end

#selectmonster 3015 -- Triton Hoplite
#name "Triton Hoplite"
#descr "While in Erytheia the mermen are the formal rulers of the realms of the sea, Tritons still make up most of the underwater population. Triton hoplites, armed in bronze hauberks of Pelagian design improved by the artisans of Arcoscephalian descent are both stronger and more skilled than their merman counterparts and are instrumental in the conquest of the underwater world."
#end

#selectmonster 3014 -- Triton Soldier
#name "Triton Soldier"
#descr "Although the Triton kingdom of Pelagia has since completely recovered and is now as powerful as ever, it suffered greatly during the Civil War. While the ruling Tritons battled each other many mermen withdrew and those that did eventually founded Erytheia, the Red Land. Now the mermen have reclaimed the seas and become Pelagia's rivals and enemies, but exiled Triton nobles are allowed to rule the old provinces as governors and administrators in exchange for their loyalty. There are still only a few mermen in Erytheia's seas and Tritons make up most of the underwater population, as well as the armies."
#end

#selectmonster 3013 -- Triton Militia
#name "Triton Militia"
#descr "Although the Triton kingdom of Pelagia has since completely recovered and is now as powerful as ever, it suffered greatly during the Civil War. While the ruling Tritons battled each other many mermen withdrew and those that did eventually founded Erytheia, the Red Land. Now the mermen have reclaimed the seas and become Pelagia's rivals and enemies, but exiled Triton nobles are allowed to rule the old provinces as governors and administrators in exchange for their loyalty. There are still only a few mermen in Erytheia's seas and Tritons make up most of the underwater population, as well as the armies."
#end

#selectmonster 3030 -- Erytheian Crossbowman
#name "Erytheian Crossbowman"
#descr "Since the days of the Civil War mermen have encountered and suffered at the hands of human archers. The Kings and Queens of Erytheia have realized that ranged troops are instrumental if one is to conquer human lands. However, ranged weapons can be useful underneath the waves as well. Thanks to the genius of a few Arcoscephalian artisans as well as to unearthed Telkhine secrets, while looking for a way to design underwater ranged weapons, Erytheian engineers have developed one of the first crossbows of the world, the gastraphetes. On dry land, it is inferior to the crossbows of later ages, but it allows its wielder to fire arrows in the water, albeit with reduced range."
#end

#selectmonster 3031 -- Erytheian Crossbowman
#name "Erytheian Crossbowman"
#descr "Since the days of the Civil War mermen have encountered and suffered at the hands of human archers. The Kings and Queens of Erytheia have realized that ranged troops are instrumental if one is to conquer human lands. However, ranged weapons can be useful underneath the waves as well. Thanks to the genius of a few Arcoscephalian artisans as well as to unearthed Telkhine secrets, while looking for a way to design underwater ranged weapons, Erytheian engineers have developed one of the first crossbows of the world, the gastraphetes. On dry land, it is inferior to the crossbows of later ages, but it allows its wielder to fire arrows in the water, albeit with reduced range."
#end

#selectmonster 3020 -- Erytheian Phalangite
#name "Erytheian Phalangite"
#descr "The phalangites are the elites of Erytheia, fighting in close formations in the style of Arcoscephale, and using even better armaments of Telkhine design. While of merman stock, they are armed with iron weapons and are not supposed to conquer the sea; that task is left for the bronze-clad hoplites."
#end

#selectmonster 3021 -- Erytheian Phalangite
#name "Erytheian Phalangite"
#descr "The phalangites are the elites of Erytheia, fighting in close formations in the style of Arcoscephale, and using even better armaments of Telkhine design. While of merman stock, they are armed with iron weapons and are not supposed to conquer the sea; that task is left for the bronze-clad hoplites."
#end

#selectmonster 3022 -- Erytheian Hoplite
#name "Erytheian Hoplite"
#descr "The bronze-clad hoplites of Erytheia are trained and equipped in the fashion of the old hoplites of Therodos and wear armors whose design was kept alive in the Red Land and modified according to the mermen's needs by Arcoscephalian artisans of Therodian descent. Their main role is to be a heavy and flexible contingent able to strike from land into the sea, or from the sea into coastal regions. Since they are weaker than the Triton hoplites in underwater battles, and not as efficient as the phalangites on dry land, they are seen as redundant by some military leaders."
#end

#selectmonster 3023 -- Erytheian Hoplite
#name "Erytheian Hoplite"
#descr "The bronze-clad hoplites of Erytheia are trained and equipped in the fashion of the old hoplites of Therodos and wear armors whose design was kept alive in the Red Land and modified according to the mermen's needs by Arcoscephalian artisans of Therodian descent. Their main role is to be a heavy and flexible contingent able to strike from land into the sea, or from the sea into coastal regions. Since they are weaker than the Triton hoplites in underwater battles, and not as efficient as the phalangites on dry land, they are seen as redundant by some military leaders."
#end

#selectmonster 3051 -- Soldier of the Setting Sun
#name "Soldier of the Setting Sun"
#descr "Erytheia, the Red Land, got its name from the Red River, colored golden by the setting sun. Here the exiled Pelagian torch-bearers found the splendor of the Closed Realm brilliant and manifest. The mystery of the Red River let them imbue pearls and gold with the splendor of the setting sun. They brought their mystery as a gift to the King of Both Worlds who adorned his most loyal soldiers in brilliant jewelry made of pearls and red gold. The soldiers were equipped with the last remaining weapons from the now rival kingdom of Pelagia and were prepared for the advent of the Awakening God. The Soldiers of the Setting Sun wield jewelry and armors that reinvigorates them and shines with unbearable splendor of the setting sun while under the light of the sun. The aura of splendor is extinguished in darkness and underneath the waves. In addition, the people's adoration for them is so great that the offerings they receive exceed their upkeep."
#enc 2
#sunawe 3
#gold 2
#gcost 40
#reinvigoration 1
#addupkeep -40
#end

#selectmonster 3052 -- Soldier of the Setting Sun
#name "Soldier of the Setting Sun"
#descr "Erytheia, the Red Land, got its name from the Red River, colored golden by the setting sun. Here the exiled Pelagian torch-bearers found the splendor of the Closed Realm brilliant and manifest. The mystery of the Red River let them imbue pearls and gold with the splendor of the setting sun. They brought their mystery as a gift to the King of Both Worlds who adorned his most loyal soldiers in brilliant jewelry made of pearls and red gold. The soldiers were equipped with the last remaining weapons from the now rival kingdom of Pelagia and were prepared for the advent of the Awakening God. The Soldiers of the Setting Sun wield jewelry and armors that reinvigorates them and shines with unbearable splendor of the setting sun while under the light of the sun. The aura of splendor is extinguished in darkness and underneath the waves. In addition, the people's adoration for them is so great that the offerings they receive exceed their upkeep."
#enc 2
#sunawe 3
#gold 2
#gcost 40
#reinvigoration 1
#addupkeep -40
#end

#selectmonster 3165 -- Colossi Light Infantry
#name "Colossi Light Infantry"
#descr "The Colossi have ruled Phaeacia since berytian times. They are dark-skinned men of great stature originally descendant from the Lion Clan royalty of Great Mababwe, that still reigns today over the far away lands of Machaka. Phaeacia was one of the most prosperous colonies of the Phoenix Empire and many colossi moved to the blessed isle. With time the colossi became almost as numerous as the humans. When Berytos abandoned Phaeacia, its colossi were a thriving part of the broader population, and not just a small and privileged group. Now the colossi and the humans live and fight side by side. Colossi infantry are armed much in the same way as their human counterparts. Light infantry wear linen cuirasses and wield spears and javelins. Heavy infantry don plate cuirasses and wield short swords."
#end

#selectmonster 3148 -- Colossi Heavy Infantry
#name "Colossi Heavy Infantry"
#descr "The Colossi have ruled Phaeacia since berytian times. They are dark-skinned men of great stature originally descendant from the Lion Clan royalty of Great Mababwe, that still reigns today over the far away lands of Machaka. Phaeacia was one of the most prosperous colonies of the Phoenix Empire and many colossi moved to the blessed isle. With time the colossi became almost as numerous as the humans. When Berytos abandoned Phaeacia, its colossi were a thriving part of the broader population, and not just a small and privileged group. Now the colossi and the humans live and fight side by side. Colossi infantry are armed much in the same way as their human counterparts. Light infantry wear linen cuirasses and wield spears and javelins. Heavy infantry don plate cuirasses and wield short swords."
#end

#selectmonster 3146 -- Phaeacian Infantry
#name "Phaeacian Infantry"
#descr "The human infantry of Phaeacia are armed in much the same way as their berytian rivals. They carry short swords and wear scale cuirasses. Like most human inhabitants of the blessed isle, they have unnaturally long lifespans."
#end

#selectmonster 3145 -- Phaeacian Light Infantry
#name "Phaeacian Light Infantry"
#descr "The human infantry of Phaeacia are armed in much the same way as their berytian rivals. The light infantry carry spears and javelins and don linen armors. Like most human inhabitants of the blessed isle, they have unnaturally long lifespans."
#end

#selectmonster 3144 -- Phaeacian Archer
#name "Phaeacian Archer"
#descr "The human archers of Phaeacia are armed in much the same way as their berytian rivals. Like most human inhabitants of the blessed isle, they have unnaturally long lifespans."
#end

#selectmonster 3150 -- Gigante
#name "Gigante"
#descr "When Eurymedon, King of the Gigantes like his brother Polybotes, led his kin to war against the gods of men, his son Nausithous saw the folly of his ways and fled with a few followers to distant lands. Eventually the Gigantes settled on Black Korkyra in the phaeacian archipelago, where they still hope never to be found by the armies of the God-slayer. After a short conflict the Gigantes yielded and Nausithous offered himself in marriage to the Colossi Queen. The Gigantes of Black Korkyra still fight in dense hoplite formations. Only a few of the gleaming armors crafted by the Elder Cyclopes have survived since Phaeacia's Gigantes fled their kingdom, so they now use regular spears and plate cuirasses."
#gcost 0
#hp 42
#end

#newmonster 7407
#copystats 3111
#spr1 "./Hellenika/KorkyraElite1.tga"
#spr2 "./Hellenika/KorkyraElite2.tga"
#name "Gigante Elite"
#descr "When Eurymedon, King of the Gigantes like his brother Polybotes, led his kin to war against the gods of men, his son Nausithous saw the folly of his ways and fled with a few followers to distant lands. Eventually the Gigantes settled on Black Korkyra in the phaeacian archipelago, where they still hope never to be found by the armies of the God-slayer. After a short conflict the Gigantes yielded and Nausithous offered himself in marriage to the Colossi Queen. The Gigantes of Black Korkyra still fight in dense hoplite formations. Only a few of the gleaming armors crafted by the Elder Cyclopes have survived since Phaeacia's Gigantes fled their kingdom, so they now use regular spears and plate cuirasses."
#hp 45
#mor 14
#str 20
#att 13
#def 13
#cleararmor
#clearweapons
#weapon 473
#armor 237
#armor 238
#armor 239
#maxage 250
#startage 100
#addrandomage 20
#end

#selectmonster 3132 -- Helote Archer
#name "Helote Archer"
#descr "The Tyrants of Phlegra, like their mekonean cousins, have enslaved their human neighbors. The Gigantes of Phlegra have spawned in ever greater numbers, but the helotes are still used to fill up the ranks of the Phlegran armies. The helotes of Phlegra are not just recruited in the cities, but everywhere in the kingdom. Unlike the helotes of mekonean lands the slaves of Phlegra don't have any prospects of promotion. As long as they fight for the Gigantes they can hope that their families are spared. Helote archers have abysmal morale and need to be whipped into coercion by Tyrants or human taskmasters in order to fight effectively."
#end

#selectmonster 3133 -- Helote Warrior
#name "Helote Warrior"
#descr "The Tyrants of Phlegra, like their mekonean cousins, have enslaved their human neighbors. The Gigantes of Phlegra have spawned in ever greater numbers, but the helotes are still used to fill up the ranks of the Phlegran armies. The helote warriors of Phlegra are not just recruited in the cities, but everywhere in the kingdom. Unlike the helotes of mekonean lands the slaves of Phlegra don't have any prospects of promotion. As long as they fight for the Gigantes they can hope that their families are spared. Helote warriors have abysmal morale and need to be whipped into coercion by Tyrants or human taskmasters in order to fight effectively."
#end

#selectmonster 3134 -- Helote Soldier
#name "Helote Soldier"
#descr "The Tyrants of Phlegra, like their mekonean cousins, have enslaved their human neighbors. The Gigantes of Phlegra have spawned in ever greater numbers, but the helotes are still used to fill up the ranks of the Phlegran armies. Unlike the helotes of mekonean lands the slaves of Phlegra don't have any prospects of promotion. As long as they fight for the Gigantes they can hope that their families are spared. Helote soldiers have abysmal morale and need to be whipped into coercion by Tyrants or human taskmasters in order to fight effectively."
#end

#selectmonster 3140 -- Gigante Warrior
#name "Gigante Warrior"
#descr "The Phlegran Gigantes are the descendants of semi-divine Gigantes, who once allied with the Telkhines and declared war upon the Pantokrator. Punished for their hubris the Gigantes were cursed by a celestial decree. Although they are among the largest and strongest of remaining giants, they have lost much of the discipline and skills of earlier times and their bodies show signs of the curse. The curse has also made them violent and easy to anger. Phlegran Gigantes are frightening to behold with long hair and serpentine scales covering their legs, and their bodies have become resistant to heat and poison. While their Tyrants still wear armaments crafted by the Elder Cyclopes, most Gigante Warriors wear simple armor of leather and metal scales. Gigante Warriors are arrogant and proud and never take command from human-sized generals. In their hubris they believe themselves above the gods and they force the population to worship them."
#hp 68
#fireres 15
#end

#newmonster 6617 -- DO NOT CHANGE ID (xpshape)
#copyspr 1367 -- Angel of the Heavenly Choir
#copystats 2056 -- Malakh
#name "Angel" -- Gabriel/Leliel
#descr "Angels are holy agents of the celestial spheres who usually manifest as winged, sexless humanlike beings dressed in white robes, radiant light and incomparable beauty and purity. Although some of them in the past have been known or at least perceived to serve other deities or to operate with greater independence, never before the awakening of Bethel She'em's Lord have so many been observed to descend in the material realms and to take such interest in mortal destinies. As a result, many scholars assume that they are united for the most part and in this time and day work together towards a single goal, which disturbingly appears to have recently become the eradication of mankind; but there are others still who fear or trust that great wars may have been waged in Heaven in the past and possibly still to this day between several immense angelic empires, sects or coalitions and that the Litany of Cinders is but one of them, even though no one besides the other pretender gods and their own servants seems to have descended yet to oppose its global invasion. In any case, Bethel She'em's angels are organized following a strict vertical order divided in nine classes and thus named the Ennearchy. The lowest of these ranks is nameless just like most of its members, who are usually tasked with delivering messages, singing the glory of the Lord and acting as infantry in battle. Since angels mostly lack the mortals' ability to carve their own path and destiny through free-will, they are by themselves completely incapable of overcoming their fundamental nature and of changing their metaphysical identity. In spite of this, and even though the angelic hierarchy is primarily based on innate individual worth, by distinguishing themselves by their deeds all angels may be chosen by the God, undergo Transubstantiation and reach a higher dignity. By doing so, a nameless angel will first be christened and awarded with a heavenly horn which can smite enemies and bring great zeal to allies."
#nametype 139
#xpshape 100
#patrolbonus 1
#castledef 1
#siegebonus 1
#bodyguard 3
#str 5
#att 10
#def 11
#mr 14
#magicpower 1
#weapon 1121
#end -- possible weapons: 92, 282, 387, 284, 516

#newmonster 6618 -- DO NOT CHANGE ID (xpshape)
#spr1 "Hellenika/PromotedAngel1.tga"
#spr2 "Hellenika/PromotedAngel2.tga"
#copystats 2056 -- Malakh
#name "Angel"
#descr "Angels are holy agents of the celestial spheres who usually manifest as winged, sexless humanlike beings dressed in white robes, radiant light and incomparable beauty and purity. Although some of them in the past have been known or at least perceived to serve other deities or to operate with greater independence, never before the awakening of Bethel She'em's Lord have so many been observed to descend in the material realms and to take such interest in mortal destinies. As a result, many scholars assume that they are united for the most part and in this time and day work together towards a single goal, which disturbingly appears to have recently become the eradication of mankind; but there are others still who fear or trust that great wars may have been waged in Heaven in the past and possibly still to this day between several immense angelic empires, sects or coalitions and that the Litany of Cinders is but one of them, even though no one besides the other pretender gods and their own servants seems to have descended yet to oppose its global invasion. In any case, Bethel She'em's angels are organized following a strict vertical order divided in nine classes and thus named the Ennearchy. The lowest of these ranks is nameless just like most of its members, who are usually tasked with delivering messages, singing the glory of the Lord and acting as infantry in battle. Since angels mostly lack the mortals' ability to carve their own path and destiny through free-will, they are by themselves completely incapable of overcoming their fundamental nature and of changing their metaphysical identity. In spite of this, and even though the angelic hierarchy is primarily based on innate individual worth, by distinguishing themselves by their deeds all angels may be chosen by the God, undergo Transubstantiation and reach a higher dignity. By doing so, a nameless angel will first be christened and awarded with a heavenly horn which can smite enemies and bring great zeal to allies."
#nametype 139
#standard 2
#bodyguard 3
#hp 17
#str 7
#att 10
#def 11
#mr 14
#magicpower 1
#clearweapons
#weapon 1121
#weapon 145
#patrolbonus 1
#castledef 1
#siegebonus 1
#end

#selectmonster 2391 -- Triton Rider
#name "Triton Rider"
#descr "These elite Triton warriors are the predecessors of the Triton knights of later eras. They ride hippocampoi, magical steeds that are able to strike enemies or heal their rider with their horns, and they are among the fastest military forces known to the underwater realms."
#mapmove 24
#end

#newmonster 6944
#copyspr 676
#copystats 676
#name "Lemur Shade"
#descr "Shades are spirit natives of the Shade Lands between the Underworld and the land of the living. Shades appear as beings composed of darkness and their touch can steal strength from living beings. In the deepest reaches of the Shade Lands rests the forgotten realm of Lemuria. Lemur Shades are even more horrifying that their more common counterparts; they are indestructible, strike fear in the hearts of their victims, drain their very lifeforce with a mere touch and draw great strength from surrounding darkness and magic."
#immortal
#fear
#mr 16
#hp 15
#clearweapons
#weapon 63
#weapon 284
#magicpower 1
#darkpower 4
#montag 4163
#end

#newmonster 6945
#copyspr 675
#copystats 675
#name "Lemur Soldier"
#descr "Shadows are the spiritual remains of deceased people that have become lost in the Shade Lands between the Underworld and the land of the living. The Shade Lands have robbed them of their spiritual strength, but they are still stronger than the dispossessed spirits that never left the physical world. Those who reach the heart of the Shade Lands become one with the whispering people of Lemuria and form its spectral armies. There, they endlessly roam the Underworld, re-enacting the battles that consumed their mortal lives and executing the will of the Grand Lemurs. Now they have been interrupted from their eternal wars and brought back to fight the living. Their weapons are not of this world and will not wound those strong of mind, but they are better armored than most other shades. Like other Lemurs, they are cursed with immortality and draw great strength from surrounding darkness and magic."
#immortal
#invulnerable 10
#hp 10
#str 10
#att 10
#mr 16
#mor 14
#clearweapons
#weapon 281
#weapon 279
#armor 156
#magicpower 1
#darkpower 4
#montag 4163
#woundfend 3
#end

#newmonster 6946
#copyspr 2125
#copystats 2125
#name "Lemur Shadow"
#descr "Shadows are the spiritual remains of deceased people that have become lost in the Shade Lands between the Underworld and the land of the living. The Shade Lands have robbed them of their spiritual strength, but they are still stronger than the dispossessed spirits that never left the physical world. Those who reach the heart of the Shade Lands become one with the whispering people of Lemuria and form its spectral armies. There, they endlessly roam the Underworld, re-enacting the battles that consumed their mortal lives and executing the will of the Grand Lemurs. Now they have been interrupted from their eternal wars and brought back to fight the living. They are surrounded by glacial emanations and their touch is strikes their victims with paralysis. Like other Lemurs, they are cursed with immortality and draw great strength from surrounding darkness and magic."
#immortal
#mapmove 20
#clearweapons
#weapon 283
#mr 16
#magicpower 1
#darkpower 4
#montag 4163
#standard 3
#cold 5
#float
#end

#newmonster 6947
#copyspr 945
#copystats 945
#name "Lemur Guard"
#descr "Shades are spirit natives of the Shade Lands between the Underworld and the land of the living. Shades appear as beings composed of darkness and their touch can steal strength from living beings. The most horrifying of their kind are the Lemur Guards, who have grown as apex predators of the spiritual by cannibalizing innumerable souls over the nameless eons. Having attracted the attention of the Lords of Lemuria, they were granted special bane blades which consume the very life essence of whatever they touch and which raise their victims as new shadow servants under the Shade Lords' dominion."
#clearspec
#clearweapons
#immortal
#weapon 42
#weapon 284
#mr 16
#att 14
#str 14
#coldres 15
#poisonres 25
#stealthy 40
#darkpower 4
#magicpower 1
#fear
#holy
#ethereal
#amphibian
#undead
#ethereal
#neednoteat
#spiritsight
#bodyguard 3
#raiseonkill 100
#raiseshape -4163
#haltheretic 1
#float
#end

#selectmonster 902 -- Celestial Soldier
#name "Celestial Soldier"
#descr "Also called the Horse-face, the Celestial Soldier is a being of the Celestial Sphere. It has the appearance of a horse-headed man in full scale armor, armed with a glaive and skilled in tight formation fighting. Celestial Soldiers are strong and skillful warriors. They are sacred and can only be summoned by the Celestial Masters of T'ien Ch'i."
#mapmove 14
#nametype 134
#formationfighter 2
#hp 47
#end

#selectmonster 2090 -- Horse-face
#clearspec
#clearweapons
#cleararmor
#copyspr 902
#name "Celestial Soldier"
#descr "Also called the Horse-face, the Celestial Soldier is a being of the Celestial Sphere. It has the appearance of a horse-headed man in full scale armor, armed with a glaive and skilled in tight formation fighting. Celestial Soldiers are strong and skillful warriors. They are sacred and can only be summoned by the Celestial Masters of T'ien Ch'i."
#gcost 0
#hp 47
#size 4
#prot 4
#mr 15
#mor 15
#str 18
#att 14
#def 15
#prec 15
#ap 16
#mapmove 14
#enc 1
#maxage 500
#startage 200
#okmagicleader
#noundeadleader
#holy
#magicbeing
#neednoteat
#spiritsight
#nametype 134
#weapon 309
#armor 17
#armor 20
#formationfighter 2
#end

#selectmonster 2091 -- Ox-head
#name "Demon Soldier"
#descr "Also called the Ox-head, the Demon Soldier is a jailer and guardian demon of the Underworld who feeds upon the flesh of deceased sinners. It has the appearance of an ox-man in full scale armor, armed with barbed pole arms enchanted to trap souls. Unlike Celestial Soldiers, Demon Soldiers aren't sacred, but like them they are tight formation fighter, and they often accompany them to inspire fear among their enemies and bravery among their allies."
#fear 5
#formationfighter 2
#standard 4
#hp 58
#end

#selectmonster 791 -- Red Guard
#hp 14
#def 15
#end

#selectmonster 1544 -- Warrior of the Five Elements
#def 15
#end

#selectmonster 1247 -- Sohei
#name "Sohei"
#descr "Sohei are sacred warrior monks and guardians of the ancient Jomonese order of the Temple of Pure War. They are skilled warriors known for their outstanding devotion. They resent the Yamabushi for being undisciplined and selfish. Sohei rarely fight alongside Yamabushi."
#mor 18
#monpresentrec 1258
#end

#selectmonster 1248 -- Yamabushi
#name "Yamabushi"
#descr "Yamabushi are ascetic warrior monks of the Sacred Mountains populated and worshipped by the Jomonese minorities of T'ien Ch'i. Enlightenment is found through the study and contemplation of oneself. This might include heavy drinking and unsavory behavior. The practice of martial arts is a means to perfection of body and mind, and although the Yamabushi's unconventional technique focuses on more exotic and esoteric aspects of the craft of war than the Samurai's, they undoubtedly are among the most skilled warriors in all of Jomon. Yamabushi live in isolation in search for enlightenment. Therefore they rarely fight in armies and are not as disciplined as the Sohei warrior monks. Some even consider them cowardly."
#mr 16
#monpresentrec 1258
#end

#selectmonster 2101 -- Shrimp Soldier
#mr 20
#gcost 5
#end

#newmonster 6830
#copyspr 2262
#name "Colossi Warrior"
#descr "Unlike Berytos, which is otherwise very close to it culturally, Apsum always was ruled by descendants of the mighty Machakan Lion Queens of the great race of Mababwe. Called 'Colossi' by the historians of Arcoscephale, they are truly superior to ordinary men and bear a divine heritage in their blood. Their warriors are the ruthless bodyguards of the Queens of Apsum and had sacred status until recently, when the city-state abandoned the Rephaim's worship. Now, unlike those of Berytos, they are entirely mundane although still formidable combatants. However, thanks to the old tradition of their training as the military elite of Apsum, they are more numerous and thus less costly. In addition, they are very used to patrolling the desert and will be more efficient both at surviving wastelands and striking down rebellion."
#hp 24
#size 3
#prot 1
#mr 12
#mor 14
#str 16
#att 13
#def 13
#prec 11
#ap 14
#mapmove 20
#enc 2
#maxage 100
#gcost 20
#rcost 1
#rpcost 21
#weapon 6
#armor 12
#armor 162
#armor 2
#bodyguard 2
#nametype 125
#wastesurvival
#patrolbonus 3
#woundfend 1
#end

#newmonster 7067
#copyspr 2262
#name "Colossi Bodyguard"
#descr "The Qudarri are known to be mighty descendants of the great race of Mababwe. Called 'Colossi' by the historians of Arcoscephale, they are truly superior to ordinary men and bear a divine heritage in their blood. Their warriors fight with both unbreakable discipline and faith."
#hp 24
#size 3
#prot 1
#mr 12
#mor 15
#str 16
#att 13
#def 13
#prec 11
#ap 14
#mapmove 20
#enc 2
#maxage 100
#gcost 20
#rcost 1
#rpcost 21
#weapon 6
#armor 12
#armor 162
#armor 2
#bodyguard 2
#nametype 125
#wastesurvival
#patrolbonus 3
#holy
#woundfend 1
#end

#selectmonster 2262 -- Colossi Warrior
#name "Colossi Warrior"
#descr "More than a generation ago a new power emerged in the Phoenix Empire. Refugees from a distant kingdom arrived with claims of divine heritage. The Colossi Warriors were bodyguards of the refugee Lion Queens and members of the great race of Mababwe. Called 'Colossi' by the historians of Arcoscephale, they are truly superior to ordinary men. The Colossi serve as bodyguards of the Brides and are most often seen guarding the Temple of Storms and Flames or in the numerous sacred processions. Dedicated solely to their protection, they refuse to leave them behind and thus do not normally travel by boat."
#hp 24
#str 16
#att 13
#def 13
#woundfend 1
#gcost 30
#rpcost 21
#mountainsurvival
#wastesurvival
#end

#selectmonster 2260 -- Berytian Lancer
#name "Berytian Lancer"
#descr "Horses are not very comfortable with sailing, and are difficult to transport in greater numbers, so the Phoenix Empire rarely uses them on their conquests. Once a colony is founded, lancers are deployed if there is need for a mobile land based army. The lancers of Berytos are lightly armed, but fast and trained to travel through difficult terrain."
#mountainsurvival
#wastesurvival
#gcost 20
#rpcost 24
#end

#selectmonster 150 -- War Elephant (indie)
#hp 77
#gcost 100
#end

#selectmonster 2261 -- War Elephant (Berytos)
#name "War Elephant"
#descr "Elephants, the largest animals known to man, are trained for use in battle. Their sheer size allows them to trample soldiers and horses. Elephants are intelligent beings with minds of their own. Once hurt, they become enraged and terrified, seeking to leave the battlefield by the shortest possible route and trampling friends and enemies alike. The Berytian war elephants are specifically trained for war in difficult terrain and will withstand even the difficult climate of wastelands and mountains."
#mountainsurvival
#wastesurvival
#gcost 100
#hp 77
#end

#newmonster 6825
#copystats 2261
#copyspr 2261
#quadruped
#end

#selectmonster 1147 -- War Elephant (Bandar Log)
#name "War Elephant"
#descr "Elephants, the largest animals known to man, are trained by the Vanara for use in battle. Their sheer size allows them to trample soldiers and horses. Elephants are intelligent beings with minds of their own. Once hurt, they become enraged and terrified, seeking to leave the battlefield by the shortest possible route and trampling friends and enemies alike. The elephants of Bandar Log come from the deep forests and thick marshes of the kingdom and travel through luxurious lands with ease."
#gcost 100
#swampsurvival
#hp 77
#end

#selectmonster 1555 -- War Elephant (Delphanes)
#name "War Elephant"
#descr "Elephants, the largest animals known to man, are trained for use in battle. Their sheer size allows them to trample soldiers and horses. Elephants are intelligent beings with minds of their own. Once hurt, they become enraged and terrified, seeking to leave the battlefield by the shortest possible route and trampling friends and enemies alike. The war elephants of Delphanes are heavily armored and protected from attackers by their riders' pikes."
#unsurr 2
#gcost 100
#hp 77
#end

#selectmonster 2586 -- War Elephant (Ragha)
#name "War Elephant"
#descr "When the Abysians first conquered Tur, they defeated a small army of War Elephants. Impressed by the size and effectiveness of the elephants, the Turans adopted the use of elephants and now they are as important as the regular cavalry of the nation. The Elephants form the main shock contingent, while the Savaran cavalry are used to outflank the enemy army. The war elephants of Ragha are heavily armored and protected from attackers by their riders' pikes."
#unsurr 2
#gcost 100
#hp 77
#end

#selectmonster 2307 -- War Elephant (Machaka)
#gcost 95
#hp 77
#mor 11
#addupkeep -50
#end

#selectmonster 619 -- Mammoth (Caelum & Hararat)
#woundfend 3
#hp 90
#gcost 120
#end

#selectmonster 720 -- Slave (Mictlan)
#name "Slave"
#descr "The Nok Kings have always used slaves in warfare, taken from the maskless and soulless populations they dominate. Slaves are armed with spears, but are not given armor. They are untrained and likely to break if they face disciplined soldiers. Only the Priest Kings and Tribal Kings of Nok can levy slave warriors."
#end


------------- COMMANDERS

#selectmonster 2984 -- Scout (Rus)
#name "Rusian Scout"
#descr "Scouts are trained to pass unseen through enemy territory and to travel efficiently even in mountainous and forested terrain. Their reports on enemy army movements and the resources in enemy lands are invaluable to the prudent warlord."
#gcost 20
#addupkeep -20
#end

#selectmonster 2985 -- Rusian Chieftain (forts)
#addupkeep -40
#end

#selectmonster 2986 -- Rusian Priest
#addupkeep -45
#end

#selectmonster 2987 -- Rusian Wizard
#name "Rusian Wizard"
#descr "Since the first men started to cook their meat men have found ways to manipulate the world. In secluded caves or by the warmth of the hearth these wizards practice a new kind of magic unknown to the priest-mages of the tribal moiety. The wizards are not bound by taboos or old traditions. They cook their meat and experiment with the arcane. They even know the secret of how to cast the Transformation ritual."
#montag 4153 -- can cast Transformation
#addupkeep -125
#end

#selectmonster 3008 -- Rusian Chieftain (foreign)
#addupkeep -45
#end

#selectmonster 2988 -- Thunder Priest
#addupkeep -235
#end

#selectmonster 3002 -- Chud Chieftain
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 3000 -- Son of Heaven
#name "Son of Heaven"
#descr "The most prominent families of the Chudes claim to be descendants of the gods and the Lord of Heaven himself. Chud men of divine heritage are called Sons of Heaven, Dieva Deli, and command great respect among Chudes and humans alike. From the Hall of Dawn they lead the cult and perform all the important ceremonies to the Awakening God. The Sons of Heaven are blessed with some magic powers, but their role as priests and leaders of the settled communities outweighs their role as mages and sages. Still, they know the secret of how to cast the Transformation ritual."
#montag 4153 -- can cast Transformation
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 3001 -- Daughter of the Sun
#userestricteditem 8069
#twiceborn 6675
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2999 -- Perkunu
#name "Perkunu"
#descr "The Perkunu is a Chud Thunder Priest Skinshifter trained at the sacred Pine of Skulls. For a decade the young apprentice will follow his master and only eat bear meat, wild berries and mead. When fully trained the would be Perkunu climbs a mountaintop and calls thunder to strike him down. If he survives he is blessed with the gift of shapeshifting and vast powers over storms and weather. The Perkunu are revered by all, but their skills as commanders and generals are lesser than the Chudes of the settled moiety. They are so powerful that they know how to cast the Transformation ritual."
#montag 4153 -- can cast Transformation
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2998 -- Werebear (Perkunu)
#name "Werebear"
#descr "When the Vanir first arrived in the lands of Rus they met another exalted race. The Chuds had the beauty and might of the Vanir and some were able to change their shape into great bears. At the Pine of Skulls the Chuds feast upon bear hearts to incorporate the spirit of the bear into their bodies. When they are wounded, their flesh is filled with the rage of the bear and they are transformed. Chud Skinshifters don't have the regenerative powers of the wolven skinshifters of Midgård, but they have remarkable recuperative powers, and can heal even the most gruesome wounds over time."
#montag 4153 -- can cast Transformation
#boartattoo 10
#beartattoo 4
#wolftattoo 4
#horsetattoo 4
#snaketattoo 4
#end

#selectmonster 2013 -- Acha
#hp 35
#gcost 160
#end

#selectmonster 2014 -- Ammi
#hp 35
#gcost 120
#end

#selectmonster 2016 -- Qadesim
#hp 31
#gcost 65
#end

#selectmonster 2016 -- Qadesot
#hp 28
#gcost 70
#end

#selectmonster 2020 -- Horite Shaman
#hp 37
#gcost 90
#end

#selectmonster 2023 -- Avvite Commander
#hp 41
#gcost 85
#end

#selectmonster 2024 -- Avvite Scout
#hp 37
#gcost 40
#end

#selectmonster 2629 -- Zhayedan Spahbed
#name "Zhayedan Spahbed"
#descr "The Zhayedan Spahbed is a commander of the Zhayedan. They are skilled generals and mighty warriors blessed by the magi priests of the kingdom. They are also tasked with the sacred mission of ensuring the equality of the Turan and Airya dual rules in all of Ragha. As a result, any province under Cold scales will generate taxes with double efficiency if it hosts a Zhayedan Spahbed as its guardian and isn't under siege."
#rpcost 2
#end

#selectmonster 2901 -- Kernou Druid
#rpcost 1
#mr 14
#end

#selectmonster 2914 -- Ysian Druid
#name "Ysian Druid"
#descr "Before the first contacts with the Tuatha the Merrow practiced their own ancient form of druidism. With increasing influence from the Tuatha their focus changed, but the Ysian Druids were never able to master the Tuathan secrets. While the most powerful mages in the queendom are indisputably the Morgen Queens, there are still several Merrow of considerable magic skills. The Merrow Druids once served as priests, but now they have lost most of their religious influence. They are still revered as keepers of traditions and their ancient kinship with amphibians is such that they may befriend them in incredible numbers."
#gcost 130
#goodmagicleader
#makemonsters5 2222 -- Frog
#end

#selectmonster 2913 -- Ysian Commander
#rpcost 0
#end

#selectmonster 2928 -- Swanherd
#rpcost 4
#mr 14
#mor 12
#end

#selectmonster 2900 -- Kernou Chieftain
#mr 13
#mr 15
#rpcost 0
#end

#selectmonster 2931 -- Knight Commander of Ys (UW)
#name "Knight Commander of Ys"
#descr "The Knights of Ys are noble-born Merrow trained for battle from a young age. The Knights of Ys resemble the human knights of the feudal kingdoms, but they ride shape shifting Kelpies instead of horses and are not as heavily armored. Kelpies are able to change their shape into that of a horse and the Knights of Ys have been known to raid coastal settlements in Ermor and Marverni."
#rpcost 0
#mapmove 24
#end

#selectmonster 2932 -- Knight Commander of Ys (land)
#name "Knight Commander of Ys"
#descr "The Knights of Ys are noble-born Merrow trained for battle from a young age. The Knights of Ys resemble the human knights of the feudal kingdoms, but they ride shape shifting Kelpies instead of horses and are not as heavily armored. Kelpies are able to change their shape into that of a horse and the Knights of Ys have been known to raid coastal settlements in Ermor and Marverni."
#rpcost 0
#end

#selectmonster 263 -- Vanherse
#name "Vanherse"
#descr "Herses are the chiefs of the Van of both Light and Shadow. The Vanherse is a religious leader who performs sacrifices and lesser ceremonies. Vanherses can use Air magic. In battle, they wear chainmail hauberks and ride magnificent fay horses. Vanherses can sail with all their units across the open sea. Since they hail from both Vanheim and Helheim, they retain their authority for the entire year."
#pillagebonus 2
#twiceborn 263
#combatcaster
#end

#selectmonster 264 -- Vanjarl
#name "Vanjarl"
#descr "The military and political leaders of Van society are the Jarls in Helheim and Vanheim both. They are also its religious leaders and care for the sacrificial groves and administer the ceremonies. Vanjarls are closely attuned to their heritage and are skilled in the practice of Air magic and illusions. Vanjarls still remember the times when human blood was sacrificed to the gods. Vanjarls can sail with all units under their command across the open sea. Since they hail from both Vanheim and Helheim, they retain their authority for the entire year."
#pillagebonus 2
#twiceborn 264
#combatcaster
#end

#selectmonster 1507 -- Dis
#name "Dis"
#descr "The Dis is a Van warrior sorceress and commander of the Valkyries. The Disir were blessed by the dead god of Helheim in ages past and all Van women can fly since, a power which allowed them to serve as holy messengers between Vanhalla and Helhalla for the centuries leading to their alliance. Disir wear magical scale mail armor. Since they hail from both Vanheim and Helheim, they retain their authority for the entire year."
#userestricteditem 8069
#darkpower 3
#rpcost 1
#gcost 145
#twiceborn 1507
#combatcaster
#end

#newmonster 6598
#copystats 948 -- Vanadrott
#copyspr 948
#name "Vanadrott"
#descr "A Vanadrott is an ancient Vanjarl of great renown given the honorary title of Drott, meaning King. Few of these ancient heroes of Vanhalla still survive, but they have great influence over the affairs of the celestial Vanir and rule Midgård during the Light season. Vanadrotts wear magical lightweight armor."
#springshape 948
#summershape 948
#magicboost 53 -2
#rpcost 2
#researchbonus 2
#pillagebonus 2
#magicskill 7 2
#gcost 245
#fixedresearch 17
#twiceborn 6598
#combatcaster
#end

#selectmonster 948 -- Vanadrott
#name "Vanadrott"
#descr "A Vanadrott is an ancient Vanjarl of great renown given the honorary title of Drott, meaning King. Few of these ancient heroes of Vanhalla still survive, but they have great influence over the affairs of the celestial Vanir and rule Midgård during the Light season. Vanadrotts wear magical lightweight armor."
#autumnshape 4598
#wintershape 4598
#rpcost 2
#researchbonus 2
#pillagebonus 2
#magicskill 7 2
#gcost 245
#addupkeep -245
#twiceborn 948
#combatcaster
#end

#newmonster 6599
#copystats 847 -- Hangadrott
#copyspr 847
#name "Hangadrott"
#descr "The Hangadrott is an ancient Helkarl who has hung himself from an ash tree to gain knowledge in the dark arts. For ages, they withdrew to Helhalla where the dead pass by on their way to the Underworld, but they have returned with the coming of the New God. A few of these ancient mages still survive and they have great influence over the affairs of the Vanir of Shadow, thus ruling Midgård during the Dark season. Hangadrotts wear magical lightweight armor."
#autumnshape 847
#wintershape 847
#magicboost 53 -2
#rpcost 2
#darkpower 3
#researchbonus 8
#gcost 245
#fixedresearch 17
#twiceborn 6599
#combatcaster
#end

#selectmonster 847 -- Hangadrott
#name "Hangadrott"
#descr "The Hangadrott is an ancient Helkarl who has hung himself from an ash tree to gain knowledge in the dark arts. For ages, they withdrew to Helhalla where the dead pass by on their way to the Underworld, but they have returned with the coming of the New God. A few of these ancient mages still survive and they have great influence over the affairs of the Vanir of Shadow, thus ruling Midgård during the Dark season. Hangadrotts wear magical lightweight armor."
#springshape 4599
#summershape 4599
#rpcost 2
#darkpower 3
#researchbonus 8
#gcost 245
#addupkeep -245
#twiceborn 847
#combatcaster
#end

#newmonster 6600
#copystats 323 -- Dwarven Smith
#copyspr 323
#name "Dwarven Smith"
#descr "In the hills near the Well of Urd, the entrance to the great Halls of Andvare can be found. Here in that mighty fortress dwarven smiths of great renown guard Bifröst and practice their craft. Dwarves are adept Earth magicians and masters of forging. They are said to have crafted many of the most ancient and powerful artifacts and, should their greatest Elder be chosen as a Prophet, his mastery of the magic of stone and metals would increase and he would be recognized as a master over all Dwarves and Svartalfs, lord of the Halls of Andvare for both seasons. Having sided with Vanheim, all other Dwarves withdraw half of the year until the Light season returns."
#springshape 323
#summershape 323
#magicboost 53 -2
#magicskill 1 1
#rpcost 2
#forgebonus 20
#researchbonus 2
#gcost 155
#fixedresearch 11
#twiceborn 6600
#end

#selectmonster 323 -- Dwarven Smith
#name "Dwarven Smith"
#descr "In the hills near the Well of Urd, the entrance to the great Halls of Andvare can be found. Here in that mighty fortress dwarven smiths of great renown guard Bifröst and practice their craft. Dwarves are adept Earth magicians and masters of forging. They are said to have crafted many of the most ancient and powerful artifacts and, should their greatest Elder be chosen as a Prophet, his mastery of the magic of stone and metals would increase and he would be recognized as a master over all Dwarves and Svartalfs, lord of the Halls of Andvare for both seasons. Having sided with Vanheim, all other Dwarves withdraw half of the year until the Light season returns."
#autumnshape 4600
#wintershape 4600
#magicskill 1 1
#rpcost 2
#forgebonus 20
#researchbonus 2
#gcost 155
#addupkeep -155
#twiceborn 323
#end

#selectmonster 324 -- Dwarf Elder (prophetshape)
#name "Dwarf Elder"
#descr "In the hills near the Well of Urd, the entrance to the great Halls of Andvare can be found. Here in that mighty fortress dwarven smiths of great renown guard Bifröst and practice their craft. Dwarves are adept Earth magicians and masters of forging. They are said to have crafted many of the most ancient and powerful artifacts and, should their greatest Elder be chosen as a Prophet, his mastery of the magic of stone and metals would increase and he would be recognized as a master over all Dwarves and Svartalfs, lord of the Halls of Andvare for both seasons. Having sided with Vanheim, all other Dwarves withdraw half of the year until the Light season returns."
#magicboost 3 1
#forgebonus 20
#gcost 155
#twiceborn 324
#end

#newmonster 6601
#copystats 1010 -- Svartalf
#copyspr 1010
#name "Svartalf"
#descr "The Svartalf is a dwarf of sinister nature. Like all dwarves, they shun the daylight and prefer to live in deep caves to work their wonders of architecture and the crafts. The Svartalfs have fled the advance of man and found refuge in the hills near the Well of Urd where the dead pass by to Gnipahålan and Helhalla. Svartalfs are old practitioners of dark magic, but not as skilled mages of the Earth as their dwarven cousins. Having sided with Helheim, they withdraw half of the year until the Dark season returns."
#autumnshape 1010
#wintershape 1010
#magicboost 53 -2
#rpcost 2
#darkpower 3
#custommagic 5504 10
#forgebonus 20
#researchbonus 2
#gcost 155
#fixedresearch 13
#twiceborn 6601
#end

#selectmonster 1010 -- Svartalf
#name "Svartalf"
#descr "The Svartalf is a dwarf of sinister nature. Like all dwarves, they shun the daylight and prefer to live in deep caves to work their wonders of architecture and the crafts. The Svartalfs have fled the advance of man and found refuge in the hills near the Well of Urd where the dead pass by to Gnipahålan and Helhalla. Svartalfs are old practitioners of dark magic, but not as skilled mages of the Earth as their dwarven cousins. Having sided with Helheim, they withdraw half of the year until the Dark season returns."
#springshape 4601
#summershape 4601
#rpcost 2
#darkpower 3
#custommagic 5504 10
#forgebonus 20
#researchbonus 2
#gcost 155
#addupkeep -155
#twiceborn 1010
#end

#newmonster 6602
#copystats 1502 -- Helkarl
#copyspr 1502
#name "Helkarl"
#descr "Helkarlar are the chiefs of Helheim and commanders of the Helhirds. The Helkarl is a religious leader who performs sacrifices and lesser ceremonies. The Helkarl can use Death magic until the coming of the Light season, when they withdraw to Gnipahålan like all Dark Vanir. In battle, Helkarlar wear scale mail and ride magnificent dark fay horses."
#autumnshape 1502
#wintershape 1502
#magicboost 53 -2
#darkpower 3
#researchbonus 2
#gcost 90
#fixedresearch 5
#rpcost 1
#noreqlab
#twiceborn 6602
#combatcaster
#end

#selectmonster 1502 -- Helkarl
#name "Helkarl"
#descr "Helkarlar are the chiefs of Helheim and commanders of the Helhirds. The Helkarl is a religious leader who performs sacrifices and lesser ceremonies. The Helkarl can use Death magic until the coming of the Light season, when they withdraw to Gnipahålan like all Dark Vanir. In battle, Helkarlar wear scale mail and ride magnificent dark fay horses."
#springshape 4602
#summershape 4602
#darkpower 3
#researchbonus 2
#gcost 90
#addupkeep -90
#rpcost 1
#noreqlab
#twiceborn 1502
#combatcaster
#end

#newmonster 6603
#copystats 281 -- Norna
#copyspr 281
#name "Norna"
#descr "The Norns are strange, cowled Van hags of Helhalla who master a magic of unknown origin. They divine and weave the fates of men and are said to decide even the fates of gods in their weaving. They have foreseen the fate and future of the world and have warned the Hangadrott about the rise of the Niefel and the cataclysmic wars to come, thus a strong hatred and rivalry exists between them and the Gygjas whose plans they attempted to foil. With these omens they have paved the path to an alliance with the Light Vanir, but they haven't predicted victory yet and some believe they hide a bleaker truth. Norns are skilled in the ancient sorcery known as Seith and they are seeresses of great power who can prevent bad events before they occur. Like all female Vanir, they received from the dead god of Helheim the gift of flight in the ages past. Their magic belongs to Helhalla and thus they must withdraw during the Light season until the coming of the Dark."
#autumnshape 281
#wintershape 281
#magicboost 53 -2
#rpcost 2
#curseluckshield 1
#userestricteditem 8069
#clearmagic
#magicskill 5 2
#custommagic 21760 100
#custommagic 19712 100
#custommagic 21760 10
#stealthy 25
#illusion
#flying
#hp 12
#mr 18
#str 9
#att 9
#def 11
#prec 12
#darkpower 3
#researchbonus 2
#spiritsight
#spellsinger
#twiceborn 6603
#gcost 195
#fixedresearch 11
#maxage 300
#end

#selectmonster 281 -- Norna
#name "Norna"
#descr "The Norns are strange, cowled Van hags of Helhalla who master a magic of unknown origin. They divine and weave the fates of men and are said to decide even the fates of gods in their weaving. They have foreseen the fate and future of the world and have warned the Hangadrott about the rise of the Niefel and the cataclysmic wars to come, thus a strong hatred and rivalry exists between them and the Gygjas whose plans they attempted to foil. With these omens they have paved the path to an alliance with the Light Vanir, but they haven't predicted victory yet and some believe they hide a bleaker truth. Norns are skilled in the ancient sorcery known as Seith and they are seeresses of great power who can prevent bad events before they occur. Like all female Vanir, they received from the dead god of Helheim the gift of flight in the ages past. Their magic belongs to Helhalla and thus they must withdraw during the Light season until the coming of the Dark."
#springshape 4603
#summershape 4603
#rpcost 2
#curseluckshield 1
#userestricteditem 8069
#clearmagic
#magicskill 5 2
#custommagic 21760 100
#custommagic 19712 100
#custommagic 21760 10
#stealthy 25
#illusion
#flying
#hp 12
#mr 18
#str 9
#att 9
#def 11
#prec 12
#darkpower 3
#researchbonus 2
#spiritsight
#spellsinger
#twiceborn 281
#gcost 195
#addupkeep -195
#maxage 300
#end

#newmonster 6604
#copystats 846 -- Galderman
#copyspr 846
#name "Galderman"
#descr "A Galderman is a Van mage, a master shapeshifter and a guardian of esoteric traditions in Vanheim's society. Galdermen are Skalds, masters of the magic of verses and enchanted poetry, thus they weave songs of heroism and fury to inspire the warriors of the Vanir. Their chants tell the tales of ancient berserkers and valkyries, and their epics of long journeys across the sea to lands unknown. They know the secret of runes which they only reveal to their personal disciples and apprentices. Galdermen are versatile mages skilled in Air magic. Their magic belongs to Vanhalla and thus they must withdraw during the Dark season until the coming of the Light."
#springshape 846
#summershape 846
#magicboost 53 -2
#stealthy 25
#illusion
#str 11
#prec 12
#maxage 100
#mr 17
#att 11
#def 12
#researchbonus 2
#spellsinger
#gcost 185
#fixedresearch 11
#twiceborn 6604
#older 150
#end

#selectmonster 846 -- Galderman
#name "Galderman"
#descr "A Galderman is a Van mage, a master shapeshifter and a guardian of esoteric traditions in Vanheim's society. Galdermen are Skalds, masters of the magic of verses and enchanted poetry, thus they weave songs of heroism and fury to inspire the warriors of the Vanir. Their chants tell the tales of ancient berserkers and valkyries, and their epics of long journeys across the sea to lands unknown. They know the secret of runes which they only reveal to their personal disciples and apprentices. Galdermen are versatile mages skilled in Air magic. Their magic belongs to Vanhalla and thus they must withdraw during the Dark season until the coming of the Light."
#autumnshape 4604
#wintershape 4604
#stealthy 25
#illusion
#str 11
#prec 12
#maxage 100
#mr 17
#att 11
#def 12
#researchbonus 2
#spellsinger
#gcost 185
#addupkeep -185
#twiceborn 846
#older 150
#end

#newmonster 6605
#copystats 854 -- Werewolf (Galderman)
#copyspr 854
#springshape 854
#summershape 854
#magicboost 53 -2
#stealthy 25
#illusion
#maxage 100
#mr 18
#def 15
#researchbonus 2
#spellsinger
#twiceborn 6604
#maxage 300
#older 150
#end

#selectmonster 854 -- Werewolf (Galderman)
#autumnshape 4605
#wintershape 4605
#stealthy 25
#illusion
#maxage 100
#mr 18
#def 15
#researchbonus 2
#spellsinger
#twiceborn 846
#maxage 300
#older 150
#end

#selectmonster 786 -- Jotun Scout
#hp 59
#end

#selectmonster 3399 -- Thrymsgode
#name "Thrymsgode"
#descr "There are a few Jotun spread across Niefelheim who unlike most of their brethren carry the legacy of the great Niefel in their blood. While most merely intend to serve as the legendary Tjatse's hirdmen, the most influential of them have become Godar over the lesser Jotuns. Thrymsgodar are innately skilled in the magic of the Niefel giants, but their skills are limited compared to their lords. Thrymsgodar are even more attuned to the cold than the rest of their divine-blooded kin."
#hp 66
#gcost 245
#mountainsurvival
#end

#selectmonster 1299 -- Jotun Jarl
#copystats 274
#copyspr 274
#hp 60
#gcost 130
#mountainsurvival
#end

#selectmonster 636 -- Jotun Jarl prophet
#hp 60
#gcost 130
#mountainsurvival
#end

#selectmonster 1300 -- Jotun Gode
#copystats 275
#copyspr 275
#hp 54
#gcost 110
#mountainsurvival
#end

#selectmonster 1301 -- Jotun Herse
#copystats 437
#copyspr 437
#hp 54
#gcost 75
#mountainsurvival
#end

#selectmonster 753 -- Jotun Skratti (EA)
#hp 55
#gcost 345
#mountainsurvival
#end

#selectmonster 1652 -- Jotun Werewolf (EA)
#hp 67
#gcost 345
#douse 3
#mountainsurvival
#end

#selectmonster 1653 -- Jotun Wolf (EA)
#hp 30
#gcost 345
#mountainsurvival
#end

#selectmonster 844 -- Niefel Jarl
#rpcost 6
#hp 112
#gcost 510
#mor 18
#mountainsurvival
#combatcaster
#end

#newmonster 7707
#copyspr 844
#copystats 844 -- Niefel Jarl
#spreaddom 1
#end

#selectmonster 2201 -- Niefel Shaman
#hp 104
#gcost 0
#mountainsurvival
#combatcaster
#end

#selectmonster 785 -- Gygja
#name "Gygja"
#descr "Gygjas are ancient Jotun hags. Over the centuries, they have grown in might and malice. Gygjas are skilled in the dark witchcraft known as Seith. They can foretell the future and know how to cast the Transformation ritual. Seith is a magic forbidden to men and only used by female Jotuns. This has led to a growing rivalry between the Skrattir and the Gygjas. Since the Gygjas began to lend the Niefel Jarls their guidance and sorcery, they have become influential in Jotun society. To further their goals they taught the Skrattis skin-shifting and tricked them to serve as vessels in their bloody communions. Now the Gygjas rule Niefelheim in all but name. Their comfortable position has made them less inclined to reawaken the Rimtursar and they generally leave this matter to the Skrattir."
#userestricteditem 8069
#montag 4153 -- can cast Transformation
#hp 57
#gcost 225
#curseluckshield 1
#end

#selectmonster 3397 -- Gygja
#userestricteditem 8069
#end

#selectmonster 3398 -- Jarnvidja
#name "Jarnvidja"
#descr "The Jarnvidjur are ancient Gygjas of the Iron Wood instructed in the art of Seith by Angerboda herself. They are from an earlier era and remember the time when frost covered the world and the Rimtursar walked the earth. When the gods of frost disappeared the oldest and mightiest of the Gygjas sequestered themselves in the Iron Wood for centuries, but with the Awakening, they have emerged anew to serve the great Jarls of Niefelheim. The Jarnvidjur are mighty sorceresses adept in blood magic, crossbreeding, the practice of Seith and the secretive Transformation ritual. They craft the enchanted wolf pelts used by the Ulfhednar and plan the fate of the world. Their influence on the tapestry of magic is such that their mere presence alters the world around them."
#montag 4153 -- can cast Transformation
#userestricteditem 8069
#hp 63
#gcost 350
#rpcost 3
#curseluckshield 1
#decscale 5
#researchbonus 8
#reinvigoration 5
#fixforgebonus 1
#commaster
#end

#selectmonster 3409 -- Jotun Gygja
#userestricteditem 8069
#nowish
#end

#selectmonster 3444 -- Wight Hag
#userestricteditem 8069
#hp 79
#curseluckshield 1
#end

#selectmonster 1258 -- Kannushi
#name "Kannushi"
#descr "The Kannushi is the high priest of a Jomonese shrine, a servant of the wild kami. Since the coming of the New God, they have been known to join armies, however their main function in T'ien Ch'i's order is to maintain a link between the subjugated population and the Imperial Bureaucracy. As such, a Kannushi's presence is required to recruit other members of the Jomonese special forces. Close to nature, the Kannushi require neither infrastructure for their recruitment nor upkeep for their services. A few rare Kannushi have some skill in magic."
#spellsinger
#noreqtemple
#addupkeep -70
#gcost 70
#end

#selectmonster 1318 -- Naga
#name "Naga"
#descr "Nagas are semi-divine serpent beings from the Netherworld of Patala. They are sacred, can see in the dark and breathe underwater. They are sprung from the Underworld and are skilled in metalworking and gemcrafting."
#end

#selectmonster 2476 -- Naga Chief
#name "Naga Chief"
#descr "Nagas are semi-divine serpent beings usually from the Netherworld of Patala, but some Nagas dwell in deep caves and oceans in the normal world. They are sacred, can see in the dark and breathe underwater."
#end

#selectmonster 2100 -- Shikome
#name "Rabisu"
#descr "The Rabisu are hags of the Underworld which result of the failure and punishment of a Black Sorceress or Labasu. Spirits of unending hatred, they are sent in screaming flocks to hunt down those who try to escape the Land of the Dead or its Lord's Decrees. They appear as mad, starving hags with claws and pointy teeth. Their claws are able to harm and incapacitate ghosts and spirits. Rabisu are never given food by their cruel lords and they all have an insatiable appetite for the food of the living. They take every opportunity to feast on flesh or fruits unavailable to them in the halls of the Underworld, and when unleashed upon their foes will eagerly seek to devour them as well. Rabisu are the personal servants of the lords of the Underworld and are revered by the denizens of Irkallah."
#userestricteditem 8069
#nametype 150
#end

#selectmonster 3069 -- Namanari
#spr1 "./Hellenika/SubartuSorceress1G.tga"
#spr2 "./Hellenika/SubartuSorceress2G.tga"
#name "Black Sorceress"
#descr "The Black Sorceress is an ambitious witch who has sided with the necromancer-kings. In return for her servitude, she is granted magical power. All Black Sorceresses are filled with pride and cunning and thus have plans to grow beyond this status. Consumed by jealousy for their masters' power and by the desire to become the mistresses, the Black Sorceresses are easily tempted to seal pacts with the Lords of Irkallah, giving up their humanity for even greater powers. Black Sorceresses traditionally choose to display their beauty and their confidence by wearing no other clothing than a theatrical cloak and gleaming jewelry, a sure way to show their sense of power and control as well as their disdain for the self-righteous virtues of less liberated cultures."
#maxage 50
#userestricteditem 8069
#twiceborn 3069
#gcost 65
#stealthy
#itemslots 14470
#clearmagic
#magicskill 5 1
#magicskill 0 1
#nametype 150
#clearweapons
#weapon 712
#armor 148
#prophetshape 3070
#end

#selectmonster 3070 -- Chunari
#clearspec
#clearmagic
#clearweapons
#spr1 "./Hellenika/Labasu1.tga"
#spr2 "./Hellenika/Labasu2.tga"
#name "Labasu"
#descr "The Labasu is a cruel succubus sorceress, a demon who used to be a mortal until she made a pact with the Lords of Irkallah, giving up her humanity for magical power. Labasu are powerful practioners of black magics and have the appearance of beautiful, nude women with leathery bat-like wings. They are able to enter the dreams of men to seduce and corrupt their souls. A Labasu who succeeds in seducing an enemy commander will take him from his bed and fly him to her master, where he will serve until he dies. Men of high moral standing are difficult to seduce and a high magic resistance might prevent the demon from corrupting his dreams. A Labasu who fails its attempt at dream seduction will attack the victim physically. Jealous and greedy for power a Labasu will sooner or later strengthen her pact with her masters and lose her humanity altogether."
#userestricteditem 8069
#nametype 150
#size 4
#ressize 3
#flying
#female
#demon
#mountainsurvival
#swampsurvival
#wastesurvival
#itemslots 14470
#succubus 15
#scalewalls
#maxage 100
#poisonres 5
#fireres 5
#magicskill 5 2
#magicskill 0 1
#magicskill 7 1
#gcost 0
#stealthy
#spiritsight
#neednoteat
#weapon 63
#armor 148
#prophetshape 1432
#end

#selectmonster 1432 -- Hannya
#clearspec
#clearmagic
#copyspr 393 -- Lammashta
#name "Lammashta "
#descr "Lammashtas are angelic beings of hideous appearance who serve the Lords of the Underworld as executioners. Since the Asag Lords have seized control of Irkallah, its Lammashtas obey them and the necromancer-kings of Subartu, lending them their full power. Some Lammashtas used to be mighty and ambitious mortal sorceresses in their past, but after having twice made a pact with the Lords of Irkallah they lost all their humanity for power and their bodies were turned undead to remind them of who their true masters are. Lammashtas appear as semi-transparent, winged females drenched in blood. They wield Wraith Swords that drain the life from the beings they strike. Lammashtas are ethereal and can fly."
#hp 18
#size 4
#ressize 3
#prot 5
#mr 17
#mor 30
#str 15
#att 13
#def 13
#ap 12
#mapmove 18
#fireres 5
#coldres 15
#poisonres 25
#fear
#invulnerable 20
#undead
#ethereal
#flying
#amphibian
#spiritsight
#weapon 110
#goodundeadleader
#female
#holy
#mountainsurvival
#swampsurvival
#wastesurvival
#maxage 500
#haltheretic 5
#magicskill 5 3
#magicskill 0 2
#magicskill 7 1
#magicskill 1 1
#userestricteditem 8069
#assassin
#spy
#scalewalls
#patience 3
#nametype 150
#gcost 0
#stealthy 40
#neednoteat
#end

#selectmonster 3270 -- Araburu-kami (human shape, summoned)
#clear
#copyspr 392 -- Ashen Angel
#name "Ashen Angel "
#descr "The Ashen Angel is an angelic avenger commanded by the Lord of the Underworld. Ashen Angels normally cannot be summoned by any means and will only arrive to punish those who have broken the Laws of the Underworld. However, since the greatest of Asag spirits and Subartu's Grand Viziers have taken control of Irkallah and upset the order of the world, it is they who bear the title of Lords over this particular infernal layer. Thus, its Ashen Angels now execute their bidding and have begun emerging in the material plane for missions of great secret and importance that sometimes far exceed their original purposes; yet, they still act with the same inflexible loyalty as ever, bringing Death to those who their masters have marked for that destiny. The Ashen Angel has the general appearance of a decaying corpse with skeletal bat wings and wields a greenish Bane Blade. With Irkallah's gates opened and its guardians' full powers at last unleashed, this herald of oblivion radiates an aura of dread and apathy that repulses the sacred beings of other faiths and drains living beings of their energy. With the patience of untold millenia and the ability to remain veiled to mortal eyes, its skills as an assassin are unsurpassed, and it acts as the highest ranking of the Netherworld's reanimators and priests. As such, it holds supreme authority over the unholy Lammashtas, its most faithful agents, and it possesses the ability to spend the month calling one for free, though stripped of her commander status."
#hp 35
#size 4
#prot 5
#mr 18
#mor 30
#str 16
#att 16
#def 16
#prec 16
#ap 14
#mapmove 18
#enc 0
#maxage 1000
#coldres 15
#poisonres 25
#fear 5
#invulnerable 25
#undead
#ethereal
#flying
#amphibian
#neednoteat
#spiritsight
#holy
#haltheretic 5
#assassin
#scalewalls
#patience 10
#stealthy 50
#invisible
#magicskill 8 4
#reanimpriest
#sleepaura 30
#makemonsters1 1432
#nametype 105
#weapon 41
#end

#selectmonster 3271 -- Araburu-kami (oni shape)
#nowish
#end

#selectmonster 1609 -- Demon Priest
#copyspr 1934 -- Occultist (Bogarus)
#name "Black Priest"
#descr "A Black Priest is a secretive human priest who worships the demons of the Underworld and serves its strongest and cruellest spirits, if not in the memory of the dead then in return for gifts, slaves or promises of eternal life or power. They perform burn offerings and simple ceremonies to their dark lords and erect altars in the ruins and wilderness upon which their summoning rituals are performed. From these esoteric gates the shadowy remnants of the damned pour endlessly, turned vicious by endless torment and now drawn to strife and turmoil. As soon as they arrive, they seek a corporeal vessel to inhabit lest they are forcefully pulled back to their realm of ashes; the Black Priests thus tirelessly shape the innumerable clay figures that will serve that purpose for their return, and in wait for their true masters take religious care of the antediluvian statues that will become their flesh."
#nametype 101
#end

#selectmonster 1314 -- Demon General
#spr1 "./Hellenika/AsagF1.tga"
#spr2 "./Hellenika/AsagF2.tga"
#name "Asag Standard"
#descr "The Utukku are ruled by mighty demon kings from the Netherworld, the Asag Lords. Their spiritual form is mighty and they command vast magical powers. They rule by fear and swift arbitrary justice and their lands are constantly torn by civil wars and uprisings. This matters little, as both Utukku and Asag, being already dead and condemned to an eternity of torment in Irkallah, are essentially indestructible. The Asag Lords delight in warfare and are often found in the front ranks of their armies, butchering their enemies. Yet they are few and they need champions to do their bidding. This is where the ascending Asakku and above them the inferior ranks of the Asag come into play. These spirits of intermediary yet still considerable might are recognised by the Lords of Irkallah as their smaller siblings, gifted with the necessary cruelty and strength to rule over Utukku and with a sacred nature among the unholy. Like the greater Asag Lords whose physical form towers above theirs, they are summoned back to the realm of the living by Subartu's necromancer-kings to inhabit the ancient and noble statues of fallen Umet'enni and conquer the sunlit world. Thus will they accomplish their destiny of vengeance and glory, thus will they rebuild their rightful empire from its ashes. Some wield antediluvian weapons to exterminate their foes while others carry through exhaustion the eerie standards which were enchanted by the Black Sorcerers to drain their energy and radiate with otherworldly light as beacons of control over the legions of homunculi and Utukku. The Asag are almost immortal. If their body is slain, their residual spirit will fight on until banished or destroyed. Should it survive, it will reform a new body after the battle. Although unlike the Utukku's living clay their ancient stone cannot be repaired in any other way, they are much stronger than them and they may be blessed."
#secondshape 5382
#cleanshape
#okmagicleader
#size 4
#hp 40
#prot 19
#mr 15
#mor 18
#str 15
#att 10
#def 10
#prec 9
#ap 6
#mapmove 14
#enc 0
#reinvigoration -10
#poisonres 25
#fireres 20
#chaospower 1
#holy
#spiritsight
#neednoteat
#snow
#gcost 185
#addupkeep -185
#pierceres
#slashres
#pooramphibian
#inanimate
#stonebeing
#wastesurvival
#mountainsurvival
#demon
#noheal
#inspirational 1
#undcommand 30
#maxage 1000
#batstartsum1d6 442
#cleararmor
#clearweapons
#weapon 430
#nametype 101
#itemslots 3206 -- no misc
#researchbonus -4
#end

#newmonster 7382
#spr1 "./Hellenika/AsagSpiritE1.tga"
#spr2 "./Hellenika/AsagSpiritE2.tga"
#name "Asag Spirit"
#descr "Asag are almost immortal. If the ancient statue that hosts their spirit is slain, they fight on in a wraith's form. If the spirit is not slain as well, it will reform a new body of irreparable stone once the battle is over, thus mending all damage it incurred in past conflicts. Although the Asag have been changed by Irkallah's tormenting influence into beings of vice and cruelty, thus granting them a demonic nature while they inhabit a corporeal receptacle, they nonetheless used to be mortals and once released from their material vessel adopt a more ghostly shape. Regardless, they are no longer from this world and in both forms are susceptible to being banished."
#hp 40
#size 4
#prot 0
#mr 15
#mor 18
#str 15
#att 10
#def 10
#prec 9
#ap 6
#mapmove 20
#enc 0
#maxage 500
#poisonres 25
#chaospower 1
#saltvul 1
#holy
#undead
#ethereal
#neednoteat
#spiritsight
#firstshape 1314
#expertleader
#okmagicleader
#okundeadleader
#amphibian
#inspirational 1
#weapon 67
#nametype 101
#itemslots 3206 -- no misc
#end

#selectmonster 3084 -- Amanojaku
#spr1 "./Hellenika/AsagB1.tga"
#spr2 "./Hellenika/AsagB2.tga"
#name "Asakku"
#descr "The Utukku are ruled by mighty demon kings from the Netherworld, the Asag Lords. Their spiritual form is mighty and they command vast magical powers. They rule by fear and swift arbitrary justice and their lands are constantly torn by civil wars and uprisings. This matters little, as both Utukku and Asag, being already dead and condemned to an eternity of torment in Irkallah, are essentially indestructible. The Asag Lords delight in warfare and are often found in the front ranks of their armies, butchering their enemies. Yet they are few and they need champions to do their bidding. This is where the ascending Asakku and above them the inferior ranks of the Asag come into play. These spirits of intermediary yet still considerable might are recognised by the Lords of Irkallah as their smaller siblings, gifted with the necessary cruelty and strength to rule over Utukku and with a sacred nature among the unholy. Like the greater Asag Lords whose physical form towers above theirs, they are summoned back to the realm of the living by Subartu's necromancer-kings to inhabit the ancient and noble statues of fallen Umet'enni and conquer the sunlit world. Thus will they accomplish their destiny of vengeance and glory, thus will they rebuild their rightful empire from its ashes. Some wield antediluvian weapons to exterminate their foes while others carry through exhaustion the eerie standards which were enchanted by the Black Sorcerers to drain their energy and radiate with otherworldly light as beacons of control over the legions of homunculi and Utukku. The Asag are almost immortal. If their body is slain, their residual spirit will fight on until banished or destroyed. Should it survive, it will reform a new body after the battle. Although unlike the Utukku's living clay their ancient stone cannot be repaired in any other way, they are much stronger than them and they may be blessed."
#size 4
#hp 32
#prot 19
#enc 0
#poisonres 25
#fireres 20
#mapmove 14
#maxage 1000
#pierceres
#slashres
#pooramphibian
#inanimate
#stonebeing
#wastesurvival
#noheal
#supplybonus 0
#cleararmor
#clearweapons
#weapon 469
#weapon 383
#nametype 101
#poormagicleader
#end

#selectmonster 3085 -- Oni Spirit (Amanojaku)
#spr1 "./Hellenika/AsagSpiritB1.tga"
#spr2 "./Hellenika/AsagSpiritB2.tga"
#name "Asag Spirit"
#descr "Asag are almost immortal. If the ancient statue that hosts their spirit is slain, they fight on in a wraith's form. If the spirit is not slain as well, it will reform a new body of irreparable stone once the battle is over, thus mending all damage it incurred in past conflicts. Although the Asag have been changed by Irkallah's tormenting influence into beings of vice and cruelty, thus granting them a demonic nature while they inhabit a corporeal receptacle, they nonetheless used to be mortals and once released from their material vessel adopt a more ghostly shape. Regardless, they are no longer from this world and in both forms are susceptible to being banished."
#size 4
#hp 32
#mapmove 20
#amphibian
#clearweapons
#weapon 67
#weapon 383
#nametype 101
#end

#selectmonster 1276 -- Oni Shugo
#spr1 "./Hellenika/AsagE1.tga"
#spr2 "./Hellenika/AsagE2.tga"
#name "Asag Champion"
#descr "The Utukku are ruled by mighty demon kings from the Netherworld, the Asag Lords. Their spiritual form is mighty and they command vast magical powers. They rule by fear and swift arbitrary justice and their lands are constantly torn by civil wars and uprisings. This matters little, as both Utukku and Asag, being already dead and condemned to an eternity of torment in Irkallah, are essentially indestructible. The Asag Lords delight in warfare and are often found in the front ranks of their armies, butchering their enemies. Yet they are few and they need champions to do their bidding. This is where the ascending Asakku and above them the inferior ranks of the Asag come into play. These spirits of intermediary yet still considerable might are recognised by the Lords of Irkallah as their smaller siblings, gifted with the necessary cruelty and strength to rule over Utukku and with a sacred nature among the unholy. Like the greater Asag Lords whose physical form towers above theirs, they are summoned back to the realm of the living by Subartu's necromancer-kings to inhabit the ancient and noble statues of fallen Umet'enni and conquer the sunlit world. Thus will they accomplish their destiny of vengeance and glory, thus will they rebuild their rightful empire from its ashes. Some wield antediluvian weapons to exterminate their foes while others carry through exhaustion the eerie standards which were enchanted by the Black Sorcerers to drain their energy and radiate with otherworldly light as beacons of control over the legions of homunculi and Utukku. The Asag are almost immortal. If their body is slain, their residual spirit will fight on until banished or destroyed. Should it survive, it will reform a new body after the battle. Although unlike the Utukku's living clay their ancient stone cannot be repaired in any other way, they are much stronger than them and they may be blessed."
#size 4
#hp 40
#prot 19
#enc 0
#gcost 275
#addupkeep -275
#poisonres 25
#fireres 20
#mapmove 14
#pierceres
#slashres
#pooramphibian
#inanimate
#stonebeing
#wastesurvival
#noheal
#supplybonus 0
#batstartsum1d6 442
#cleararmor
#clearweapons
#weapon 1213
#weapon 383
#nametype 101
#okmagicleader
#raredomsummon 1266
#end

#selectmonster 1277 -- Oni Spirit (Oni Shugo)
#spr1 "./Hellenika/AsagSpiritE1.tga"
#spr2 "./Hellenika/AsagSpiritE2.tga"
#name "Asag Spirit"
#descr "Asag are almost immortal. If the ancient statue that hosts their spirit is slain, they fight on in a wraith's form. If the spirit is not slain as well, it will reform a new body of irreparable stone once the battle is over, thus mending all damage it incurred in past conflicts. Although the Asag have been changed by Irkallah's tormenting influence into beings of vice and cruelty, thus granting them a demonic nature while they inhabit a corporeal receptacle, they nonetheless used to be mortals and once released from their material vessel adopt a more ghostly shape. Regardless, they are no longer from this world and in both forms are susceptible to being banished."
#size 4
#hp 40
#mapmove 20
#gcost 195
#addupkeep -195
#amphibian
#clearweapons
#weapon 67
#weapon 383
#nametype 101
#end

#selectmonster 1256 -- Shura
#spr1 "./Hellenika/AsagJ1.tga"
#spr2 "./Hellenika/AsagJ2.tga"
#name "Asag General"
#descr "The Utukku are ruled by mighty demon kings from the Netherworld, the Asag Lords. Their spiritual form is mighty and they command vast magical powers. They rule by fear and swift arbitrary justice and their lands are constantly torn by civil wars and uprisings. This matters little, as both Utukku and Asag, being already dead and condemned to an eternity of torment in Irkallah, are essentially indestructible. The Asag Lords delight in warfare and are often found in the front ranks of their armies, butchering their enemies. Yet they are few and they need champions to do their bidding. This is where the ascending Asakku and above them the inferior ranks of the Asag come into play. These spirits of intermediary yet still considerable might are recognised by the Lords of Irkallah as their smaller siblings, gifted with the necessary cruelty and strength to rule over Utukku and with a sacred nature among the unholy. Like the greater Asag Lords whose physical form towers above theirs, they are summoned back to the realm of the living by Subartu's necromancer-kings to inhabit the ancient and noble statues of fallen Umet'enni and conquer the sunlit world. Thus will they accomplish their destiny of vengeance and glory, thus will they rebuild their rightful empire from its ashes. Some wield antediluvian weapons to exterminate their foes while others carry through exhaustion the eerie standards which were enchanted by the Black Sorcerers to drain their energy and radiate with otherworldly light as beacons of control over the legions of homunculi and Utukku. The Asag are almost immortal. If their body is slain, their residual spirit will fight on until banished or destroyed. Should it survive, it will reform a new body after the battle. Although unlike the Utukku's living clay their ancient stone cannot be repaired in any other way, they are much stronger than them and they may be blessed."
#clearspec
#size 4
#hp 40
#prot 19
#mr 17
#str 17
#ap 14
#mapmove 14
#enc 1
#maxage 1000
#gcost 0
#poisonres 25
#fireres 25
#superiorleader
#goodmagicleader
#superiorundeadleader
#demon
#chaospower 1
#inspirational 1
#pierceres
#slashres
#pooramphibian
#inanimate
#stonebeing
#wastesurvival
#noheal
#batstartsum1d6 442
#cleararmor
#clearweapons
#weapon 430
#weapon 383
#nametype 101
#raredomsummon 1266
#onisummon 25
#holy
#cleanshape
#neednoteat
#spiritsight
#mountainsurvival
#snow
#fear
#heat 5
#magicskill 0 1
#magicskill 5 2
#custommagic 1408 100
#secondshape 5393
#end

#newmonster 7393
#spr1 "./Hellenika/AsagSpiritJ1.tga"
#spr2 "./Hellenika/AsagSpiritJ2.tga"
#name "Asag Spirit"
#descr "Asag are almost immortal. If the ancient statue that hosts their spirit is slain, they fight on in a wraith's form. If the spirit is not slain as well, it will reform a new body of irreparable stone once the battle is over, thus mending all damage it incurred in past conflicts. Although the Asag have been changed by Irkallah's tormenting influence into beings of vice and cruelty, thus granting them a demonic nature while they inhabit a corporeal receptacle, they nonetheless used to be mortals and once released from their material vessel adopt a more ghostly shape. Regardless, they are no longer from this world and in both forms are susceptible to being banished."
#size 4
#hp 40
#prot 0
#mr 17
#mor 18
#str 17
#att 14
#def 16
#prec 11
#ap 14
#enc 0
#mapmove 20
#gcost 0
#poisonres 25
#fireres 25
#amphibian
#chaospower 1
#inspirational 1
#undead
#saltvul 1
#ethereal
#weapon 430
#weapon 383
#nametype 101
#firstshape 1256
#holy
#spiritsight
#neednoteat
#heat 5
#fear
#superiorleader
#goodmagicleader
#superiorundeadleader
#end

#selectmonster 1315 -- Sorcerer (Subartu)
#spr1 "./Hellenika/LittleVizier1.tga"
#spr2 "./Hellenika/LittleVizier2.tga"
#name "Black Sorcerer"
#descr "A dark magician who has chosen to serve a Grand Vizier or a demon lord such as the great Asag to gain power. Black Sorcerers skulk the ruins of old Umet'enni in search for lost arcane secrets and scheme in hope of gaining eternal life and escaping the terrible fate promised by Irkallah. Although they claim their work will bring immortality and prosperity to all who serve them, they feel no qualm about sacrificing the blood of others in their rituals."
#clearmagic
#gcost 115
#magicskill 3 1
#magicskill 5 1
#magicskill 7 1
#custommagic 21888 100
#nametype 101
#armor 120
#montag 4124 -- foreign savant
#end

#newmonster 7377
#spr1 "./Hellenika/Vizier1.tga"
#spr2 "./Hellenika/Vizier2.tga"
#name "Grand Vizier"
#descr "Although they are commonly called the Necromancer-Kings, the Grand Viziers do not actually bear a royal title, and officially only serve as regents and ministers of the empire in the absence of its dead sovereigns. Indeed, it is on sheer power and ambition more than on law that their unchallenged authority rests. Yet, an entire era has passed since any rightful claim could be laid over the mountainous wastelands of ruined Umet'enni, and so, with the coming of the Grand Viziers, for the first time in centuries men in the flesh are seen as skilled, charismatic and unwavering enough to at last bring hope and direction to its people. Of course, the Grand Viziers are tyrants and care little for the well-being of their subjects; however, they are clever administrators and their propaganda is effective. As such, their rule doesn't merely rest on fear: their followers believe in their great promises as in a religious creed. The first is the promise of immortality: the Grand Viziers' great plan is to vanquish death once and for all for the benefit of all mankind, thus granting it an escape from its inevitable destiny in infernal torment. The second is the promise of glory: through the necromancer-kings' power alone may Subartu aspire to rise and once more conquer - under their rule alone may Umet'enni's order and prosperity be rebuilt from the ashes. And the last of their promises is that of eschatological justice and salvation: by their hand will the dead return to life, by their will shall the legions of the damned be granted a second chance; a chance at vengeance for the unfairly condemned, and a chance at freedom for those who long for the release of pleasure, now that vice and virtue are in the grasp of men to define. By this doctrine have the Grand Viziers persuaded Subartu to become theirs, and if they are to return it to the Asag Lords one day, it will only be for an even greater prize in their eyes: the eternal rulership of Irkallah itself and its mystical secrets."
#hp 9
#size 2
#prot 0
#mr 18
#mor 10
#str 9
#att 9
#def 9
#prec 13
#ap 9
#mapmove 14
#enc 3
#maxage 50
#poorleader
#mountainsurvival
#magicskill 3 2
#magicskill 5 2
#magicskill 7 2
#custommagic 21888 200
#custommagic 20480 100
#custommagic 21888 10
#rpcost 4
#rcost 1
#gcost 10000
#nametype 101
#weapon 238
#armor 805
#end

#selectmonster 1316 -- Dai Oni
#spr1 "./Hellenika/SubartuStatueF1.tga"
#spr2 "./Hellenika/SubartuStatueF2.tga"
#name "Asag Lord"
#descr "Although Irkallah hosts and torments the spirits of all the ancient denizens of Umet'enni, not all of them are equal in power. Whether they are of royal ascendance, of heroic nature, filled with arcane knowledge and experience or simply strong enough of mind and perversity to have devoured countless of their own kin over the centuries and grown above them, such remains disputed by savants to this day, but they regardless are commonly named the Asag, and from mortal souls they have been turned to cruel demons. For times immemorial, as mighty as they were among Irkallah's spirits, the Asag were like their inferiors its captives, powerless before the laws of the Underworld, and bound to wage meaningless war against each other for all eternity. But back in the realm of the living, the Grand Viziers and their sects of priests and sorcerers have been conspiring for centuries to topple this order of the world. Eventually they were successful, and thanks either to their tireless efforts or to the Pantokrator's timely disappearance they were able to crown the Asag as true Lords of Irkallah, kings over ashes. Now with Irkallah under control, the Asag crave for their return under the sun and call to the necromancer-kings, according to some their servitors and to others their puppeteers. And at long last indeed, Subartu's dark mages have found a path to free them from their prison. Unlike the Utukku, the Asag are too powerful to be anchored in the material through use of simple clay figures; they need more: along with the long lost rituals of Umet'enni, a vessel of true power and sacrality. Thus have their summoners elected to put to use the ancient and noble statues of the fallen empire, and after the strict observance of many occult rites turned them into temporary gates to the Netherworld for the mighty Asag to finally return to this plane. Now nearly immortal like the Utukku, they inhabit these formidable physical forms which may be repaired only by being reconstructed."
#size 6
#hp 70
#prot 19
#enc 0
#gcost 700
#addupkeep -700
#poisonres 25
#fireres 20
#mapmove 14
#maxage 2000
#pierceres
#slashres
#pooramphibian
#inanimate
#stonebeing
#wastesurvival
#noheal
#supplybonus 0
#mason
#batstartsum1d6 442
#cleararmor
#clearweapons
#weapon 1213
#weapon 383
#nametype 101
#okmagicleader
#raredomsummon -4167
#rpcost 4
#end

#selectmonster 1317 -- Oni Spirit (Dai Oni)
#spr1 "./Hellenika/SubartuSpirit1.tga"
#spr2 "./Hellenika/SubartuSpirit2.tga"
#name "Asag Spirit"
#descr "Asag are almost immortal. If the ancient statue that hosts their spirit is slain, they fight on in a wraith's form. If the spirit is not slain as well, it will reform a new body of irreparable stone once the battle is over, thus mending all damage it incurred in past conflicts. Although the Asag have been changed by Irkallah's tormenting influence into beings of vice and cruelty, thus granting them a demonic nature while they inhabit a corporeal receptacle, they nonetheless used to be mortals and once released from their material vessel adopt a more ghostly shape. Regardless, they are no longer from this world and in both forms are susceptible to being banished."
#size 6
#hp 70
#gcost 700
#addupkeep -700
#mapmove 20
#amphibian
#clearweapons
#weapon 67
#weapon 383
#nametype 101
#end

#newmonster 7364
#spr1 "./Hellenika/HyenaCom1.tga"
#spr2 "./Hellenika/HyenaCom2.tga"
#copystats 2303 -- Hyena Clan Warrior
#name "Hyena Clan Commander"
#descr "The Hyena Clan is the least trusted of all clans, perhaps rightly so. The warriors of the clan are somewhat cowardly and prefer to avoid melee battles. They use javelins instead. Their commanders aren't very worthy in direct confrontations, but they are skilled in cunning tactical operations such as guiding troops behind the enemy lines."
#stealthy
#gcost 55
#hp 13
#mor 10
#str 11
#att 11
#def 11
#cleararmor
#armor 44
#armor 112
#armor 20
#nametype 126
#end

#newmonster 7358
#spr1 "./Hellenika/Pastor1.tga"
#spr2 "./Hellenika/Pastor2.tga"
#name "Pastor"
#descr "A simple shepherd living a simple pastoral life in the wastes and mountains that surround Bethel She'em, the old pastor was around before the final coming of the angels. He is a pious man, so now he follows the Litany of Cinders, too humble and frightened to dare question the actions and true purpose of the celestial invaders. Although less effective for military tasks than professional scouts, the Pastor is quite sneaky, easy to find near temples and always accompanied by a few mildly dangerous goats."
#hp 9
#size 2
#prot 0
#mr 10
#mor 8
#str 9
#att 9
#def 8
#prec 10
#ap 10
#mapmove 14
#weapon 7
#stealthy
#wastesurvival
#mountainsurvival
#gcost 40
#addupkeep -20
#rpcost 1
#rcost 1
#startage 50
#addrandomage 20
#nametype 148
#batstartsum1d6 2227
#noleader
#command 1
#reqtemple
#end

#newmonster 7354
#spr1 "./Hellenika/BerytianDiplomat1.tga"
#spr2 "./Hellenika/BerytianDiplomat2.tga"
#name "Berytian Diplomat"
#descr "The Phoenix Empire is known for being active everywhere on the globe, sailing to the furthest reaches of the sea - even making contact with the mythical T'ien Ch'i - and establishing counters on all shores, as remote as they are. With this comes a pressing need for forming diplomatic relations with the numerous and varied indigenous kingdoms, and so Berytos has begun training talented and loyal diplomats, aiming to create embassies and conclude trade agreements in all capitals of the world."
#hp 10
#size 2
#prot 0
#mr 10
#mor 10
#str 9
#att 8
#def 8
#prec 10
#ap 10
#mapmove 14
#enc 3
#weapon 92
#stealthy 25
#spy
#rcost 1
#rpcost 1
#gcost 55
#noleader
#sailing 999 2
#end

#selectmonster 729 -- Scout (Mictlan)
#spr1 "./Hellenika/NokScout.tga"
#spr2 "./Hellenika/NokScout2.tga"
#mr 18
#nametype 126
#cleararmor
#armor 105
#armor 804
#end

#selectmonster 730 -- Tribal King (Mictlan)
#spr1 "./Hellenika/NokTribalKing.tga"
#spr2 "./Hellenika/NokTribalKing2.tga"
#name "Tribal King"
#descr "The Nok Empire is comprised of several tribal kingdoms that have been conquered by the armies of the Priest Kings. The kings of these vassal tribes retain their titles and lead their subjects when the Empire goes to war. Tribal Kings can levy slave warriors, most often taken from the maskless and soulless peoples such as that of Berytos."
#mr 18
#nametype 126
#cleararmor
#armor 106
#armor 804
#end

#selectmonster 731 -- Mictlan Priest
#spr1 "./Hellenika/BasicPriest1.tga"
#spr2 "./Hellenika/BasicPriest2.tga"
#name "Nok Priest"
#descr "The lesser priests of the Nok Empire perform blood sacrifices in remote provinces, gather blood slaves and keep the temples ready for the eventual arrival of more prominent priests from the capital"
#mr 20
#nametype 126
#armor 804
#end

#selectmonster 1361 -- Nahualli
#spr1 "./Hellenika/NokSorcererB1.tga"
#spr2 "./Hellenika/NokSorcererB2.tga"
#name "Nok Sorcerer"
#descr "The common sorcerers of the Nok people have little influence in society and live secluded lives in rural areas. They are beast-mages and shamans, able to bind animals to their service by entering the spirit world. Nok sorcerers are also able to shapechange into their animal spirit double and are even capable of casting the Transformation ritual."
#mr 20
#montag 4153 -- can cast Transformation
#nametype 126
#armor 804
#end

#selectmonster 1362 -- Turkey
#spr1 "./Hellenika/Bat1.tga"
#spr2 "./Hellenika/Bat2.tga"
#name "Bat"
#descr "The bat is a large, flying, troglodytic rodent. Some Nok sorcerers shapeshift into bats."
#mr 20
#montag 4153 -- can cast Transformation
#stealthy
#blind
#clearweapons
#weapon 251
#weapon 403
#nametype 126
#end

#selectmonster 732 -- Priest King
#spr1 "./Hellenika/PriestKing1.tga"
#spr2 "./Hellenika/PriestKing2.tga"
#name "Priest King"
#descr "The Priest Kings are the temporal leaders of the Nok kingdom. They bless the Land with fertility and lead the people. The Priest King wields priestly power and is skilled in Nature and Blood magic, even knowing the secret of how to cast the Transformation ritual. He can levy slave warriors, most often taken from the maskless and soulless peoples such as that of Berytos."
#mr 22
#nametype 126
#rpcost 3
#armor 809
#montag 4153 -- can cast Transformation
#end

#selectmonster 733 -- Rain Priest
#spr1 "./Hellenika/NokRaintPriest1.tga"
#spr2 "./Hellenika/NokRaintPriest2.tga"
#name "Rain Priest"
#descr "Rain is important in the Nok Cult. Unless sated with human sacrifices, the God will withhold the life-giving Rain from the Land. In the absence of the rare mortal Sky Priests, Rain Priests also take upon themselves to represent this aspect of the Hungry God and train the Eagle Warriors, thus freeing the Couatl of this lowly responsibility - or, a few might say, stripping them of this authority. The Rain Priest wields priestly power and is skilled in Water and Blood magic."
#mr 22
#nametype 126
#rpcost 3
#armor 804
#makemonsters1 726
#end

#selectmonster 734 -- Moon Priest
#spr1 "./Hellenika/NokMoonPriest1.tga"
#spr2 "./Hellenika/NokMoonPriest2.tga"
#name "Moon Priest"
#descr "The Moon is the Dream Face of God in the Nok Cult. Unless sated with human sacrifices, the Moon will not bless the dreams of his followers nor protect their souls while they sleep. The Moon Priest wields priestly power and is skilled in Astral and Blood magic."
#mr 22
#nametype 126
#rpcost 3
#armor 804
#end

#selectmonster 735 -- High Priest of the Sun
#spr1 "./Hellenika/NokSunPriest.tga"
#spr2 "./Hellenika/NokSunPriest2.tga"
#name "High Priest of the Sun"
#descr "The Sun is the Watchful Face of God in the Nok Cult. Unless sated with human sacrifices, it will look to other, more worthy followers. The High Priest of the Sun is the most important of all priests of the Empire. His authority outweighs even the authority of the Priest Kings. The High Priest is skilled in Fire magic and is a powerful priest and Blood mage."
#drawsize 10
#mr 22
#nametype 126
#rpcost 3
#armor 804
#clearweapons 
#weapon 1224
#end

#selectmonster 1194 -- Couatl (recruit)
#name "Couatl"
#descr "The Couatl are mythical serpents with feathery wings. They avoid contact with civilized man and are rarely sighted. Living symbols of divinity and immortality, they are powerful and cunning mages and priests and they are sacred in most cultures that know of their existence, especially in C'tis - but their importance is even greater in Nok, where they have exceptionally become an intergral part of man's institutions and society. As Nok's true High Priests of the Sky, they are revered as holy envoys of the God for their power and their supernatural aura, yet their frequent refusal to drink the blood of sacrifice arouses suspicion and their true agenda is unknown. As such, they have discreetly been pushed to the boundaries of the system and some suspect that there is a struggle of influence between them and the High Priests of the Sun, whether the Couatl have somehow been coerced or secretly seek to steal their authority. While this explains the taboo and marginalisation of the mortal Sky Priests, their inhuman paragons remain worshipped as mysterious deities and mighty protectors of the nation, and since they bide their time and patiently maintain a facade of agreement with the High Priests of the other temples, none would dare blaspheme against their name."
#nametype 113
#awe 5
#domimmortal
#gcost 300
#addupkeep -300
#end

#selectmonster 725 -- Couatl (summon)
#name "Couatl"
#descr "The Couatl are mythical serpents with feathery wings. They avoid contact with civilized man and are rarely sighted. Living symbols of divinity and immortality, they are powerful and cunning mages and priests and they are sacred in most cultures that know of their existence."
#awe 5
#domimmortal
#nametype 113
#end

#newmonster 7395
#copyspr 1194
#copystats 1194
#bonusspells 1
#regeneration 100
#heal
#end

#newmonster 7396
#copyspr 1194
#copystats 1194
#bonusspells 1
#regeneration 100
#heal
#spreaddom 1
#end

#selectmonster 1612 -- Leopard Tribe Priest
#spr1 "./Hellenika/NokJaguarTribePriest1.tga"
#spr2 "./Hellenika/NokJaguarTribePriest2.tga"
#name "Leopard Tribe Priest"
#descr "Tribal peoples of the wild follow their priests and totemic spirits. The priests of the Leopard Tribes have skill in Nature magic and occasionally in other magic as well."
#nametype 126
#end

#selectmonster 2265 -- Berytian Priest
#undcommand 5
#end

#selectmonster 2424 -- Berytian Sage
#clearmagic
#magicskill 3 1
#custommagic 1792 100
#end

#selectmonster 2263 -- Mage Pilot (Berytos)
--#name "Mage Pilot"
--#descr "The Berytian mage pilots are renowned for their navigational skills. They use Air and Water magic to guide their ships across the oceans. Thanks to this expertise in navigation, they all are able to deal with the logistics of transporting large units like cavalry and colossi across the sea."
--#sailing 999 3 -- decided against it because of how clearly intentional it is in Berytian lore that cavalry and colossi can't sail (check their descriptions).
#end

#selectmonster 2264 -- Storm Caller (Berytos)
--#name "Storm Caller"
--#descr "The Storm Caller is a powerful Berytian mage pilot and heir to the Telkhine legacy. The storm callers can summon hail storms and lightning upon enemy fleets and coastal cities. Their magic might has been instrumental in many Berytian conquests. They often lead naval campaigns, but can also be found in coastal cities researching ancient Telkhine lore. Thanks to this expertise in navigation, they all are able to deal with the logistics of transporting large units like cavalry and colossi across the sea."
--#sailing 999 3 -- decided against it because of how clearly intentional it is in Berytian lore that cavalry and colossi can't sail (check their descriptions).
#end

#selectmonster 2253 -- Berytian Captain
--#name "Berytian Captain"
--#descr "The captains of the Phoenix Empire proudly present their Telkhine legacy by coloring their armor and clothing with the purple dye of their ancestors. The Telkhine heritage is also obvious in the sailing and boatbuilding skills of the empire. To become a commander in the Berytian armies, one has to be an accomplished boat captain and navigator. If you cannot command a ship you are of no military use. As a result, the Berytian Captains all are able to deal with the logistics of transporting large units like cavalry and colossi across the sea."
--#sailing 999 3 -- decided against it because of how clearly intentional it is in Berytian lore that cavalry and colossi can't sail (check their descriptions).
#end

#newmonster 7351
#copystats 427 -- Spy
#spr1 "Hellenika/EyeOfTheDeep1c.tga"
#spr2 "Hellenika/EyeOfTheDeep2c.tga"
#name "Eye of the Deep"
#descr "The Eyes of the Deep are secret agents of the Witnesses of the Deep, human initiates trained to keep a close and stealthy eye on human society and report to their masters underneath the waves. Initially a member of a coastal mystery cult, the candidate will eventually be gifted with enchantments of waterbreathing and sent off to further the goals of Atlantis with limited autonomy. When he has completed his mission, the spy will return to the shore, discard his iron sword and enter the realm of the Atlantians to deliver the information he gathered; if his work is satisfying, he will then be sent back to his cult and given a new blade to replace his old one - otherwise he will be punished for this wasteful behavior. Those whose loyalty is flawless and whose tasks are successful will eventually be granted the right to witness the might and splendor of the Coral Towers and to progress through the ranks of the cultic mysteries of the Deep."
#pooramphibian
#gcost 45
#mor 12
#mr 12
#end

#selectmonster 2102 -- Crab General
#goodleader
#mr 20
#end

#selectmonster 793 -- Prince General
#hp 16
#def 16
#command 120
#end

#selectmonster 940 -- Master of the Five Elements
#templetrainer 1544
#raredomsummon 1544
#end

#selectmonster 804 -- Minister of Rituals
#bringeroffortune 5
#clearweapons
#weapon 502
#weapon 761
#end

#selectmonster 807 -- Ceremonial Master
#name "Ceremonial Master"
#descr "Ceremonial Masters are lowly priests of the Bureaucracy who serve under the Ministers. They perform ceremonies according to the ritual calendar and rarely leave their parish, where they may be officiate and be recruited even without important infrastructure. They have a slight chance of preventing bad events in their parish."
#noreqtemple
#clearweapons
#weapon 502
#weapon 761
#end

#selectmonster 813 -- Imperial Consort
#name "Imperial Consort"
#descr "Consorts are Imperial wives. When the Emperor loses interest in one of his wives, the Lady may be granted more freedom. They are not allowed to lead armies, but their influence in the Imperial Court is undisputed. These Imperial Ladies sometimes organise expeditions to explore the uncivilized world and often serve as diplomats and spies in foreign lands."
#gcost 70
#stealthy 50
#sailing 999 2
#end

#selectmonster 806 -- Master of the Dead
#name "Master of the Dead"
#descr "Good standing with one's ancestral spirits is of utmost importance in T'ien Ch'i. The Master of the Dead is a lowly priest or spirit master who divines the will of the ancestral spirits. They have some skill in exorcism and communication with the dead. They often carry papers inscribed with sacred texts. Weaker unholy beings hit by a thrown sutra are paralyzed by the holy words. When threatened, Masters of the Dead will spend esoteric components prepared in advance to create a temporary Death gem."
#tmpdeathgems 1
#end

#selectmonster 1890 -- Apothecary
#name "Apothecary"
#descr "The people of T'ien Ch'i have always been obsessed with physical health and long life. Masters of the Way quest for immortality through internal alchemy and asceticism. Other less esoteric practices are more popular with the common folk. Herbal medicine as a means to health and longevity has become widely used and apothecaries ply their trade in most settlements of the Empire. The apothecaries of T'ien Ch'i are skilled at herbalism and are able to cure diseases. Free from the alchemists' duty of studying the esoteric properties of the elements, they can focus their entire energy on developping better healing techniques, and they are often employed by armies to treat the wounded. Furthermore, while under friendly dominion they will tirelessly work to cultivating medicinal gardens to improve their province's Nature gem income; each province with an Apothecary and no medicinal garden thus has one percent chance per month of seeing this task completed, and each province with an Apothecary and a medicinal garden has twenty percent chance per month of producing greater quantities of precious herbs. Constant exposure to poisons and remedies has made Apothecaries somewhat resistant to poison. If threatened, they flick envenomed darts at their attacker."
#gcost 65
#healer 10
#end

#selectmonster 1891 -- Alchemist of the Five Elements
#alchemy 50
#end

#newmonster 7340
#copyspr 1891
#copystats 1891 -- Alchemist of the Five Elements
#shapechange 1891
#gold -30
#gemprod 0 1
#end

#newmonster 7341
#copyspr 1891
#copystats 1891 -- Alchemist of the Five Elements
#shapechange 1891
#gold -30
#gemprod 1 1
#end

#newmonster 7342
#copyspr 1891
#copystats 1891 -- Alchemist of the Five Elements
#shapechange 1891
#gold -25
#gemprod 2 1
#end

#newmonster 7343
#copyspr 1891
#copystats 1891 -- Alchemist of the Five Elements
#shapechange 1891
#gold -30
#gemprod 3 1
#end

#newmonster 7344
#copyspr 1891
#copystats 1891 -- Alchemist of the Five Elements
#shapechange 1891
#gold -30
#gemprod 6 1
#end

#selectmonster 1892 -- Imperial Alchemist
#name "Imperial Alchemist"
#descr "The longevity of the Emperor is of utmost importance, not only to the Emperor, but also to the Ministers and eunuchs serving under him. Should the Emperor die, many of his most loyal servants would follow him to the grave in the ensuing power struggle. The Emperor has many concubines and has sired hundreds of sons, all with more or less rightful claims to the throne. Thus the Ministers do whatever they can to keep the current Emperor alive. The most skilled alchemists of the Empire are invited to serve the Emperor with their skills in return for alchemical equipment, gold or luxuries. The Imperial Alchemists have uncovered the alchemical properties of all Five Elements and are highly skilled herbalists. They have gained longevity, poison resistance and the ability to cure diseases as well as the skill to alchemize gems into gold more effectively. They even master the supreme alchemical art of turning blessed waters into astral pearls of distilled perfection. The success and lifespan of an Emperor is more or less dependent on how well he treats his alchemists."
#alchemy 100
#montag 4124
#makepearls 5
#autohealer 1
#gcost 225
#end

#selectmonster 1665 -- Noble Commander (Chariot, T'ien Ch'i)
#rpcost 2
#gcost 115
#mor 17
#end

#selectmonster 2089 -- Jigami
#name "Jigami"
#descr "The Jigami are kami of farms and villages, bound to their ancestral land. They protect villages and farms in rural areas and have power over fertility and growth. While they aren't powerful enough to fend off most violent threats on their own, their presence yields enough bountiful food and supplies in their area of power to vastly stimulate population growth."
#homesick 40
#end

#selectmonster 2098 -- Monk of the Fivefold Path
#name "Monk of the Fivefold Path"
#descr "While most among the Jomonese minorities primarily worship the powers of the kami of the land in various local shrines, there are those who seek a higher divine principle. These seekers of truth do not concern themselves with the lowly kami of this world. Instead, heavily influenced by The Way, they sequester themselves in temples and seek enlightenment through the Fivefold Path. The Monks of the Fivefold Path have developed gestures representing the five peaceful natures of the divine principle and the five elements."
#gcost 55
#rpcost 1
#drainimmune
#spellsinger
#divineins
#monpresentrec 1258
#end

#selectmonster 803 -- Celestial Master (MA T'ien Ch'i)
#name "Celestial Master"
#descr "Celestial Masters are high Masters of the Way who have accepted title and training in the Celestial City. Skilled in magic and esoteric arts, they have been revered and respected as religious leaders since the birth of the Empire. Celestial Masters are the highest ranking priests of T'ien Ch'i, but since the founding of the Bureaucracy and the institutionalization of the faith, the Ministry of Rituals has reduced their religious influence. They are still revered and respected among the people of the Empire, but most of the important ceremonies are now performed by the Ministry. Celestial Masters are versatile mages adept in many paths of magic, but first and foremost Water magic. They once all practiced Fire magic, but the founding of the Bureaucracy has led some to studies of Earth magic instead. The Element of the Earth is stable and a more suitable magical foundation for an Empire than the wild nature of Fire magic; in spite of this, the ancient traditions aren't forgotten just yet and even the Ministry of Magic recognizes the value of their unique skills. As high Masters of the Way, Celestial Masters have perfected the art of internal alchemy and have gained longevity and the abilities to fly and sense the immaterial. Furthermore, while meditating in high dominion, sometimes a Celestial Master will reach enlightenment and learn the secret of true immortality. In each province, there is 0.5% chance per candle that one Celestial Master's wisdom will blossom this way, and that chance will be doubled if there is no Misfortune scale or tripled if Luck scales are optimal."
#flying
#spiritsight
#clearmagic
#magicskill 1 1
#magicskill 2 2
#magicskill 4 1
#magicskill 8 2
#custommagic 11008 100
#custommagic 11008 20
#custommagic 1152 100
#custommagic 8064 100
#gcost 320
#undcommand 30
#montag 4124
#twiceborn 803
#end

#newmonster 7346
#spr1 "./Hellenika/CelestialImmortal1.tga"
#spr2 "./Hellenika/CelestialImmortal2.tga"
#name "Celestial Grandmaster"
#descr "Celestial Masters are high Masters of the Way who have accepted title and training in the Celestial City. Skilled in magic and esoteric arts, they have been revered and respected as religious leaders since the birth of the Empire. Celestial Masters are the highest ranking priests of T'ien Ch'i, but since the founding of the Bureaucracy and the institutionalization of the faith, the Ministry of Rituals has reduced their religious influence. They are still revered and respected among the people of the Empire, but most of the important ceremonies are now performed by the Ministry. Celestial Masters are versatile mages adept in many paths of magic, but first and foremost Water magic. They once all practiced Fire magic, but the founding of the Bureaucracy has led some to studies of Earth magic instead. The Element of the Earth is stable and a more suitable magical foundation for an Empire than the wild nature of Fire magic; in spite of this, the ancient traditions aren't forgotten just yet and even the Ministry of Magic recognizes the value of their unique skills. As high Masters of the Way, Celestial Masters have perfected the art of internal alchemy and have gained longevity and the abilities to fly and sense the immaterial. Furthermore, while meditating in high dominion, sometimes a Celestial Master will reach enlightenment and learn the secret of true immortality. This Celestial Master is one of them, and therefore has deserved the title of Celestial Grandmaster."
#copyspr 803
#copystats 803
#domimmortal
#ambidextrous 1
#clearweapons
#weapon 75
#weapon 502
#weapon 175
#twiceborn 7346
#end

#selectmonster 808 -- Master of the Way
#name "Master of the Way"
#descr "Masters of the Way are lowly priests, hermits and sages who practice the ancient Magic of the Way. Some serve as parish priests and others travel the land, gathering followers. Still others sequester themselves in caves and practice extreme asceticism and self-starvation in the attempt to attain immortality. The practice of internal alchemy has given them remarkable longevity and they can survive on a diet of a few grains of rice per day. They all have some skill in Water magic, for the characteristics of Water, softness, flexibility and life-giving, are considered high ideals in the lore of the Way of the Five Elements. While meditating in high dominion, sometimes a Master of the Way will reach enlightenment and learn the secret of true immortality, along with increased mastery of a random path other than Death or Blood and a few others of the Celestial Masters' legendary abilities. In each province, there is 0.25% chance per candle that one Master of the Way's wisdom will blossom this way, and that chance will be doubled if there is no Misfortune scale or tripled if Luck scales are optimal."
#twiceborn 808
#end

#newmonster 7345
#spr1 "./Hellenika/GrandmasterOfTheWay1.tga"
#spr2 "./Hellenika/GrandmasterOfTheWay2.tga"
#name "Grandmaster of the Way"
#descr "Masters of the Way are lowly priests, hermits and sages who practice the ancient Magic of the Way. Some serve as parish priests and others travel the land, gathering followers. Still others sequester themselves in caves and practice extreme asceticism and self-starvation in the attempt to attain immortality. The practice of internal alchemy has given them remarkable longevity and they can survive on a diet of a few grains of rice per day. They all have some skill in Water magic, for the characteristics of Water, softness, flexibility and life-giving, are considered high ideals in the lore of the Way of the Five Elements. While meditating in high dominion, sometimes a Master of the Way will reach enlightenment and learn the secret of true immortality, along with increased mastery of a random path other than Death or Blood and a few others of the Celestial Masters' legendary abilities. This Master of the Way is one of them, and therefore has deserved the title of Grandmaster of the Way."
#copyspr 808
#copystats 808
#gcost 135
#domimmortal
#flying
#spiritsight
#researchbonus 4
#twiceborn 7345
#end

#selectmonster 680
#name "Shadow Tribune"
#descr "Shadow Tribunes, or Lemur Senators, are representatives of the eternally whispering people of silent, lifeless Lemuria. They serve as the political, military and religious leaders of the Shade Lands and their interests are not in the world of the living. They resist most attempts to summon them from their dark home, but with the opening of the Soul Gates they have sworn allegiance to a new lord and prepare to engulf the physical world and replace the living. They are capable of summoning the people of Lemuria to create vast armies of living shadows."
#darkpower 4
#magicpower 1
#stealthy 40
#immortal
#expertleader
#float
#makemonsters5 -4163
#clearweapons
#weapon 284
#weapon 63
#cold 5
#mr 18
#end

#selectmonster 2335
#copyspr 843
#name "Shade Lord"
#descr "Shade Lords, or Grand Lemurs, are the most powerful of their kind, disincarnate sorcerer-kings strongly attuned to the Shade Lands between the Underworld and the land of the living. Native to the Shade Lands, these dark spirits eternally rule upon their expanses and their interests are not in the world of the living. They resist most attempts to summon them from their dark home, but with the opening of the Soul Gates they have sworn allegiance to a new lord and prepare to engulf the physical world and replace the living. They are capable of shaping new Lemur Guards to protect them and do their bidding, and their mere presence on the battlefield is enough to infuse all friendly undead beings with the power of the Shade Lands, which will increase their magic resistance, movement speed and attack skill."
#darkpower 5
#fear
#amphibian
#custommagic 35584 50
#clearweapons
#weapon 59
#weapon 63
#makemonsters3 4947
#cold 5
#haltheretic 1
#incscale 3
#mr 18
#float
#onebattlespell 324
#end

#selectmonster 1816 -- Fomorian Scout
#name "Fomorian Scout"
#descr "Fomorians are a race of malicious and deformed giants descended from the cursed Fomorian giants. Many of them suffer from afflictions such as limps and missing eyes. Almost all are cursed with goatlike heads. Warriors and champions among the Fomorians are often taken from the clans where the Curse is weaker and fewer members suffer from the afflictions typical of their kin. Their scouts are less skilled than the Fir Bolg's, but they are taken from the rare Fomorians who retain the ability to breathe underwater in spite of the Curse."
#hp 50
#gcost 45
#pooramphibian
#weapon 331
#end

#selectmonster 1818 -- Unmarked Champion
#hp 56
#gcost 130
#weapon 331
#end

#selectmonster 1819 -- Fomorian Druid
#hp 48
#gcost 200
#weapon 331
#end

#selectmonster 1800 -- Fomorian Champion
#hp 53
#gcost 60
#weapon 331
#end

#selectmonster 1802 -- Fomorian King
#gcost 485
#hp 105
#giftofwater 999
#forgebonus 20
#end

#newmonster 7476
#spr1 "./Hellenika/TwiceCursed1a.tga"
#spr2 "./Hellenika/TwiceCursed2a.tga"
#copystats 1801 -- Fomorian Giant
#name "Twice Cursed"
#descr "The Twice Cursed are those of the Fomorian Giants who survived the Curse and yet still decided to remain beneath the waves. Their stubborness cost them dearly: they were afflicted with a monstrous appearance, a single eye, skin as black as the night, a ravenous hunger and an ill-fated destiny. But now, with the Fomorian Kings returning to their ancestral realm of the watery dead, the Twice Cursed at last can hope to find a purpose to their existence in their revenge against all who caused their suffering. Although weaker than the Fomorian Kings in many respects, the Twice Cursed are still zealous commanders and mighty mages whose skills are attuned to the tides more than the winds."
#hp 105
#gcost 325
#mor 15
#inspirational 2
#supplybonus -20
#magicskill 2 1
#magicskill 5 1
#custommagic 4864 100
#custommagic 4864 100
#custommagic 4864 10
#magicskill 8 1
#rpcost 4
#spiritsight
#darkvision 0
#startingaff 2
#end

#selectmonster 1700 -- Shambler Chief
#gcost 50
#hp 33
#end

#selectmonster 1701 -- Coral Commander
#name "Coral Commander"
#descr "For the longest time, the Basalt Queens have remained entirely uninterested in the conquest of the shallow water and the surface - only the depths which saw the emergence of the deep ones had any worth in their eyes. But with the Fall of the Star, the Reef Dwellers' betrayal and the founding of Atlantis, this has started to change; jealous of their disloyal progeny, they now dearly wish to devour it, and so they have started taking interest in the sunlit world. With this recent development, the art of coral crafting has been seized from the reef dwellers to be used against them, and a new elite force has been formed. The Coral Guard are war shamblers armed in full coral armor made by the reef dwellers that are sill loyal to the nation. Their coral armor is covered by poisonous spikes, protecting the wearer from short weapons such as daggers or claws."
#hp 38
#gcost 80
#end

#selectmonster 1693 -- Mother of the Deep
#name "Mother of the Deep"
#descr "The Mothers of the Deep are shambler priestesses and the depths' pendant of the betrayer-Queens of Atlantis. Unlike their brethren of shallow waters, they have remained loyal to Iapeto and rejected the opportunity to grow as powerful as the Basalt Queens. They faithfully serve the nation as it emerges from the dark and they lead the Cult in the sunlit world against their degenerate kin."
#end

#selectmonster 1692 -- Mage of the Deep (Iapeto)
#name "Mage of the Deep"
#descr "The mages of the Deep are shambler mages and the depths' pendant of the betrayer-Kings of Atlantis. Unlike their brethren of shallow waters, they have remained loyal to Iapeto and rejected the opportunity to grow as powerful as the Basalt Kings, knowing full well that, should one become too powerful, he would probably be killed. Like the Coral Kings that arose from their ranks, the shambler mages use a slightly wider spectrum of magic than the Basalt Kings. The mages of the Deep have the ability to grant water-breathing abilities to a few followers."
#hp 30
#gcost 215
#end

#newmonster 7338
#spr1 "./Hellenika/CrystalGazer1.tga"
#spr2 "./Hellenika/CrystalGazer2.tga"
#name "Crystal Gazer"
#descr "Secretive and fanatically loyal students of the Basalt Kings, the Crystal Gazers spend most of their upbringing contemplating the depths of the Dark Crystal in Iapeto's heart, and until their initiation is complete are forbidden from leaving this reclusive sanctum. When their inception in the Crystal's mysteries is complete at last, they are granted sacred status as black mages of the Horror of the Depths and often leave for distant abyssal citadels to execute the will of their masters and oversee their subjects' tasks. The Crystal Gazers are skilled practitioners of the dark magic of the Crystal and thus perform as mighty mages of Death, though unable to raise the dead or call the plague. A few among them also have some skills in Earth magic."
#gcost 255
#rcost 1
#rpcost 2
#hp 41
#size 3
#prot 9
#mr 16
#mor 13
#str 17
#att 10
#def 8
#prec 8
#ap 12
#mapmove 14
#enc 3
#maxage 500
#poorleader
#undcommand -60
#fireres 5
#coldres 5
#darkvision 100
#amphibian
#nametype 117
#holy
#magicskill 5 2
#custommagic 5120 25
#spellsinger
#weapon 238 -- magic staff
#weapon 20 -- bite
#deathrange 4
#end

#selectmonster 1702 -- Basalt King
#name "Basalt King"
#descr "The Basalt City is ruled by the Basalt Queens and their consorts. The rulership is divided between the Priestess Queens and the Mage Kings. The Kings however rarely concern themselves with political matters and spend most of their time staring into the Dark Crystal at the bottom of the gorge in the center of the city. In the pale light of the Basalt Kings' antennae, shades and movements can be seen in the Crystal. What this means is unknown to all but the Kings themselves. The Basalt Kings are masters of Earth magic and were the ones who erected the pillars and halls of the city. They enchant the stone of the city to make artifacts, weapons and armor for the Deep Ones. They also are versed in the dark magic of the Crystal and thus perform as mighty mages of Death, though unable to raise the dead or call the plague. As such, they are capable of entering a meditative state which halves the fatigue cost of their spells; unlike other spellsingers, their spellcasting speed is not reduced when doing so."
#hp 76
#gcost 445
#magicskill 5 4
#custommagic 4096 10
#fastcast 100
#undcommand -120
#spellsinger
#clearweapons
#weapon 238 -- magic staff
#deathrange 4
#twiceborn 7702
#end

#selectmonster 112 -- Coral Queen
#name "Coral Queen"
#descr "When they fled Iapeto and seized power from the Basalt Queens in the shallower part of the oceans, the Mothers of the Deep took on their function as religious leaders of the new Atlantian society. Huge and ancient, they wield the holy power of their God, the Coral Towers' protector against the Horror of the Depths. They alone are allowed to study the ancient rites and traditions of Iapeto which they ceaselessly strive to banish and replace with their new cult. Fearing that heresy could leave some ground for the Basalt Queens to obtain a grasp on their young nation, they don't allow any lesser priests but their chosen Consorts. They seldom leave their coral temples unless accompanied by Mother Guards. The Coral Queens are ancient Atlantians of the deeps, recognizable by their dark skin."
#userestricteditem 8069
#twiceborn 3444
#gcost 265
#hp 46
#end

#selectmonster 374 -- Queen Mother
#name "Queen Mother"
#descr "When they fled Iapeto and seized power from the Basalt Queens in the shallower part of the oceans, the Mothers of the Deep took on their function as religious leaders of the new Atlantian society. Huge and ancient, they wield the holy power of their God, the Coral Towers' protector against the Horror of the Depths. They alone are allowed to study the ancient rites and traditions of Iapeto which they ceaselessly strive to banish and replace with their new cult. Fearing that heresy could leave some ground for the Basalt Queens to obtain a grasp on their young nation, they don't allow any lesser priests but their chosen Consorts. They seldom leave their coral temples unless accompanied by Mother Guards. The Coral Queens are ancient Atlantians of the deeps, recognizable by their dark skin."
#userestricteditem 8069
#twiceborn 3444
#hp 51
#end

#selectmonster 322 -- King of the Deep
#name "Coral King"
#descr "With their rejection and betrayal of the Basalt Kings, the Mages of the Deep were able to seize power in the shallower parts of the ocean. With the Basalt City abandoned, they created the Coral Towers. These ancient Atlantians have studied the secrets of the depths for ages before secluding themselves in the Coral Towers to further their knowledge, and some of them even were able to steal some secrets and artifacts of the Basalt City before their exile. Thanks to this and to gifts of their god to the newly formed nation, they excel at Water magic beyond the ability of even the Basalt Kings and they are often proficient in other magic paths as well. The Coral King is able to grant others the ability breathe water and can safely lead a handful of landlubbers into the sea."
#gcost 275
#hp 40
#end

#selectmonster 3096 -- Mage of the Deep (Atlantis)
#name "Coral Mage"
#descr "The Coral Mages are shambler mages, cousins of Iapeto's mages of the Deep, and from their ranks the first of the Coral Kings were chosen after they fled the dark gorges of Iapeto. Many younger Coral Mages remain, now students of their forefathers and teachers of the human initiates. The Coral Mages have the ability to grant water-breathing abilities to a few followers."
#hp 30
#gcost 165
#end

#selectmonster 641 -- Consort (Atlantis)
#hp 41
#gcost 115
#end

#selectmonster 207 -- Shambler Chief (Atlantis & indie)
#hp 33
#gcost 50
#end

#newmonster 6926
#spr1 "./Hellenika/UlmChampion1.tga"
#spr2 "./Hellenika/UlmChampion2.tga"
#name "Warrior Champion"
#descr "While the people of Ulm despises magic and respects strength and martial skill more than nearly all else, this isn't for a lack of intelligence nor for a lack of respect for intelligence, and whoever fights the best doesn't always come to be a ruler. Instead, it is well understood that a good chief and a good combatant are two different things. No good chief can be weak, inexperienced or untrained, but other qualities are more important for a commander, such as that of guiding one's brethren in war with cunning strategy and effective understanding of logistics. For all their talents, battles and scars, chiefs thus aren't the toughest warriors in Ulm, but merely the most respected; finding stronger yet isn't difficult, and those who lack the ability to lead but show particularly admirable ability for killing are often rewarded with the title of Champion, granting them impressive honor and riches. The warrior champions of Ulm carry no authority other than their sword, but they are frequently sent in perilous missions as the spearhead of the nation, spreading carnage on their path until overconfidence awards them a glorious death."
#nametype 104
#hp 20
#size 2
#prot 0
#mr 8
#mor 18
#str 16
#def 16
#att 16
#prec 13
#mapmove 16
#enc 3
#reinvigoration 5
#berserk 5
#woundfend 1
#rpcost 1
#rcost 1
#gcost 150
#coldres 5
#maxage 50
#mountainsurvival
#forestsurvival
#snow
#weapon 260
#weapon 17
#weapon 8
#armor 12
#armor 20
#poorleader
#fear 5
#stealthy
#ambidextrous 2
#pillagebonus 5
#end

#newmonster 6924
#spr1 "./Hellenika/ChampionOfSteel1.tga"
#spr2 "./Hellenika/ChampionOfSteel2.tga"
#name "Son of Steel"
#descr "Chosen of the Spirits after many ruthless trials, with their blade blessed by the forge and their soul blessed by the battlefield, the Sons of Steel are identified by the Antlered Shamans under exceptional circumstances from among the best Steel Warriors. Invested with the will and power of the Enigma and the Ancestors, they are by far the greatest warriors of Ulm, the pride of its blood, and they all are fated to carve a great destiny - for their nation or for themselves remains to be seen. Although these legendary heroes are rare and often care little about the affairs of kings and gods, they can be convinced to put their glorious feats under the service of the Tribes in exchange for a royal quantity of gold. This indifference to the higher powers and religion in no way is displeasing to the God of Ulm - quite the contrary, it is a god that despises the weak and never answers prayers; only those who can take care of themselves without relying on anyone else deserve to be his champions, and thus, the Sons of Steel are as prophets to him, wordlessly conquering the hearts of those who witness their mythical prowesses. Since they are so mighty and don't believe in any authority, while bored they often let themselves drift towards decadent desires, so they represent terrible expenses for their allies while in friendly dominion; on the other hand, they have a true passion for battle, so they are much more content while fighting in enemy territory. If sneaking rather than fighting, they'll still find small settlements, ruins and dungeons to pillage, which will cause the province owner to suffer more expenses in both gold and lives and to notice the Son of Steel's presence, provided that they also have dominion over that province. In any case, since the Sons of Steel become the problems of others in such regions, they cost no upkeep while in enemy dominion."
#nametype 104
#hp 20
#size 2
#prot 0
#mr 20
#mor 30
#str 18
#def 18
#att 18
#prec 15
#mapmove 16
#enc 3
#reinvigoration 5
#berserk 5
#woundfend 3
#rpcost 0
#rcost 1
#gcost 585
#spreaddom 1
#coldres 8
#fireres 3
#shockres 3
#poisonres 3
#maxage 50
#holy
#mountainsurvival
#forestsurvival
#snow
#weapon 469
#armor 12
#armor 20
#goodleader
#command -70
#fear 5
#seduce 14
#stealthy
#haltheretic 7
#taxcollector
#gold -50
#notdomshape 4925
#userestricteditem 8092
#ambidextrous 3
#pillagebonus 5
#end

#newmonster 6925
#spr1 "./Hellenika/ChampionOfSteel1.tga"
#spr2 "./Hellenika/ChampionOfSteel2.tga"
#name "Son of Steel"
#descr "Chosen of the Spirits after many ruthless trials, with their blade blessed by the forge and their soul blessed by the battlefield, the Sons of Steel are identified by the Antlered Shamans under exceptional circumstances from among the best Steel Warriors. Invested with the will and power of the Enigma and the Ancestors, they are by far the greatest warriors of Ulm, the pride of its blood, and they all are fated to carve a great destiny - for their nation or for themselves remains to be seen. Although these legendary heroes are rare and often care little about the affairs of kings and gods, they can be convinced to put their glorious feats under the service of the Tribes in exchange for a royal quantity of gold. This indifference to the higher powers and religion in no way is displeasing to the God of Ulm - quite the contrary, it is a god that despises the weak and never answers prayers; only those who can take care of themselves without relying on anyone else deserve to be his champions, and thus, the Sons of Steel are as prophets to him, wordlessly conquering the hearts of those who witness their mythical prowesses. Since they are so mighty and don't believe in any authority, while bored they often let themselves drift towards decadent desires, so they represent terrible expenses for their allies while in friendly dominion; on the other hand, they have a true passion for battle, so they are much more content while fighting in enemy territory. If sneaking rather than fighting, they'll still find small settlements, ruins and dungeons to pillage, which will cause the province owner to suffer more expenses in both gold and lives and to notice the Son of Steel's presence, provided that they also have dominion over that province. In any case, since the Sons of Steel become the problems of others in such regions, they cost no upkeep while in enemy dominion."
#nametype 104
#hp 20
#size 2
#prot 0
#mr 20
#mor 30
#str 18
#def 18
#att 18
#prec 15
#mapmove 16
#enc 3
#reinvigoration 5
#berserk 5
#woundfend 3
#rpcost 0
#rcost 1
#gcost 0
#spreaddom 1
#coldres 8
#fireres 3
#shockres 3
#poisonres 3
#maxage 50
#holy
#mountainsurvival
#forestsurvival
#snow
#weapon 469
#armor 12
#armor 20
#goodleader
#command -70
#fear 5
#seduce 14
#stealthy
#haltheretic 7
#taxcollector
#domshape 4924
#userestricteditem 8092
#ambidextrous 3
#pillagebonus 5
#end

#selectmonster 2279 -- Warrior Scout (Ulm)
#name "Warrior Scout"
#descr "The warrior scouts of Ulm are used not only to operating alone in enemy territory, but also to surviving in the harshest conditions of the wild. In times of war their reports on enemy army movements and the resources in enemy lands are invaluable to the prudent warlord, and in times of peace they capture and train wolves, breeding them for hunting and warfare. They are not very good at leading human soldiers."
#makemonsters2 284
#okleader
#inspirational -2
#beastmaster 6
#animalawe 2
#gcost 40
#end

#selectmonster 1158 -- Warrior Chief (Ulm)
#mor 18
#gcost 75
#end

#selectmonster 1159 -- Warrior Smith (Ulm)
#fixforgebonus 2
#gcost 110
#end

#newmonster 7303
#spr1 "Hellenika/PelagianCommander1.tga"
#spr2 "Hellenika/PelagianCommander2.tga"
#copystats 2391 -- Triton Rider
#name "Triton Rider Captain"
#descr "These elite Triton warriors are the predecessors of the Triton knights of later eras. They ride hippocampoi, magical steeds that are able to strike enemies or heal their rider with their horns, and they are among the fastest military forces known to the underwater realms."
#gcost 90
#rpcost 1
#rcost 1
#goodleader
#hp 17
#mor 14
#str 13
#att 12
#def 12
#armor 224 -- Shell cap
#end

#selectmonster 2399 -- Aphroi Lord (UW)
#name "Aphroi Lord"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as sacred warriors equipped with lances and symbiotic armors of living coral which help them crush their foes with their terrifying pincers."
#regeneration 10
#gcost 145
#mapmove 24
#clearweapons
#weapon 651
#weapon 55
#weapon 1237 -- pincer
#end

#selectmonster 2400 -- Aphroi Lord (land)
#name "Aphroi Lord"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as sacred warriors equipped with lances and symbiotic armors of living coral which help them crush their foes with their terrifying pincers."
#regeneration 10
#gcost 145
#clearweapons
#weapon 651
#weapon 55
#weapon 1237 -- pincer
#end

#selectmonster 2392 -- Aphroi Hierophant (UW)
#name "Aphroi Hierophant"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as hierophants, chanting priests. Hierophants have some skills in Nature or Water magic."
#regeneration 10
#gcost 135
#mapmove 24
#twiceborn 719
#clearweapons
#weapon 7
#weapon 55
#end

#selectmonster 2393 -- Aphroi Hierophant (land)
#spr1 "./Hellenika/2393_1.tga"
#spr2 "./Hellenika/2393_2.tga"
#name "Aphroi Hierophant"
#descr "The Aphroi are ichtycentaurs of pure blood. They are marked by their creator with lobster claws on their brows, a sure sign of divine heritage. All Aphroi receive special status in Oceania and many are trained as hierophants, chanting priests. Hierophants have some skills in Nature or Water magic."
#regeneration 10
#gcost 135
#twiceborn 719
#clearweapons
#weapon 7
#weapon 55
#end

#selectmonster 2374 -- Ichtycentaur Commander (UW)
#regeneration 10
#gcost 90
#mapmove 24
#clearweapons
#weapon 651
#weapon 55
#end

#selectmonster 2375 -- Ichtycentaur Commander (land)
#regeneration 10
#gcost 90
#clearweapons
#weapon 651
#weapon 55
#end

#selectmonster 2950 -- Ishib (Akkad)
#name "Ishib"
#descr "The Ishib is a priest of the old faith trained and ordained in the House of Two Rivers, which now replaces in Akkad the House of Water of Eridu. As newly-founded cities erected temples of their own the Ishibs lost of their former influence save in the Primordial City and its controlled territory. With the great schism, the Ensi of Eridu was replaced by the Entu of the Moon as the highest religious authority in the kingdom, but the Ishibs, sequestered in their temples, did not react. When the Great Temple of the Moon was finally erected, religious influence was transferred from the Ishibs and the House of Water to this new center. Now Akkadian Ishibs are merely relics of the old faith that still rules in Eridu, but what they lost in official power, they retained in respect from the people. Indeed, the Ishibs are now revered by the populace for their wisdom and for the antiquity of their institutions, and as such they have replaced the Elders of old as local magistrates. The Ishibs of Akkad are such effective defence organisers that in addition to the normal effects of this ability each province with at least one Ishib will see its province defense increased by two each month with an upper limit of one hundred."
#hp 36
#gcost 155
#taxcollector
#incprovdef 2
#resources 5
#end

#selectmonster 2951 -- Ashipu
#hp 36
#gcost 130
#clearweapons
#weapon 92
#end

#selectmonster 2952 -- Mashmashu
#hp 36
#gcost 280
#allrange 4
#montag 4124 -- foreign savant
#clearweapons
#weapon 92
#end


#selectmonster 2954 -- Enkidu Shaman (Akkad)
#name "Enkidu Shaman"
#descr "The Shamans were once the spiritual leaders of the Enkidus. Now there is almost no one in Akkad left who remembers the old ways and the few shamans who still wander the lands have lost most of their fabled powers. Even when a stronger shaman arises, it is common for him to leave for the more naturalistic territory of Eridu where many wild tribes still prosper. Still, those who remain are among the strongest masters of Nature magic in Akkad, so much so that they are capable of casting the Transformation ritual."
#montag 4153 -- can cast Transformation
#hp 36
#gcost 125
#end

#selectmonster 2942 -- Enkidu Commander
#name "Enkidu Commander"
#descr "With the founding of new cities wealth is accumulating. Without central leadership there was a growing rivalry between the city states. With time each city fielded their own army to defend themselves from neighboring city states. Now that the city states of Akkad are united and free from Eridu's ruling dynasty, the Enkidu commanders lead smaller armies, but in the event of a large-scale war, each city is supposed to field a great army led by its Ensi."
#hp 36
#gcost 30
#end

#selectmonster 3093 -- Kulullu Commander
#name "Kulullu Commander"
#descr "The Kulullus are an ancient race of strange beings whose bodies resemble a combination of Enkidu and fish. The Kulullus have lived in the seas near Ur since before the First City was founded and they claim to have founded the first of the kingdoms underneath the waves. Some sages even believe that when U'an the Apkallu emerged from the sea to bring civilization to Ur he had already brought his gifts to the Kulullus. But war and strife brought by less peaceful beings almost destroyed the Kulullu kingdom. Kulullu myths claim that an apostle of U'an will one day arrive from dry land to rebuild the old Kulullu kingdom."
#gcost 45
#hp 46
#end

#selectmonster 3094 -- Kulullu King
#name "Kulullu King"
#descr "The Kulullu kingdom came into being when U'an brought civilization and culture to the depths. Kulullu society is in many ways organized as the Enkidu society of the First City, but since the kingdom came under the pressure from other underwater races, the centralized government crumbled. With the alliance with the Enkidus the Kulullus are trying to reestablish the ancient order and kings and queens once more lead the Kulullus. The Kulullu king is what the Ensi is to the Enkidus, a priest king and supreme commander. As is the case in Eridu, the Kulullu underwater kingdoms prosper if led by a royal couple; thus, any underwater fort with a temple, a Kuliltu Queen and a Kulullu King will generate double gold income."
#hp 48
#magicskill 8 3
#older -12
#end

#selectmonster 2934 -- Enkidu Scout (Akkad)
#name "Enkidu Scout"
#descr "The last few tribal Enkidus of Akkad make better scouts than their civilized brethren. Indeed, they have much better knowledge of the wild and its secrets, which certainly is useful for travel and stealth. As such, the now rare wild men of the confederacy's lands are highly sought out by the Ensis for their skills."
#swampsurvival
#hp 36
#gcost 30
#end

#selectmonster 2161 -- Enkidu Scout (Eridu)
#name "Enkidu Scout"
#descr "Enkidus are large, hairy wild men with horns and unkempt hair. They live and frolic with the beasts of the wilderness and have only a vague notion of the concept of civilization. Since the First War ages ago, a great traumatism has marked the Enkidu race, and to most civilization now means Avvite slavers. Some efforts have been made by the Royal Couple and its followers to change this, but only as far as could be done while preserving their people's trust and respecting the divine principles of balance taught by the Apkallu. As a result, not much has changed for Eridu in the last few millenia; but nonetheless, slowly increasing numbers of the wild men are adopting the ever-nascent ways of farming and metalworking. Still, most Enkidus live pastoral lives in small tribal groups."
#swampsurvival
#rpcost 1
#hp 36
#gcost 30
#end

#selectmonster 2177 -- Enkidu Commander
#name "Enkidu Commander"
#descr "Since the founding of the Primordial City millenia ago, wealth has been accumulating and need has been found for organized defence. With the ever-nascent discovery of metalcrafting, it became possible to arm soldiers with modern weapons and armor. The commanders of Ur lead smaller armies, but in the event of a large scale war, the Ensi is supposed to lead the nation."
#rpcost 0
#gcost 45
#hp 39
#end

#selectmonster 2178 -- Enkidu Elder
#name "Enkidu Elder"
#descr "Much of the day to day affairs of the First City is entrusted to the Council of Elders, where they indeed assemble and are much easier to find. Matters of war and sacred affairs are generally managed by the priests and their king, but sometimes an Elder is given an army to lead. The Elders command great respect, but are not very good war-leaders. A few of the Elders are old and wise enough to remember some ancient secrets of the magic of the Apkallu. With enough investment in gems and support from researchers, finding one of those could be a way to recall the divine protectors of Eridu in this world, and would result in an increase of the power of the Council of Elders. As such, while an Umu-apkallu is in the capital, there is a chance, once every other month on average, that an Elder located there will be invested with sacred authority and begin spreading dominion like a prophet."
#rpcost 1
#hp 36
#gcost 15
#fixedresearch 1
#magicimmune
#drainimmune
#custommagic 2048 5
#montag 4165
#end

#newmonster 6823
#copyspr 2178
#copystats 2178
#rpcost 0
#end

#newmonster 6940
#copyspr 2178
#copystats 2178
#gcost 0
#spreaddom 1
#end

#newmonster 7369
#copyspr 2178
#name "Enkidu Elder Spectre"
#descr "You shouldn't be able to see this monster. Vengeful Waters is the most common cause for revealing it and is usually fine. Seen in battle, if it has regeneration and survived all should be fine; if it doesn't have regeneration and didn't lose any health, it should be fine as well. In all other cases, this might cause game-breaking bugs. Please report it to Hellenika's modmaker if you fear this might be the case or if the cause wasn't Vengeful Waters."
#nowish
#stealthy 1000
#startitem 858
#itemslots 2048 -- 1 feet
#hp 500
#size 6
#prot 40
#mr 50
#mor 50
#str 50
#att 50
#def 50
#prec 50
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 1000
#inanimate
#deserter 100
#nohof
#heal
#float
#end

#newmonster 6534
#copyspr 1753
#name "Tuatha Spectre"
#descr "You shouldn't be able to see this monster. Vengeful Waters is the most common cause for revealing it and is usually fine. Seen in battle, if it has regeneration and survived all should be fine; if it doesn't have regeneration and didn't lose any health, it should be fine as well. In all other cases, this might cause game-breaking bugs. Please report it to Hellenika's modmaker if you fear this might be the case or if the cause wasn't Vengeful Waters."
#nowish
#stealthy 1000
#startitem 858
#itemslots 2048 -- 1 feet
#hp 500
#size 6
#prot 40
#mr 50
#mor 50
#str 50
#att 50
#def 50
#prec 50
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 1000
#inanimate
#deserter 100
#nohof
#heal
#float
#end

#selectmonster 2180 -- Ishib
#rpcost 1
#gcost 195
#hp 36
#end

#selectmonster 2268 -- Gudu
#rpcost 1
#gcost 155
#hp 36
#end

#newmonster 7493
#copyspr 2181
#name "Eridu Fertility Spectre"
#descr "You shouldn't be able to see this monster. Vengeful Waters is the most common cause for revealing it and is usually fine. Seen in battle, if it has regeneration and survived all should be fine; if it doesn't have regeneration and didn't lose any health, it should be fine as well. In all other cases, this might cause game-breaking bugs. Please report it to Hellenika's modmaker if you fear this might be the case or if the cause wasn't Vengeful Waters."
#nowish
#stealthy 1000
#startitem 858
#itemslots 2048 -- 1 feet
#hp 500
#size 6
#prot 40
#mr 50
#mor 50
#str 50
#att 50
#def 50
#prec 50
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 1000
#inanimate
#deserter 100
#nohof
#heal
#float
#end

#selectmonster 2181 -- Ensi (Eridu)
#name "Ensi"
#descr "The First City of Eridu is ruled by priest-kings. The Ensi leads the lesser priests and ensures the prosperity of the kingdom. Once every year he participates in the sacred marriage ritual together with his consort the Entu, the priestess-queen. Their joining ensures the fertility and prosperity of the whole kingdom, in addition to tremendously reducing unrest and inspiring a few new men to join the province defense every month. Ultimately, the Ensi hopes to be chosen as a vessel for the legendary Dawn Warrior to return in this world and ascend as the reputedly invincible King of the World. According to legends, such will only happen if an Enkidu king equips all four artifacts of Dawn at once. However, such will surely mark the end of this Ensi's terrestrial life as the First Hero manifests in his place and takes permanent hold of his divine armaments."
#rpcost 3
#gcost 290
#hp 39
#montag 4168
#userestricteditem 8094
#end

#newmonster 6912
#copyspr 2181
#copystats 2181 -- Ensi (Eridu)
#name "Ensi"
#descr "The First City of Eridu is ruled by priest-kings. The Ensi leads the lesser priests and ensures the prosperity of the kingdom. Once every year he participates in the sacred marriage ritual together with his consort the Entu, the priestess-queen. Their joining ensures the fertility and prosperity of the whole kingdom, in addition to tremendously reducing unrest and inspiring a few new men to join the province defense every month. Ultimately, the Ensi hopes to be chosen as a vessel for the legendary Dawn Warrior to return in this world and ascend as the reputedly invincible King of the World. According to legends, such will only happen if an Enkidu king equips all four artifacts of Dawn at once. However, such will surely mark the end of this Ensi's terrestrial life as the First Hero manifests in his place and takes permanent hold of his divine armaments."
#rpcost 3
#gcost 290
#hp 39
#montag 4168
#userestricteditem 8094
#end

#newmonster 6913
#copyspr 2181
#copystats 2181 -- Ensi (Eridu)
#name "Ensi"
#descr "The First City of Eridu is ruled by priest-kings. The Ensi leads the lesser priests and ensures the prosperity of the kingdom. Once every year he participates in the sacred marriage ritual together with his consort the Entu, the priestess-queen. Their joining ensures the fertility and prosperity of the whole kingdom, in addition to tremendously reducing unrest and inspiring a few new men to join the province defense every month. Ultimately, the Ensi hopes to be chosen as a vessel for the legendary Dawn Warrior to return in this world and ascend as the reputedly invincible King of the World. According to legends, such will only happen if an Enkidu king equips all four artifacts of Dawn at once. However, such will surely mark the end of this Ensi's terrestrial life as the First Hero manifests in his place and takes permanent hold of his divine armaments."
#rpcost 3
#gcost 290
#hp 39
#montag 4168
#userestricteditem 8094
#end

#newmonster 6914
#copyspr 2181
#copystats 2181 -- Ensi (Eridu)
#name "Ensi"
#descr "The First City of Eridu is ruled by priest-kings. The Ensi leads the lesser priests and ensures the prosperity of the kingdom. Once every year he participates in the sacred marriage ritual together with his consort the Entu, the priestess-queen. Their joining ensures the fertility and prosperity of the whole kingdom, in addition to tremendously reducing unrest and inspiring a few new men to join the province defense every month. Ultimately, the Ensi hopes to be chosen as a vessel for the legendary Dawn Warrior to return in this world and ascend as the reputedly invincible King of the World. According to legends, such will only happen if an Enkidu king equips all four artifacts of Dawn at once. However, such will surely mark the end of this Ensi's terrestrial life as the First Hero manifests in his place and takes permanent hold of his divine armaments."
#rpcost 3
#gcost 290
#hp 39
#montag 4168
#userestricteditem 8094
#end

#newmonster 6363
#copyspr 2181
#name "Ensi Echo"
#descr "You shouldn't be able to see this monster. Vengeful Waters is the most common cause for revealing it and is usually fine. Seen in battle, if it has regeneration and survived all should be fine; if it doesn't have regeneration and didn't lose any health, it should be fine as well. In all other cases, this might cause game-breaking bugs. Please report it to Hellenika's modmaker if you fear this might be the case or if the cause wasn't Vengeful Waters."
#nowish
#stealthy 1000
#startitem 858
#itemslots 2048 -- 1 feet
#hp 500
#size 6
#prot 40
#mr 50
#mor 50
#str 50
#att 50
#def 50
#prec 50
#enc 0
#mapmove 0
#invisible
#immobile
#unteleportable
#ap 0
#maxage 10000
#amphibian
#gcost 0
#woundfend 1000
#inanimate
#deserter 100
#nohof
#heal
#float
#end

#selectmonster 2943 -- Ensi (Akkad)
#name "Ensi"
#descr "Once there was but one Ensi, the priest-king of the Primordial City. But as new cities were founded Eridu lost influence and the leaders and founders of the new cities claimed Ensi-hood and religious authority. With time the Ensi of the First City stopped being recognized in Akkad as anything but one of several petty kings of equal power and authority. Though the Akkadian city states often had to unite in order to stop Eridu from dominating them, never was the Primordial City able to decisively defeat their pact - which led them to grow into an empire. Now there is an Ensi priest-governor for each city state. Rivalry between the cities has occasionally led to times of strife, but so far no Ensi has managed to conquer all of the other city states. With the imminent arrival of the Awakening God the Ensis have set their differences aside and Akkad has become a united nation once more. Eridu however lives on and retains the strength to guarantee its own independence alone."
#hp 41
#gcost 215
#montag 4168
#userestricteditem 8094
#end

#newmonster 7086
#spr1 "./Hellenika/YlthuleWiz1.tga"
#spr2 "./Hellenika/YlthuleWiz2.tga"
#name "Student of Balance"
#descr "Students of Balance are the members of a newly founded order of mages who, inspired by the Twilight Avatar's mysticism, attempt to recover the lost magic of the Pantokrator and access an equal understanding of all the arcane paths all the while rejecting the excesses of those who neglect some of them. This is a collective effort and, due to the very recent creation of this group, most of its members are still novices, but they are nonetheless confident that, with the help of their divine master, they soon will outshine the spell weavers of the other, more dogmatic and less ambitious nations. Although preference is generally given by the Hallowed Wanderers to priests, witches, shamans and sorcerers of local traditions, whose ancestral lore is more fine-tuned, the hard-working Students of Balance are seen as promising enough that they have been tasked with bringing the light of knowledge to the least civilized provinces, where new colleges of young initiates are frequently established - a precious opportunity for them to further their nascent yet already unmistakable influence."
#hp 10
#size 2
#prot 0
#mr 12
#mor 8
#str 10
#att 10
#def 10
#prec 10
#ap 12
#mapmove 16
#enc 3
#maxage 50
#poorleader
#custommagic 32640 100
#gcost 110
#rpcost 4
#rcost 1
#weapon 7
#armor 15
#armor 118
#end

#newmonster 6923
#spr1 "./Hellenika/YlthuleTriton1.tga"
#spr2 "./Hellenika/YlthuleTriton2.tga"
#name "Student of Balance"
#descr "Students of Balance are the members of a newly founded order of mages who, inspired by the Twilight Avatar's mysticism, attempt to recover the lost magic of the Pantokrator and access an equal understanding of all the arcane paths all the while rejecting the excesses of those who neglect some of them. This is a collective effort and, due to the very recent creation of this group, most of its members are still novices, but they are nonetheless confident that, with the help of their divine master, they soon will outshine the spell weavers of the other, more dogmatic and less ambitious nations. Although preference is generally given by the Hallowed Wanderers to priests, witches, shamans and sorcerers of local traditions, whose ancestral lore is more fine-tuned, the hard-working Students of Balance are seen as promising enough that they have been tasked with bringing the light of knowledge to the least civilized provinces, where new colleges of young initiates are frequently established - a precious opportunity for them to further their nascent yet already unmistakable influence."
#nametype 159
#hp 12
#size 2
#prot 1
#mr 12
#mor 8
#str 12
#att 10
#def 10
#prec 10
#ap 20
#mapmove 16
#enc 3
#maxage 50
#poorleader
#custommagic 32640 100
#gcost 90
#rpcost 4
#rcost 1
#weapon 674
#aquatic
#itemslots 13446 -- 2 hands, head, body, 2 misc
#end

#newmonster 6955
#spr1 "./Hellenika/WizardOfBalance1.tga"
#spr2 "./Hellenika/WizardOfBalance2.tga"
#name "Wizard of Balance"
#descr "Experienced and ambitious mages from all horizons, the Wizards of Balance are the the masters and teachers of the Students of Balance. Unlike them, most have learned their craft before the coming of the Avatar. In search of esoteric secrets and desirous of increasing their power over magic, all Wizards of Balance have somehow reached the Terra Ultima. There, they found the noble and incomprehensible ruins of the Pantokrator's sanctum and, dazzled by the Dark Messiah's might, have sworn allegiance to him in exchange for his blessing. Thus, although they lack the religious authority of the Hallowed Wanderers and much of their skills, they are like them able to breath without air as well as to travel by Will and the Laws of Simultaneity. Wizards of Balance may either be recruited in the capital or in provinces with Order scales join on their own after their initiatic journey to the Septentrional Isle."
#hp 9
#size 2
#prot 0
#mr 14
#mor 12
#str 9
#att 8
#def 8
#prec 13
#ap 10
#mapmove 16
#enc 3
#maxage 50
#older 15
#poorleader
#custommagic 32640 200
#custommagic 32640 30
#researchbonus 10
#gcost 220
#rpcost 4
#rcost 1
#weapon 7
#teleport
#pooramphibian
#coldrec -2
#end

#newmonster 7087
#spr1 "./Hellenika/PankOracle1.tga"
#spr2 "./Hellenika/PankOracle2.tga"
#name "Hallowed Wanderer"
#descr "Once upon a time, the world was much simpler. Only one true God existed to be worshipped, uncontested; only one truth to be preached, one future to be divined. In this time, those we now call Hallowed Wanderers were high priests of the Pantokrator and walked in the light, their spiritual authority unchallenged; all attended their rituals, all listened to their wisdom, all feared and respected their omens. But one day, silence fell upon their temples. No longer were their prayers answered, no longer did their prophecies come true. At first, there was great confusion - no one could tell for sure what was happening. But little by little, as no sign was given and as the ancient powers waned, faith began to falter, soon to be replaced by anguish and blasphemy. The entire universe had wordlessly been abandoned by its God, the Pantokrator had disappeared and all meaning along with him. An eon of simplicity and clarity had come to an abrupt end, nothing could stop the world from falling into an era of darkness and chaos any longer. To doubt followed fear, and to fear, new prophecies spelled by false deities old and new, of alien descent and evil intentions. The Pantokrator's chosen soon were disgraced and chased away from their crumbling temples, their once great creed falling into oblivion. Many lost hope. Many abjured. Some didn't, but nearly all had to leave the light and start walking in the shadows. And then came the Dark Messiah, and so hope was reborn. Today, not much remains of the ancient religion, but the secretive Hallowed Wanderers, convinced that it isn't too late and gifted with many strange powers, work tirelessly to rebuild and reform it in his wake, claiming their Septentrional Cult to be its true successor. Oracles of the Absent God, they are his Son-and-Shadow's most prized instruments to rise as the next Pantokrator. They chant his hymns in battle and administer his provinces. When appointed as prophets, they receive increased priestly authority."
#mr 16
#mor 8
#att 8
#def 8
#ap 12
#mapmove 14
#enc 4
#older 15
#addrandomage 10
#gcost 250
#rcost 1
#rpcost 4
#nobadevents 20
#custommagic 65408 100
#magicskill 8 1
#magicboost 8 1
#stealthy
#spy
#researchbonus 8
#teleport
#incprovdef 19
#inspiringres 1
#okleader
#poormagicleader
#weapon 9
#armor 158
#coldrec -2
#pooramphibian
#montag 4124
#end

#newmonster 6887 -- hero
#spr1 "./Hellenika/PankOracle1.tga"
#spr2 "./Hellenika/PankOracle2.tga"
#name "Hallowed Wanderer"
#descr "Once upon a time, the world was much simpler. Only one true God existed to be worshipped, uncontested; only one truth to be preached, one future to be divined. In this time, those we now call Hallowed Wanderers were high priests of the Pantokrator and walked in the light, their spiritual authority unchallenged; all attended their rituals, all listened to their wisdom, all feared and respected their omens. But one day, silence fell upon their temples. No longer were their prayers answered, no longer did their prophecies come true. At first, there was great confusion - no one could tell for sure what was happening. But little by little, as no sign was given and as the ancient powers waned, faith began to falter, soon to be replaced by anguish and blasphemy. The entire universe had wordlessly been abandoned by its God, the Pantokrator had disappeared and all meaning along with him. An eon of simplicity and clarity had come to an abrupt end, nothing could stop the world from falling into an era of darkness and chaos any longer. To doubt followed fear, and to fear, new prophecies spelled by false deities old and new, of alien descent and evil intentions. The Pantokrator's chosen soon were disgraced and chased away from their crumbling temples, their once great creed falling into oblivion. Many lost hope. Many abjured. Some didn't, but nearly all had to leave the light and start walking in the shadows. And then came the Dark Messiah, and so hope was reborn. Today, not much remains of the ancient religion, but the secretive Hallowed Wanderers, convinced that it isn't too late and gifted with many strange powers, work tirelessly to rebuild and reform it in his wake, claiming their Septentrional Cult to be its true successor. Oracles of the Absent God, they are his Son-and-Shadow's most prized instruments to rise as the next Pantokrator. They chant his hymns in battle and administer his provinces. When appointed as prophets, they receive increased priestly authority."
#mr 16
#mor 8
#att 8
#def 8
#ap 12
#mapmove 14
#enc 4
#older 15
#addrandomage 10
#gcost 250
#rcost 1
#rpcost 4
#nobadevents 20
#custommagic 65408 100
#magicskill 8 1
#magicboost 8 1
#stealthy
#spy
#researchbonus 8
#teleport
#incprovdef 19
#inspiringres 1
#okleader
#poormagicleader
#weapon 9
#armor 158
#coldrec -2
#pooramphibian
#end

#selectmonster 3321 -- King of the Lost Tribe
#name "King of the Lost Tribe"
#descr "In Magnificent Ind there is a wasteland inhabited by six-fingered giants with skin as pale as death. In ancient times these giants were immensely large and powerful enough to threaten the gods themselves. They are bound to their land by a divine decree, lest they overtake the world. The Kings of the Lost Tribe claim a legacy from the Lords of Civilization and are innately skilled in the magic of the Grigori. They are of an older order and their words are anathema to the faith of Magnificent Ind, thus the Prester King has not asked the Lord to lift the decree. In exchange for their limited autonomy within the confines of their mystical prison, the Giants of the Lost Tribe have taken upon themselves to take care of their own and as a result cost no upkeep even when they risk their life to brave the law that binds them to their land."
#addupkeep -195
#hp 82
#gcost 195
#heal
#clearweapons
#weapon 1232
#weapon 331
#end

#selectmonster 2397 -- Pearl King
#gcost 485
#custommagic 10496 100
#magicskill 1 1
#end

#selectmonster 3379 -- Great Huntress (Ind)
#hp 31
#gcost 50
#end

#selectmonster 3290 -- Bishop Vicomte
#name "Bishop Vicomte"
#descr "Under each Viceroy Primate there is a number of governors who are also bishops. They perform most of the administrative duties of the government and are tasked with keeping the heathens and cannibals under control. The cannibals themselves don't have the discipline or training to command and lead men and would likely just plunder their own lands were they not reigned in by the Bishop Vicomtes of Ind. Any fortless province where Heathens are being mobilized will receive 30 percent increased tax income that month."
#incunrest -20
#end

#selectmonster 3291 -- Viceroy Primate
#name "Viceroy Primate"
#descr "The subservient lands of heathens are ruled by Viceroys who are also high priests and generals. They reign in the heathen tribes and prepare for their eventual release upon the world. The Viceroy Primates are administrative rulers and rarely lead the cannibal tribes into battle. The Viceroy Primates regularly return to Magnificent Ind to drink from the Fountain of Youth and most of them have lived for centuries. Any fortless province where Heathens are being mobilized will receive 30 percent increased tax income that month."
#incunrest -40
#end

#selectmonster 231 -- Centaur Hierophant
#name "Centaur Hierophant"
#descr "Most halfmen of Pangaea have brown hides. When a calf with white hide is born, there is much celebration, for the young one is touched by the God and sacred. White centaurs serve as priests and guardians of the sacred Groves of Pangaea, singing the sacred songs and serving the dryads. Others are trained in warfare as sacred centaur warriors of tremendous ferocity."
#gcost 120
#twiceborn 714
#clearmagic
#magicskill 6 1
#magicskill 8 1
#custommagic 1024 50
#custommagic 10368 10
#end

#selectmonster 2158 -- Centauride Hierophantide
#name "Centauride Hierophantide"
#descr "Most halfmen of Pangaea have brown hides. When a calf with white hide is born, there is much celebration, for the young one is touched by the God and sacred. White centaurides serve as priests and guardians of the sacred Groves of Pangaea, singing the sacred songs and helping the dryads."
#userestricteditem 8069
#twiceborn 6939
#gcost 120
#armor 148
#clearmagic
#magicskill 6 1
#magicskill 8 1
#custommagic 512 50
#custommagic 12544 10
#end

#selectmonster 2479 -- Centaur Sage
#name "Centaur Sage"
#descr "Centaur Sages are the mystical disciples of the the great white Ancient, the Wise Guardian Stag. Enlightened by his teachings, they have acquired innate mastery of Astral and Nature magic as well as a great erudition. Centaur Sages are very devoted to their master and will serve without requiring an upkeep cost. A new Centaur Sage will join Pangaea every month that his patron Divine Beast spends researching."
#gcost 0
#twiceborn 714
#clearmagic
#magicskill 4 1
#magicskill 6 1
#end

#selectmonster 15 -- Hypaspist commander
#name "Hypaspist Commander"
#descr "The commanders of the hypaspist armies are known for their bravery and charisma. They are armed as hypaspists but their armor is gilded and shiny. Like them, they also are very skilled in combat, and the elite training they already received as troops makes them slightly cheaper than other commanders to recruit."
#woundfend 1
#str 13
#att 13
#mr 11
#mor 15
#enc 2
#hp 14
#end

#selectmonster 13 -- Hoplite commander
#name "Hoplite Commander"
#descr "The commanders of the hoplite armies are known for their bravery and charisma. They are armed as hoplites but their armor is gilded and shiny. Like them, they also are very common and do not require high wages, which halves their upkeep cost as commanders."
#addupkeep -38
#end

#selectmonster 1552 -- Phalangite commander
#name "Phalangite Commander"
#descr "The commanders of the phalangite armies are known for their bravery and charisma. They are armed as phalangites but their armor is gilded and shiny. Like them, they also require low infrastructure and preparation to be recruited and therefore they do not cost any commander point."
#rpcost 0
#end

#selectmonster 644 -- Traitor Prince
#hp 41
#gcost 80
#taskmaster 1
#decscale 1
#end

#selectmonster 1523 -- Slave Prince
#hp 41
#gcost 80
#end

#selectmonster 1750 -- Fir Bolg Champion (TNN)
#pillagebonus 2
#castledef 2
#berserk 2
#reinvigoration 1
#end

#selectmonster 1815 -- Fir Bolg Champion (Fomoria)
#pillagebonus 2
#castledef 2
#berserk 2
#reinvigoration 1
#end

#selectmonster 1754 -- Ri
#gcost 355
#combatcaster
#hp 20
#mor 18
#str 14
#att 15
#def 17
#enc 2
#yearturn 5
#magicpower 1
#twiceborn 1754
#end

#selectmonster 714 -- Carrion Centaur
#name "Carrion Centaur"
#descr "A carrion centaur is the reanimated carcass of a centaur Hierophant. The soul of the centaur is forced to rejoin its own moss-covered carcass by a Panic Apostate. The bones are entwined with vines and roots that have a life of their own. The priestly powers of the former centaur are corrupted. Instead, the carrion centaur has unholy powers over the dead and is able to create manikins by animating vines, roots and the bones of dead beasts. The Carrion Centaur spreads his infection to his foes and will therefore raise as a new, temporary manikin anyone that he kills in battle, but in addition he has unholy powers over the dead and is able to create manikins by animating vines, roots and the bones of dead beasts."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#newmonster 6939
#copyspr 714
#copystats 714 -- Carrion Centaur
#name "Carrion Centauride"
#descr "A carrion centauride is the reanimated carcass of a centaur Hierophantide. The soul of the centauride is forced to rejoin its own moss-covered carcass by a Panic Apostate. The bones are entwined with vines and roots that have a life of their own. The priestly powers of the former centaur are corrupted. Instead, the carrion centaur has unholy powers over the dead and is able to create manikins by animating vines, roots and the bones of dead beasts. The Carrion Centauride spreads her infection to her foes and will therefore raise as a new, temporary manikin anyone that she kills in battle, but in addition she has unholy powers over the dead and is able to create manikins by animating vines, roots and the bones of dead beasts."
#female
#userestricteditem 8069
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 2312 -- (Black) Centauride Hierophantide
#userestricteditem 8069
#twiceborn 6939
#gcost 110
#armor 148
#end

#selectmonster 2311 -- (Black) Centaur Hierophant
#gcost 110
#twiceborn 714
#end

#selectmonster 1881 -- Satyr (Orgy)
#chaospower 1
#end

#selectmonster 2118 -- Satyr Commander
#addupkeep -20
#chaospower 1
#end

#selectmonster 2154 -- Satyr Commander
#addupkeep -20
#chaospower 1
#end

#selectmonster 2370 -- Ichtysatyr Scout (UW)
#addupkeep -10
#regeneration 10
#gcost 20
#chaospower 1
#end

#selectmonster 2371 -- Ichtysatyr Scout (land)
#addupkeep -10
#regeneration 10
#gcost 20
#chaospower 1
#end

#selectmonster 2372 -- Ichtysatyr Commander (UW)
#addupkeep -20
#regeneration 10
#gcost 40
#chaospower 1
#end

#selectmonster 2373 -- Ichtysatyr Commander (land)
#addupkeep -20
#regeneration 10
#gcost 40
#chaospower 1
#end

#selectmonster 2485 -- Satyr Commander
#addupkeep -20
#chaospower 1
#end

#selectmonster 236 -- Minotaur Lord
#prot 6
#att 12
#def 11
#hp 32
#unsurr 3
#command 0
#goodleader
#reinvigoration 4
#end

#selectmonster 1534 -- Minotaur Lord
#prot 6
#hp 36
#att 13
#def 11
#unsurr 3
#command 0
#goodleader
#reinvigoration 4
#clearweapons
#weapon 698
#end

#selectmonster 701 -- Minotaur Commander
#prot 6
#hp 32
#att 13
#def 12
#unsurr 3
#reinvigoration 4
#end

#selectmonster 645 -- Illithid Lord
#name "Illithid Lord"
#descr "Illithids are members of a once great race from a distant star. The body of an Illithid resembles a pink mass of writhing tentacles. They cover their bodies in robes made of strange flowing materials. Their heads are squidlike, with tentacles where their mouths should be. The mere touch of an Illithid sucks the life force out of living beings. Illithids are mentally powerful beings, able to paralyze enemies by sheer strength of mind. The soldiers and lords of the race are equipped with plate cuirass and tridents. All Illithids are amphibious. Illithid Lords have an innate understanding of the stars and are able to receive additional Astral magic levels from items even though they aren't mages."
#userestricteditem 8088
#magicskill 4 1
#magicboost 4 -1
#combatcaster
#woundfend 3
#gcost 80
#magiccommand 20
#rpcost 1
#noreqlab
#voidret 10
#end

#selectmonster 332 -- Starspawn
#name "Starspawn Architect"
#descr "Starspawns are ancient Illithids of tremendous power. Most remember the day when the Star fell and the City of R'lyeh was built. The Starspawns are masters of Astral magic and adept in the path of Water. Some carry priestly authority and all are masters of the mind. All Illithids are amphibious and able to use a mind blast attack in battle."
#userestricteditem 8088
#researchbonus 4
#magicstudy 1
#gcost 290
#clearweapons
#weapon 1116
#weapon 63
#voidret 10
#end

#selectmonster 333 -- Starspawn
#name "Starspawn Invoker"
#descr "Starspawns are ancient Illithids of tremendous power. Most remember the day when the Star fell and the City of R'lyeh was built. The Starspawns are masters of Astral magic and adept in the path of Water. Some carry priestly authority and all are masters of the mind. All Illithids are amphibious and able to use a mind blast attack in battle."
#userestricteditem 8088
#researchbonus 4
#magicstudy 1
#gcost 200
#clearweapons
#weapon 1116
#weapon 63
#voidret 10
#end

#newmonster 6918
#copystats 333
#copyspr 333
#voidret 10
#end

#newmonster 6919
#copystats 333
#copyspr 333
#voidret 10
#teleport
#end

#selectmonster 203 -- High Seraph
#name "High Seraph"
#descr "The High Seraphs are the highest ranking of the Seraphs. With the rejection of the Eagle Kings' reign and the exile to Mount Hararat they have turned from administrators and judges to rulers. With their powerful magic they have constructed the Palace of Frozen Crystal where they live and take the necessary decisions to protect the future of their young kingdom. The memory of the Eagle Kings' corruption at the hand of the Raptors has led them to prudence and seclusion from other societies. Only recently has any contact been made with the outside world. The High Seraphs are mighty Air mages and are also skilled in the path of Water. A few of them still remember and use the dark magic of the Harab Seraphs, but those that do are looked upon with suspicion and distrust and are only tolerated because of the necessity to know the enemy's weapons to better fight it. When becoming a prophet, a High Seraph will also receive improved magical skills in the form of two temporary Air gems at the start of every battle and bless his entire province with the supernatural protection of winter by starting to spread Cold scales."
#montag 4124
#userestricteditem 8059
#end

#selectmonster 615 -- High Seraph prophet
#name "High Seraph"
#descr "The High Seraphs are the highest ranking of the Seraphs. With the rejection of the Eagle Kings' reign and the exile to Mount Hararat they have turned from administrators and judges to rulers. With their powerful magic they have constructed the Palace of Frozen Crystal where they live and take the necessary decisions to protect the future of their young kingdom. The memory of the Eagle Kings' corruption at the hand of the Raptors has led them to prudence and seclusion from other societies. Only recently has any contact been made with the outside world. The High Seraphs are mighty Air mages and are also skilled in the path of Water. A few of them still remember and use the dark magic of the Harab Seraphs, but those that do are looked upon with suspicion and distrust and are only tolerated because of the necessity to know the enemy's weapons to better fight it. When becoming a prophet, a High Seraph will also receive improved magical skills in the form of two temporary Air gems at the start of every battle and bless his entire province with the supernatural protection of winter by starting to spread Cold scales."
#incscale 2
#tmpairgems 2
#userestricteditem 8059
#end

#selectmonster 202 -- MA Caelian Seraph
#name "Exiled Seraph"
#descr "The Seraphs are the ruling mages of Hararat. They settle the judicial affairs of the populace and make sure that the weather is good. They are skilled Air mages and know some Water magic. When becoming a prophet, an Exiled Seraph will also receive improved magical skills in the form of two temporary Air gems at the start of every battle and bless his entire province with the supernatural protection of winter by starting to spread Cold scales."
#end

#selectmonster 1283 -- Ice Crafter
#name "Ice Crafter"
#descr "The Ice Crafters are exiled Caelian craftsmen and mages of frozen Water. Improving upon the magical art of their ancestors in Caelum, they make the magical ice used in Hararat, which is now the best of the world. They build palaces and make armor and weapons as well as common tools. A few of them become Enchanters and forge other magical items as well. Ice Crafters use less magical gems when forging a magical item."
#fixforgebonus 2
#end

#selectmonster 2575 -- Airya Noble
#name "Airya Noble"
#descr "Since the exile from High Caelum and the kingdom of Hararat's foundation, the exiled Airya clan has gained independence and no longer has to share most functions with the other Caelian clans. To be of importance in the exiled society you have to be born Airya. To gain status and influence Airya nobles who are unable to join the Seraph order have joined the Iceclads. They rarely become as competent commanders as the Storm Generals, but they often have the time, wealth and backing to gain superior training and equipment."
#end

#selectmonster 684 -- Caelian Scout
#name "Caelian Scout"
#descr "The scouts of Caelum and Hararat are very efficient, being able to travel fast and deep into enemy lands. Most of them come from the Spire Horn Clan."
#end

#selectmonster 1286 -- Eagle King
#custommagic 32768 10
#end

#selectmonster 2560 -- Mairya Ahu
#name "Mairya Ahu"
#descr "The Mairya Ahu, or Mairya Lord, is a black-winged Raptorian commander. The Ahus of old were Yazata generals, but now the Mairyas have taken the name to remind their enemies of their proud ancestry. The Mairyas prefer stealth and plunder and the Ahus rarely lead large armies. They however are extremely proud of their ancestry and will do anything in their power to further improve the image and glory of the Raptors in the eyes of the Eagle Kings. As such, each Mairya Ahu is able to spend the month training a Mairya Warrior for free provided that the province where he is located has a temple that isn't already used for that purpose."
#templetrainer 2559 -- Mairya Warrior
#end

#selectmonster 214 -- Beast Trainer
#name "Beast Trainer"
#descr "Beast trainers are entrusted with the task of taming and training salamanders for battle. They are armed with iron prods, which they use to drive the salamanders. The beast trainers also have a mystical power that keeps animals from attacking them, making them very useful for dealing with wild beasts such as salamanders or scorpion beasts. Any Abysian cave province with at least one beast trainer and five salamanders or scorpion beasts will thus become a breeding ground for more of their kind to be used in war."
#gcost 40
#beastmaster 6
#command 30
#end

#selectmonster 118 -- War Master (Warlord Prophet)
#spr1 "Hellenika/WarMaster1.tga"
#spr2 "Hellenika/WarMaster2.tga"
#name "War Master"
#descr "The Warmaster is a Warlord who has achieved Prophet status and received from the God immense skills and limited immortality. The strength and ferocity of the Warmaster is feared by Abysians and humans alike. He is seemingly impossible to kill and always benefits from the effects of the Quicken Self spell in combat."
#clearweapons
#weapon 18
#weapon 18
#weapon 334
#berserk 5
#hp 23
#onebattlespell "Quicken Self"
#reinvigoration 5
#regeneration 10
#mr 18
#unsurr 3
#def 15
#att 15
#domimmortal
#end

#selectmonster 119 -- Warlord
#name "Warlord"
#descr "Warlords are the warrior chiefs of Abysian society and radiate the hellish heat characteristic of their race. They lead the Abysians in war and plunder. Warlords are chosen on the basis of superior strength and fighting prowess. They are large in size and strong enough to use twin axes in battle. Since the Warlords fight their way to prominence, they are respected and feared by their troops. When appointed as prophets they become very powerful and nearly infatiguable berserkers with the skills of seemingly perfect warriors and the blessing of dominion immortality."
#end

#selectmonster 1542 -- Warlock Apprentice
#rpcost 1
#raredomsummon 303
#end

#selectmonster 327 -- Anathemant/Warlock prophetshape
#name "Grand Anathemant"
#descr "The Anathemant caste was formed by the Anointed of Rhuax to perform the many ceremonies of the Flame Cult. These sacral mages administer the procession, ceremonies and sacrifices in the lesser temples of the kingdom. In the Temple of the All-Consuming Flame they serve the Anointed Ones at the High Sacrifices of the Inner Fire where Anathemant Salamanders are not allowed. Anathemant Dragons are Abysians and radiate the hellish heat characteristic of their race. They are such powerful mages of Fire that they start every battle with a temporary gem of that element. In addition, when appointed as prophets they receive for free the benefits of a Great Empowerment as well as five additional temporary Blood slaves."
#magicboost 53 1
#tmpfiregems 1
#batstartsum5 326
#armor 212
#raredomsummon 303
#custommagic 16512 50
#userestricteditem 8059
#end

#newmonster 6527
#copystats 1538 -- Warlock
#spr1 "Hellenika/CrownedWarlock1.tga"
#spr2 "Hellenika/CrownedWarlock2.tga"
#name "Warlock"
#descr "The Warlocks of Smouldercone are mages of a newly formed order. They experiment with Blood magic, the summoning and binding of otherworldly beings and the creation of new species. Their most recent experiments are the Demonbreds. Warlocks are Abysians and radiate the hellish heat characteristic of their race. In addition, when appointed as prophets they become Grand Anathemants and receive for free the benefits of a Great Empowerment as well as one free temporary Fire gem and five temporary Blood slaves at the start of every battle."
#magicboost 53 1
#armor 212
#prophetshape 327 -- Anathemant/Warlock prophetshape
#raredomsummon 303
#gcost 135
#custommagic 16512 50
#montag 4124 -- foreign savant
#userestricteditem 8059
#end

#selectmonster 1538 -- Warlock
#name "Warlock"
#descr "The Warlocks of Smouldercone are mages of a newly formed order. They experiment with Blood magic, the summoning and binding of otherworldly beings and the creation of new species. Their most recent experiments are the Demonbreds. Warlocks are Abysians and radiate the hellish heat characteristic of their race. In addition, when appointed as prophets they become Grand Anathemants and receive for free the benefits of a Great Empowerment as well as a free temporary Fire gem and five temporary Blood slaves at the start of every battle."
#prophetshape 327 -- Anathemant/Warlock prophetshape
#raredomsummon 303
#gcost 135
#custommagic 16512 50
#userestricteditem 8059
#end

#selectmonster 1698 -- Anathemant Salamander
#name "Anathemant Salamander"
#descr "The authority of the Abysian Warlords is limited to acts of war. In all other matters, Abysia is ruled by the Anathemants and the Anointed of Rhuax. Anathemant Salamanders are lowly priests of the Abysian Flame Cult. Anathemants excel in Fire magic and use fire not only to incinerate infidels, but also to feed the anger inherent in the hearts of all Abysian warriors and to shape armors, weapons and magical items from molten metal and sulphur. The Anathemants practice human sacrifice to empower their Master's Dominion by the magic inherent in human blood. Anathemant Salamanders are Abysians and radiate the hellish heat characteristic of their race. In addition, when appointed as prophets they become Grand Anathemants and receive for free the benefits of a Great Empowerment as well as a free temporary Fire gem and five temporary Blood slaves at the start of every battle."
#fixforgebonus 1
#resources 10
#end

#newmonster 7504 -- Abysia wall def com
#copystats 1698 -- Anathemant Salamander
#copyspr 1698
#undcommand 20
#end

#selectmonster 1699 -- Anathemant Dragon
#name "Anathemant Dragon"
#descr "The Anathemant caste was formed by the Anointed of Rhuax to perform the many ceremonies of the Flame Cult. These sacral mages administer the procession, ceremonies and sacrifices in the lesser temples of the kingdom. In the Temple of the All-Consuming Flame they serve the Anointed Ones at the High Sacrifices of the Inner Fire where Anathemant Salamanders are not allowed. Anathemant Dragons are Abysians and radiate the hellish heat characteristic of their race. They are such powerful mages of fire that they start every battle with a temporary gem of that element. In addition, when appointed as prophets they receive for free the benefits of a Great Empowerment and five additional temporary Blood slaves."
#tmpfiregems 1
#custommagic 4096 10
#prophetshape 327 -- Anathemant/Warlock prophetshape
#end

#selectmonster 629 -- Abysian Slayer
#name "Slayer"
#descr "The Slayer is an Abysian assassin. He can pass unseen through enemy territories and try to assassinate enemy leaders. In Abysia, murder is considered a sacred act and all Slayers can receive the All-Consuming Flame's blessing."
#holy
#patience 2
#gcost 70
#end

#newmonster 6528
#copystats 1537 -- Demonbred
#copyspr 1537
#name "Demonbred"
#descr "Deep in the Smouldercone, the Warlocks of Abysia experiment with their brethren to create superior beings. The Demonbreds are the most successful of these creatures. Part demon, part Abysian, they share the strengths and weaknesses of both. The Demonbreds are bound by their nature to serve their masters as slaves. Trained as priest-assassins, they deliver death to the enemies of their Warlock masters. Those among them that achieve glory through the holy act of murder will see their inner magical potential unlocked and be rewarded with the high status of a Slayer Sanguine. Demonbreds radiate the hellish heat characteristic of Abysians."
#patience 3
#holy
#magicskill 0 2
#magicskill 7 2
#magicskill 8 1
#magicboost 0 -4
#magicboost 7 -4
#xpshape 60
#undcommand 10
#rpcost 1
#gcost 110
#end

#newmonster 6529
#spr1 "Hellenika/Sanguine1.tga"
#spr2 "Hellenika/Sanguine2.tga"
#copystats 1537 -- Demonbred
#name "Slayer Sanguine"
#descr "Deep in the Smouldercone, the Warlocks of Abysia experiment with their brethren to create superior beings. The Demonbreds are the most successful of these creatures. Part demon, part Abysian, they share the strengths and weaknesses of both. The Demonbreds are bound by their nature to serve their masters as slaves, and among them the Slayer Sanguines representent the living pinnacle of Abysian blood magic and of the art of ceremonial assassination. Trained as priest-assassins, Anathemants and mages, they deliver death to the enemies of their Warlock masters through the holy act of murder and can achieve great status and influence. They are fanatically loyal to their masters and are the most trusted and able of the Abysian mages. Demonbreds radiate the hellish heat characteristic of Abysians. They are given horrible athames that drain the life force from living beings."
#nametype 101
#gcost 0
#prot 6
#mr 17
#magicskill 0 2
#magicskill 7 2
#magicskill 8 1
#douse 1
#patience 3
#holy
#cleararmor
#clearweapons
#weapon 101
#weapon 101
#combatcaster
#undcommand 10
#gcost 110
#end

#newmonster 7088
#copyspr 1536
#copystats 1536
#name "Child of Rhuax"
#descr "The first Abysians sprung from the Fires of Rhuax were large magmatic beings, barely resembling humans at all. Slowly these monstrosities developed into humanoids. With every generation, the Fires of Rhuax grew cooler in their bodies and the flaming Children of Rhuax became smoldering Abysians. Abysians of prominent heritage are larger and surrounded by flames. They are called Burning Ones and are sacred to the degenerates. Only Burning Ones can become high priests of the Flame Cult, the Anointed of Rhuax, and they are the undisputed rulers of the Abysians. The Anointed Ones have formed the Order of the Anathemants to administer ceremonies and burn offerings in the many temples of the kingdom. Their innate mastery of Fire magic is so extraordinary that they possibly are the greatest mages of that element in the world below the Kings of Fire themselves. As such, they cast spells twice as quickly as most other mages, start every battle with three temporary gems of Fire, and they are even capable of slowly crystalizing their might into permanent gems of power. Finally, should one of them be apointed as a prophet, he would ascend as a Child of Rhuax and gain immortality in friendly dominion and spread the fire of faith like an extra temple."
#magicskill 0 3
#magicboost 0 1
#gcost 0
#nowish
#reinvigoration 1
#gemprod 0 1
#tmpfiregems 3
#fastcast 100
#domimmortal
#spreaddom 1
#end

#selectmonster 1536 -- Anointed of Rhuax
#name "Anointed of Rhuax"
#descr "The first Abysians sprung from the Fires of Rhuax were large magmatic beings, barely resembling humans at all. Slowly these monstrosities developed into humanoids. With every generation, the Fires of Rhuax grew cooler in their bodies and the flaming Children of Rhuax became smoldering Abysians. Abysians of prominent heritage are larger and surrounded by flames. They are called Burning Ones and are sacred to the degenerates. Only Burning Ones can become high priests of the Flame Cult, the Anointed of Rhuax, and they are the undisputed rulers of the Abysians. The Anointed Ones have formed the Order of the Anathemants to administer ceremonies and burn offerings in the many temples of the kingdom. Their innate mastery of Fire magic is so extraordinary that they possibly are the greatest mages of that element in the world below the Kings of Fire themselves. As such, they cast spells twice as quickly as most other mages, start every battle with three temporary gems of Fire, and they are even capable of slowly crystalizing their might into permanent gems of power. Finally, should one of them be apointed as a prophet, he would ascend as a Child of Rhuax and gain immortality in friendly dominion and spread the fire of faith like an extra temple."
#magicskill 0 3
#magicboost 0 1
#gcost 555
#reinvigoration 1
#gemprod 0 1
#tmpfiregems 3
#fastcast 100
#prophetshape "Child of Rhuax"
#userestricteditem 8059
#end

#selectmonster 1284 -- Spire Horn Seraph
#rpcost 1
#researchbonus -3
#gcost 45
#end

#selectmonster 710 -- Carrion Lord
#name "Carrion Lord"
#descr "A Carrion Lord is a dead Pan reanimated and given unholy powers by a Panic Apostate, who forces the soul of the dead Pan to rejoin its own moss-covered carcass. The carcass is entwined with vines and roots that have a life of their own. The Carrion Lord is a powerful wielder of Nature magic, but is also given unholy powers over the dead. The Carrion Lord spreads his infection to his foes and will therefore raise as a new, temporary manikin anyone that he kills in battle, but in addition he also can create manikins by animating vines, roots and the bones of dead beasts with his dark magic and unholy powers."
#raiseonkill 100
#raiseshape 313 -- Manikin
#end

#selectmonster 711 -- Carrion Lady
#name "Carrion Lady"
#descr "A Carrion Lady is a dead dryad reanimated and given unholy powers by a Panic Apostate, who forces the soul of the dead dryad to rejoin its own moss-covered carcass. The carcass is entwined with vines and roots that have a life of their own. The Carrion Lady has retained some of her former skills in the use of Nature magic, but her priestly powers are corrupted. The Carrion Lady spreads her infection to her foes and will therefore raise as a new, temporary manikin anyone that she kills in battle, but in addition she has unholy powers over the dead and is able to create manikins by animating vines, roots and the bones of dead beasts."
#raiseonkill 100
#raiseshape 313 -- Manikin
#userestricteditem 8069
#end

#selectmonster 1188 -- Soothsayer
#gcost 40
#end

#selectmonster 296 -- Hydra Tamer
#stealthy 10
#gcost 25
#end

#selectmonster 1186 -- Warrior Sorceress
#custommagic 512 25
#userestricteditem 8069
#twiceborn 6675
#gcost 180
#end

#newmonster 7713
#copystats 1186
#copyspr 1186
#gcost 0
#end

#selectmonster 1181 -- Enarie
#userestricteditem 8069
#curseluckshield 1
#deathcurse
#gcost 145
#sorceryrange 1
#end

#selectmonster 1180 -- Spirit Guide
#name "Spirit Guide"
#descr "Spirit Guides take care of the dead. They raise burial mounds and make sure that the spirits pass to the afterlife with good grace. They are able to call ancestral spirits and use them in divination or curses. They are also tasked with crafting the funerary incenses, apotropaic totems and talismanic jewelry used by the Enarie. As such, they are particularly talented in item forging, however their vows prevent them from using magic paths other than Death even with empowerment."
#userestricteditem 8069
#curseluckshield 1
#deathcurse
#gcost 45
#fixforgebonus 3
#sorceryrange 1
#magicboost 53 -2
#magicboost 5 2
#end

#selectmonster 1175 -- Warrior Queen
#userestricteditem 8069
#twiceborn 6675
#batstartsum3 1172 -- Cataphracts
#gcost 165
#mor 18
#incprovdef 3
#end

#newmonster 7709
#copyspr 1175
#copystats 1175
#gcost 0
#end

#selectmonster 1169 -- Chieftain
#name "Chieftain"
#descr "A chieftain is the warchief of an unimportant tribe where women warriors have less power. They take their position by reputation and use flayed-man standards to show off their battle prowess. Most Sauromatians decorate themselves with tattoos. The most common motif is the horse, but the Androphags are known to prefer serpent motifs. Minor chieftains such as this one are commonly ordered to establish relays for horses and their riders in the vast plains and steppes that surround Sauromatia. Should they do so, they would become too busy with ruling such settlements to take a direct part in war, but they would permanently develop the province's resources and supplies in the form of a new local site until a fortress replaces it. The usual way to perform such a task is to ask the chieftain to search for magic sites in any dry land province that isn't equipped with a fortress or a relay yet."
#magicskill 7 1
#magicboost 7 -2
#noreqlab
#gcost 60
#rpcost 1
#end

#selectmonster 1174 -- Warrior priestess
#userestricteditem 8069
#twiceborn 6675
#gcost 110
#end

#selectmonster 1177 -- Manflayer
#batstartsum4 1176 -- Androphags
#clearweapons
#weapon 1122 -- Unholy Lance
#weapon 495 -- Poisonous Bite
#weapon 263 -- Net
#rpcost 2
#poisonres 5
#end

#selectmonster 1178 -- Witch King
#name "Witch King"
#descr "The Androphags are ruled by Witch Kings skilled in dark sorcery. The Witch Kings rule by strength and harsh justice. Those who oppose them are swiftly killed. They are formidable warriors and it is said that the blood of serpents flows in their veins. They even possess the power to cast the Transformation ritual. The Witch Kings have unnaturally long lives and few remember how they first rose to power. Most likely their strength and sorcery is a gift from supernatural forces. The Witch Kings introduced cannibalism and manflaying to the Sauromatian people. Feeding on one's fallen enemies is only practiced by the Androphags, but manflaying is a widely accepted practice in all of Sauromatia. The Witch Kings use flayed-skin standards and wear skullface masks. They are truly horrible to behold."
#clearweapons
#weapon 1122 -- Unholy Lance
#weapon 495 -- Poisonous Bite
#weapon 263 -- Net
#poisonres 10
#curseluckshield 1
#deathcurse
#gcost 390
#montag 4153 -- can cast Transformation
#sorceryrange 1
#end

#selectmonster 1173 -- Sauromatian Manflayer
#userestricteditem 8069
#rpcost 0
#end

#selectmonster 630 -- Black Harpy
#chaospower 1
#addupkeep -12
#userestricteditem 8069 -- for Thalamanth and Nabatem
#end

#selectmonster 1461 -- Troglodyte Lord
#name "Troglodyte Lord"
#descr "Troglodytes are huge, stupid subterranean beings of great strength. Troglodytes sometimes side with the Pale Ones of Agartha, who know the secret of how to manage their hordes. As such, should at least five troglodytes and a troglodyte lord be present in a cave province fully controlled by Agartha, several new troglodytes would be very likely to appear each month to join the horde for free."
#end

#selectmonster 2886 -- Grandmother
#addupkeep -300
#poisonskin 40
#supplybonus 40
#giftofwater 80
#heal
#userestricteditem 8069
#twiceborn 2886
#bonusspells 1
#end

#selectmonster 1401 -- Polypal mother
#addupkeep -100
#poisonskin 20
#supplybonus 20
#giftofwater 20
#heal
#userestricteditem 8069
#twiceborn 1401
#bonusspells 1
#older -1000
#end

#selectmonster 1518 -- Slave Mage
#name "Slave Mage"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. Even mages and priests are coerced into servitude, although this demands more thorough mind control. Slave mages live in shallow waters and can leave the seas. Therefore, they are used as stargazers and have some training in Astral magic."
#researchbonus -5
#gcost 175
#end

#selectmonster 1519 -- Slave Mage
#name "Slave Mage"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. Even mages and priests are coerced into servitude, although this demands more thorough mind control. Slave mages live in shallow waters and can leave the seas. Therefore, they are used as stargazers and have some training in Astral magic."
#researchbonus -5
#gcost 175
#end

#selectmonster 1527 -- Slave Priest
#name "Slave Priest"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. Even mages and priests are coerced into servitude, although this demands more thorough mind control."
#end

#selectmonster 1528 -- Slave Priest
#name "Slave Priest"
#descr "The success of Aulgyaththu and R'lyeh is largely due to their powers of mind control. By enslaving other peoples, they have built a slave-based society with few dissidents. Even mages and priests are coerced into servitude, although this demands more thorough mind control."
#end

#selectmonster 2885 -- Androdai
#gcost 145
#giftofwater 20
#end

#selectmonster 1521 -- Mind Lord
#gcost 420
#hp 104
#holy
#fear 5
#darkpower 3
#giftofwater 80
#poisonskin 20
#userestricteditem 8083
#poisonres 7
#heal
#end

#selectmonster 1520 -- Aboleth
#gcost 200
#holy
#darkpower 2
#giftofwater 60
#poisonskin 20
#userestricteditem 8083
#poisonres 7
#heal
#end

#selectmonster 2883 -- Abodai
#name "Abodai"
#descr "The Abodai is a Gibodai grown large and powerful. Gibodai are rare and Abodai even more so. Gibodai have the ability to gather life force from living beings. With age and maturity the Abodai can drain life from living creatures at a distance. Abodai develop magic skills that sets them apart from the Aboleths. Although all adult members of the elder race deserve sacred status in the eyes of the Aboleths, Abodai are able to communicate in the same strange language of psychic screams as the polypal mothers and they alone truly know their will."
#magicskill 8 2
#mindslime 5
#gcost 265
#darkpower 2
#giftofwater 20
#poisonskin 20
#userestricteditem 8083
#poisonres 7
#heal
#end

#selectmonster 3451
--#spr1 "Hellenika/WightAboleth1.tga"
--#spr2 "Hellenika/WightAboleth2.tga"
#name "Necrodai"
#descr "A Necrodai is the corpse of an Aboleth strong enough to avoid death itself. Although it lost its fragile tentacles to putrefaction, its dried and leathery body is stronger than it was in life. The Necrodai is constantly surrounded by an icy wind. While unlike living Aboleths it no longer risks entering this strange coma called the Long Dreaming when stranded on dry land for too long, it moves very slowly and will surely degrade with time when staying far from the sea, even risking destruction after a few months."
#hp 216
#holy
#darkpower 3
#giftofwater 80
#fear 5
#poisonskin 20
#userestricteditem 8083
#landdamage 15
#heal
#end

#selectmonster 3452
--#spr1 "Hellenika/WightAboleth1.tga"
--#spr2 "Hellenika/WightAboleth2.tga"
#name "Necrodai"
#descr "A Necrodai is the corpse of an Aboleth strong enough to avoid death itself. Although it lost its fragile tentacles to putrefaction, its dried and leathery body is stronger than it was in life. The Necrodai is constantly surrounded by an icy wind. While unlike living Aboleths it no longer risks entering this strange coma called the Long Dreaming when stranded on dry land for too long, it moves very slowly and will surely degrade with time when staying far from the sea, even risking destruction after a few months."
#hp 93
#holy
#darkpower 2
#giftofwater 20
#poisonskin 20
#userestricteditem 8083
#landdamage 15
#heal
#end

#newmonster 7550 -- New Ermor
#copystats 366 -- Eternal Knight
#spr1 "Hellenika/EternalKnight1b.tga"
#spr2 "Hellenika/EternalKnight2b.tga"
#name "Eternal Knight Commander"
#descr "With the proclamation of the Decree of Sanctity, the Eternal Knights swore to serve the Holy Father of Eldregate and were granted immortality by the God. Should one day Ermor Fall and their masters be corrupted, they would fight against even them and defend the Holy Sepulchre at all costs. The Eternal Knights wield great, flaming swords that shred the flesh of undead beings. Unlike the holy warriors they command, the leaders of the Order of the Holy Sepulchre are truly immortal. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#immortal
#gcost 300
#nametype 106
#rpcost 3
#combatcaster
#inspirational 1
#startage 40
#hp 16
#mr 16
#str 13
#att 13
#def 13
#end

#newmonster 7089
#copystats 366 -- Eternal Knight
#spr1 "Hellenika/EternalKnight1b.tga"
#spr2 "Hellenika/EternalKnight2b.tga"
#name "Eternal Knight Commander"
#descr "With the proclamation of the Decree of Sanctity, the Eternal Knights swore to serve the Holy Father of Eldregate and were granted immortality by the God. Should one day Ermor Fall and their masters be corrupted, they would fight against even them and defend the Holy Sepulchre at all costs. The Eternal Knights wield great, flaming swords that shred the flesh of undead beings. Unlike the holy warriors they command, the leaders of the Order of the Holy Sepulchre are truly immortal. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#immortal
#gcost 300
#nametype 106
#rpcost 3
#combatcaster
#inspirational 1
#startage 40
#hp 16
#mr 16
#str 13
#att 13
#def 13
#end

#newmonster 7551 -- New Ermor
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/PaterEcclesiae1a.tga"
#spr2 "Hellenika/PaterEcclesiae2a.tga"
#name "Pater Ecclesiae"
#descr "The Patres Ecclesiae are holy men of science that helped establishing the theoretical foundations of the church of the Sacred Shroud after the proclamation of the Decree of Sanctity and converted innumerable people through their words. They are invested by the God and their arcane studies with extremely powerful magical skills, which they use to make rain down the divine wrath on the enemies of the faith. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#mr 16
#mor 14
#weapon 7
#rpcost 4
#magicskill 8 3
#magicskill 0 3
#magicskill 1 2
#magicskill 4 1
#custommagic 35200 100
#custommagic 35200 25
#custommagic 35200 10
#nametype 106
#researchbonus 8
#gcost 445
#end

#newmonster 7090
#copystats 1113 -- Acolyte (EA Ermor)
#spr1 "Hellenika/PaterEcclesiae1a.tga"
#spr2 "Hellenika/PaterEcclesiae2a.tga"
#name "Pater Ecclesiae"
#descr "The Patres Ecclesiae are holy men of science that helped establishing the theoretical foundations of the church of the Sacred Shroud after the proclamation of the Decree of Sanctity and converted innumerable people through their words. They are invested by the God and their arcane studies with extremely powerful magical skills, which they use to make rain down the divine wrath on the enemies of the faith. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#mr 16
#mor 14
#weapon 7
#rpcost 4
#magicskill 8 3
#magicskill 0 3
#magicskill 1 2
#magicskill 4 1
#custommagic 35200 100
#custommagic 35200 25
#custommagic 35200 10
#nametype 106
#researchbonus 8
#montag 4124
#gcost 445
#end

#selectmonster 2289 -- Rhino Clan Commander
#woundfend 1
#prot 1
#att 12
#rcost 0
#end

#selectmonster 2290 -- Lion Clan Commander
#hp 16
#str 13
#mor 17
#mr 13
#enc 2
#att 13
#end

#selectmonster 2295 -- Spider Clan Sorcerer
#name "Spider Clan Sorcerer"
#descr "The true rulers of the Spider Clan are not the Lion Kings. In the depths of their sacred forest, sorcerers of great powers gather to plot the eventual downfall of the Lion Kings. These dark mystics know many magical secrets and are even able to cast the Transformation ritual."
#gcost 175
#custommagic 5120 100
#montag 4153 -- can cast Transformation
#end

#newmonster 6637
#spr1 "Hellenika/LionessSpirit1.tga"
#spr2 "Hellenika/LionessSpirit2.tga"
#name "Lioness Spirit"
#descr "The Lioness Spirit is a sacred guardian animal worshipped by the people of Machaka as a reincarnated Lion Queen of great power and nobility. She is an extremely intelligent and powerful magic being and the spirits of taboo protect her against harm. Although she is unable to perform priestly rituals, she spreads the Awakening God's dominion like a prophet and will remain immortal for as long as she remains in his sacred sphere of influence."
#female
#hp 75
#size 4
#prot 18
#mr 18
#mor 30
#str 23
#att 14
#def 12
#prec 10
#ap 24
#mapmove 20
#enc 1
#maxage 200
#darkvision 50
#fear 5
#animal
#forestsurvival
#magicbeing
#gcost 0
#goodleader
#inspirational 1
#quadruped
#itemslots 274560
#magicboost 6 1
#magicboost 8 -10
#domimmortal
#spreaddom 1
#weapon 20
#weapon 29
#weapon 29
#curseluckshield 1
#combatcaster
#animalawe 3
#spiritsight
#nametype 125
#end

#selectmonster 2297 -- Lion Queen
#name "Lion Queen"
#descr "The Lion Queens are the consorts of the Lion Kings. Their temporal and religious power are slightly less then their consorts', but their magical powers are considerable, being semi-divine and blessed from birth. As such, they are even capable of casting the Transformation ritual. Recently there was a schism in the royal family. A conspiracy was discovered by Spider's servants and a whole branch of the royal family were executed. A few young queens escaped the massacre and fled to the Phoenix City where they took over the local cult. Now the royalty of Machaka are intent on destroying Berytos and the rebel queens."
#gcost 320
#magicskill 8 2
#magicskill 0 4
#hp 21
#str 15
#att 11
#def 11
#mor 15
#rcost -3
#twiceborn 6637
#userestricteditem 8069
#montag 4153 -- can cast Transformation
#end

#newmonster 6638
#spr1 "Hellenika/LionSpirit1.tga"
#spr2 "Hellenika/LionSpirit2.tga"
#name "Lion Spirit"
#descr "The Lion Spirit is a sacred guardian animal worshipped by the people of Machaka as a reincarnated Lion King of great power and nobility. He is an extremely intelligent and powerful magic being and the spirits of taboo protect him against harm. Although he is unable to perform priestly rituals, he spreads the Awakening God's dominion like a prophet and will remain immortal for as long as he remains in his sacred sphere of influence."
#hp 80
#size 4
#prot 18
#mr 18
#mor 30
#str 23
#att 14
#def 12
#prec 10
#ap 22
#mapmove 20
#enc 1
#maxage 200
#darkvision 50
#fear 5
#animal
#forestsurvival
#magicbeing
#gcost 0
#goodleader
#inspirational 1
#quadruped
#itemslots 274560
#magicboost 0 1
#magicboost 8 -10
#domimmortal
#spreaddom 1
#weapon 20
#weapon 29
#weapon 29
#curseluckshield 1
#combatcaster
#animalawe 3
#spiritsight
#nametype 126
#end

#selectmonster 2296 -- Lion King
#name "Lion King"
#descr "Machaka is ruled by a royal family of Great Men. When the Lion Clan found Great Mababwe, they found the Colossi. Soon the Colossi adopted the Lion Clan Machakans and made them their servants. With the guidance of the Colossi the Lion Clan became rulers over the other Machakan clans and Great Mababwe became the royal capital. The first Colossi king brought order and civilization to the newly formed kingdom. When he died all his sons were named kings, and all their consorts queens. The Lion Kings are the highest priests of the kingdom and mages of remarkable power, even able to cast the Transformation ritual. They tend to avoid dull work, such as research, but make great warleaders. Most kings and queens are satisfied with their position, but recently there was a schism in the royal family. Spider's agents discovered a conspiracy that was about to destroy the kingdom."
#gcost 380
#magicskill 8 3
#magicskill 6 4
#hp 23
#str 16
#att 13
#def 11
#mor 16
#rcost -3
#twiceborn 6638
#montag 4153 -- can cast Transformation
#cleararmor
#armor 802
#armor 148
#end

#selectmonster 2291 -- Voice of Lion
#templetrainer 2306
#inquisitor
#gcost 80
#armor 44
#armor 120
#end

#selectmonster 2310 -- Voice of Spider
#incscale 4
#bringeroffortune -5
#end

#newmonster 7552 -- New Ermor
#copystats 1655 -- Censor
#copyspr 1655
#name "Censor"
#descr "The Censors were judges in the old Empire. With the proclamation of the Decree of Thaumaturgy and the emergence of the Death Cult, their responsibilities increased and they have been entrusted with the command of the dead and the Lictorian legions, which they also have the high duty of training. With the silent legions under their command, they are feared by both internal and external enemies of the state. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#gcost 120
#batstartsum2 1654
#templetrainer 1654
#fear 10
#end

#selectmonster 1655 -- Censor
#name "Censor"
#descr "The Censors were judges in the old Empire. With the proclamation of the Decree of Thaumaturgy and the emergence of the Death Cult, their responsibilities increased and they have been entrusted with the command of the dead and the Lictorian legions, which they also have the high duty of training. With the silent legions under their command, they are feared by both internal and external enemies of the state. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#gcost 120
#batstartsum2 1654
#templetrainer 1654
#fear 10
#end

#newmonster 7524
#copystats 1111
#copyspr 1111
#name "Prophet of the Sacred Shroud"
#descr "The Arch Bishops of Eldregate are the highest ranking priests of the Awakening God. They wear holy replicas of the Sacred Shroud of the Prophet. This sacred piece of cloth gives them unsurpassed healing abilities. They have all but replaced the old Pontifices as religious magistrates of the Empire."
#magicskill 5 1
#magicboost 5 -2
#montag 4109
#end

#newmonster 7523 -- New Ermor
#copystats 1111 -- Arch Bishop
#copyspr 1111
#gcost 170
#prophetshape 5524
#magicskill 5 1
#magicboost 5 -2
#montag 4109
#end

#newmonster 7091
#copystats 1111
#copyspr 1111
#name "Prophet of the Sacred Shroud"
#descr "The Arch Bishops of Eldregate are the highest ranking priests of the Awakening God. They wear holy replicas of the Sacred Shroud of the Prophet. This sacred piece of cloth gives them unsurpassed healing abilities. They have all but replaced the old Pontifices as religious magistrates of the Empire."
#magicskill 5 1
#magicboost 5 -2
#montag 4119
#end

#selectmonster 1111 -- Arch Bishop of the Sacred Shroud
#gcost 170
#prophetshape 5091
#magicskill 5 1
#magicboost 5 -2
#montag 4119
#end

#selectmonster 1112 -- Bishop of the Sacred Shroud
#gcost 135
#magicskill 5 1
#magicboost 5 -2
#end

#newmonster 7518 -- New Ermor
#copystats 670 -- Grand Thaumaturg
#copyspr 670
#name "Grand Thaumaturg"
#descr "The Thaumaturgs were a secretive order of mage-priests that acted from the shadows in the great empire of Ermor. They were skilled in the arcane lore of the Spheres, but were influenced by the darkness permeating the empire in its last days before the Decree of Thaumaturgy was proclaimed. With their lore of the stars and the laws of the Underworld they predicted a great cataclysm, and advised the emperor to exile the Augurs far from Eldregate. When their doctrine was recognized by the God as a faithful reflection of his own and blessed by the Church of the Sacred Shroud, the Decree of Thaumaturgy was proclaimed and the Gates of Death prepared by the Augur Elders in secret were found and sealed. But the danger was not completely averted yet, as the Gates still threatened to be opened should their guardians' vigilance ever falter. Thus, they introduced a Death Cult that would make the dead serve the living. Now, their word justifies the Tribunal of Shadows and the dictature of Censors in their iron rule. Apart from their priestly powers, the Thaumaturgs have skills in both Death and Astral magic. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#undcommand 45
#summon2 -4117
#raredomsummon 7611
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#custommagic 6912 100
#gcost 300
#end

#selectmonster 670 -- Grand Thaumaturg
#name "Grand Thaumaturg"
#descr "The Thaumaturgs were a secretive order of mage-priests that acted from the shadows in the great empire of Ermor. They were skilled in the arcane lore of the Spheres, but were influenced by the darkness permeating the empire in its last days before the Decree of Thaumaturgy was proclaimed. With their lore of the stars and the laws of the Underworld they predicted a great cataclysm, and advised the emperor to exile the Augurs far from Eldregate. When their doctrine was recognized by the God as a faithful reflection of his own and blessed by the Church of the Sacred Shroud, the Decree of Thaumaturgy was proclaimed and the Gates of Death prepared by the Augur Elders in secret were found and sealed. But the danger was not completely averted yet, as the Gates still threatened to be opened should their guardians' vigilance ever falter. Thus, they introduced a Death Cult that would make the dead serve the living. Now, their word justifies the Tribunal of Shadows and the dictature of Censors in their iron rule. Apart from their priestly powers, the Thaumaturgs have skills in both Death and Astral magic. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#undcommand 45
#summon2 -4117
#raredomsummon 7611
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#montag 4124
#custommagic 6912 100
#gcost 300
#end

#newmonster 7519 -- New Ermor
#copystats 669 -- Thaumaturg
#copyspr 669
#name "Thaumaturg"
#descr "The Thaumaturgs were a secretive order of mage-priests that acted from the shadows in the great empire of Ermor. They were skilled in the arcane lore of the Spheres, but were influenced by the darkness permeating the empire in its last days before the Decree of Thaumaturgy was proclaimed. With their lore of the stars and the laws of the Underworld they predicted a great cataclysm, and advised the emperor to exile the Augurs far from Eldregate. When their doctrine was recognized by the God as a faithful reflection of his own and blessed by the Church of the Sacred Shroud, the Decree of Thaumaturgy was proclaimed and the Gates of Death prepared by the Augur Elders in secret were found and sealed. But the danger was not completely averted yet, as the Gates still threatened to be opened should their guardians' vigilance ever falter. Thus, they introduced a Death Cult that would make the dead serve the living. Now, their word justifies the Tribunal of Shadows and the dictature of Censors in their iron rule. Apart from their priestly powers, the Thaumaturgs have skills in both Death and Astral magic. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#gcost 165
#undcommand 30
#summon1 -4117
#raredomsummon 7611
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#custommagic 6144 100
#custommagic 6144 10
#end

#selectmonster 669 -- Thaumaturg
#name "Thaumaturg"
#descr "The Thaumaturgs were a secretive order of mage-priests that acted from the shadows in the great empire of Ermor. They were skilled in the arcane lore of the Spheres, but were influenced by the darkness permeating the empire in its last days before the Decree of Thaumaturgy was proclaimed. With their lore of the stars and the laws of the Underworld they predicted a great cataclysm, and advised the emperor to exile the Augurs far from Eldregate. When their doctrine was recognized by the God as a faithful reflection of his own and blessed by the Church of the Sacred Shroud, the Decree of Thaumaturgy was proclaimed and the Gates of Death prepared by the Augur Elders in secret were found and sealed. But the danger was not completely averted yet, as the Gates still threatened to be opened should their guardians' vigilance ever falter. Thus, they introduced a Death Cult that would make the dead serve the living. Now, their word justifies the Tribunal of Shadows and the dictature of Censors in their iron rule. Apart from their priestly powers, the Thaumaturgs have skills in both Death and Astral magic. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#gcost 165
#undcommand 30
#summon1 -4117
#raredomsummon 7611
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#custommagic 6144 100
#custommagic 6144 10
#end

#selectmonster 1110 -- Pontifex
#gcost 165
#magicskill 0 2
#magicskill 5 1
#magicboost 5 -2
#end

#selectmonster 1109 -- Flamen
#gcost 135
#magicskill 5 1
#magicboost 5 -2
#end

#selectmonster 256 -- Acolyte of Eldregate
#name "Acolyte of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were once responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold."
#magicskill 5 1
#undcommand 15
#magicboost 53 -2
#magicboost 5 2
#magicboost 8 2
#masterrit -1
#mastersmith -1
#researchbonus -3
#end

#selectmonster 257 -- Bishop of Eldregate
#name "Bishop of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were once responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold. Bishops of Eldregate will automatically cast Unholy Power at the start of every battle. With this prayer, they can grant extra speed and attack skill to a small number of undead beings."
#undcommand 30
#magicboost 0 -2
#magicskill 5 1
#mastersmith -1
#researchbonus -3
#end

#newmonster 7526 -- New Ermor
#copystats 258 -- Arch Bishop of Eldregate
#copyspr 258
#name "Prophet of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold. In addition to being able to reanimate the dead, a Prophet of Eldregate can spend the month giving false life to two unholy Lictors."
#undcommand 60
#magicskill 5 1
#makemonsters2 259 -- Undead Lictor
#montag 4109
#mastersmith -1
#researchbonus -3
#end

#newmonster 7525 -- New Ermor
#copystats 258 -- Arch Bishop of Eldregate
#copyspr 258
#name "Arch Bishop of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold. In addition to being able to reanimate the dead, an Arch Bishop of Eldregate can spend the month giving false life to one unholy Lictor."
#makemonsters1 259 -- Undead Lictor
#undcommand 45
#magicskill 5 1
#prophetshape 
#montag 4109
#mastersmith -1
#researchbonus -3
#end

#newmonster 7092
#copystats 258 -- Arch Bishop of Eldregate
#copyspr 258
#name "Prophet of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold. In addition to being able to reanimate the dead, a Prophet of Eldregate can spend the month giving false life to two unholy Lictors."
#undcommand 60
#magicskill 5 1
#makemonsters2 259 -- Undead Lictor
#montag 4119
#mastersmith -1
#researchbonus -3
#end

#selectmonster 258 -- Arch Bishop of Eldregate
#name "Arch Bishop of Eldregate"
#descr "Before the proclamation of the Decree of Extinction, the priests of Eldregate were responsible for performing the ceremonies of the Holy City of Eldregate. When the Augur Elders succumbed to the dark lure of Death magic and became the Dusk Elders, the Arch Bishops sat idly by as they watched the Empire fall. As a result, they were more harshly cursed than the rest of the population and now perform the unholy rites of reanimation. The priests of Eldregate are surrounded by a wind of numbing cold. In addition to being able to reanimate the dead, an Arch Bishop of Eldregate can spend the month giving false life to one unholy Lictor."
#makemonsters1 259 -- Undead Lictor
#undcommand 45
#magicskill 5 1
#prophetshape 5092
#montag 4119
#mastersmith -1
#researchbonus -3
#end

#selectmonster 1114 -- Augur
#gcost 65
#older -10
#magicskill 5 2
#magicboost 5 -4
#end

#selectmonster 254 -- Spectator
#name "Spectator"
#descr "The mages of fallen Ermor performed rituals that corrupted and destroyed the Empire. These mages are now summoned from the dead to wage war against the living and they are now known as Spectators or Dusk Elders. The mages do not possess solid bodies, but their spirits are connected to the Netherworld and their powers of Death magic are greater than ever before. The mere touch of these mages will drain the life energy of the target and replenish the power of the mage. They are ethereal and very difficult to harm without magic weapons. Spectators only have interest in Death magic and they are completely unable to gain skills in the other paths - even as priests. However, now able to contemplate the mysteries of the afterlife, they are effective researchers even without magic skills."
#magicboost 0 -4
#magicboost 1 -4
#magicboost 2 -4
#magicboost 3 -4
#magicboost 4 -4
#magicboost 6 -4
#magicboost 7 -4
#magicboost 8 -4
#notsacred
#fixedresearch 9
#researchbonus -2
#end

#selectmonster 253 -- Dusk Elder
#magicskill 0 2
#magicskill 5 2
#magicboost 0 -1
#magicboost 5 1
#researchbonus 16
#end

#newmonster 7520 -- New Ermor
#copystats 2244 -- Scelerian Cultist
#copyspr 2244
#name "Cultist"
#descr "A worshipper of Death, the Cultist is able to command the walking dead and has limited priestly powers. In spite of their minor necromantic practices, they can be trained quickly in great numbers; however, they are poor researchers even in magic scales. Controlling an Arch Bishop of the Sacred Shroud or an Arch Bishop of Eldregate is necessary to recruit them."
#magicimmune
#rpcost 0
#undcommand 15
#magicskill 5 1
#masterrit -1
#mastersmith -1
#researchbonus -3
#gcost 65
#noreqlab
#ownsmonrec -4109
#domsummon20 -4117
#end

#selectmonster 2244 -- Scelerian Cultist
#name "Cultist"
#descr "A worshipper of Death, the Cultist is able to command the walking dead and has limited priestly powers. In spite of their minor necromantic practices, they can be trained quickly in great numbers; however, they are poor researchers even in magic scales. Controlling an Arch Bishop of the Sacred Shroud or an Arch Bishop of Eldregate is necessary to recruit them."
#magicimmune
#rpcost 0
#undcommand 15
#magicskill 5 1
#masterrit -1
#mastersmith -1
#researchbonus -3
#gcost 65
#noreqlab
#ownsmonrec -4119
#domsummon20 -4117
#end

#newmonster 7521 -- New Ermor
#copystats 41 -- Arch Theurg
#copyspr 41
#name "Arch Theurg"
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#gcost 390
#custommagic 2944 25
#end

#selectmonster 61 -- Arch Theurg
#name "Arch Theurg"
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#montag 4124
#gcost 390
#custommagic 2944 25
#end

#newmonster 7522 -- New Ermor
#copystats 42 -- Theurg
#copyspr 42
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#end

#selectmonster 62 -- Theurg
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#end

#newmonster 7527 -- New Ermor
#copystats 43 -- Theurg Acolyte
#copyspr 43
#name "Theurg Acolyte"
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#end

#selectmonster 63 -- Theurg Acolyte
#name "Theurg Acolyte"
#descr "Spokesmen of the New Faith of Ermor and magicians of the Spheres, Theurgs are among the most powerful mages in the world. The Arch Theurg possesses vast powers that can be further increased through communion with lesser Theurgs. The Theurgs are devout priests as well as magicians, able to divine both the future and their Master's wishes. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#end

#newmonster 7528 -- New Ermor
#copystats 52 -- Battle Deacon
#copyspr 52
#name "Battle Deacon"
#descr "Equipped with mace and plate cuirass, the Battle Deacons carry out the will of the New God on the battlefield. In addition to training them, which they do in place of a temple, they often accompany and bless the Battle Vestals, but their priestly authority is somewhat limited. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4109 -- New Ermorian Arch Bishops
#end

#selectmonster 72 -- Battle Deacon
#name "Battle Deacon"
#descr "Equipped with mace and plate cuirass, the Battle Deacons carry out the will of the New God on the battlefield. In addition to training them, which they do in place of a temple, they often accompany and bless the Battle Vestals, but their priestly authority is somewhat limited. Controlling an Arch Bishop of the Sacred Shroud is necessary to recruit them."
#ownsmonrec -4119 -- Old Ermorian Arch Bishops
#end

#selectmonster 2834 -- Hekateride
#name "Hekateride"
#descr "The Hekaterides are female Daktyloi, semi-divine beings of the sunken kingdom of Therodos. Unlike their male counterparts, they are not of dwarven stature, but tall, slender and beautiful. They are the inventors of dance and gave their skills and blessings to the human inhabitants of Therodos. During the Telkhine reign the Hekaterides gave birth to a race of goat-like half-men. The Daktyloi disclaimed paternity of the satyrs, denounced their sisters and secluded themselves in caves and hidden forges. The satyrs were expelled from the realm and hid in faraway forests where they eventually were found and adopted by the Panii. The male Daktyloi were always reclusive and concerned themselves more with their crafts than with humans. Their Hekateride sisters on the other hand were very much involved with the human population and became queens and priestesses under the Telkhine God-kings. With their sacred dances they brought joy and fertility to the lands. Now the Therodian ghosts follow them in death as they once did in life, dancing to the clamor of cymbals. With their kind words, music and dance they relieve them from the suffering of the Telkhine curse, thus attracting its survivors, healing the sick among them and restoring fertility to the land; as such, even though it will never be enough to return Therodos to its former glory, population will automatically increase by roughly a hundred per month in all provinces where at least one Hekateride is present, provided that these provinces are under friendly dominion. In addition, Hekaterides are able to cast the Transformation ritual."
#rpcost 3
#userestricteditem 8069
#twiceborn 2834
#montag 4153 -- can cast Transformation
#end

#selectmonster 2836 -- Daktyl
#rpcost 3
#resources 10
#str 15
#end

#selectmonster 2835 -- Kabeiros
#gcost 95
#end

#selectmonster 2833 -- Melia
#gcost 145
#userestricteditem 8069
#twiceborn 2833
#end

#selectmonster 2845 -- Ephor (Therodos)
#raredomsummon 2843
#domsummon20 -4149
#end

#selectmonster 3113 -- Kryptes
#holy
#hp 42
#patrolbonus 20
#woundfend 1
#haltheretic 2
#end

#newmonster 6644
#copystats 3113 -- Kryptes
#copyspr 3113
#hp 42
#mor 18
#att 13
#def 13
#enc 2
#illusion
#haltheretic 3
#patience 3
#spy
#end

#selectmonster 3111 -- Lochos (Mekone)
#name "Lochos"
#descr "The Lochoi are Gigante commanders of the Mekonean armies. They are taken from the ranks of the hoplites and are skilled warriors and tacticians. They command the Gigantes as well as helotes and free humans. Experienced Lochos are often elected into the gerousia when they retire, but under rare circumstances those of exceptional skills might instead be promoted to the high rank of Polemarch."
#haltheretic 1
#gcost 90
#hp 48
#magicskill 3 2
#magicskill 0 2
#magicboost 3 -3
#magicboost 0 -3
#older -100
#xpshape 100
#noreqlab
#rpcost 1
#maxage 250
#startage 100
#addrandomage 20
#end

#selectmonster 3112 -- Polemarch (Mekone)
#awe 2
#gcost 295
#hp 52
#end

#selectmonster 3114 -- Geronte (Mekone)
#name "Geronte"
#descr "The Gerontes, elders, are members of the ruling council of a city. The gerousia is composed of elder Gigantes who once were in the military and any Lochos of exceptional skill is expected to one day be elected into the gerousia. The gerousia also perform the ceremonies and offerings to the god-slayer. As priests of the god-slayer they refute false gods. Through persuasion or coercion they have become good at convincing humanity of their follies. The Gerontes are skilled leaders, but tradition dictates that they only lead a limited number of troops. Being political administrators used to officiating in unrighteous lands, Gerontes can be recruited even without temples, unlike most other priests."
#str 20
#hp 50
#clearspec
#clearmagic
#maxage 250
#startage 0
#older 100
#magicskill 8 1
#custommagic 1152 90
#gcost 110
#inquisitor
#formationfighter 2
#taskmaster 1
#haltheretic 1
#noreqtemple
#command -50
#end

#selectmonster 3115 -- Ephor (Mekone)
#str 20
#hp 50
#haltheretic 1
#gcost 180
#startage 0
#older 90
#end

#selectmonster 3116 -- Archon (Mekone)
#hp 50
#haltheretic 2
#gcost 305
#itemslots 16777216 -- normal + 4 misc
#fastcast 100
#end

#selectmonster 3117 -- Basileus (Mekone)
#hp 50
#haltheretic 3
#gcost 350
#itemslots 16777216 -- normal + 4 misc
#fastcast 100
#end

#selectmonster 1366 -- Lizard Heir
#str 14
#att 15
#def 16
#mor 15
#incprovdef 4
#taxcollector
#clearweapons
#weapon 19
#weapon 1149
#end

#selectmonster 170 -- C'tissian Shaman
#name "Shaman"
#descr "The shamans are the rulers of the barbarian predator lizards and have knowledge in the paths of Nature and Astral magic, a mastery that increases when they are appointed as prophets. They have partial resistance to poison."
#userestricteditem 8059
#end

#selectmonster 321 -- C'tissian Shaman prophetshape
#userestricteditem 8059
#magicboost 4 1
#magicboost 6 1
#end

#selectmonster 161 -- EA Sauromancer
#name "Sauromancer"
#descr "The Order of the Sauromancers is a secretive one and only after passing three rites of initiation is one considered a full member of the Order. In the last initiation, the Rite of Three Gates, a Reborn enters the Underworld and immerses himself in the black waters of that dark Realm. If he returns, he is given a crown and full authority as a Sauromancer. The Sauromancers discovered the secrets of dark magic in ancient times and the magic of Death was prudently practiced during these times. However, when Ermor stole the secrets of life and death and perverted them, the Sauromancers knew that swift destruction would soon follow. They decided to aid the priests of C'tis with advice and prepare the kingdom for the coming catastrophe. Sauromancers are very powerful Death mages with some skill in Nature magic as well as other magic paths. In fact, they are even capable of casting the Transformation ritual. The immersion in the black waters of the Underworld gives them great resistance to poisons and almost impervious hides. They also are skilled marshmasters and might tame some exotic beasts if left in swamp provinces for long enough."
#custommagic 8704 50
#montag 4153 -- can cast Transformation
#userestricteditem 8059
#end

#selectmonster 1119 -- Markata Scout
#name "Markata Scout"
#descr "Bandar Log is a very hierarchical society, and so is the nascent simian culture of Kailasa. Markatas are the smallest of the monkey people and their intellect is barely above that of simple beasts. Markatas are small, noisy and annoying, especially when met in large numbers. If alone, they can be used as scouts, but when in greater numbers, they quickly become bored and start to make noise and play with each other. They are generally despised by the larger monkeys and apes. They are sometimes given small bows. This pleases them no end, but they are still not very useful soldiers."
#end

#selectmonster 1127 -- Atavi Chieftain
#name "Atavi Chieftain"
#descr "The Vanara are the most common of the four castes of Bandar Log and Kailasa. They are about as big as humans. Many Vanaras live in tribal societies in the dense forests of these realms. The warriors of the forest tribes are called Atavi. They use bows and maces, but do not wear armor. All Atavi are stealthy."
#end

#selectmonster 1329 -- Yaksha
#name "Yaksha"
#descr "Yakshas are semi-divine beings of the sacred Mount Kailasa that once upon a time also educated the apes of the far away lands of Bandar Log. Their time has passed and the most powerful of them have left this world and entered the Celestial Spheres. The few that still linger on are the ones infatuated with the beauty of the wild and the riches of this world. They have bred the monkey people and led them into servitude. Yakshas are gifted with Celestial Splendor that strikes lowly beings with awe. They are sacred to the monkey people. Yakshas are spirits of Nature and are powerful Earth mages. They even hold the power of casting the Transformation ritual."
#montag 4153 -- can cast Transformation
#end

#selectmonster 1330 -- Yakshini
#name "Yakshini"
#descr "Yakshinis are female Yakshas, semi-divine beings of the sacred Mount Kailasa that once upon a time also educated the apes of the far away lands of Bandar Log. Their time has passed and the most powerful of them have left this world and entered the celestial spheres. The few that still linger on are the ones infatuated with the beauty of the wild and the riches of this world. They have bred the monkey people and led them into servitude. Yakshinis are gifted with Celestial Splendor that strikes lowly beings with awe. They are sacred to the monkey people. Yakshinis often inhabit springs, lakes and rivers and are powerful Water mages. They even hold the power of casting the Transformation ritual."
#userestricteditem 8069
#twiceborn 1330
#montag 4153 -- can cast Transformation
#end

#selectmonster 1734 -- Yogini
#name "Yogini"
#descr "While the apes of Bandar Log and Kailasa have been exempt from the practice of magic, the demons of Lanka have found a replacement for the enlightened White Ones servants of the Devatas. A Yogini is a Bandar sorceress trained in the magic arts by a Kala-Mukha or Rakshasi. Yoginis rarely become powerful mages, but are quite common in the kingdom."
#userestricteditem 8069 -- for Thalamanth and Nabatem
#end

#selectmonster 3226
#name "Laestrygonian Tyrant"
#descr "The Laestrygonians were once proud generals and warriors of Phlegra. Following the Telkhines in their great rebellion, they waged war against the gods of men, but failed and were punished for their hubris by a celestial decree. The Gigantes were transformed into Laestrygonian monstrosities with serpents for legs and viper tresses for hair. They are cursed with a foul temper and an insatiable hunger for the flesh of men. The mightiest of them all were imprisoned underneath mountains to prevent them from destroying the world. But their might and fury would not be contained, and the mountains started to spew fire and molten rock. From the burning mountains of Porphyrion and Phlegra, Laestrygonians have emerged from time to time to wreak havoc upon mankind. Woe to the world, should the Tyrant monstrosities imprisoned beneath the burning mountains break free."
#hp 132
#unsurr 4
#fireres 20
#poisonres 15
#gcost 300
#end

#selectmonster 3227
#name "Laestrygonian"
#descr "The deformed Laestrygonian Gigantes are the most powerful of the Gigantes of ancient Phlegra, who once declared war upon the gods of men along with the Telkhines. Punished for their hubris the Gigantes were cursed by a celestial decree. Now they are huge monstrosities of foul temper and have an insatiable hunger for the flesh of men. Laestrygonians have serpents for legs and viper tresses for hair. They are able to enter the sea and would probably destroy the world were they more numerous. Laestrygonians do not use armor or weapons, but are fond of throwing boulders on buildings and those who scurry around underneath the roofs. The human population lives in terror of the Laestrygonians and tries to avoid them at all costs."
#hp 123
#unsurr 4
#fireres 20
#gcost 225
#poisonres 15
#end

#selectmonster 3225 -- Cyclope Smith
#spr1 "Hellenika/ShackledSmith1.tga"
#spr2 "Hellenika/ShackledSmith2.tga"
#name "Shackled Smith"
#descr "Four kinds of Cyclops are known to exist in this world. First, there are the mighty Elder Cyclopes, cousins of the Titans now very few in numbers, most of which were killed or imprisoned after the defeat of the Telkhines, but some of which still help the Gigantes of Mekone and Phlegra with their wondrous crafts to this day. Then come the Younger Cyclopes, their degenerate progeny, who inhabit the plains of Phlegra and the mountains of Ind in a wild state but have become civilized soldiers in Porphyrion; Cyclopes of this kind are free even in the land of Oppressors, where they willingly serve their masters. Those of the third kind, the monstrous Earthen Cyclopes, truly are the most mysterious of their great race, for they predate even the Titans and sired the lesser kinds; these very powerful mineral-skinned giants were born from the roots of great mountains in primordial times and have now almost completely disappeared from the world, except in the coasts of Triliax. Finally, there are the unrelated pseudo-cyclopes, that is to say the one-eyed giants of other kinds, the best known and numerous of which may be the denizens of Agartha, the Pale Ones.
Shackled Smiths deeply differ from other Porphyrian Cyclopes in that they are of the Elder kind rather than of the Younger one. As such, they are of much greater size, strength and intelligence; but the difference doesn't stop there, for as the ancient allies of Phlegran Tyrants they also are hated all over Porphyrion. Thus, in Porphyrion there is a strong opposition and rivalry between Cyclopes of these two kinds, and when at the end of the war against Phlegra the Oppressors ordered their soldiers to capture and enslave all remaining Cyclops Lords, the proud Younger Cyclopes obeyed gladly. Now, all Elder Cyclopes in Porphyrion are Shackled Smiths magically chained to the Oppressors' dungeons and forced to serve them by forging superior armaments for their lesser kin as well as the cruel tools of their own oppression."
#rpcost 3
#comslave
#drainimmune
#gcost 165
#hp 95
#homesick 10
#slave
#mor 10
#mr 15
#montag 4112 -- for Triliax
#resources 30
#ap 2
#mapmove 1
#fixforgebonus 2
#end

#selectmonster 3162 -- Trophimos Oppressor
#name "Trophimos Oppressor"
#descr "Most of the Trophimoi are human students that come to Phlegra to study ancient lore, but some unscrupulous individuals come to gain personal power over their fellow men. Several generations ago, before Porphyrion's revolt, the Phlegran Tyrants received an unusual visitor in the person of Phlegyas, the Theurg Tyrant who, in his exile from Ermor, decided to join and serve them in exchange for power and famously created the iron headbands since then used by the Oppressors of both Phlegra and Porphyrion to subjugate oppressed communion slaves. Following that tradition, Trophimos Oppressors capture and train promising youngsters in the use of magic. The young mages are shackled with arcane bonds that place them in a forced communion led by the Oppressors. The Oppressors wear iron headbands forged by the Elder Cyclopes that allow them to dominate arcane communions and the Shackled Ones."
#end

#selectmonster 3217 -- Phlegran Commander
#name "Porphyrian Commander"
#descr "The elites of the Porphyrian armies are the Cyclops Soldiers, but a large part of the armies are made up of human slave soldiers. A slave soldier that shows initiative, cruelty and loyalty can advance and gain a position as commander of the Porphyrian slave troops. These slave commanders are rarely allowed to leave their armies and few of them see the comfort of city life, despite their position in the slave hierarchy. Porphyrian commanders, like their troops, have abysmal morale and fight mainly to keep their privileged status."
#end

#selectmonster 3218 -- Phlegran Priest
#name "Porphyrian Priest"
#descr "The Priests of Porphyrion are caretakers and shepherds of the human population. While the Cyclope and Tyrant rulers of the kingdom have little use for the worship of gods, the humans pray for deliverance from the wrath of the Laestrygonians. Phlegran priests travel throughout the land to comfort the human population and give them hope that the Laestrygonians remain imprisoned in their mountain ranges."
#end

#selectmonster 3219 -- Phlegran Cataphract Commander
#name "Porphyrian Cataphract Commander"
#descr "The Cataphract Commanders are slave commanders that have advanced in skill and rank. In the slave hierarchy of Porphyrion they wield power and influence and are expected to whip their troops into cohesive and unfaltering units. They ride mighty mouflon steeds and lead the Mouflon Cataphracts with an iron fist."
#end

#selectmonster 3220 -- Shackled Mage
#name "Shackled Mage"
#descr "The Oppressors scour the countryside for gifted youngsters. Lured with false promises they are brought to the laboratories of the Oppressors, where they are shackled and put to stressful training in the magical arts. Most of them only lose their minds or important body parts in the process, but a few actually develop some magical understanding. Given arcane collars ironically forged by the shackled smiths, who are also forced to use them, these Shackled Mages are joined in a forced communion dominated by the Oppressors. The Shackled ones are usually forced to do research for their masters, but sometimes they are brought forth to aid their Oppressors in combat."
#drainimmune
#gcost 70
#end

#selectmonster 3221 -- Phlegran Oppressor
#name "Porphyrian Oppressor"
#descr "Porphyrian Oppressors are mages following the tradition of the Theurg Tyrant who, in his exile from Ermor, joined Phlegra before Porphyrion's revolt and created the iron headbands since then used by the Oppressors of both lands to subjugate oppressed communion slaves. The Oppressors capture and train promising youngsters in the use of magic. The young mages are shackled with arcane bonds that place them in a forced communion led by the Oppressors. The Oppressors wear iron headbands forged by the shackled smiths that allow them to dominate arcane communions and the Shackled Ones themselves."
#end

#selectmonster 3222 -- Oppressor General
#name "Oppressor General"
#descr "The Oppressors were originally the ones who, under the domination of Phlegran Tyrants, enslaved human mages with magical shackles. When they revolted against the Gigantes and told the human slaves that they would free them, they gave them armaments suited for killing even the mightiest of Gigantes and the Porphyrian armies were born. But the Oppressors didn't really intend to free their slaves, and thus they saw the need for strong leadership. The Cyclops commanders, regardless of their claims, were not very good strategists. Some Oppressors made themselves captains and generals of the slave soldiers. After the war, being used to dominating the shackled mages, they observed a lack in loyalty among their soldiers. With the aid of the Elder Cyclops they had enslaved, a new form of shackles was forged and the first Iron Bound were chosen. Oppressor Generals are Oppressor mages that have chosen a martial career. They are superior to the Cyclops Commanders, but can only command human soldiers."
#inspirational 1
#gcost 135
#end

#selectmonster 3223 -- Cyclope Commander
#name "Cyclops Commander"
#descr "Unlike their Phlegran cousins, Porphyrian Cyclopes have abandoned their pastoral ways of life and formed a powerful warrior-caste. While mankind toil and serve, the Cyclopes live existences of ease, serving the Oppressors as their ruthless soldiers in exchange for their privileges. They occasionally wage war upon inferior races, but most of their time is spent honing their skills and bullying the human population. The Cyclops Commanders claim that they are the equals of the Gigante generals of Mekone, but in truth their success in battles stems from the strength of their soldiers rather than from their strategic skills. Hateful of all Gigantes for being better than them in every way, they'll do anything in their power to preserve Porphyrion's oligarchy and follow the Oppressors in their conquest and destruction of both Mekone and Phlegra."
#montag 4112 -- for Triliax
#hp 60
#gcost 75
#end

#selectmonster 3224 -- Cyclope Soldier
#name "Cyclops Soldier"
#descr "In earlier times Porphyrian Cyclopes lived pastoral lives herding mouflon sheep on the gentle slopes of mount Ethna, but even during these times they sometimes were coerced into joining the Phlegran Tyrants' armies. When the Tyrants, too sure of their rule's sustainability, started fighting each other for petty reasons, their control over Porphyrian provinces dwindled. The human and Cyclops populations took that opportunity to rebel against their masters and together tried to capture the great fortress of Telepylos once built by the Tyrants to oversee the lands they conquered. They suffered incredible hardships, but their brave attempts shook the very fundations of Phlegran rule, in the end forcing the Tyrants to retreat in order to avoid similar revolts in other parts of their empire and reinforce their control over its remaining slave populations. Thus, Porphyrian humans and Cyclopes successfully expelled the Gigantes out of their lands. Jealous and hateful of their greater cousins the Elder Cyclopes, who had willingfully served Phlegra against them, Porphyrian Cyclopes gladly obeyed their new human overlords when they ordered to capture the region's few surviving elder smiths and to shackle them under the fortress that was once theirs. When the lords of Porphyrion eventually unveiled their intentions as Oppressors, they wisely decided to reward their mighty Cyclops soldiers with influence and power, thus ensuring their loyalty. They were given arms of cyclopean manufacture and became a noble warrior-caste tasked with enforcing the Oppressors' absolute control over the human population. Created by enslaved smiths, the cyclopean armors are not as splendid as those used in Mekone, but they are superior to most other armors. Cyclopes are known for their fondness for throwing things, large and small. In Porphyrion where they have been gifted with armaments forged by their greater kin, javelins have replaced the boulders carried in Phlegra and by their ancestors."
#hp 52
#gcost 40
#end

#selectmonster 3228 -- Oppressor Archon
#name "Oppressor Archon"
#descr "Although they claim they saved the people from tyranny, the Oppressor Archons, rulers of Porphyrion, are tyrants themselves. Since the days of Phlegran domination there have been oppressors with greater powers than their peers, but only after the Tyrants' demise were they able to grab power. Since then, they have manipulated the Cyclopes into fealty, further developed the Theurg Tyrant's sinister creation and invented new ways of dominating their fellow men. The Oppressor Archons are skilled mages ordained as high priests. Their magic knowledge is considerable and the iron headbands that give them command of the communion of the shackled mages provide them with almost godlike powers. The Archons rule Porphyrion with an iron hand."
#montag 4124 -- for Isphenople
#rpcost 3
#end

#selectmonster 3028 -- Erytheian Scout (UW)
#cleararmor
#armor 135
#armor 5
#end

#newmonster 7093
#spr1 "Hellenika/SciapodChieftain1.tga"
#spr2 "Hellenika/SciapodChieftain2.tga"
#name "Sciapod Chieftain"
#descr "The strongest of all sciapods besides Gavagai giants, sciapod chieftains are the most common war leaders of U and each rules a whole tribe of lesser sciapods, only answering to the Satraps themselves. Their whole authority being based on their strength and fighting abilities, they appear almost invincible to other sciapods, and although it is indeed very hard to defeat these half-giants in single combat, as soon as they lose a duel, their power crumbles and they are likely to be replaced by a stronger champion. Still, becoming a chieftain in U is earning a great number of privileges, among which the right to wear regal furs without being looked down upon, protecting their owner from cold and light blows. Indeed, while in U clothes are usually considered to be for the weak, when none but the greatest warriors of the nation is able to strike you down, it is clear that you have attained the epitome of muscular might and no longer have anything to prove; therefore, even though it is still necessary to remain the strongest in order to keep your lieutenants in check and avoid being overthroned, only a fool would doubt your physical shape or demand to see it directly. In addition to being the most common of blemmye commanders, sciapod chieftains also have the privilege to be trained by the Sophotatos or Anthropophagos shamans of their tribe and are thus gifted with a very faint magical aura, an essential skill for a chief since it allows them to lead protozoons and other magical beings in battle."
#nametype 240
#size 4
#hp 50
#prot 3
#mr 9
#mor 15
#str 24
#att 16
#def 13
#prec 12
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 90
#weapon 397
#weapon 1152
#armor 44
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#goodleader
#beastmaster 1
#gcost 35
#formationfighter 2
#berserk 3
#rpcost 1
#okmagicleader
#userestricteditem 8066
#swimming
#minsizeleader 4
#twiceborn 6642
#end

#newmonster 7094
#spr1 "Hellenika/SciapodScout1.tga"
#spr2 "Hellenika/SciapodScout2.tga"
#name "Sciapod Scout"
#descr "Even among sciapods, there are travelers curious of the outside world. Most start out as hunters and eventually find a careful interest in the marvels of mankind, sometimes even primitively mimicking its technology. While they dislike forests and their strange anatomy makes them less discreet than most scouts, many are still trained to hide and pass unseen through enemy territory, and they are much cheaper to recruit than human agents. Their reports on enemy army movements and the resources in enemy lands are invaluable to the prudent warlord."
#nametype 240
#size 2
#hp 12
#prot 0
#mr 7
#mor 8
#str 10
#att 10
#def 10
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#stealthy
#noleader
#troglodyte
#weapon 373
#weapon 397
#weapon 1151
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#gcost 15
#rpcost 1
#rcost 2
#coldres -3
#userestricteditem 8066
#swimming
#supplybonus 6
#twiceborn 6642
#end

#newmonster 7095
#spr1 "Hellenika/Anthropophagos1.tga"
#spr2 "Hellenika/Anthropophagos2.tga"
#name "Anthropophagos"
#descr "The most voracious, cruel and perverted of the Epiphagoi, their shamans and leaders are notorious for only eating sciapods and humans, particularly relishing in devouring such delicacies as their brains, hearts and eyes, and as such, they have very well earned their name: the Anthropophagoi. Although they are as primitive and violent as their minions, they are much smarter and have some magic knowledge, which makes them vastly more dangerous in more than a way. Entirely devoting their intelligence to the defilement and corruption of all that is pure, orderly or beautiful, they conspire against their enemies with the ultimate goal of making them suffer and eating them, and they use all their powers to do so, seldom hesitating to send to oblivion their numerous underlings, whose loyalty they ensure by fear of the supernatural and of fates much worse than death. Some scholars even suspect that the Anthropophagoi may have played a decisive role in the fall of Pedoseion, the third King of Elemental Earth that is now known as Father Illearth and worshipped by them in a gory and barbaric cult that even other sciapods consider heathenly. While it is true that their presence often impacts negatively the region in which they dwell by spreading unrest and causing some population losses, they are extremely cheap blood mages and their dark rituals are one of the most powerful weapons of U, which explains why the Satraps tolerate and even sometimes cooperate with them; still, they are strictly forbidden direct participation in the religious rituals of U, and as such, their priestly authority will be reduced if they are ever appointed as prophets."
#nametype 240
#size 2
#hp 17
#prot 1
#mr 12
#mor 8
#str 16
#att 10
#def 7
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 1150
#weapon 20
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#supplybonus -6
#popkill 1
#incunrest 10
#berserk 3
#gcost 35
#poorleader
#magicskill 7 1
#magicboost 8 -1
#custommagic 1024 25
#researchbonus -4
#rpcost 2
#coldres -3
#poormagicleader
#wastesurvival
#userestricteditem 8066
#fixforgebonus -1
#twiceborn 6642
#end

#newmonster 7096
#spr1 "Hellenika/Anthropophagos1.tga"
#spr2 "Hellenika/Anthropophagos2.tga"
#name "Necrophagos"
#descr "Necrophagoi are dark Epiphagos shamans that received the teachings of Urizen, the Son of Mu. They share all of the Anthropophagoi's abilities, and in addition have some knowledge of Death magic. Up to three Anthropophagoi per month can be uplifted, and they need to be in the same province as their semi-divine master for this to happen."
#nametype 240
#size 2
#hp 17
#prot 1
#mr 12
#mor 8
#str 16
#att 10
#def 7
#prec 10
#ap 18
#mapmove 16
#enc 3
#maxage 40
#troglodyte
#weapon 1150
#weapon 20
#weapon 1151
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#supplybonus -6
#popkill 1
#incunrest 10
#berserk 3
#gcost 35
#poorleader
#magicskill 5 1
#magicskill 7 1
#magicboost 8 -1
#custommagic 1024 25
#researchbonus -4
#rpcost 2
#coldres -3
#poormagicleader
#wastesurvival
#userestricteditem 8066
#fixforgebonus -1
#twiceborn 6642
#end

#newmonster 7097
#spr1 "Hellenika/PriestA1.tga"
#spr2 "Hellenika/PriestA2.tga"
#name "Priest of the Palm"
#descr "While sciapods eschew technology and often live as troglodytes, the least uncivilized of their tribes still have a proper culture - a language, a society, a religion, rites, arts and traditions. As the holy representatives of all that makes sciapods a noble race, the Priests of the Palm, leaders of the Dancers of the Foot, are highly respected by all true sciapods in U and may even be seen as wisemen by some humans. Above both the Strong - chieftains and their champions, who retain their power at a local level but must recognize them as envoys of the Satraps as well as obey the directives they deliver in the name of the Great Unifier - and the Weak - mere tribesmen, who see them as the best of their kind, their glorious protectors and the chosen of the God, promised to bring them happiness by making the utopia of Mu a reality -, they form a third caste along with their blessed followers and, as such, are the greatest guarantors of U's unity before a single, common and sacred goal. While they share with the Anthropophagoi the ability, rare in U, to use magic and are sometimes ordered by the Satraps to cooperate with them, they are antithetical to them in many ways; indeed, these sacred gymnasts are benevolent, very disciplined and clearly more learned than most other blemmyes. In peace, they officiate in most of the rituals that aren't restricted to the Satraps themselves, take an important part in the nation's research for the keys to the mystery of Mu, and when available teach tribesmen in the temples, an important task since it allows them to spend the month training a new Dancer of the Foot for free; and in war, they demonstrate their unique priestly science by using holy semaphore against their enemies and sacred oils to magnify their soldiers' bodies, two spells they are famed for even beyond the lands of U. Still, they are forbidden by their jealous masters to overstep their role, and as such their priestly authority will be reduced if appointed as prophets."
#nametype 240
#size 3
#hp 16
#prot 1
#mr 14
#mor 14
#str 12
#att 10
#def 10
#prec 12
#ap 18
#mapmove 16
#enc 2
#maxage 40
#troglodyte
#weapon 92
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#gcost 55
#rpcost 2
#okleader
#holy
#magicskill 3 1
#magicskill 8 2
#magicboost 8 -1
#coldres -3
#okmagicleader
#templetrainer "Dancer of the Foot"
#userestricteditem 8066
#fixforgebonus -1
#twiceborn 6642
#end

#newmonster 7098
#spr1 "Hellenika/Snail1.tga"
#spr2 "Hellenika/Snail2.tga"
#name "Sacred Snail"
#descr "Grand masters of 'Pataphysics, the Satraps of U worship a vastly significant symbol: the Great Gidouille. Since it takes the vague shape of a spiral, snails and in particular their shells are closely associated with it. For this reason, these animals are sacred to the priests of U - a status facilitated by the fact that, just like blemmyes, they only have a single foot and no discernable head -, and a rare species of giant, subterranean, fungivore snails which also exists in some marshes of the sunlit world has been bred by the sciapods for as long as they can remember. Almost brainless and therefore very resistant to fear and magic, these terrifying war snails have a highly corrosive saliva which can cause both flesh and steel to melt, and their almost formless body has impressive regenerative properties. Although they are generally slow, they feel at ease in swamps - which remind them of the muddy environment of their caves - and have no issue surviving underwater. In addition to ensnaring their aggressors in very sticky and somewhat poisonous slime, their moist body makes them highly resistant to fire and poison, albeit vulnerable to lightning and cold climate. But this weakness is no matter for them: when they are hurt badly enough, they temporarily retreat inside their shell and wait for their wounds to heal, which is rarely more than a matter of minutes. While they are entirely unable to act in this state, they also are very difficult to harm and are almost guaranteed to eventually recover if not killed quickly, which makes them highly dangerous opponents indeed."
#hp 60
#size 6
#prot 0
#mr 18
#mor 16
#str 14
#att 8
#def 10
#prec 0
#ap 6
#mapmove 1
#enc 0
#maxage 40
#nametype 240
#okmagicleader
#snake
#itemslots 61440 -- 4 misc
#holy
#animal
#regeneration 10
#heal
#bluntres
#weapon 1191
#fireres 15
#shockres -5
#coldblood
#darkvision 100
#poisonres 15
#amphibian
#neednoteat
#slimer 2
#swampsurvival
#gcost 0
#shrinkhp 15
#eyes 4
#poisonskin 20
#voidsanity 10
#end

#newmonster 7099
#spr1 "Hellenika/SnailShell.tga"
#name "Sacred Snail"
#descr "Grand masters of 'Pataphysics, the Satraps of U worship a vastly significant symbol: the Great Gidouille. Since it takes the vague shape of a spiral, snails and in particular their shells are closely associated with it. For this reason, these animals are sacred to the priests of U - a status facilitated by the fact that, just like blemmyes, they only have a single foot and no discernable head -, and a rare species of giant, subterranean, fungivore snails which also exists in some marshes of the sunlit world has been bred by the sciapods for as long as they can remember. Almost brainless and therefore very resistant to fear and magic, these terrifying war snails have a highly corrosive saliva which can cause both flesh and steel to melt, and their almost formless body has impressive regenerative properties. Although they are generally slow, they feel at ease in swamps - which remind them of the muddy environment of their caves - and have no issue surviving underwater. In addition to ensnaring their aggressors in very sticky and somewhat poisonous slime, their moist body makes them highly resistant to fire and poison, albeit vulnerable to lightning and cold climate. But this weakness is no matter for them: when they are hurt badly enough, they temporarily retreat inside their shell and wait for their wounds to heal, which is rarely more than a matter of minutes. While they are entirely unable to act in this state, they also are very difficult to harm and are almost guaranteed to eventually recover if not killed quickly, which makes them highly dangerous opponents indeed."
#hp 60
#size 6
#prot 18
#mr 18
#mor 16
#str 14
#att 8
#def 0
#prec 0
#ap 0
#mapmove 0
#enc 0
#immobile
#maxage 40
#nametype 240
#okmagicleader
#miscshape
#itemslots 61440 -- 4 misc
#holy
#animal
#regeneration 10
#heal
#slashres
#pierceres
#fireres 15
#shockres 5
#coldres 5
#coldblood
#woundfend 3
#darkvision 100
#poisonres 15
#reinvigoration 1
#amphibian
#neednoteat
#slimer 2
#swampsurvival
#gcost 0
#growhp 40
#eyes 4
#voidsanity 10
#firstshape "Sacred Snail"
#end

#newmonster 7100
#spr1 "Hellenika/Satrap1.tga"
#spr2 "Hellenika/Satrap2.tga"
#name "Satrap"
#descr "The highest sciapod authority in all of U along with the Gavagai Kings, the enigmatic Satraps - also called Bishops of Delirium - are second only to the God and the Mu-Atlaï themselves. As the most direct interpreters of the Primogenitor's ktonian Dreams, they have developed an utterly strange holy science in order to understand them. Called 'Pataphysics - always starting with an apostrophe -, that serendipitous and hyper-paranoiac-critical discipline could be defined as the branch of metamagic philosophy which extends as far beyond metaphysics as the latter extends beyond physics, or in other words, the science of imaginary solutions, which symbolically attributes the properties of objects, described by their virtuality, to their lineaments, and especially the science of the particular, that which examines the laws governing exceptions. Armed with this highly advanced and superrealistic knowledge, the secretive Satraps ascended to power in U long ago, directed the unending blemmye wars against Agartha, prophesied the coming of the Unifier, and now, will do all that is in their power to bring the rise of U to its ultimate conclusion: the reshaping of the world into the imaginary empire of Mu. Although they aren't very skilled in traditional magic, they actually have immense powers that could pass unseen at a first glance. The most important one is by far their ability to cast the majority of the highest rituals of U, including those summoning Terminae and Mu-Atlaï; and while these rituals could theoretically be cast by other mage-priests as well, in practice it is extremely rare for non-Satraps to be able to do so. In addition, only they have the expertise and the rank required to use a very mighty magical item, the Sacred Shell, and they rarely summon monstrous Sacred Snails when in friendly dominion. Finally, they know how to cause madness with a mere touch and they are such powerful priests that they automatically cast Fanaticism at the start of every battle."
#nametype 240
#size 4
#hp 50
#prot 3
#mr 18
#mor 15
#str 20
#att 13
#def 11
#prec 12
#ap 18
#mapmove 16
#enc 4
#maxage 40
#troglodyte
#weapon 481
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#mountainsurvival
#goodleader
#goodmagicleader
#gcost 320
#rpcost 4
#rcost 1
#holy
#startage 40
#magicskill 3 1
#magicskill 8 2
#masterrit 1
#fixforgebonus -1
#userestricteditem 8068
#researchbonus 14
#allrange 2
#onebattlespell "Fanaticism"
#raredomsummon "Sacred Snail"
#twiceborn 6642
#voidsanity 10
#end

#newmonster 7101
#spr1 "Hellenika/GavagaiChieftain1.tga"
#spr2 "Hellenika/GavagaiChieftain2.tga"
#name "Gavagai Chieftain"
#descr "A Gavagai Chieftain is the leader of one of the many perpetually warring Gavagai tribes, much rougher and meaner than regular Gavagais. By strength and will alone, he subjugated several other blemmye giants and built his clan out of nothingness, just as his clan will once again dissolve into chaos as soon as he knows defeat. While too stupid to rule over blemmyes of lesser size but greater numbers and intelligence, Gavagai chieftains still are highly respected by sciapods and inspire them awe, as they are as strong and tall as the mountains themselves, and when they stop struggling against each other to sing in unison for their next in kin, the Mu-Atlas Titans of legends, the long echo of their voices seems to cause the whole earth to shiver before the mysterious power and the strange beauty of their lament. Although the influence of Gavagai chieftains is very limited in itself, there is an important reason why they so clash against each other; for once or twice per century, it happens that a Gavagai so mighty, cunning and heroic as to unite under his grasp his entire kin in the region comes to deserve the uncontested title of King and build cyclopean monuments to his own glory such as those that still litter U millenia after their death. Therefore, after winning countless battles, a Gavagai Chieftain has the chance of being recognized as a Gavagai King, thus granting him with many powerful skills. By doing so, he'll receive some mastery of Earth magic and priestly powers above that of a Priest of the Palm, as well as a very powerful area of effect weapon and enough fighting mastery to cast spells in melee without faltering. But the greatest mark of his unyielding authority will by far rest in his unique ability to construct great fortresses for the whole blemmye race to admire and use in warfare."
#nametype 240
#size 6
#hp 105
#prot 5
#mr 11
#mor 16
#str 30
#att 13
#def 11
#prec 13
#ap 18
#mapmove 20
#enc 3
#maxage 200
#troglodyte
#weapon 252
#weapon 90
#weapon 397
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#fear 5
#patrolbonus 25
#siegebonus 25
#castledef 25
#mountainsurvival
#okleader
#okmagicleader
#gcost 100
#rpcost 1
#xpshape 70
#woundfend 1
#userestricteditem 8066
#minsizeleader 4
#twiceborn 775
#magicskill 3 1
#magicskill 8 1
#magicboost 3 -2
#magicboost 8 -1
#noreqtemple
#notsacred
#end

#newmonster 7102
#spr1 "Hellenika/GavagaiKing1.tga"
#spr2 "Hellenika/GavagaiKing2.tga"
#name "Gavagai King"
#descr "The greatest of all Gavagai giants, Gavagai Kings are the reason why lesser chieftains perpetually war against each other; for once or twice per century, it happens that a Gavagai so mighty, cunning and heroic as to unite under his grasp his entire kin in the region comes to deserve the uncontested title of King and build cyclopean monuments to his own glory such as those that still litter U millenia after their death. Therefore, after winning countless battles, a Gavagai Chieftain has the chance of being recognized as a Gavagai King, thus entering the legends of U forever. As such, a Gavagai King has skills to the height of his prowesses, far beyond the greatest dreams of his subjects. By valor, guile, strength and will, he subjugated entire Gavagai tribes and built a kingdom out of nothingness, just as his kingdom will once again dissolve into chaos whenever he knows his ultimate demise. Clever enough to rise above their kind, Gavagai Kings often rule over several sciapod tribes as well, even using the Satraps as counselors rather than obeying them. In addition to having some mastery of Earth magic and priestly powers above that of the Priests of the Palm, they are known for their very powerful area of effect weapons as well as for their exceptional fighting mastery, which allows them to cast spells in melee without faltering. But the greatest mark of their unyielding authority by far rests in their unique ability to construct great fortresses for the whole blemmye race to admire and use in warfare."
#nametype 240
#size 6
#hp 120
#prot 5
#mr 15
#mor 30
#str 33
#att 15
#def 13
#prec 14
#ap 18
#mapmove 20
#enc 3
#maxage 200
#troglodyte
#weapon 1138
#weapon 397
#itemslots 7174 -- 2 hands, 1 body, 1 feet, 1 misc
#darkvision 100
#fear 10
#patrolbonus 25
#siegebonus 50
#castledef 50
#mountainsurvival
#expertleader
#expertmagicleader
#gcost 100
#holy
#mason
#woundfend 3
#combatcaster
#userestricteditem 8066
#fixforgebonus -1
#minsizeleader 4
#magicskill 3 1
#magicskill 8 1
#magicboost 8 1
#twiceborn 775
#end

#newmonster 7103
#spr1 "Hellenika/BigTriskelion1.tga"
#spr2 "Hellenika/BigTriskelion2.tga"
#name "Megatriskelios"
#descr "Megatriskelioi are triskelioi of great size that strangely attract protozoons and therefore often lead hordes of lesser mindless blemmyes to destroy everything in their wake. Like regular triskelioi, they are strange creatures born from the spontaneous aggregation of three leg protozoons. Considering the fact that legs and arms are equally common among protozoons, the existence of triskelioi is inevitable, since sciapods - the most numerous of sentient blemmyes - have two arms for one leg. As such, triskelioi are widely believed to be formed of the many legs in surplus. Still, their generation doesn't follow any preordained plan, and just like protozoons, with whom they share most of their qualities, they are completely devoid of intelligence. Since their entire body is made of nothing but legs, triskelioi are known in the lands of U as one of the fastest terrestrial creatures in existence. In order to avoid losing balance, triskelioi never walk. Instead, unable to ever stop their course, they continuously roll forward not unlike a wheel, and when numerous enough they mindlessly trample everything in their path, repeatedly kicking with great agility, speed and strength anything too large to be climbed over."
#nametype 240
#size 4
#hp 60
#prot 3
#mr 14
#mor 50
#str 24
#att 16
#def 15
#prec 12
#ap 32
#mapmove 26
#enc 2
#maxage 20
#miscshape
#magicbeing
#undisciplined
#weapon 175
#weapon 175
#weapon 175
#trample
#itemslots 14336 -- 1 feet, 2 misc
#blind
#eyes 0
#mountainsurvival
#noleader
#coldres -3
#expertmagicleader
#neednoteat
#gcost 35
#rcost 1
#rpcost 1
#formationfighter 2
#userestricteditem 8066
#summon1 -4146
#twiceborn 776
#end

#newmonster 7104
#copystats 160 -- High Priest of C'tis
#spr1 "Hellenika/AabHighPriest_1.tga"
#spr2 "Hellenika/AabHighPriest_2.tga"
#name "High Priest of Aabydum"
#descr "The black-robed priests of Aabydum are revered and treated with total respect in the sacred kingdom. They are trained in the City of Tombs where they perform the sacred services and train the sacred rattlesnakes. Each priest is served by a harem of Hierodules."
#prot 6
#hp 12
#poisonres 6
#wastesurvival
#templetrainer "Sacred Rattlesnake"
#twiceborn 3181
#addupkeep -20
#undcommand 1
#end

#selectmonster 160 -- High Priest of C'tis
#name "High Priest of C'tis"
#descr "The black-robed priests of C'tis are revered and treated with total respect in the sacred kingdom. They are trained in the Temple Marsh where they perform the sacred services and train the sacred serpents. Each priest is served by a harem of Hierodules."
#end

#newmonster 7105
#copystats 162 -- Lizard Lord
#spr1 "Hellenika/AabLizLord_1.tga"
#spr2 "Hellenika/AabLizLord_2.tga"
#name "Desert Lord"
#descr "The Desert Lords of Aabydum are proficient leaders equipped with falchions and gilded scale armor. They are second only to the Desert Kings in their skill at warfare."
#prot 6
#hp 15
#poisonres 6
#wastesurvival
#twiceborn 3181
#addupkeep -20
#undcommand 1
#end

#newmonster 7106
#copystats 163 -- Commander of C'tis
#spr1 "Hellenika/AabCommander_1.tga"
#spr2 "Hellenika/AabCommander_2.tga"
#name "Commander of Aabydum"
#descr "The commanders of Aabydum are armed identically to the desert heavy infantry. Their armor is gilded and ornate."
#prot 6
#hp 14
#poisonres 6
#wastesurvival
#twiceborn 3181
#addupkeep -10
#undcommand 1
#end

#newmonster 7107
#copystats 328 -- Lizard King prophetshape
#spr1 "Hellenika/AabLizProph_1.tga"
#spr2 "Hellenika/AabLizProph_2.tga"
#name "Desert Monarch"
#descr "The Desert Kings are the supreme priestly authority in Aabydum. They receive physical, mental and religious training from the moment they are hatched. Desert Kings command all and lead the sacred services in the City of Tombs. They are formidable leaders, powerful warriors and mighty priests, and when appointed as prophets they became great builder monarchs with the capacity to direct the construction of huge citadels and the divine knowledge to gift their people with one Earth gem per month."
#prot 6
#hp 18
#poisonres 6
#wastesurvival
#mason
#twiceborn 3181
#gemprod 3 1
#clearweapons
#weapon 172
#gcost 0
#undcommand 1
#end

#newmonster 7108
#copystats 177 -- Lizard King
#spr1 "Hellenika/AabLizKing_1.tga"
#spr2 "Hellenika/AabLizKing_2.tga"
#name "Desert King"
#descr "The Desert Kings are the supreme priestly authority in Aabydum. They receive physical, mental and religious training from the moment they are hatched. Desert Kings command all and lead the sacred services in the City of Tombs. They are formidable leaders, powerful warriors and mighty priests, and when appointed as prophets they became great builder monarchs with the capacity to direct the construction of huge citadels and the divine knowledge to gift their people with one Earth gem per month."
#prot 6
#hp 18
#poisonres 6
#wastesurvival
#prophetshape "Desert Monarch"
#twiceborn 3181
#clearweapons
#weapon 1149
#addupkeep -60
#undcommand 1
#end

#selectmonster 177 -- EA Lizard King
#name "Lizard King"
#descr "The Lizard Kings are the supreme priestly authority in C'tis. They receive physical, mental and religious training from the moment they are hatched. Lizard Kings command all and lead the sacred services in the Temple Marsh and its sacral city. They are formidable leaders, powerful warriors and mighty priests, and when appointed as prophets they became great builder monarchs with the capacity to direct the construction of imposing castles and, as the divine embodiments of the fertile river's valley, to gift their people with one Water gem per month."
#clearweapons
#weapon 1149
#end

#selectmonster 328 -- EA Lizard King prophet
#name "Lizard Monarch"
#descr "The Lizard Kings are the supreme priestly authority in C'tis. They receive physical, mental and religious training from the moment they are hatched. Lizard Kings command all and lead the sacred services in the Temple Marsh and its sacral city. They are formidable leaders, powerful warriors and mighty priests, and when appointed as prophets they became great builder monarchs with the capacity to direct the construction of imposing castles and, as the divine embodiments of the fertile river's valley, to gift their people with one Water gem per month."
#poisonres 7
#mason
#gemprod 2 1
#clearweapons
#weapon 172
#end

#newmonster 7109
#copystats 510 -- Hierodule
#spr1 "Hellenika/AabHierodule_1.tga"
#spr2 "Hellenika/AabHierodule_2.tga"
#name "Hierodule of Aabydum"
#descr "Hierodules are the sacred consorts of the High Priests. They serve at the temples, laying eggs and nurturing future kings and priests. Hierodules are trained as priestesses but are not entrusted with leading armies."
#prot 5
#hp 11
#poisonres 6
#wastesurvival
#twiceborn 3181
#addupkeep -8
#userestricteditem 8069 -- for Thalamanth and Nabatem
#undcommand 1
#end

#selectmonster 710 -- Hierodule
#userestricteditem 8069 -- for Thalamanth and Nabatem
#end

#selectmonster 1036 -- LA Sauromancer
#spr1 "Hellenika/AabSauromancer_1.tga"
#spr2 "Hellenika/AabSauromancer_2.tga"
#name "Sauromancer"
#descr "Although today Sauromancers are widely believed to serve C'tis, in truth their enigmatic Order was born in Aabydum long before the fall of the First Empire, and the fact that they are granted priestly authority by the Old and New Dynasties and not in C'tis shows how only the Desert Lizards remained faithful to their sacred tradition. The Sauromancers discovered the secrets of dark magic in the ancient eras and have prudently practiced the magic of Death since these times. However, when the Temple Marsh fell at the hands of the C'tissian traitors the Sauromancers of Aabydum changed their ways. Dark rituals started being secretly performed in the tombs of ancient kings. Bane Fires were lit in braziers not used for a millenium. Dried husks of legendary kings were reawakened to share the thrones of living kings. The Sauromancers of Aabydum are very powerful Death mages and skilled also in Fire magic, which is necessary to light the Bane Fire Braziers. They have partial resistance to poison."
#montag 4124 -- for Isphenople
#addupkeep -70
#userestricteditem 8059
#end

#selectmonster 692 -- Tomb King
#wastesurvival
#end

#selectmonster 691 -- Tomb Priest
#wastesurvival
#end

#selectmonster 1659 -- Tomb Chariot
#wastesurvival
#end

#selectmonster 1365 -- Lizard Chariot
#name "Lizard Chariot"
#descr "Ceremonies and parades are common in the sacred kingdom and gilded, lizard-drawn chariots can often be seen in the Temple Marsh's sacral city. The chariots are used in warfare as well as in parades. With scythed wheels, the chariot is mainly an offensive weapon. Its charge causes tremendous damage to lightly armored troops. Lizard charioteers are armed with falchions and wear scale mail cuirass."
#att 14
#def 15
#end

#selectmonster 693 -- Tomb Wyrm
#wastesurvival
#end

#selectmonster 690 -- Grave Consort
#wastesurvival
#userestricteditem 8069 -- for Thalamanth and Nabatem
#end

#selectmonster 2314 -- Reborn
#spr1 "Hellenika/AabReborn_1.tga"
#spr2 "Hellenika/AabReborn_2.tga"
#prot 6
#wastesurvival
#addupkeep -30
#end

#selectmonster 702 -- Empoisoner
#spr1 "Hellenika/AabEmpoisoner_1.tga"
#spr2 "Hellenika/AabEmpoisoner_2.tga"
#prot 6
#rpcost 1
#wastesurvival
#montag 4148
#addupkeep -25
#researchbonus -4
#end

#selectmonster 1095 -- Keeper of the Tombs
#spr1 "Hellenika/AabKeeper_1.tga"
#spr2 "Hellenika/AabKeeper_2.tga"
#name "Keeper of the Tombs"
#descr "The Keepers of the Tombs are mage-priests of the Sacred Tombs of Aabydum. They serve the Tomb Kings and the Sauromancers and keep the green flames of the Bane Fires blazing in the dark halls of the Sacred Tombs. Their mystical powers and ancient secrets are such that they start every battle with a temporary Death and Fire gems."
#tmpfiregems 1
#tmpdeathgems 1
#prot 6
#researchbonus 12
#addupkeep -25
#custommagic 2048 10
#userestricteditem 8059
#end

#selectmonster 3195 -- Wight Mage (Atlantian)
#hp 80
#end

#newmonster 6675
#copystats 299 -- Wight Mage
#copyspr 299
#name "Wight Sorceress"
#descr "A wight sorceress is the corpse of a female necromancer strong enough to avoid death itself. Its dried and leathery body is stronger than it was in life. The wight sorceress is constantly surrounded by an icy wind."
#female
#nametype 135
#userestricteditem 8069
#end

#newmonster 6768
#copystats 350 -- Garnet Priestess
#spr1 "Hellenika/SunAdept_1.tga"
#spr2 "Hellenika/SunAdept_2.tga"
#name "Disciple of the Sun"
#descr "In Zun, some priestesses believe that the Sun is an aspect of the God even more important than Fire itself. These priestesses call themselves Disciples of the Sun and are very well known for their selflessness and fanaticism. Through intense meditation under the desert sun, they are able to greatly empower the inner flame they were born with as Garnet Amazons. This increases her priestly authority, makes her hard to look at like the Sun, and gifts her with the ability to release rays of burning light in a large area when slain. In addition, if she already had some knowledge of Fire magic, her mastery is increased."
#deathfire 20
#twiceborn 6768
#magicboost 8 1
#magicboost 0 1
#awe 3
#gcost 0
#userestricteditem 8069
#end

#selectmonster 349 -- Garnet Sorceress
#twiceborn 349
#userestricteditem 8069
#end

#selectmonster 350 -- Garnet Priestess
#twiceborn 350
#userestricteditem 8069
#end

#newmonster 6790
#copystats 350
#spr1 "Hellenika/SacredProstitute_1.tga"
#spr2 "Hellenika/SacredProstitute_2.tga"
#name "Sacred Prostitute"
#descr "In the temples of Zun, the highest of Vestal priestesses tend to the eternal Flame of Justice. Most, however, instead celebrate the holy Blood of womanly self-sacrifice. Those among them that completely devote their lives to the sublime and invincible power of Femininity become Sacred Prostitutes. By doing so, they abandon their priestly authority forever to instead themselves become embodiments of passion and objects of adoration. Although their daily life then consists of appeasing the pain and urges of the Amazons by sharing their warmth with them, they can also serve the God by seducing men, thus causing their downfall as castrated slaves and once again proving the superiority of women. While their sacred task forbids them from wearing any other armor or clothing than their thin veils, delicate perfume and refined jewelry, they are protected from harm both by their great beauty and by the God, which allows them to make fine assassins as well in the case where they would fail to sway their target's heart. However, carving their precious jewelry and distilling their bewitching perfumes isn't possible without the help of magic, and thus they can only be recruited in provinces with a laboratory."
#gcost 95
#rpcost 1
#holy
#noleader
#awe 1
#startitem 869
#seduce 12
#stealthy 10
#researchbonus -4
#incunrest -5
#clearweapons
#weapon 126
#cleararmor
#clearmagic
#custommagic 16768 50
#custommagic 16768 10
#twiceborn 6790
#reqlab
#userestricteditem 8069
#end

#newmonster 7110
#copystats 351
#spr1 "Hellenika/GarnetCommander_1.tga"
#spr2 "Hellenika/GarnetCommander_2.tga"
#name "Garnet Commander"
#descr "Amazons of the Garnet Tribe are even more warlike than those of the other tribes. Their military is renowned both for its discipline and for its ferocity. Garnet Commanders are the result of this great predominance of war in the society of Zun: experienced and brutal warriors that were rewarded for their skills with the right to lead a small squadron in battle. Being accustomed both to the order of the phalanx and to the chaos of the battlefield, they are skilled, pragmatic and charismatic leaders, respected both of Hoplites and Furies, and they are very efficient in their tasks, especially that of patroling and hunting fugitives, which makes them very useful even in times of peace as roughless agents of the secret police. However, they are quite numerous in the armed forces of Zun, so they aren't allowed to lead as many soldiers as the commanders of rival nations."
#gcost 45
#patrolbonus 30
#hp 13
#str 14
#mr 12
#mor 16
#def 15
#att 13
#enc 2
#okleader
#shockres 5
#command -10
#woundfend 1
#inspirational 2
#formationfighter 2
#clearweapons
#weapon 644
#cleararmor
#armor 101
#armor 123
#armor 209
#userestricteditem 8069 -- for Thalamanth and Nabatem
#end

#newmonster 6545
#spr1 "Hellenika/GryphonGeneral_1.tga"
#spr2 "Hellenika/GryphonGeneral_2.tga"
#name "Gryphon Prophet"
#descr "In the Garnet tribes, gryphons are trained from birth by warrior maidens of the temples. Gryphons are large, winged beasts of tremendous ferocity. Gryphon Generals are the most experienced of these sacred warriors, exceptionally skilled commanders that also received medium ranking as mage-priestesses in the Order of Vestals. As a result, few Amazons in Zun would dream of reaching such perfection of mind and body as theirs. Unlike lower Gryphon Riders, Gryphon Generals cannot be replaced easily. In addition, the link they develop with their gryphons is so strong that these noble beasts cannot live without their beloved mistresses. Therefore, a Gryphon General's mount will fight with unmatched fury and protect its rider to the death, allowing her to survive even in the most dire of situations until they both fall."
#expertleader
#inspirational 1
#hp 44
#size 5
#prot 0
#str 14
#mr 13
#mor 16
#def 13
#att 15
#prec 13
#ap 15
#mapmove 20
#enc 4
#maxage 50
#mounted
#ressize 2
#mountedhumanoid
#female
#flying
#holy
#wastesurvival
#mountainsurvival
#fireres 15
#gcost 225
#magicskill 8 1
#rpcost 2
#combatcaster
#custommagic 49536 100
#custommagic 49536 100
#custommagic 49536 20
#startage 30
#shockres 5
#woundfend 1
#weapon 596
--#weapon 651
#weapon 1149
#weapon 236
#weapon 237
#armor 123
--#armor 101
--#armor 209
#armor 7
#armor 2
#twiceborn 6545
#userestricteditem 8069
#end

#newmonster 6791
#spr1 "Hellenika/GryphonGeneral_1.tga"
#spr2 "Hellenika/GryphonGeneral_2.tga"
#name "Gryphon General"
#descr "In the Garnet tribes, gryphons are trained from birth by warrior maidens of the temples. Gryphons are large, winged beasts of tremendous ferocity. Gryphon Generals are the most experienced of these sacred warriors, exceptionally skilled commanders that also received medium ranking as mage-priestesses in the Order of Vestals. As a result, few Amazons in Zun would dream of reaching such perfection of mind and body as theirs. Unlike lower Gryphon Riders, Gryphon Generals cannot be replaced easily. In addition, the link they develop with their gryphons is so strong that these noble beasts cannot live without their beloved mistresses. Therefore, a Gryphon General's mount will fight with unmatched fury and protect its rider to the death, allowing her to survive even in the most dire of situations until they both fall."
#prophetshape 4545
#expertleader
#inspirational 1
#hp 44
#size 5
#prot 0
#str 14
#mr 13
#mor 16
#def 13
#att 15
#prec 13
#ap 15
#mapmove 20
#enc 4
#maxage 50
#mounted
#ressize 2
#mountedhumanoid
#female
#flying
#holy
#wastesurvival
#mountainsurvival
#fireres 15
#gcost 225
#magicskill 8 1
#rpcost 2
#combatcaster
#custommagic 49536 100
#custommagic 49536 100
#custommagic 49536 20
#startage 30
#shockres 5
#woundfend 1
#weapon 596
--#weapon 651
#weapon 1149
#weapon 236
#weapon 237
#armor 123
--#armor 101
--#armor 209
#armor 7
#armor 2
#twiceborn 6791
#userestricteditem 8069
#end

#newmonster 6792
#copystats 349
#spr1 "Hellenika/GoldVestal_1.tga"
#spr2 "Hellenika/GoldVestal_2.tga"
#name "Vestal Adept"
#descr "Powerful mage-priestesses of Fire, Femininity and Justice, the ever-young Vestals are the leaders of the Zunnite society. Their primary functions are to tend to the holy flames of the temples, to make the matriarchy flourish and to ensure that males are kept in check. They perform the holy sacrifices and through Blood rituals nurture the lifeblood of all Garnet Amazons. Clearly, their Order is to thank for the emergence of Zun's utopia."
#gcost 320
#maxage 90
#startage 50
#mr 16
#mor 14
#prec 14
#str 12
#hp 11
#def 14
#att 13
#clearmagic
#holy
#poorundeadleader
#magicskill 0 2
#magicskill 8 2
#custommagic 16640 100
#custommagic 16640 100
#custommagic 16768 100
#custommagic 24960 10
#twiceborn 6792
#crossbreeder 3
#clearweapons
#weapon 473
#userestricteditem 8069
#end

#newmonster 6793
#copystats 349
#spr1 "Hellenika/HighVestal_1.tga"
#spr2 "Hellenika/HighVestal_2.tga"
#name "High Vestal"
#descr "By far the mightiest sorceresses of their Order, High Vestals are queens in their own right. They bear the supreme priestly authority in the lands of Zun, and should a male touch them or look at them in the eyes without permission, he would immediately be sentenced to death, for their purity knows no equal. Their skills are instrumental to many of the sacred rituals through which the nation is destined to glory, and their magical experimentations are vital to their sisters' health, thus allowing their mere presence to prevent the most dire consequences of a lack of blood medicine in the region. In fact, all High Vestals who saw their skills in Holy magic empowered by an item are even considered as prophets for that purpose. Clearly, as the architects of magical cloning and of the Zunnite society as a whole, more than any other mortal they are to thank for the emergence of Zun's utopia."
#gcost 575
#rpcost 4
#maxage 90
#startage 57
#mr 18
#mor 16
#prec 14
#str 12
#hp 11
#def 14
#att 13
#cleararmor
#armor 148
#clearweapons
#weapon 712
#clearmagic
#holy
#poorundeadleader
#undcommand 10
#magicskill 0 3
#magicskill 8 3
#custommagic 16640 200
#custommagic 16640 100
#custommagic 24960 100
#custommagic 24960 10
#twiceborn 6793
#crossbreeder 5
#userestricteditem 8069
#end

#newmonster 7112
#spr1 "Hellenika/FireCavalry_1.tga"
#spr2 "Hellenika/FireCavalry_2.tga"
#name "Drakon Cavalry"
#descr "Even though horses are rare in the lands of Zun, the Amazons of the Garnet Tribe have no need for them. This is mainly due to their wide use of gryphons originating from the Spire of Justice as sacred mounts; but a less known fact is that the royal stables of Zun train elite purebred drakon riders whose rare mounts are famed in the whole world for their near-perfection as beasts of war and parade. Close relatives to fire drakes, Zunnite drakons are huge, scaly reptiles capable of breathing fire like dragons as well as running with the speed and agility of a jade lizard. Although they are rather stupid and cruel creatures, they still are very disciplined due to the special training they received since birth at the hands of the expert Amazon breeders of the Zunnite drakon studs, located in remote desertic regions or sometimes in deep magma caves where drakons can easily be obtained through blood magic experiments on wild fire drakes. Due to their great prestige, members of the royal Drakon Cavalry are considered sacred, but because of the highly magical nature of their mounts a High Vestal must be present in the province to recruit them."
#gcost 50
#rcost 1
#rpcost 28
#nametype 135
#hp 12
#size 3
#prot 0
#mr 14
#mor 16
#str 12
#att 12
#def 13
#prec 12
#ap 18
#mapmove 3
#enc 4
#ressize 2
#fireres 25
#coldblood
#wastesurvival
#darkvision 100
#mounted
#mountedhumanoid
#female
#startage 50
#holy
#weapon 357
#weapon 19
#weapon 676
#armor 101
#armor 123
#armor 209
#monpresentrec "High Vestal"
#end

#newmonster 6780
#spr1 "Hellenika/KnightDrakon_1.tga"
#spr2 "Hellenika/KnightDrakon_2.tga"
#name "Drakon Knight"
#descr "Highly ranked captains of the royal Drakon Cavalry of Zun, Drakon Knights are among the most feared and respected of the Amazons of the Garnet Tribe. Elite warrior maidens with great skills and experience of the battlefield, they are famed for their exotic fighting style and all received special training to be able to control the huge Drakon matriarchs they mount in combat, which also allows them to efficiently lead other warbeasts on the battlefield, particularly regular salamanders and fire drakes. Drakon matriarchs are Zunnite drakons of massive size, musculature and weight. Unlike their younger progeny, more commonly used as mounts by the Drakon Cavalry, these formidable creatures, tyrants among their kin, are slow and lazy; however, they are also capable of resisting great violence unscathed, and more than anything, their fiery breath is much more powerful than their offspring's. Truly, Drakon Knights are among the greatest war heroines of the Zunnite military of the present days. Like the Drakon Cavalry they command, they are considered sacred but can only be recruited under the presence of a High Vestal."
#gcost 165
#rcost 1
#rpcost 3
#nametype 135
#hp 44
#size 4
#prot 12
#mr 16
#mor 18
#str 18
#att 14
#def 10
#prec 10
#ap 18
#mapmove 3
#enc 4
#ressize 2
#fireres 25
#coldblood
#wastesurvival
#darkvision 100
#mounted
#mountedhumanoid
#female
#startage 50
#goodleader
#command -20
#inspirational 1
#holy
#magicskill 8 1
#custommagic 16512 40
#custommagic 16512 40
#researchbonus -4
#beastmaster 3
#weapon 20
#weapon 357
#weapon 567
#armor 101
#armor 123
#armor 209
#monpresentrec "High Vestal"
#twiceborn 6780
#userestricteditem 8069
#end

#newmonster 7113
#copystats 431
#copyspr 431
#name "Makedonian Scout"
#descr "Scouts are trained to pass unseen through enemy territory and to travel efficiently even in mountainous and forested terrain. Their reports on enemy army movements and the resources in enemy lands are invaluable to the prudent warlord."
#nametype 107 -- arco male
#rpcost 1
#end

#newmonster 7114
#copystats 2260 -- Berytian Lancer
#spr1 "./Hellenika/mountedcaptain1.tga"
#spr2 "./Hellenika/mountedcaptain2.tga"
#name "Makedonian Mounted Captain"
#descr "Rising up from the ranks of the Makedonian Cavalry, this man is a skilled commander and tactician from his many years in the royal service. Most are from a Kaeonian background or have fought against other barbarians, and have learned how to navigate forests and mountains from many campaigns in the north of the kingdom."
#weapon 1143
#weapon 645
#weapon 56
#armor 2
#armor 183
#armor 135
#size 3
#ressize 2
#okleader
#gcost 10015
#rcost 4
#command 20
#mor 13
#mapmove 20
#nametype 107
#forestsurvival
#mountainsurvival
#rpcost 1
#nametype 107 -- arco male
#end

#newmonster 7115
#copystats 1081
#spr1 "Hellenika/thracianchiefwounded1.tga"
#spr2 "Hellenika/thracianchiefwounded2.tga"
#name "Kaeonian Warchief"
#descr "Influential and particularly warlike tribal chieftans are sought out by the kingdom in order to keep the frontier secure, and convince other tribal kingdoms to capitulate to Makedonian conquest."
#cleararmor
#clearweapons
#startage 40
#hp 13
#att 12
#def 12
#str 12
#enc 3
#mor 13
#mr 12
#firstshape 4757
#armor 142
#armor 135
#weapon 1148
#goodleader
#rcost 1
#mapmove 20
#nametype 107
#gcost 10000
#rpcost 1
#nametype 131 -- EA ulm male
#forestsurvival
#mountainsurvival
#end

#newmonster 6757
#copystats 365
#spr1 "Hellenika/thracianchief1.tga"
#spr2 "Hellenika/thracianchief2.tga"
#name "Kaeonian Warchief and Attendant"
#descr "Influential and particularly warlike tribal chieftans are sought out by the kingdom in order to keep the frontier secure, and convince other tribal kingdoms to capitulate to Makedonian conquest. If the chariot attendant dies, another one will take his place so long as the warchief does not perish."
#cleararmor
#clearweapons
#startage 40
#hp 13
#att 11
#def 11
#str 12
#enc 3
#mor 13
#mr 12
#secondshape "Kaeonian Warchief"
#armor 142
#armor 135
#armor 207
#weapon 1148
#weapon 643
#weapon 21
#goodleader
#prec 11
#rcost 1
#mapmove 20
#nametype 107
#gcost 10000
#rpcost 1
#nametype 131 -- EA ulm male
#forestsurvival
#mountainsurvival
#end

#newmonster 7116
#spr1 "./Hellenika/thraciansage1.tga"
#spr2 "./Hellenika/thraciansage2.tga"
#copystats 1188 --mystic
#name "Kaeonian Seer"
#descr "From their many years in the wilds interpreting the signs of the gods, the seers have learned the art of reading omens and birdsign. While the proud Makedonians might not admit it outright, many nobles consult with the sages and seers to make sure the stars and omens favour them before any major decisions are made."
#clearmagic
#cleararmor
#clearweapons
#startage 30
#weapon 674
#armor 44
#magicskill 4 1
#nobadevents 5
#forestsurvival
#mountainsurvival
#nametype 131 -- EA ulm male
#gcost 10010
#rpcost 2
#end

#newmonster 7117
#spr1 "./Hellenika/thracianelder1.tga"
#spr2 "./Hellenika/thracianelder2.tga"
#copystats 311
#name "Sage of the Wilds"
#descr "The eldest members of the seers do not rely on mere omens, but have withdrawn deep into study and attempt to read the sacred earth-current and will of the forest. Rumors abound in the Royal Court that these humble sages are not what they seem, and that they select promising noble youths for induction into the cult of heroes. Sages of the Wilds know the secret of how to cast the Transformation ritual."
#clearmagic
#clearweapons
#cleararmor
#clearspec
#startage 45
#weapon 7
#armor 44
#armor 120
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 1
#nobadevents 10
#holy
#custommagic 11264 100
#forestsurvival
#mountainsurvival
#nametype 131
#gcost 145
#rpcost 4
#montag 4153 -- can cast Transformation
#end

#newmonster 7118
#name "Kaeonian Warsmith"
#spr1 "./Hellenika/thraciansmith1.tga"
#spr2 "./Hellenika/thraciansmith2.tga"
#descr "Smiths deep from the Kaeonian mountains answer the call for skilled forgers in the royal army. With the barbarian kingdoms subjugated under Makedonian rule, many have moved south for good wages and steady work that the warring kingdom brings. They also tell tales of a faraway barbarian kingdom ruled by smiths and shamans even more talented than they are."
#magicskill 3 1
#custommagic 1920 100
#custommagic 1920 20
#mr 15
#mor 14
#mapmove 14
#armor 142
#armor 135
#weapon 1148
#enc 3
#poorleader
#resources 5
#fixforgebonus 1
#rcost -10
#forestsurvival
#mountainsurvival
#nametype 131
#gcost 125
#rpcost 2
#end

#newmonster 7119
#spr1 "./Hellenika/sacredpikecommander1b.tga"
#spr2 "./Hellenika/sacredpikecommander2b.tga"
#name "Sacred Band Commander"
#descr "While the cult of heroes primarily appeals to members of the well-off warrior-aristocracy, the Sacred Band was founded as a volunteer corps of elite hoplites in order to give the lowborn the chance to fight for glory and prove their valour in the name of the awakening god. Its commanders are low-ranking priests, skilled warriors and experienced phalanx leaders."
#hp 13
#att 12
#def 14
#str 12
#enc 3
#formationfighter 2
#mor 15
#mr 10
#holy
#goodleader
#magicskill 8 1
#combatcaster
#mapmove 14
#weapon 1200
#armor 209
#armor 100
#armor 135
#gcost 95
#rcost 1
#rpcost 1
#end

#newmonster 7120 -- duplicate for heroic manifestation
#spr1 "./Hellenika/horselord1.tga"
#spr2 "./Hellenika/horselord2.tga"
#name "Hero Cult Champion"
#descr "Those who have proven their worth to the cult of heroes by slaying many mighty beasts, or currying favor of the gods are blessed with skills and magical power beyond their mortal capabilities. Many are rumored to trace their bloodline to the ancient heroes themselves, or the sons of the titans."
#prophetshape 4761
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#hp 15
#mr 17
#mor 14
#str 13
#att 14
#def 16
#prec 14
#magicskill 1 2
#magicskill 3 1
#magicskill 8 1
#magicboost 8 1
#magicboost 1 1
#magicboost 3 1
#inspirational 1
#startage 30
#ap 22
#heal
#goodleader
#holy
#mounted
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 799
#armor 123
#rcost 1
#nametype 107
#gcost 240
#mapmove 24
#nametype 107
#combatcaster
#nowish
#montag 4116
#end

#newmonster 6758
#spr1 "./Hellenika/sacredcavwarrior1.tga"
#spr2 "./Hellenika/sacredcavwarrior2.tga"
#name "Makedonian Noble"
#descr "Sons of Makedonian nobles worship at the altars of heroes long dead, and follow their example by learning of combat and magic. They are inductees into the cult of heroes, and may gain skill and magical power through battle. These powerful battlemages form the bulk of the warrior-aristocracy of Makedon, and every martial clan boasts of their blood ties and history connecting them to the ancient heroes. However, their pride means that only a warlord of truly heroic might will inspire their respect and be able to unite them in his army. As a result, Makedonian Nobles can only be recruited if a Champion of Heroes, a Hero Cult Champion, or a sacred champion of even greater fame is currently controlled by Makedon; until then, they will wait for the one whom the gods have chosen to lead them to glory. While they are not usually of Kaeonian heritage, many wear a Kaeonian-style cape after spending many years training in the wilds."
#prophetshape 4759
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#hp 14
#mr 14
#mor 13
#str 12
#att 12
#def 12
#prec 12
#ap 22
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#woundfend 1
#startage 30
#goodleader
#holy
#mounted
#weapon 1144
#weapon 645
#weapon 56
#armor 2
#armor 100
#armor 135
#rcost 1
#nametype 107
#gcost 240
#xpshape 50
#rpcost 2
#mapmove 24
#nametype 107
#combatcaster
#ownsmonrec -4116
#end

#newmonster 6759
#spr1 "./Hellenika/sacredcavcommander1.tga"
#spr2 "./Hellenika/sacredcavcommander2.tga"
#name "Hero Cult Aspirant"
#descr "This champion of the gods has distinguished himself in battle, and has gained holy power from the heroes of old. He follows faithfully in the footsteps of ancient heroes, and emulates their example."
#prophetshape 4760
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#hp 15
#mr 17
#mor 14
#str 13
#att 14
#def 16
#prec 14
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#magicboost 1 1
#startage 30
#ap 22
#heal
#goodleader
#holy
#mounted
#weapon 1144
#weapon 645
#weapon 56
#armor 2
#armor 100
#armor 135
#rcost 1
#nametype 107
#gcost 240
#xpshape 100
#rpcost 2
#mapmove 24
#nametype 107
#combatcaster
#nowish
#end

#newmonster 6760
#spr1 "./Hellenika/horselord1.tga"
#spr2 "./Hellenika/horselord2.tga"
#name "Hero Cult Champion"
#descr "Those who have proven their worth to the cult of heroes by slaying many mighty beasts, or currying favor of the gods are blessed with skills and magical power beyond their mortal capabilities. Many are rumored to trace their bloodline to the ancient heroes themselves, or the sons of the titans."
#prophetshape 4761
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#hp 15
#mr 17
#mor 14
#str 13
#att 14
#def 16
#prec 14
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#magicboost 8 1
#magicboost 1 1
#magicboost 3 1
#inspirational 1
#startage 30
#ap 22
#heal
#goodleader
#holy
#mounted
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 799
#armor 123
#rcost 1
#nametype 107
#gcost 240
#xpshape 175
#mapmove 24
#nametype 107
#combatcaster
#nowish
#montag 4116
#end

#newmonster 6761
#spr1 "./Hellenika/championcav1.tga"
#spr2 "./Hellenika/championcav2.tga"
#name "Hero Cult Exalted Champion"
#descr "This hero among mortals has begun to attract the attention of the lower divinities. Rumors abound that he might be the son of the high gods themselves."
#prophetshape 4762
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#hp 20
#mr 17
#mor 16
#str 14
#att 15
#def 16
#prec 14
#startage 30
#ap 22
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#magicboost 8 1
#magicboost 3 1
#magicboost 1 2
#inspirational 1
#awe 1
#heal
#expertleader
#holy
#mounted
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 801
#armor 123
#rcost 1
#nametype 107
#gcost 240
#mapmove 24
#nametype 107
#xpshape 250
#combatcaster
#nowish
#montag 4116
#end

#newmonster 6762
#spr1 "./Hellenika/sonofthegods1.tga"
#spr2 "./Hellenika/sonofthegods2.tga"
#name "Son of Demigods"
#descr "After butchering countless enemies and standing atop a pile of their skulls, this champion of the hero cult has had his divine parentage noticed, but not yet acknowledged, the only step left for him to complete his ascension. Now begins for him the wait..."
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#domimmortal
#reformtime 9
#hp 20
#mr 17
#mor 16
#str 14
#att 15
#def 16
#prec 14
#startage 30
#ap 22
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#magicboost 8 1
#magicboost 3 1
#magicboost 1 2
#inspirational 1
#awe 1
#heal
#expertleader
#holy
#mounted
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 801
#armor 123
#rcost 1
#nametype 107
#gcost 240
#mapmove 24
#nametype 107
#combatcaster
#nowish
#montag 4116
#end

#newmonster 6593
#spr1 "./Hellenika/sonofthegods1.tga"
#spr2 "./Hellenika/sonofthegods2.tga"
#name "Son of the Gods"
#descr "After butchering countless enemies and standing atop a pile of their skulls, this champion of the hero cult has had his divine parentage acknowledged. He and his few brothers lead the Hero Cult of Makedon, and fight against whole armies singlehandedly. Mortal men look upon him with awe, and few would dare to strike an acknowledged son of the gods."
#cleararmor
#clearweapons
#clearmagic
#size 3
#ressize 2
#enc 4
#immortal
#reformtime 9
#hp 30
#mr 18
#mor 20
#str 16
#att 17
#def 18
#prec 15
#startage 30
#ap 22
#magicskill 1 1
#magicskill 3 1
#magicskill 8 1
#magicboost 1 3
#magicboost 3 2
#magicboost 8 1
#inspirational 2
#woundfend 1
#spreaddom 1
#awe 3
#fear 5
#heal
#expertleader
#holy
#mounted
#weapon 1145 
#weapon 1147
#weapon 56
#armor 71
#armor 801
#armor 123
#rcost 1
#nametype 107
#gcost 240
#mapmove 24
#nametype 107
#combatcaster
#nowish
#montag 4116
#end

#newmonster 7121 -- DO NOT MOVE OR CHANGE ID (xpshape)
#copystats 1075
#spr1 "./Hellenika/bellerophon1.tga"
#spr2 "./Hellenika/bellerophon2.tga"
#name "Lord of Heroes"
#descr "Many adherents of the hero cults of Makedon are descended from the bloodlines of the ancient heroes themselves. This Lord of Heroes has proven his skill in battle time and time again, and rides a sacred pegasus. Part of the initiation into the higher-tier of the cult of heroes is to participate into a daring raid either on Mount Cephalos or the Amazons of the Crystal Tribe, and steal a beautiful pegasus for themselves. Only the most cunning and daring can sneak deep into the heart of a rival city state, and emerge with such a glorious prize. They are powerful warriors and mages, and inspire feats of bravery from those who follow them into battle."
#cleararmor
#clearweapons
#clearmagic
#itemslots 13446
#size 4
#ressize 2
#enc 4
#hp 15
#mr 17
#mor 14
#str 13
#att 14
#def 16
#prec 14
#magicskill 1 3
#magicskill 3 1
#magicskill 8 2
#woundfend 1
#holy
#expertleader
#mounted
#inspirational 1
#weapon 1144
#weapon 645
#weapon 56
#armor 2
#armor 100
#armor 135
#startage 30
#xpshape 125
#gcost 405
#rpcost 4
#mapmove 24
#end

#newmonster 7122 -- DO NOT MOVE OR CHANGE ID (xpshape)
#copystats 1075
#spr1 "./Hellenika/bellerophonchosen1.tga"
#spr2 "./Hellenika/bellerophonchosen2.tga"
#name "Champion of Heroes"
#descr "This hero among mortals has begun to attract the attention of the lower divinities. This Lord of Heroes has proven himself in battle, and has gained magic power and the favour of the gods."
#cleararmor
#clearweapons
#clearmagic
#itemslots 13446
#size 4
#ressize 2
#enc 4
#hp 20
#mr 17
#mor 16
#str 14
#att 15
#def 16
#prec 14
#magicskill 1 3
#magicskill 3 1
#magicskill 8 2
#magicboost 1 1
#magicboost 3 1
#heal
#holy
#mounted
#goodleader
#awe 1
#inspirational 1
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 799
#armor 123
#startage 30
#xpshape 250
#gcost 405
#mapmove 24
#nowish
#montag 4116
#end

#newmonster 7123 -- DO NOT MOVE OR CHANGE ID (xpshape)
#copystats 1075
#spr1 "./Hellenika/bellerophongods1.tga"
#spr2 "./Hellenika/bellerophongods2.tga"
#name "Demigod Elect"
#descr "After butchering countless enemies and standing atop a pile of their skulls, this champion of the hero cult has had his divine parentage noticed, but not yet acknowledged, the only step left for him to complete his ascension. Now begins for him the wait..."
#cleararmor
#clearweapons
#clearmagic
#itemslots 13446
#size 4
#ressize 2
#enc 4
#domimmortal
#reformtime 9
#hp 20
#mr 17
#mor 16
#str 14
#att 15
#def 16
#prec 14
#magicskill 1 3
#magicskill 3 1
#magicskill 8 2
#magicboost 1 1
#magicboost 3 1
#heal
#holy
#mounted
#goodleader
#awe 1
#inspirational 1
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 799
#armor 123
#startage 30
#gcost 405
#mapmove 24
#nowish
#montag 4116
#end

#newmonster 6597 -- DO NOT MOVE OR CHANGE ID (xpshape)
#copystats 1075
#spr1 "./Hellenika/bellerophongods1.tga"
#spr2 "./Hellenika/bellerophongods2.tga"
#name "Demigod Incarnate"
#descr "After butchering countless enemies and standing atop a pile of their skulls, this champion of the hero cult has had his divine parentage acknowledged. He and his few brothers lead the Hero Cult of Makedon, and fight against whole armies singlehandedly. Mortal men look upon him with awe, and few would dare to strike an acknowledged son of the gods."
#cleararmor
#clearweapons
#clearmagic
#itemslots 13446
#size 4
#ressize 2
#enc 4
#immortal
#reformtime 9
#hp 30
#mr 18
#mor 20
#str 16
#att 17
#def 18
#prec 15
#startage 30
#magicskill 1 3
#magicskill 3 1
#magicskill 8 2
#magicboost 1 2
#magicboost 3 2
#inspirational 2
#woundfend 1
#spreaddom 1
#awe 3
#fear 5
#heal
#expertleader
#holy
#mounted
#weapon 1145 
#weapon 1147
#weapon 56
#armor 71
#armor 801
#armor 123
#rcost 1
#nametype 107
#gcost 405
#mapmove 24
#nowish
#montag 4116
#end

#newmonster 6841 -- duplicate for heroic manifestation
#copystats 1075
#spr1 "./Hellenika/bellerophonchosen1.tga"
#spr2 "./Hellenika/bellerophonchosen2.tga"
#name "Champion of Heroes"
#descr "This hero among mortals has begun to attract the attention of the lower divinities. This Lord of Heroes has proven himself in battle, and has gained magic power and the favour of the gods."
#cleararmor
#clearweapons
#clearmagic
#itemslots 13446
#size 4
#ressize 2
#enc 4
#hp 20
#mr 17
#mor 16
#str 14
#att 15
#def 16
#prec 14
#magicskill 1 3
#magicskill 3 1
#magicskill 8 2
#magicboost 1 1
#magicboost 3 1
#heal
#holy
#mounted
#goodleader
#awe 1
#inspirational 1
#weapon 1144
#weapon 1146
#weapon 56
#armor 71
#armor 799
#armor 123
#startage 30
#gcost 405
#mapmove 24
#nowish
#montag 4116
#end

#newmonster 7124
#spr1 "Hellenika/WindRiderEx1lord.tga"
#spr2 "Hellenika/WindRiderEx2lord.tga"
#copystats 1075
#name "Wind Lord Prophet"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders. Sometimes a youngster arriving at Mount Cephalos for martial training is approached by pegasi. These blessed ones are given special status and priestly training otherwise restricted to women. After years of rigorous training they become priest commanders of the wind riders and receive a golden lance blessed with some of the wondrous properties from all of the four lesser types of Wind Rider weapons. When appointed as prophets, Wind Lords become great heroes of such nobility that they are permitted to enter the Awakening God's sanctum on the summit of Mount Cephalos. This allows them to bring back one Air gem per month to the people as sacred gifts from the Celestial powers."
#gemprod 1 1
#mor 15
#mr 14
#str 13
#att 14
#clearweapons
#weapon 1115
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#selectmonster 1075
#spr1 "Hellenika/WindRiderEx1lord.tga"
#spr2 "Hellenika/WindRiderEx2lord.tga"
#name "Wind Lord"
#descr "During the Golden Era, there were still pegasi living on the cloudy peaks of Mount Cephalos. The pegasi are captured and brought to the temple at the base of the mountain, where they are trained as mounts for the Wind Riders. Sometimes a youngster arriving at Mount Cephalos for martial training is approached by pegasi. These blessed ones are given special status and priestly training otherwise restricted to women. After years of rigorous training they become priest commanders of the wind riders and receive a golden lance blessed with some of the wondrous properties from all of the four lesser types of Wind Rider weapons. When appointed as prophets, Wind Lords become great heroes of such nobility that they are permitted to enter the Awakening God's sanctum on the summit of Mount Cephalos. This allows them to bring back one Air gem per month to the people as sacred gifts from the Celestial powers."
#prophetshape "Wind Lord Prophet"
#mor 15
#mr 14
#str 13
#att 14
#clearweapons
#weapon 1115
#weapon 56
#cleararmor
#armor 879
#armor 123
#armor 2
#end

#newmonster 7125
#name "Knossian Raider Chief"
#descr "Many Knossians turn to piracy and banditry and are employed by the nobles and Bull Kings as mercenaries to harass their foes. The Raider Chief is a prominent outlaw leader who rose to his position through both brutality and cunning."
#spr1 "./Hellenika/raiderchief1.tga"
#spr2 "./Hellenika/raiderchief2.tga"
#mr 10
#incunrest 3
#swimming
#stealthy 0
#weapon 645 -- bronze sword
#weapon 21 -- javelin
#armor 5
#armor 120
#armor 1 -- buckler
#nametype 107
#chaosrec 5
#gcost 10030
#rpcost 1
#hp 12
#str 11
#att 11
#def 11
#prec 11
#enc 3
#mor 11
#sailing 999 2
#pillagebonus 5
#incunrest 10
#end

#newmonster 7126
#name "Knossian Commander"
#descr "The lower ranking commanders of the Knossian armies are not nobles. They are armed and armored like the Royal Axemen and decorate their helms with horns to be recognized on the battlefield and imitate the nobility. Their leadership skills are unremarkable, but they are capable sailors."
#spr1 "./Hellenika/commander1.tga"
#spr2 "./Hellenika/commander2.tga"
#prec 10
#mr 10
#enc 3
#nametype 107
#str 11
#att 11
#def 11
#mor 13
#bodyguard 2
#weapon 1240
#armor 100 -- bronze cuirass
#armor 135
#gcost 10010
#hp 13
#okleader
#command 20
#sailing 999 2
#rpcost 1
#end

#newmonster 7127
#name "Ijereja"
#descr "The Ijereja is a low-ranking Knossian priestess, a woman of common birth given limited religious authority and training in the magic of the natural world and herbal healing.
The priestesses of Knoss are not trained in blood magic and are ritually banned from performing sacrifices, a task left to the male priesthood. An Ilereja who breaks this taboo and performs blood sacrifice will cause the province to suffer slight unrest."
#spr1 "./Hellenika/ijereja1.tga"
#spr2 "./Hellenika/ijereja2.tga"
#gcost 9990
#rpcost 2
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mr 13
#mor 10
#enc 3
#weapon "Bronze Dagger"
#armor "Robes"
#female
#holy
#magicskill 6 1
#magicskill 8 1
#custommagic 1408 100
#poorleader
#sailing 999 2
#autodishealer 1
#nametype 108
#userestricteditem 8069
#twiceborn 6675
#end

#newmonster 7128
#name "Kleiduchos"
#descr "The Kleiduchos is an influential Knossian priestess, a woman of noble but not royal birth who has been granted significant religious authority and training in the magic of the natural world and herbal healing.
The priestesses of Knoss are not trained in blood magic and are ritually banned from performing sacrifices, a task left to the male priesthood. A Kleiduchos who breaks this taboo and performs blood sacrifices will cause the province to suffer some unrest."
#spr1 "./Hellenika/kleiduchos1.tga"
#spr2 "./Hellenika/kleiduchos2.tga"
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mor 10
#enc 3
#weapon "Bronze Dagger"
#armor "Robes"
#female
#holy
#magicskill 6 1
#magicskill 8 1
#poorleader
#sailing 999 2
#gcost 245
#rpcost 2
#mr 15
#autodishealer 2
#nametype 108
#magicskill 6 2
#magicskill 8 2
#custommagic 1408 200
#userestricteditem 8069
#twiceborn 6675
#end

#newmonster 7129
#name "Wanassa"
#descr "The Wannasa is a priest-queen and the highest religious authority on Knoss together with their consort, the Wanax.
Born in the royal family and given extensive training in magic and herbal healing, they are powerful sorceresses with impressive control over nature and the elements of earth, wind and sun. They also possess some authority in military and occasionally lead small armies in battle, though they prefer to let their consorts handle these matters.
The priestesses of Knoss are not trained in blood magic and are ritually banned from performing sacrifices, a task left to the male priesthood. A Wanassa who breaks this taboo and performs blood sacrifices will cause the province to suffer significant unrest."
#spr1 "./Hellenika/wanassa1.tga"
#spr2 "./Hellenika/wanassa2.tga"
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mor 10
#enc 3
#weapon "Bronze Dagger"
#armor "Robes"
#female
#holy
#sailing 999 2
#nametype 108
#gcost 365
#rpcost 4
#mr 18
#magicskill 6 3
#magicskill 8 3
#custommagic 1408 200
#custommagic 9600 100
#okleader
#autodishealer 3
#userestricteditem 8069
#twiceborn 6675
#end

#newmonster 7130
#name "Ijereu"
#descr "The Ijereu is a low-ranking Knossian priest, a man of common birth given limited religious authority and training in magic and ritual sacrifice. As they are not nobles they are not cursed, but wear bronze bull masks to honor and imitate their superiors. "
#spr1 "./Hellenika/ijereu1.tga"
#spr2 "./Hellenika/ijereu2.tga"
#gcost 10010
#rpcost 2
#hp 10
#str 10
#att 10
#def 10
#prec 10
#mr 13
#mor 11
#enc 3
#weapon "Bronze dagger"
#armor "Robes"
#armor "Mask"
#holy
#sailing 999 2
#poorleader
#magicskill 7 1
#magicskill 8 1
#custommagic 9344 100 -- FEN
#nametype 107
#end

#newmonster 7131
#name "Archegos"
#descr "A long time ago the noblemen of Knoss were cursed with bull heads and bestial tempers and hungers as punishment for their bloody sins and blasphemous hubris. The Archegos or Bull Prince, is a noble and bearer of the curse. An influental mage-priest, he has considerable physical and magical prowess and some skill in military matters, often leading war parties in raids and attacks on enemy coasts. In addition, he has learnt how to channel his gluttony and hunger for power into a cruel magical art which allows him to cast spells twice as quickly as most other mages."
#spr1 "./Hellenika/archegos1.tga"
#spr2 "./Hellenika/archegos2.tga"
#gcost 255
#rpcost 2
#hp 15
#prot 2
#str 13
#att 12
#def 12
#enc 2
#mr 16
#mor 14
#enc 2
#weapon 1241
#weapon 331 -- gore
#armor "Bronze cuirass"
#holy
#sailing 999 2
#nametype 107
#goodleader
#magicskill 7 2
#magicskill 8 2
#custommagic 9344 200 -- FEN
#maxage 100
#older -40
#berserk 4
#popkill 2
#combatcaster
#fastcast 100
#pillagebonus 5
#end

#newmonster 7132
#name "Wanax"
#descr "A long time ago the noblemen of Knoss were cursed with bull heads and bestial tempers and hungers as punishment for their bloody sins and blasphemous hubris. The Wanax or Bull King is a noble of the highest rank and bearer of the curse. He is the highest religious and temporal authority in Knoss together with his consort the Wanassa. The Wanax also has extraordinary physical and magical powers and is skilled in military matters, leading major invasions and attacks against the coasts of enemy nations. In addition, he has learnt how to channel his gluttony and hunger for power into a cruel magical art which allows him to cast spells twice as quickly as most other mages."
#spr1 "./Hellenika/wanax1.tga"
#spr2 "./Hellenika/wanax2.tga"
#prot 2
#str 13
#enc 2
#weapon 1241
#weapon 331 -- gore
#holy
#sailing 999 2
#nametype 107
#goodleader
#berserk 4
#gcost 385
#rpcost 4
#hp 18
#att 13
#def 13
#mr 18
#mor 15
#armor "Bronze Cuirass"
#armor "Crown"
#expertleader
#magicskill 7 3
#magicskill 8 3
#custommagic 9344 200 -- FEN
#custommagic 25728 100 -- FENB
#maxage 125
#older -90
#popkill 3
#userestricteditem 8064
#combatcaster
#fastcast 100
#end

#newmonster 7362
#name "Arch Wanax"
#descr "A long time ago the noblemen of Knoss were cursed with bull heads and bestial tempers and hungers as punishment for their bloody sins and blasphemous hubris. The Wanax or Bull King is a noble of the highest rank and bearer of the curse. He is the highest religious and temporal authority in Knoss together with his consort the Wanassa. The Wanax also has extraordinary physical and magical powers and is skilled in military matters, leading major invasions and attacks against the coasts of enemy nations. In addition, he has learnt how to channel his gluttony and hunger for power into a cruel magical art which allows him to cast spells twice as quickly as most other mages."
#spr1 "./Hellenika/wanax1.tga"
#spr2 "./Hellenika/wanax2.tga"
#prot 2
#str 13
#enc 2
#weapon 1241
#weapon 331 -- gore
#holy
#sailing 999 2
#nametype 107
#goodleader
#berserk 4
#gcost 385
#rpcost 4
#hp 18
#att 13
#def 13
#mr 18
#mor 15
#armor "Bronze Cuirass"
#armor "Crown"
#expertleader
#magicskill 7 3
#magicskill 8 3
#custommagic 9344 200 -- FEN
#custommagic 25728 100 -- FENB
#magicboost 53 2
#popkill 3
#userestricteditem 8064
#combatcaster
#fastcast 100
#end

#newmonster 7133
#skirmisher 0
#name "Chief Dancer"
#descr "Sacred dancers of exceptional skill and devotion are sometimes granted limited religious authority and allowed to lead a limited number of troops. Some even develop skill in Nature magic through their sacred connection to the animal world. Their primary function in times of peace is to train new initiates in the temples, and those who master magical lore may even form their own mystical circles to train acolytes of their own."
#spr1 "./Hellenika/chiefdancer1.tga"
#spr2 "./Hellenika/chiefdancer2.tga"
#gcost 10014
#rpcost 9997
#prec 10
#enc 2
#ap 14
#weapon 1141 -- fatiguing blow
#holy
#swimming
#formationfighter -2
#itemslots 12288
#nametype 107
#hp 13
#str 11
#att 12
#def 16
#mr 13
#mor 14
#animalawe 2
#poorleader
#inspirational 1
#magicskill 8 1
#custommagic 8192 20
#templetrainer "Temple Dancer"
#sleepaura 5
#end

#newmonster 7134
#copystats 517 -- Black Hawk
#spr1 "Hellenika/SilverHawk1.tga"
#spr2 "Hellenika/SilverHawk2.tga"
#name "Silver Hawk"
#descr "Great hawks are large predator birds of uncanny intellect. They are often found in hidden mountain valleys where they impose themselves as rulers over lesser birds. Known for its great nimbleness and talons of sharp metal, their silver variety is very common in the lands of Thalamanth and is led by kings of large size."
#mor 10
#def 16
#enc 1
#str 6
#airshield 50
#bird
#clearweapons
#weapon 753
#weapon 1106
#end

#newmonster 7135
#copystats 451 -- Horse Brother Cmdr
#spr1 "./Hellenika/WindTribeChief.tga"
#spr2 "./Hellenika/WindTribeChief2.tga"
#name "Wind Tribe Chieftain"
#descr "Chieftains are the warchiefs of unimportant Wind Tribe clans where women warriors have less power. They take their position by reputation and competence, and they are tolerated by the Amazons because they don't meddle with women's affairs and are otherwise loyal servants of the Crystal Ark. They proudly lead troops of the Wind Tribe in battle like the Wind leads their arrows to the hearts of their enemies, and their colorful feather standards make them look like sacred winged beings, inspiring their followers. Minor chieftains such as this one are commonly ordered to establish relays for horses and their riders in the vast plains and steppes that surround Thalamanth. Should they do so, they would become too busy with ruling such settlements to take a direct part in war, but they would permanently develop the province's resources and supplies in the form of a new local site until a fortress replaces it. The usual way to perform such a task is to ask the chieftain to search for magic sites in any dry land province that isn't equipped with a fortress or a relay yet."
#nametype 100
#weapon 1
#weapon 264
#armor 15
#armor 20
#armor 1
#att 11
#prec 10
#inspirational 1
#batstartsum1 "Silver Hawk"
#rpcost 1
#mountedhumanoid
#magicskill 1 1
#magicboost 1 -2
#noreqlab
#gcost 60
#end

#newmonster 7136
#spr1 "Hellenika/Monk_1C.tga"
#spr2 "Hellenika/Monk_2C.tga"
#name "Cloud Monk"
#descr "Cloud Monks are young disciples of the Cloud Sages that often live in reclusive monasteries in the mountains, learning the hidden truths of the universe and helping their masters achieve greater knowledge. However, once they know some magic, many of them instead choose to roam the kingdom, to continuously journey from a village to the next, and to help people on their way as much as they can. Although they are disciplined and humble members of their orders, in a way they love freedom and movement as much as the wind from which they draw their inspiration and magic. Thus, they are loved by the people and now represent an emblematic part of Thalamanth's syncretic culture. They can be recruited in every mountain and highland, even without laboratories."
#nametype 121
#hp 9
#size 2
#prot 0
#mr 14
#mor 12
#str 9
#att 8
#def 8
#prec 10
#enc 1
#mapmove 14
#ap 10
#gcost 70
#rcost 1
#weapon 92
#maxage 50
#startage 20
#noleader
#shockres 5
#fixedresearch 6
#researchbonus -1
#custommagic 256 80
#custommagic 256 15
#rpcost 1
#snow
#mountainsurvival
#stormimmune
#end

#newmonster 7137
#spr1 "Hellenika/Sage_1C.tga"
#spr2 "Hellenika/Sage_2C.tga"
#name "Cloud Sage"
#descr "The Cloud Sages of Thalamanth are powerful and spiritual mages of air that came from the Far East a few decades ago following the foretellings of their three Most-Wise-Kings. Upon separately prophesying the awakening of the God, the Most-Wise-Kings gathered their disciples and led them on a very long journey to the Crystal Tribe Amazons. The Cloud Sages are the greatest of the Cloud Monks, the Most-Wise-Kings' disciples, and lead their monasteries in the mountains, represent them where they need to be represented, and even sometimes serve as administrators of remote regions on behalf of the Amazons. As such, they can be hired in every fort where the necessary preparations for the use of magic have been made. But they are before anything else great erudites and teachers and brought many mystical secrets with them from the East. Only they know how to cut a piece of the sky to forge a Sky Shard, which will serve as a powerful air gem generator for its bearer; how to reforge the Regalia of the Sky for the elemental Queens of Air if they should be released from their prisons; and how to infuse with mystical powers the three holy gifts of their kings for them to use once again. Thanks to their mystical attunement to the Wind, they have also found ways to contact and befriend many powerful creatures of Thalamanth's sky. Finally, they sometimes teach the shamans of the Wind Tribe how to speak to the birds as they do. Entirely devoted to their new kingdom and its God, they are humble goodmakers and today no-one doubts their place in Thalamanth."
#nametype 121
#hp 9
#prot 0
#mr 18
#mor 13
#str 9
#att 8
#def 8
#prec 12
#enc 1
#mapmove 14
#ap 10
#gcost 230
#rcost 1
#weapon 92
#maxage 50
#poorleader
#stormpower 3
#researchbonus 3
#magicskill 1 3
#custommagic 256 33
#montag 4161
#rpcost 3
#shockres 5
#snow
#mountainsurvival
#end

#newmonster 7138
#spr1 "Hellenika/Sage_1C.tga"
#spr2 "Hellenika/Sage_2C.tga"
#name "Cloud Sage"
#descr "The Cloud Sages of Thalamanth are powerful and spiritual mages of air that came from the Far East a few decades ago following the foretellings of their three Most-Wise-Kings. Upon separately prophesying the awakening of the God, the Most-Wise-Kings gathered their disciples and led them on a very long journey to the Crystal Tribe Amazons. The Cloud Sages are the greatest of the Cloud Monks, the Most-Wise-Kings' disciples, and lead their monasteries in the mountains, represent them where they need to be represented, and even sometimes serve as administrators of remote regions on behalf of the Amazons. As such, they can be hired in every fort where the necessary preparations for the use of magic have been made. But they are before anything else great erudites and teachers and brought many mystical secrets with them from the East. Only they know how to cut a piece of the sky to forge a Sky Shard, which will serve as a powerful air gem generator for its bearer; how to reforge the Regalia of the Sky for the elemental Queens of Air if they should be released from their prisons; and how to infuse with mystical powers the three holy gifts of their kings for them to use once again. Thanks to their mystical attunement to the Wind, they have also found ways to contact and befriend many powerful creatures of Thalamanth's sky. Finally, they sometimes teach the shamans of the Wind Tribe how to speak to the birds as they do. Entirely devoted to their new kingdom and its God, they are humble goodmakers and today no-one doubts their place in Thalamanth."
#nametype 121
#hp 9
#prot 0
#mr 18
#mor 13
#str 9
#att 8
#def 8
#prec 12
#enc 1
#mapmove 14
#ap 10
#gcost 260
#rcost 1
#weapon 92
#maxage 50
#poorleader
#stormpower 3
#researchbonus 3
#magicskill 1 3
#custommagic 256 33
#montag 4124 -- for Isphenople
#rpcost 3
#shockres 5
#snow
#mountainsurvival
#firstshape "Cloud Sage"
#end

#newmonster 7139
#spr1 "./Hellenika/Strategis_1l.tga"
#spr2 "./Hellenika/Strategis_2l.tga"
#name "Strategis Prophet"
#descr "Crystal Strategis are the greatest of all Amazon warriors. Not only are they formidable opponents in their own right, they are also great leaders, clever conquerors and subtle tacticians, and their spirit is as strong and swift as their body. As direct representatives of the council of Pythias and as flying guardians of the sky, they bear great authority. Although they are hierarchically inferior to Pythias and Astrologers, Crystal Strategis truly are the living embodiment of what the perfect Amazon ought to be. In addition, when appointed as prophets, they receive the ability to spend a month training one Crystal Maiden for free."
#nametype 135
#hp 14
#size 4
#prot 0
#mr 17
#mor 17
#str 13
#att 13
#def 17
#prec 15
#enc 2
#mapmove 28
#ap 32
#gcost 0
#rcost 1
#weapon 1155
#weapon 357
#weapon 56
#weapon 1198
#armor 101
#armor 123
#armor 888
#maxage 50
#older -20
#expertleader
#mounted
#ressize 2
#flying
#holy
#female
#magicskill 8 2
#stormimmune
#shockres 5
#userestricteditem 8069
#twiceborn 6675
#rpcost 2
#nowish
#makemonsters1 "Crystal Maiden"
#mountedhumanoid
#end

#newmonster 7140
#spr1 "./Hellenika/Strategis_1l.tga"
#spr2 "./Hellenika/Strategis_2l.tga"
#name "Crystal Strategis"
#descr "Crystal Strategis are the greatest of all Amazon warriors. Not only are they formidable opponents in their own right, they are also great leaders, clever conquerors and subtle tacticians, and their spirit is as strong and swift as their body. As direct representatives of the council of Pythias and as flying guardians of the sky, they bear great authority. Although they are hierarchically inferior to Pythias and Astrologers, Crystal Strategis truly are the living embodiment of what the perfect Amazon ought to be. In addition, when appointed as prophets, they receive the ability to spend a month training one Crystal Maiden for free."
#nametype 135
#hp 14
#size 4
#prot 0
#mr 17
#mor 17
#str 13
#att 13
#def 17
#prec 15
#enc 2
#mapmove 28
#ap 32
#gcost 295
#rcost 1
#weapon 1155
#weapon 357
#weapon 56
#weapon 1198
#armor 101
#armor 123
#armor 888
#maxage 50
#older -20
#expertleader
#mounted
#ressize 2
#flying
#holy
#female
#magicskill 8 2
#stormimmune
#shockres 5
#userestricteditem 8069
#twiceborn 6675
#rpcost 2
#prophetshape "Strategis Prophet"
#mountedhumanoid
#end

#newmonster 7141
#spr1 "Hellenika/monster_2073.tga"
#spr2 "Hellenika/monster_2074.tga"
#name "Astrologer Prophet"
#descr "Along with Pythias, Astrologers are the true leaders of the Crystal Tribe and Thalamanth itself. They are subtle and powerful mages who not only mastered air magic before the Cloud Sages came to Thalamanth but also know the secrets of the earth and the stars. It is said that during the rebellion against the Tyrant-Philosophers they learned part of their art from the legendary Crystal Mages, who first studied the Crystal Ark, and thanks to the help of their three demi-gods they quickly exceeded their old masters. These powerful sorceresses also know how to read the future in the stars and the flight of birds, and they are the greatest guardians of the Crystal Tribe's magical heritage. Although they are very few and often old and frail, it is not without reason that they are feared by foreign adventurers who stop in Amazon lands. In addition, when appointed as prophets, they attract two Crystal Infantry bodyguards each month."
#nametype 135
#hp 10
#size 2
#prot 0
#mr 16
#mor 13
#str 8
#att 8
#def 8
#prec 13
#enc 3
#mapmove 14
#ap 13
#gcost 0
#rcost 1
#weapon 7
#maxage 50
#female
#nobadevents 6
#poorleader
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#custommagic 3328 100
#custommagic 2304 100
#custommagic 2304 20
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#shockres 5
#summon2 "Crystal Infantry"
#nowish
#stormimmune
#montag 4162
#end

#newmonster 7142
#spr1 "Hellenika/monster_2073.tga"
#spr2 "Hellenika/monster_2074.tga"
#name "Crystal Astrologer"
#descr "Along with Pythias, Astrologers are the true leaders of the Crystal Tribe and Thalamanth itself. They are subtle and powerful mages who not only mastered air magic before the Cloud Sages came to Thalamanth but also know the secrets of the earth and the stars. It is said that during the rebellion against the Tyrant-Philosophers they learned part of their art from the legendary Crystal Mages, who first studied the Crystal Ark, and thanks to the help of their three demi-gods they quickly exceeded their old masters. These powerful sorceresses also know how to read the future in the stars and the flight of birds, and they are the greatest guardians of the Crystal Tribe's magical heritage. Although they are very few and often old and frail, it is not without reason that they are feared by foreign adventurers who stop in Amazon lands. In addition, when appointed as prophets, they attract two Crystal Infantry bodyguards each month."
#nametype 135
#hp 10
#size 2
#prot 0
#mr 16
#mor 13
#str 8
#att 8
#def 8
#prec 13
#enc 3
#mapmove 14
#ap 13
#gcost 405
#rcost 1
#weapon 7
#maxage 50
#female
#nobadevents 6
#poorleader
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#custommagic 3328 100
#custommagic 2304 100
#custommagic 2304 20
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#shockres 5
#prophetshape "Astrologer Prophet"
#stormimmune
#montag 4162
#end

#newmonster 7143
#spr1 "Hellenika/Pythia_1.tga"
#spr2 "Hellenika/Pythia_2.tga"
#name "Pythia Prophet"
#descr "Along with Astrologers, Pythias are the true leaders of the Crystal Tribe and Thalamanth itself. They are pure maidens who have dedicated all their lives to their prophetic destiny. Rarely permitted to leave the palace of Thalamanth except for excellent reason, they are rather inoffensive by themselves and the special initiation they must survive to become spiritual vessels of the God renders them even weaker physically. But when their sacred powers manifest, they seem to lose all control of their bodies and are animated by a supernatural force just as a sacred statue would speak the will of the God. In these moments, they stop being themselves and their true power becomes evident. Since they are able to foresee future events, the greatest of the Pythias form a permanent council in Thalamanth which makes all vitally important decisions for the nation, though only after consulting the God and his three holy messengers. Even Astrologers are not allowed to reject such sacred edicts. Pythias are also excellent healers, for it is from them that Arcoscephale priestesses learned their art in the times past. Finally, as the mortal epitome of sacrality in the theocracy, they inspire great deeds among the Amazons and thus attract an enthusiastic Initiate each month simply by their presence.  When appointed as prophets, they instead attract three Amazon Archer servants per month."
#nametype 135
#hp 8
#size 2
#prot 0
#mr 18
#mor 15
#str 8
#att 8
#def 8
#prec 11
#enc 4
#mapmove 14
#ap 8
#gcost 0
#rcost 1
#weapon 92
#maxage 50
#female
#nobadevents 12
#poorleader
#holy
#magicskill 8 3
#autohealer 3
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#summon3 "Amazon Archer"
#nowish
#stormimmune
#shockres 5
#end

#newmonster 7144
#spr1 "Hellenika/Pythia_1.tga"
#spr2 "Hellenika/Pythia_2.tga"
#name "Crystal Pythia"
#descr "Along with Astrologers, Pythias are the true leaders of the Crystal Tribe and Thalamanth itself. They are pure maidens who have dedicated all their lives to their prophetic destiny. Rarely permitted to leave the palace of Thalamanth except for excellent reason, they are rather inoffensive by themselves and the special initiation they must survive to become spiritual vessels of the God renders them even weaker physically. But when their sacred powers manifest, they seem to lose all control of their bodies and are animated by a supernatural force just as a sacred statue would speak the will of the God. In these moments, they stop being themselves and their true power becomes evident. Since they are able to foresee future events, the greatest of the Pythias form a permanent council in Thalamanth which makes all vitally important decisions for the nation, though only after consulting the God and his three holy messengers. Even Astrologers are not allowed to reject such sacred edicts. Pythias are also excellent healers, for it is from them that Arcoscephale priestesses learned their art in the times past. Finally, as the mortal epitome of sacrality in the theocracy, they inspire great deeds among the Amazons and thus attract an enthusiastic Initiate each month simply by their presence. When appointed as prophets, they instead attract three Amazon Archer servants per month."
#nametype 135
#hp 8
#size 2
#prot 0
#mr 18
#mor 15
#str 8
#att 8
#def 8
#prec 11
#enc 4
#mapmove 14
#ap 8
#gcost 335
#rcost 1
#weapon 92
#maxage 50
#female
#nobadevents 12
#poorleader
#holy
#magicskill 8 3
#autohealer 3
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#summon1 "Amazon Initiate"
#prophetshape "Pythia Prophet"
#stormimmune
#shockres 5
#end

#newmonster 7145
#spr1 "Hellenika/thunderpriestess1.tga"
#spr2 "Hellenika/thunderpriestess2.tga"
#name "Thunder Prophet"
#descr "Combining the whole powers of both Pythias and Astrologers, Thunder Priestesses are the supreme authority of the Crystal Tribe. They are extremely powerful sorceresses that were imbued with the divine power of the three Demi-Gods of Thalamanth, and as such they cannot be recruited before either Archeosis, Heliopteryx or Nyctandeor has been summoned to bestow justice upon the nation. In addition, when appointed as a prophet, a Thunder Priestess will start training three powerful Thunder Guards per month."
#nametype 135
#hp 10
#size 2
#prot 0
#mr 18
#mor 18
#str 10
#att 10
#def 10
#prec 13
#enc 3
#mapmove 14
#ap 13
#gcost 0
#rcost 1
#weapon 467
#maxage 50
#older -5
#female
#nobadevents 12
#goodleader
#holy
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#custommagic 3328 100
#custommagic 2304 100
#custommagic 2304 20
#custommagic 32768 20
#magicskill 8 3
#autohealer 3
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#shockres 15
#stormpower 3
#summon3 "Thunder Guard"
#nowish
#stormpower 3
#montag 4162
#end

#newmonster 7146
#spr1 "Hellenika/thunderpriestess1.tga"
#spr2 "Hellenika/thunderpriestess2.tga"
#name "Thunder Priestess"
#descr "Combining the whole powers of both Pythias and Astrologers, Thunder Priestesses are the supreme authority of the Crystal Tribe. They are extremely powerful sorceresses that were imbued with the divine power of the three Demi-Gods of Thalamanth, and as such they cannot be recruited before either Archeosis, Heliopteryx or Nyctandeor has been summoned to bestow justice upon the nation. In addition, when appointed as a prophet, a Thunder Priestess will start training three powerful Thunder Guards per month."
#nametype 135
#hp 10
#size 2
#prot 0
#mr 18
#mor 18
#str 10
#att 10
#def 10
#prec 13
#enc 3
#mapmove 14
#ap 13
#gcost 495
#rcost 1
#weapon 467
#maxage 50
#older -5
#female
#nobadevents 12
#goodleader
#holy
#magicskill 1 1
#magicskill 3 1
#magicskill 4 1
#custommagic 3328 100
#custommagic 2304 100
#custommagic 2304 20
#custommagic 32768 20
#magicskill 8 2
#autohealer 3
#rpcost 4
#userestricteditem 8069
#twiceborn 6675
#summon1 "Amazon Initiate"
#prophetshape "Thunder Prophet"
#shockres 15
#stormpower 3
#ownsmonrec -4160
#stormpower 3
#montag 4162
#end

#newmonster 7147
#spr1 "./Hellenika/Sky_Hunter_2.tga"
#spr2 "./Hellenika/Sky_Hunter_1.tga"
#nametype 100
#name "Wind Tribe Sky Hunter"
#descr "Sky Hunters of the Wind Tribe are wild and stealthy disciples of the Ornithomancers that know how to speak to birds through whistle-language and are very talented in leading small commandos. Several loyal birds always accompany them in combat. Like Bird Warriors, the feather cloaks they don are enchanted by the magical knowledge taught to their shamans by the Cloud Sages and allow them to fly. Also like them, they wear no real armor, however their main weapon is a javelin enchanted by air magic. When thrown, it is carried by the winds for very long distances, and it returns to its user after having hit. An Ornithomancer or a Cloud Sage must be present in the province to recruit them. Dai Tengus, Silver Hawk Kings and Cloud Dragons also make good teachers."
#hp 12
#size 2
#prot 0
#mr 10
#mor 14
#str 11
#att 12
#def 12
#prec 12
#enc 3
#mapmove 20
#ap 12
#maxage 50
#weapon 123
#weapon 9
#armor 44
#poorleader
#command -5
#inspirational 1
#gcost 10025
#rcost 1
#stealthy 10
#batstartsum3 "Silver Hawk"
#mountainsurvival
#forestsurvival
#flying
#startitem 867
#monpresentrec -4161
#rpcost 1
#patrolbonus 10
#end

#newmonster 7148
#spr1 "./Hellenika/Ornithomancer_2.tga"
#spr2 "./Hellenika/Ornithomancer_1.tga"
#name "Wind Tribe Ornithomancer"
#descr "Ornithomancers are wild shamans of the Wind Tribe who combined their own ancient traditions with the lore of the Cloud Sages and know how to speak to birds through whistle-language and magic rituals. Several loyal birds always accompany them in combat and they can befriend more each month, although in great numbers they consume a lot of supplies. In addition, they are the only mages in Thalamanth who know the hidden paths of the mountain and forest that lead to ancient Tengu villages. Otherwise, like Bird Warriors and Sky Hunters, they are stealthy warriors of the Wind Tribe and the feather cloaks they don are enchanted by the magical knowledge taught by the Cloud Sages and allow them to fly. They wield javelins, spears and daggers, but wear no real armor. An Ornithomancer or a Cloud Sage must be present in the province to recruit them. Dai Tengus, Silver Hawk Kings and Cloud Dragons also make good teachers."
#nametype 100
#hp 14
#size 2
#mr 13
#mor 14
#str 11
#att 12
#def 12
#prec 13
#enc 3
#mapmove 20
#ap 12
#maxage 50
#weapon 9
#armor 44
#gcost 115
#rcost 1
#poorleader
#stealthy 0
#magicskill 1 1
#custommagic 8448 100
#custommagic 8192 20
#beastmaster 2
#makemonsters3 "Silver Hawk"
#batstartsum3 "Silver Hawk"
#researchbonus -6
#forestsurvival
#mountainsurvival
#flying
#monpresentrec -4161
#montag 4161
#rpcost 1
#end

#newmonster 7149
#spr1 "./Hellenika/TyrantPhi1.tga"
#spr2 "./Hellenika/TyrantPhi2.tga"
#name "Tyrant-Philosopher"
#descr "The Tyrant-Philosophers of Thalamanth are mad and corrupted thinkers that formed an orgiac cult and perpetrated many horrible crimes in the ancient times when they reigned over the city, before the Amazons and the Wind Tribe cast them down from their thrones and almost killed them all. For a very long time, the few survivors hid, waiting for the day where someone power-hungry enough would call them back to their rightful kingdom. Powerful blood and astral mages that are hated by the people, they can only be found in Thalamanth, and recruiting them will be very difficult until their old academy, the Areopagus, is reassembled through the right blood ritual, which anyone can do with a sufficient blood sacrifice. Once the Tyrant-Philosophers are in power again, they'll be able to corrupt Thalamanth's Crystal Ark through a truly awful ritual they invented, thus committing the ultimate sacrilege and gaining immense and terrible power."
#nametype 107
#hp 10
#prot 0
#mr 18
#mor 13
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 10
#gcost 200
#rcost 1
#weapon 674
#poorleader
#maxage 50
#magicskill 4 2
#magicskill 7 2
#custommagic 18432 50
#custommagic 18432 50
#custommagic 18432 50
#researchbonus 4
#slothresearch 2
#incunrest 10
#rpcost 2
#heretic 3
#end

#newmonster 7150
#spr1 "Hellenika/CrystSorcE1.tga"
#spr2 "Hellenika/CrystSorcE2.tga"
#name "Crystal Enchantress"
#descr "The Crystal Tower is well known throughout Thalamanth for the special training that its mistress, the great and controversial poet-sorceress Psappho, grants to the maidens that come here and earn her trust and love. Once their long initiation is finished, they all master a very wide range of skills. Although most of these skills are useless in warfare, their original talents in magic certainly are not, and since the Crystal Tower's mistress has joined the Awakening God, their loyalty now indirectly goes to Thalamanth, which will undoubtedly be a great boon. A Crystal Astrologer or Psappho herself must be present to teach them their craft."
#nametype 135
#hp 9
#size 2
#prot 0
#mr 13
#mor 7
#str 8
#att 8
#def 8
#prec 10
#enc 2
#mapmove 14
#ap 10
#gcost 10085
#rcost 1
#weapon 92
#female
#poorleader
#maxage 50
#older -15
#custommagic 3328 100
#custommagic 2304 100
#custommagic 8704 100
#custommagic 11008 50
#custommagic 12032 10
#userestricteditem 8069
#twiceborn 6675
#rpcost 2
#monpresentrec -4162
#montag 4124 -- for Isphenople
#end

#newmonster 7151
#copystats 1076 -- Myrmidon Champion
#spr1 "Hellenika/Triliaxian_champion_1.tga"
#spr1 "Hellenika/Triliaxian_champion_1.tga"
#name "Triliaxian Champion"
#descr "The Myrmidons are the elites of the Divine Citadel, and their commanders are its champions. After the Arcoscephalean Myrmidons turned the tide of several battles against Triliax in previous wars, Triliax's military adopted the unit as its own. Since then, it has become a staple of Triliaxian tactics and the proud Triliaxian Myrmidons don't think of themselves as simple epigones. Like all Myrmidons, they wield short swords and carry shields, but unlike others they also bear magical tattoos that remind them of the sacred horses of Trilios, children of foam, a great symbol of nobility that strengthens them when a High Priest of the Sea accompanies them."
#horsetattoo 2
#end

#newmonster 7152
#spr1 "Hellenika/Physicist_Scholar_1.tga"
#spr2 "Hellenika/Physicist_Scholar_2.tga"
#name "Physicist Scholar"
#descr "Physicist Scholars are mage-thinkers specializing in the mechanics of the Mundane and the Arcane alike. Although they could be compared to philosophers, a complicated relationship exists between these sects. The physicists of Triliax existed before the philosophers of Arcoscephale and in fact even before the fall of Therodos, and it is said that the philosophers founded their school in reaction to the physicists' beliefs, which they find too earthly and archaic. Since then, philosophers have become a lot more popular than physicists, but physicists still live in the Divine Citadel which welcomed and protected them when they were cast out of Arcosephale, and now they serve it with all their skills. They study all four elements as the fundamental principles of the universe and use their findings to invent practical things. Therefore, they are very skilled at siegecraft and castle defense. In addition, due to their materialistic way of thought, they are very aggressive battle mages and know how to cast spells twice as quickly as most other mages, which can be quite exhausting but also devastating to the opposing forces."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 12
#mor 9
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 10
#maxage 50
#weapon 637
#poorleader
#siegebonus 15
#castledef 15
#gcost 140
#rcost 1
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 1
#magicboost 4 -1
#custommagic 1920 10
#rpcost 2
#researchbonus 2
#fastcast 100
#montag 4124 -- for Isphenople
#userestricteditem 8059
#end

#newmonster 7153
#copystats 240 -- Priest
#spr1 "Hellenika/Triliaxian_Priest_1.tga"
#spr2 "Hellenika/Triliaxian_Priest_2.tga"
#name "Triliaxian Priest"
#descr "In Triliax, both the sea and the mountain are revered as two different aspects of the Awakening God. Although each of these great forces has its own high priests, Triliaxian priests of low rank often employ elements of both spiritualities. As polyvalent and popular representatives of the royal cult, they are the principal link between the Divine Citadel and the people of its provinces."
#nametype 107
#magicskill 8 1
#custommagic 1536 100
#custommagic 512 50
#custommagic 1024 50
#gcost 120
#rcost 1
#mountainsurvival
#rpcost 2
#end

#newmonster 7154 -- Summoned only, but must be present before High Priests to avoid crash
#spr1 "Hellenika/NewPillar.tga"
#name "Pillar of the City"
#descr "The Pillar of the City is an altar of great symbolic importance that can be used by High Priests of the Sea and the Mountain to perform their rituals. It is richly ornamented with jewelry of gold and aquamarine and carved with delicate patterns of vines and flowers which are famed for their beauty and intricacy even in Arcoscephale. Its main function is to remind the people of Triliax of the great miracle of the Sacred Walls of Dardanum and of the inevitable victory of Civilization over savagery. The mere presence of one such pillar is enough to increase the wisdom of savants in the region, and therefore it will improve the research abilities of all friendly mages in the province. Although the pillars can be summoned everywhere, High Priests cannot be recruited outside of provinces of their element. A pillar is also required for the recruitment of Troll Archons in underwater provinces, but it is gradually damaged by erosion while underwater and thus will be rendered completely useless after one year in such an environment. Finally, should a great Telkhine join the kingdom in service of the Basilei, he would be able to fulfill the function of a Pillar of the City for recruitment purposes."
#nametype 106
#hp 60
#size 5
#prot 25
#mr 18
#mor 30
#str 15
#prot 20
#att 5
#def 0
#prec 5
#enc 0
#mapmove 0
#ap 2
#noleader
#maxage 2400
#poisonres 25
#eyes 0
#spiritsight
#fireres 15
#coldres 15
#shockres 15
#immobile
#bonusspells 1
#blind
#bluntres
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#stonebeing
#holy
#magicskill 8 1
#miscshape
#itemslots 1 -- no itemslot
#inspiringres 1
#castledef 100
#supplybonus 100
#montag 4113
#uwdamage 9
#gcost 0
#end

#newmonster 7155
#spr1 "Hellenika/High_Priest_of_the_Sea_1.tga"
#spr2 "Hellenika/High_Priest_of_the_Sea_2.tga"
#name "High Priest of the Sea"
#descr "Four things are worshipped in Triliax: Waves, Quakes, Monsters, and the City. Of the four, three are aspects of Natural Violence and the Wrath of God; they are feared by all, and prayers dedicated to them mainly have the function of appeasing them, in hopes that they won't manifest. On the other hand, the City is the true benevolent aspect of the God of Triliax: the safety of civilization, the marvels of the crafts, the divine walls that were given to man to protect himself from the natural world and the enemies of culture. The High Priests of Triliax represent all these things and therefore are great authorities in many domains, but they focus on either the Sea or the Mountain, for the City is best represented by the Basilei, and the Monsters themselves need no heralds. In this sense, one could say that two churches cohabit in Triliax. Both worship the same God, but through opposite and complementary points of view. High Priests are very confident in the benevolence the God extends to its faithful servants, as well as in their own powers, and unlike lesser priests they will summon without hesitation the Wrath of the Sea and the Mountain upon the enemies of civilization. More than anyone, they understand that there is actually no contradiction between the violence of nature and the order of culture; one is built directly on the other. High mountains and oceanic shores serve the City as much as walls of stone, and therefore being a High Priest of Quakes or Waves doesn't mean being a savage. It is actually quite to the contrary: a High Priest is a representative of Civilization and just like the ancient cyclopes a great master of the crafts, a very skillful mage-smith. Other than their religious authority, High Priests of the Sea bear great powers over water and storm, and sometimes also over the earth. They can be recruited in all coastal forts where either a Pillar of the City has been erected for their rituals or a divine Telkhine has taken residence."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 16
#mor 9
#str 10
#att 8
#def 8
#prec 11
#enc 3
#mapmove 14
#ap 12
#maxage 50
#gcost 260
#rcost 1
#weapon 9
#armor 158
#holy
#poorleader
#magicskill 1 1
#magicskill 2 3
#magicskill 8 2
#custommagic 1792 100 -- A/E/W
#custommagic 1792 10
#slowrec
#fixforgebonus 1
#resources 15
#monpresentrec -4113
#rpcost 3
#montag 4124 -- for Isphenople
#end

#newmonster 7156
#spr1 "Hellenika/High_Priest_of_the_Mountain_1.tga"
#spr2 "Hellenika/High_Priest_of_the_Mountain_2.tga"
#name "High Priest of the Mountain"
#descr "Four things are worshipped in Triliax: Waves, Quakes, Monsters, and the City. Of the four, three are aspects of Natural Violence and the Wrath of God; they are feared by all, and prayers dedicated to them mainly have the function of appeasing them, in hopes that they won't manifest. On the other hand, the City is the true benevolent aspect of the God of Triliax: the safety of civilization, the marvels of the crafts, the divine walls that were given to man to protect himself from the natural world and the enemies of culture. The High Priests of Triliax represent all these things and therefore are great authorities in many domains, but they focus on either the Sea or the Mountain, for the City is best represented by the Basilei, and the Monsters themselves need no heralds. In this sense, one could say that two churches cohabit in Triliax. Both worship the same God, but through opposite and complementary points of view. High Priests are very confident in the benevolence the God extends to its faithful servants, as well as in their own powers, and unlike lesser priests they will summon without hesitation the Wrath of the Sea and the Mountain upon the enemies of civilization. More than anyone, they understand that there is actually no contradiction between the violence of nature and the order of culture; one is built directly on the other. High mountains and oceanic shores serve the City as much as walls of stone, and therefore being a High Priest of Quakes or Waves doesn't mean being a savage. It is actually quite to the contrary: a High Priest is a representative of Civilization and just like the ancient cyclopes a great master of the crafts, a very skillful mage-smith. Other than religious authority, High Priests of the Mountain bear great powers over earth and volcanoes, and sometimes also over the sea. They can be recruited in all mountain provinces where either a Pillar of the City has been erected for their rituals or a divine Telkhine has taken residence."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 16
#mor 9
#str 10
#att 8
#def 8
#prec 11
#enc 3
#mapmove 14
#ap 12
#maxage 50
#gcost 260
#rcost 1
#weapon 9
#armor 158
#holy
#poorleader
#magicskill 0 1
#magicskill 3 3
#magicskill 8 2
#custommagic 1664 100 -- F/E/W
#custommagic 1664 10
#slowrec
#fixforgebonus 1
#resources 15
#monpresentrec -4113
#rpcost 3
#montag 4124 -- for Isphenople
#end

#newmonster 6815
#spr1 "Hellenika/Basileus_1.tga"
#spr2 "Hellenika/Basileus_2.tga"
#name "Basileus"
#descr "A Basileus is a direct descendant of the divine hero Trilios, the founding father of Triliax. The Basilei are the holy kings of Triliax, and they receive immense magic and priestly powers from their venerable age, the purity of their blood and the sanctity of their function. Far above the High Priests, they are the great unifiers of the two cults of Triliax - the cult of the Sea and the cult of the Mountain -, and more than anyone else, they represent the most important aspect of the God: the City. They are the heralds of Civilization, the Soul of the Nation, and they vigilantly watch over the Great Walls of Dardanum from their palace in the Divine Citadel. Although their reign is authoritarian and tyrannical, they are admired by all for their leadership bears the promise of unparalleled greatness."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 16
#mor 12
#str 10
#att 8
#def 8
#prec 11
#enc 3
#mapmove 14
#ap 12
#maxage 50
#older -18
#gcost 10100
#rcost 1
#weapon 92
#armor 158
#armor 148
#holy
#magicskill 2 4
#magicskill 3 4
#magicskill 8 3
#slowrec
#fixforgebonus 1
#expertleader
#rpcost 4
#montag 4115
#end

#newmonster 7157
#spr1 "Hellenika/Aristocrat_1.tga"
#spr2 "Hellenika/Aristocrat_2.tga"
#name "Aristocrat"
#descr "The society of Triliax is very hierarchical. It is widely believed in the Divine Citadel that virtues and skills are before all else a matter of ancestry; some bloodlines are better than others by nature, for the remnants of divinity quickly dissipate with generations. There are some things that cannot be taught; one is simply born with or without them, or at least with or without a great potential for them. This is not only the order of nature, but also that of reason and the city. Therefore, it is no surprise that the idea of democracy and rule by the unwashed masses is despised in Triliax. Because of the importance placed on the purity of blood, the Triliaxian theocratic monarchy also bears a large aristocratic class - that is to say, a class of leaders chosen for their innate, hereditary ability, moral merit and qualities -, which is centered on the preservation of the power of a few dynasties that usually have some old ties to local divinities or sometimes even to Trilios himself. These high-blood families are composed both of myrmidon warriors that value honor, bravery and loyalty above all else, and of frail intellectuals that prefer taking the fight to the field of words. The latter often become politicians and are what the people of Triliax call Aristocrats. They are useless in battle, except for commanding troops. They don't have enough experience of combat to be great tacticians, but they bear enough authority to ensure that slaves won't rebel. However, Aristocrats are most skillful as province administrators. Not only do they gather taxes even when no fortress is present, but they also very efficiently organize static defenses. A wise Basileus should not underestimate the utility of such governors."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 12
#mor 9
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 10
#maxage 50
#older 30
#gcost 10040
#rcost 1
#weapon 9
#armor 158
#incprovdef 4
#taxcollector
#goodleader
#inspirational -1
#taskmaster 3
#rpcost 1
#end

#newmonster 7158
#spr1 "Hellenika/CyclopsMonster1.tga"
#spr2 "Hellenika/CyclopsMonster2.tga"
#name "Monster Cyclops"
#descr "Monster Cyclopes are commanders of the Monstrous Phalanxes and lead their brethren in battle. They are even more gluttonous than inferior Cyclopes, but they are also smarter and stronger and can destroy or repair stone fortifications with ease. Having fought beasts and monsters for the control of the lands since the dawn of time, they bear great authority over animals and can tame even the wildest monsters. Ironically themselves despised as savage and degenerate beasts by their distant cousins the True Cyclopes and Gigantes of Mekone, Monster Cyclopes have no need for their noble traditions, but even then they still practice blacksmithing, in unison with the priests of Quakes, Waves and the City. Monster Cyclops may only be recruited under the vigilant watch of the Basilei that once defended their honor and sanctity by giving them a homeland to serve and who now ensure their loyalty. Their natural cruelty also makes them easier than most commanders to empower in Blood magic."
#nametype 107
#hp 80
#size 5
#prot 15
#mr 11
#mor 17
#str 25
#att 13
#def 11
#prec 9
#enc 2
#mapmove 3
#ap 14
#maxage 200
#fireres 15
#poisonres 15
#beastmaster 3
#animalawe 3
#eyes 1
#fear 10
#mountainsurvival
#stonebeing
#patrolbonus 10
#weapon 645
#armor 142
#holy
#gcost 205
#rcost 1
#supplybonus -10
#siegebonus 10
#castledef 10
#montag 4112
#rpcost 1
#resources 15
#magicskill 7 1
#magicboost 7 -1
#noreqlab
#monpresentrec -4115
#snaketattoo 2
#end

#newmonster 7159
#copystats 580 -- Sea King
#spr1 "Hellenika/SeaTrollsKing1.tga"
#spr2 "Hellenika/SeaTrollsKing2.tga"
#name "Troll Archon"
#descr "Troll Archons are ancient Kings of the Sea Trolls who joined the great Triliaxian Basilei after their conquests of the sea. They willingly exchanged their crown and their sunken kingdoms' secrets for great riches and the promise of even greater glory. These powerful sorcerer-generals possess unimaginable wonders of Water magic and may grant humans water-breathing abilities if they accompany them. A temple, a laboratory and a Pillar of the City are required to recruit them in underwater forts, and the strong sea currents will inevitably damage Pillars of the City with time over the course of a year spent underneath the waves, until replacing them becomes necessary. However, the presence of a mighty Telkhine also may replace that of a Pillar of the City for that purpose. Short of all these requirements being fulfilled, Troll Archons may also be summoned."
#reqtemple
#gcost 275
#rpcost 4
#monpresentrec -4113
#cleararmor
#armor 123
#end

#newmonster 7160
#spr1 "./Hellenika/GreatBirdD_1.tga"
#spr2 "./Hellenika/GreatBirdD_2.tga"
#name "Wanderer Bird"
#descr "Nephelococcygia has agents hiding in all four corners of the world, and Wanderer Birds are among the most iconic. They are large predator birds of uncanny intellect, dull colors and placid personality that prefer a lonely and free-spirited life-style despite their great skills as hunters. They fly at such heights and for such long distances and periods of time that scholars suspect that they are able to sleep on the wing, even while gliding far above earth or the oceans. As such, they make extraordinarily good scouts, and if needed their excellent sight also lets them patrol or find supplies very efficiently."
#hp 15
#size 3
#prot 2
#mr 5
#mor 13
#str 11
#att 11
#def 13
#prec 14
#enc 2
#mapmove 32
#ap 6
#maxage 21
#weapon 408
#weapon 404
#noleader
#stealthy 100
#patrolbonus 30
#animal
#flying
#mountainsurvival
#forestsurvival
#wastesurvival
#swampsurvival
#gcost 30
#rcost 1
#sailing 3 6
#addupkeep -15
#supplybonus 20
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7161
#spr1 "./Hellenika/GreatBirdH_1.tga"
#spr2 "./Hellenika/GreatBirdH_2.tga"
#name "Aerial Troublemaker"
#descr "Nephelococcygia has agents hiding in all four corners of the world, and Aerial Troublemakers are among the most iconic. They are large predator birds of uncanny intellect that are known for the incredible agressiveness both of their bright colors and fiery personality. Never ever tired nor compliant, they cause unimaginable chaos wherever they go, most of the time for no reason at all, and rare are the animals that are considered more noxious and destructive than them. The Republic in the Clouds doesn't care about their anarchic ways and gladly uses them to spread the word of revolt or to instill disorder in enemy territory. In fact, they are even encouraged to harm concurrent cults, a new way to annoy others that they revel in, and as such serve an important purpose for the Nation of the Birds: starving the gods of the faith of their worshippers."
#hp 15
#size 3
#prot 2
#mr 14
#mor 14
#str 12
#att 12
#def 14
#prec 14
#enc 1
#mapmove 26
#ap 6
#maxage 21
#weapon 408
#weapon 404
#noleader
#stealthy
#heretic 1
#incunrest 30
#animal
#flying
#mountainsurvival
#forestsurvival
#gcost 30
#rcost 1
#addupkeep -15
#nametype 239
#airshield 20
#chaospower 1
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7162
#spr1 "./Hellenika/AerialIconoclast_1.tga"
#spr2 "./Hellenika/AerialIconoclast_2.tga"
#name "Aerial Iconoclast"
#descr "Aerial Iconoclasts are extremely vicious and anarchistic birds that embody the furious heart of the Revolution. Although they resemble Aerial Troublemakers, they are more than thrice as efficient when spreading chaos and heresy, and as they accomplish this task with a mad and religious zeal, they are granted sacred status by the Awakening God."
#hp 20
#holy
#size 3
#prot 2
#mr 14
#mor 14
#str 12
#att 12
#def 14
#prec 14
#enc 1
#mapmove 26
#ap 6
#maxage 21
#weapon 408
#weapon 404
#noleader
#stealthy
#heretic 3
#incunrest 100
#animal
#flying
#mountainsurvival
#forestsurvival
#gcost 0
#rcost 1
#nametype 239
#airshield 20
#chaospower 3
#incscale 0
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7163
#spr1 "./Hellenika/GreatBirdJ_1.tga"
#spr2 "./Hellenika/GreatBirdJ_2.tga"
#name "Superior Hawk"
#descr "Like the more common Great Hawks, Superior Hawks are large predator birds of uncanny intellect that impose themselves as rulers over lesser birds, and their resplendent colors mean that they don't have to rely on strength alone to do so. As such, they are often chieftains of the savage although impressively clever bird tribes formed by the most intelligent winged species. Usually wilder and more defiant against civilization than their black counterparts, most Superior Hawks that heard the call of Nephelococcygia decided to rally their tribe to the Revolution and to lead it to war against mankind; therefore, just like more important commanders of Nephelococcygia, they are naturally admired by lesser birds but don't get along very well with humanoids. Finally, they are great hunters and are able to somewhat efficiently organize the search for supplies for the ravenous and sometimes even destructive flocks of Warriors of the Clouds they lead."
#rcost 1
#hp 15
#size 3
#prot 2
#mr 8
#mor 13
#str 11
#att 11
#def 13
#prec 14
#enc 3
#mapmove 26
#ap 6
#maxage 21
#gcost 45
#rcost 1
#weapon 408
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#animalawe 1
#inspirational -1
#beastmaster 2
#stealthy
#addupkeep -22
#supplybonus 10
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7164
#spr1 "./Hellenika/BringerOfAnarchy_1.tga"
#spr2 "./Hellenika/BringerOfAnarchy_2.tga"
#name "Bringer of Anarchy"
#descr "Bringers of Anarchy are extremely chaotic birds that joined the Revolution with great zeal and are otherwise rather similar to Superior Hawks. Their immense passion makes them charismatic leaders and they spread unrest everywhere they go, reveling in the destruction of all that serves human dominance. Their cry is the burning hymn of the Revolution and inspires great deeds in the hearts of all birds."
#rcost 1
#hp 15
#size 3
#prot 2
#mr 5
#mor 13
#str 11
#att 11
#def 13
#prec 14
#enc 3
#mapmove 26
#ap 6
#maxage 21
#gcost 0
#rcost 1
#weapon 408
#weapon 404
#goodleader
#command -20
#inspirational -1
#animal
#flying
#mountainsurvival
#forestsurvival
#animalawe 1
#beastmaster 2
#stealthy
#incunrest 30
#chaospower 2
#supplybonus 10
#nametype 239
#airshield 20
#rpcost 1
#bird
#itemslots 12288 -- 2 misc
#end

#newmonster 7165
#spr1 "./Hellenika/GreatBirdA_1.tga"
#spr2 "./Hellenika/GreatBirdA_2.tga"
#name "Bird Shaman"
#descr "Like most intelligent beings, birds clever enough to maintain a culture have shamans. Bird Shamans serve as tribal spiritual guides and, while reclusive, they are often very wild and aggressive towards any humanoids who stumble upon them. Since the rise of Nephelococcygia, this dislike of mankind has been harnessed by the leaders of the Republic in the Clouds to inspire revolt against mankind among lesser birds. This plan has worked, and now Bird Shamans accompany them to war. Although they are too savage and unstable in appearance to make good leaders, they are talented song-weavers and use their intricate whistlings to conjure spells of great beauty and subtlety. A good title to summarize their status would be that of cruel artists."
#hp 15
#size 3
#prot 2
#mr 8
#mor 11
#str 10
#att 10
#def 12
#prec 14
#enc 3
#mapmove 26
#ap 6
#maxage 21
#older -10
#gcost 65
#rcost 1
#inspirational -1
#beastmaster 2
#poorleader
#weapon 408
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#bird
#itemslots 12288 -- 2 misc
#fixforgebonus -6
#magicskill 6 1
#custommagic 8448 100
#custommagic 256 20
#researchbonus -6
#stealthy
#addupkeep -30
#supplybonus 10
#nametype 239
#airshield 20
#rpcost 1
#spellsinger
#end

#newmonster 7166
#spr1 "./Hellenika/WyrdBird_1.tga"
#spr2 "./Hellenika/WyrdBird_2.tga"
#name "Wyrd Master"
#descr "Wyrd Masters are liars, outcasts, freaks and witches that live apart from other birds. They are misshapen scavengers and bringers of misfortune that dwell hidden in dark and sickly places and are often deformed, diseased or lame. The hoi polloi sometimes calls them weird or wyrd, and superstitious or perhaps wise people tell that they form covens to study the mysteries of the occult and conspire against mankind. Although even other birds dislike them, the Republic of the Clouds sometimes uses their services in exchange for the right to approach the utopic Nephelococcygia. They can only be found in provinces with an Ashen Tree, and they'll desert it if a fort is built there. Only they and their Herald of Slaughter masters are able to forge Shadow Feathers."
#hp 15
#size 3
#prot 2
#mr 14
#mor 12
#str 10
#att 10
#def 12
#prec 14
#enc 3
#mapmove 26
#ap 6
#maxage 21
#gcost 60
#rcost 1
#poorleader
#weapon 1185
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#swampsurvival
#wastesurvival
#bird
#itemslots 12288 -- 2 misc
#fixforgebonus -6
#custommagic 8448 100
#custommagic 10496 40
#custommagic 4096 40
#custommagic 16384 10
#researchbonus -4
#stealthy 20
#addupkeep -30
#nametype 239
#deathcurse
#deathdisease 5
#darkvision 100
#darkpower 2
#startaff 30
#monpresentrec "Ashen Tree"
#airshield 20
#rpcost 2
#spellsinger
#spiritsight
#twiceborn 1388
#end

#newmonster 7167
#spr1 "./Hellenika/ManflayerBird_1.tga"
#spr2 "./Hellenika/ManflayerBird_2.tga"
#name "Manflayer Bird"
#descr "For most of their historical existence, since they acted naturally according to the divine will and thus didn't have to worry about the gods, birds didn't have any use for priests. When the Pantokrator disappeared, this changed. The subjects of Nephelococcygia no longer are heralds of the Pantheon, their flight no longer bears any other meaning than that of the impending fall of mankind. Instead, they glorify their own divinity and claim confidence in the fact they are the new gods. Thus, when the blood of a man was first spilled upon the holy ground of the City in the Sky, a new order of Priests of Birdkind was founded. While they still are as uncivilized as Bird Shamans and Superior Hawks, all Manflayers bear within them the holy Oath of Nephelococcygia against Mankind and the Gods. They have no use for words or diplomacy; the only way to teach wingless mortals their place is by example, by spilling and drinking their blood. Thus, although they are able to preach, when doing so they will always kill a part of the population in their gory rites. Manflayer Birds are the spiritual leaders of all Blood-drinker Birds and tell the other birds of the Golden Ones that bathed in the Blood of the Sun. Those among them who are clever enough to master blood magic are talented in finding suitable slaves for holy sacrifice."
#hp 15
#size 3
#prot 2
#mr 8
#mor 11
#str 10
#att 10
#def 12
#prec 14
#enc 3
#mapmove 26
#ap 6
#maxage 21
#older -10
#gcost 140
#rcost 1
#inspirational -1
#beastmaster 2
#poorleader
#weapon 1185
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#bird
#itemslots 12288 -- 2 misc
#fixforgebonus -6
#holy
#magicskill 8 1
#custommagic 16384 25
#rpcost 1
#douse 1
#supplybonus 10
#addupkeep -70
#nametype 239
#airshield 20
#damagerev 1
#chaospower 1
#fixedresearch 3
#spellsinger
#end

#newmonster 6881
#spr1 "./Hellenika/GiantBirdF2_1.tga"
#spr2 "./Hellenika/GiantBirdF2_2.tga"
#name "Great Wise Owl"
#descr "Great Wise Owls are Ancient Owls of venerable age, immense knowledge and extreme rarity. They are the most faithful servants of the Sky Trees and are said to keep their most important secrets. They attend to their every need and direct the rituals that are held when one of them dies. They are very reclusive and since they believe their task is sacred they only leave the White Groves in times of great necessity."
#hp 52
#size 6
#prot 7
#mr 18
#mor 16
#str 17
#att 11
#def 11
#prec 14
#enc 3
#mapmove 32
#ap 8
#goodleader
#inspirational -1
#beastmaster 2
#weapon 408
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#siegebonus 10
#patrolbonus 10
#bird
#itemslots 12288 -- 2 misc
#fixforgebonus -6
#magicskill 1 2
#magicskill 4 1
#magicskill 6 2
#custommagic 10496 100
#magicboost 1 1
#magicboost 4 1
#magicboost 6 1
#maxage 150
#older 50
#holy
#researchbonus 8
#sailing 6 6
#montag 4123
#supplybonus 40
#nametype 239
#airshield 20
#rpcost 3
#spellsinger
#gcost 0
#end

#newmonster 7168
#spr1 "./Hellenika/GiantBirdF_1.tga"
#spr2 "./Hellenika/GiantBirdF_2.tga"
#name "Ancient Owl"
#descr "After Bird Sorcerers, Ancient Owls are the most intelligent of entirely natural birds. They spend most of their time in contemplation of the mysterious truths of nature and the sky and before the rise of Nephelococcygia it was very rare to meet them directly without searching deep in the forest or the mountain for their hidden abodes. All of them know human speech, and although they eschew civilization and the products of the craft, they are powerful mages with the mystical knowledge to equal any human wizard. It is said that they were taught their lore by the Treelords and Sky Trees at the very dawn of time, and as such they were often considered important representatives of the natural world and their wisdom was respected by the elder druids and shamans of Ulm and Marverni. But recently, things have changed; most Ancient Owls have agreed that man must pay for his impudence and have joined or even sometimes actively encouraged the Revolution of the Birds. Now, they are among the most common of the great leaders of Nephelococcygia, and they cooperate together with a vast mutual respect, loyalty and understanding, allowing them to achieve a great efficiency. Although they can only be recruited the traditional way in the capital, they can also be found as teachers and governors of all provinces with a Circle of Knowledge. Such a site will automatically appear in each fort that is controlled by the Republic, is under its dominion and is equipped with a laboratory, and will remain for as long as these conditions are met. While any commander can enter it to learn from the Owls' wisdom, as long as it is an Owl that enters it, one month out of two on average one of its peers will join the nation for the same gold cost as usual. Additionally, an Owl prophet will always be empowered in all its known paths of air, nature and astral magic, but such Great Wise Owls can also appear spontaneously at the doors of Nephelococcygia to bestow their immense wisdom upon the Nation."
#hp 52
#size 6
#prot 7
#mr 16
#mor 16
#str 17
#att 11
#def 11
#prec 14
#enc 3
#mapmove 32
#ap 8
#command 20
#inspirational -1
#beastmaster 2
#gcost 160
#addupkeep -80
#rcost 1
#weapon 408
#weapon 404
#animal
#flying
#mountainsurvival
#forestsurvival
#siegebonus 10
#patrolbonus 10
#bird
#itemslots 12288 -- 2 misc
#fixforgebonus -6
#magicskill 1 1
#magicskill 6 1
#custommagic 10496 100
#custommagic 8448 100
#custommagic 8448 50
#custommagic 2048 15
#researchbonus 2
#maxage 100
#older 25
#rpcost 3
#prophetshape "Great Wise Owl"
#sailing 6 6
#montag 4123
#supplybonus 20
#nametype 239
#airshield 20
#spellsinger
#end

#newmonster 7169
#spr1 "./Hellenika/GiantBirdA_1.tga"
#spr2 "./Hellenika/GiantBirdA_2.tga"
#name "Eagle Warlord"
#descr "Eagle Warlords are the strongest and greatest of all entirely natural birds. They share most of their traits with Terror Falcons, but their physical might outweighs even that of the Great Eagles. Although they aren't very colorful but instead entirely black, they still are revered by all birds, and not just because they are rightfully feared. Their flight and stature are both elegant and majestic, and they are very charismatic leaders. They are considered Kings among birds, and none in Nephelococcygia would dare to oppose them."
#hp 60
#size 6
#prot 8
#mr 16
#mor 18
#str 18
#att 15
#def 14
#prec 16
#enc 3
#mapmove 38
#ap 8
#gcost 200
#rcost 1
#weapon 408
#weapon 404
#maxage 50
#superiorleader
#animal
#flying
#mountainsurvival
#forestsurvival
#siegebonus 30
#patrolbonus 30
#bird
#itemslots 12288 -- 2 misc
#inspirational -1
#beastmaster 2
#fear 5
#sailing 6 6
#montag 4123
#rpcost 2
#addupkeep -100
#supplybonus 60
#nametype 239
#airshield 20
#end

#newmonster 7170
#spr1 "./Hellenika/GiantBirdJ5_1.tga"
#spr2 "./Hellenika/GiantBirdJ5_2.tga"
#name "Solar Bird"
#descr "Solar Birds are giant birds entirely covered with feathers of pure gold. They are exceedingly rare except in times of cataclysmic change and their appearance is generally seen as a prophetic sign. They are the most sacred of all birds, except for their ancestors the legendary Primordial Eagles, which haven't been seen on earth for the last eon. Solar Birds are supernatural beings imbued with the essence of the sun. They shine like angels and anyone daring to strike them risks losing their eyes forever. They are almost immune to the elements and entirely unaffected by storms. An intense holy aura surrounds them and they are able to fight like dragons and cast powerful divine spells at the same time. Although their personality is too cold, stoic and impervious to change to allow them to lead living beings, they have a telepathic link with magical entities and are able to command them in battle. Like Spirits of the Four Seasons, Solar Birds are able to attack with flashes of blinding light, burning the eyes of their foes, and their internal energy seems to be inexhaustible. Solar Birds require half the upkeep they normally would as their perfect body has very few needs. A Solar Bird prophet will gain one additional priest level compared to other prophets."
#hp 52
#size 6
#prot 8
#mr 18
#mor 30
#str 16
#att 14
#def 13
#prec 15
#enc 1
#reinvigoration 2
#mapmove 32
#ap 8
#gcost 300
#rcost 1
#weapon 1188
#weapon 1187
#weapon 1189
#maxage 50
#noleader
#okmagicleader
#animal
#flying
#mountainsurvival
#forestsurvival
#poisonres 15
#fireres 15
#coldres 15
#shockres 15
#awe 5
#holy
#magicskill 8 1
#magicboost 8 1
#siegebonus 20
#patrolbonus 20
#bird
#itemslots 12288 -- 2 misc
#eyeloss
#stormimmune
#sailing 6 6
#montag 4123
#bonusspells 3
#rpcost 2
#addupkeep -225
#nametype 239
#airshield 20
#magicbeing
#custommagic 128 20
#spellsinger
#end

#newmonster 7171
#spr1 "Hellenika/IsphiCommander_1.tga"
#spr2 "Hellenika/IsphiCommander_2.tga"
#name "Isphenoplian Commander"
#descr "Although the savants, leaders and librarians of Isphenople are usually human, they are only a minority in the ancient city. Most of its population is actually still of C'tissian origins, as it descends from the people of Isphi. While the C'tissians of Isphenople prefer to live peaceful lives as farmers, fishers, crafters and traders, they still have to defend their homes in case of war. They are skilled at surviving swamps and the desert, and like all C'tissians, they have a thick hide, innately resist poisons and are able to swim accross rivers. They however aren't very skilled in combat, and they actually are notorious for their cowardice. Since they expect their human leaders to protect them against invaders, they rarely volunteer in the military and ask for high wages in spite of their general inefficiency. As a testimony to their hybrid culture, they wear Ermorian bronze scale cuirasses but use falchions and round shields of C'tissian design instead of the tower shields standard to the Isphenoplian order of the Guardians of Knowledge."
#gcost 40
#rcost 1
#rpcost 1
#hp 12
#size 2
#prot 5
#mr 11
#mor 10
#str 11
#att 10
#def 10
#prec 10
#ap 10
#mapmove 14
#enc 4
#maxage 50
#weapon 10
#weapon 21
#armor 142
#armor 127
#armor 2
#okleader
#inspirational -1
#poisonres 6
#coldblood
#wastesurvival
#swampsurvival
#swimming
#nametype 113
#end

#newmonster 6892
#copyspr 1070
#name "Philosopher"
#descr "Since in the end their metaphysical discoveries inevitably find their way to the Archives of Isphenople, it is common for philosophers of Arcoscephale and beyond to leave their birth lands for the Ancient Library, where they hope to complete their path to wisdom and find some long-sought piece of hidden lore. Those do not always come back, for there is nothing in the outside world that they cannot find in the ancient scrolls of the Scholar Citadel. Since all the world's philosophers converge towards the Library during their journeys, they are a very common sight in the lands of Isphenople, and the Conclave often uses their services. They gather and speculate about the origins of the world, its morals and the fabric of the universe. Some delve into the mysteries of the Arcana and form hypothetical spell designs that are later tested by the Gnostics. Philosophers can research or build laboratories even though they do not have any magical skill, and their research abilities are far better in lands of sloth where there is a lot of time to do nothing but think. In addition, as soon as the Unutterable Vessel is constructed, all the philosophers of Isphenople will begin receiving metaphysical enlightenment in the form of newly gained skills in Astral magic, at the rate of one philosopher per province each month."
#hp 10
#size 2
#prot 0
#mr 12
#mor 8
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 10
#poorleader
#maxage 50
#older 35
#fixedresearch 10
#slothresearch 2
#weapon 674
#nametype 107
#gcost 65
#rcost 1
#rpcost 2
#userestricteditem 8059
#noreqlab
#magicskill 4 1
#magicboost 4 -2
#end

#newmonster 6894
#copyspr 1070
#name "Philosopher"
#descr "Since in the end their metaphysical discoveries inevitably find their way to the Archives of Isphenople, it is common for philosophers of Arcoscephale and beyond to leave their birth lands for the Ancient Library, where they hope to complete their path to wisdom and find some long-sought piece of hidden lore. Those do not always come back, for there is nothing in the outside world that they cannot find in the ancient scrolls of the Scholar Citadel. Since all the world's philosophers converge towards the Library during their journeys, they are a very common sight in the lands of Isphenople, and the Conclave often uses their services. They gather and speculate about the origins of the world, its morals and the fabric of the universe. Some delve into the mysteries of the Arcana and form hypothetical spell designs that are later tested by the Gnostics. Philosophers can research or build laboratories even though they do not have any magical skill, and their research abilities are far better in lands of sloth where there is a lot of time to do nothing but think. In addition, as soon as the Unutterable Vessel is constructed, all the philosophers of Isphenople will begin receiving metaphysical enlightenment in the form of newly gained skills in Astral magic, at the rate of one philosopher per province each month."
#hp 10
#size 2
#prot 0
#mr 12
#mor 8
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 10
#poorleader
#maxage 50
#older 35
#fixedresearch 10
#slothresearch 2
#weapon 674
#magicskill 4 1
#nametype 107
#gcost 65
#rcost 1
#rpcost 2
#userestricteditem 8059
#end

#selectmonster 1072
#descr "Engineers are down-to-earth philosophers specializing in the physics and mechanics of that which is observable. They do not concern themselves with moral values or esoteric musings. Instead, they try to define the laws governing the universe and use their findings to invent practical things. Engineers are very skilled at siegecraft and castle defence. While philosophers prefer to work in the comfort of forums and libraries, engineers often leave their homes and travel throughout the world to test their ideas and inventions."
#fixedresearch 3
#userestricteditem 8060
#montag 4126
#end

#selectmonster 678
#userestricteditem 8063
#end

#newmonster 6895
#copyspr 478
#copystats 478
#descr "Sages are students of the magic of the Spheres. They are not magically powerful, but excel at spell research. Like philosophers, they are very common in the lands of Isphenople and together represent the greatest of its strengths: knowledge."
#userestricteditem 8063
#gcost 85
#end

#selectmonster 679
#descr "Lore Masters are sages of extraordinary skill. They share the sages' aptitude for research, but are also skilled in various forms of magic. Those that serve the Ancient Library of Isphenople have the opportunity to take on the admirable mantle of a Scholarch, thus engraving their names forever in the annals of history."
#userestricteditem 8061
#end

#selectmonster 671 -- Golem
#userestricteditem 8062
#end

#newmonster 7172
#copystats 6
#spr1 "Hellenika/High_Bookkeeper_1.tga"
#spr2 "Hellenika/High_Bookkeeper_2.tga"
#name "High Bookkeeper"
#descr "High Bookkeepers are Guardians of Knowledge of great loyalty and experience that were chosen by the Conclave to coordinate Isphenople's troops. To symbolize their rank, they all bear a prestigious sword enchanted by the Conclave's Immortals themselves. They share all of the abilities of the Guardians of knowledge, and they are even more dangerous in combat due to their greater skills and that exceptional weapon. In addition to their more martial duties, they must be learned men of indubitable interest for philosophy and magic, as they serve as librarians and as leaders of the magical constructs Isphenople uses to defend its lands. As such, they know how to command magical troops as well as living ones, and they can even help the nation in research."
#weapon 1167
#nametype 106
#command -20
#magiccommand 40
#inspirational 1
#older 7
#fireres 5
#mr 15
#patrolbonus 10
#gcost 100
#rpcost 1
#fixedresearch 3
#userestricteditem 8062
#end

#newmonster 7173
#copystats 6
#spr1 "Hellenika/High_Bookkeeper_1.tga"
#spr2 "Hellenika/High_Bookkeeper_2.tga"
#name "Watcher of the Wastes"
#descr "Watchers of the Wastes are High Bookkeepers who accepted the specific function of guarding the Scholar Citadel's borders. Although they no longer watch over the Library directly, they know that their work is crucial to the defense of Isphenople and its precious knowledge. They are always accompanied by a Scribe Fencer tasked with managing encrypted communications with the Conclave as well as keeping an eye both on the military and the people."
#weapon 1167
#nametype 106
#command -20
#magiccommand 40
#inspirational 1
#older 7
#fireres 5
#mr 15
#patrolbonus 10
#gcost 100
#rpcost 1
#wastesurvival
#batstartsum1 "Scribe Fencer"
#end

#newmonster 7174
#spr1 "Hellenika/Archivist_1.tga"
#spr2 "Hellenika/Archivist_2.tga"
#name "Archivist"
#descr "Archivists are simultaneously erudites, diplomats and adventurers that form a great order at the center of all Isphenople's activities. Unlike the savants that come to Isphenople simply to make use of its precious books, they are men of action and loyal agents of the Ancient Library. Their goal is simple: to gather knowledge and record historical events for the Ancient Library. As such, they travel all around the globe and serve as the eyes and ears of the Scholar Citadel, ever-vigilant of all opportunities, including taking possession of old manuscripts, exploring ancient ruins to unearth forgotten secrets, or following important figures to write down an accurate account of their lives and actions. Although they are mostly pacifists interested only in the unlimited acquisition of knowledge, they are ready to employ every tool in their arsenal for this purpose, including lying, scheming and making use of their powerful mind-magic. While it is certainly true that they aren't warriors and despise physical violence, they consider the progress of science and mankind to ultimately be far more important than a single life and are very able to defend themselves if necessary thanks to the magical and martial art they created: scroll-fencing. This exotic fighting style makes use of scrolls and quills as shields and swords, and requires an expertise both physical and mystical that only Archivists, Gnostics and their disciples possess. Thus, typically covered in magical parchments, books and writing material, Archivists are permanently protected from mundane attacks by invisible wardings, but are very vulnerable to fire."
#hp 9
#size 2
#prot 0
#mr 13
#mor 12
#str 8
#att 10
#def 10
#prec 10
#enc 3
#mapmove 14
#ap 8
#poorleader
#weapon 92
#maxage 50
#gcost 160
#rcost 1
#rpcost 2
#fireres -5
#invulnerable 10
#magicskill 4 2
#custommagic 3072 100
#custommagic 3328 30
#stealthy 20
#spy
#userestricteditem 8063
#itemslots 15494 -- standard
#slothpower 1
#end

#newmonster 7175
#spr1 "Hellenika/Great_Archivist_1.tga"
#spr2 "Hellenika/Great_Archivist_2.tga"
#name "Great Archivist"
#descr "Great Archivists are Archivists of great renown that reached a high rank in their order after having proven themselves many times and gathered a considerable amount of knowledge for the Library in their past journeys. Immensely powerful astral mages, they also have impressive skills in earth magic and sometimes also know of air magic as well. Due to their importance, age and power, they no longer spend their time traveling like lesser Archivists, and instead put their experience to administrative uses. Unlike Gnostics, they generally operate in plain day, officially representing the Conclave wherever they go and acting for the greatest glory of Isphenople. In addition to all the abilities of regular Archivists, Great Archivists also start battles with a temporary astral gem that demonstrates their magical might."
#hp 9
#size 2
#prot 0
#mr 15
#mor 12
#str 8
#att 10
#def 10
#prec 10
#enc 3
#mapmove 14
#ap 8
#poorleader
#weapon 92
#maxage 50
#gcost 265
#rcost 1
#rpcost 4
#fireres -5
#tmpastralgems 1
#magicskill 3 1
#magicskill 4 3
#custommagic 3072 100
#custommagic 3072 20
#custommagic 1280 20
#stealthy 20
#invulnerable 10
#spy
#userestricteditem 8063
#itemslots 15494 -- standard
#slothpower 1
#end

#newmonster 7176
#spr1 "Hellenika/Keeper_of_Secrets_1.tga"
#spr2 "Hellenika/Keeper_of_Secrets_2.tga"
#name "Keeper of Secrets"
#descr "Keepers of Secrets, or Gnostics, are members of a very secretive order that is officially dedicated to classifying newly acquired knowledge and watching over the most precious scrolls of Isphenople. In truth, Gnostics are more than just librarians: they are the true power behind the Library and worshippers of a Divine Mystery so high and unutterable that it can only be described as a Dazzling Darkness. Gnostics all share the same goal: achieving Gnosis, that is to say Supreme Knowledge. They believe that reaching such a perfect truth shall allow them to transcend their own nature and that such is the will of the Awakening God for its faithful. To ascend towards Gnosis, a Gnostic must undergo several successive rites of initiation, each time reaching a higher rank in the Order and learning more of its mystical secrets. Thus, most members only know a very small part of the sacred Truth that they worship. Still, they serve their order with great zeal and discretion, and the few mysteries that they have been allowed to contemplate give them the power to chase down the forces of evil. As such, they are the priests of Isphenople and their sacred archives are its temples. Just like Archivists, they are protected by magical wards inscribed on scrolls that serve as their armors, but unlike them they rarely adventure outside the lands of Isphenople and do not master the art of scroll-fencing. In addition, they can cast Communion Slave even without knowledge of astral magic, and thus join a mystical communion with the masters of their order, and they can receive additional astral magic power from items even when they haven't already mastered astral magic."
#hp 9
#size 2
#prot 0
#mr 16
#mor 12
#str 8
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 8
#poorleader
#weapon 674
#weapon 1177
#maxage 50
#gcost 140
#rcost 1
#rpcost 2
#older 5
#fireres -5
#holy
#magicskill 4 1
#magicboost 4 -1
#magicskill 8 1
#custommagic 32640 100
#researchbonus 4
#invulnerable 10
#userestricteditem 8059
#itemslots 15494 -- standard
#end

#newmonster 7177
#spr1 "Hellenika/Keeper_of_Mysteries_1.tga"
#spr2 "Hellenika/Keeper_of_Mysteries_2.tga"
#name "Keeper of Highest Mysteries"
#descr "Keepers of Highest Mysteries are the masters of the Gnostic Order. They are members of the cult that have reached the highest of its ranks and thus had access to the Sealed Vault hidden below the Inner Archives of Isphenople. None except they know what resides within that Vault, but it is whispered that, there, they had the chance to see for themselves and contemplate the Dazzling Darkness of Gnosis in its whole splendor, and that this changed them, healing them from their humanity by burning it away from their souls. Some also believe that they unlocked the Secret of Immortality, and no-one has yet been able to prove this false. In any case, Keepers of Highest Mysteries demonstrate some very weird and powerful abilities, and although it is hard for the profane to recognize them and differentiate them from lower Gnostics, they truly are superior in their mystical might. Not only are they extremely powerful priests capable of deciphering the Thrones of Ascension's secrets and riddles, they also are in possession of such immense knowledge that, should they undergo a ritual of Empowerment in any path for the first time for that path, they would gain two more magic levels than normal in the process. In addition, should a Keeper of Highest Mysteries become the Awakening God's Prophet, he will receive one more priest level than normal. Finally, as the ritual masters of their Order, they will always lead astral communions in battle. Although Keepers of Highest Mysteries do not usually share their secrets, those that were empowered at least once will be able to unearth new ones with great ease and thus gain incredibly vast research abilities."
#hp 9
#size 2
#prot 0
#mr 18
#mor 12
#str 8
#att 8
#def 8
#prec 10
#enc 3
#mapmove 14
#ap 8
#poorleader
#weapon 674
#weapon 1177
#maxage 500
#domimmortal
#gcost 500
#rcost 1
#rpcost 4
#holy
#magicskill 8 1
#magicboost 53 2
#researchbonus 50
#slowrec
#fireres -5
#invulnerable 10
#userestricteditem 8059
#itemslots 15494 -- standard
#commaster
#end

#newmonster 6851
#copyspr 1226
#copystats 1226 -- Naiad
#descr "Naiades are river spirits that manifest themselves as incredibly beautiful women. Few mortals would dream of harming a naiad. Naiades are connected with their river and slowly die when they leave their home. Naiades are powerful mages of Water and Nature. They are sacred to the people of Arcadeia, and the nation can also recruit them for a low cost in underwater forts. They cost no upkeep."
#holy
#gcost 145
#addupkeep -145
#nametype 110
#rpcost 2
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 6878
#spr1 "Hellenika/Auloniad_1.tga"
#spr2 "Hellenika/Auloniad_2.tga"
#name "Auloniad"
#descr "Auloniades are wild, benevolent spirits of mountain pastures and vales that commonly reveal themselves to the nature-loving people of Arcadeia. Although they are comparable to Oreiades in their powers, appearance and nature, they are both far more common and less powerful. Still, they are incredibly beautiful and sacred beings, and they wield impressive powers over plants and animals. Although they can be recruited in every province with a laboratory and a temple and their upkeep never changes, they are far less costly in provinces with a fort. They are capable of casting the Transformation ritual."
#gcost 200
#rcost 1
#hp 10
#size 2
#mr 16
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#poorleader
#maxage 1000
#rpcost 2
#holy
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#magicskill 6 2
#magicskill 1 1
#custommagic 9984 100
#custommagic 9984 10
#weapon 92
#awe 4
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#montag 4153 -- can cast Transformation
#end

#newmonster 6879
#spr1 "Hellenika/Auloniad_1.tga"
#spr2 "Hellenika/Auloniad_2.tga"
#name "Auloniad"
#descr "Auloniades are wild, benevolent spirits of mountain pastures and vales that commonly reveal themselves to the nature-loving people of Arcadeia. Although they are comparable to Oreiades in their powers, appearance and nature, they are both far more common and less powerful. Still, they are incredibly beautiful and sacred beings, and they wield impressive powers over plants and animals. Although they can be recruited in every province with a laboratory and a temple and their upkeep never changes, they are far less costly in provinces with a fort. They are capable of casting the Transformation ritual."
#gcost 145
#addupkeep 55
#rpcost 2
#rcost 1
#hp 10
#size 2
#mr 16
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#poorleader
#maxage 1000
#holy
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#magicskill 6 2
#magicskill 1 1
#custommagic 9984 100
#custommagic 9984 10
#weapon 92
#awe 4
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#montag 4153 -- can cast Transformation
#end

#newmonster 7178
#spr1 "Hellenika/AnthousiadG_1.tga"
#spr2 "Hellenika/AnthousiadG_2.tga"
#name "Anthousiad"
#descr "Anthousiades are benevolent spirits of flowers and blossoms that reside in the most beautiful and fertile pastures, provided that civilization or dark magic doesn't taint these natural sanctums. They are very fragile and innocent beings and will quickly wither and die if they are forced to leave their birthlands. Still, they are powerful avatars of the earth's lifeforce and they'll spread their soft perfumes and influence for as long as peace is preserved around them. There are many different kinds of Anthousiad; all induce hedonism in living beings and thus increase sloth in their province, but each also increases a different scale based on their personality: either order, growth, fortune or magic will bloom along with the flowers around them. All Anthousiades also produce medicinal pollens and thus know how to heal their allies' wounds. They are considered sacred by the people of Arcadeia, can help the nation with research provided that a laboratory is present in the province and, nourishing themselves from the rays of the sun and the happiness of mortals, they cost neither upkeep nor commander points."
#gcost 60
#addupkeep -60
#rcost 1
#hp 10
#size 2
#mr 18
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#noleader
#maxage 500
#poormagicleader
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#incscale 1
#homesick 40
#autohealer 1
#firstshape -4127
#holy
#weapon 284
#awe 4
#fixedresearch 1
#rpcost 0
#fireres -5
#coldres -5
#poisonres -5
#shockres -5
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 7179
#spr1 "Hellenika/AnthousiadG_1.tga"
#spr2 "Hellenika/AnthousiadG_2.tga"
#name "Anthousiad"
#descr "Anthousiades are benevolent spirits of flowers and blossoms that reside in the most beautiful and fertile pastures, provided that civilization or dark magic doesn't taint these natural sanctums. They are very fragile and innocent beings and will quickly wither and die if they are forced to leave their birthlands. Still, they are powerful avatars of the earth's lifeforce and they'll spread their soft perfumes and influence for as long as peace is preserved around them. There are many different kinds of Anthousiad; all induce hedonism in living beings and thus increase sloth in their province, but each also increases a different scale based on their personality: either order, growth, fortune or magic will bloom along with the flowers around them. All Anthousiades also produce medicinal pollens and thus know how to heal their allies' wounds. They are considered sacred by the people of Arcadeia, can help the nation with research provided that a laboratory is present in the province and, nourishing themselves from the rays of the sun and the happiness of mortals, they cost neither upkeep nor commander points."
#gcost 60
#addupkeep -60
#rcost 1
#hp 10
#size 2
#mr 18
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#noleader
#maxage 500
#poormagicleader
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#incscale 1
#decscale 0
#homesick 40
#autohealer 1
#montag 4127
#holy
#weapon 284
#awe 4
#fixedresearch 1
#rpcost 0
#fireres -5
#coldres -5
#poisonres -5
#shockres -5
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 7180
#spr1 "Hellenika/AnthousiadM_1.tga"
#spr2 "Hellenika/AnthousiadM_2.tga"
#name "Anthousiad"
#descr "Anthousiades are benevolent spirits of flowers and blossoms that reside in the most beautiful and fertile pastures, provided that civilization or dark magic doesn't taint these natural sanctums. They are very fragile and innocent beings and will quickly wither and die if they are forced to leave their birthlands. Still, they are powerful avatars of the earth's lifeforce and they'll spread their soft perfumes and influence for as long as peace is preserved around them. There are many different kinds of Anthousiad; all induce hedonism in living beings and thus increase sloth in their province, but each also increases a different scale based on their personality: either order, growth, fortune or magic will bloom along with the flowers around them. All Anthousiades also produce medicinal pollens and thus know how to heal their allies' wounds. They are considered sacred by the people of Arcadeia, can help the nation with research provided that a laboratory is present in the province and, nourishing themselves from the rays of the sun and the happiness of mortals, they cost neither upkeep nor commander points."
#gcost 60
#addupkeep -60
#rcost 1
#hp 10
#size 2
#mr 18
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#noleader
#maxage 500
#poormagicleader
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#incscale 1
#decscale 3
#homesick 40
#autohealer 1
#montag 4127
#holy
#weapon 284
#awe 4
#fixedresearch 1
#rpcost 0
#fireres -5
#coldres -5
#poisonres -5
#shockres -5
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 7181
#spr1 "Hellenika/AnthousiadJ_1.tga"
#spr2 "Hellenika/AnthousiadJ_2.tga"
#name "Anthousiad"
#descr "Anthousiades are benevolent spirits of flowers and blossoms that reside in the most beautiful and fertile pastures, provided that civilization or dark magic doesn't taint these natural sanctums. They are very fragile and innocent beings and will quickly wither and die if they are forced to leave their birthlands. Still, they are powerful avatars of the earth's lifeforce and they'll spread their soft perfumes and influence for as long as peace is preserved around them. There are many different kinds of Anthousiad; all induce hedonism in living beings and thus increase sloth in their province, but each also increases a different scale based on their personality: either order, growth, fortune or magic will bloom along with the flowers around them. All Anthousiades also produce medicinal pollens and thus know how to heal their allies' wounds. They are considered sacred by the people of Arcadeia, can help the nation with research provided that a laboratory is present in the province and, nourishing themselves from the rays of the sun and the happiness of mortals, they cost neither upkeep nor commander points."
#gcost 60
#addupkeep -60
#rcost 1
#hp 10
#size 2
#mr 18
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#noleader
#maxage 500
#poormagicleader
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#incscale 1
#decscale 4
#homesick 40
#autohealer 1
#montag 4127
#holy
#weapon 284
#awe 4
#fixedresearch 1
#rpcost 0
#fireres -5
#coldres -5
#poisonres -5
#shockres -5
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 7182
#spr1 "Hellenika/AnthousiadD_1.tga"
#spr2 "Hellenika/AnthousiadD_2.tga"
#name "Anthousiad"
#descr "Anthousiades are benevolent spirits of flowers and blossoms that reside in the most beautiful and fertile pastures, provided that civilization or dark magic doesn't taint these natural sanctums. They are very fragile and innocent beings and will quickly wither and die if they are forced to leave their birthlands. Still, they are powerful avatars of the earth's lifeforce and they'll spread their soft perfumes and influence for as long as peace is preserved around them. There are many different kinds of Anthousiad; all induce hedonism in living beings and thus increase sloth in their province, but each also increases a different scale based on their personality: either order, growth, fortune or magic will bloom along with the flowers around them. All Anthousiades also produce medicinal pollens and thus know how to heal their allies' wounds. They are considered sacred by the people of Arcadeia, can help the nation with research provided that a laboratory is present in the province and, nourishing themselves from the rays of the sun and the happiness of mortals, they cost neither upkeep nor commander points."
#gcost 60
#addupkeep -60
#rcost 1
#hp 10
#size 2
#mr 18
#mor 10
#str 9
#att 10
#def 10
#prec 10
#enc 2
#mapmove 2
#ap 12
#noleader
#maxage 500
#poormagicleader
#mountainsurvival
#heal
#female
#stealthy
#nametype 110
#incscale 1
#decscale 5
#homesick 40
#autohealer 1
#montag 4127
#holy
#weapon 284
#awe 4
#fixedresearch 1
#rpcost 0
#fireres -5
#coldres -5
#poisonres -5
#shockres -5
#userestricteditem 8069 -- for Thalamanth and Nabatem
#twiceborn 6828
#end

#newmonster 7183
#spr1 "Hellenika/Shepherd_1.tga"
#spr2 "Hellenika/Shepherd_2.tga"
#name "Shepherd"
#descr "Arcadeians have always been a pastoral people of shepherds. Therefore, shepherds can very easily be found on the slopes and vales of Arcadeia. Although the most experienced among them can make good guides for troops in uncivilized lands, their greatest use in war besides scouting resides in their ability to assemble herds of goats. These animals can then be used either as a way to produce supplies for regular troops or as emergency troops themselves. Like all Arcadeians, shepherds are peaceful hedonists and will be stronger in lands of sloth. In addition, their great independence allows them to cost half the upkeep they normally would."
#nametype 107
#gcost 20
#addupkeep -12
#rcost 1
#hp 10
#size 2
#prot 0
#mr 11
#mor 9
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 2
#ap 12
#poorleader
#command 10
#maxage 50
#animalawe 2
#inspirational -1
#beastmaster 3
#stealthy
#supplybonus 5
#makemonsters1 2227
#mountainsurvival
#weapon 7
#weapon 22
#slothpower 1
#rpcost 1
#end

#newmonster 7184
#spr1 "Hellenika/Aoidos_1.tga"
#spr2 "Hellenika/Aoidos_2.tga"
#name "Rhapsode"
#descr "Rhapsodes, or Aoidoi, are Arcadeian elders that have mastered the arts of sacred music and poetry as taught by the nymphs and their ancestors. They spend their lives traveling from a village to the next and chanting their stories as a gift of wisdom and beauty to their countrymen. Such poems and songs vary widely in content; some are tales of epic battles and adventures through the world, others are hymns of joy and veneration to nature and its beloved spirits, others still are practical counsels about life, love, or the natural cycles. But all are sacred to the people of Arcadeia, and thus rhapsodes all have priestly powers, even though a temple is not required to recruit them. Like all Arcadeian priests, they can receive increased priestly powers by using ancient rhapsodies crafted by astral magic."
#nametype 107
#gcost 40
#rcost 1
#hp 10
#size 2
#prot 0
#mr 11
#mor 9
#str 10
#att 8
#def 8
#prec 10
#enc 3
#mapmove 2
#ap 12
#poorleader
#mountainsurvival
#maxage 50
#startage 60
#stealthy
#weapon 7
#slothpower 1
#magicskill 8 1
#custommagic 2048 20
#rpcost 1
#spellsinger
#userestricteditem 8058
#noreqtemple
#end

#newmonster 6857 -- Mounted Commander
#copyspr 46
#copystats 46
#slothpower 1
#nametype 107
#mountedhumanoid
#end

#newmonster 7185
#spr1 "Hellenika/Lychan1.tga"
#spr2 "Hellenika/Lychan2.tga"
#name "Lychantropos"
#descr "Lychantropoi are the Lychantropos Kings' offspring. These half-human half-wolf beings are not as strong as regular werewolves, for their fathers' curse has been diluted in their blood. Still, they are formdiable wild warriors and share most of their progenitors' traits. Like their masters, they still resent the nymphs to this day; but unlike them, they aren't tied by honor nor watched by Arcadeia's semi-divine mistresses. As such, they are free to spread heresy and chaos everywhere they go."
#gcost 20
#heretic 1
#darkvision 50
#berserk 2
#nametype 107
#size 2
#hp 14
#prot 3
#mr 10
#mor 15
#str 12
#att 12
#def 12
#prec 5
#ap 14
#mapmove 4
#enc 2
#maxage 50
#weapon 20
#weapon 29
#weapon 29
#regeneration 10
#stealthy
#makemonsters3 284
#forestsurvival
#invulnerable 10
#heretic 1
#incunrest 5
#end

#newmonster 7186
#spr1 "Hellenika/LychanKing1.tga"
#spr2 "Hellenika/LychanKing2.tga"
#name "Lychantropos King"
#descr "Lychantropos Kings are the offspring of Lykaon, Pandora's brother and a great tyrant that reigned over Arcadeian humans long after her disappearance. He was beloved by his people and accomplished great deeds in its name, but prosperity wasn't enough for him as he couldn't forget his sister since she had received divine punishment for her mistakes. As a result he secretly hated the nymphs - the semi-divine guardians that were tasked with keeping mortals away from Pandora's memorial and the products of her misstep - and he dreamed of vengeance against the Pantokrator. So he devised a plan to trick the Great One, soil his sanctity and prove his servants that his power had limits, so that a great rebellion could begin against him. Convinced of the fact that the Pantokrator wasn't really omniscient, he killed one of his own sons and served his flesh as a dish to the Pantokrator during a feast he had prepared in his honor. Should he have succeeded, he would have shown all lesser deities evidence of the Pantokrator's weakness, all the while defiling his pure light, the greatest symbol of his power. But in truth, the Pantokrator had intentionally feigned ignorance so that Lykaon would believe he could be tricked and would commit such an unforgivable crime. Falling into his trap, the ancient king was punished for all eternity along with his offspring, and since then he and his remaining sons have been cursed with the grotesque attributes of a half-human half-wolf body. Humiliated and dishonored, Arcadeia's Kings no longer have any real political power. Still, they are respected by the denizens of the Valley as the bearers of a noble and heroic blood and as the symbols of a past whose darkest moments have been erased from all but a few memories by the nymphs and their dreamlike gifts. These semi-divine werewolves still resent the nymphs to this day. Although they hide their true feelings and obey their watchers, they can call lesser Lychantropoi that spread heresy and chaos."
#gcost 225
#rpcost 4
#hp 20
#size 3
#prot 6
#mr 14
#mor 18
#str 14
#att 13
#def 13
#prec 5
#ap 14
#mapmove 4
#enc 2
#weapon 20
#weapon 29
#weapon 29
#invulnerable 15
#stealthy
#regeneration 10
#beastmaster 1
#forestsurvival
#goodleader
#darkvision 50
#berserk 4
#nametype 107
#armor 148
#makemonsters1 "Lychantropos"
#batstartsum5 "Lychantropos"
#assassin
#patience 3
#animalawe 3
#scalewalls
#end

#newmonster 6833
#copystats 2820
#copyspr 2820
#name "Bone Reader"
#descr "Although it is possible that the shamans of the Bone Tribes once encountered the Enkidus of the swamps of Ur - which after all aren't located exceedingly far from Nabatem - and learned their ways from the wild men, they also clearly share some cultural traits with the Amazons of the Onyx Tribe, and it yet remains to discover whether this is a simple coincidence or the sign of common origins. They call themselves Bone Readers and their magic is similar in many ways both to that of Enkidu shamans and Onyx sorceresses. The Bone Readers make bone charms for the warriors of the tribe and prepare the cannibalistic feast held after a victorious battle. Like lesser members of Nabatem's Bone Tribes, Nabatem's Bone Readers are attracted by lands of death where they can more easily practice their dark shamanism, and they cost no upkeep whatsoever. In addition, as Nabatem's Bone Tribes are more nomadic than those that dwell outside its sphere of influence, their chieftains and shamans also are somewhat competent warleaders. Of course, practicing cannibalism on a ritual level, they sometimes know how to use blood magic - a secret that they're willing to share with the Amazons. Finally, a few of them were illuminated by the ever-growing influence of the Awakening God and gained priestly powers or additional powers over death through the ecstatic worship of some Dark Rock Fallen from the Stars or the tending of some ancient mausoleum once built for a now forgotten royalty of Saqaba. Although they can't be recruited without a summoned Desolate Presence to unite them under its worship in their province, members of Nabatem's Bone Tribes will spontaneously appear in provinces controlled by the Lost Necropolis where a dominion of Death is strong. Temples can also be built to increase their numbers."
#okleader
#gcost 0
#rpcost 2
#custommagic 53248 20
#monpresentrec "Desolate Presence"
#end

#newmonster 7187
#spr1 "Hellenika/Zuna_1.tga"
#spr2 "Hellenika/Zuna_2.tga"
#copystats 102
#name "Zuna Betrayer"
#descr "Zunas, sometimes called the Blue People or the Lazuli as well, are a rare species of blue inorganic humanoids whose natural habitats are the most arid and hot deserts of the world. They usually live a nomadic lifestyle in small, reclusive tribes, the most powerful of which is called the Ifinagh tribe. Zunas are believed to have a liquid body composed mostly of magical water, and as such they are extremely resistant to fire and have a natural affinity for water magic. Although they can easily breathe in aquatic environments, their bodies also have a tendency to lose some of their matter to the currents and to meld with the ocean. Therefore, Zunas' health quickly deteriorates when underwater, and it is almost unheard of for one of them to survive more than a year in such a place. It is for this reason that Zunas usually choose to stay in the desert: they don't have any difficulty surviving in the wastes, even in the absence of food, and they know that no other place is more hospitable to their kind. Although the Ifinagh exist as a nation free from oppressors, other weaker Zuna tribes have been entirely enslaved by the Onyx Amazons of Nabatem, who find their race very useful for their innate powers over water. Members of such tribes do not revere the Awakening God and secretly hope that the Inifagh will one day come to free them. In addition, as slaves, they have very low morale, and since their mastery of magic does not come from scholarship, they make quite poor researchers. It even may happen that some Zuna slaves escape from their masters and run away in the desert where human beings would have trouble following them, and if the capital was ever captured by the enemy, he would receive the help of one additional Zuna for free every month as long as the city isn't besieged. Illuminated by the Awakening God, the Zuna Betrayer no longer is a slave or a heretic and willingly serves the Onyx Tribe. He has a great morale and increased powers over water."
#rpcost 1
#noleader
#wastesurvival
#mor 30
#pierceres
#bluntres
#slashres
#researchbonus -3
#fireres 15
#poisonres -5
#coldres -5
#gcost 0
#custommagic 640 10
#uwdamage 10
#magicbeing
#neednoteat
#magicboost 2 2
#heal
#end

#newmonster 7188
#spr1 "Hellenika/Zuna_1.tga"
#spr2 "Hellenika/Zuna_2.tga"
#copystats 102
#name "Zuna Slave"
#descr "Zunas, sometimes called the Blue People or the Lazuli as well, are a rare species of blue inorganic humanoids whose natural habitats are the most arid and hot deserts of the world. They usually live a nomadic lifestyle in small, reclusive tribes, the most powerful of which is called the Ifinagh tribe. Zunas are believed to have a liquid body composed mostly of magical water, and as such they are extremely resistant to fire and have a natural affinity for water magic. Although they can easily breathe in aquatic environments, their bodies also have a tendency to lose some of their matter to the currents and to meld with the ocean. Therefore, Zunas' health quickly deteriorates when underwater, and it is almost unheard of for one of them to survive more than a year in such a place. It is for this reason that Zunas usually choose to stay in the desert: they don't have any difficulty surviving in the wastes, even in the absence of food, and they know that no other place is more hospitable to their kind. Although the Ifinagh exist as a nation free from oppressors, other weaker Zuna tribes have been entirely enslaved by the Onyx Amazons of Nabatem, who find their race very useful for their innate powers over water. Members of such tribes do not revere the Awakening God and secretly hope that the Inifagh will one day come to free them. In addition, as slaves, they have very low morale, and since their mastery of magic does not come from scholarship, they make quite poor researchers. It even may happen that some Zuna slaves escape from their masters and run away in the desert where human beings would have trouble following them, and if the capital was ever captured by the enemy, he would receive the help of one additional Zuna for free every month as long as the city isn't besieged. Still, they are extremely cheap mages and can be trained very quickly in all wastes controlled by Nabatem, as well as in the capital where all kinds of slave can be found easily."
#rpcost 1
#heretic 1
#noleader
#wastesurvival
#mor 7
#pierceres
#bluntres
#slashres
#researchbonus -3
#fireres 15
#poisonres -5
#coldres -5
#gcost 35
#custommagic 640 10
#uwdamage 10
#magicbeing
#neednoteat
#deserter 1
#heal
#slave
#prophetshape "Zuna Betrayer"
#end

#newmonster 7189
#spr1 "Hellenika/Zuna_1.tga"
#spr2 "Hellenika/Zuna_2.tga"
#copystats 102
#name "Freed Zuna"
#descr "Zunas, sometimes called the Blue People or the Lazuli as well, are a rare species of blue inorganic humanoids whose natural habitats are the most arid and hot deserts of the world. They usually live a nomadic lifestyle in small, reclusive tribes, the most powerful of which is called the Ifinagh tribe. Zunas are believed to have a liquid body composed mostly of magical water, and as such they are extremely resistant to fire and have a natural affinity for water magic. Although they can easily breathe in aquatic environments, their bodies also have a tendency to lose some of their matter to the currents and to meld with the ocean. Therefore, Zunas' health quickly deteriorates when underwater, and it is almost unheard of for one of them to survive more than a year in such a place. It is for this reason that Zunas usually choose to stay in the desert: they don't have any difficulty surviving in the wastes, even in the absence of food, and they know that no other place is more hospitable to their kind. Although the Ifinagh exist as a nation free from oppressors, other weaker Zuna tribes have been entirely enslaved by the Onyx Amazons of Nabatem, who find their race very useful for their innate powers over water. But now that the Lost Necropolis has been captured by the armies of another God, the Zunas have been released and will serve their saviors to the best of their abilities. Thus, as long as the Unearthed Queens are exiled from Nabatem and the city isn't besieged, Nabatem's controler will receive the help of one more such freed Zuna every month for free. In addition, freed Zunas are so exalted by their liberation that they benefit from a high morale, higher chances than usual of mastering better magic, and an entirely non-existent upkeep."
#rpcost 1
#noleader
#wastesurvival
#mor 12
#pierceres
#bluntres
#slashres
#researchbonus -3
#fireres 15
#poisonres -5
#coldres -5
#gcost 0
#custommagic 640 25
#uwdamage 10
#magicbeing
#neednoteat
#heal
#end

#newmonster 7190
#copystats 357
#spr1 "Hellenika/OnyxCommander_1b.tga"
#spr2 "Hellenika/OnyxCommander_2b.tga"
#name "Onyx Commander"
#nametype 135
#descr "Onyx Commanders are Amazon warriors of the Onyx Tribe that have shown great skills and loyalty in battle. They are brutal, cold and cruel, qualities that are appreciated for women in Nabatem's society. Although they do not gain sacred status themselves, they are rewarded for their military zeal by receiving from the Necropolis' vaults holy baetyl armaments that heavily protect them both from magic and mundane attacks and allow them to inflict tremendous backlash to those of their enemies that bear divine protection. They very commonly practice slavery as well and are very efficient at leading slaves in battle as well as when selling blood slaves for gold in Saqaba's market."
#weapon 1160
#armor 53
#armor 211
#armor 881
#okleader
#command 20
#mr 13
#mor 13
#str 13
#att 12
#hp 12
#rpcost 1
#taskmaster 2
#userestricteditem 8069
#twiceborn 6675
#itemslots 15494 -- standard
#startitem 863
#woundfend 1
#end

#newmonster 7191
#spr1 "Hellenika/UnearthedConsort_1d.tga"
#spr2 "Hellenika/UnearthedConsort_2d.tga"
#name "Unearthed Consort"
#descr "An Unearthed Consort is the dried husk of an ancient king of Nabatem, that is to say, the spouse chosen by an Amazon Queen to accompany her in eternity. In Nabatem, polygamy is the norm for women of power. In addition to their female lovers, they generally have an entire male harem at their disposal, and although their men are usually slaves, they still must fit many different criteria, such as external beauty, good health, a learned mind, talent, docility, respect, and a general nobility of heart. But those are only the required conditions to enter a great priestess' or sorceress' harem and avoid being taken by a lesser nobility instead, or worse, becoming a non-recreative slave, a worker or a soldier, as is the case for the majority of captured men. Although becoming a royal concubine by entering a harem is hard and reserved for an elite, it isn't the end of potential hierarchical ascension for slaves, for every harem is shaped by its internal competition between slaves to become the one and only Consort. Indeed, when the harem's mistress is particularly satisfied by one of her concubines, she can choose to enfranchise him and to either give him a position of high servant as a paid eunuch or, in rarer cases, declare him as her eternal spouse, her Consort, and make him the closest thing there is to her equal for a male. In both cases, the chosen concubine only receives a very limited, although very real, amount of freedom and becomes respected as a true, although not fully independent, member of his royal house. When finally time comes for an Amazon leader to enter the Necropolis and be enthroned as an Eternal Queen, she brings with her her entire harem and her Consort is compelled to follow her, gaining with her sacred status and immortality. Such a Consort is then called King and can even receive limited political responsibility as the bearer of his Queen's sacred Will and supreme Authority. Consorts can only be recruited in presence of their Queen."
#hp 18
#size 3
#ressize 2
#prot 6
#mr 17
#mor 30
#expertleader
#expertundeadleader
#str 15
#att 16
#def 16
#prec 10
#ap 25
#enc 0
#maxage 500
#mountedhumanoid
#itemslots 13446 -- no feet
#gcost 290
#rcost 1
#rpcost 3
#mapmove 24
#holy
#undead
#immortal
#mountainsurvival
#mounted
#pooramphibian
#neednoteat
#fear 5
#poisonres 25
#coldres 15
#fireres -10
#haltheretic 3
#clearweapons
#cleararmor
#weapon 1160
#weapon 56
#armor 53
#armor 148 -- 211 for meteorite cap
#armor 881
#wastesurvival
#spiritsight
#pierceres
#nametype 113
#monpresentrec 4673
#end

#newmonster 7192
#copystats 356
#spr1 "Hellenika/Priestess_1.tga"
#spr2 "Hellenika/Priestess_2.tga"
#name "Stygian Priestess"
#descr "As we know, below Saqaba lies a vast, ancient and multi-layered necropolis; but that isn't the last of Nabatem's secrets, for below that very necropolis also lie other things. One, if not the most important of them, is a cold and black river that leads straight to the Underworld, and whose still waters are enchanted with magical properties, such as powers of divination or immortality. Thus, after their discovery of these mystical caves far under the Necropolis, the Amazons of the Onyx Tribe developed in Nabatem a new caste of priestesses and sorceresses that other independent Onyx Amazons do not share with them. These mystics are called Stygian from the name of the sources of the Underworld. Stygian priestesses are a more secretive and deliberately humble order than that of usual Onyx priestesses, and thus have a lesser spiritual status. They are silent women that refuse temporary power to study the waters of eternal sorrow and ritually mourn the dead without an end. That is not to say that they are pacifists or condemn murder, far from it. Instead, they find nobility in the suffering of separation between the living and the dead, and want to cultivate that nobility as the most beautiful and meaningful thing in the world. Of course, peace definitely also is something they revere, but pain, to them, is in the natural order of things and shouldn't be considered the enemy. In a way, it even is sacred, and that understanding is what lets Stygian priestesses use their powers. For they aren't simple priests indeed. Not only are they able to read glimpses of the future in the subterranean currents, but by mourning the dead and following the stygian flows until a path to their lands opens before them, they can under specific circumstances call them back to the land of the living, and in particular they can return their God to the sunlit world far quicklier than other priests, according to the Divine Will and the fluctuations of the River of Souls."
#clearmagic
#nametype 135
#poorleader
#elegist 2
#rpcost 1
#custommagic 512 50
#custommagic 4096 10
#magicskill 8 1
#gcost 70
#userestricteditem 8069
#nobadevents 3
#spiritsight
#twiceborn 6675
#end

#newmonster 7193
#copystats 355
#spr1 "Hellenika/Sorceress_1.tga"
#spr2 "Hellenika/Sorceress_2.tga"
#name "Stygian Sorceress"
#descr "As we know, below Saqaba lies a vast, ancient and multi-layered necropolis; but that isn't the last of Nabatem's secrets, for below that very necropolis also lie other things. One, if not the most important of them, is a cold and black river that leads straight to the Underworld, and whose still waters are enchanted with magical properties, such as powers of divination or immortality. Thus, after their discovery of these mystical caves far under the Necropolis, the Amazons of the Onyx Tribe developed in Nabatem a new caste of priestesses and sorceresses that other independent Onyx Amazons do not share with them. These mystics are called Stygian from the name of the sources of the Underworld. Stygian sorceresses are Amazons that ritually bathed in the River of Souls and thus gained limited immortality and sacred powers over Water, Death and the Spheres. Although they can be killed like anyone else and won't come back unlike their lich Queens, they still can live for centuries without losing their youth and are almost immune to mundane weapons, as if only the most destructive attacks were able to damage their very skin. They learned their arts from the Kokythiai, nymphs of the Underworld, and since their return to the sunlit world they bear great magical powers and arrogance. They love to take part in every battle, inflicting suffering and death with great joy and cruelty, all the while showing their almost naked beauty behind their entire lack of armor. As such, most unlike Stygian priestesses, Stygian sorceresses are as exuberant as they are cold and quickly became the major war mages of Nabatem's kingdom, which is undoubtedly a great advantage in spite of their costly and luxury exigences, for they are mighty spellcasters, as can be seen in their ability to conjure a temporary water gem at the start of every battle. In the very end, those that proved themselves the best shall be chosen by the Unearthed Queens of Saqaba to be enthroned and reborn as one of them."
#clearmagic
#nametype 135
#holy
#rpcost 2
#magicskill 2 2
#magicskill 5 1
#custommagic 7168 100
#custommagic 5120 100
#custommagic 7680 15
#invulnerable 15
#heal
#spiritsight
#maxage 300
#older -100
#gcost 290
#tmpwatergems 1
#userestricteditem 8069
#twiceborn 6675
#end

#newmonster 6673
#copystats 178
#spr1 "Hellenika/UnearthedQueen_1d.tga"
#spr2 "Hellenika/UnearthedQueen_2d.tga"
#name "Unearthed Queen"
#descr "An Unearthed Queen, or Eternal Queen as the Amazons call them, is the dried husk of an ancient Amazon Queen of Nabatem, a High Priestess of the Baetylic cult of the Necropolis, and a grand master of Death and Earth magic. In Nabatem, the ritual of lichcraft is institutionalized as a great Ceremony of Enthronement in which a powerful Amazon leader of high nobility and exceptional deeds, either a priestess or a sorceress, is chosen by the already existing Queens of Saqaba and reborn as one of them along with her entire household. As a result, she exchanges her life and that of her consort for immortality for them both and she becomes an undead mage-priest of immense power as well as a member of the supreme council that leads Nabatem's destiny. In the ancient times, when the Onyx Tribe first found Saqaba and its antediluvian Necropolis, its sorceresses studied these mysterious places of power with great fascination and interest, which led to the discovery of mystical secrets such as the one that started the Unearthed Queens' dynasty and is still being used today during their enthronement. Now, although new upper layers of Amazon origins were built in the since then fully appropriated Necropolis, the Unearthed Queens still continue their research devoutly, hungry for power, knowledge and the glory of their Awakening God, and with each of their steps in that progress they grant new weapons to their kindgom. As such, for as long as either an Unearthed Queen or one of her Consorts is entering one of Nabatem's capital city's sites, there is a small chance that they will find a great treasure of magical gems of Death, and even more wonderful relics may be found if both members of such an eternal couple are entering these sites simultaneously - one of them studying a Baetyl Obelisk for mystical secrets, and the other one challenging the deadly traps and guardians of the Carved City with these very secrets as his or her weapons."
#female
#nametype 135
#clearmagic
#armor 148
#holy
#fear 5
#poorleader
#magicskill 3 1
#magicskill 5 3
#custommagic 7680 100
#custommagic 3584 100
#custommagic 7680 15
#magicskill 8 3
#gcost 515
#rcost 1
#rpcost 4
#mountainsurvival
#wastesurvival
#userestricteditem 8069
#end

#newmonster 7194
#copystats 356
#spr1 "Hellenika/Lithomancer_1.tga"
#spr2 "Hellenika/Lithomancer_2.tga"
#name "Onyx Lithomancer"
#descr "Onyx Lithomancers are powerful yet reclusive Amazon smith-mages that draw their powers from the mountains, and forge, sculpt and carve stones both through physical and magical skills. They are priestesses of the Earth and consider onyx, obisidian and baetylic iron as sacred materials linked to Strength, Stability, Purity and the Underworld. Although they are rare and prefer to practice their art in loneliness, they undoubtedly are one of the greatest strengths of the Onyx Tribe, to which they usually stay loyal and from which they receive great honor, and more than one Onyx sorceress learned her talents by becoming a Lithomancer's apprentice. Although they dislike purely intellectual tasks and thus aren't exceptional researchers, they still are very powerful mages and start all their battles with a temporary earth gem. In addition, they craft tools and weaponry for their patrons and are the origins of the renowned Onyx Amazons' heavy armaments, therefore naturally producing resources in the province where they're located. While it is true that some reside in the red canyons of Saqaba itself, Onyx Lithomancers can also be found in all of Nabatem's highlands and mountains and are usually recruited there to allow for a more efficient use of the capital's infrastructures."
#clearmagic
#str 14
#hp 12
#older -5
#nametype 135
#okleader
#rpcost 4
#magicskill 3 2
#magicskill 5 1
#magicskill 8 1
#custommagic 5120 50
#custommagic 5120 10
#gcost 205
#userestricteditem 8069
#resources 20
#weapon 14
#researchbonus -4
#tmpearthgems 1
#twiceborn 6675
#end

#newmonster 7195
#spr1 "Hellenika/ArcaneMenhir.tga"
#name "Arcane Menhir"
#descr "Arcane Menhirs are sentient megaliths of great wisdom adorned with ancient mystical runes of either benevolence or malevolence called triskeles. According to legends, they taught the druids of Marverni how to awaken their warriors' hidden potential by inscribing magical tattoos on their skins. They possess subtle magical powers that can be increased to tremendous proportions with the help of great choruses of singing stones and menhirs. As such, they are the primary mages and priests of Karanaac and are trusted by the Geodetic Awakening as reliable nodes and transmitters of its sacred Will across the world wide harmonic network of stones."
#noheal
#hp 85
#size 6
#prot 21
#mr 16
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 195
#rcost 1
#rpcost 2
#addupkeep -195
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 1
#custommagic 15360 10
#bonusspells 1
#researchbonus 3
#magicstudy 1
#nametype 142
#end

#newmonster 7196
#spr1 "Hellenika/Filiposa.tga"
#name "Speaking Stone"
#descr "Speaking Stones are sentient megaliths of black, polished granite and huge size that are carved with a symbolic, minimalistic and unmovable face representing their soul and gifting them with speech. They are powerful guardians of the Underworld whose enigmatic words bear terrible charms and curses. Their crude and eerie resemblance to human beings gives them an uncanny and paradoxically inhuman aspect, underlining very well their alien, unforgiving personalities. Although they are very rare, they are still deeply feared by mortals, and for good reason: in addition to their great magical might and priestly authority, they are known to possess strange and unique abilities, such as that of cursing with dire bad luck anyone who touches them. Thanks to their rudimentary humanoid features and to their subtle mastery of language, they are also more able than other megaliths to preach as well as to use magical items. Finally, should they be threatened, they know how to release spirits of the dead to defend themselves and their holy ground."
#noheal
#hp 150
#size 6
#prot 22
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#poormagicleader
#stonebeing
#miscshape
#itemslots 12288 -- 2 misc
#spellsinger
#gcost 270
#rcost 1
#rpcost 3
#addupkeep -270
#holy
#magicskill 8 2
#custommagic 15360 300
#bonusspells 1
#researchbonus 8
#nametype 142
#curseluckshield 1
#inquisitor
#drainimmune
#batstartsum3 "Corpse Candle"
#end

#newmonster 7197
#spr1 "Hellenika/Dolmen.tga"
#name "Dolmen"
#descr "A Dolmen is a complex megalithic monument composed of at least three different stones, among which at least one, the Table, is roughly horizontal and covers several of the others. Thus, most dolmens have the general shape of a door without walls, and this is no coincidence, for dolmens are known by druids and mystics to be gates to the Underworld and the korrigans' kingdoms. With the Geodetic Awakening, like other kinds of megaliths, Dolmens have started to gain sentience, and while it is true that each stone retains its own soul, the Dolmens' are fused into a single consciousness through the Polyphony of Stones. Like menhirs, dolmens are sacred to Karanaac, even though they can be erected without temples - and as such, they are often used to build temples in faraway provinces. In addition, since they are often located close to stone fields of great size and are inhabited by very powerful spirits due to their internal polyphony, they can be used as commanders for a great number of troops or, more classicaly, korrigans, menhirs and singing stones - an ability that isn't shared by most other megaliths. Incidentally, their great wisdom can be used for fairly efficient research. Finally, their presence is necessary to recruit most of the Armaerix Tribe's sacred warriors and sages, provided that one of their Oppidums or Stone Circles is present in the province."
#noheal
#hp 100
#size 6
#prot 20
#mr 15
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#immobile
#bonusspells 1
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#expertleader
#okmagicleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 100
#rcost 1
#rpcost 1
#addupkeep -100
#fixedresearch 7
#magicskill 8 1
#nametype 142
#deathcurse
#noreqtemple
#end

#newmonster 7198
#spr1 "Hellenika/Cairn.tga"
#name "Cairn"
#descr "Cairns, or Thinking Stones, are uncommon megaliths composed of several medium-sized stones arranged in such a way that removing a single of them would probably be enough to unbalance their ensemble. As such, they are symbols of perfect harmony, their cooperation being necessary to their stability. Similarly, although each of their stones is inhabited by a very primitive and simple spirit - alone almost inert and incapable of complex thought -, when put together, a common consciousness of a higher level than those of most mortals emerges from their meditation. And reciprocally, the same kind of equilibrium can be found between different cairns themselves; for they very often form vast geometrical figures in the landscape, so far away from each other that they wouldn't seem linked without looking at a map, but also so intrinsically connected that their mystical conjunction and entanglement causes the whole province to participate in the Geodetic Awakening. All these facts, when put together, explain why Cairns are exceptional researchers yet not sacred to Karanaac, and why only a specific number of them can efficiently take part in Karanaac's mystical reflections, that number being at all times equal to the intensity of Karanaac's dominion in the province. It is worth noting that Thinking Stones are also much more sensitive than normal researchers to Drain and Magic scales, even when compared to the other magically attuned megaliths of Karanaac."
#noheal
#hp 45
#size 4
#prot 17
#mr 13
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#immobile
#bonusspells 1
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 200
#rcost 1
#rpcost 1
#addupkeep -200
#divineins
#fixedresearch 20
#magicstudy 2
#nametype 142
#deathcurse
#comslave
#end

#newmonster 7199
#spr1 "Hellenika/JanusFigure.tga"
#name "Wise Figure"
#descr "A Wise Figure, or Korrigan King, is the petrified body of a great korrigan elder chosen to reign over a small faery kingdom beneath the earth, halfway between the Underworld and the Sunlit World. Although they are close cousins to other megaliths, Wise Figures have different origins, and thus aren't sacred to Karanaac. They look like the sturdy, stout statues of bearded dwarven beings and actually have two different faces, one on each of their sides, so that they are able to watch over the crossroads and passageways between both Worlds, as they were instructed to do by the Elder Stones. Many legends speak of children, adventurers or wizards that fell in deep holes while following the korrigans out of reckless curiosity or hunger for power, were then led to their Kings and had to answer riddles to escape with their lives; it is also said that those that survived, either through wit, purity of heart or trickery, went back home with incredible secrets and soon became rich and mighty by using them astutely. It is now evident that at least some of these legends are true, for Korrigan Kings are full of incredible wisdom and spend their almost unlimited time weaving elaborate and often cruel jokes and enigmas, oblivious in their games to even the most basic needs of their human friends and victims. Thus, it is no surprise that Karanaac makes good use of them for research purpose, and although they are unorthodox parts of the Geodetic Awakening, there is no doubt that they are zealous servants of Awakening God."
#noheal
#hp 50
#size 4
#prot 20
#mr 16
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 1000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#okleader
#stonebeing
#goodmagicleader
#miscshape
#itemslots 4096
#spellsinger
#gcost 150
#rcost 1
#rpcost 2
#addupkeep -150
#inspiringres 2
#magicskill 3 1
#custommagic 15360 100
#bonusspells 1
#researchbonus 3
#magicstudy 1
#nametype 142
#end

#newmonster 6837
#spr1 "Hellenika/PsientistMenhirGold.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 2
#magicboost 3 3
#custommagic 11264 100
#custommagic 4096 10
#montag 4131
#bonusspells 1
#researchbonus 8
#taxcollector
#polyimmune
#nametype 142
#end

#newmonster 6706
#spr1 "Hellenika/GoldFloatingStone.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening.
In their levitating state, Elder Stones are able to overcome their immobility for a limited time. Every month until they shapechange back to their original form, they'll lose some of their life force until their mind dies off after four months. During that time they'll also be surrounded by eerie energies that will hurt attackers."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 10
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#shapechange 4837
#uwdamage 20
#landdamage 20
#banefireshield 8
#float
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 1
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 2
#magicboost 3 3
#custommagic 11264 100
#custommagic 4096 10
#bonusspells 1
#researchbonus 8
#polyimmune
#nametype 142
#weapon 118
#end

#newmonster 6709
#spr1 "Hellenika/PsientistMenhirBlue.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 8 2
#magicboost 4 3
#custommagic 11264 100
#custommagic 4096 10
#montag 4131
#bonusspells 1
#researchbonus 8
#taxcollector
#polyimmune
#nametype 142
#end

#newmonster 6705
#spr1 "Hellenika/BlueFloatingStone.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening.
In their levitating state, Elder Stones are able to overcome their immobility for a limited time. Every month until they shapechange back to their original form, they'll lose some of their life force until their mind dies off after four months. During that time they'll also be surrounded by eerie energies that will hurt attackers."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 10
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#shapechange 4709
#uwdamage 20
#landdamage 20
#banefireshield 8
#float
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 1
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 2
#magicboost 4 3
#custommagic 11264 100
#custommagic 4096 10
#bonusspells 1
#researchbonus 8
#polyimmune
#nametype 142
#weapon 118
#end

#newmonster 6708
#spr1 "Hellenika/PsientistMenhir.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 8 2
#magicboost 6 3
#custommagic 11264 100
#custommagic 4096 10
#montag 4131
#bonusspells 1
#researchbonus 8
#taxcollector
#polyimmune
#nametype 142
#end

#newmonster 6704
#spr1 "Hellenika/GreenFloatingStone.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening.
In their levitating state, Elder Stones are able to overcome their immobility for a limited time. Every month until they shapechange back to their original form, they'll lose some of their life force until their mind dies off after four months. During that time they'll also be surrounded by eerie energies that will hurt attackers."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 10
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#shapechange 4708
#uwdamage 20
#landdamage 20
#banefireshield 8
#float
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 1
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 2
#magicboost 6 3
#custommagic 11264 100
#custommagic 4096 10
#bonusspells 1
#researchbonus 8
#polyimmune
#nametype 142
#weapon 118
#end

#newmonster 6707
#spr1 "Hellenika/PsientistMenhirPurple.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 8 2
#custommagic 11264 100
#custommagic 4096 10
#magicboost 3 1
#magicboost 4 1
#magicboost 5 1
#magicboost 6 1
#montag 4131
#bonusspells 1
#researchbonus 8
#taxcollector
#polyimmune
#nametype 142
#end

#newmonster 6819
#spr1 "Hellenika/PurpleFloatingStone.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening.
In their levitating state, Elder Stones are able to overcome their immobility for a limited time. Every month until they shapechange back to their original form, they'll lose some of their life force until their mind dies off after four months. During that time they'll also be surrounded by eerie energies that will hurt attackers."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 10
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#shapechange 4707
#uwdamage 20
#landdamage 20
#banefireshield 8
#float
#blind
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 1
#spellsinger
#gcost 0
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 6 1
#magicskill 8 2
#custommagic 11264 100
#custommagic 4096 10
#magicboost 3 1
#magicboost 4 1
#magicboost 5 1
#magicboost 6 1
#bonusspells 1
#researchbonus 8
#polyimmune
#nametype 142
#weapon 118
#end

#newmonster 6703
#spr1 "Hellenika/PsientistMenhirGrey.tga"
#name "Elder Stone"
#descr "Elder Stones are huge megaliths of polished black stone in which an incredibly ancient spirit of immense power has been sealed for all eternity by the last Pantokrator for having threatened his authority. Standing in mute circles in Karanaac like dark, immutable guardians and pillars of the sky or at Fomoria's most remote crossroads between the realms of the living and the Underworld, they may very well be the greatest megaliths of the world both in sheer mass and in mystical might, and, although a rare few instead decided to side with the Cursed Giants, for most their immeasurable age and wisdom naturally caused them to become the true architects and masterminds of the Geodetic Awakening, second only to the God himself. Each Elder Stone is engraved with a single symbol of either benevolence of malevolence called a triskele, and the Elder Stones' innate attunement to creation and destruction is so great that their triskeles perpetually glow with a dim, supernatural light whose color depends on the personality and magical alignment of the spirit that inhabits it. There are therefore four main types of Elder Stone, three of which receive hugely increased skills in either Earth, Astral or Nature magic, and the last of which receives moderately increased skills in all of these magics as well as in the path of Death. All of Fomoria's Elder Stones are of the last type, but otherwise a given Elder Stone's type isn't predictable in any way before it has awakened, and once it has been declared it can only change through Karanaac's great ritual of Reawakening."
#noheal
#hp 175
#size 6
#prot 23
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 2000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#miscshape
#itemslots 4096
#spellsinger
#gcost 450
#rcost 1
#rpcost 3
#addupkeep -450
#holy
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 8 2
#custommagic 11264 100
#custommagic 4096 10
#firstshape -4131
#bonusspells 1
#researchbonus 8
#taxcollector
#polyimmune
#nametype 142
#end

#newmonster 7200
#spr1 "Hellenika/AstralMegalith.tga"
#name "Astral Megalith"
#descr "Astral Megaliths are needle-like stone structures that are said to be as ancient as the world itself. They are also called Pillars of Creation due to the fact that their geometric positioning seems essential to the very stability of the world as a whole, somehow linking it to the higher Spheres of existence in a great cosmic concordance between the vast and the singular. Although their exact original purpose is unknown and unfathomable to mortals, some posit that together they act like a metaphysical shield that protects the Earth and all of its inhabitants against the great Horrors that dwell in the Void beyond the stars; while others claim that, on the contrary, they are proof that the Earth itself is a prison and a containment cell for some mysterious force, and that mortals are but insects whose destiny is irrelevant to this divine undertaking. In any case, with the Geodetic Awakening, Astral Megaliths have started to adopt a new purpose, and their universal communion now serves the God of Karanaac. Their world-wide alignments grant them an incredible power that manifests itself both through their immense sacred influence, able to spread dominion with ease, and through their ability to extract astral pearls from cosmic energies. And although the Astral Megaliths are too ancient and inhuman to communicate in comprehensible ways or even at all, which means that they leave all mundane matters to the Elder Stones, they very probably are the most important and mighty beings in the Polyphony of Stones."
#noheal
#hp 90
#size 6
#prot 22
#mr 18
#mor 30
#str 15
#att 5
#def 0
#prec 5
#ap 2
#mapmove 0
#enc 0
#maxage 5000
#poisonres 25
#eyes 0
#blind
#immobile
#slashres
#pierceres
#inanimate
#amphibian
#neednoteat
#spiritsight
#noleader
#stonebeing
#holy
#miscshape
#itemslots 4096
#spellsinger
#gcost 750
#rcost 1
#rpcost 3
#addupkeep -750
#gemprod 4 1
#spreaddom 1
#magicskill 4 3
#magicskill 8 3
#bonusspells 1
#polyimmune
#nametype 142
#end

#newmonster 6805
#copystats 13 -- Hoplite Commander
#spr1 "Hellenika/HopliteCommander_1.tga"
#spr2 "Hellenika/HopliteCommander_2.tga"
#name "Hoplite Commander"
#descr "The commanders of the hoplite armies are known for their bravery and charisma. Those that are recruited among the population of the nation's dry land colonies aren't blessed with the ability to breathe underwater, but they do not need to be equipped with rust-resistant armaments and therefore use less expensive armor and weaponry."
#gcost 70
#end

#newmonster 7201
#copystats 13 -- Hoplite Commander
#spr1 "Hellenika/PearlCommander_1.tga"
#spr2 "Hellenika/PearlCommander_2.tga"
#name "Hydrelephantine Commander"
#descr "The commanders of the hoplite armies are known for their bravery and charisma. Cyanautha's commanders are famed for their nacre armaments made out of the Ivory of the Sea. They are therefore called Hydrelephantine and their equipment both resists rust and allows them to strike true against even the ethereal ghosts of Therodos."
#pooramphibian
#mor 14
#att 13
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 1159 -- Pearl Long Spear
#gcost 80
#end

#newmonster 7202
#copystats 13 -- Hoplite Commander
#spr1 "Hellenika/GoldCommander_1.tga"
#spr2 "Hellenika/GoldCommander_2.tga"
#name "Chryselephantine Commander"
#descr "The commanders of the hoplite armies are known for their bravery and charisma. Throughout the centuries, thanks to clever trade with Pelagia and Berytos as well its heroes' conquests both over and under the sea, Argolinth has accumulated vast treasures and added them to the opulent riches it retained from its glorious past under the Telkhines' leadership. Thus, the bravest of its commanders are rewarded by being allowed to bear Chryselephantine masterwork armaments of gleaming gold and nacre. Although their upkeep is increased by half as a result of the maintenance required to keep their arms and armor in perfect condition, they become awe-inspiring warriors while retaining their ability to fight ethereal beings and to resist rust, and they gain enough authority to train Chryselephantine hoplites and commanders and to allow their recruitment. However, just like their troops, Chryselephantine commanders are only recruitable in positive dominion and a Chryselephantine Commander or Champion must be present to train them."
#pooramphibian
#mor 16
#mr 12
#att 13
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1195 -- Golden Long Spear
#awe 4
#montag 4134
#monpresentrec -4134
#gcost 120
#addupkeep 60
#rpcost 1
#domrec
#end

#newmonster 6800
#copystats 1076 -- Myrmidon Champion
#spr1 "Hellenika/CyanChampion_1.tga"
#spr2 "Hellenika/CyanChampion_2.tga"
#name "Myrmidon Champion"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes. The Myrmidons of the dry lands are not descendants of the Fifty like their kin beneath the waves, but they have devoted their lives to the imitation of the ancient champions. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their days traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. Although the people of the dry land colonies does not descend from Cyanautha's legendary heroes and was thus born without the God's blessing of water breathing, its troops still are formidable in both skills and armaments."
#holy
#sailing 40 6
#inspirational 1
#gcost 110
#end

#newmonster 7203
#copystats 1076 -- Myrmidon Champion
#spr1 "Hellenika/PearlChampion_1.tga"
#spr2 "Hellenika/PearlChampion_2.tga"
#name "Hydrelephantine Champion"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes, and their champions are very charismatic and experienced warleaders. As the children and heirs of the Fifty, they live to imitate and resemble them. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their whole time traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. As their characteristic ant-like armor as well as their weapons are usually made out of the Ivory of the Sea - iridescent nacre cultivated in clam fields by the people of Argolinth -, they are called Hydrelephantine and are both able to fight underwater without their armaments rusting and to strike true even against the ethereal ghosts of Therodos."
#pooramphibian
#mor 16
#att 14
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 665 -- Pearl Blade
#holy
#gcost 130
#sailing 40 6
#inspirational 1
#end

#newmonster 7204
#copystats 1076 -- Myrmidon Champion
#spr1 "Hellenika/GoldChampion_1.tga"
#spr2 "Hellenika/GoldChampion_2.tga"
#name "Chryselephantine Champion"
#descr "The Myrmidons are the elites of Cyanautha and its bravest heroes, and their champions are very charismatic and experienced warleaders. As the children and heirs of the Fifty, they live to imitate and resemble them. Thus, like them, they bear a sacred flame in their heart and they are holy warrior-sailors that spend their days traveling across the sea, exploring the Archipelago and the lands beyond to accomplish mythic deeds in the name of the God and the nation. Throughout the centuries, thanks to clever trade with Pelagia and Berytos as well its heroes' conquests both over and under the waves, Argolinth has accumulated vast treasures and added them to the opulent riches it retained from its glorious past under the Telkhines' leadership. Thus, those among the myrmidons who prove their worth are rewarded by being allowed to bear Chryselephantine masterwork armaments of gleaming gold and nacre. Although unlike other sacred troops their upkeep, rather than reduced, is increased by half as a result of the maintenance required to keep their arms and armor in perfect condition, they become awe-inspiring warriors all the while retaining their ability to fight ethereal beings and to resist rust, and their generals gain enough authority to train Chryselephantine hoplites and commanders and to allow their recruitment."
#pooramphibian
#mor 17
#mr 12
#att 14
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1158 -- Golden Sword
#awe 4
#holy
#sailing 40 6
#montag 4134
#gcost 200
#addupkeep 400
#expertleader
#inspirational 1
#rpcost 2
#end

#newmonster 7205
#spr1 "Hellenika/DolphinCommander1.tga"
#spr2 "Hellenika/DolphinCommander2.tga"
#name "Dolphin Commander"
#descr "Dolphin Commanders are experienced Dolphin Riders that lead Cyanautha's maritime cavalry in battle. Along with their men, they are Cyanautha's only cavalry and the greatest of its defenders in the deeps. These white knights relentlessly patrol the kingdom and restore order and justice within it when needed. Their noble mounts are both strong and nimble and they truly are the best ally of man in the oceanic realms. They are capable of hitting several enemies at once with broad sweeps of their powerful tail, and their sixth sense allows them to locate even invisible targets."
#att 13
#hp 15
#prot 0
#prec 10
#ap 30
#maxage 50
#goodleader
#inspirational 1
#nametype 107
#aquatic
#size 3
#ressize 2
#mor 17
#mr 12
#def 14
#enc 5
#str 12
#mapmove 24
#mounted
#mountedhumanoid
#cleararmor
#clearweapons
#armor 885 -- Pearl Hoplon
#armor 886 -- Pearl Helmet
#armor 887 -- Pearl Hauberk
#weapon 1159 -- Pearl Long Spear
#weapon 1104 -- Tail Sweep
#gcost 145
#rcost 1
#rpcost 1
#custommagic 32768 30
#patrolbonus 25
#spiritsight
#end

#newmonster 7206
#spr1 "Hellenika/DolphinChampion1.tga"
#spr2 "Hellenika/DolphinChampion2.tga"
#name "Dolphin Champion"
#descr "Dolphin Champions are the Dolphin Interceptors' generals and combine all the abilities of Chryselephantine Champions with the sacred gift of their wondrous albino mount, which allows them to heal their wounds and to take limited control over the sea in combat. Along with their men, they are Cyanautha's only cavalry and the greatest of its defenders in the deeps. These white knights relentlessly patrol the kingdom and restore order and justice within it when needed. Their noble mounts are both strong and nimble and they truly are the best ally of man in the oceanic realms. They are capable of hitting several enemies at once with broad sweeps of their powerful tail, and their sixth sense allows them to locate even invisible targets."
#att 13
#hp 15
#prot 0
#prec 10
#ap 30
#maxage 50
#expertleader
#inspirational 1
#nametype 107
#aquatic
#size 3
#ressize 2
#mor 18
#mr 14
#def 14
#enc 5
#awe 4
#str 12
#mapmove 24
#older -10
#holy
#heal
#mounted
#mountedhumanoid
#cleararmor
#clearweapons
#armor 882 -- Golden Hoplon
#armor 883 -- Golden Helmet
#armor 884 -- Golden Hauberk
#weapon 1195 -- Golden Long Spear
#weapon 1104 -- Tail Sweep
#magicskill 2 1
#combatcaster
#researchbonus -4
#custommagic 33536 100
#custommagic 512 30
#gcost 240
#rcost 1
#rpcost 3
#addupkeep 480
#montag 4134
#patrolbonus 25
#spiritsight
#end

#newmonster 7207
#spr1 "Hellenika/InsularSorceress_1.tga"
#spr2 "Hellenika/InsularSorceress_2.tga"
#name "Insular Sorceress"
#descr "Cyanautha's territory still comprises many islands, and although most are tiny and hold only a few small settlements - often villages that were built on the remnants of the highest mountains of the sunken empire -, these islands are numerous enough to be home to the majority of the nation's population, like a vast constellation whose many fickle stars would as a whole shine like the sun. Yet, many of these islands are almost entirely uninhabited, and for good reason: they often shelter the lonely and almost immortal disciples of an ancient sorceress-heroine, one of the Fifty, who is known for her tragic destiny and the terrible curses she cast upon those that bored or annoyed her even in the slightest. Therefore, any traveler would be well advised to whenever possible avoid setting foot upon the sand of the least civilized of Cyanautha's isles, for it is likely that just like their feared mistress, the insular sorceresses of the present have great powers and cruel charms. In truth, in spite of these frightening rumors, the sorceresses still are loyal to their nation and its God, and they'll gladly unchain their magic to spell the doom of those that threaten their beloved archipelago and its people. With the right magic paths, Insular Sorceresses are capable of casting the Transformation ritual."
#nametype 135
#hp 10
#size 2
#prot 0
#mr 14
#mor 12
#str 8
#att 10
#def 9
#prec 11
#ap 12
#mapmove 14
#enc 2
#maxage 150
#older -10
#weapon 473
#armor 20
#female
#pooramphibian
#sailing 40 6
#giftofwater 60
#magicskill 2 2
#custommagic 35456 20
#custommagic 256 20
#custommagic 4096 20
#custommagic 8192 20
#stealthy
#seduce 10
#awe 4
#rpcost 2
#poorleader
#gcost 140
#spiritsight
#userestricteditem 8069
#twiceborn 6675
#researchbonus 3
#montag 4153 -- can cast Transformation
#end

#newmonster 6801
#spr1 "Hellenika/Geront_1.tga"
#spr2 "Hellenika/Geront_2.tga"
#name "Geronte"
#descr "Since Cyanautha rejected its Telkhine masters, its political system changed dramatically. The monarchy was abolished and replaced by an oligarchy which combines both tyrannical and democratic aspects. Now, in Cyanautha, with the exception of the Awakening God, only man commands man, and the nation's leaders always have to keep in mind the best interests of the people and to work for the greatest glory of the nation as a whole. Only the elders, or Gerontes, are allowed to bear citizenship, and thus they rule everyone else with an iron grasp; however, they are first and foremost fatherly priests of the God and the people, and although they are privileged, very strict rules dictate their powers and their rights to ensure absolute fairness and a functional system, for corrupt and chaotic individualistic behavior is widely considered shameful in Cyanautha. Every day, the Gerontes must take part in the Boule - an assembly that possesses judicial, legislative and limited executive power - to decide through vote and random sortition who among them will be allotted with the most important responsibilities for that day. As such, they are skillful orators and administrators, and only they have the necessary authority to organize the great undertaking of producing and managing the resources that will then be used by the military to complete the sacred duty of the nation. Although only a few among them have the time to devote themselves to the study of magic, all of them have very learned minds and cause the nation's wisdom to advance through their debates and deliberations. As such, they can be used as researchers and are entirely unaffected by Drain and Magic scales in this task, Production scales instead increasing their general efficiency; and due to the mundane origins of their sacred authority - their political status -, no temple is required to recruit them."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 14
#mor 12
#str 8
#att 10
#def 9
#prec 8
#ap 10
#mapmove 14
#enc 3
#gcost 105
#startage 48
#pooramphibian
#magicskill 8 1
#custommagic 768 15
#custommagic 512 15
#resources 12
#sailing 40 6
#poorleader
#rpcost 1
#fixedresearch 3
#slothresearch -1
#drainimmune
#magicimmune
#weapon 92
#end

#newmonster 7208
#spr1 "Hellenika/Prytanis_1.tga"
#spr2 "Hellenika/Prytanis_2.tga"
#name "Prytanis"
#descr "As everyone knows in Cyanautha, the Gerontes aren't only priests, sages and administrators but must also daily take part in the Boule - an assembly that possesses judicial, legislative and limited executive power - to decide through vote and random sortition who among them will be allotted with the most important responsibilities for that day. But their great importance doesn't stop there, for in the same way, every year they must also elect a few of their peers as their representatives; those that emerge victorious, generally great orators full of wisdom and experience, become Prytanis, or Caretakers, and assume direct leadership of Cyanautha. In doing so, they acquire great priestly and military authority and their magical powers are immensely expanded by the Boule's combined favor. Although the Prytanis still have to obey the edicts of the Boule, for most intents and purposes they are the true leaders of the nation and they have unmatched executive power. In addition to being the mightiest mages of Argolinth and the only ones with the power to imbue hydrelephantine silk robes through construction rituals, they are administrators of immense skill and their presence in overland colonies is necessary to organize the patronage of Mage Engineers and Orphic Mystics. However, since their political role is so different than that of other Gerontes, both kinds of politician are complementary to each other and irreplaceable by each other. In other words, as they are too busy to manage the nation's resource chains due to their own important functions, Prytaneis do not increase production in the province where they dwell and instead delegate that task to lesser administrators whose time isn't as precious as theirs."
#nametype 107
#hp 10
#size 2
#prot 0
#mr 15
#mor 11
#str 9
#att 10
#def 9
#prec 8
#ap 10
#mapmove 14
#enc 3
#gcost 275
#startage 50
#addrandomage 5
#pooramphibian
#magicskill 2 3
#magicskill 8 2
#custommagic 36736 100
#custommagic 1792 30
#rpcost 4
#sailing 40 6
#goodleader
#weapon 7
#drainimmune
#montag 4136
#end

#newmonster 6802
#copystats 1606 -- Mage Engineer
#spr1 "Hellenika/Mathematician_1.tga"
#spr2 "Hellenika/Mathematician_2.tga"
#name "Mage Engineer"
#descr "In Cyanautha's dry land colonies, there has been a long tradition of scientific, artistic and otherwise cultural patronage. Each Prytanis likes to improve his image and leave a lasting trace in history by wisely spending the city's resources as well as his personal riches to support the research of a few intellectuals and commission new masterworks. Mage-engineers represent the purely scientific aspect of such patronage and are often chosen to improve the military defenses of a city by undertaking great projects of architecture or golem construction, which makes their presence, along with that of a laboratory, absolutely necessary to the production of khalkotauroi, clockwork soldiers, siege golems and their own apprentices. They are great geometers and mathematicians who study the fabric of the Spheres. Although they aren't very powerful war mages, they still master the mechanics of optics and, by cleverly using mirror arrays, they can burn away dangerous foes by focusing intense light on them - a slow-to-use but very precise weapon that is inefficient underwater but can pierce armor and blind in a small area. Still, the mage-engineers' genius is useless without a sufficient workforce to handle their apparatus, and for this reason their efficiency in research is increased under Production scales and reduced under Sloth scales. Even though mage-engineers aren't sacred, the presence of a Prytanis as well as of a temple of the arts are both necessary to organize their patronage and recruit them."
#clearmagic
#prec 13
#magicskill 0 1
#magicskill 4 1
#custommagic 3200 50
#custommagic 1920 15
#researchbonus 3
#slothresearch -1
#sailing 40 6
#poorleader
#okmagicleader
#rpcost 4
#resources 36
#gcost 250
#reqtemple
#drainimmune
#monpresentrec -4136
#fixforgebonus 2
#clearweapons
#weapon 637
#weapon 1157
#end

#newmonster 6803
#spr1 "Hellenika/CyanMyst_1.tga"
#spr2 "Hellenika/CyanMyst_2.tga"
#nametype 107
#name "Orphic Mystic"
#descr "In Cyanautha's dry land colonies, there has been a long tradition of scientific, artistic and otherwise cultural patronage. Each Prytanis likes to improve his image and leave a lasting trace in history by wisely spending the city's resources as well as his personal riches to support the research of a few intellectuals and commission new masterworks. Orphic Mystics represent the spiritual and artistic aspect of such patronage; they are sacred poets and musicians of such skill that they have influenced the mystics of Delphanes and contribued to the formation of one of their orders, and some even claim they too have oracular powers. In any case they compose odes to the God and his most faithful lieutenants - both the Heroes of the past and the governors that support them - and as such, they are among the most important priests of the kingdom, those that write the sacred hymns recited in every temple. As the disciples of a legendary hero - one of the Fifty - that used his musical skills to enter the Underworld and leave it unscathed, they follow a tradition of mystic poetry and adopted his ideas of the transmigration of the soul; like him, they are able to follow the hidden paths of the land of the dead and will never truly die for as long as the light of the God shines to guide them to the sunlit world. In earlier times there was not much speculation on the afterlife in Cyanautha, but with the century-long war against the Spectre of Therodos, this has changed and the Orphic Mystics are the result of this cultural evolution. The new perceptions of the soul and the dead have also marked the arrival of necromantic practices, such as the use of curse tablets, and the chants of Rebirth can be used to charm terrestrial animals as well as to summon the blessing of the Styx upon the nation. The presence of a Prytanis is necessary to organize the Orphic Mystics' patronage and recruit them."
#hp 10 
#size 2
#prot 0
#mr 15
#mor 10
#str 10
#att 8
#def 8
#prec 10
#ap 10
#mapmove 14
#enc 3
#maxage 50
#startage 25
#addrandomage 5
#spellsinger
#sailing 40 6
#okleader
#inspirational 1
#okmagicleader
#noundeadleader
#holy
#magicskill 5 1
#magicskill 6 1
#magicskill 8 1
#custommagic 12544 50
#custommagic 13056 15
#rpcost 4
#animalawe 4
#domimmortal
#cleararmor
#clearweapons
#weapon 674
#gcost 250
#monpresentrec -4136
#domsummon20 -4135
#userestricteditem 8058
#sleepaura 10
#end

#selectmonster 3128 -- Orphic Mystic
#name "Orphic Mystic"
#descr "The unsurpassed oracular powers of the Sibyls and the location of their caves at the centre of the world have always attracted many foreign faiths and beliefs. Among them, there is in Delphanes a group of mystics following a tradition of spiritual poetry who nurture ideas of the transmigration of the soul. These perceptions of the soul and the dead also cause the survivance of necromantic practices, such as the use of curse tablets."
#prophetshape 4645
#userestricteditem 8058
#end

#newmonster 6645
#copystats 3128 -- Orphic Mystic
#spr1 "Hellenika/DelphMyst_1.tga"
#spr2 "Hellenika/DelphMyst_2.tga"
#name "Orphic Hierophant"
#nametype 107
#descr "The unsurpassed oracular powers of the Sibyls and the location of their caves at the centre of the world have always attracted many foreign faiths and beliefs. Among them, there is in Delphanes a group of mystics following a tradition of spiritual poetry who nurture ideas of the transmigration of the soul. These perceptions of the soul and the dead also cause the survivance of necromantic practices, such as the use of curse tablets. This Orphic Mystic has achieved the initiatic mysteries of his cult and attained the title of Hierophant. As such, he gained increased magical powers as well as priestly status, and through music and spiritual attunement with nature he became able to attract and befriend animals."
#montag 4124 -- for Isphenople
#domsummon20 -4135
#inspirational 2
#okleader
#okmagicleader
#animalawe 4
#magicskill 8 1
#userestricteditem 8058
#end

#newmonster 6668
#copystats 3128 -- Orphic Mystic
#spr1 "Hellenika/AwakeOrphic1.tga"
#spr2 "Hellenika/AwakeOrphic2.tga"
#name "Orphic Hierophant"
#nametype 107
#descr "The unsurpassed oracular powers of the Sibyls and the location of their caves at the centre of the world have always attracted many foreign faiths and beliefs. Among them, there is in Delphanes a group of mystics following a tradition of spiritual poetry who nurture ideas of the transmigration of the soul. These perceptions of the soul and the dead also cause the survivance of necromantic practices, such as the use of curse tablets. This Orphic Mystic has achieved the initiatic mysteries of his cult and attained the title of Hierophant. As such, he gained increased magical powers as well as priestly status, and through music and spiritual attunement with nature he became able to inspire humans as well as to attract and befriend animals."
#domsummon20 -4135
#inspirational 2
#okleader
#okmagicleader
#animalawe 4
#magicskill 8 1
#userestricteditem 8058
#end

#newmonster 6669
#spr1 "Hellenika/DelphMyst_1.tga"
#spr2 "Hellenika/DelphMyst_2.tga"
#nametype 107
#name "Awakened Hierophant"
#descr "The unsurpassed oracular powers of the Sibyls and the location of their caves at the centre of the world have always attracted many foreign faiths and beliefs. Among them, there is in Delphanes a group of mystics following a tradition of spiritual poetry who nurture ideas of the transmigration of the soul. These perceptions of the soul and the dead also cause the survivance of necromantic practices, such as the use of curse tablets. After having achieved the initiatic mysteries of his cult and attained the title of Hierophant, this Orphic Mystic went to the Underworld and successfully returned with his life and enlightenment. When awakened to the hidden reality of the Underworld, Orphic Hierophants start transcending their humanity. They then no longer need any other sustenance than their music and the contemplation of nature, thus nullifying their upkeep cost, and through wisdom and knowledge of the forbidden paths they reach a state of limited immortality, a higher priestly status and the ability to innately lead communions."
#hp 10
#size 2
#prot 0
#mr 15
#mor 10
#str 10
#att 8
#def 8
#prec 10
#ap 10
#mapmove 14
#enc 3
#maxage 50
#spellsinger
#okleader
#inspirational 2
#okmagicleader
#noundeadleader
#holy
#animalawe 4
#domimmortal
#cleararmor
#clearweapons
#weapon 674
#gcost 0
#neednoteat
#spiritsight
#domsummon20 -4135
#commaster
#magicskill 8 2
#userestricteditem 8058
#sleepaura 10
#end

#selectmonster 1554 -- Agema Commander
#name "Agema Commander"
#descr "The Royal Companions are mounted elite warriors of great skill and discipline. They are often sons of royal blood from other nations that were chosen as a great tribute to the Sibyls, which has given them their name. By renouncing their heritage and swearing life-long allegiance to Delphanes, they ensure the good fortune of their former kingdom, so they'll never betray their engagements."
#end

#selectmonster 746 -- Strategos
#name "Strategos"
#descr "The Strategos is a general of extraordinary skill that devoted his whole life to the military protection of the City at the Centre of the World. Ability rather than birth decides the rank of the generals in Delphanes. Skill and experience comes with age, and many of the strategoi are starting to get old."
#end

#selectmonster 3199 -- Neokoros
#name "Neokoros"
#descr "The Neokoros is a priestess and temple-warden in the service of the Sibyls. The priestly occupation in Delphanes has always been restricted to women. Although the youngest priestesses often come from far away lands where they already served in foreign temples, when joining the City of a Thousand Gods they must undergo an initiation to the cult of the God of Gods. Once this training is over, they fully understand that all faiths are One and they are allowed to take a part in the religious rituals of the temples in the cities of the kingdom. A Neokoros rarely leaves her temple, but occasionally follows an army to tend the sick and wounded."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3200 -- Panageis
#name "Panageis"
#descr "The Panageis, the All Holy Ones, are high priestesses in the service of the Sibyls. With a close connection to the cycles of life and rebirth, these priestesses perform animal sacrifice to procure fertility and prosperity of the land. In every temple there is a chasm into which blessed animals are thrown to their death during the celebration of the Thesmophoria. Their rotting carcasses are collected by the priestesses and used in the rituals of death and rebirth."
#userestricteditem 8069
#twiceborn 6675
#montag 4124 -- for Isphenople
#end

#selectmonster 3201 -- Hydrophoros of the East
#userestricteditem 8069
#twiceborn 6675
#makepearls 2
#end

#selectmonster 3202 -- Hydrophoros of the West
#userestricteditem 8069
#twiceborn 6675
#makepearls 2
#end

#selectmonster 1557 -- Sibyl
#name "Sibyl"
#descr "The Sibyls are ancient seeresses of great skill who follow an immemorable tradition of sacred seclusion within the mysterious caves of Delphanes, to which no one else is allowed access. There, by inhalating the sacred fumes from the Underworld, they can divine the future and the will of all gods. No one knows where they or their secrets truly come from, but their oracular answers have raised Delphanes as a power to be reckoned with. When in a strong dominion, their faith may inspire sacred Heart Companion bodyguards who will come to protect the City of a Thousand Gods and its great priestesses."
#gcost 230
#magicskill 8 3
#userestricteditem 8069
#twiceborn 6675
#domsummon20 "Heart Companion"
#montag 4124 -- for Isphenople
#end

#newmonster 6750
#copystats 3172 -- Cerulean Commander
#copyspr 3172 -- Cerulean Commander
#name "Cerulean Commander"
#descr "Located close from the mighty kingdom of Bandar Log, Delphanes has always kept close ties with its mystics and its people. Through sheer spiritual influence, it has even gained a valuable ally in the Cerulean Maharaja. The Maharaja gave the generals of Delphanes an army of apes from his personal retinue. The Bandar warriors of the Cerulean Legion joined the City at the Centre of the World where they were given a portion of the capital and a mighty tower to defend. Now the Cerulean Warriors in their blue armor have become known among the enemies of Delphanes as fierce and skillful warriors."
#gcost 75
#domsummon20 "Cerulean Warrior"
#beastmaster 2
#inspirational -1
#end

#selectmonster 3172 -- Cerulean Commander
#copystats 1143 -- Guru
#copyspr 1143
#name "Gymnosophist"
#descr "The Gymnosophists, or Naked Sages, are exotic mystics and thinkers from the lands of Kailasa that always fascinated the philosophers of Arcoscephale. Although they are aloof and rarely concern themselves with matters of politics, they maintain a close relationship with the City of a Thousand Faiths, and when they come to Delphanes, they sometimes agree that the principle of Spiritual Unity is perfectly embodied by the Sibyls' Awakening God, and they join the Cerulean Tower to guide lower apes or sometimes share some of their insights with the Orphic Mystics. This is especially likely to happen while a Cerulean Commander is in the capital, as he'll spread the word of the Sibyls to other apes, and those likely will end up reaching the ears of a Gymnosophist. As White Ones, they are white-furred Vanara of the highest of the castes of Bandar Log who are gifted with superior mental capabilities, as well as mages and philosophers who study astrology, and sages the path of Nature who are able to cast the Transformation ritual. When a White One dies, his soul may transmigrate. Depending on the actions of the White One, he will reincarnate in a lower or higher form of existence. Truly enlightened ones might become one with the Awakening God."
#nametype 129
#clearmagic
#clearweapons
#cleararmor
#weapon 92
#researchbonus 6
#slothresearch 2
#magicskill 4 1
#custommagic 2048 30
#custommagic 2048 30
#custommagic 8192 30
#custommagic 8192 30
#custommagic 512 30
#gcost 100
#montag 4153 -- can cast Transformation
#end

#newmonster 7404
#copystats 3172 -- Gymnosophist
#copyspr 1143
#montag 4124 -- foreign savant
#firstshape 3172
#end

#selectmonster 382
#copyspr 301
#name "Astrologer"
#descr "The Astrologers of Arcoscephale and Delphanes are enlightened mystics and masters of star signs and divination. They reputedly gained their lore from the Rephaite of Kokabel. To consult the stars, they seek places of solitude and silence in the highlands where the stars are most clearly visible. Astrologers are masters of Astral magic that can project their magic much further than other mages and have a slight chance to prevent bad events in the province where they dwell."
#researchbonus 3
#allrange 2
#masterrit 1
#commaster
#end

#selectmonster 301
#name "Astrologer"
#descr "The Astrologers of Arcoscephale and Delphanes are enlightened mystics and masters of star signs and divination. They reputedly gained their lore from the Rephaite of Kokabel. To consult the stars, they seek places of solitude and silence in the highlands where the stars are most clearly visible. Astrologers are masters of Astral magic that can project their magic much further than other mages and have a slight chance to prevent bad events in the province where they dwell."
#researchbonus 3
#allrange 2
#magicskill 4 1
#magicboost 4 2
#montag 4124 -- for Isphenople
#end

#selectmonster 311 -- Mystic
#name "Mystic"
#descr "Mystics are reclusive mages living in strange caves where they explore the mysteries of time and the fabric of creation. Mystics are adept at Astral and Elemental magics and wield a broad spectrum of magical skills. When appointed as prophets, Mystics become great Astrologers with powerful new magic abilities."
#end

#newmonster 7209
#copystats 301 -- Astrologer
#spr1 "Hellenika/AwakeAstrologer1.tga"
#spr2 "Hellenika/AwakeAstrologer2.tga"
#name "Awakened Astrologer"
#nametype 107
#descr "The Astrologers of Arcoscephale and Delphanes are masters of star signs and divination. They reputedly gained their lore from the Rephaite of Kokabel. To consult the stars, they seek places of solitude and silence in the highlands where the stars are most clearly visible. Astrologers are masters of Astral magic that can project their magic much further than other mages and have a slight chance to prevent bad events in the province where they dwell. When awakened to the hidden reality of the Higher Spheres, they reach an enlightened state of being called Teleiotes and start transcending their humanity. They then no longer need any other sustenance than metaphystical meditation and the pure light of the stars, thus nullifying their upkeep cost and vastly increasing their life expectancy as well as their ability for magical research, and in addition to reaching sacred status they become sufficiently attuned with the Stars to innately lead communions and travel by Will and the laws of Simultaneity."
#gcost 0
#enc 0
#mr 18
#researchbonus 12
#maxage 500
#neednoteat
#holy
#commaster
#teleport
#spiritsight
#end

#selectmonster 3026 -- Erytheian Commander
#name "Erytheian Commander"
#descr "The commanders of the Erytheian armies are supposed to lead armies on dry land as well as in the sea. They therefore wear bronze armor, even if they for the most part lead Erytheian phalangites clad in iron. They are given pearl blades, relics crafted in Pelagia before the Civil War and once wielded by their exiled ancestors, the first conquerors of the Closed Realm."
#end

#selectmonster 3027 -- Erytheian Commander
#name "Erytheian Commander"
#descr "The commanders of the Erytheian armies are supposed to lead armies on dry land as well as in the sea. They therefore wear bronze armor, even if they for the most part lead Erytheian phalangites clad in iron. They are given pearl blades, relics crafted in Pelagia before the Civil War and once wielded by their exiled ancestors, the first conquerors of the Closed Realm."
#end

#selectmonster 3032 -- Daduchos
#name "Daduchos"
#descr "The mermen mystics of Pelagia have always been influenced by Berytian and Arcoscephalian lore, though envy and suspicion on the part of the ruling Tritons means that many restrictions are placed on them. But during the Civil War the Daduchoi, the torch-bearers, hid from the Triton rulers in the Closed Realm. In the Red Land, the colony Erytheia, they found solace and were able to continue their practices. They followed the Red River to its source and discovered the mystery of the Setting Sun. Thus, when the Civil War ended and Erytheia broke free, the Daduchoi emerged to guide and aid the first King of Both Worlds. With access to the mystery of the Setting Sun the Daduchoi became influential. Now they are responsible for the arcane training of the royal children."
#end

#selectmonster 3033 -- Daduchos
#name "Daduchos"
#descr "The mermen mystics of Pelagia have always been influenced by Berytian and Arcoscephalian lore, though envy and suspicion on the part of the ruling Tritons means that many restrictions are placed on them. But during the Civil War the Daduchoi, the torch-bearers, hid from the Triton rulers in the Closed Realm. In the Red Land, the colony Erytheia, they found solace and were able to continue their practices. They followed the Red River to its source and discovered the mystery of the Setting Sun. Thus, when the Civil War ended and Erytheia broke free, the Daduchoi emerged to guide and aid the first King of Both Worlds. With access to the mystery of the Setting Sun the Daduchoi became influential. Now they are responsible for the arcane training of the royal children."
#montag 4124 -- for Isphenople
#end

#selectmonster 3039 -- Erytheian Mystic
#userestricteditem 8059
#rpcost 1
#end

#selectmonster 3042 -- Prince of the Setting Sun
#name "Prince of the Setting Sun"
#descr "Out of necessity the ruling dynasty of Erytheia has adopted a practice of sibling marriages. The princes are trained in all aspects of governance, magic and priesthood from a young age. Only when they are married do they end their studies. Should the current king die, the queen marries one of her brothers or sons and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring. Some of the royalty have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and princes occasionally murder one of their brothers to advance their position. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#sunawe 5
#warning 2
#userestricteditem 8082
#startage 4
#addrandomage 40
#end

#selectmonster 3043 -- Prince of the Setting Sun
#name "Prince of the Setting Sun"
#descr "Out of necessity the ruling dynasty of Erytheia has adopted a practice of sibling marriages. The princes are trained in all aspects of governance, magic and priesthood from a young age. Only when they are married do they end their studies. Should the current king die, the queen marries one of her brothers or sons and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring. Some of the royalty have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and princes occasionally murder one of their brothers to advance their position. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#montag 4124 -- for Isphenople
#sunawe 5
#warning 2
#userestricteditem 8082
#startage 4
#addrandomage 40
#end

#selectmonster 3044 -- Princess of the Setting Sun
#name "Princess of the Setting Sun"
#descr "Out of necessity the ruling dynasty of Erytheia has adopted a practice of sibling marriages. The princesses are trained in all aspects of governance, magic and priesthood from a young age. Only when they are married do they end their studies. Should the current queen die, the king marries one of his sisters or daughters and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring. Some of the royalty have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and princesses occasionally murder one of their sisters to advance their position. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#userestricteditem 8069
#twiceborn 6675
#startage 4
#addrandomage 40
#sunawe 5
#warning 2
#end

#selectmonster 3045 -- Princess of the Setting Sun
#name "Princess of the Setting Sun"
#descr "Out of necessity the ruling dynasty of Erytheia has adopted a practice of sibling marriages. The princesses are trained in all aspects of governance, magic and priesthood from a young age. Only when they are married do they end their studies. Should the current queen die, the king marries one of his sisters or daughters and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring. Some of the royalty have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and princesses occasionally murder one of their sisters to advance their position. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#userestricteditem 8069
#twiceborn 6675
#montag 4124 -- for Isphenople
#startage 4
#addrandomage 40
#sunawe 5
#warning 2
#end

#selectmonster 3046 -- King of Both Worlds
#name "King of Both Worlds"
#descr "The King of Both Worlds is the monarch of Erytheia, the Kingdom of the Setting Sun. Together with his queen he rules over land and over sea. He is king and high priest, general and master magician. He rules every aspect of his kingdom and soon the world. Since the founding of Erytheia mermen have ruled the Kingdom of the Setting Sun. With the death of his first wife, daughter of an Arcoscephalian Strategos, the first Erytheian king married his own sister, barring dynastic claims from human relatives. Since then every king and queen have married their siblings to preserve the royal blood. The kings and queens share power and are raised knowing that they are divine and gifted with magic powers. All royal children are trained in the magic arts until they marry or die from old age. Some kings and queens have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and most kings occasionally execute their brothers on claims of conspiracy. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#sunawe 7
#warning 2
#userestricteditem 8082
#end

#selectmonster 3047 -- King of Both Worlds
#name "King of Both Worlds"
#descr "The King of Both Worlds is the monarch of Erytheia, the Kingdom of the Setting Sun. Together with his queen he rules over land and over sea. He is king and high priest, general and master magician. He rules every aspect of his kingdom and soon the world. Since the founding of Erytheia mermen have ruled the Kingdom of the Setting Sun. With the death of his first wife, daughter of an Arcoscephalian Strategos, the first Erytheian king married his own sister, barring dynastic claims from human relatives. Since then every king and queen have married their siblings to preserve the royal blood. The kings and queens share power and are raised knowing that they are divine and gifted with magic powers. All royal children are trained in the magic arts until they marry or die from old age. Some kings and queens have shown signs of insanity and physical deformities. Most mystics claim that this is the workings of a malign force awakening in the deep - maybe some dark Aboleth influence once again, maybe a conspiration of the jealous Triton Kings, or maybe something else entirely - and propose a conquest of the old lands of Pelagia, the mermen's rightful heritage.
There is fierce competition among the royal siblings and most kings occasionally execute their brothers on claims of conspiracy. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#sunawe 7
#warning 2
#userestricteditem 8082
#end

#selectmonster 3048 -- Queen of Land and Water
#name "Queen of Land and Water"
#descr "The queen is the wife-sister of the king. Together with her king she rules over land and over sea. She is queen and high priestess, general and grand sorceress. She rules every aspect of her kingdom and soon the world. To preserve purity of blood and prevent threats to the ruling dynasty, the kings and queens of Erytheia marry their sisters, sons and daughters. The king and queen share power and rule every aspect of the kingdom together, including the royal cult. They are considered divine and are the highest ranking priests of the kingdom. When a princess is crowned queen she is inaugurated as high priestess as well. Should the current queen die, the king marries one of his sisters or daughters and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring.
There is fierce competition among the royal siblings and most queens occasionally execute their sisters on claims of conspiracy. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#userestricteditem 8069
#twiceborn 6675
#startage 4
#addrandomage 30
#sunawe 7
#warning 2
#end

#selectmonster 3049 -- Queen of Land and Water
#name "Queen of Land and Water"
#descr "The queen is the wife-sister of the king. Together with her king she rules over land and over sea. She is queen and high priestess, general and grand sorceress. She rules every aspect of her kingdom and soon the world. To preserve purity of blood and prevent threats to the ruling dynasty, the kings and queens of Erytheia marry their sisters, sons and daughters. The king and queen share power and rule every aspect of the kingdom together, including the royal cult. They are considered divine and are the highest ranking priests of the kingdom. When a princess is crowned queen she is inaugurated as high priestess as well. Should the current queen die, the king marries one of his sisters or daughters and they share power until one of them dies. The surviving monarch then marries another sibling or one of their offspring.
There is fierce competition among the royal siblings and most queens occasionally execute their sisters on claims of conspiracy. As a result, members of the Erytheian royalty are also used to the protection of bodyguards and are able to lead them in greater numbers than other commanders."
#userestricteditem 8069
#twiceborn 6675
#startage 4
#addrandomage 30
#sunawe 7
#warning 2
#end

#selectmonster 3017 -- Triton Noble
#name "Triton Noble"
#descr "Many Triton noble families were banished from Pelagia for their involvement in the Civil War. Some took shelter in the parts of the sea that were under the protection of Erytheia and in exchange for their loyalty are now allowed to rule the lands once theirs as administrators and military leaders. They follow old traditions and train hippocampoi steeds just like the sacred Knights of the Deeps they once were. But Tritons are no longer priests in Erytheia, nor are they trained as holy warriors of the Setting Sun's faith. Now they are but soldiers and generals expected to lead the Triton armies in conquest for the King of Both Worlds."
#mapmove 24
#end

#selectmonster 3050 -- Triton Priest
#name "Triton Priest"
#descr "In Pelagia the Pearl Clan holds special status and its members are important advisors, mages and priests. But under the rule of the mermen kings, those that were banished from Pelagia for their involvement in the Civil War have lost much of their former influence. Still, their priests are allowed to lead religious ceremonies of lesser importance."
#end

#selectmonster 3038 -- Pearl Mage
#name "Pearl Mage"
#descr "In Pelagia, the Tritons are the undisputed rulers and their mages have access to resources and arcane lore gifted by their masters the Triton Kings. But for those that were banished from Pelagia due to their involvement in the Civil War, much of that ancient legacy is now lost. The mermen, who never were allowed to glean the magic of the pearls when they still served the Triton Kings, have since turned to new and unimaginable magics in the Red Land, but the few Triton Pearl Mages that joined the Kingdom of Both Worlds cling to their past and preserve their ways even now that they are Pelagia's enemies. The Pearl Mages are adept in the paths of water and the stars and they are able to cultivate pearls imbued with astral magic."
#custommagic 11008 20
#gcost 175
#end

#selectmonster 3034 -- Mermage (UW)
#custommagic 512 20
#gcost 95
#end

#selectmonster 3035 -- Mermage
#custommagic 512 20
#gcost 95
#end

#selectmonster 3152 -- Wind Caller
#name "Wind Caller"
#descr "The Storm Callers of Berytos, bringers of hailstorms and lightnings, still lead today berytian armies in naval campaigns. But it was trade and tributes that saved Phaeacia when Berytos abandoned it, and the warlike Storm Callers of the Phoenix empire fell from grace in the queendom. The Wind Callers, descendants of the Phaeacian Storm Callers of old, have found a new role as traders and shipwrights. They craft and enchant the Dark Ships of Phaeacia, but sometimes travel to distant lands to trade or found new colonies. Like most human inhabitants of the blessed isle, they have unnaturally long lifespans."
#gcost 150
#end

#selectmonster 3158 -- Prince Consort
#name "Prince Consort"
#descr "Since the ancient times queens have ruled the Colossi, both in Berytos and in its colonies. Likewise, in Phaeacia, noblemen are expected to study philosophy and magic to become beautiful of mind as well as body. The most prominent and wise of these noble mages become advisors and lovers of their queens. Their golden apple diet gifts them with the ability to recover from any wound."
#montag 4124 -- for Isphenople
#heal
#gcost 370
#end

#selectmonster 3157 -- Colossi Queen
#name "Colossi Queen"
#descr "When the link between Berytos and Phaeacia was broken the Phaeacians kept many traditions including matriarchy. The former Brides-in-Waiting called themselves Colossi Queens and abandoned the blood magic of the Melqart cult that still reigns supreme on the mainland today. In spite of Berytos' growing jealousy, they reigned in Phaeacia until the Gigantes came. When Nausithous' Gigantes settled on Black Korkyra the Phaeacians declared war upon the Gigantes to protect their lands. The Gigantes were few and were losing. Nausithous yielded and offered himself in marriage to the Colossi Queen. Their daughters have since ruled Phaeacia. The phaeacian queens are skilled mages and generals and lead the cult of the Awakening God. Their golden apple diet gifts them with the ability to recover from any wound."
#custommagic 32768 20
#heal
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3155 -- Colossi Weaver
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3151 -- Mage Pilot
#name "Mage Pilot"
#descr "Both Berytian and Phaeacian mage pilots are renowned for their navigational skills. When Berytos abandoned Phaeacia, some mage pilots remained in Phaeacia in fear of both Arcoscephale's military and Berytos' punishment. Their skills were instrumental when the Dark Ships were first made. Mage Pilots use Air and Water magic and can sail across the oceans even without the aid of the Dark Ships. Like most human inhabitants of the blessed isle, they have unnaturally long lifespans."
#end

#selectmonster 3149 -- Lochos
#name "Lochos"
#descr "When Eurymedon, King of the Gigantes like his brother Polybotes, led his kin to war against the gods of men, his son Nausithous saw the folly of his ways and fled with a few followers to distant lands. Eventually, the Gigantes who fled settled on Black Korkyra in the phaeacian archipelago, where they still hope never to be found by the armies of the God-slayer. After a short conflict the Gigantes yielded and Nausithous offered himself in marriage to the Colossi Queen. The Gigante nobles have intermingled with the Colossi, but the remaining Gigantes follow the traditions of their Mekonean ancestry and follow their Lochos commanders. The Lochos arm themselves with ancient armaments crafted by the Elder Cyclopes when the Mekonean Kingdom was still united."
#gcost 0
#hp 48
#userestricteditem 8055
#end

#newmonster 7406
#copystats 3149
#spr1 "./Hellenika/KorkyraLeader1.tga"
#spr2 "./Hellenika/KorkyraLeader2.tga"
#name "Polemarch"
#descr "When Eurymedon, King of the Gigantes like his brother Polybotes, led his kin to war against the gods of men, his son Nausithous saw the folly of his ways and fled with a few followers to distant lands. Eventually, the Gigantes who fled settled on Black Korkyra in the phaeacian archipelago, where they still hope never to be found by the armies of the God-slayer. After a short conflict the Gigantes yielded and Nausithous offered himself in marriage to the Colossi Queen. The Gigante nobles have intermingled with the Colossi, but the remaining Gigantes follow the traditions of their Mekonean ancestry and follow their Lochos commanders. The Polemarchs arm themselves with ancient armaments crafted by the Elder Cyclopes when the Mekonean Kingdom was still united. They surpass their brethren in skill and devotion and are powerful wielders of battle magic."
#hp 52
#mr 16
#mor 14
#str 22
#att 14
#def 14
#older -50
#combatcaster
#expertleader
#cleararmor
#clearweapons
#weapon 722
#armor 237
#armor 238
#armor 239
#magicskill 0 2
#magicskill 1 2
#end

#selectmonster 3156 -- Colossi Storm Captain
#userestricteditem 8055
#end

#selectmonster 3118 -- Mekonean Elder Cyclops
#name "Elder Cyclops"
#descr "The Elder Cyclops is an exalted giant of ages past. They were once taught the secrets of metalcrafting by the Telkhines. When the island of Telkhinis sunk beneath the waves and its masters were imprisoned in Tartarus, the Elder Cyclopes were spared in return for their services. But the celestial powers got tired of their servants and their crafts were all but forgotten. The Cyclopes found themselves lost and without purpose. Watching the lesser races they found a kindred race in the Gigantes of Mekone. Half of the few surviving cyclopes settled in a volcano outside the golden city of Mekone and found purpose again. Now they forge armaments for an army to punish pretending gods."
#resources 40
#hp 95
#montag 4112 -- for Triliax
#end

#selectmonster 3138 -- Phlegran Elder Cyclops
#name "Elder Cyclops"
#descr "The Elder Cyclops is an exalted giant of ages past. They were once taught the secrets of metalcrafting by the Telkhines. When Telkhinis sunk beneath the waves and its masters were imprisoned in Tartarus, the Elder Cyclopes were spared in return for their services. But the celestial powers forgot about their servants and their crafts were not put to use. The Cyclopes found themselves lost and without purpose. Watching the lesser races they found a kindred race in the Gigantes of Phlegra, who had took a part with them in the Telkhines' war against the Pantokrator. Half of the few surviving Cyclopes settled in the burning fields of Phlegra and were given purpose again. There, they built for their brothers a cyclopean fortress of iron and stone and helped them to calm their temper and wait for a better opportunity to strike the gods once again."
#resources 40
#hp 95
#montag 4112 -- for Triliax
#end

#selectmonster 3139 -- Phlegran Tyrant
#name "Phlegran Tyrant"
#descr "Phlegra is ruled by Tyrants of semi-divine descent. Punished for their hubris the Gigantes of Phlegra were cursed by a celestial decree. They have grown and their bodies show signs of the curse. Cursed Gigantes are frightening to behold with long hair and serpentine scales covering their legs, and their bodies have become resistant to heat and poison. The Phlegran Tyrants may have lost much of the discipline of earlier times, but they have gained tremendous physical and magical might. They are however, not very bright, and are inept at magical research. The Tyrants are the only Gigantes of Phlegra still wearing armaments crafted by the Elder Cyclopes. Phlegran Tyrants are not very skilled leaders, but they are exceptionally cruel and are intimidating enough to make most helots fight to the very end. Tyrants can round up locals and force them to take up arms and fight for Phlegra. In their hubris they believe themselves above the gods and they force the population to worship them."
#hp 75
#fear 5
#fireres 15
#gcost 315 -- unchanged
#end

#selectmonster 3129 -- Trophimos Commander
#name "Trophimos Commander"
#descr "The Trophimoi are human students that come to Phlegra. Some of them become taskmasters and are given command of slave armies. The Trophimoi draw upon the military knowledge of the ancient human kingdoms that fell under the Gigantes' tyranny and are often better commanders than their cursed lords."
#end

#selectmonster 3347 -- Nabaean Scout
#name "Sabaean Scout"
#descr "A large portion of the human Sabaeans live pastoral lives and are adept at surviving in the desert. Their scouts have the same armaments and skills as regular desert warriors."
#end

#selectmonster 3334 -- Sheikh
#name "Sheikh"
#descr "A large portion of the human Sabaeans live pastoral lives and follow their own rulers unless called upon by their 'Adite lords. Prominent caravan leaders blessed by the Jiniri Queens are respected as royalty by the human population. They lead the humans in trade and raids, but they rarely commit their men to full scale wars. This they leave to the 'Adites and the Sabaeans of the cliff cities. The Caravan Leaders can send their couriers with goods and treasures home to their Queens from faraway lands. Falconry is popular among the Sabaeans and most Sheikhs own at least one falcon."
#end

#selectmonster 3337 -- 'Adite General
#name "'Adite General"
#descr "The 'Adites are a tribe of Avvite giants that originate from the lands of Hinnom. To avoid the oppression of the Rephaites they fled into the deserts of 'Ad where they encountered the exiled Jinnun and formed an alliance, recognizing themselves in them. When their new allies' power waned the 'Adites became more influential and now the human Sabaeans serve the 'Adites as subjects rather than slaves."
#hp 40
#gcost 85
#end

#selectmonster 3358 -- Karib
#name "Karib"
#descr "The Karib is a human priest. The priests of Sa'Ba are divided into two sects; those who regard the Godhood as ascending from the earth, and those who regard the Godhood as descending from the stars. Most of the human population of Sa'Ba worship the earthen aspect of the Reawakening God, and while more numerous than the 'Adite Mukarribs, the Karibs have less influence. The human Karibs of the earthen sect can be found throughout the lands of Sa'Ba, following the caravans to foreign lands."
#end

#selectmonster 3332
#name "Sabaean Desert Warrior"
#descr "A large portion of the Sabaeans live pastroral lives and are adept at surviving in the desert. Their warriors are swift and silent, but they lack the armaments or cohesion to fight real battles. This they leave to the 'Adites."
#end

#selectmonster 3338
#name "Sabaean Soldier"
#descr "While most human Sabaeans live pastoral lives, the marvels of the 'Adite cities carved from the desert cliffs have attracted growing numbers of human settlers. Now most 'Adite settlements have a large human  population. These humans have adopted 'Adite customs and tactics and readily fight to defend their cities. Now human soldiers march side by side with the 'Adites in the armies of the Awakening God."
#end

#selectmonster 3356
#name "Sabaean Light Infantry"
#descr "While most human Sabaeans live pastoral lives, the marvels of the 'Adite cities carved from the desert cliffs have attracted growing numbers of human settlers. Now most 'Adite settlements have a large human  population. These humans have adopted 'Adite customs and tactics and readily fight to defend their cities. Now human soldiers march side by side with the 'Adites in the armies of the Awakening God."
#end

#selectmonster 3333
#name "Sabaean Camel Rider"
#descr "The human Sabaeans live pastoral lives. Their caravans travel through the deserts to distant lands where they are met with wonder and disbelief. The camel caravans of Sa'Ba are famous for their frankincense and marvelous goods from the Hidden Land. But the caravan riders are not just simple merchants. Swordplay is  an important part of life and every member of a caravan is an accomplished warrior trained in mounted fighting. Caravans readily raid unsuspecting victims, should their masters wish it. Falconry is popular  among the Sabaeans and many camel riders own a falcon."
#end

#selectmonster 3336
#name "'Adite Archer"
#descr "The 'Adites are a tribe of Avvite giants that originate from the lands of Hinnom. To avoid the oppression of the Rephaites they fled into the deserts of 'Ad where they encountered the exiled Jinnun and formed an alliance, recognizing themselves in them. When their new allies' power waned the 'Adites became more influential and now the human Sabaeans serve the 'Adites as subjects rather than slaves. The 'Adites are far superior to human troops and form the elite corps of the Sabaean army. They fight in the style once taught by the Rephaite descendants of Azazel."
#hp 36
#gcost 25
#end

#selectmonster 3355
#name "'Adite Light Infantry"
#descr "The 'Adites are a tribe of Avvite giants that originate from the lands of Hinnom. To avoid the oppression of the Rephaites they fled into the deserts of 'Ad where they encountered the exiled Jinnun and formed an alliance, recognizing themselves in them. When their new allies' power waned the 'Adites became more influential and now the human Sabaeans serve the 'Adites as subjects rather than slaves. The 'Adites are far superior to human troops and form the elite corps of the Sabaean army. They fight in the style once taught by the Rephaite descendants of Azazel."
#hp 36
#gcost 25
#end

#selectmonster 3335
#name "'Adite Elite Soldier"
#descr "The 'Adites are a tribe of Avvite giants that originate from the lands of Hinnom. To avoid the oppression of the Rephaites they fled into the deserts of 'Ad where they encountered the exiled Jinnun and formed an alliance, recognizing themselves in them. When their new allies' power waned the 'Adites became more influential and now the human Sabaeans serve the 'Adites as subjects rather than slaves. The 'Adites are far superior to human troops and form the elite corps of the Sabaean army. They fight in the style once taught by the Rephaite descendants of Azazel."
#hp 38
#gcost 25
#end

#selectmonster 3342
#name "Jann Guard"
#descr "The Jann are half-breed descendants of the exiled Jinnun from Ubar. Gifted with the spiritual might of the Jinnun and the strong physique of the 'Adites they are superior to men in every way. The Jann form the ruling caste of Sa'Ba and most of them live secluded lives in marvelous palaces carved out of the enchanted cliffs of the Concealed City. While most Jann live comfortable lives served by slaves there are some who pursue a martial career. These mighty warriors defend their Queens and Chahar Bagh, 'the Fourfold Garden', the sanctum and oasis created by the exiled Jinnun of the past in the image of Iram's wondrous Jannah. Unlike the true-blooded Jinnun, the Jann have physical form, but they can hide their true appearances and are able to fool lesser men with illusions and tricks of the mind. Jann, like their Jinnun ancestors, take great discomfort from the touch of iron and use armaments and weapons made of bronze."
#hp 33
#gcost 40
#end

#selectmonster 3389
#name "Jinn Block"
#descr "The Jinn Block is a carved stone block inhabited by a Jinn. The Jinn Block has limited powers and is immobile, but the stone block is difficult to destroy and will protect itself from intruders. The Jinn Block is sacred to the sabaean desert tribes and have some priestly powers."
#eyes 0
#end

#selectmonster 3353 -- Jinn (Sa'Ba)
#name "Jinn"
#descr "Jinnun are spiritual beings born from smokeless flame in a distant past. They replaced the Hinn and Binn during the reign of a previous Pantokrator. They are naturally invisible and ethereal, but can take physical form when they interact with men. Most Jinnun live in Ubar, a magic desert kingdom of marvelous riches, but the gates were sealed by a divine decree and the City was hidden from the eyes of men, only a few Jinnun succeeding in fleeing in time and scattering, only to leave Ubar in sand to be forgotten. There are many Jinn races with different abilities and powers, but they are all born from Smokeless Flame and therefore strongly attuned to magic, ethereal and invisible unless they wish to be seen. All true-blooded Jinnun are sacred in the queendom of Sa'Ba, even though they aren't in Ubar, where much greater beings exist to be revered."
#end

#selectmonster 3354 -- Jinn Warrior (Sa'Ba)
#name "Jinn Warrior"
#descr "Jinnun are spiritual beings born from smokeless flame in a distant past. They replaced the Hinn and Binn during the reign of a previous Pantokrator. They are naturally invisible and ethereal, but can take physical form when they interact with men. Most Jinnun live in Ubar, a magic desert kingdom of marvelous riches. The City of Brass once fielded armies of Jinnun, wielding magic and armed with enchanted weapons. These Jinn Warriors now mostly follow the Jinn Emirs of Iram, waiting for the Gates of Brass to open and for the war upon mankind to restart so that magic can be restored to the world; however, they sometimes instead answer the call of the renegade Jiniri Queens of Sa'Ba whose intentions are less threatening to humans. There are many Jinn races with different abilities and powers, but they are all born from Smokeless Flame and therefore strongly attuned to magic, ethereal and invisible unless they wish to be seen. All true-blooded Jinnun are sacred in the queendom of Sa'Ba, even though they aren't in Ubar, where much greater beings exist to be revered."
#end

#selectmonster 3463 -- Jinn Warrior (Sa'Ba)
#name "Jinn Warrior"
#descr "Jinnun are spiritual beings born from smokeless flame in a distant past. They replaced the Hinn and Binn during the reign of a previous Pantokrator. They are naturally invisible and ethereal, but can take physical form when they interact with men. Most Jinnun live in Ubar, a magic desert kingdom of marvelous riches. Once the City of Brass was the capital of the Jinnun, but the gates were sealed by a divine decree and the City was hidden from the eyes of men. All that was left was windswept pillars and a city covered in sand, known to man as Iram of a Thousand Pillars. Here the few remaining loyal Jinnun and their human servants gather and wait for the seals to break. The City of Brass once fielded armies of Jinnun, wielding magic and armed with enchanted weapons. These Jinn Warriors now mostly follow the Jinn Emirs of Iram, waiting for the Gates of Brass to open and for the war upon mankind to restart so that magic can be restored to the world; however, they sometimes instead answer the call of the renegade Jiniri Queens of Sa'Ba whose intentions are less threatening to humans. There are many Jinn races with different abilities and powers, but they are all born from Smokeless Flame and therefore strongly attuned to magic, ethereal and invisible unless they wish to be seen. Jinnun are vulnerable to iron and salt and the Jinn Warriors of Ubar use armaments of bronze."
#end

#selectmonster 3341
#name "Malikah"
#descr "Sa'Ba is ruled by the Malikat, Jinari Queens descendant of the imprisoned Sultans of Ubar, whose authority they challenged and overthrew by building their own kingdom from the Concealed City. Their blood is pure and runs thick with the magic of the Jinnun. Their bodies are insubstantial, almost transparant and ever young. They are gifted with flight and are innately skilled in the magic of the Jinnun. They can obfuscate their surroundings and hide their entire entourage with illusions and tricks of the mind. Like their ancestors they suffer pain if touched by cold iron. From the palaces of Chahar Bagh the Malikat rule over the men and giants of Sa'Ba, and send caravans of marvelous wonders to distant lands to gather riches and knowledge to aid the Awakening God."
#userestricteditem 8069
#twiceborn 3384
#hp 28
#gcost 485
#userestricteditem 8059
#end

#selectmonster 3343 -- Jann Emir
#hp 36
#gcost 275
#end

#selectmonster 3357
#name "Mukarrib"
#descr "The Mukarrib, One Close to God, is an 'Adite priest. The priests of Sa'Ba are divided into two sects, those who regard the Godhood as ascending from the earth and those who regard the Godhood as descending from the stars. Most of the 'Adite population of Sa'Ba worship the astral aspect of the Reawakening God and their priests observe  the signs of the stars. The 'Adite Mukkarribs reside in the cliff cities and are closer to power than the human Karibs. While less numerous then the human pritests, they have far greater influence and religious authority. To most effects they even outrank the Jann Nobles, who care little for religious affairs, besides being worshipped."
#hp 31
#gcost 120
#userestricteditem 8059
#end

#selectmonster 3339
#name "Hermit Sahir"
#descr "In the deserts of Sa'Ba, reclusive sorcerers practice the ancient magic of the Hinn and the Jinn. The Hinn and the Jinn were spiritual beings of air and fire that roamed the land in times before mankind came to dominate the world. Many Sahara have made pacts with the Hinn and have Hinn companions. While most of these hermits avoid contact with other men, there are some who follow their tribal leaders and join their caravans to guide them and protect them from supernatural threats."
#userestricteditem 8059
#end

#selectmonster 3373 -- Shaytan (Sa'Ba)
#name "Shaytan"
#descr "The Shayatin are a race of malign and powerful Jinnun, spiritual beings born from Smokeless Flame. They are most often thought to serve the Sultans of Ubar with their silver tongues and crafty lies, but some actually scheme against them and thus ally with their rivals, in particular the Jiniri Queens of Sa'Ba. As masters of manipulation they lead the enemies of their lords astray. Shayatin are arrogant, proud and since magic has begun to wane they harbor a hatred for mankind, whom they blame for the loss of magic. Even those who were exiled from Iram have scattered and hid in remote areas, from which they've since plotted their revenge. It is they who convinced the Sultans to wage war upon humanity, they who doomed the City of Brass. Shayatin are masters of lies and can corrupt and lead the most loyal servant away from his master. Shayatin are pure-blooded Jinnun and share their traits, such as invisibility, glamour and a strong connection with magic."
#end

#selectmonster 3472 -- Shaytan (Ubar)
#name "Shaytan"
#descr "The Shayatin are a race of malign and powerful Jinnun, spiritual beings born from Smokeless Flame. They are most often thought to serve the Sultans of Ubar with their silver tongues and crafty lies, but some actually scheme against them and thus ally with their rivals, in particular the Jiniri Queens of Sa'Ba. As masters of manipulation they lead the enemies of their lords astray. Shayatin are arrogant, proud and since magic has begun to wane they harbor a hatred for mankind, whom they blame for the loss of magic. Even those who were exiled from Iram have scattered and hid in remote areas, from which they've since plotted their revenge. It is they who convinced the Sultans to wage war upon humanity, they who doomed the City of Brass. Shayatin are masters of lies and can corrupt and lead the most loyal servant away from his master. Shayatin are pure-blooded Jinnun and share their traits, such as invisibility, glamour and a strong connection with magic."
#end

#selectmonster 3372 -- Ifrit (Sa'Ba)
#name "Ifrit"
#descr "Afarit are powerful Jinnun born from Smokeless Flame. Endowed with exceptional physical and magical might, they are arrogant and cruel, and might be perceived as outright evil. Most Afarit live sequestered lives in the opulent palaces of Iram, visiting the Houris of Jannah and feasting upon dates and grapes of unequalled flavor while waiting for the Gates of Brass to open at last; but a few escaped imprisonment and became renegades in Ubar's eyes, scattering and vanishing until all but the Jinnun of Sa'Ba forgot them. Now, with magic scarce outside the lost walls of Iram, the renegade Afarit are drawn to the smell of sacrificial blood. Afarit are spiritual beings and are invisible until they manifest. When wounded they reveal their true form, ablaze with Smokeless Flame, a pure green and yellow fire of incredible heat. Afarit are attuned to magic and are stronger in provinces where magic is strong."
#end

#selectmonster 3464 -- Ifrit Warrior (Ubar)
#name "Ifrit Warrior"
#descr "Afarit are powerful Jinnun born from Smokeless Flame. Endowed with exceptional physical and magical might they are arrogant and cruel, and might be perceived as outright evil. The Afarit and their Sultans rule the magical kingdom of Ubar and the lesser Jinnun. There are few Afarit and their warriors only join armies when called upon by their Sultans. When commanded by their Sultans a few Ifrit Warriors can obliterate entire armies by themselves. Afarit are spiritual beings and are invisible until they manifest. When wounded they reveal their true form, ablaze with Smokeless Flame, a pure green and yellow fire of incredible heat. Afarit are attuned to magic and are stronger in provinces where magic is strong. Afarit suffer from two weaknesses, iron and salt, and with the aid of these mankind might prevail. Under the God's dominion, their magical aura is so powerful that after they have received a Divine Name they might attract more Afarit exiled in the ancient times to join the battle for ascension."
#raredomsummon 3464
#end

#selectmonster 3465 -- Ifrit Sultan (Ubar)
#name "Ifrit Sultan"
#descr "The Sultans are the oldest and mightiest of a race of mighty beings. Born from Smokeless Flame and endowed with vast magical and physical powers they have ruled Ubar since the coming of man. Most of the Sultans live sequestered lives in the opulent palaces of the City of Brass, visiting the Houris of Jannah and feasting upon dates and grapes of unequalled flavor. When distracted from these pleasantries, the white hot ire of the Afarit flares and they emerge to wage war upon those who would disturb their flawless lives. The Ifrit Sultans are Afarit and share their traits, albeit more powerful. They are innately powerful wielders of Sahar, the sorcery of the Jinnun, and can unleash unrivaled destruction upon men."
#raredomsummon 3464
#gcost 570
#magicskill 8 3
#bonusspells 1
#end

#selectmonster 3468 -- Jinn Sahir
#name "Jinn Sahir"
#descr "The Jinnun are magical beings closely attuned to the essence of arcana. Sine the City of Brass was sealed, the Jinnun haunt the ruins known to man as Iram of a Thousand Pillars. Men of the deserts have come to Iram and become servants of the Jinnun. The Jinn Sahara have rewarded loyal men with magical gifts and the blessings of the Jinn. All of the Unseen are able to use minor magical tricks, but arcane studies come naturally to them and there are many who have become sages and sorcerers of remarkable power. While not as strong as the Ifrit Sultans they serve, these Jinn Sahara display formidable power over the elements from which they are born. They can also obfuscate their surroundings and hide a small entourage with illusions and tricks of the mind. They can either be recruited in the capital or, with the presence of an Ifrit Sultan to command them, in other forts more slowly."
#end

#selectmonster 3469 -- Jinn Emir
#name "Jinn Emir"
#descr "Since the City of Brass was sealed, the Jinnun haunt the ruins known to man as Iram of a Thousand Pillars. The Emir is a Jinn noble serving the imprisoned Sultans of Ubar. With the imminent awakening of the God, the Emirs and their Jinn Warriors have initiated the war upon mankind to please the Lords of Ubar. They are skilled commanders and are adept in the magic of the Jinnun. For the Jinnun, military training is time consuming, compared to arcane studies, and the armies of Ubar fields fewer Emirs than sorcerers. Still, with the opening of the Gates of Brass, this might come change. Jinn Emirs can either be recruited in the capital or, with the presence of an Ifrit Sultan to command to them, in other forts."
#end

#selectmonster 3463 -- Jinn Warrior
#name "Jinn Warrior"
#descr "Jinnun are spiritual beings born from Smokeless Flame in a distant past. They replaced the Hinn and Binn during the reign of a previous Pantokrator. They are naturally invisible and ethereal, but can take physical form when they interact with men. The Jinnun live in Ubar, a magic desert kingdom of marvelous riches. Once the City of Brass was the capital of the Jinnun, but the gates were sealed by a divine decree and the City was hidden from the eyes of men. All that was left was windswept pillars and a city covered in sand, known to man as Iram of a Thousand Pillars. Here the few remaining Jinnun and their human servants gather and wait for the seals to break. The City of Brass once fielded armies of Jinnun armed with enchanted weapons. These Jinn Warriors now follow the Jinn Emirs of Iram, waiting for the Gates of Brass to open and the war upon mankind restarted so that magic can be restored to the world. There are many Jinn races with different abilities and powers, but they are all born from Smokeless Flame and therefore strongly attuned to magic, ethereal and invisible unless they wish to be seen. Jinnun are vulnerable to iron and salt and the Jinn Warriors of Ubar use armaments of bronze. They can either be recruited in the capital or, with the presence of an Ifrit Sultan to command them, in other forts."
#end

#newmonster 7374
#copyspr 3468
#copystats 3468 -- Jinn Sahir
#monpresentrec 3465
#rpcost 4
#gcost 260
#end

#newmonster 7375
#copyspr 3469
#copystats 3469 -- Jinn Emir
#monpresentrec 3465
#end

#newmonster 7376
#copyspr 3463
#copystats 3463 -- Jinn Warrior
#monpresentrec 3465
#reclimit 1
#end

#selectmonster 3374 -- Marid (Sa'Ba)
#bonusspells 1
#end

#selectmonster 3376 -- Marid (Ubar)
#bonusspells 1
#magicskill 2 3
#end

#selectmonster 3379 -- Great Huntress
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3318 -- Magog Bitch-Mother
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3314 -- Feminie Sorceress
#name "Feminie Sorceress"
#descr "The land of Great Feminie is a kingdom in the land of Magnificent Ind. It was once formed by proud Amazons who rejected the four Tribes' separation and rule to remain united. Women still hold power in the land and everyone of importance is female, not least their mages. The sorceresses of the Great Feminie no longer practice the unsophisticated and bloody arts of the Amazons, but have become influenced by the wise Magi of Ind."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3312 -- Feminie Queen
#name "Feminie Queen"
#descr "The land of Great Feminie is a kingdom in the land of Magnificent Ind. It is ruled by several queens descendant from proud Amazons of the four Tribes who exiled themselves to remain united even when their sisters separated to take opposing paths. Women still hold power in the land and the soldiers and knights of the land are invariably female. Any man visiting a lady of the land is allowed to stay for nine days, but if he overstays he will die. Such are the customs of Great Feminie. The Feminie Queens are highly skilled and inspirational commanders. Even after the subjugation, the Queens have remained in power and there is no Viceroy of Ind to rule the Great Feminie."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3375 -- Houri (Sa'Ba)
#name "Houri"
#descr "Houris, The Fair Ones, are concubines and entertainers of the Sultans of Ubar chosen for their beauty and exquisite manners. Most live sequestered lives in Jannah, the enchanted garden of Iram, and are rarely allowed to leave their paradise unless tasked by their Sultan to seduce or entertain a foreign diplomat or ruler. When the Jinnun were sealed inside Iram of a Thousand Pillars, a few Houris were able to escape in the chaos and eventually found shelter in the mystical Chahar Bagh of Sa'Ba, clinging to the residual magic of the Fourfold Garden. Houris are Jiniris and share the traits of pure-blooded Jinnun, such as glamour, invisibility and a strong connection with magic."
#userestricteditem 8069
#twiceborn 3375
#end

#selectmonster 3279 -- Cynocephalian Shaman
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3341 -- Malikah
#userestricteditem 8069
#twiceborn 3341
#end

#selectmonster 346 -- Crystal sorceress
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 347 -- Crystal priestess
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 353 -- Jade priestess
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 355 -- Onyx sorceress
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 356 -- Onyx priestess
#userestricteditem 8069
#twiceborn 6675
#end

#newmonster 6543
#copyspr 2266
#name "Queen of Apsum"
#descr "Unlike Berytos, which is otherwise very close to it culturally, Apsum always was ruled by descendants of the mighty Machakan Lion Queens of the great race of Mababwe. Called 'Colossi' by the historians of Arcoscephale, they are truly superior to ordinary men and bear a divine heritage in their blood. Their Queens are sorceresses of great power and adopted the bloody cult of the Melqarts long before Berytos, although in a very similar fashion. But times change, and due to its close geographical proximity with Nabatem and relative isolation from other nations as well as to its comparable traditions of matriarchal rulership and slavery, Apsum's exchanges and ties of partnership with Saqaba have never ceased to grow. In parallel, its other neighbors have considerably expanded their terrorities in recent times and became increasingly hostile before that small city-state. The great queens of Apsum are so proud of their divine ancestry and glorious history that, when they felt their precious independence threatened, they started to question the cult they themselves had led to power. Thus, it only became a question of time before they agreed to betray their faraway Rephaim masters and joined their forces with their cousins of the Onyx Tribe. Accepting their exotic baetylic cult was a small price to pay to share with Saqaba a common destiny, for the Carved City too is in need of allies and more than anything else wants to stay strong and autonomous. Now, the Queens of Apsum are glad to learn their new religion and to rediscover some forgotten parts of their own past in the lost mausoleums of Nabatem. Although they no longer have any priestly power or sacred status, they still are great masters of Blood magic and outstanding military leaders. In addition, each is at all times accompanied by two blood slaves like personal pets ready for battlemagic sacrifice, and they are so loyal allies of the Lost Necropolis that they may end up deserting when controlled by other nations."
#hp 18
#size 3
#prot 1
#mr 17
#mor 12
#expertleader
#command 20
#okundeadleader
#rcost 1
#str 13
#att 10
#def 10
#prec 12
#ap 14
#rpcost 4
#mapmove 20
#enc 2
#maxage 150
#older -115
#weapon 473
#armor 148
#gcost 10020
#female
#nametype 125
#magicskill 0 1
#magicskill 1 1
#magicskill 3 2
#magicskill 7 2
#custommagic 17792 100
#custommagic 17792 20
#custommagic 17792 20
#userestricteditem 8069
#batstartsum2 326
#taskmaster 3
#wastesurvival
#twiceborn 6673
#deserter 7
#end

#newmonster 6544
#copyspr 2266
#name "Queen of Apsum"
#descr "Unlike Berytos, which is otherwise very close to it culturally, Apsum always was ruled by descendants of the mighty Machakan Lion Queens of the great race of Mababwe. Called 'Colossi' by the historians of Arcoscephale, they are truly superior to ordinary men and bear a divine heritage in their blood. Their Queens are sorceresses of great power and adopted the bloody cult of the Melqarts long before Berytos, although in a very similar fashion. But times change, and due to its close geographical proximity with Nabatem and relative isolation from other nations as well as to its comparable traditions of matriarchal rulership and slavery, Apsum's exchanges and ties of partnership with Saqaba have never ceased to grow. In parallel, its other neighbors have considerably expanded their terrorities in recent times and became increasingly hostile before that small city-state. The great queens of Apsum are so proud of their divine ancestry and glorious history that, when they felt their precious independence threatened, they started to question the cult they themselves had led to power. Thus, it only became a question of time before they agreed to betray their faraway Rephaim masters and joined their forces with their cousins of the Onyx Tribe. Accepting their exotic baetylic cult was a small price to pay to share with Saqaba a common destiny, for the Carved City too is in need of allies and more than anything else wants to stay strong and autonomous. Now, the Queens of Apsum are glad to learn their new religion and to rediscover some forgotten parts of their own past in the lost mausoleums of Nabatem. Although they no longer have any priestly power or sacred status, they still are great masters of Blood magic and outstanding military leaders. In addition, each is at all times accompanied by two blood slaves like personal pets ready for battlemagic sacrifice, and they are so loyal allies of the Lost Necropolis that they may end up deserting when controlled by other nations."
#hp 18
#size 3
#prot 1
#mr 17
#mor 12
#expertleader
#command 20
#okundeadleader
#rcost 1
#str 13
#att 10
#def 10
#prec 12
#ap 14
#rpcost 4
#mapmove 20
#enc 2
#maxage 150
#older -115
#weapon 473
#armor 148
#gcost 10020
#female
#nametype 125
#magicskill 0 1
#magicskill 1 1
#magicskill 3 2
#magicskill 7 2
#custommagic 17792 100
#custommagic 17792 20
#custommagic 17792 20
#userestricteditem 8069
#batstartsum2 326
#taskmaster 3
#wastesurvival
#twiceborn 6673
#end

#selectmonster 2266 -- Bride-in-Waiting
#userestricteditem 8069
#twiceborn 6675
#undcommand 10
#mountainsurvival
#wastesurvival
#gcost 415
#end

#selectmonster 891 -- Sorceress (Machaka)
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 343 -- Sorceress
#name "Azure Sorceress"
#descr "The Azure Sorceresses are female mages of a secluded order which specializes in Astral magic, but they often practice some others paths of magic as well."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 344 -- Black Sorceress
#name "Night Sorceress"
#descr "The Night Sorceresses are female mages of a secluded order which specializes in Astral and elemental magic. A few of them also practice darker arts."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 393 -- Lammashta
#female
#userestricteditem 8069
#end

#selectmonster 634 -- Handmaiden of Death
#userestricteditem 8069
#end

#selectmonster 1714 -- Dakini
#userestricteditem 8069
#end

#selectmonster 1226 -- Naiad
#userestricteditem 8069
#twiceborn 1477
#end

#selectmonster 1477 -- Kokythiad
#userestricteditem 8069
#twiceborn 1477
#end

#selectmonster 2832 -- Strategis
#userestricteditem 8069
#twiceborn 2832
#end

#selectmonster 609 -- Lamia Queen
#userestricteditem 8069
#twiceborn 609
#end

#selectmonster 610 -- Lamia Queen
#userestricteditem 8069
#twiceborn 610
#end

#selectmonster 774 -- Female Tartarian Titan
#userestricteditem 8069
#end

#selectmonster 777 -- Tartarian Monstra
#female
#userestricteditem 8069
#end

#selectmonster 359 -- Queen of the Sea
#userestricteditem 8069
#end

#selectmonster 907 -- Queen of the Deeps
#userestricteditem 8069
#end

#selectmonster 908 -- Queen of the Lake
#userestricteditem 8069
#end

#selectmonster 946 -- Lady of Spiders
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 947 -- Great Spider
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2429 -- Bride of the Gods
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 153 -- Crone of Avalon
#userestricteditem 8069
#twiceborn 6675
#montag 4153 -- can cast Transformation
#end

#selectmonster 1752 -- Sidhe Champion
#magicpower 1
#end

#selectmonster 1759 -- Sidhe Lord
#magicpower 1
#end

#selectmonster 1774 -- Bean Sidhe
#userestricteditem 8069
#twiceborn 6675
#magicpower 1
#end

#selectmonster 1776 -- Bean Sidhe
#userestricteditem 8069
#twiceborn 6675
#magicpower 1
#end

#selectmonster 1792 -- Nemedian Sorceress
#name "Nemedian Sorceress"
#descr "The Nemedians have merged the old magical traditions of their Partholonian ancestors and the magic of their Fomorian masters. Sorceresses skilled in Death and Air magic hide in the dark spires of Rath Chimbaith and in the misty marshlands of the kingdom where they summon whispering shades of mist and darkness."
#userestricteditem 8069
#twiceborn 1792
#swampsurvival
#end

#selectmonster 1791 -- Nemedian Champion
#name "Nemedian Champion"
#descr "Nemedians are the descendants of the Sauromatian Partholonians. They are a highly magical race far superior to ordinary men, but they were few in number. The Nemedians once warred with the Fomorians and were defeated and subjugated. A few of them still linger in the old fortress Rath Chimbaith and in the misty marshlands of the kingdom. Their champions possess some priestly authority and have some skill in Death and Air magic."
#swampsurvival
#twiceborn 1791
#end

#selectmonster 1790 -- Nemedian Warrior
#name "Nemedian Warrior"
#descr "Nemedians are the descendants of the Sauromatian Partholonians. They are a highly magical race far superior to ordinary men, but they were few in number. With the arrival of the Witch Kings, they left Sauromatia for a better place. The Nemedians followed in the footsteps of their Partolonian ancestors and arrived in the rich land of the Fomorians. Soon war broke out. The Nemedians were victorious until the plague that once eradicated the Partholonians struck them and wiped out half the population. The war ended with the subjugation of the Nemedians. After a bloody rebellion, most of them fled from the land, but a few of them still linger in the old fortress Rath Chimbaith and in the misty marshlands of the kingdom. Nemedian Warriors take great discomfort from iron and use armaments made of bronze and enchanted metals."
#rcost -5
#rpcost 18
#swampsurvival
#end

#selectmonster 1773 -- Tuatha Sorceress
#name "Tuatha Sorceress"
#descr "While the Tuatha Kings rule and wage war, their consorts use their time to practice the more refined arts of the race. They have mastered the magic of false appearances, mists and the winds, and they are even able to cast the Transformation ritual. The Tuatha are also closely attuned to the land and are skilled in Nature magic. Poetry is very important to them and the Tuatha have developed remarkable spellsongs."
#userestricteditem 8069
#twiceborn 1773
#yearturn 5
#magicpower 1
#enc 2
#hp 14
#def 15
#bringeroffortune 5
#montag 4153 -- can cast Transformation
#end

#selectmonster 2921 -- Morgen Sorceress
#name "Morgen Sorceress"
#descr "Ys is ruled by sorceresses descending from a clan of Tuatha that for their ambitions were banished from Tir na n'Og long ago. When their citadel of Ker-Ys was hidden beneath the waves and they sequestered themselves from the other Tuatha, they slowly adapted to a life under water and were transformed into Morgen, semi-divine beings revered by the Merrow of Ys. Centuries later, although neither Tuatha nor Morgen has met ever since, both still live and remember their ancient rivals, awaiting the time to claim back what they believe theirs and to subjugate those they call betrayers. Most Morgen train as knights, but the older and wiser Morgen often give up their arms and turn to studies in the magic arts of their ancestors. Morgen, like their Tuatha cousins, are skilled in the use of glamour and Air magic, but with their transformation into Morgen they have adapted and mastered other paths, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost."
#enchrebate50p 59
#userestricteditem 8069
#twiceborn 2921
#armor 148
#end

#selectmonster 2920 -- Morgen Princess
#name "Morgen Princess"
#descr "The Morgen Princess is a descendant of Dahut, queen of Ys. While younger and not as magically powerful as the sorceresses, the princesses have become the true leaders of the queendom. Trained in tactics, magic and combat they have become mage-generals of unsurpassed skill. The Morgen Princesses lead the armies of Ys and the Morvarc'h Knights in the conquest of lands once theirs and lands never visited, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost."
#enchrebate50p 59
#userestricteditem 8069
#twiceborn 2920
#armor 148
#montag 4106
#combatcaster
#end

#selectmonster 2919 -- Morgen Princess
#name "Morgen Princess"
#descr "The Morgen Princess is a descendant of Dahut, queen of Ys. While younger and not as magically powerful as the sorceresses, the princesses have become the true leaders of the queendom. Trained in tactics, magic and combat they have become mage-generals of unsurpassed skill. The Morgen Princesses lead the armies of Ys and the Morvarc'h Knights in the conquest of lands once theirs and lands never visited, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost."
#enchrebate50p 59
#userestricteditem 8069
#twiceborn 2919
#mapmove 28
#armor 148
#ap 36
#montag 4106
#combatcaster
#end

#selectmonster 2918 -- Morgen Champion
#name "Morgen Champion"
#descr "The Morgen Champion is a Morvarc'h Knight with strong blood and exceptional skills. Innately skilled in the magic of the Tuatha she has become a leader among her peers and an example to all. Mounted on Morvarc'h steeds the Morgen can charge on land, gallop on the sea or dive beneath its waves. On land the Morvarc'h are even more terrifying with their flaming breath. With the arrival of the new God, all lands will come under the rule of Ys. Because they must be initiated in the secrets of their foremothers before taking up arms, Morgen Champions require for their recruitment the presence of a Morgen Princess or hero, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost."
#enchrebate50p 59
#userestricteditem 8069
#twiceborn 2918
#monpresentrec -4106
#combatcaster
#end

#selectmonster 2917 -- Morgen Champion
#name "Morgen Champion"
#descr "The Morgen Champion is a Morvarc'h Knight with strong blood and exceptional skills. Innately skilled in the magic of the Tuatha she has become a leader among her peers and an example to all. Mounted on Morvarc'h steeds the Morgen can charge on land, gallop on the sea or dive beneath its waves. On land the Morvarc'h are even more terrifying with their flaming breath. With the arrival of the new God, all lands will come under the rule of Ys. Because they must be initiated in the secrets of their foremothers before taking up arms, Morgen Champions require for their recruitment the presence of a Morgen Princess or hero, and like all Morgen they long for the return of Thetis' Blessing which will grant them back their glory and halve their gold cost."
#enchrebate50p 59
#userestricteditem 8069
#twiceborn 2917
#monpresentrec -4106
#mapmove 28
#ap 36
#combatcaster
#end

#selectmonster 1054 -- Siren
#userestricteditem 8069
#twiceborn 1054
#spellsinger
#regeneration 20
#gcost 130
#end

#selectmonster 1055 -- Siren
#userestricteditem 8069
#twiceborn 1055
#spellsinger
#regeneration 20
#gcost 130
#end

#selectmonster 237 -- Dryad
#userestricteditem 8069
#twiceborn 237
#end

#selectmonster 151 -- Daughter of Avalon
#userestricteditem 8069
#twiceborn 151
#end

#selectmonster 1775 -- Baobhan Sidhe
#userestricteditem 8069
#twiceborn 1775
#magicpower 1
#end

#selectmonster 2187 -- Dryad
#userestricteditem 8069
#twiceborn 711
#end

#selectmonster 705 -- Dryad
#userestricteditem 8069
#twiceborn 711
#end

#selectmonster 237 -- Dryad
#userestricteditem 8069
#twiceborn 711
#end

#selectmonster 2557 -- Airya Seraphine
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 616 -- Seraphine
#name "Seraphine"
#descr "The Seraphines are female priests of the ice temples. With the Eagle Kings' corruption at the Raptors' hands and the great exile from the White Forest of the Purifying Flame they have lost a lot of their importance. The High Seraphs have become rulers of the new, secluded kingdom and the old traditions have lost some of their appeal. The Seraphines conduct services, keep alight the sacred flames which they brought with them in their exile, and tend the frost flowers of the ice gardens which they have cultivated in Hararat in the hope of recreating there those of High Caelum. Each frost flower is said to hold the soul of a dead Caelian, and now that the ashen flowers of Ravens' Vale are far away the Seraphines want to believe that the corrupting influence of the Raptors will finally go away. Since their exile, the Seraphines have gained a more martial role. Unlike those that remained loyal to the Eagle Kings, they abandoned the horrible practice of wing cutting and they now instead lead the Immaculate Guards into battle. Seraphines sometimes set up secret cults in human lands. Their wings and beauty allow them to present themselves as angels and divine messengers. When becoming a prophet, a Seraphine will also receive improved mastery of Fire magic if she already has some knowledge of this path and she will bless her entire province with the supernatural protection of winter by starting to spread Cold scales."
#magicboost 0 1
#incscale 2
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2487 -- Dryad Mother
#name "Dryad Mother"
#descr "Some of the oldest and most influential dryads are blessed by Gaia with the power to charm, not just men, but all living things. Plants and animals come to their aid, and few living beings would ever consider hurting them. While peaceful at heart, the Dryad Mothers sometimes join the armies of Pangaea to protect the beasts and plants of the forests. They are powerful enough to cast spells as if they started every battle with a gem of Nature and are even able to cast the Transformation ritual."
#userestricteditem 8069
#twiceborn 711
#tmpnaturegems 1
#older 40
#montag 4153 -- can cast Transformation
#end

#selectmonster 2480 -- Dryad Hag
#name "Dryad Hag"
#descr "The awakening of the Vengeful Woods has altered the very essence of Pangaea's inhabitants. Dryad Hags were the first of these black dryads. When they first appeared it was an event of great alarm and the young kids were contained or exiled. Soon it became evident that it was not a singular event. Other half-men with black hides, mirroring the dark mood of the Vengeful Forest were also born. The half-men of Pangaea were divided and the exiles and the discontent formed an emerging power that threatens the civilized world. The dryad hags are old, sly and harbor a relentless hatred of the civilized world. They have completely lost the beauty-inspired aura of awe of the white dryads, but still are powerful enough to cast spells as if they started every battle with a gem of Death and are even able to cast the Transformation ritual."
#userestricteditem 8069
#twiceborn 711
#tmpdeathgems 1
#montag 4153 -- can cast Transformation
#end

#selectmonster 901 -- Black Dryad
#userestricteditem 8069
#twiceborn 711
#end

#selectmonster 204 -- Seraphine
#name "Seraphine"
#descr "The Seraphines are female priests of the ice temples. With the Eagle Kings' corruption at the Raptors' hands and the great exile from the White Forest of the Purifying Flame they have lost a lot of their importance. The High Seraphs have become rulers of the new, secluded kingdom and the old traditions have lost some of their appeal. The Seraphines conduct services, keep alight the sacred flames which they brought with them in their exile, and tend the frost flowers of the ice gardens which they have cultivated in Hararat in the hope of recreating there those of High Caelum. Each frost flower is said to hold the soul of a dead Caelian, and now that the ashen flowers of Ravens' Vale are far away the Seraphines want to believe that the corrupting influence of the Raptors will finally go away. Since their exile, the Seraphines have gained a more martial role. Unlike those that remained loyal to the Eagle Kings, they abandoned the horrible practice of wing cutting and they now instead lead the Immaculate Guards into battle. Seraphines sometimes set up secret cults in human lands. Their wings and beauty allow them to present themselves as angels and divine messengers. When becoming a prophet, a Seraphine will also receive improved mastery of Fire magic if she already has some knowledge of this path and she will bless her entire province with the supernatural protection of winter by starting to spread Cold scales."
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2332 -- Adventurer
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2458 -- Dragon Girl
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2459 -- Dragon Girl
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3127 -- Ker
#userestricteditem 8069
#end

#selectmonster 242 -- Hiereia (Arcoscephale Priestess)
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3198 -- Archousa (Arcoscephale Priestess)
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 3210 -- Lampad
#userestricteditem 8069
#twiceborn 3210
#end

#newmonster 7756
#copystats 3210 -- Lampad
#copyspr 3210
#name "Lampad"
#descr "Sacred to Delphanes, Lampades are nymphs of the Underworld and companions of the Mistress of Crossroads. They are joyful beings with a twisted sense of humor, that delight in dancing, revelry and hauntings. Their processions and dances light up the dark reaches of the Underworld and they bring brief moments of joy to the dreary dead. Their torches reveal the stygian paths and expose the shades of the Underworld. Lampades will never get lost when traveling on stygian paths and they can guide others through the Underworld."
#holy
#end

#selectmonster 1296 -- Erinya
#userestricteditem 8069
#twiceborn 1296
#end

#selectmonster 1297 -- Erinya
#userestricteditem 8069
#twiceborn 1297
#end

#selectmonster 1298 -- Erinya
#userestricteditem 8069
#twiceborn 1298
#end

#selectmonster 1436 -- Noppera-bo
#name "Noppera-bo"
#descr "The Noppera-bo is a strange apparition that appears as a comely young maiden dressed in pure white. When she gets close to her intended target, she reveals her true appearance and wipes off her face. The Noppera-bo is actually faceless and horrible to behold. The sight of her will make men turn and flee or become mad with fear. Noppera-bo use their powers to get close to important people and drive them mad or kill them."
#gcost 0
#userestricteditem 8069
#twiceborn 1436
#end

#selectmonster 1549
#name "Shuten-doji"
#descr "Shuten-doji are mortal vampires of Shinuyama. They appear as tall old men with fangs and claws, dressed in robes. Shuten-doji can produce enticing music with their flutes. They use this power to make visitors fall asleep so they can feast on their blood. Shuten-doji are feared by most of Shinuyama's wild spirits as well as by most of the rural populace of T'ien Ch'i and Jomon. In battle they use their enticing flutes to defend themselves from would-be attackers. Shuten-doji are not undead and cannot be banished by priests. They are lonely beings who cannot command to mundane armies, but their inhuman nature is such that they have authority over beings of the Underworld and will reawaken from their ghoulish slumber a year and a day after having been killed."
#gcost 0
#magicskill 5 1
#command -160
#sleepaura 30
#immortal
#reformtime 9
#end

#selectmonster 1908 -- Huli Jing (human form)
#name "Huli Jing"
#descr "Also called Kitsune by the rural Jomonese minorities, the Huli Jing is a fox spirit, a kami of the wild. It has the appearance of a silvery fox with many tails. It is magically powerful and able to take the appearance of a beautiful woman. The Huli Jing is a trickster and often whimsical or even mischievous in nature. In human guise they may play pranks on unsuspecting travelers, aid lowborn peasants to greatness or plot the rise or downfall of kingdoms. Huli Jing are stealthy and in human guise have the abilities of a spy and a seducer. All Huli Jing are powerful mages of Nature, but most also have other magical skills. In their animal form, they are particularly elusive and protected by a veil of invisibility."
#userestricteditem 8069
#twiceborn 1908
#seduce 12
#end

#selectmonster 1909 -- Huli Jing
#name "Huli Jing"
#descr "Also called Kitsune by the rural Jomonese minorities, the Huli Jing is a fox spirit, a kami of the wild. It has the appearance of a silvery fox with many tails. It is magically powerful and able to take the appearance of a beautiful woman. The Huli Jing is a trickster and often whimsical or even mischievous in nature. In human guise they may play pranks on unsuspecting travelers, aid lowborn peasants to greatness or plot the rise or downfall of kingdoms. Huli Jing are stealthy and in human guise have the abilities of a spy and a seducer. All Huli Jing are powerful mages of Nature, but most also have other magical skills. In their animal form, they are particularly elusive and protected by a veil of invisibility."
#userestricteditem 8069
#twiceborn 1909
#invisible
#end

#selectmonster 2058 -- Arel
#userestricteditem 8069
#twiceborn 2058
#hp 49
#end

#selectmonster 1741 -- Asrapa
#userestricteditem 8069
#end

#selectmonster 2071 -- Lilot
#name "Lilot"
#descr "The Lilin are the offspring of Lilith, a demoness of primeval times and the Mother of Demons. Lilin appear as winged women with the lower part of a hind. Their appearance is strangely alluring and they seduce and abduct men of weak morals. They are attuned to the powers of life and fertility and have weak skills in Nature magic. Regardless of their ancestry, they are of this world and can be summoned without the sacrifice of blood."
#userestricteditem 8069
#magicskill 6 1
#end

#selectmonster 811 -- Succubus
#userestricteditem 8069
#end

#selectmonster 2017 -- Qedesot
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2179 -- Sal-Me
#name "Sal-Me"
#descr "In the center of the First City lies an enormous temple ground. Here priests and sacred warriors are trained. The Sal-Me is a priestess and temple-consort at the House of Waters. Her most important role is as a vessel for the divine principle of fertility. In sacred marriage rites she blesses and brings fertility to the land. As a result, any province with friendly dominion and a Sal-Me will see its population increase by one hundred per month."
#userestricteditem 8069
#twiceborn 6675
#rpcost 1
#gcost 100
#hp 28
#end

#selectmonster 2182 -- Gala (Eridu)
#userestricteditem 8069
#twiceborn 6675
#rpcost 1
#gcost 75
#hp 28
#end

#selectmonster 2945 -- Gala (Akkad)
#name "Gala"
#descr "With the construction of the Great Temple of the Moon much changed, but some traditions remain. The dirges for the dead can still be heard in temples throughout the kingdom, but they now serve a different deity. The Gala is an elegist, a lamentation-priest grieving the untimely dead and the dying god. Her dirges and lamentations will open the gates to the Underworld and allow the imprisoned god to return to once more bring fertility and prosperity to the land of Akkad. When recalling a dead god the Gala counts as being two levels higher than her ordinary priest level."
#userestricteditem 8069
#twiceborn 6675
#hp 28
#gcost 75
#end

#selectmonster 2944 -- Nin
#name "Nin"
#descr "The Nin is an Enkidu lady of noble heritage trained as a priestess. Most Nin follow the old ways, but some of them study the magic of the Moon. Because of their high upbringing and education in the arts of language, the Nin are frequently sent in small delegations to other City States as diplomats. As such, any province with five or more Nin will see its chances for a new Akkadian City State to join the Awakening God doubled or more: tripled if there is no Misfortune scales in it, and quadrupled if its Luck scales are perfect."
#userestricteditem 8069
#twiceborn 6675
#hp 28
#gcost 75
#end

#selectmonster 2946 -- Naditu
#userestricteditem 8069
#twiceborn 6675
#hp 28
#gcost 70
#end

#selectmonster 2947 -- Ereshdingir
#name "Ereshdingir"
#descr "The Ereshdingir is a priestess of the Moon, second only to the Entu herself. Once there was but one Temple of the Moon with a single Entu and the Ereshdingir were rare, but now every city state has its own lunar temple, led by a different Entu under which several Ereshdingir operate. The Ereshdingir have much greater autonomy and authority than the Naditu and perform most of the city state's holy rites."
#hp 28
#gcost 190
#end

#selectmonster 2269 -- Entu (Eridu)
#name "Entu"
#descr "In the center of the First City lies an enormous temple ground. The Entu is a priestess-queen and consort of the Ensi. She is the highest ranking priestess of the sacred kingdom. The Entu's most important role is as a vessel for the divine principle of fertility. In the yearly ritual of the sacred marriage she is impregnated by the Ensi as the rain impregnates the earth. Together the sacred couple ensures the fertility and prosperity of Ur."
#userestricteditem 8069
#twiceborn 6675
#rpcost 3
#gcost 265
#hp 28
#end

#selectmonster 2949 -- Gudu (Akkad)
#hp 36
#gcost 95
#custommagic 1280 20
#end

#selectmonster 2948 -- Entu (Akkad)
#name "Entu"
#descr "The erection of the Great Temple of the Moon marked the beginning of a new era in the lands of the free. The influence of the prophetess and of her Entu of the Moon successors came to eclipse the Entu-queens of the First City in Akkad, and the Ensis of the newly founded cities turned to the Moon for advice. The sacred marriage between the Ensi and the Entu of the First City lost meaning save in Eridu itself, and astrological considerations replaced the fertility rites of old. The Entu of the Moon became the single most influential individual in the kingdom and now all of the Ensis heed her counsel. While Eridu retained its symbolic value for a time, by the time the schism occurred it had already lost much of its influence and the City of Gods had for all intents and purposes become the Sacred City in Akkad. Now, Eridu having rejected the Awakening God to cling to its old deities and traditions, it no longer bears any religious authority over the other city states. The survival of these archaisms, however, is also the sign of Eridu's lingering strength and of the danger it represents for Akkad."
#userestricteditem 8069
#twiceborn 6675
#hp 28
#gcost 275
#end

#newmonster 7445
#copyspr 2948
#copystats 2948
#addupkeep -275
#magicboost 8 2
#foreignshape 2948
#end

#selectmonster 3092 -- Kuliltu Queen
#name "Kuliltu Queen"
#descr "The Kulullu kingdom came into being when U'an brought civilization and culture to the depths. Kulullu society is in many ways organized as the Enkidu society of the First City, but since the kingdom came under the pressure from other underwater races, the centralized government crumbled. With the alliance with the Enkidus the Kulullus are trying to reestablish the ancient order and kings and queens once more lead the Kulullus. The Kuliltu Queen is what the Entu is to the Enkidus, a mage-priest queen. As is the case in Eridu, the Kulullu underwater kingdoms prosper if led by a royal couple; thus, any underwater fort with a temple, a Kuliltu Queen and a Kulullu King will generate double gold income."
#userestricteditem 8069
#twiceborn 3444
#hp 36
#custommagic 11008 100
#end

#selectmonster 3091 -- Kulullu Sage
#hp 39
#gcost 190
#researchbonus 12
#end

#selectmonster 1693 -- Mother of the Deep
#userestricteditem 8069
#twiceborn 3444
#hp 33
#gcost 95
#end

#selectmonster 1695 -- Basalt Queen
#name "Basalt Queen"
#descr "The Basalt City is ruled by the Basalt Queens and their consorts. The rulership is divided between the Priestess Queens and the Mage Kings, but the actual leadership of the emerging nation is a matter for the Basalt Queens. While the Basalt Kings sequester themselves, staring into the Dark Crystal at the bottom of the gorge in the center of the city, the young female spawn of the previous Queens slumber hundreds of years at a time in their hermetic chambers. After a thousand years they emerge mightier than ever to never sleep again, and in this manner do they unlock the strange powers that are theirs and mark them as full-fledged royalty. The Basalt Queens rarely concern themselves with matters outside the Basalt City and few have ever been seen by non-Atlantians. Religious matters outside the Basalt City are left to the Mothers of the Deep while their Queens only emerge to decide the fate of empires. The political and sacred authority of Basalt Queens among Atlantians is such that each queen can single-handedly command up to eighty bodyguards, usually a true armada of stalwart Living Pillar royal guards. Ever-hungry, the voracious queen-mothers of the deep Atlantians are often gifted with the corpses of their slain enemies, which they then devour to fuel their terrifying might."
#userestricteditem 8069
#twiceborn 3444
#hp 72
#mor 30
#gcost 375
#spellsinger
#warning 75
#voidsanity 10
#mr 22
#spiritsight
#darkpower 3
#startheroab 100
#corpseeater 7
#deadhp 1
#magicskill 3 3
#magicskill 5 3
#magicboost 3 -3
#magicboost 5 -3
#twiceborn 7702
#maxage 2000
#startage 800
#addrandomage 500
#end

#selectmonster 2248 -- Sister
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2249 -- Nun
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 2250 -- Abbess
#userestricteditem 8069
#twiceborn 6675
#end

#selectmonster 1322 -- Nagini
#userestricteditem 8069
#twiceborn 1322
#end

#selectmonster 1325 -- Nagini
#userestricteditem 8069
#twiceborn 1325
#end

#selectmonster 1474 -- Golem Crafter
#name "Golem Crafter"
#descr "Although contact between men and Pale Ones has been rare until recently, with the Awakening of the God and the project of conquest of the sunlit world they have become more frequent. Small human populations living near the multiple entrances to the vast subterranean networks of Agartha have been subjugated and in some cases even were convinced by the Ancient Ones' greatness that it was only justice. When the leaders and diplomats of the most loyal human subjects of the Pale Ones first were invited to enter the caves of Agartha, they were awed by the great statues adorning the opulent halls of the Pale Ones and they understood the true glory and power of their blessed masters. The Pale Ones became worshipped along with their great statues, and when the Oracles accepted human veneration, mortal mages formed a cult around them. The Golem Crafters are the leaders of the cult and now also of Agartha's small human communities. They guard those of the secrets and magic wonders of Old Agartha that the Oracles allowed them to bring, defend and contemplate in their temples on the surface, and they perform weak animation rituals as a pious imitation of the sacred power of the Ancients."
#rpcost 3
#rpcost 50
#patrolbonus 5
#batstartsum1 1497 -- Attentive Statue
#end

#selectmonster 1497 -- Attentive Statue
#name "Attentive Statue"
#descr "To the human communities that worship the Pale Ones, the ancient statues of Old Agartha are sacred and rare. Human ones are not treated with the same respect, but as the products of the imitation of the Pale Ones' noble art they are quite common. Enlivened by the Golem Crafters, these statues are placed near gates and temples to stand vigil and wait for trespassers. When the Golem Crafters are called by the Ancient Lords to serve them in war, their stone creations leave the guard of the Agarthan artifacts of old and march to battle along with the Pale Ones and their own sentinels of greater value."
#hp 16
#end

#selectmonster 2493 -- Olm Sage
#name "Olm Sage"
#descr "Since a few centuries ago Deepthought allied himself with the Oracles more Olms gifted with magical abilities have emerged to lend their aid to Agartha. They are skilled mages, but lesser in power than Deepthought. They are considered sacred to the Pale Ones, although they are not trained as priests. Olm Sages have some oracular powers similar to that of the earth readers, but they draw their insights from other sources. As they are allies of Agartha and benefit of a large degree of independence, Olms take care of their own expenses and do not cost any upkeep."
#addupkeep -155
#gcost 155
#voidsanity 10
#end

#selectmonster 2492 -- Great Olm
#name "Great Olm"
#descr "Since time immemorial pale amphibians with external gills have lived in the watery caverns of the deeper earth. Some claim that the Olms are an earlier form of the Pale Ones. When Olms grow old they grow large and wise and whatever their origin the Pale Ones of Agartha revere them and consider them sacred. For ages the Olms have lived apart from the Pale Ones, curiously observing the emerging civilization from their underground streams and ponds. But this changed a few centuries ago when one of their numbers befriended Emberstream, an Agarthan Oracle of Subterranean Waters. Deepthought, oldest and wisest among Olms had previously only been encountered on rare occasions. When Deepthought allied itself with the Pale Ones, so did its kin, and now the Olms of the deeper earth and their Sages aid the Oracles of Agartha. Olms communicate wordlessly and can project images and emotions to other sentient beings. This power can also be used to overwhelm and harm an enemy. As they are allies of Agartha and benefit of a large degree of independence, Olms take care of their own expenses and do not cost any upkeep."
#addupkeep -50
#voidsanity 5
#end

#selectmonster 1470 -- Ancient Lord
#hp 66
#end

#selectmonster 2506 -- Ancient Lord (MA)
#hp 66
#end

#selectmonster 1457 -- W Oracle
#montag 4150
#userestricteditem 8069
#hp 60
#end

#selectmonster 1459 -- MA Oracle
#montag 4150
#hp 60
#end

#selectmonster 1467 -- F Oracle
#montag 4150
#hp 60
#end

#selectmonster 1468 -- D Oracle
#montag 4150
#hp 60
#end

#selectmonster 2491 -- Engraver
#fixforgebonus 1
#hp 22
#gcost 70
#end

#selectmonster 1460 -- Earth Reader 
#gcost 185
#hp 22
#end

#selectmonster 1463 -- Pale One Commander
#gcost 35
#hp 27
#end

#selectmonster 1466 -- Pale One Scout
#gcost 20
#hp 25
#end

#newmonster 7210
#copystats 2331 -- Pilgrim
#spr1 "Hellenika/TheIlluminate1.tga"
#spr2 "Hellenika/TheIlluminate2.tga"
#name "Immaculate Wanderer"
#descr "No one knows for sure who the Immaculate Wanderer is. Some claim that he is a prophet, one of many in these lands, maybe even a messiah. Others profess that he used to be a leper king, who was miraculously healed and abandoned his crown when he found his holy blade or spiritual enlightenment. Others yet postulate that he is an eternal vagabond, older that any surviving mortal kingdom, up until now blessed or cursed with the inability to die, who finally stopped his great journey when the Angels gave him a new purpose after he reached the holy city. Some even believe that he was the shepherd-patriarch of Bethel She'em before the angels came, and that he is the one to blame for their summoning. And many more posit that he is nothing but a beggar and a madman, who got lucky and now serves the Ennearchy of his own accord. Regardless of the truth, the Immaculate Wanderer travels no longer. This extremely zealous, humble and charismatic individual seems to be spending his whole time within the holy city, praying, preaching and venerating those that he calls 'saviors'. He also doesn't seem to possess any earthly belonging, except for a wondrous blade which he uses as a symbol of his sacred mission in this world, and which he seems extremely eager to brandish against the enemies of the faith, should the opportunity arise in the capital. Until then, he certainly won't be of great use to the Litany of Cinders, but for the time being its celestial envoys do not seem to mind and let him freely pursue his actions. In fact, in his extreme fanaticism he might very well end up serving some purpose, whether by design or by accident..."
#fixedname "Dahud"
#unique
#mapmove 0
#clearmagic
#clearweapons
#weapon 92
#startitem 859
#goodleader
#goodmagicleader
#startheroab 100
#gcost 0
#mor 16
#end

#newmonster 6608
#copyspr 2331
#copystats 2331 -- Pilgrim
#name "Pilgrim"
#descr "Particularly common in the arid mountains of Bethel She'em, Pilgrims are men of humble condition and extreme devotion. While some are simple shepherds who have witnessed the glory of the Lord's angels or found some ancient wisdom in the desert, others come from very far away to visit the lands of the next True God. The Pilgrim will of course serve the pretender to the best of his limited abilities and, should he be appointed as a prophet, he will receive divine inspiration in the form of even further increased priestly skills after having preached for a month in lands controlled by rival pretenders. Once this is done, as soon as he starts preaching in the capital, he will emulate the God by sacrificing himself and be raptured to Heaven by His angels. As a result, he will die immediately but many magical gems will be gathered from his body's holy relics, and the following month even more gems will be collected in each temple of Bethel She'em that is located in a fully controlled province with friendly dominion. Unlike other priests of non-magical essence, pilgrims will not be feebleminded by the rapturous glory of Bethel She'em's God, and their ascetic practices let them perform their duties at half their normal upkeep cost."
#prophetshape 4503
#wastesurvival
#mountainsurvival
#gcost 100
#addupkeep -50
#rpcost 2
#fixedresearch 2
#magicstudy 1
#resources 1
#drainimmune
#magiccommand 1
#nametype 148
#end

#newmonster 6503
#copyspr 2331
#copystats 2331
#name "Pilgrim"
#descr "Particularly common in the arid mountains of Bethel She'em, Pilgrims are men of humble condition and extreme devotion. While some are simple shepherds who have witnessed the glory of the Lord's angels or found some ancient wisdom in the desert, others come from very far away to visit the lands of the next True God. The Pilgrim will of course serve the pretender to the best of his limited abilities and, should he be appointed as a prophet, he will receive divine inspiration in the form of even further increased priestly skills after having preached for a month in lands controlled by rival pretenders. Once this is done, as soon as he starts preaching in the capital, he will emulate the God by sacrificing himself and be raptured to Heaven by His angels. As a result, he will die immediately but many magical gems will be gathered from his body's holy relics, and the following month even more gems will be collected in each temple of Bethel She'em that is located in a fully controlled province with friendly dominion. Unlike other priests of non-magical essence, pilgrims will not be feebleminded by the rapturous glory of Bethel She'em's God, and their ascetic practices let them perform their duties at half their normal upkeep cost."
#wastesurvival
#mountainsurvival
#magicboost 8 -1
#fixedresearch 2
#magicstudy 1
#resources 1
#drainimmune
#nowish
#magiccommand 1
#nametype 148
#end

#newmonster 6586
#copyspr 2331
#copystats 2331
#name "Pilgrim"
#descr "Particularly common in the arid mountains of Bethel She'em, Pilgrims are men of humble condition and extreme devotion. While some are simple shepherds who have witnessed the glory of the Lord's angels or found some ancient wisdom in the desert, others come from very far away to visit the lands of the next True God. The Pilgrim will of course serve the pretender to the best of his limited abilities and, should he be appointed as a prophet, he will receive divine inspiration in the form of even further increased priestly skills after having preached for a month in lands controlled by rival pretenders. Once this is done, as soon as he starts preaching in the capital, he will emulate the God by sacrificing himself and be raptured to Heaven by His angels. As a result, he will die immediately but many magical gems will be gathered from his body's holy relics, and the following month even more gems will be collected in each temple of Bethel She'em that is located in a fully controlled province with friendly dominion. Unlike other priests of non-magical essence, pilgrims will not be feebleminded by the rapturous glory of Bethel She'em's God, and their ascetic practices let them perform their duties at half their normal upkeep cost."
#wastesurvival
#mountainsurvival
#magicboost 8 1
#fixedresearch 2
#magicstudy 1
#resources 1
#drainimmune
#nowish
#magiccommand 1
#nametype 148
#end

#newmonster 6532
#copyspr 2331
#copystats 2331 -- Pilgrim
#end

#selectmonster 2331 -- Pilgrim
#prophetshape 4532
#end

#newmonster 6517
#spr1 "Hellenika/Tetragrammaton1.tga"
#spr2 "Hellenika/Tetragrammaton2.tga"
#copystats 1025 -- Divine Glyph
#name "Tetragrammaton"
#descr "Taking the shape of mystical diagrams constantly ablaze with supernatural fire and blinding light, Tetragrammatons are direct manifestations of Bethel She'em's God and allow the Lord to interact with material reality even whenever He has exiled Himself from it through Tzimtzum. Each Tetragrammaton is composed of four different symbols which together can be read in multiple ways, and each of these combinations is one of the seventy-two Divine Names of the God, the unbearable Shem'ham Phorash. Even though one Tetragrammaton contains only a very limited portion of the God's power, its existence is already in and of itself a miracle worthy of worship, for even simple Harbingers can summon their Lord simply by etching down one of His names. Then, by sole virtue of its profound metaphysical significance, the Tetragrammaton shall spontaneously light up and gain life, speech and influence, thus acting as a mighty beacon for the coming of the Ennearchy into this world.
Although Tetragrammatons are completely immobile, cannot be teleported even with the help of magic and can be destroyed relatively easily in battle, they still are very important instruments of Bethel She'em's glory. Indeed, each month, every province with a Tetragrammaton and a temple will attract at least one Angel, more appearing in strong dominion and Order scales. The chance for additional angels to descend is equal to twice ten percent for each level of dominion strength and of Order above neutral scales, culminating at a total of seven angels per month on average under perfect conditions. In addition, every province with a Tetragrammaton, a temple, a laboratory and friendly dominion has one percent chance per level of dominion strength to attract a Harbinger every month. Finally, every province with a Tetragrammaton, a temple, a fort, maximal Order scales and friendly dominion also has a one percent chance per level of dominion strength to attract a Principality every month."
#nametype 139
#homerealm 0
#gcost 0
#size 4
#hp 32
#clearmagic
#magicskill 0 1
#magicskill 4 1
#magicskill 8 1
#custommagic 2176 100
#custommagic 2176 20
#unteleportable
#noleader
#magiccommand -100
#miscshape
#itemslots 1 -- nothing
#woundfend 99
#twiceborn 6517
#heal
#researchbonus -6
#end

-- 2057 -- Hashmal

#newmonster 6620
#copyspr 464
#copystats 464 -- Harbinger
#name "Harbinger"
#descr "Harbingers, or Archangels, are holy apparitions that occupy the second to last position in Bethel She'em's Ennearchy. Even though they are relatively weak when compared to other angels, they still are both magically and physically very powerful by human standards. From the angels of the lowest rank, which only very rarely are Transubstantiated to become Harbingers but much more frequently receive the intermediate promotion and honor of receiving a name and a heavenly horn, they retain this wondrous weapon which destroys undead beings and mortal flesh as well as their winged humanoid shape and radiant aura; but unlike them, they also have high enough sanctity and might to act as lowly officers, priests and mages. They are generally tasked with leading the angelic choirs in worship as well as in war, announcing dramatically important events to mortals, installing permanent outposts in prevision for the coming of higher entities and assisting them in the performing of holy and arcane rituals." -- Michael/Israfel/Raphael
#nametype 139
#clearmagic
#okleader
#magiccommand -25
#inspirational 1
#magicskill 1 2
#magicskill 8 1
#custommagic 2432 100
#custommagic 2176 20
#end

#newmonster 7312
#copystats 464 -- Harbinger
#spr1 "Hellenika/MessengerOfSolitude1.tga"
#spr2 "Hellenika/MessengerOfSolitude2.tga"
#name "Messenger of Solitude"
#descr "Harbingers, or Archangels, are holy apparitions that occupy the second to last position in Bethel She'em's Ennearchy. Even though they are relatively weak when compared to other angels, they still are both magically and physically very powerful by human standards. From the angels of the lowest rank, which only very rarely are Transubstantiated to become Harbingers but much more frequently receive the intermediate promotion and honor of receiving a name and a heavenly horn, they retain this wondrous weapon which destroys undead beings and mortal flesh as well as their winged humanoid shape and radiant aura; but unlike them, they also have high enough sanctity and might to act as lowly officers, priests and mages. They are generally tasked with leading the angelic choirs in worship as well as in war, announcing dramatically important events to mortals, installing permanent outposts in prevision for the coming of higher entities and assisting them in the performing of holy and arcane rituals." -- Michael/Israfel/Raphael
#nametype 139
#clearmagic
#okleader
#magiccommand -25
#inspirational 1
#magicskill 1 2
#magicskill 8 1
#hp 9
#end

#newmonster 6619
#copyspr 465
#copystats 465 -- Arch Angel
#name "Virtue"
#descr "Virtues, or Powers, are angelic paragons, living allegories that serve the Litany of Cinders as beacons of light and purity for all lower celestial beings to follow. Cloaked in blazing fires of kindness and equity, they are leaders of nearly unparalleled skills within the Ennearchy, only equaled in holy charisma by the supreme Seraphs and Tetramorphs. They are also divine warriors that wield solar flames both through arcane potency and their resplendant blade, a consecrated sword known as a Flambeau, which destroys any demonic being it touches. Taking the idealized shape of a feminine Harbinger of unimaginable beauty and absolute chastity, they dazzle mortals with the graceful perfection of their physical form as well as with the ecstatic sanctity of their compassionate yet inflexible words and actions. As the metaphysical embodiments of victorious rectitude, gentleness and abnegation, they are trusted to always prevail against corruption and are frequently sent to destroy evil threats before they grow to require the intervention of higher entities. Along with Taxiarchs, who share a similar rank and power level with them, they command the angelic hosts to war and ensure that the Will of the God is done on Earth and in Heaven alike." -- Raphael/Michael
#nametype 139
#female
#clearmagic
#combatcaster
#goodleader
#magicskill 0 4
#magicskill 8 1
#magicboost 8 1
#end

#newmonster 7211
#copyspr 2051
#copystats 2051 -- Ophan
#name "Throne" -- Zaphkiel/Tzaphqiel
#descr "Thrones, or Wheels, are angels of superior dignity, only surpassed in the Ennearchy by Seraphs and Tetramorphs. Like Dominations, who share with them a similar rank and power level, they abandoned the humanoid shape of their inferiors and instead took on the incomprehensible form of an eldritch celestial entity, in this particular case as a brilliance covered by four wings and surrounded by a blaze like that of the sun, that when unfolded will reveal a wheel intersecting another wheel of gleaming brass, the rim of which is covered by eyes of sparkling chrysolite - a shape more fitting of their primary function, which doesn't require communication with earthly beings. As a result, their mere presence is unbearable to most mortals, and they are only sent to meet them when the goal clearly is to destroy them and that all else failed to do so, the rest of the time remaining in the Celestial Spheres to shine with eternal light, sing with perfect vibrations and guard the Seat of Heaven against metaphysical invaders. Unfathomable and otherworldly, Thrones bear witness to the splendor of the Awakening God and uncompromisingly serve the Litany of Cinders as sentient, magical weapons of incredible might. These lifeless, ethereal entities are so powerful Air mages that they start every battle with three temporary Air gems, and the tempest of fire that radiates from their perfectly serene body at all times is strong enough to rend and tear apart nearly any mortal it touches in addition to shielding them against storms and greatly helping when besieging enemy forts. Finally, their innumerable eyes let them patrol with unmatched efficiency and their immense wisdom lets them advance Bethel She'em's research at great speeds. Ultimately, one of the Thrones is expected to undergo Transsubstantiation and become the Throne of Thrones by merging with a mighty emerald artifact: the Chrysolithops."
#nametype 139
#clearmagic
#magicskill 1 4
#magicskill 8 1
#magicboost 8 1
#tmpairgems 3
#stormimmune
#bonusspells 1
#miscshape
#noleader
#magiccommand -20
#researchbonus 12
#siegebonus 50
#itemslots 61440 -- 4 misc
#userestricteditem 8086
#reinvigoration 4
#unsurr 12
#end

#selectmonster 2051 -- Ophan
#unsurr 12
#stormimmune
#bonusspells 1
#reinvigoration 4
#siegebonus 50
#itemslots 61440 -- 4 misc
#userestricteditem 8086
#end

#newmonster 6607
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6587
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 7212
#copystats 1368 -- Seraph
#spr1 "Hellenika/Solari_1.tga"
#spr2 "Hellenika/Solari_2.tga"
#name "Solar"
#descr "A Solar is a metaphysical being of incomprehensible might sent by the Sun itself to burn the land, dry the ocean and blind mortal minds with its triumphant light. Angels of fire, light and destruction, Solars appear as golden winged fireballs that radiate hallucinating heat and leave only ashes and wastes in their wake. Worshipped by the Garnet Amazons and especially the Disciples of the Sun as the lords of the sands, the guardian spirits of the lands of Zun and the bringers of the end for mortals, they are called Ruby Eyes of the Desert and idolized in their temples in the form of a ruby eye adorned with a thousand wings of gold. When sent by the God to shine over an enemy province, Solars behave as stealthy commanders that spread heat, dominion and insanity; but they are also extremely powerful mage-priests and incredibly dangerous opponents in battle. Should they be killed, they'd explode in a vast deflagration of light and fire."
#hp 45
#mr 20
#size 4
#voidsanity 20
#mapmove 36
#blind
#eyes 0
#spiritsight
#heat 12
#mindslime 15
#stealthy
#miscshape
#nametype 139
#decscale 2
#spreaddom 1
#uwdamage 100
#insanify 100
#invulnerable 25
#clearmagic
#magicskill 0 5
#magicskill 8 5
#clearweapons
#weapon 229
#weapon 229
#weapon 229
#shockres 0
#fireres 25
#deathfire 50
#localsun
#end

#selectmonster 1368 -- Seraph
#userestricteditem 8084
#end

#newmonster 6535
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6536
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6537
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6538
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6539
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6540
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6541
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 6542
#copyspr 1368
#copystats 1368 -- Seraph -- Seraphiel
#name "Seraph"
#descr "Seraphs, or Empyreans, are heavenly attendants of the Celestial Sphere and, along with Tetramorphs, the highest servants of the Ennearchy. They assist the emerging God as he chose to claim this world as his and proclaim His glory. They are surrounded by a divine splendor that must be shielded lest it strike the world with unbearable might. The Seraph has three pairs of wings. The first pair covers the face of the being, the second pair covers its naked feet and the third pair brings the angelic apparition into the air. Anyone striking the Seraph will in turn be struck by awe, fire and blindness. The Seraphim have vast magical and priestly powers. Although Bethel She'em can call more Seraphs to this world through the Sephira of Kingship, only the Heavenly Host and Wish rituals can bring above nine the number of Seraphs currently following the Litany of Cinders in the material realm, and performing the Sephira of Kingship while nine or more Seraphs are under Bethel She'em's control will instead summon a weaker angel: a Principality, a Virtue, an Authority, a Throne, a Domination or a Cherub."
#userestricteditem 8084
#end

#newmonster 7213
#copyspr 1369
#name "Authority" -- Kamael/Gabriel
#descr "Authorities, or Judgements, are celestial retributors, bringers of divine punishment and bearers of mystical secrets. Placed above Virtues and Taxiarchs but below Thrones and Dominations in the angelological Ennearchy, they serve as intermediates between superior and lower angels and as spiritual leaders of the latter in their great crusade in the earthly realms. Dressed in robes smeared with the blood of unrepentant sinners, they return to all blasphemers and persecutors the agony they inflicted upon sanctified martyrs who sacrificed themselves in the name of the Absolute. As Scourges of the Lord, Chastisers of the Unlawful and Destroyers of False Prophets, they will therefore punish for his sins anyone who attempts to strike them by forcing him to take the damage himself. Authorities are utterly silent and, although they bear the greatest priestly powers in Bethel She'em along with the supreme Seraphs and Tetramorphs, their sacred vows prevent them from ever uttering a single word and therefore from commanding armies. They are instruments of meditation and punishment and their functions are those of prayer and retribution, not leadership; in fact, this truth is so fundamental that the most exemplary among them may even be Transubstantiated into dark Angels of Death and Messengers of the Apocalypse by the Sephira of Severity, thus retrieving speech only to end life by the sheer meaning of their whispers and verdicts."
#gcost 0
#nametype 139
#hp 49
#size 4
#prot 0
#mr 18
#mor 30
#str 17
#att 14
#def 14
#prec 15
#ap 16
#mapmove 32
#enc 1
#maxage 1000
#weapon 402
#damagerev 4
#magicskill 8 4
#inquisitor
#noleader
#invulnerable 20
#fear 5
#awe 5
#fireres 5
#shockres 5
#flying
#neednoteat
#spiritsight
#magicskill 5 5
#magicboost 5 -9
#combatcaster
#magicbeing
#end

#newmonster 7214
#spr1 "./Hellenika/DeathAngel1.tga"
#spr2 "./Hellenika/DeathAngel2.tga"
#name "Angel of Death" -- Kamael/Gabriel
#descr "Authorities, or Judgements, are celestial retributors, bringers of divine punishment and bearers of mystical secrets. Placed above Virtues and Taxiarchs but below Thrones and Dominations in the angelological Ennearchy, they serve as intermediates between superior and lower angels and as spiritual leaders of the latter in their great crusade in the earthly realms. Dressed in robes smeared with the blood of unrepentant sinners, they return to all blasphemers and persecutors the agony they inflicted upon sanctified martyrs who sacrificed themselves in the name of the Absolute. As Scourges of the Lord, Chastisers of the Unlawful and Destroyers of False Prophets, they will therefore punish for his sins anyone who attempts to strike them by forcing him to take the damage himself. Authorities are utterly silent and, although they bear the greatest priestly powers in Bethel She'em along with the supreme Seraphs and Tetramorphs, their sacred vows prevent them from ever uttering a single word and therefore from commanding armies. They are instruments of meditation and punishment and their functions are those of prayer and retribution, not leadership; in fact, this truth is so fundamental that the most exemplary among them may even be Transubstantiated into dark Angels of Death and Messengers of the Apocalypse by the Sephira of Severity, thus retrieving speech only to end life by the sheer meaning of their whispers and verdicts."
#gcost 0
#nametype 139
#hp 49
#size 4
#prot 0
#mr 18
#mor 30
#str 17
#att 14
#def 14
#prec 15
#ap 16
#mapmove 32
#enc 1
#maxage 1000
#weapon 286
#weapon 1217
#damagerev 4
#magicskill 8 4
#inquisitor
#noleader
#invulnerable 20
#fear 5
#awe 5
#fireres 5
#shockres 5
#flying
#neednoteat
#spiritsight
#magicskill 5 4
#assassin
#patience 3
#stealthy 20
#leper 10
#diseasecloud 10
#diseaseres 100
#combatcaster
#deathrange 2
#twiceborn 6549
#montag 4111
#magicbeing
#end

#newmonster 6549
#spr1 "./Hellenika/DeathAngel1.tga"
#spr2 "./Hellenika/DeathAngel2.tga"
#name "Angel of Death" -- Kamael/Gabriel
#descr "Authorities, or Judgements, are celestial retributors, bringers of divine punishment and bearers of mystical secrets. Placed above Virtues and Taxiarchs but below Thrones and Dominations in the angelological Ennearchy, they serve as intermediates between superior and lower angels and as spiritual leaders of the latter in their great crusade in the earthly realms. Dressed in robes smeared with the blood of unrepentant sinners, they return to all blasphemers and persecutors the agony they inflicted upon sanctified martyrs who sacrificed themselves in the name of the Absolute. As Scourges of the Lord, Chastisers of the Unlawful and Destroyers of False Prophets, they will therefore punish for his sins anyone who attempts to strike them by forcing him to take the damage himself. Authorities are utterly silent and, although they bear the greatest priestly powers in Bethel She'em along with the supreme Seraphs and Tetramorphs, their sacred vows prevent them from ever uttering a single word and therefore from commanding armies. They are instruments of meditation and punishment and their functions are those of prayer and retribution, not leadership; in fact, this truth is so fundamental that the most exemplary among them may even be Transubstantiated into dark Angels of Death and Messengers of the Apocalypse by the Sephira of Severity, thus retrieving speech only to end life by the sheer meaning of their whispers and verdicts."
#gcost 0
#nametype 139
#hp 49
#size 4
#prot 0
#mr 18
#mor 30
#str 17
#att 14
#def 14
#prec 15
#ap 16
#mapmove 32
#enc 1
#maxage 1000
#weapon 286
#weapon 402
#damagerev 1
#magicskill 8 4
#inquisitor
#noleader
#invulnerable 20
#fear 5
#awe 5
#fireres 5
#shockres 5
#flying
#neednoteat
#spiritsight
#magicskill 5 4
#assassin
#patience 3
#stealthy 20
#leper 10
#diseasecloud 10
#diseaseres 100
#combatcaster
#deathrange 2
#twiceborn 6549
#montag 4111
#magicbeing
#end

#newmonster 7215
#spr1 "Hellenika/MiniDomination1.tga"
#name "Singing Diamond"
#descr "Like the higher Tetramorphs, Dominations are so powerful beings that they cannot entirely manifest in the material realm. Instead, Dominations can only project a small part of their body in this reality. In fact, according to a popular conjecture among philosophers and mathematicians, they are dwellers of higher spatial dimensions, and the entity that can be seen and touched by mortals is but some kind of tridimensional section or shadow of the Domination's true form, which cannot materialize in any fuller way. This at the very least explains why the geometrical structure of Dominations seems to be able to change so widely all the while being so impervious to damage, as well as how these creatures can teleport across the world so easily. As a result, scholars believe they understand why Dominations are followed by four singing diamonds at all times: these actually are dimensional reflections of their own self, incomplete manifestations of other parts of their inaccessibl