#modname "MA Nation: Pankot - Temple of Doom"
#icon "./ma_pankot/banner.png"
#description "Adds MA Pankot, based on Indiana Jones and the Temple of Doom"
#version 1.1


----- v1.11 ----
-- FIX Kryta Doll was glamour istead of blood
-- TWEAK morale 50 does not work with blood of Kali, item now makes wearer go berserk until better solution is found
-- TWEAK Giant vampire bats lost magicbeing

----- v1.1 ------
-- Changed monster IDs 7900 -> 10400  to prevent conflict with Mormacil Mod Nations
-- Fixed (hopefully) all grammar errors 
-- FIX Maharaja trubute events could happen if Maharaja is in a conquered capital (not Pankot itself)
-- TWEAK Start Army 15 Militia, 10 Warriors -> 25 Militia, 15 Warriors

----- v1.0 DOM 6 Release ----
-- All sprites converted to png
-- TWEAK "Giant Vampire Bat" enc 2 -> 3, mor 11 -> 10
-- TWEAK "Thuggee Militia" gained militia stats and cost
-- TWEAK "Thuggee Warrior" stealth 45 -> 40, gcost 15 -> 11, rpcost 8 
-- TWEAK "Thuggee Poison Archer" stealth 45 -> 40, gcost 17 -> 14, rpcost 14
-- TWEAK "Palace Guard" hp 12->13, mr 11->10, mor 14->13, str 12 -> 11, att 13->12, def 13->12, gcost 19 -> 17, rpcost 25, 
-- TWEAK "Trained Elephant" changed to the new mount system, gcost 80 -> 70, rcost 15->11, looses chaos rec
-- TWEAK "Kali Ma Cultist" become mindless, lose berserk, bless berserk and stealth, gcost 15->11, rpcost 9 
-- TWEAK "Blood Drinker" mr 15->13, gcost 22->20, rpcost 22
-- TWEAK "Child Slave" mr 14->10, att 10->6, def 13->7, prec 11->10, startage 8, cleared extra supply usage
-- TWEAK "Child Slave" mr 14->10, att 10->6, def 13->7, prec 11->10, startage 8, cleared extra supply usage and stealth
-- TWEAK "Thuggee Assassin" hp 13 ->10, mr 13->11 att 12->13, def 12->13, prec 12->13, gcost 60->85
-- TWEAK "Emissary" mr 12->11, str 11->9, mor 10->9 gcost 60->80
-- TWEAK "Thuggee Commander" str 12->11, att 12->11, def 12->11, enc 2->3, gcost 45 -> 55 
-- TWEAK "Thuggee Slaver" stats inline with commander, gainedd +50 command, taskmaster 3, inspirational -1
-- TWEAK "Raja" adapted to new mount system, gcost 280 -> 410, rcost 10->30
-- TWEAK "Acolyte of Blood" hp 13->10, gcost 150 -> 230, gained poorleader and poorundeadleader
-- TWEAK "Acolyte of Sacrifice" hp 13->10, lost one +1FE random, gained poorleader and okundeadleader
-- TWEAK "High Priest" hp 13->15, str 11->13, gcost 320->470, rpcost 3->4, gained adeptsac 1 and 50 undead/demon leadership
-- TWEAK "Ascetic" gcost 80 -> 110
-- TWEAK "Avatar of Kali Ma" gained experleader and expertundeadleader, 50% chance of getting blood magic boosted and a boost in priest level
-- TWEAK "Sleeping High Priest" gained new sprite, twice as likely to happen (montagweight 2), gained undead stats (poison and cold res, need not eat etc ...)
-- TWEAK "Deposed Raksharaja" multihero gains +1 Glamour, stealth 70->80
-- TWEAK "Mola Ram" hp 16 ->25, str 12->15, def 12->13, att 12->13, prec 11->12, good undead leader -> expert 
-- TWEAK "Maharaksharasi" gained mace weapon, #glamour, str 21->20, att 13->12, def 13->12, enc 2->3, mapmove 4->16, stealth 45 -> 80, A2D2N2B3H2 -> D1N2G3B2H2
-- TWEAK "Indiana Jones" enc 2->3, stealth 45 -> 65
-- TWEAK "Chattar Lal" enc 2->3
-- TWEAK "Kryta Doll" item B1 -> B2 autospell "Paralyze" -> spell "Paralyze"
-- TWEAK "High Priest" and "Mola Ram" lost access to twiceborn spell.
-- TWEAK "Sacrifice to Kali Ma" spell removed. Now slaves need to be blood sacrificed in the capital to keep the pit of fire not turning into pit of death after turn 5.
-- TWEAK Maharaja tribute events - the Maharaja needs to be present in the capital for them to happen
-- TWEAK Nation looses 2 blood bless points, gains turmoil limit +1 and 1 bonus bless point
-- CONTENT Added Future sites with summons, heroes and sankara stones


----- v0.2 ----

-- TWEAK - added nametypes to commanders.

-- FIX - Palace guard now has castle defender 1 as intended

-- FIX - Trained Elephant now has properly defined rpcost 
-- FIX - Chatar Lal hero now properly increases PD
-- FIX - Sankara Stones now pierce resistant as intended 
-- FIX - Serpent Kryss now gets national rebate as intended
-- FIX - Blood of Kali item now has description
-- FIX - 5 Palankashas, 10 Ansaras and 10 Asarapas to actually summon appropriate number of monsters

-- TODO futuresites

-- FUTURE WORK:
-- Vetala and Gana to human form
-- better story events for Sankara stones


------ Weapons -----------------------------------------------------------

#newweapon 1920
#copyweapon 256 -kryss
#name "Poisoned Kryss"
#secondaryeffect 50 --weak poison
#end

#newweapon 1921
#copyweapon 11 --greatsword
#name "Serpent Greatsword"
#dmg 10
#secondaryeffect 50 --weak poison
#end



------ Armor --------------------------------------------


-------- UNITS ------------------------------------------

-- Those are not birds...
#newmonster 10400
#copyspr 1357 -- beast bat 
#name "Giant Vampire Bat"
#descr "In the caves and jungle around Pankot live giant vampire bats. They suck the blood of animals and humans, however they cannot drain life like real vampires. Their fangs however possess paralyzing poison so that the victim is helpless while the bat feeds. Their affinity for blood made them controllable by the blood mages of Pankot, and they are often used to harass unsuspecting enemy back lines."
#weapon 251 --venomous fangs
#hp 13
#size 3
#prot 2
#mr 9
#mor 10
#str 10
#att 10
#def 12
#prec 4
#ap 3
#mapmove 28
#enc 3
#animal
#flying
#forestsurvival
#darkvision 100
#blind
--#magicbeing
#gcost 10
#rcost 1
#rpcost 22
#end

-- Everyone needs an arrow and lance catcher 
#newmonster 10401
#copystats 31 -- militia
#spr1 "./ma_pankot/thugee_spear.png"
#spr2 "./ma_pankot/thugee_spear_2.png"
#name "Thuggee Militia"
#descr "Thuggee Militia are the trainees and initiates of the Cult of Kali-Ma. Although bandits, robbers and mercenaries join the cult, most of the ones joining are peasants requiring training. During their training they are used as light infantry, carrying the simplest instrument of war, a shield and a spear. They are mostly used to protect Thuggee infrastructure and provinces, however they are sometimes used in armies, mostly as meat shields on the front lines. Should they survive the military campaign they will gain enough experience, together with their training, to become fully fledged Thuggee Warriors."
#cleararmor
#armor 158 --robes
#armor 249 --cloth headpiece
#armor 2 --shield
#xpshape 20
#end

-- Hope they fare better than in the movie...
#newmonster 10402
#copystats 3332 -- nabaean desert warrior
#spr1 "./ma_pankot/thugee_warrior.png"
#spr2 "./ma_pankot/thugee_warrior_2.png"
#name "Thuggee Warrior"
#descr "The Thuggees rely on guerilla tactics and light infantry in battle. The Thuggee Warriors are well trained in close combat and wield a scimitar and a dagger. In addition each one is a trained archer and they carry short bows to harass the enemy before closing in. Thuggee Warriors are stealthy and make good raiders and pillagers. Though they raid villages, they are said to protect pilgrims and ascetics, therefore the general population is somewhat tolerant and Thuggees don't cause unrest."
#clearweapons
#weapon 746 -- scimitar
#weapon 9 -- dagger
#weapon 23 -- short bow
#clearspec
#stealthy 0
#pillagebonus 2
#ambidextrous 2
#forestsurvival
#gcost 11
#rcost 1
#rpcost 8
#chaosrec 1
#end

--Such an exotic location must have poison archers !
#newmonster 10403
#copystats 3332 -- nabaean desert warrior
#spr1 "./ma_pankot/thugee_poisarch.png"
#spr2 "./ma_pankot/thugee_poisarch_2.png"
#name "Thuggee Poison Archer"
#descr "During training or in the course of battles, some Thuggee warriors show greater precision than their comrades and an affinity for the bow. These are given further training and equipped with poisoned composite bows of high quality."
#clearweapons
#weapon 372 -- Poisoned composite bow (androphag arher)
#weapon 746 -- scimitar
#clearspec
#stealthy 0
#pillagebonus 2
#forestsurvival
#gcost 14
#rcost 1
#rpcost 14
#chaosrec 1
#end

-- From the one scene in the movie when they are greated by Chatar Lal... Talk about attention to details...
#newmonster 10404
#spr1 "./ma_pankot/palace_guard.png"
#spr2 "./ma_pankot/palace_guard_2.png"
#name "Palace Guard"
#descr "Palace Guards are loyal warriors who protect the Maharaja of Pankot and the Rajas of surrounding lands. They are not part of the Thuggee cult, but they have sworn to protect their masters until their dying breath. They wear Chainmail under their ceremonial robes and iron caps under their turbans. The Palace Guard are well trained and respected warriors."
#armor 8 --chain mail cuirass
#armor 20 -- iron cap 
#weapon 1 -- spear
#weapon 746 -- scimitar
#hp 13
#size 3
#prot 0
#mr 10
#mor 13
#str 11
#att 12
#def 12
#prec 10
#ap 12
#mapmove 16
#enc 3
#ambidextrous 4
#castledef 1
#bodyguard 3
#gcost 17
#rcost 1
#rpcost 25
#humanoid
#end

-- There were elephants, and they are used a lot in india, so why not 
#newmonster 10405
#copystats 2307 -- MA Machaka elephant rider
#spr1 "./ma_pankot/eleph.png"
#spr2 "./ma_pankot/eleph_2.png"
#unmountedspr1 "./ma_pankot/rider.png"
#unmountedspr2 "./ma_pankot/rider_2.png"
#name "Elephant Rider"
#descr "Elephants are used all over Pankot and the neighbouring kingdoms for heavy labour and transports. Although some are used by the Rajas for war, the Thuggees prefer to coerce local peasants and elephant handlers into the cult and use them when needed. These elephants come with no barding and only a single rider, but they get the job done and cost less to field than the war elephants of the Rajas. The elephants of Pankot come from the deep jungle."
#clearspec
#mountmnr 10413
#forestsurvival
#gcost 70
#rcost 11
#rpcost 28
#end

#newmonster 10413
#copystats 2398
#copyspr 2398
#name "Trained Elephant"
#descr "Elephants are used all over Pankot and the neighbouring kingdoms for heavy labour and transports. Although some are used by the Rajas for war, the Thuggees prefer to coerce local peasants and elephant handlers into the cult and use them when needed. These elephants come with no barding and only a single rider, but they get the job done and cost less to field than the war elephants of the Rajas. The elephants of Pankot come from the deep jungle."
#nothrowoff
#end

-- this is a bit of a strech but feels fitting so f*ck it.
#newmonster 10406
#spr1 "./ma_pankot/cultist.png"
#spr2 "./ma_pankot/cultist_2.png"
#name "Kali Ma Cultist"
#descr "The most fanatic and committed followers of mother Kali are the cultists. It is said that those favoured by Kali fall into the Black Sleep without drinking the blood. Guided by visions, they find their way to the Thuggee cult where they are welcomed and celebrated as sacred warriors. They don't wear any armor and wield poisoned krysses"
#armor 249 --cloth headpiece
#weapon 1920 --"Poisoned Kryss"
#weapon 1920 --"Poisoned Kryss"
#hp 12
#size 3
#prot 0
#mr 13
#mor 50
#str 12
#att 10
#def 10
#prec 8
#ap 12
#mapmove 16
#enc 3
#holy
--#blessbers
--#berserk 3
#ambidextrous 2
--#stealthy 0
#gcost 11
#rcost 1
#rpcost 9
#end


--again a strech but why not have decent cap sacreds. 
#newmonster 10407
#spr1 "./ma_pankot/thugee_sacred.png"
#spr2 "./ma_pankot/thugee_sacred_2.png"
#name "Blood Drinker"
#descr "Those warriors who have proven themselves in battle and shown unwavering loyalty to the Thuggees and the Cult of Kali Ma are given the dubious honour to drink the Blood of Kali and enter the Black Sleep. The warriors become mindlessly, unswervingly loyal to Kali and the Thuggees. They are given serpentine greatswords coated in poison and paint their faces to resemble a skull. Unlike other Thuggee warriors, they are given chainmail which they wear underneath the robes and iron caps under their turbans."
#weapon 1921 -- serpent greatsword
#armor 20 -- iron cap
#armor 8 --chain mail cuirass
#hp 15
#size 3
#prot 0
#mr 13
#mor 50
#str 14
#att 12
#def 10
#prec 8
#ap 12
#mapmove 16
#enc 3
#holy
#gcost 20
#rcost 1
#rpcost 22
#end

-- Slaves

-- standard slave but more indian
#newmonster 10408
#copystats 720 --slave
#spr1 "./ma_pankot/slave.png"
#spr2 "./ma_pankot/slave_2.png"
#name "Slave"
#descr "A slave captured from their village and forced to serve Pankot. While most slaves are used in the mines, some are forced to the battlefields in times of need."
#montag 6679
#end

-- child slave
-- size 2
#newmonster 10409
#copystats 3390 --hoburg slinger
#spr1 "./ma_pankot/cslave1.png"
#spr2 "./ma_pankot/cslave1_2.png"
#name "Child Slave"
#descr "A child captured from their family and forced to serve Pankot. While most slaves are used in the mines, some are forced to the battlefields in times of need."
#cleararmor
#clearspec
#mr 10
#att 6
#def 7
#prec 10
#slave
#startage 8
#montag 6679
#end

-- one more child slave ( so that 50% of slaves are children)
-- size 2
#newmonster 10410
#copystats 483 -- hoburg militia
#spr1 "./ma_pankot/cslave2.png"
#spr2 "./ma_pankot/cslave2_2.png"
#name "Child Slave"
#descr "A child captured from their family and forced to serve Pankot. While most slaves are used in the mines, some are forced to the battlefields in times of need."
#cleararmor
#clearspec
#mr 10
#att 6
#def 7
#prec 10
#slave
#startage 8
#montag 6679
#end

-- coerced warrior
#newmonster 10411
#copystats 29 --light infantry 
#spr1 "./ma_pankot/coerced.png"
#spr2 "./ma_pankot/coerced_2.png"
#name "Coerced Warrior"
#descr "Warriors and bandits with training are also often coerced to serve Pankot through ransom and threats. These serve on the battlefield when needed, but have low morale unless led by a taskmaster."
#mor 7
#slave
#montag 6679
#end

--generic slave that randomly transforms into one of the other 4
#newmonster 10412
#copystats 720 --slave
#spr1 "./ma_pankot/slave.png"
#spr2 "./ma_pankot/slave_2.png"
#name "Slave"
#descr "A slave captured from their village and forced to serve Pankot. While most slaves are used in the mines, some are forced to the battlefields in times of need."
#firstshape -6679
#end

------- COMMANDERS ----------------------------------------------

-- that is not a painting ! 
-- assassin 
#newmonster 10450
#copystats 428 --generic assassin
#spr1 "./ma_pankot/thugee_assassin.png"
#spr2 "./ma_pankot/thugee_assassin_2.png"
#name "Thuggee Assassin"
#descr "For many centuries the Thuggee operated in secret and as guerilla soldiers. Well trained assassins were extremely important to remove those that stood in the way of Kali Ma's ascendency or that got too close to discovering the secret temples of the cult. To this day assassins are employed to solve all manner of problems. They are armed with Poisoned Krysses, but prefer strangling their victims with silk cords."
#clearweapons
#cleararmor
#armor 158 --robes
#armor 249 --cloth headpiece
#weapon 1920 --"Poisoned Kryss"
#weapon 116 -- strangulation
#mor 14
#str 12
#att 13
#def 13
#prec 13
#patience 2
#gcost 85
#rcost 1
#rpcost 1
#nametype 129
#noleader
#humanoid
#end 

-- Chattar Lal would be proud...
-- Spy / Emisary
#newmonster 10451
#copystats 1591 -- spy
#spr1 "./ma_pankot/emisary.png"
#spr2 "./ma_pankot/emisary_2.png"
#name "Emissary"
#descr "The Thuggee cult attracts more than just bandits, peasants and fanatics. Many learned men, councillors and emissaries of the Rajas of nearby lands have been attracted to the cult and the promises of Kali Ma. They serve the cult by infiltrating other nations, exposing their weaknesses, spreading lies and whispering about the power of Kali."
#clearweapons
#cleararmor
#weapon 1920 --"Poisoned Kryss"
#hp 11
#size 2
#prot 0
#mr 11
#mor 9
#str 9
#att 9
#def 9
#prec 8
#ap 12
#mapmove 16
#enc 2
#gcost 80
#rcost 1
#rpcost 2
#nametype 129
humanoid
#end 

-- Somebody has to be in charge, right ?
-- Commander
#newmonster 10452
#spr1 "./ma_pankot/thugee_commander.png"
#spr2 "./ma_pankot/thugee_commander_2.png"
#name "Thuggee Commander"
#descr "The Commander of the roaming Thuggee warbands wear a turban with a blood red circle and a metal statuette of Kali Ma on the top. They are efficient yet unremarkable and share their fellow Thuggee's aptitude for sneaking and pillaging."
#armor 158 --robes
#armor 249 --cloth headpiece
#weapon 746 -- scimitar
#weapon 9 -- dagger
#weapon 23 -- short bow
#hp 12
#size 3
#prot 0
#mr 10
#mor 13
#str 11
#att 11
#def 11
#prec 11
#ap 12
#mapmove 16
#enc 3
#okleader
#stealthy 0
#pillagebonus 3
#ambidextrous 2
#forestsurvival
#gcost 55
#rcost 1
#rpcost 1
#chaosrec 1
#nametype 129
#humanoid
#end

-- maybe this time they won't get overrun by children... 
-- Slaver
#newmonster 10453
#copystats 10452
#spr1 "./ma_pankot/slaver.png"
#spr2 "./ma_pankot/slaver_2.png"
#name "Thuggee Slaver"
#descr "During their raids, Thuggees capture many slaves, preferably children, which can either be trained and indoctrinated or put to work in mines. Slavers take care of the large slave workforce as well as arranging the capture of new slaves."
#clearweapons
#cleararmor
#clearspec
#weapon 40 --whip
#armor 249 --cloth headpiece
#okleader
#command 50
#inspirational -1
#slaver 10412
#taskmaster 3
#gcost 100
#rcost 1
#rpcost 1
#nametype 129
#end

-- Raja, on elephant
-- they see me riding, my elephant, they must think I'm so Raja and awesome
#newmonster 10454
#spr1 "./ma_pankot/raj.png"
#spr2 "./ma_pankot/raj_2.png"
#unmountedspr1 "./ma_pankot/raj_foot.png"
#unmountedspr2 "./ma_pankot/raj_foot_2.png"
#name "Raja"
#descr "The Rajas are the undisputed secular and religious leaders of the states subject to the Maharaja of Pankot. As the upholders of Dharma, the force of order that upholds the universe, they are considered sacred and have priestly powers which not even the Thuggees dispute. In addition they are taught the arts of war and magic, and most of them have at least some knowledge in the magic of nature or stars. They prefer to move around on their elephants and are always accompanied by an entourage of Palace Guards."
#mountmnr 10414
#weapon 746 -- scimitar
#armor 161 -- jeweld breastplate
#armor 249 --cloth headpiece
#hp 13
#size 3
#prot 0
#mr 15
#mor 13
#expertleader
#inspirational 1
#str 11
#att 12
#def 12
#prec 11
#ap 12
#mapmove 16
#enc 3
#magicskill 9 2
#custommagic 11264 50 -- 50% ESN
#custommagic 11264 50 -- 50% ESN
#custommagic 11264 10 -- 10% ESN
#holy
#combatcaster
#batstartsum5 10404 --palace guard
#startage 30
#maxage 60
#gcost 410
#rcost 30
#rpcost 3
#nametype 129
#humanoid
#end

#newmonster 10414
#copystats 3541 -- barded war elephant
#spr1 "./ma_pankot/royal_elephant.png"
#spr2 "./ma_pankot/royal_elephant_2.png"
#name "Royal Elephant"
#descr "The elephants ridden by the Rajas are barded and exquisitely decorated. As they are bearing a holy person they are also considered holy. They are very well trained and have charms to protect against spells."
#holy
#end

-- Acolyte of Blood
-- stealthy preach, blood sacking, virgin hunting guy
#newmonster 10455
#spr1 "./ma_pankot/acolyte_b.png"
#spr2 "./ma_pankot/acolyte_b_2.png"
#name "Acolyte of Blood"
#descr "Acolytes form the backbone of the priestly and mage power of the Thuggee cult. They paint their skin in pale colors to resemble skeletons and help the High Priests in specific tasks. The Acolytes of Blood are field operatives and are in charge of procuring worthy blood sacrifices. In addition they can infiltrate heretic nations and through preaching and blood rituals lower the dominion of false Pretenders."
#weapon 1920 --"Poisoned Kryss"
#armor 249 --cloth headpiece
#hp 10
#size 3
#prot 0
#mr 14
#mor 14
#poorleader
#poorundeadleader
#str 11
#def 12
#att 12
#prec 11
#ap 12
#mapmove 16
#magicskill 8 1
#magicskill 9 1
#custommagic 1152 100 -- +1 FE
#custommagic 33920 10 -- 10% FEB 
#holy
#stealthy 20
#douse 1
#gcost 230
#rcost 1
#rpcost 2
#startage 22
#nametype 129
#humanoid
#end

-- Acolyte of Sacrifice 
-- more standard guy in charge of blood sacking and magic
#newmonster 10456
#spr1 "./ma_pankot/acolyte_s.png"
#spr2 "./ma_pankot/acolyte_s_2.png"
#name "Acolyte of Sacrifice"
#descr "Acolytes form the backbone of the priestly and mage power of the Thuggee cult. They paint their skin in pale colors to resemble skeletons and help the High Priests in specific tasks. The Acolytes of Sacrifice help the high priests during sacrificial ceremonies and magic rituals."
#weapon 1920 --"Poisoned Kryss"
#armor 249 --cloth headpiece
#hp 10
#size 3
#prot 0
#mr 14
#mor 14
#poorleader
#okundeadleader
#str 11
#def 12
#att 12
#prec 11
#ap 12
#mapmove 16
#magicskill 8 2
#magicskill 9 2
#custommagic 1152 100 -- +1 FE
#custommagic 33920 10 -- 10% FEB 
#holy
#gcost 285
#rcost 1
#rpcost 2
#startage 22
#nametype 129
#humanoid
#end

-- High Priest
-- Mola Ram style bad ass with Blood fire earth and possible nature random
#newmonster 10457
#spr1 "./ma_pankot/high_priest.png"
#spr2 "./ma_pankot/high_priest_2.png"
#name "High Priest of Kali Ma"
#descr "The High Priests of Kali Ma lead the ritual congregations and sacrifice captives to appease mother Kali. In the main temple under the Pankot palace, called the Temple of Doom, this includes throwing captives into the pit of lava present there, while in other temples the pit has to be recreated with large bonfires. Each one of the High Priests has been personally trained by Mola Ram himself, and are powerful mages of magma and blood. They have been granted increased vitality by Kali Ma."
#weapon 1920 --"Poisoned Kryss"
#armor 125 --skullface
#hp 15
#size 2
#prot 0
#mr 16
#mor 17
#goodleader
#okundeadleader
#str 13
#def 12
#att 12
#prec 11
#ap 12
#mapmove 16
#magicskill 0 2
#magicskill 3 2
#magicskill 8 3
#magicskill 9 3
#custommagic 42112 10 -- 10% FENB
#adeptsacr 1
#holy
#gcost 470
#rcost 1
#rpcost 4
#twiceborn -6678
#startage 34
#nametype 129
#end

-- Ascetic
-- outside forts only
#newmonster 10458
#copystats 3128 -- Orphic Mystic, for reincarnation... not sure how that works... 
#spr1 "./ma_pankot/ascetic.png"
#spr2 "./ma_pankot/ascetic_2.png"
#name "Ascetic"
#descr "Ascetics are hermits who live in the forests and wilds all over Pankot and neighbouring regions. In search of enlightenment, they forgo all earthly pleasures, practising extreme abstinence. They are malnourished and weak, yet are considered holy, even by the Thuggees who protect and help them. They are persuaded into servitude of the awakening Kali Ma. Ascetics are connected to the magic of nature and the celestial plane."
#clearweapons
#clearmagic
#weapon 346 -- useless kick
#armor 249 --cloth headpiece
#hp 6
#size 3
#prot 0
#mr 18
#mor 20
#noleader
#str 6
#def 5
#att 5
#prec 12
#spiritsight
#ap 12
#mapmove 16
#custommagic 10240 100 -- +1 SN
#custommagic 10240 100 -- +1 SN
#custommagic 10240 10 -- +1 SN
#holy
#gcost 110
#rcost 1
#rpcost 2
#startage 35
#nametype 129
#end

------- SUMMONED UNITS ------------------------------------------------------------------

--Asara
#selectmonster 1745
#montag 6677
#end

--Anusara 
#selectmonster 1746
#montag 6677
#end

--Palankasha
#selectmonster 1747
#montag 6677
#end


------- SUMMONED COMMANDERS

--avatar of Kali Ma twiceborn thinkgy
#newmonster 10459
#spr1 "./ma_pankot/kali_avatar.png"
#spr2 "./ma_pankot/kali_avatar_2.png"
#name "Avatar of Kali Ma"
#descr "The chosen few high priests whom Kali Ma deems worthy are transformed into her avatars, directly connected to the great mother's demon-slaying form. They ascend to the celestial abode of Kali and return changed, with four arms and wielding Apotropaic weapons that slay demons. As Avatars of Kali Ma they cannot be killed inside the Dominion of the Great Mother."
#armor 14 -- plate hauberk
#armor 1 -- buckler
#armor 20 -- iron cap
#armor 113 --skull necklace
#weapon 467 -- apotropaic trident
#weapon 466 -- apotropaic sword
#weapon 17 --axe
#hp 28
#size 4
#prot 3
#mr 18
#mor 18
#str 18
#att 14
#def 14
#prec 11
#ap 14
#enc 2
#fear 5
#magicbeing
#holy
#ambidextrous 5
#spiritsight
#experleader
#expertundeadleader
#bloodattuned 50
#magicboost 9 1
#itemslots 991774 -- 4hands,bow,head,body,feet,2misc
#demon
#domimmortal
#montag 6678
#cleanshape
#end

-- mindless  slave chassis 
#newmonster 10460
#copystats 10457
#spr1 "./ma_pankot/undead_priest.png"
#spr2 "./ma_pankot/undead_priest_2.png"
#name "Sleeping High Priest"
#descr "Those High Priests whom Kali Ma doesn't consider worthy are overtaken by the Black Sleep and transformed into mindless undead servants."
#mor 50
#undead
#coldres 15
#poisonres 25
#pierceres
#neednoteat
#noheal
#holy
#inanimate
#pooramphibian
#montag 6678
#montagweight 2
#gcost 0
#end


------- HEROES

-- Raksharaja multihero
#newmonster 10461
#copyspr 1738
#copystats 1738
#name "Deposed Raksharaja"
#descr "The Raksharaja is a Rakshasa King and former ruler of the Lankan ogres. When Lanka fell, most Raksharajas were banished from this world, yet some escaped, hiding in the deep forests. Over time, they created bloody cults, such as the one of Pankot. Now the time has come for Lanka to rise again, and the Raksharaja has come to serve Pankot and the Awakening God. The Raksharaja appears as a monstrous ogre with the legs and horns of a bull and a massive ape-like body. He is a formidable warrior and powerful sorcerer. He has a ravenous appetite and feasts upon men and monkeys. Raksharajas are descendants of the Danavas and Daityas of ancient times and are vulnerable to fire. Centuries of hiding has granted them powers of illusion and the ability to hide their true form."
#glamour
#magicskill 7 1 -- +1 glamour 
#stealthy 15
#latehero 5
#end

-- Supreme Priest - Mola Ram
#newmonster 10462
#spr1 "./ma_pankot/mola_ram.png"
#spr2 "./ma_pankot/mola_ram_2.png"
#name "Supreme Priest"
#descr "Mola Ram is the supreme leader of the Thuggee cult and second only in importance to Kali Ma herself. Little is known about the Supreme Priest except that seemingly from nothing he managed to recreate the bloody Thuggee cult. He has vast priestly and magical powers. Many times his foes thought him slain only for Mola Ram to reappear again and wreak vengeance upon them."
#fixedname "Mola Ram"
#weapon 1920 --"Poisoned Kryss"
#armor 125 --skullface
#hp 25
#size 2
#prot 0
#mr 18
#mor 17
#expertleader
#expertundeadleader
#str 15
#def 13
#att 13
#prec 12
#ap 12
#enc 3
#mapmove 16
#magicskill 0 3
#magicskill 3 2
#magicskill 8 4
#magicskill 5 1
#magicskill 9 4
#holy
#domimmortal
#twiceborn -6678
#latehero 15
#unique
#humanoid
#end

-- Maharaja - Zalim Singh
#newmonster 10463
#spr1 "./ma_pankot/maharaja.png"
#spr2 "./ma_pankot/maharaja_2.png"
#name "Maharaja"
#descr "Young Zalim Singh had to take the throne of Pankot as Maharaja, great king, after the death of his father. Although widely considered a well-educated and benevolent ruler, those with proper intelligence may know that there is something dark behind the scenes. It is believed that young Zalim is manipulated by the Thuggee cult, in particular by his close advisor and prime minister Chattar Lal. Many see the poor Maharaja as being manipulated at best and outright hypnotized at worst. Few if any come close to finding the real truth of the Maharaja, and his real shape. The Maharaja has been trained in the magics of Nature and Glamour. He also possesses priestly powers. If the Maharaja is present in the capital many foreign officials and dignitaries will come to tribute gold, perls and slaves."
#fixedname "Zalim Singh"
#armor 158 --robes
#armor 249 --cloth headpiece
#weapon 9 --dager
#hp 10
#size 2
#prot 0
#mr 16
#mor 14
#goodleader
#str 9
#def 13
#att 9
#prec 10
#ap 12
#enc 3
#mapmove 16
#magicskill 7 2
#magicskill 6 2
#magicskill 9 2
#holy
#gold 50
#shapechange 10464
#latehero 10
#unique
#humanoid
#end

--true form...
#newmonster 10464
#spr1 "./ma_pankot/maharaksharaja.png"
#spr2 "./ma_pankot/maharaksharaja_2.png"
#name "Maharaksharasi"
#descr "Almost none know that the true shape of young Zalim Singh is that of a particularly cunning Rakshasi, with shapeshifting abilities far beyond her peers. When Lanka fell she shapeshifted as a Kaliasa Guru and escaped. She travelled the lands disguised as an Ascetic. When she stumbled upon Pankot she saw the previous Maharaja as weak and easily manipulated. She transformed into a beautiful redhead, seduced the Maharaja and murdered the wife. The Maharaja took her hand in marriage and she bore him a child. She secluded herself with the half-demon child. The Maharaja was tricked that the child was normal through illusion spells, though most of the time he didn't care to visit them. When the child has grown of ruling age she seized the opportunity. She murdered the Maharaja, ate her own child and took its shape. Now she joined the Thuggee cult to rise in power and rule the world."
#fixedname "Zalim Singh"
#weapon 12 -- mace
#hp 37
#size 4
#prot 5
#mr 20
#mor 30
#goodleader
#str 20
#att 12
#def 12
#prec 11
#ap 10
#mapmove 16
#enc 3
#magicskill 5 1
#magicskill 6 2
#magicskill 7 3
#magicskill 8 2
#magicskill 9 2
#holy
#stealthy 15
#glamour
#fireres -5
#darkvision 100
#chaospower 1
#demon
#female
#forestsurvival
#neednoteat
#supplybonus -10
#reanimpriest
#shapechange 10463
#unique
#humanoid
#end


-- Converted Adventurer - Indiana Jones
#newmonster 10465
#spr1 "./ma_pankot/indy.png"
#spr2 "./ma_pankot/indy_2.png"
#name "Archeologist"
#descr "Indiana Jones is an Archeologist, a scholar of ancient and forgotten civilisations and artefacts. Although stories about him abound no one is quite sure where he came from. He came to Pankot in search of the mysterious Sankara stones. Although he created many troubles and set back the Thuggees goals many times, he was finally captured and forced to drink the Blood of Kali, trapping him in the Dark Sleep. According to some, the sleep is merely temporary and if wounded, especially with fire, he will awake and take his vengeance upon Pankot!"
#fixedname "Indiana Jones"
#weapon 40 --whip
#hp 17
#size 3
#prot 0
#mr 15
#poorleader
#str 13
#def 12
#att 12
#prec 12
#ap 12
#mapmove 16
#enc 3
#mor 50
#fireres -10
#stealthy 25
#humanoid
#startitem 1660
#latehero 15
#unique
#end

-- Prime Minister - Chattar Lal
#newmonster 10466
#spr1 "./ma_pankot/chattar.png"
#spr2 "./ma_pankot/chattar_2.png"
#name "Prime Minister"
#descr "Prime Minister Chattar Lal has served the previous and current Maharajas of Pankot. He organizes the task collection, research, administration etc. He is also ordained as a Thuggee Priest, though he lacks magical power. Although blamed for converting the young Maharaja to the dark cult of the Thuggees, the truth is in fact quite the opposite, and the Prime Minister is sworn to serve the Maharaja, whoever, or whatever it may be."
#fixedname "Chattar Lal"
#hp 11
#size 3
#prot 0
#mr 13
#goodleader
#str 9
#def 9
#att 9
#prec 9
#ap 12
#mapmove 16
#enc 3
#mor 10
#fixedresearch 10
#inspiringres 1
#castledef 30
#supplybonus 20
#resources 20
#incunrest -5
#incprovdef 2
#taxcollector
#magicskill 9 2
#holy
#unique
#end

------- SANKARA STONES

#newmonster 10467
#spr1 "./ma_pankot/sankara.png"
#spr2 "./ma_pankot/sankara.png"
#name "Sankara Stone"
#descr "The Sanakara stones are five smooth-polished stones shaped like rounded columns that symbolize the fertility aspect of the previous Panktokrator. They were given to a faithful servant of the previous Pantokrator to combat evil and those who oppose him. All stones will bring good luck. The first stone increases order."
#fixedname "Stone of Order"
#hp 30
#prot 20
#size 1
#pierceres
#slashres
#mr 18
#poorleader
#str 20
#def 1
#att 1
#prec 12
#ap 2
#mapmove 0
#immobile
#enc 0
#mor 50
#awe 3
#fireshield 15
#eyeloss
#curseluckshield 3
#holy
#magicskill 4 1
#researchbonus -5
#inanimate
#bringeroffortune 10
#decscale 0 --Turmoil
#unique
#end


#newmonster 10468
#spr1 "./ma_pankot/sankara2.png"
#spr2 "./ma_pankot/sankara2.png"
#name "Sankara Stone"
#descr "The Sanakara stones are five smooth-polished stones shaped like rounded columns that symbolize the fertility aspect of the previous Panktokrator. They were given to a faithful servant of the previous Pantokrator to combat evil and those who oppose him. All stones will bring good luck. The second stone increases productivity."
#fixedname "Stone of Productivity"
#hp 30
#prot 20
#size 1
#pierceres
#slashres
#mr 18
#poorleader
#str 20
#def 1
#att 1
#prec 12
#ap 2
#mapmove 0
#enc 0
#mor 50
#awe 3
#fireshield 15
#eyeloss
#curseluckshield 3
#holy
#magicskill 4 1
#researchbonus -5
#inanimate
#bringeroffortune 10
#decscale 1
#unique
#end

#newmonster 10469
#spr1 "./ma_pankot/sankara3.png"
#spr2 "./ma_pankot/sankara3.png"
#name "Sankara Stone"
#descr "The Sanakara stones are five smooth-polished stones shaped like rounded columns that symbolize the fertility aspect of the previous Panktokrator. They were given to a faithful servant of the previous Pantokrator to combat evil and those who oppose him. All stones will bring good luck. The third stone increases growth."
#fixedname "Stone of Growth"
#hp 30
#prot 20
#size 1
#pierceres
#slashres
#mr 18
#poorleader
#str 20
#def 1
#att 1
#prec 12
#ap 2
#mapmove 0
#enc 0
#mor 50
#awe 3
#fireshield 15
#eyeloss
#curseluckshield 3
#holy
#magicskill 4 1
#researchbonus -5
#inanimate
#bringeroffortune 10
#decscale 3
#unique
#end

#newmonster 10470
#spr1 "./ma_pankot/sankara4.png"
#spr2 "./ma_pankot/sankara4.png"
#name "Sankara Stone"
#descr "The Sanakara stones are five smooth-polished stones shaped like rounded columns that symbolize the fertility aspect of the previous Panktokrator. They were given to a faithful servant of the previous Pantokrator to combat evil and those who oppose him. All stones will bring good luck. The third stone increases luck."
#fixedname "Stone of Luck"
#hp 30
#prot 20
#size 1
#pierceres
#slashres
#mr 18
#poorleader
#str 20
#def 1
#att 1
#prec 12
#ap 2
#mapmove 0
#enc 0
#mor 50
#awe 3
#fireshield 15
#eyeloss
#curseluckshield 3
#holy
#magicskill 4 1
#researchbonus -5
#inanimate
#bringeroffortune 10
#decscale 4
#unique
#end

#newmonster 10471
#spr1 "./ma_pankot/sankara5.png"
#spr2 "./ma_pankot/sankara5.png"
#name "Sankara Stone"
#descr "The Sanakara stones are five smooth-polished stones shaped like rounded columns that symbolize the fertility aspect of the previous Panktokrator. They were given to a faithful servant of the previous Pantokrator to combat evil and those who oppose him. All stones will bring good luck. The fifth stone increases magic."
#fixedname "Stone of Magic"
#hp 30
#prot 20
#size 1
#pierceres
#slashres
#mr 18
#poorleader
#str 20
#def 1
#att 1
#prec 12
#ap 2
#mapmove 0
#enc 0
#mor 50
#awe 3
#fireshield 15
#eyeloss
#curseluckshield 3
#holy
#magicskill 4 1
#researchbonus -5
#inanimate
#bringeroffortune 10
#decscale 5
#unique
#end


------- PRETENDERS


------- SPELLS

--Summon Danavas
#selectspell 582
#restricted 203
#end

--Summon Vetalas
#selectspell 585
#restricted 203
#end

--Host of Ganas
#selectspell 584
#restricted 203
#end

--Summon sandhyabalas
#selectspell 578
#restricted 203
#end

--feast of flesh
#selectspell 575
#restricted 203
#end

--summon asrapas
#selectspell 576
#restricted 203
#end

--summon rakshasa warriors
#selectspell 577
#restricted 203
#end

--summon rakshasas
#selectspell 574
#restricted 203
#end

--summon Mandeha
#selectspell 581
#restricted 203
#end

--summon samanishada
#selectspell 580
#restricted 203
#end

--summon dakini
#selectspell 579
#restricted 203
#end

--Summon Daitya
#selectspell 583
#restricted 203
#end

--Twiceborn not for mola ram and high priests
#selectspell 1159
#notmnr 10457
#notmnr 10462
#end

#newspell
#name "Beckon Demon-Ogres of Lanka"
#descr "After the fall of Lanka, most Demon-Ogres were banished from this world, some, however, escaped and hid themselves in the deepest of Jungles. Here, either alone or in tribes, the demon-ogres coerced the worship of humans and monkeys. With this spell, a blood mage of Pankot ventures deep into a jungle or forest. After drawing signs of pure blood and chanting ancient spell-songs, the blood mage pulls the beating heart out of a still living virgin and stabs it with a sacrificial knife. The scream is inaudible to anyone but the demon-ogres and they will be drawn from the forest to serve the caster in the resurgence of Lanka. The caster has no control over which demon-ogres respond to the spell."
#restricted 203
#onlygeosrc 128 --only forest
#school 6
#researchlevel 3
#path 0 8
#path 1 6
#pathlevel 0 2
#pathlevel 1 1
#fatiguecost 1200 -12 blood slaves
#effect 10001
#nreff 3
#damage -6677
#end

#newspell
#name "Summon Rakshasi"
#descr "After the fall of Lanka, most Demon-Ogres were banished from this world, some, however, escaped and hid themselves in the deepest of Jungles. With this spell, a blood mage of Pankot performs a great sacrifice and calls a Rakshasi back to this world. Rakshasi are female demon-ogres from Lanka and skilled in the magic of air, death, nature and blood."
#restricted 203
#school 6
#researchlevel 5
#path 0 8
#pathlevel 0 3
#fatiguecost 4700 -47 blood slaves
#effect 10021
#damage 1739
#end 

#newspell
#name "10 Asaras"
#restricted 203
#school -1
#researchlevel 5
#path 0 8
#pathlevel 0 3
#fatiguecost 4700 -47 blood slaves
#effect 10001
#damage 1745
#nreff 10
#end

#newspell
#name "10 Anusaras"
#restricted 203
#school -1
#researchlevel 5
#path 0 8
#pathlevel 0 3
#fatiguecost 4700 -47 blood slaves
#effect 10001
#damage 1746
#nreff 10
#nextspell "10 Asaras"
#end

#newspell
#name "5 Palankashas"
#restricted 203
#school -1
#researchlevel 5
#path 0 8
#pathlevel 0 3
#fatiguecost 4700 -47 blood slaves
#effect 10001
#damage 1747
#nreff 5
#nextspell "10 Anusaras"
#end

#newspell
#name "Summon Lankan Court"
#descr "After the fall of Lanka, most Demon-Ogres were banished from this world, some, however, escaped and hid themselves in the deepest of Jungles. With this spell, a powerful blood mage of Pankot performs a great blood feast and calls a Raksharaja, a king of the demon-ogres back to this world. The Raksharaja will be accompanied by his entourage of demon-ogre warriors."
#restricted 203
#school 6
#researchlevel 7
#path 0 8
#pathlevel 0 5
#fatiguecost 11300 --113 blood slaves
#effect 10021
#damage 1738
#nextspell "5 Palankashas"
#end

--twiceborn shape for priests and high priests

#newspell
#name "Mark of Kali Ma"
#descr "With a great sacrifice to appease Kali Ma, a High Priest marks himself as ready to be judged by the Great Mother. When he is slain, Kali Ma will judge his worth and he may rise again as a Demon Avatar of Kali Ma. On the other hand he may also fall into the Dark Sleep, and awaken a mindless, undead servant of Kali-Ma."
#details "A High priest gets twiceborn with a 33% chance of raising again as an Avatar of Kali Ma, or as a mindless undead servant that still retains magic paths."
#restricted 203
#onlymnr 10457 -- High Priest
#onlymnr 10462 -- Mola Ram
#school 6
#researchlevel 7

#path 0 8
#pathlevel 0 4

#effect 10023
#damage 4194304
#spec 814219264 -#undeadimmune; #uwok; #demonimune; #inanimateimmune
#nreff 1
#fatiguecost 3300 -- 33 bloodslaves
#end

-- move for sankara stones
#newspell 
#copyspell 1303 -- teleport
#name "Move Sankara Stone"
#descr "Using an astral pearl the Magic of the sankara stone is temporarily awakened and the stone is teleported magically to the desired province."
#restricted 203
#onlymnr 10467 -- Sankara stones...
#onlymnr 10468
#onlymnr 10469
#onlymnr 10470
#onlymnr 10471
#researchlevel 0
#pathlevel 0 1
#fatiguecost 100
#provrange 10
#end


------ Items -------------------------------------------

--Indy's Journal
#selectitem 1660
#clear
#copyspr 441 -- atlas of creation
#name "Indy's Journal"
#descr "The famous archeologist Indiana Jones has uncovered many secrets and truths, which were compiled into a Journal. Using this journal, Indiana Jones can find and uncover all sites of power in a province."
#type 8
#nofind
#cursed
#constlevel 12
#mainpath 3
#mainlevel 5
#spell "Record of Creation"
#end

--blood of Kali
#newitem
#spr "./ma_pankot/blood_of_kali.png"
#name "Blood of Kali"
#descr "The skull contains a diluted version of the Blood of Kali, usually preserved in the great Temple of Doom. When the blood is drunk, the bearer becomes blessed by the Great Mother and the dark sleep will prevent him from routing in battle, fighting until death or victory"
#restricted 203
#noforgebonus
#constlevel 6
#mainpath 8
#secondarypath 0
#mainlevel 3
#secondarylevel 1
#type 8
#bless
#morale 50
#berserk 0
#cursed
#nofind
#end


-- Kryta doll
#newitem
#spr "./ma_pankot/kryta.png"
#name "Kryta Doll"
#descr "The Kryta doll is fashioned in a humanoid shape and empowered by the magic of blood. At the start of battle the user activates the power of the doll and stabs it with a knife. The spirits of blood in the doll will try to transfer the excruciating pain, paralyzing any target in range."
#restricted 203
#noforgebonus
#constlevel 2
#mainpath 8
#mainlevel 2
#spell "Paralyze" --change ?
#type 8
#end


--serpent Kryss 20% off !! Get one today ! 
#selectitem 53
#nationrebate 203
#end

------- NAME POOL ----

------ EVENTS
#newevent
#rarity 0 --> always
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_capital 1 -only in capital
#req_site 1
#req_turn 5 -- cannot happen before turn 5
#msg "The Blood Sacrifice has stopped. If the sacrifice doesn't resume, Kali Ma's anger will transform the Pit of Fire, and Death will spread out of it ! [Pit of Fire]"
#notext
#nolog
#removesite 1820 --Remove Pit of Fire
#addsite 1823 --Add Pit of Death
#delay 0
#end

#newevent
#rarity 0 --> always
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_targorder 33
#req_site 1
#msg "pit of fire restored ! [Pit of Death]"
#notext
#nolog
#removesite 1823 --Remove Pit of Death
#addsite 1820 --Add Pit of Fire
#end

#newevent
#rarity 0 --> always
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_targorder 33
#req_site 1
#msg "Pit of fire restored ! [Pit of Death]"
#notext
#nolog
#removesite 1823 --Remove Pit of Death
#addsite 1820 --Add Pit of Fire
#end


-- Zalim Singh tribute events (only when in Mharaja shape and only when in capital)
-- gems for zalim Singh
#newevent
#rarity -2 --uncommon good
#1d3vis 53 --all gem types
#msg "Dignitaries from foreign lands have donated magic gems to the Maharaja." 
#req_monster 10463 --Maharaja
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_owncapital 1 -only in capital
#end

#newevent
#rarity -1 --common good
#1d3vis 1 --air
#msg "Dignitaries from foreign lands have donated magic gems to the Maharaja." 
#req_monster 10463 --Maharaja
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_owncapital 1 -only in capital
#end

#newevent
#rarity -1 --common good
#1d6vis 8 --blood
#msg "Dignitaries from foreign lands have donated slaves to the Maharaja." 
#req_monster 10463 --Maharaja
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_owncapital 1 -only in capital
#end

#newevent
#rarity -1 --common good
#1d3vis 4 --pearls
#msg "Dignitaries from foreign lands have donated magic pearls to the Maharaja." 
#req_monster 10463 --Maharaja
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_owncapital 1 -only in capital
#end


--indy does his shit !

#newevent
#rarity -1 --common good
#req_mnr 10465 --indy
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#msg "Indiana Jones has uncovered an artifact of power!"
#magicitem 4 --lvl 4-6
#end

-- if Indy is "Killed" he comes back to attack pankot with various monsters

#newevent
#rarity 1 --common bad
#req_deadmnr 10465 --indy
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#msg "Indiana Jones has returned to take his vengeance upon Pankot! He leads an army of Pirates against us!"
#nation 2
#com 10465 --indiana jones
#com 870 --captain
#8d6units 871 --pirates
#3d6units 47 --crossbowmen ring mail
#end

#newevent
#rarity 2 --uncommon bad
#req_deadmnr 10465 --indy
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#msg "Indiana Jones has returned to take his vengeance upon Pankot! He leads an army of Mummies against us!"
#nation 2
#com 10465 --indiana jones
#com 778 --divine mummy
#8d6units 625 --mummies
#end

-------------Sankara stones---------------------------
----- 2 of them are in the mines of pankot... -----------------

#newevent
#rarity 0
#req_rare 5 -- 5 percent chance of finding it  
#req_site 1
#msg "Your servant searching the Mines of Pankot found one of the Sankara Stones! [Mines of Pankot]"
#req_nomnr 10467
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_targorder 50 --commander enters site
#nation 203
#com 10467 --1st sankara stone !
#unique 
#end 

#newevent
#rarity 0
#req_rare 5 -- 5 percent chance of finding it  
#req_site 1
#msg "Your servant searching the Mines of Pankot found one of the Sankara Stones! [Mines of Pankot]"
#req_nomnr 10468
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_targorder 50 --commander enters site
#nation 203
#com 10468 --2nd sankara stone ! 
#unique
#end 

---------- 1 is in possession on Mola Ram --------------------------

#newevent
#rarity 0 -- happens always ! 
#msg "The Supreme Priest Mola Ram returns to Pankot with one of the Sankara Stones!"
#req_nomnr 10469
#req_monster 10462 --Mola Ram must be present
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#req_targorder 50 --commander enters site
#nation 203
#com 10469 --3rd sankara stone ! 
#unique
#end 

----------- 2 require following a simple event chain ... should be improved in the future to make it more interesting

#newevent
#rarity -2 -- uncommon good
#req_land 1 -- on land
#req_code 0 -- for events that generate event code
#code -7970 -- event code 
#flagland 1 -- set flag to province
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot 
#req_nomnr 10470 -- 4th sankara stone does not exist 
#msg "The Fourth Sankara stone was located in a province! A high priest must be sent to activate its powers and retrieve it!"
#end

#newevent
#rarity 0 --always
#req_code -7970 
#req_monster 10457 -- a high priest must be in the province
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#code 0 --set code 0
#req_nomnr 10470 -- 4th sankara stone does not exist
#nation 203
#com 10470 --4th sankara stone !!
#msg "The High Priest has found the Sankara stone. A lab should be constructed and the stone moved somewhere safe."
#end 


#newevent
#rarity -2 -- uncommon good
#req_land 1 -- on land
#req_code 0 -- for events that generate event code
#code -7971 -- event code 
#flagland 1 -- set flag to province
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot 
#req_nomnr 10471 -- 4th sankara stone does not exist 
#msg "The Fifth Sankara stone was located in a province! A high priest must be sent to activate its powers and retrieve it!"
#end

#newevent
#rarity 0 --always
#req_code -7971 
#req_monster 10457 -- a high priest must be in the province
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#code 0 --set code 0
#req_nomnr 104701 -- 4th sankara stone does not exist
#nation 203
#com 10471 --5th sankara stone !!
#msg "The High Priest has found the Sankara stone. A lab should be constructed and the stone moved somewhere safe."
#end  
 


-- When all 5 are together something awesome happens !!! 
#newevent
#rarity 0 --always
#req_mnr 10467 --all 5 stones must be present in the capital ! 
#req_mnr 10468
#req_mnr 10469
#req_mnr 10470
#req_mnr 10471
#req_capital 1
#req_nation 203 --requires Pankot
#req_fornation 203 --happens only to Pankot
#gold 1000 -- 1000 gold every turn +- 50 percent
#4d6vis 4 --4d6 astral pearls 
#nation 203
#2d6units 1335 --gandharva
#msg "The power of the stones summons gold, astral pearls and celestial warriors to our cause!"
#end

------- SITES

-- 1 fire, 1 earth
#newsite 1820
#name "Pit of Fire"
#path 0 -- fire 
#level 0
#rarity 5
#gems 0 1
#gems 3 1
#homemon 10407 -- Blood Drinker
#homecom 10457 -- High Priest
#loc 16384
#decscale 3 --increases growth
#end

-- 3 b slaves = 1 gem
#newsite 1821
#name "Mines of Pankot"
#path 3 -- earth 
#level 0
#rarity 5
#gems 8 3 -- 3b slaves
#adventureruin 15
#gold 50
#loc 16384
#end

-- 2 n
#newsite 1822
#path 6
#level 0
#rarity 5
#gems 6 2
#homemon 10400 -- Giant Vampire Bat
#name "Pankot Jungle"
#loc 16384
#end

#newsite 1823
#name "Pit of Death"
#path 0 -- fire 
#level 0
#rarity 5
#gems 5 1 --gives you death gem
#gems 3 1
#nation 203
--#natmon 10407 -- Blood Drinker
--#natcom 10457 -- High Priest
#homemon 10407 -- Blood Drinker
#homecom 10457 -- High Priest
#loc 16384
#incscale 3 --increases death
#end

#newsite 1824
#level 0
#rarity 5
#path 8
#name "Pankot Unit Summons I"
#homemon 1745
#homemon 1746
#homemon 1747
#homemon 1140
#homemon 1736
#homemon 1737
#homemon 1741
#homemon 1742
#homemon 1743
#homemon 1764
#end

#newsite 1825
#level 0
#rarity 5
#path 8
#name "Pankot Unit Summons II"
#homemon 1765
#homemon 1766
#homemon 1767
#homemon 2398
#homemon 3009
#homemon 3663
#end

#newsite 1826
#level 0
#rarity 5
#path 8
#name "Pankot Commander Summons"
#homecom 1714
#homecom 1744
#homecom 1748
#homecom 3635
#homecom 3636
#homecom 1739
#homecom 1738
#homecom 10459
#homecom 10460
#end

#newsite 1827
#level 0
#rarity 5
#path 9
#name "Pankot Heroes"
#homecom 10461
#homecom 10462
#homecom 10463
#homecom 10464
#homecom 10465
#homecom 10466
#end

#newsite 1828
#level 0
#rarity 5
#path 4
#name "Sankara Stones"
#homecom 10467
#homecom 10468
#homecom 10469
#homecom 10470
#homecom 10471
#end

-------- NATION

#selectnation 203
#name "Pankot"
#epithet "Temple of Doom"
#era 2
#brief "Pankot is home to the Thuggee cult that worships the Awakening God they call Kali through human sacrifice"
#descr "In ages past, what is now known as Pankot was the domain of Lankan demons. After their defeat the last remaining demon ogres hid in the dense jungles. Then humans arrived and settled the region, which they called Pankot. It was not long after that holy men started coming out of the dense jungle, where they meditated, talking about an Awakening God, called Kali Ma, or Mother Time. This is how the Thuggee cult came to be. They worshipped Kali Ma with gruesome rituals of human sacrifices. Seeing this outrage the Celestial Forces destroyed Pankot and killed most of the Cult. Yet, the cult continued its work in utmost secrecy. Now with the Pantokrator gone and Kali Ma about to awake, the Thuggees rebuild Pankot palace and are preparing to conquer the world for their Mother. Kali Ma is the Queen of Demons and the cult can summon the surviving demon-ogres of Lanka, as well as greater demons.

After turn 5, a blood priest must perform blood sacrifices in the capital to appease Kali Ma. If not, the Pit of Fire will turn into the pit of death, spreading death scales, but gives you 1 death gem instead of a fire gem."
#summary "Race: Humans, summonable Demon-Ogres, prefers Heat scale +2
Military: Light, Stealthy Infantry, Poison Archers, Elephants  
Magic: Blood, Earth, Fire and Nature. Access to Air, Death and Glamour through Summons
Priests: Powerful, can Blood Sacrifice "
 
#flag "./ma_pankot/flag.png"
#templepic 5 --indian
#color 0.97 0.02 0.0 
#homefort 3 -- Castle
#fortera 2 -- MA forts

#idealcold -2 -- HEAT 2
#sacrificedom -- Can blood sacrefice
--#bloodblessbonus 2 -- 2 blood bless bonus
#moreorder -1
#blessbonus 1
#likesterr 128 --likes forests
#hatesterr 64 --hates wastes
#cavenation 0 -- no cave

-------- START SITES
#startsite "Pit of Fire"
#startsite "Mines of Pankot"
#startsite "Pankot Jungle"

#futuresite 1824
#futuresite 1825
#futuresite 1826
#futuresite 1827
#futuresite 1828

-------- PRETENDERS 

#homerealm 8 
#addgod 656 --Fountain of Blood
#addgod 978 --great black bull
#addgod 2788 --maneater
#addgod 246 --freak lord 
#addgod 3345 --wooden colossus
#addgod 157 --mother of monsters
#addgod 2550 --raksharani
#addgod 158 --oracle
#addgod 249 --great crone
#addgod 485 --great enchantress
#addgod 2791 --earth serpent
#addgod 395 --lich queen

#delgod 2548 --monkey be gone

#cheapgod20 1341 --Devi of Darkness
#cheapgod20 2550 --raksharani


-------- ADD HEROES

#multihero1 10461 -- "Deposed Raksharaja"

#hero1 10462 -- Mola Ram
#hero2 10463 -- Zelim Singh
#hero3 10465 -- Indiana Jones
#hero4 10466 -- Chattar Lal

-------- ADD SOLDIERS

#addrecunit 10401 --Thuggee Militia
#addrecunit 10402 --Thuggee Warrior
#addrecunit 10403 --Thuggee Poision Archer
#addrecunit 10404 --Palace Guard
#addrecunit 10405 --Elephant
#addrecunit 10406 --Kali Ma Cultist

#addforeignunit 10406 --Kali Ma Cultist

-------- ADD COMMANDERS

#addreccom 10450 --Assassin
#addreccom 10451 --Emissary
#addreccom 10452 --Commander
#addreccom 10453 --Slaver
#addreccom 10454 --Raja
#addreccom 10455 --Acolyte of Blood
#addreccom 10456 --Acolyte of Sacrifice

#addforeigncom 10458 --Ascetic, only outside forts

-------- PD

#defcom1 10452 --Commander
#defcom2 10452 -- Commander
#defunit1 10401 --Thugee Militia 
#defunit1b 10402 --Thuggee Warrior
#defunit2 10402 --Thuggee Warrior
#defunit2b 10403 --Thuggee poision Archer

#defmult1 10 
#defmult1b 10 
#defmult2 10 
#defmult2b 10 

#wallcom 10452 --Commander
#wallunit 10402 --Thuggee Warrior
#wallmult 15

#guardcom 10454 --Raja
#guardunit 10404 --Palace guard 
#guardmult 10

#startcom 10452 --Commander
#startunittype1 10401 --Thugee Militia 
#startunitnbrs1 25 --instead of 10
#startunittype2 10402 --Thuggee Warrior
#startunitnbrs2 20 --instead of 10
#startscout 10450 --Assassin
#end

