﻿#modname "Firepower"
#description "New forces have been unleashed in the absence of the Pantokrator. Industry is advancing and weapons engineering is indistinguishable from magic. The nations of Rus, Ulm and Man emerge from civil wars with new ideas about warfare. Psychic warriors from another plane seek conquest in the name of their Emperor, or to overthrow the Empire in the name of the Republic. Whosoever seizes the Throne at the end of the Ascension War will surely reign over naught but cratered rubble."
#icon "./Firepower/banner.tga"
#version 1.0
#domversion 6.11

-- Weapon slots: 1300 - 1380
-- Armor slots: 615 - 673
-- Nation slots: 450 - 455
-- Nametypes: 251 - 273
-- Item slots: 850, 853
-- Unit slots: 6550 - 6599, 6800 - 6914
-- Site slots:
-- Spell slots: 2861 - 2863

-- Thanks to SA user Sword of Damocles for Stalotsky sprites

-- Version history

-- 25/04/2024
-- Firepower mod pack released for Dominions 6

-- 27/11/2017
-- Firepower mod pack released for Dominions 5

-- 20/09/2017
-- Initial release of Anglia

-- 25/09/2016
-- Initial release of New Republic

-- 11/01/2016
-- Initial release of Imperial Enclave

-- 22/05/2015
-- Initial release of Manica

-- 07/05/2015
-- Initial release of Ulmreich

-- 18/01/2015
-- Initial release of Sovirus


-------- WEAPONS --------

#newweapon 1300
#name "Lightsabre"
#dmg 5
#att 1
#def 1
#len 1
#rcost 8
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/lightsabre.sw"
#end

#newweapon 1301
#name "Two-handed Lightsabre"
#twohanded
#dmg 8
#att 3
#def 3
#len 2
#rcost 10
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/heavy_lightsabre.sw"
#end

#newweapon 1302
#name "Short Lightsabre"
#dmg 3
#att 1
#def 1
#len 1
#rcost 6
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/quick_lightsabre.sw"
#end

#newweapon 1303
#name "Double-bladed Lightsabre"
#twohanded
#dmg 5
#att 2
#def 2
#len 1
#rcost 12
#nratt 2
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/double_lightsabre.sw"
#end

#newweapon 1304
#name "Force Choke" -- tier 1
#magic
#mind -- no effect on mindless
#inanimateimmune
#undeadimmune
#mrnegates
#armornegating
#dmg -3
#att 0
#nratt 1
#range 15
#ammo 3
#rcost 0
#range0
#explspr 10072
#sample "./Firepower/choke.sw"
#bonus
#uwok
#end

#newweapon 1305
#name "Force Choke" -- tier 3
#magic
#mind -- no effect on mindless
#inanimateimmune
#undeadimmune
#mrnegates
#armornegating
#dmg 3
#att 0
#nratt 1
#range 25
#ammo 10
#rcost 0
#range0
#explspr 10072
#sample "./Firepower/choke.sw"
#bonus
#uwok
#end

#newweapon 1306
#name "Force Choke" -- tier 4
#magic
#mind -- no effect on mindless
#inanimateimmune
#undeadimmune
#mrnegates
#armornegating
#dmg 6
#att 0
#nratt 1
#range 30
#ammo 15
#rcost 0
#range0
#explspr 10072
#sample "./Firepower/choke.sw"
#bonus
#uwok
#end

#newweapon 1307
#name "Force Choke" -- tier 2
#magic
#mind -- no effect on mindless
#inanimateimmune
#undeadimmune
#mrnegates
#armornegating
#dmg 0
#att 0
#nratt 1
#range 20
#ammo 5
#rcost 0
#range0
#explspr 10072
#sample "./Firepower/choke.sw"
#bonus
#uwok
#end

#newweapon 1309
#name "Shrapnel"
#dmg 12
#aoe 1
#nostr
#pierce
#slash
#explspr 10060
#sample "./Firepower/artillery_impact.sw"
#end

#newweapon 1310
#name "Blaster Rifle"
#twohanded
#ironweapon
#dmg 14
#att 3
#nratt 1
#range 50
#fire
#armorpiercing
#nostr
#ammo 10
#rcost 12
#sample "./Firepower/blaster.sw"
#flyspr 96 1
#explspr 10071
#end

#newweapon 1311
#name "Blaster Pistol"
#ironweapon
#dmg 10
#att 2
#nratt 1
#range 45
#fire
#armorpiercing
#nostr
#ammo 10
#rcost 4
#sample "./Firepower/light_blaster.sw"
#flyspr 96 1
#explspr 10071
#range0
#end

#newweapon 1312
#name "Disruptor Carbine"
#twohanded
#ironweapon
#dmg 10
#att 1
#nratt 3
#range 35
#acid
#armorpiercing
#nostr
#ammo 8
#rcost 15
#sample "./Firepower/disruptor_carbine.sw"
#flyspr 404 3 -- acid arrow
#explspr 10064 -- green blob
#range0
#uwok
#end

#newweapon 1313
#name "Poison Grenade"
#ironweapon
#poison
#dt_poison
#dmg 10
#aoe 1
#att 0
#nratt 1
#range -1
#armornegating
#nostr
#ammo 1
#rcost 4
--#sound 15
#sample "./Firepower/grenade.sw"
#flyspr 99 1
#explspr 10114
#end

#newweapon 1314
#name "Blaster Carbine"
#twohanded
#ironweapon
#dmg 10
#att 1
#nratt 3
#range 35
#fire
#armorpiercing
#nostr
#ammo 8
#rcost 15
#sample "./Firepower/blaster_carbine.sw"
#flyspr 96 1
#explspr 10071
#range0
#end

#newweapon 1315
#name "Walker Kick"
#dmg 0
#att 0
#def 0
#len 5
#rcost 0
#unrepel
#norepel
#bonus
#blunt
#sound 1
#end

#newweapon 1316
#name "Heavy Blaster"
#ironweapon
#dmg 12
#att 1
#nratt 10
#range 50
#fire
#armorpiercing
#nostr
#ammo 10
#rcost 20
#sample "./Firepower/repeat_blaster.sw"
#flyspr 96 1
#explspr 10071
#bonus
#end

#newweapon 1317
#name "Sonic Rifle"
#twohanded
#ironweapon
#blunt
#dmg 14
#att 3
#nratt 1
#range 50
#armorpiercing
#nostr
#ammo 10
#rcost 12
#sample "./Firepower/sonic_blaster.sw"
#flyspr 339 3 -- decay
#explspr 10035
#uwok
#end

#newweapon 1318
#name "Sonic Carbine"
#twohanded
#ironweapon
#blunt
#dmg 10
#att 1
#nratt 3
#range 35
#armorpiercing
#nostr
#ammo 8
#rcost 15
#sample "./Firepower/sonic_carbine.sw"
#flyspr 339 3 -- decay
#explspr 10022
#range0
#uwok
#end

#newweapon 1319
#name "Sonic Grenade"
#ironweapon
#blunt
#dmg 15
#aoe 1
#att 0
#nratt 1
#range -1
#nostr
#ammo 1
#rcost 4
--#sound 15
#sample "./Firepower/sonic_grenade.sw"
#flyspr 99 1
#explspr 10122
#end

#newweapon 1320
#name "Masterwork Lightsabre"
#dmg 10
#att 2
#def 2
#len 1
#rcost 8
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/lightsabre.sw"
#end

#newweapon 1321
#name "Masterwork two-handed Lightsabre"
#twohanded
#nratt 2
#dmg 14
#att 3
#def 3
#len 2
#rcost 12
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/heavy_lightsabre.sw"
#end

#newweapon 1322
#name "Masterwork short Lightsabre"
#dmg 8
#att 2
#def 2
#len 1
#rcost 6
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/quick_lightsabre.sw"
#end

#newweapon 1323
#name "Masterwork double-bladed Lightsabre"
#twohanded
#dmg 10
#att 2
#def 2
#len 1
#rcost 12
#nratt 2
#armorpiercing
#fire
#magic
--#sound 8
#sample "./Firepower/double_lightsabre.sw"
#end

#newweapon 1324
#name "Bowcaster"
#twohanded
#ironweapon
#dmg 13
#att 3
#nratt 2
#range 45
#fire
#armorpiercing
#nostr
#ammo 10
#rcost 12
#sample "./Firepower/blaster.sw"
#flyspr 96 1
#explspr 10071
#end

#newweapon 1325
#name "Disruptor Rifle"
#twohanded
#ironweapon
#dmg 14
#att 3
#nratt 1
#range 50
#acid
#armorpiercing
#nostr
#ammo 10
#rcost 12
#sample "./Firepower/disruptor_rifle.sw"
#flyspr 404 3 -- acid arrow
#explspr 10064 -- green blob
#uwok
#end

#newweapon 1326
#name "Bash" -- for floating lightsabres, to stop them relying entirely on fire damage
#dmg -5
#att 0
#def 0
#len 0
#rcost 0
#bonus
#blunt
#sound 0
#end

#newweapon 1327
#name "Bayonet"
#ironweapon
#dmg 2
#att 0
#def 0
#len 2
#rcost 1
#pierce
#sound 12
#end

#newweapon 1328
#name "Rifle"
#ironweapon
#dmg 14
#att 3
#nratt 1
#twohanded
#range 50
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 12
--#sound 25
#sample "./Firepower/mosin1891.sw"
#flyspr -1
#uwok
#end

#newweapon 1330
#name "Maxim Gun"
#ironweapon
#dmg 10
#att 1
#nratt 10
#armorpiercing
#range 50
#pierce
#nostr
#ammo 10
#rcost 40
--#sound 27
#sample "./Firepower/mg_long.sw"
#flyspr -1
#uwok
#end

#newweapon 1331
#name "Slowed Maxim Gun"
#ironweapon
#dmg 10
#att 1
#nratt 5
#armorpiercing
#range 50
#pierce
#nostr
#ammo 10
#rcost 0
--#sound 27
#sample "./Firepower/mg_short.sw"
#flyspr -1
#uwok
#end

#newweapon 1332
#name "Crewman's Sword"
#ironweapon
#dmg 3
#att 0
#def 0
#len 1
#rcost 1
#bonus
#pierce
#slash
#sound 8
#end

#newweapon 1333
#name "Carbine"
#ironweapon
#dmg 11
#att 2
#nratt 1
#twohanded
#range 45
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 10
#range0
--#sound 25
#sample "./Firepower/mosin1930.sw"
#flyspr -1
#uwok
#end

#newweapon 1334
#name "Sword Cane"
#ironweapon
#dmg 3
#att 0
#def 0
#len 1
#rcost 1
#pierce
#slash
#sound 8
#end

#newweapon 1335
#name "Camel Bite"
#dmg 13
#att 1
#def 0
#len 0
#rcost 0
#nostr
#bonus
#slash
--#sound 8
#sample "./Firepower/camel.sw"
#end

#newweapon 1336
#name "Artillery Tube"
#bonus
#ironweapon
#dmg 14
#att 2
#nratt -2
#range 60
#fire
#nostr
#ammo 5
#rcost 25
#aoe 1
--#sound 27
#sample "./Firepower/cannon.sw"
#flyspr 100 1
#explspr 10113
#secondaryeffectalways 1338 -- Shrapnel 5
#uwok
#end

#newweapon 1338
#name "Shrapnel"
#dmg 12
#aoe 5
#nostr
#pierce
#slash
#explspr 10060
#sample "./Firepower/artillery_impact.sw"
#end

#newweapon 1340
#name "Revolver"
#ironweapon
#dmg 10
#att 2
#nratt 1
#range 45
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 4
--#sound 25
#sample "./Firepower/revolver.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1341 -- mosin nagant
#name "Rifle"
#ironweapon
#dmg 14
#att 3
#nratt 1
#twohanded
#range 50
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 12
#sample "./Firepower/mosin1930.sw"
#flyspr -1
#uwok
#end

#newweapon 1342 -- bayonet
#name "Bayonet"
#ironweapon
#dmg 2
#att 0
#def 0
#len 2
#rcost 1
#pierce
#sound 12
#end

#newweapon 1343
#name "Artillery Tube"
#bonus
#ironweapon
#dmg 15
#att 2
#nratt -2
#range 60
#fire
#nostr
#ammo 5
#rcost 30
#aoe 1
--#sound 27
#sample "./Firepower/cannon.sw"
#flyspr 100 1
#explspr 10113
#secondaryeffectalways 1337 -- Shrapnel 6
#uwok
#end

#newweapon 1337
#name "Shrapnel"
#dmg 12
#aoe 6
#nostr
#pierce
#slash
#explspr 10060
#sample "./Firepower/artillery_impact.sw"
#end

#newweapon 1344
#name "Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 10
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 40
--#sound 27
#sample "./Firepower/mg_long.sw"
#flyspr -1
#uwok
#end

#newweapon 1345
#name "Slow Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 5
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 0
--#sound 27
#sample "./Firepower/mg_short.sw"
#flyspr -1
#uwok
#end

#newweapon 1346
#name "Crewman's Sword"
#ironweapon
#dmg 3
#att 0
#def 0
#len 1
#rcost 1
#bonus
#pierce
#slash
#sound 8
#end

#newweapon 1347
#name "Tank Cannon"
#ironweapon
#dmg 14
#att 2
#nratt -2
#range 60
#bonus
#fire
#nostr
#ammo 5
#rcost 20
#aoe 1
--#sound 27
#sample "./Firepower/tank_cannon.sw"
#flyspr 100 1
#explspr 10113
#secondaryeffectalways 1338 -- Shrapnel 5
#uwok
#end

#newweapon 1348
#name "Tank Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 8
#armorpiercing
#range 50
#bonus
#pierce
#nostr
#ammo 15
#rcost 15
--#sound 27
#sample "./Firepower/tank_mg.sw"
#flyspr -1
#range0
#uwok
#end

#newweapon 1349
#name "Vehicle Ram"
#dmg 0
#att 0
#def 0
#len 0
#rcost 0
#unrepel
#norepel
#bonus
#blunt
#sound 1
#end

#newweapon 1350
#name "Small Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 3
#armorpiercing
#range 35
#pierce
#twohanded
#nostr
#ammo 8
#rcost 15
--#sound 25
#sample "./Firepower/ppsh.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1351
#name "Grenade"
#ironweapon
#dmg 10
#att 0
#nratt 1
#range -1
#nostr
#ammo 1
#rcost 4
#aoe 1
#fire
#secondaryeffectalways 1309 -- Shrapnel 1
--#sound 15
#sample "./Firepower/grenade.sw"
#flyspr 99 1
#explspr 10113
#skip
#end

#newweapon 1352
#name "Flamethrower"
#ironweapon
#dmg 10
#att 0
#nratt 1
#range 6
#beam
#twohanded
#armorpiercing
#fire
#magic
#aoe 4
#nostr
#ammo 4
#rcost 20
--#sound 16
#sample "./Firepower/flamethrower.sw"
#explspr 10131
#range0
#secondaryeffect 139 -- greater fear
#end

#newweapon 1353
#name "Scoped Rifle"
#ironweapon
#dmg 16
#att 4
#nratt 1
#twohanded
#range 60
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 15
--#sound 25
#sample "./Firepower/mosin1891.sw"
#flyspr -1
#uwok
#end

#newweapon 1354
#name "Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 8
#bonus
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 15
--#sound 27
#sample "./Firepower/tank_mg.sw"
#flyspr -1
#range0
#uwok
#end

#newweapon 1355
#name "Anti-Materiel Rifle"
#ironweapon
#magic
#dmg 16
#att 15
#nratt 1
#twohanded
#range 50
#pierce
#armorpiercing
#nostr
#ammo 10
--#sound 25
#sample "./Firepower/mosin1891.sw"
#secondaryeffectalways 171 -- small area fire
#flyspr -1
#uwok
#end

#newweapon 1356
#name "Rifle"
#ironweapon
#dmg 14
#att 3
#nratt 1
#twohanded
#range 50
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 12
--#sound 25
#sample "./Firepower/mauser.sw"
#flyspr -1
#uwok
#end

#newweapon 1357
#name "Small Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 3
#armorpiercing
#range 35
#pierce
#twohanded
#nostr
#ammo 8
#rcost 15
--#sound 25
#sample "./Firepower/mp40.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1358
#name "Tank Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 8
#armorpiercing
#range 50
#bonus
#pierce
#nostr
#ammo 15
#rcost 15
--#sound 27
#sample "./Firepower/mg_german.sw"
#flyspr -1
#range0
#uwok
#end

#newweapon 1359
#name "Small Tank Cannon"
#ironweapon
#dmg 12
#att 2
#nratt -2
#range 50
#bonus
#fire
#nostr
#ammo 5
#rcost 20
#aoe 1
--#sound 27
#sample "./Firepower/tank_cannon.sw"
#flyspr 100 1
#explspr 10113
#secondaryeffectalways 1339 -- Shrapnel 4
#uwok
#end

#newweapon 1339
#name "Shrapnel"
#dmg 12
#aoe 4
#nostr
#pierce
#slash
#explspr 10060
#sample "./Firepower/artillery_impact.sw"
#end

#newweapon 1360
#name "Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 10
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 40
--#sound 27
#sample "./Firepower/mg_german.sw"
#flyspr -1
#uwok
#end

#newweapon 1361
#name "Slow Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 5
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 0
--#sound 27
#sample "./Firepower/mg_german.sw"
#flyspr -1
#uwok
#end

#newweapon 1362
#name "Airyaplane Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 8
#armorpiercing
#range 50
#bonus
#pierce
#nostr
#ammo 20
#rcost 15
--#sound 27
#sample "./Firepower/mg_german.sw"
#flyspr -1
#range0
#uwok
#end

#newweapon 1363
#name "Walking Stick"
#woodenweapon
#dmg -3
#att 0
#def 0
#len 1
#rcost 0
#blunt
#sound 9
#end

#newweapon 1364
#name "Automatic Rifle"
#ironweapon
#dmg 12
#att 2
#nratt 3
#armorpiercing
#range 45
#pierce
#twohanded
#nostr
#ammo 8
#rcost 21
--#sound 25
#sample "./Firepower/stg44.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1365
#name "Rifle"
#ironweapon
#dmg 14
#att 3
#nratt 1
#twohanded
#range 50
#pierce
#armorpiercing
#nostr
#ammo 10
#rcost 12
--#sound 25
#sample "./Firepower/garand.sw"
#flyspr -1
#uwok
#end

#newweapon 1366
#name "Small Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 3
#armorpiercing
#range 35
#pierce
#twohanded
#nostr
#ammo 8
#rcost 15
--#sound 25
#sample "./Firepower/thompson.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1367
#name "Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 10
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 40
--#sound 27
#sample "./Firepower/vickers.sw"
#flyspr -1
#uwok
#end

#newweapon 1368
#name "Slow Autogun"
#ironweapon
#dmg 10
#att 1
#nratt 5
#armorpiercing
#range 50
#pierce
#nostr
#ammo 15
#rcost 0
--#sound 27
#sample "./Firepower/vickers.sw"
#flyspr -1
#uwok
#end

#newweapon 1369
#name "Automatic Rifle"
#ironweapon
#dmg 12
#att 2
#nratt 3
#armorpiercing
#range 45
#pierce
#twohanded
#nostr
#ammo 8
#rcost 21
--#sound 25
#sample "./Firepower/bar.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1370
#name "Clipboard"
#woodenweapon
#dmg -5
#att 0
#def 0
#len 0
#rcost 0
#blunt
#sound 9
#end

#newweapon 1371
#name "Stun Prod"
#ironweapon
#armornegating
#unrepel
#nostr
#dmg 5
#att 4
#def 0
#len 0
#rcost 5
#shock
#sound 24
#secondaryeffect 1372
#end

#newweapon 1372
#name "Stunning Shock"
#armornegating
#shock
#mrnegates
#dmg 50
#dt_stun
#nostr
#end

#newweapon 1373
#name "Holy Book"
#woodenweapon
#dmg -4
#att 0
#def 0
#len 0
#rcost 3
#blunt
#sound 1
#secondaryeffectalways 276 -- small area holy fire
#end

#newweapon 1374
#name "Stun Grenade"
#ironweapon
#poison
#armornegating
#dt_stun
#dmg 20
#att 0
#nratt 1
#range -1
#nostr
#ammo 1
#rcost 4
#aoe 1
--#sound 15
#sample "./Firepower/grenade.sw"
#flyspr 99 1
#explspr 10114
#secondaryeffectalways 1375 -- Blinding Flash
#skip
#end

#newweapon 1375
#name "Blinding Flash"
#dmg 4096
#dt_aff
#mrnegates
#end

#newweapon 1376
#name "Speargun"
#dmg 12
#att 1
#nratt 1
#twohanded
#range 20
#pierce
#nostr
#ammo 5
#rcost 6
#sound 46 -- blowpipe
#flyspr 403 1
#uwok
#end

#newweapon 1377
#name "Speargun Tip"
#dmg 2
#att 0
#def 0
#len 2
#rcost 1
#pierce
#sound 12
#end

#newweapon 1378
#name "Automatic Rifle"
#ironweapon
#dmg 12
#att 2
#nratt 3
#armorpiercing
#range 45
#pierce
#twohanded
#nostr
#ammo 8
#rcost 21
--#sound 25
#sample "./Firepower/ak47.sw"
#range0
#flyspr -1
#uwok
#end

#newweapon 1308
#name "Rocket Launcher"
#bonus
#ironweapon
#dmg 15
#att -1
#nratt -3
#range 60
#fire
#nostr
#ammo 4
#rcost 30
#aoe 3
--#sound 27
#sample "./Firepower/rocket_launcher.sw"
#flyspr 350 4
#explspr 10106 -- orange explosion
--#explspr 10103 -- red explosion
#secondaryeffectalways 1339 -- Shrapnel 4
#end

#newweapon 1329
#name "Pistol"
#ironweapon
#dmg 14
#att 20
#nratt 1
#range 45
#pierce
#armorpiercing
#nostr
#ammo 12
#rcost 6
--#sound 25
#sample "./Firepower/colt45.sw"
#flyspr -1
#end

#newweapon 1379
#name "Pair of Pistols"
#ironweapon
#dmg 14
#att 10
#nratt 2
#range 45
#pierce
#armorpiercing
#nostr
#ammo 12
#rcost 12
--#sound 25
#sample "./Firepower/2_gunshots.sw"
#flyspr -1
#end

#newweapon 1380
#name "Lever-Action Rifle"
#ironweapon
#dmg 14
#att 25
#nratt 2
#range 50
#pierce
#armorpiercing
#nostr
#ammo 15
#rcost 15
--#sound 25
#sample "./Firepower/winchester.sw"
#flyspr -1
#end


----- ARMOUR -----

#newarmor 615
#name "Diving Helmet"
#type 6
#prot 18
#enc 0
#def -1
#rcost 5
#end

#newarmor 616
#name "Seal Mask"
#type 6
#prot 10
#enc 0
#def -1
#rcost 4
#end

#newarmor 617
#name "Seal Armour"
#type 5
#prot 10
#enc 1
#def 0
#rcost 6
#end

#newarmor 618
#name "Diving Suit"
#type 5
#prot 18
#enc 4
#def -3
#rcost 18
#end

#newarmor 619
#name "Vampir Mask"
#type 6
#prot 12
#enc 0
#def -1
#rcost 5
#end

#newarmor 620
#name "Cloth Uniform"
#type 5
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 621
#name "Reinforced Uniform"
#type 5
#prot 5
#enc 0
#def 0
#rcost 1
#end

#newarmor 622
#name "Peaked Cap"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 623
#name "Iron Helmet"
#type 6
#prot 12
#enc 0
#def 0
#rcost 2
#end

#newarmor 624
#name "Anti-Magic Uniform"
#type 5
#prot 8
#enc 2
#def -1
#rcost 10
#end

#newarmor 625
#name "Cap"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 626
#name "Glasses"
#type 6
#prot 1
#enc 0
#def 0
#rcost 0
#end

#newarmor 627
#name "Clothes"
#type 5
#prot 1
#enc 0
#def 0
#rcost 0
#end

#newarmor 628
#name "Hat"
#type 6
#prot 1
#enc 0
#def 0
#rcost 0
#end

#newarmor 629
#name "Lightning Armour"
#type 5
#prot 8
#enc 3
#def -3
#rcost 10
#end

#newarmor 660
#name "Uniform"
#type 5
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 661
#name "Visor"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 662
#name "Cap"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 663
#name "Uniform"
#type 5
#prot 5
#enc 0
#def 0
#rcost 1
#end

#newarmor 664
#name "Pith Helmet"
#type 6
#prot 10
#enc 0
#def 0
#rcost 1
#end

#newarmor 665
#name "Shako"
#type 6
#prot 8
#enc 0
#def 0
#rcost 1
#end

#newarmor 666
#name "Mourning Robes"
#type 5
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 667
#name "Mourning Hood"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 668
#name "Suit"
#type 5
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 669
#name "Top Hat"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 670
#name "Hat"
#type 6
#prot 3
#enc 0
#def 0
#rcost 0
#end

#newarmor 671
#name "Bearskin Hat"
#type 6
#prot 10
#enc 0
#def 0
#rcost 1
#end


#newarmor 672
#name "Cowboy Hat"
#type 6
#prot 6
#enc 0
#def 0
#rcost 0
#end

#newarmor 673
#name "Poncho"
#type 5
#prot 6
#enc 0
#def 0
#rcost 0
#end

#newarmor 674
#name "Clothes"
#type 5
#prot 6
#enc 0
#def 0
#rcost 0
#end

-------- PRETENDERS ------

-- Divine Glyph

#newmonster 6589
#copystats 1025
#nametype 252 -- ideologies
#spr1 "./Firepower/sovirus/glyphidle.tga"
#spr2 "./Firepower/sovirus/glyphattack.tga"
#name "Transcendent Glyph"
#descr "The Transcendent Glyph is a divine spirit that manifests itself as a burning glyph. The sacred word is unutterable and unbearable to behold. Its very essence is beyond comprehension. At times, the spirit inspires a devout human to write manuscripts and manifestos. Anyone trying to strike the blazing glyph will be punished with blindness. The Transcendent Glyph is a powerful wielder of Astral and Fire magic."
#homerealm 0
#end

-- Divine Emperor 

#newmonster 6588
#copystats 874
#nametype 258 -- communist dictators
#spr1 "./Firepower/sovirus/leninidle.tga"
#spr2 "./Firepower/sovirus/leninattack.tga"
#name "Divine Leader"
#descr "The Divine Leader is the ruler of the nation. He led the revolution against the princes of Bogarus and their false god. He created the Cheka to destroy the last traces of the old god and to consolidate his power. With power comes arrogance and now he claims godhood himself. The Divine Leader is not a warrior and only travels by palanquin."
#homerealm 0
#end

-- Colossal Hitler 

#newmonster 6663
#copystats 958
#spr1 "./Firepower/ulmreich/hitler.tga"
#spr2 "./Firepower/ulmreich/hitler.tga"
#name "Colossal Hitler"
#descr "The Colossal Hitler is a powerful spirit that inhabits a massive stone that has been chiseled into the shape of a head. The spirit cannot leave the Colossal Hitler, but it can possess willing targets in order to make its will heard and to perform tasks such as forging items for enchantment. The spirit is tremendously strong in its Dominion and it is also magically powerful. In a physical battle, the head would be difficult to destroy, even though it cannot strike back."
#homerealm 0
#end

-------- HEROES ----------

-- Felix Dzerzhinsky

#newmonster 6594
#name "Lion of the Revolution"
#spr1 "./Firepower/sovirus/hero1idle.tga"
#spr2 "./Firepower/sovirus/hero1attack.tga"
#nametype 146
#descr "The princes of Bogarus maintained their position with ruthless violence, secret police, and religious propaganda. Wherever peasants or Peshtsi gathered to voice grievances or plot rebellion, the Druzhina and Klysty responded with furious retribution. Feliks was once a young Druzhina tasked with breaking up the subterfuge of such revolutionaries. When he refused to kill the enemies of the princes he was imprisoned and tortured for years. When the revolution swept away the princes, he was freed. Now he uses the skills the princes taught him to unleash oceans of their blood as the Lion of the Revolution. His personal motto is 'cool heads, hot hearts'."
#fixedname "Feliks"
#unique
#goodleader
#okundeadleader
#inspirational 2
#magicskill 5 1
#magicskill 8 3
#magicskill 9 2
#holy
#patrolbonus 20
#hp 12
#size 3
#prot 0
#mor 16
#mr 14
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#coldres 3
#weapon 8
#weapon 1340
#armor 621
#startage 35
#end

-- New Sovirus Demon

#newmonster 6591
#name "New Sovirus Man"
#spr1 "./Firepower/sovirus/hero2idle.tga"
#spr2 "./Firepower/sovirus/hero2attack.tga"
#nametype 146
#descr "Sergeant Ivan is widely acclaimed as a national hero for leading hundreds of reckless charges in dozens of wars. No one knows how he survives against the impossible odds, but he is respected beyond his rank by the troops. The Chekists who parade him around the barracks and city streets to inspire ordinary citizens say he is just a simple soldier taking a stand in defence of the Awakening God and the Motherland. The truth is far more sinister, but the specifics are not known as the records of his 'recruitment' were destroyed, and he refuses to speak of his history as if compelled by a geas. He is perfectly loyal and a tenacious fighter."
#fixedname "Ivan"
#unique
#goodleader
#okundeadleader
#inspirational 2
#holy
#hp 20
#size 3
#prot 0
#mor 30
#mr 15
#enc 1
#str 15
#att 12
#def 12
#prec 12
#mapmove 22
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#fireres 10
#demon
#neednoteat
#immortal
#weapon 1350 -- ppsh
#weapon 6 -- short sword
#armor 9 -- plate cuirass
#startage 2000
#maxage 5000
#end

-- Stalin/Trotsky ettin

#newmonster 6585
#name "Great Old Bolshevik"
#spr1 "./Firepower/sovirus/hero3idle.tga"
#spr2 "./Firepower/sovirus/hero3attack.tga"
#nametype 146
#descr "Stalotsky, the Revolutionary and Intellectual, or the Great Old Bolshevik, is a freak giant captured by a brave Chekist Investigator when it was still young. Brought to the local Party cadres for execution, the snivelling and crying baby giant was a cause for great amusement. It was given mercy and was reared in the Chekist headquarters to be educated in the methods of revolutionary science. Over the years Stalotsky has become a noted Party functionary and author. He has been given a giant hammer and sickle and a tale to hold true. Now he is allowed to believe that the two of them command the great nation of Sovirus. He is brought out of the Chekist headquarters once every year to receive the adoration of the crowds. Onions and turnips, his favourite food, are thrown at him by his comrades, and the revolutionary half of him rejoices as he is hailed as the greatest revolutionary in history. The intellectual head of his mutters that he would prefer a fish diet brought by tasty bourgeoisie. Stalotsky is always accompanied by a retinue of Guards that try to prevent him from doing too much damage to comrades and their national movements."
#fixedname "Stalotsky"
#unique
#poorleader
#eyes 4
#ambidextrous 6
#appetite 3
#batstartsum4 6551 -- guards rifles
#mountainsurvival
#forestsurvival
#hp 62
#size 6
#prot 6
#mor 14
#mr 14
#enc 3
#str 23
#att 13
#def 8
#prec 11
#mapmove 18
#ap 16
#rpcost 10000
#gcost 0
#rcost 0
#itemslots 15750
#weapon 13 -- hammer
#weapon 57 -- sickle
#armor 44 -- furs
#armor 622 -- peaked cap
#armor 626 -- glasses
#startage 45
#maxage 100
#end

-- Sniper hero

#newmonster 6583
#name "Red Death"
#spr1 "./Firepower/sovirus/hero4idle.tga"
#spr2 "./Firepower/sovirus/hero4attack.tga"
#nametype 146
#descr "Roza took up arms against raiders from Ulm after they killed her whole village. She managed to fend them off with her dead brother's rifle, picking them off one at a time while hidden beneath a snowdrift. She was allowed to join the regular Sovirus forces where she demonstrated her skills by assassinating leaders of raiding armies. She was deemed too valuable to lose in skirmishes against raiders and was promoted out of the front line. Now she trains talented Marksmen in the arts of stealth and patience. She is accompanied in combat by a small cadre of Snipers in training."
#fixedname "Roza"
#female
#unique
#okleader
#snow
#forestsurvival
#stealthy 20
#assassin
#patience 3
#holy
#hp 11
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 10
#att 12
#def 12
#prec 14
#mapmove 18
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#coldres 3
#weapon 1353 -- scoped rifle
#weapon 1342 -- bayonet
#armor 620
#armor 625 -- cap
#startage 30
#batstartsum2 6584
#end

-- Ghoul general

#newmonster 6582
#name "Ghoul General"
#spr1 "./Firepower/sovirus/hero5idle.tga"
#spr2 "./Firepower/sovirus/hero5attack.tga"
#nametype 146
#descr "General Shapochevsky has had many ups and downs in his life and unlife. He joined the revolution against Bogarus as a young colonel and took his Peshtsi regiment with him. He was promoted rapidly thanks to his strategic and administrative skills, becoming Chief of Staff for the Sovirus armies by the age of 35. This senior position soon became embroiled in political intrigue and he fell from favour, being demoted back to captain. Still hounded by his rivals, and faced with torture and execution, he agreed to allow the Chekists to perform necromantic rituals of rebirth upon him in exchange for immunity from prosecution. Expecting a mercifully quick death at their hands, he was surprised to discover himself one of the first successes of the ghoulification programme and was given command over the new corps. He has since killed and eaten several of his political rivals including his replacement Chief of Staff."
#fixedname "Shapochevsky"
#unique
#superiorleader
#superiorundeadleader
#ambidextrous 2
#holy
#hp 20
#size 3
#prot 1
#mor 25
#mr 14
#enc 0
#str 15
#att 12
#def 12
#prec 11
#mapmove 22
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#coldres 3
#poisonres 25
#undead
#neednoteat
#weapon 43 -- poisoned claw
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 50
#maxage 500
#end

-- Hermann Goering

#newmonster 6647
#name "Soaring General"
#spr1 "./Firepower/ulmreich/hero1idle.tga"
#spr2 "./Firepower/ulmreich/hero1attack.tga"
#descr "Hermann the Soaring is a veteran of campaigns against Ermor, where he was instrumental in establishing the Lightning Guard as a unified force. Later, he used his fame to gain personal power and became an accomplished politician within the Airyan Sect. He is a powerful Air mage."
#fixedname "Hermann"
#unique
#superiorleader
#holy
#flying
#hp 12
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 24
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#magicskill 1 3
#shockres 9
#weapon 1357 -- mp40
#weapon 6 -- short sword
#armor 622 -- peaked cap
#armor 629 -- lightning armour
#startage 40
#end

-- Ernst Roehm

#newmonster 6648
#name "Roaming Brownshirt"
#spr1 "./Firepower/ulmreich/hero2idle.tga"
#spr2 "./Firepower/ulmreich/hero2attack.tga"
#descr "Ernst the Roamer is the leader of the Brownshirts. His veneration of the Awakening God is obessive and fanatical. He walks from village to village spreading the Word of God and destroying undead wherever they can be found. He has a close relationship with all the Brownshirt militia leaders but is hated by the Generals of the army as they believe his popular appeal damages their prestige."
#fixedname "Ernst"
#unique
#expertleader
#holy
#magicskill 9 3
#hp 12
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 8
#weapon 1340
#armor 620
#startage 35
#end

-- Heinrich Himmler

#newmonster 6649
#name "Secret Police General"
#spr1 "./Firepower/ulmreich/hero3idle.tga"
#spr2 "./Firepower/ulmreich/hero3attack.tga"
#descr "The Secret Police were created by the Airyan Sect to root out blood traitors in order to prevent a second Malediction taking root within Ulmreich. General Heinrich has expanded his power far beyond this scope, however. The Secret Police are themselves dabbling in many of the blood magic rituals associated with the Malediction. They are able to gather blood slaves under the guise of destroying enemies of Ulmreich. The Sect tolerates this because the Secret Police achieve such remarkable results for the Reich through their methods. General Heinrich also commands the Airyan Guard, the most trusted arm of Ulmreich's military forces."
#fixedname "Heinrich"
#unique
#goodleader
#okundeadleader
#holy
#douse 2
#taxcollector
#stealthy 30
#magicskill 8 3
#magicskill 9 2
#popkill 3
#incunrest -30
#hp 12
#size 3
#prot 0
#mor 15
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#armor 620
#armor 626
#startage 35
#end

-- Russian defector/communist sympathiser

#newmonster 6562
#name "Occult Academician"
#spr1 "./Firepower/manica/scientist3idle.tga"
#spr2 "./Firepower/manica/scientist3attack.tga"
#descr "Academician Igor fled from the civil war engulfing Bogarus soon after completing his magical studies under the alchemists and occultists of that fractured land. Although sympathetic to the revolutionists' cause, he feared for his safety after many of his aristocratic student friends were killed by zealous and paranoid Chekists. While a competent Fire and Earth mage, the main focus of his research is into the very same necromantic rituals the Chekists became obsessed with in his homeland. This new and taboo form of magic intrigued the scientific community in Manica and he eagerly shares his knowledge with those willing to learn from him. He has developed an enmity with Ulmish exile Wernher, as they compete to gather students under their tutelage. So long as the two are rivals, the Agency is content to let them bicker over petty differences without interfering in their heresies."
#fixedname "Igor"
#unique
#heretic 1
#poorleader
#poorundeadleader
#magicskill 0 2
#magicskill 3 2
#magicskill 5 3
#resources 5
#hp 9
#size 3
#prot 0
#mor 12
#mr 14
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1370 -- clipboard
#armor 627 -- clothes
#armor 626 -- glasses
#startage 50
#end

-- Wernher von Braun

#newmonster 6561
#name "Airyan Academician"
#spr1 "./Firepower/manica/scientist4idle.tga"
#spr2 "./Firepower/manica/scientist4attack.tga"
#descr "Wernher was a wealthy factory owner in Ulm until he was captured in a fierce battle with Manica's armed forces. The Mounted Infantrymen who broke through the Ulmish lines and imprisoned him returned with fantastic tales of flying constructs which could carry men into the heavens, of devices strapped to the backs of Ulmish fanatics which let them leap into the sky without wings, and of a ritual site where giant grenades were being constructed to rain fiery death upon armies hundreds of leagues away. The Agents who interrogated Wernher confirmed these tales, and demanded Wernher serve Manica to reproduce his marvels for the good of the Awakening God. He agreed, but since then he has also been secretly sharing the doctrines of the Ulmish priesthood with his fellow academics, doctrines of Blood and Earth and the divinity of flight. He has developed an enmity with Bogarusian exile Igor, as they compete to gather students under their tutelage. So long as the two are rivals, the Agency is content to let them bicker over petty differences without interfering in their heresies."
#fixedname "Wernher"
#unique
#heretic 1
#poorleader
#poorundeadleader
#magicskill 0 2
#magicskill 1 2
#magicskill 8 3
#resources 5
#hp 11
#size 3
#prot 0
#mor 12
#mr 13
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1370 -- clipboard
#armor 627 -- clothes
#armor 626 -- glasses
#startage 50
#end

-- Captain America

#newmonster 6560
#copystats 954 -- son of titans, arcoscephale hero
#spr1 "./Firepower/manica/hero1idle.tga"
#spr2 "./Firepower/manica/hero1attack.tga"
#name "Avenger"
#fixedname "Captain Manica"
#descr "Captain Manica is the physical embodiment of the nation. He is nigh immortal, a skilled melee fighter, a master of strategy and tactics, and utterly fearless. He sows terror amongst the enemies of the Awakening God wherever he goes. Heretics and dissidents fear his rage, and he slays a score of them every month, which judges usually rule as self-defence because he only visits open carry provinces. Some believe him to be the offspring of a Titan or Angel, and he is sacred to the citizens. His appearance on the battlefield turns every patriot into a hero."
#holy
#magicskill 9 3
#popkill 2
#incunrest -10
#end

-------- UNITS ----------

----------------------------- Sovirus units -----------------------------

-- Conscript Spear

#newmonster 6593
#name "Conscript Spearman"
#spr1 "./Firepower/sovirus/soldier1idle.tga"
#spr2 "./Firepower/sovirus/soldier1attack.tga"
#nametype 146
#descr "The Chekists have the authority to conscript peasants into militia units equipped with whatever is at hand. Poorly trained and armed, they are slow to move strategically, although the conscripts can be raised even in provinces without forts."
#undisciplined
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 5
#gcost 7
#rcost 1
#coldres 3
#weapon 1
#armor 620
#armor 622
#startage 22
#end

-- Conscript Rifle

#newmonster
#name "Conscript Rifleman"
#spr1 "./Firepower/sovirus/soldier2idle.tga"
#spr2 "./Firepower/sovirus/soldier2attack.tga"
#nametype 146
#descr "The Chekists have the authority to conscript peasants into militia units equipped with whatever is at hand. The rural Rus have many hunters that make good use of their rifles. They are slow to move strategically due to lack of training, although as conscripts they can be raised even in provinces without forts."
#undisciplined
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 8
#gcost 9
#rcost 1
#coldres 3
#weapon 1341 -- mosin nagant
#weapon 1342 -- bayonet
#armor 620
#armor 622
#startage 22
#end

-- Rifle Infantry

#newmonster
#name "Rifle Infantryman"
#spr1 "./Firepower/sovirus/soldier3idle.tga"
#spr2 "./Firepower/sovirus/soldier3attack.tga"
#nametype 146
#descr "The rank and file of Sovirus are expected to march for great distances, fight long battles and remain loyal to the Awakening God through thick and thin. Their training and equipment is of higher quality than that of the conscripts, and they have been drilled with their bayonets. They could probably land a hit or two in the melee. Infantrymen are volunteers recruited from both the cities and peasants."
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 15
#rcost 1
#coldres 3
#weapon 1341 -- mosin nagant
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 25
#end

-- NBC trooper

#newmonster 6587
#name "Anti-Magic Infantryman"
#spr1 "./Firepower/sovirus/soldier9idle.tga"
#spr2 "./Firepower/sovirus/soldier9attack.tga"
#nametype 146
#descr "The many dangers facing Sovirus infantry are not limited to physical weapons. Poisons and elemental magic have been identified as a major threat to the success of the armies of the Awakening God. This protective suit has been developed to mitigate some of the risks posed by poison, fire, cold, shock and other forms of magic. It is still not very effective against blades and bolts, and it is very bulky and tiring to wear in battle."
#hp 12
#size 3
#prot 0
#mor 12
#mr 15
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 30
#rcost 0
#coldres 12
#fireres 12
#shockres 12
#poisonres 12
#weapon 1341 -- mosin nagant
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 624
#armor 623
#startage 30
#end

-- Assault Engineer

#newmonster
#name "Assault Engineer"
#spr1 "./Firepower/sovirus/soldier7idle.tga"
#spr2 "./Firepower/sovirus/soldier7attack.tga"
#nametype 146
#descr "Some roles within the Sovirus armies demand a higher level of survivability, whether due to proximity to the enemy or because the soldiers are handling explosives. Assault Engineers combine these two dangers and are equipped with solid iron plates for protection when they are charging enemy lines with carbine and grenade. Adept at both constructing and demolishing fortifications, they are veterans prized by any competent general."
#castledef 2
#siegebonus 2
#hp 12
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 20
#rcost 1
#coldres 3
#weapon 1350 -- ppsh
#weapon 1351 -- grenade
#weapon 9 -- dagger
#armor 623
#armor 9 -- plate cuirass (15 res, 14 prot, -1 def, 2 enc)
#startage 30
#end

-- Flamethrower (Sovirus)

#newmonster 6586
#name "Flame Engineer"
#spr1 "./Firepower/sovirus/flamethroweridle.tga"
#spr2 "./Firepower/sovirus/flamethrowerattack.tga"
#nametype 146
#descr "The flamethrower is a terror weapon used by specialist Assault Engineers to keep the enemy out of melee range. The Flame Engineer wears strong iron plate armour on top of a flame-proofed uniform and mask. Other friendly troops engulfed by the flamethrower may not be so fortunate, so care should be taken to position these Engineers in the frontmost ranks. The flames emitted by the weapon are imbued with the power of socialism and will harm ethereal beings."
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 45
#rcost 1
#coldres 3
#fireres 12
#weapon 9 -- dagger
#weapon 1352
#armor 623
#armor 9 -- plate cuirass (15 res, 14 prot, -1 def, 2 enc)
#startage 30
#deathfire 3
#end

-- Regimental Banner

#newmonster
#name "Regimental Banner"
#spr1 "./Firepower/sovirus/flag2idle.tga"
#spr2 "./Firepower/sovirus/flag2attack.tga"
#nametype 146
#descr "The history and battles of each Sovirus formation are proudly flown on gilt-thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from an Infantry regiment."
#aisinglerec
#standard 1
#hp 10
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 20
#rcost 4
#coldres 3
#weapon 1341 -- mosin nagant
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 25
#end

-- Assault Engineers Banner

#newmonster
#name "Assault Banner"
#spr1 "./Firepower/sovirus/flag3idle.tga"
#spr2 "./Firepower/sovirus/flag3attack.tga"
#nametype 146
#descr "The history and battles of each Sovirus formation are proudly flown on gilt-thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from an Assault Engineers regiment."
#aisinglerec
#standard 1
#castledef 2
#siegebonus 2
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 25
#rcost 4
#coldres 3
#weapon 1350 -- ppsh
#weapon 1351 -- grenade
#weapon 9 -- dagger
#armor 623
#armor 9 -- plate cuirass (15 res, 14 prot, -1 def, 2 enc)
#startage 30
#end

-- Guards Banner

#newmonster
#name "Guards Banner"
#spr1 "./Firepower/sovirus/flag1idle.tga"
#spr2 "./Firepower/sovirus/flag1attack.tga"
#nametype 146
#descr "The history and battles of each Sovirus formation are proudly flown on gilt-thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from a Guards regiment."
#aisinglerec
#formationfighter 1
#patrolbonus 2
#standard 1
#holy
#hp 12
#size 3
#prot 0
#mor 14
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 30
#rcost 4
#coldres 3
#weapon 1341 -- mosin nagant
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 30
#end

-- Marksman

#newmonster 6584
#name "Marksman"
#spr1 "./Firepower/sovirus/soldier4idle.tga"
#spr2 "./Firepower/sovirus/soldier4attack.tga"
#nametype 146
#descr "Soldiers with especially good eyesight and steady hands are selected for more training than the ordinary forces. They learn how to live off the land, move quickly, hide from prying eyes, and infiltrate enemy lines. They are then deployed in special situations, outside the regular battle formation. They are rugged enough to move rapidly through forests. Their rifles are improved with Air magic to let them fire further."
#snow
#forestsurvival
#stealthy
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 12
#mapmove 16
#ap 12
#rpcost 15
#gcost 15
#rcost 1
#coldres 3
#weapon 1353 -- scoped rifle
#weapon 1342 -- bayonet
#armor 620
#armor 622
#startage 25
#end

-- Guards Rifle

#newmonster 6551
#name "Guards Rifleman"
#spr1 "./Firepower/sovirus/soldier5idle.tga"
#spr2 "./Firepower/sovirus/soldier5attack.tga"
#nametype 146
#descr "The city dwellers led the uprising against the old princes of Bogarus. The prestige and power this won them encourages them to volunteer for the defence of their homeland. Their formations are often designated as Guards, which draw from the cream of Rus soldiery. Those who can prove themselves loyal enough to be selected for this honour are much better trained than rank and file soldiers, and steadfast in their service to the Awakening God and the nation in general. As they are more reliable, they are often used by Chekists to round up conscripts, search for spies, and prevent broken Infantrymen from deserting."
#holy
#formationfighter 1
#patrolbonus 2
#hp 12
#size 3
#prot 0
#mor 13
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 25
#rcost 1
#weapon 1341 -- mosin nagant
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 25
#coldres 3
#end

-- Infantry Commander

#newmonster
#name "Infantry Commander"
#spr1 "./Firepower/sovirus/officer1idle.tga"
#spr2 "./Firepower/sovirus/officer1attack.tga"
#nametype 146
#descr "Some volunteers are marked out from the rank and file on the basis of intelligence, charisma, or loyalty. Officers of Sovirus are trained in military schools to lead armies, but do not receive much in the way of equipment or special skills."
#goodleader
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 30
#end

-- Guards Commander

#newmonster
#name "Guards Commander"
#spr1 "./Firepower/sovirus/officer2idle.tga"
#spr2 "./Firepower/sovirus/officer2attack.tga"
#nametype 146
#descr "Officers in training who show especial fanaticism towards the Awakening God and Sovirus become commanders in Guards Rifles formations. They have priestly skills and good leadership, but must rely on the unbroken mass of soldiers to protect them as they have no armour. Guards are much more reliable than the regular Infantry and their officers are entrusted with important tasks such as leading the vanguard of an attack, or securing the rear areas against cowardly Forest Anarch wreckers."
#expertleader
#inspirational 1
#magicskill 9 1
#patrolbonus 10
#holy
#hp 12
#size 3
#prot 0
#mor 14
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10000
#rcost 1
#coldres 3
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 40
#end

-- Marksman Officer

#newmonster
#name "Sniper"
#spr1 "./Firepower/sovirus/soldier4idle.tga"
#spr2 "./Firepower/sovirus/soldier4attack.tga"
#nametype 146
#descr "Marksmen with long experience and a history of reliability are selected as commanders of their fellows and designated as Snipers. They move in small groups, attempting to scout enemy formations and assassinate leaders. They do not receive training in the military academies and cannot lead large numbers of soldiers, but are very good shots with their rifles."
#poorleader
#snow
#forestsurvival
#stealthy 10
#assassin
#patience 2
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 13
#mapmove 18
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 1353 -- scoped rifle
#weapon 1342 -- bayonet
#armor 620
#armor 622
#startage 30
#end

-- Anarchist Soldier

#newmonster
#name "Forest Brother"
#spr1 "./Firepower/sovirus/soldier6idle.tga"
#spr2 "./Firepower/sovirus/soldier6attack.tga"
#nametype 146
#descr "After the princes of Bogarus were all shot by the Sovi revolutionaries, disagreements surfaced between factions. The city dwellers wanted their leadership in the revolt recognised and they tried to force the peasants and forest bandits to obey their laws. Many bandits refused to give up their easy lives of plunder and slipped back to their old ways. With the threat to the Rus people from the foreign Pretender Gods, these Forest Brothers are willing to join forces with the Sovi once more, but they still chafe under the laws of the Chekists. After fighting one battle, the Forest Brothers will slip away from the regular formations to avoid persecution by the authorities, and must be called upon again by an Anarch. Poorly disciplined and unused to the squalor of the cities, they are of little help on the walls during sieges."
#undisciplined
#singlebattle
#forestsurvival
#stealthy
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10000
#gcost 10
#rcost 1
#coldres 3
#weapon 1341 -- mosin nagant
#weapon 1342 -- bayonet
#armor 621
#startage 22
#end


-- Anarchist Leader

#newmonster
#name "Forest Anarch"
#spr1 "./Firepower/sovirus/officer3idle.tga"
#spr2 "./Firepower/sovirus/officer3attack.tga"
#nametype 146
#descr "After the princes of Bogarus were all shot by the Sovi revolutionaries, disagreements surfaced between factions. The city dwellers wanted their leadership in the revolt recognised and they tried to force the peasants and forest bandits to obey their laws. Many bandits refused to give up their easy lives of plunder and slipped back to their old ways. With the threat to the Rus people from the foreign Pretender Gods, these Forest Brothers are willing to join forces with the Sovi once more, but they still chafe under the laws of the Chekists. The Anarchs spread dissent against the Awakening God and the foreign pretenders alike, but can call rifles to the defence of the Motherland. Some have picked up skill in Water or Nature magic from unconquered native tribes while hiding in the forests and living from the land."
#makemonsters3 "Forest Brother"
#okleader
#heretic 1
#custommagic 8704 50
#forestsurvival
#stealthy
#hp 12
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10050
#rcost 1
#coldres 3
#weapon 8
#weapon 1340
#armor 621
#startage 35
#end

-- Chekist Investigator

#newmonster
#name "Chekist Investigator"
#spr1 "./Firepower/sovirus/officer4idle.tga"
#spr2 "./Firepower/sovirus/officer4attack.tga"
#nametype 146
#descr "When the revolution against the Bogarusian princes began to encounter difficulties, the enthusiasm of the people had to be reinforced. The Cheka are experts at creating enthusiasm in people. Sometimes the mere sight of their black leather uniforms has this effect. They have become one of the most important tools for the Sovirus rulers in maintaining order. The Investigators seek out national traitors and enemies of the Awakening God. They supplement weak priestly abilities with Fire, Death or Blood magic which they pick up on the job rather than through formal education, as the Chekists are very suspicious of the overly educated."
#okleader
#poorundeadleader
#inspirational 1
#magicskill 9 1
#custommagic 36992 100 -- fire, death, blood
#custommagic 36992 10 -- fire, death, blood
#inquisitor
#holy
#patrolbonus 10
#hp 10
#size 3
#prot 0
#mor 15
#mr 12
#enc 3
#str 10
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 8
#weapon 1340
#armor 621
#armor 622
#startage 35
#end

-- Chekist Executioner

#newmonster
#name "Chekist Executioner"
#spr1 "./Firepower/sovirus/officer4idle.tga"
#spr2 "./Firepower/sovirus/officer4attack.tga"
#nametype 146
#descr "When the revolution against the Bogarusian princes began to encounter difficulties, the enthusiasm of the people had to be reinforced. The Cheka are experts at creating enthusiasm in people. Sometimes the mere sight of their black leather uniforms has this effect. They have become one of the most important tools for the Sovirus rulers in maintaining order. The Executioners work behind the scenes, breaking up dissent uncovered by the Investigators. They lack priestly skills but are more capable magi, with skill in Death and Blood, and sometimes Fire."
#okleader
#poorundeadleader
#inspirational 1
#magicskill 5 1
#magicskill 8 1
#custommagic 36992 100 -- fire, death, blood
#custommagic 36992 10 -- fire, death, blood
#holy
#patrolbonus 10
#hp 10
#size 3
#prot 0
#mor 15
#mr 12
#enc 3
#str 10
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 8
#weapon 1340
#armor 621
#armor 622
#startage 40
#end

-- Surgeon

#newmonster
#name "Surgeon"
#spr1 "./Firepower/sovirus/officer7idle.tga"
#spr2 "./Firepower/sovirus/officer7attack.tga"
#nametype 146
#descr "Medicine is not as highly developed as engineering in Sovirus, but the skills of Surgeons are nonetheless appreciated by both citizens and soldiers of the Awakening God. They can not only heal afflictions from wounded troops, they also have the responsibility for enchanting the uniforms of some infantry formations with protection against magical attacks. They tend to have a very wide range of skills due to being moved between different departments of Bureaus, military formations and the administration."
#poorleader
#autohealer 1
#magicskill 6 1
#magicskill 51 1
#custommagic 28672 100
#hp 9
#size 3
#prot 0
#mor 9
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#coldres 3
#weapon 6
#weapon 1340
#armor 620
#armor 622
#startage 45
#end

-- Bureau Engineer

#newmonster
#name "Bureau Engineer"
#spr1 "./Firepower/sovirus/officer5idle.tga"
#spr2 "./Firepower/sovirus/officer5attack.tga"
#nametype 146
#descr "The panoply of war used by Sovirus are produced in factories called Bureaus, overseen by the Chekists. The magi that work in these factories usually do not have the time or inclination to take part in battles, but the Chekists can be very persuasive. The Bureau Engineer is also able to assist in weapons production. It is said that some divinely inspired Engineers can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in the Bureaus with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 5
#hp 9
#size 3
#prot 0
#mor 9
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 6
#weapon 1340
#armor 620
#armor 622
#startage 40
#prophetshape 3567
#end

-- Prophet shape with AK47 (Engineer)

#newmonster 6567
#name "Engineer-Prophet"
#spr1 "./Firepower/sovirus/prophet2idle.tga"
#spr2 "./Firepower/sovirus/prophet2attack.tga"
#nametype 146
#descr "The panoply of war used by Sovirus are produced in factories called Bureaus, overseen by the Chekists. The magi that work in these factories usually do not have the time or inclination to take part in battles, but the Chekists can be very persuasive. The Bureau Engineer is also able to assist in weapons production. It is said that some divinely inspired Engineers can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in the Bureaus with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 30
#hp 9
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 1378 -- ak47
#weapon 6 -- shortsword
#armor 620
#armor 622
#startage 40
#end

-- Bureau Foreman

#newmonster
#name "Bureau Foreman"
#spr1 "./Firepower/sovirus/officer6idle.tga"
#spr2 "./Firepower/sovirus/officer6attack.tga"
#nametype 146
#descr "The Bureaus are centralised institutions and have an internal hierarchy. Senior magi who are esteemed by their peers for contributions to their field are promoted to the rank of Foreman. The Bureau Foreman is often an expert at several forms of elemental magic. It is said that some divinely inspired Foremen can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in the Bureaus with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#resources 5
#mason
#hp 9
#size 3
#prot 0
#mor 10
#mr 13
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 3
#gcost 10025
#rcost 1
#coldres 3
#weapon 6
#weapon 1340
#armor 620
#armor 626 -- glasses
#startage 50
#prophetshape 3568
#end

-- Prophet shape with AK47 (Foreman)

#newmonster 6568
#name "Foreman-Prophet"
#spr1 "./Firepower/sovirus/prophet1idle.tga"
#spr2 "./Firepower/sovirus/prophet1attack.tga"
#nametype 146
#descr "The Bureaus are centralised institutions and have an internal hierarchy. Senior magi who are esteemed by their peers for contributions to their field are promoted to the rank of Foreman. The Bureau Foreman is often an expert at several forms of elemental magic. It is said that some divinely inspired Foremen can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in the Bureaus with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#resources 30
#mason
#hp 9
#size 3
#prot 0
#mor 11
#mr 13
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 1378 -- ak47
#weapon 6 -- shortsword
#armor 620
#armor 626 -- glasses
#startage 50
#end

-- Field Artillery

#newmonster 6595
#name "Field Artillery"
#spr1 "./Firepower/sovirus/artillery1idle.tga"
#spr2 "./Firepower/sovirus/artillery1attack.tga"
#nametype 146
#descr "The Bureau Magi have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges."
#okleader
#siegebonus 40
#hp 30
#size 8
#prot 0
#mor 13
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 10
#ap 4
#rpcost 10000
#gcost 250
#rcost 1
#coldres 3
#weapon 1343
#weapon 1346
#weapon 1346
#weapon 1346
#armor 620
#armor 622
#startage 30
#maxage 500
#cleanshape
#secondshape 6596
#startitem 851
#xploss 100 -- xp gets wiped when crew dies
#end

-- Crewless Field Artillery

#newmonster 6596
#name "Crewless Artillery"
#spr1 "./Firepower/sovirus/artillery1nocrew.tga"
#spr2 "./Firepower/sovirus/artillery1nocrew.tga"
#nametype 146
#descr "The Bureau Magi have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges. This particular piece has lost all its crew but it will be replenished after the battle ends."
#okleader
#siegebonus 40
#hp 20
#size 7
#prot 20
#mor 50
#mr 5
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 0
#rcost 0
#poisonres 25
#firstshape 6595
#miscshape
#inanimate
#immobile
#woundfend 100
#neednoteat
#end

-- Machinegun

#newmonster 6597
#name "Autogun Team"
#spr1 "./Firepower/sovirus/machinegun1idle.tga"
#spr2 "./Firepower/sovirus/machinegun1attack.tga"
#nametype 146
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build. It has a metal shield to protect the crewmen, although this makes it quite slow both on the battlefield and during manoeuvres."
#reclimit 1
#castledef 10
#hp 10
#size 5
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 12
#ap 8
#rpcost 50
#gcost 75
#rcost 1
#coldres 3
#weapon 1344
#weapon 1346
#weapon 1346
#armor 2 -- shield
#armor 621
#armor 623
#cleanshape
#secondshape 6598
#startage 25
#maxage 500
#xploss 50 -- xp gets wiped when crew dies
#end

-- Machinegun (1 dead)

#newmonster 6598
#name "Depleted Autogun"
#spr1 "./Firepower/sovirus/machinegun2idle.tga"
#spr2 "./Firepower/sovirus/machinegun2attack.tga"
#nametype 146
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#castledef 10
#hp 10
#size 4
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 12
#ap 4
#rpcost 50
#gcost 0
#rcost 0
#coldres 3
#weapon 1345
#weapon 1346
#armor 2 -- shield
#armor 621
#armor 623
#cleanshape
#firstshape 6597
#secondshape 6599
#startage 25
#maxage 500
#xploss 100 -- xp gets wiped when crew dies
#end

-- Machinegun (2 dead)

#newmonster 6599
#name "Crewless Autogun"
#spr1 "./Firepower/sovirus/machinegun3.tga"
#spr2 "./Firepower/sovirus/machinegun3.tga"
#nametype 146
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#hp 10
#size 3
#prot 15
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 50
#gcost 0
#rcost 0
#miscshape
#itemslots 12288
#noweapon 1
#poisonres 25
#cleanshape
#firstshape 6597
#inanimate
#immobile
#woundfend 100
#neednoteat
#startage 25
#maxage 500
#end


-- Bunker
-- Summons 5d6 (5-30, mean 17.5) singlebattle Spearmen at battle start
-- 17.5 * 7 gold = 122.5 gold

#newmonster
#name "Command Bunker"
#spr1 "./Firepower/sovirus/bunker.tga"
#spr2 "./Firepower/sovirus/bunker.tga"
#nametype 251
#descr "Field fortifications are often used by commanders to make conquering Sovirus territory a more difficult prospect. This bunker unleashes a contingent of spear-armed militiamen for the duration of any battles in the province. It is very tough and will resist much damage in melee combat."
#okleader
#hp 40
#size 8
#prot 25
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 150
#rcost 30
#miscshape
#startage 20
#batstartsum5d6 6593
#weapon 1341 -- mosin nagant
#coldres 5
#fireres 5
#shockres 15
#poisonres 25
#castledef 20
#stonebeing
#inanimate
#immobile
#woundfend 100
#ainorec
#startage 30
#maxage 500
#nohof
#end

-- Medium tank
-- nobody gonna beat my car it's gonna break the speed of sound

#newmonster 6592
#name "Tank Commander"
#spr1 "./Firepower/sovirus/tank.tga"
#spr2 "./Firepower/sovirus/tank.tga"
#nametype 146
#descr "While the infantry can hide behind their bunkers and walls when on the defence, they are incredibly exposed when they have to take the fight to the enemy. The BT-36 medium tank was developed to assist the infantry during offensives. It is made of tough, magical steel, perfect for drawing arrow fire away from the footsloggers. It's a killing machine, it's got everything, like autoguns, a cannon, guns for the crew, and of course the weight of the machine itself can scatter and smash enemies of the Awakening God. It is a terrifying weapon for those unaccustomed to the deafening roar of the magical engines. It is very expensive to maintain, although crews bring their own food with them."
#okleader
#holy
#hp 80
#size 9
#prot 20
#mor 20
#mr 11
#enc 2
#str 25
#att 10
#def 5
#prec 10
#mapmove 24
#ap 14
#rpcost 10000
#gcost 240
#rcost 30
#itemslots 12288
#startage 35
#maxage 500
#weapon 1347 -- tank cannon
#weapon 1348 -- tank autogun
#weapon 1349 -- vehicle ram
#shockres -5
#coldres 5
#fireres 5
#poisonres 20
#trample
#fear 5
#woundfend 100
#inanimate
#pierceres
#slashres
#bluntres
#neednoteat
#end

-- Armoured car

#newmonster 6581
#name "Armoured Car"
#spr1 "./Firepower/sovirus/armouredcar.tga"
#spr2 "./Firepower/sovirus/armouredcar.tga"
#nametype 146
#descr "The armies of Sovirus do not often use cavalry in warfare. Instead, they place their faith in technological marvels such as this BZ-16 armoured car, developed by the finest magi and engineers in the land. Tougher than a horse, it carries an autogun which can be fired during melee combat against large targets, although it is far more useful running down small, vulnerable foes such as archers and wizards by driving over them. It is not as expensive to maintain as a medium tank, and crews bring their own food with them."
#hp 40
#size 7
#prot 20
#mor 16
#mr 10
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 24
#ap 16
#rpcost 10000
#gcost 60
#rcost 10
#itemslots 12288
#startage 30
#maxage 500
#weapon 1354 -- autogun
#weapon 1349 -- vehicle ram
#shockres -5
#coldres 5
#fireres 5
#poisonres 20
#trample
#woundfend 100
#inanimate
#pierceres
#slashres
#bluntres
#neednoteat
#end

-- Assault Ghoul

#newmonster 6590
#name "Assault Ghoul"
#spr1 "./Firepower/sovirus/soldier8idle.tga"
#spr2 "./Firepower/sovirus/soldier8attack.tga"
#nametype 146
#descr "The need for a Sovi formation that is tougher and more loyal than ordinary soldiers led the Chekists to experiment with necromantic rituals. The soulless lack the ability to use complex weapons, however, and the longdead are too fragile, so the ghoul was selected for the new corps of undead assault troops. Malnourished peasants can easily be persuaded to feast on tainted human flesh. After the curse takes them, they are equipped with strong armour, grenades and small autoguns, and they can rend apart the enemy with their poisoned claws, but they are vulnerable to being banished by enemy priests. Men will never be free until the last pretender god is strangled with the entrails of the last priest."
#hp 15
#size 3
#prot 0
#mor 20
#mr 10
#enc 0
#str 12
#att 11
#def 11
#prec 10
#mapmove 20
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#coldres 3
#poisonres 25
#ambidextrous 2
#undead
#neednoteat
#weapon 1350 -- ppsh
#weapon 1351 -- grenade
#weapon 43 -- poisoned claw
#weapon 43 -- poisoned claw
#armor 623
#armor 9 -- plate cuirass (15 res, 14 prot, -1 def, 2 enc)
#startage 25
#maxage 500
#end

-- Devil with AK47

#newmonster 6566
#copystats 304
#spr1 "./Firepower/sovirus/devil1idle.tga"
#spr2 "./Firepower/sovirus/devil1attack.tga"
#name "Assault Devil"
#descr "Devils are infernal beings of great strength. Only with human sacrifice is it possible to summon and bind these evil beings. Devils are born in the fires of the Inferno and are impervious to heat and flame. Their glowing bodies radiate heat and bat-like wings grow from their shoulders. Assault Devils are armed with experimental automatic rifles and their barbed tails can sting opponents in close combat."
#clearweapons
#weapon 1378 -- ak47
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#weapon 68 -- barbed tail
#end

-- Cossack Soldier

#newmonster 6665
#name "Cossack"
#spr1 "./Firepower/sovirus/cossack_soldier_idle.tga"
#spr2 "./Firepower/sovirus/cossack_soldier_attack.tga"
#nametype 146
#descr "Light cavalrymen armed with lances and pistols, the role of Cossack units is to charge into vulnerable points in the enemy's line and open them up for exploitation."
#mounted
#hp 11
#size 3
#prot 0
#mor 12
#mr 10
#enc 4
#str 10
#att 12
#def 12
#prec 8
#mapmove 20
#ap 24
#rpcost 35
#gcost 25
#rcost 1
#coldres 3
#weapon 1340 -- revolver
#weapon 357 -- light lance
#weapon 56 -- hoof
#armor 623 -- iron helmet
#armor 621 -- reinforced uniform
#startage 25
#end

-- Cossack Officer

#newmonster 6666
#name "Cossack Officer"
#spr1 "./Firepower/sovirus/cossack_officer_idle.tga"
#spr2 "./Firepower/sovirus/cossack_officer_attack.tga"
#nametype 146
#descr "Light cavalrymen armed with lances and pistols, the role of Cossack units is to charge into vulnerable points in the enemy's line and open them up for exploitation."
#okleader
#mounted
#hp 12
#size 3
#prot 0
#mor 15
#mr 10
#enc 4
#str 11
#att 13
#def 13
#prec 9
#mapmove 20
#ap 24
#rpcost 10000
#gcost 10010
#rcost 1
#coldres 3
#weapon 1340 -- revolver
#weapon 357 -- light lance
#weapon 56 -- hoof
#armor 622 -- peaked cap
#armor 621 -- reinforced uniform
#startage 30
#end

-- Sovirus Supply Truck

#newmonster 6899
#name "Supply Truck"
#spr1 "./Firepower/sovirus/truck1idle.tga"
#spr2 "./Firepower/sovirus/truck1attack.tga"
#nametype 146
#descr "This horseless carriage transports useful supplies to troops in the field. It has good speed and range thanks to its magic engine, imbued by the engineers with the power of scientific socialism."
#supplybonus 35
#hp 30
#size 8
#prot 15
#mor 12
#mr 10
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 22
#ap 16
#rpcost 30
#gcost 75
#rcost 30
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

#newmonster 6900
#name "Motorised Commander"
#spr1 "./Firepower/sovirus/truck1idle.tga"
#spr2 "./Firepower/sovirus/truck1idle.tga"
#okleader
#nametype 146
#descr "The armies of Sovirus have a long history with cavalry, heirs as they are to the horsemen of the Rus steppes. The old doctrines are being reinvigorated with this two and a half ton horseless carriage, developed by the Bureau Engineers. Tougher than a horse, it carries a small complement of mounted infantrymen who disembark from the carriage to do battle with their automatic rifles. The driver should be given orders to hide or retreat after arriving as the carriage itself is not useful in combat. Crews and passengers bring their own food with them."
#batstartsum5 6901
#castledef 5
#siegebonus 5
#patrolbonus 5
#hp 30
#size 8
#prot 15
#mor 14
#mr 11
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 24
#ap 16
#rpcost 10000
#gcost 75
#rcost 0
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

-- Motor Rifleman

#newmonster 6901
#name "Motorised Rifleman"
#spr1 "./Firepower/sovirus/soldier_ak47_idle.tga"
#spr2 "./Firepower/sovirus/soldier_ak47_attack.tga"
#nametype 146
#descr "The Motor Rifles are soldiers who embark on horseless carriages for fast strikes into enemy lands and to quickly reinforce threatened provinces. They are better trained than the footsloggers and they are equipped with experimental automatic rifles."
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 15
#rcost 1
#coldres 3
#weapon 1378 -- ak47
#weapon 1351 -- grenade
#weapon 9 -- dagger
#armor 621
#armor 623
#startage 25
#end


#newmonster 6908
#name "Katyusha Launcher"
#spr1 "./Firepower/sovirus/katyusha_idle.tga"
#spr2 "./Firepower/sovirus/katyusha_attack.tga"
#nametype 146
#descr "This horseless carriage has been modified with a rack of Katyusha rockets, which scream down on the enemy from afar with fire and shrapnel. The racks take some time to reload but the device is much more mobile than conventional artillery."
#hp 30
#size 8
#prot 15
#mor 12
#mr 10
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 22
#ap 16
#rpcost 30
#gcost 90
#rcost 30
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1308 -- rocket launcher
--#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

----------------------------- Ulmreich units -----------------------------

-- Labour Serviceman

#newmonster
#name "Labour Serviceman"
#spr1 "./Firepower/ulmreich/spear1idle.tga"
#spr2 "./Firepower/ulmreich/spear1attack.tga"
#nametype 104
#descr "The men of Ulmreich are required to serve time in the army, and the nature of that service depends upon the army's needs. Sometimes simple manual labour is needed, and the conscripts are sent to the Labour Battalions to build roads or carry supplies. They are looked down upon by the public as cowards shirking from the fight, although most did not choose this path. They are slow to move strategically due to lack of training, although as conscripts they can be raised even in provinces without forts."
#undisciplined
#hp 12
#size 3
#prot 0
#mor 9
#mr 9
#enc 3
#str 11
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 5
#gcost 7
#rcost 1
#weapon 1
#armor 625
#armor 620
#startage 22
#end

-- Reserve Rifleman

#newmonster
#name "Reserve Rifleman"
#spr1 "./Firepower/ulmreich/rifle2idle.tga"
#spr2 "./Firepower/ulmreich/rifle2attack.tga"
#nametype 104
#descr "The Reserve are men who have been quickly levied into the service of the Reich and handed rifles to defend the nation from invasion, or press the attack against enemy nations. They are slow to move strategically due to lack of training, although as conscripts they can be raised even in provinces without forts."
#undisciplined
#hp 12
#size 3
#prot 0
#mor 9
#mr 9
#enc 3
#str 11
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 8
#gcost 9
#rcost 1
#weapon 1356 -- mauser
#weapon 1342 -- bayonet
#armor 620
#armor 625
#startage 22
#end

-- Grenadier (formerly Fusilier)

#newmonster
#name "Grenadier"
#spr1 "./Firepower/ulmreich/rifle1idle.tga"
#spr2 "./Firepower/ulmreich/rifle1attack.tga"
#nametype 104
#descr "The regular Infantry are formed from professional volunteers and Reservists who have served their term of conscription and chosen to remain in the army. Training for the Infantry is a mixture of marksmanship, physical conditioning, hand-to-hand combat, and degrading menial work intended to break their individualism and remould them into killers. Those who fail the training are sent to the Labour Battalions in shame. Grenadiers are equipped with rifles for picking off enemies from afar, grenades for breaking up groups and bayonets for finishing them off with a charge."
#hp 12
#size 3
#prot 0
#mor 10
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 15
#rcost 1
#weapon 1356 -- mauser
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 25
#end

-- Assault Infantry

#newmonster
#name "Pionier"
#spr1 "./Firepower/ulmreich/subgun1idle.tga"
#spr2 "./Firepower/ulmreich/subgun1attack.tga"
#nametype 104
#descr "The regular Infantry are formed from professional volunteers and Reservists who have served their term of conscription and chosen to remain in the army. Training for the Infantry is a mixture of marksmanship, physical conditioning, hand-to-hand combat, and degrading menial work intended to break their individualism and remould them into killers. Those who fail the training are sent to the Labour Battalions in shame. The Pioniers are used to assault the enemy in close quarters. Their small autoguns can be fired at point blank range against enemies that engage in melee combat."
#hp 12
#size 3
#prot 0
#mor 10
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 12
#gcost 15
#rcost 1
#weapon 1357 -- mp40
#weapon 9 -- dagger
#weapon 1351 -- grenade
#armor 621
#armor 623
#startage 25
#end

-- Brownshirt

#newmonster
#name "Brownshirt Militiaman"
#spr1 "./Firepower/ulmreich/rifle3idle.tga"
#spr2 "./Firepower/ulmreich/rifle3attack.tga"
#nametype 131
#descr "The undead of Ermor and its splinter empires have been a constant threat to Ulm. The Airyan Sect holds that Ermor sent the Malediction against Ulm as punishment for breaking away from that decrepit empire. The Brownshirts are a paramilitary militia dedicated to preserving the independence of Ulmreich from her many enemies. They take special pleasure in destroying the undead, although they are not very good at this. They have enough strength of conviction to resist magical attacks more successfully than other Ulmish troops."
#holy
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 18
#rcost 1
#weapon 1356 -- mauser
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 625
#startage 25
#end

-- Airyan Guard

#newmonster
#name "Airyan Guardsman"
#spr1 "./Firepower/ulmreich/subgun3idle.tga"
#spr2 "./Firepower/ulmreich/subgun3attack.tga"
#nametype 131
#descr "The Airyan Guard are an elite force, recruited on the basis of intelligence, strength and loyalty by the Airyan priesthood to further their interests. Inspired by belief in their Caelian heritage, the Guard are hard to break with magic, and harder still to rout with fear. Their duties take them to the vanguard of any action, whether military or political. They are as likely to be deployed against dissidents and heretics as enemy field armies."
#holy
#formationfighter 1
#patrolbonus 2
#hp 13
#size 3
#prot 0
#mor 13
#mr 11
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 25
#gcost 25
#rcost 1
#weapon 1357 -- mp40
#weapon 9 -- dagger
#weapon 1351 -- grenade
#armor 621
#armor 623
#startage 30
#end

-- Regimental Standard (Ulmreich)

#newmonster 6553
#name "Regimental Standard"
#spr1 "./Firepower/ulmreich/flag1idle.tga"
#spr2 "./Firepower/ulmreich/flag1attack.tga"
#nametype 104
#descr "The history and battles of each Ulmreich formation are proudly flown on intricate thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from an Infantry regiment."
#aisinglerec
#standard 1
#hp 12
#size 3
#prot 0
#mor 11
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 20
#rcost 4
#weapon 1356 -- mauser
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 30
#end

-- Airyan Standard

#newmonster
#name "Airyan Standard"
#spr1 "./Firepower/ulmreich/flag2idle.tga"
#spr2 "./Firepower/ulmreich/flag2attack.tga"
#nametype 131
#descr "The history and battles of each Ulmreich formation are proudly flown on intricate thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from an Airyan Guard regiment. It is not known whether the icon on the flag represents the skulls of Ulmreich's enemies, a pure Airyan skull shape, or just an historical tradition of the Ulmish army."
#aisinglerec
#formationfighter 1
#standard 1
#holy
#patrolbonus 2
#hp 13
#size 3
#prot 0
#mor 14
#mr 11
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 25
#gcost 30
#rcost 4
#weapon 1357 -- mp40
#weapon 9 -- dagger
#weapon 1351 -- grenade
#armor 621
#armor 623
#startage 30
#end

-- Captain

#newmonster
#name "Infantry Captain"
#spr1 "./Firepower/ulmreich/subgun2idle.tga"
#spr2 "./Firepower/ulmreich/subgun2attack.tga"
#nametype 104
#descr "The chaos of the Malediction caused a breakdown of central command in the Ulmish armies. By the time the Airyan Sect established control, a tradition of initiative and low level leadership had arisen. The Reich continues this tradition with field promotions for intelligent and charismatic soldiers."
#okleader
#hp 12
#size 3
#prot 0
#mor 12
#mr 9
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1357 -- mp40
#armor 620
#armor 622
#startage 30
#end

-- Colonel

#newmonster
#name "Infantry Colonel"
#spr1 "./Firepower/ulmreich/officer1idle.tga"
#spr2 "./Firepower/ulmreich/officer1attack.tga"
#nametype 104
#descr "Colonels are senior officers with a record of long service and tactical aptitude. The Ulmish armies understand the importance of logistics thanks to campaigns in the barren Ermorian wastelands. It would be unlikely for Ulmreich to overextend her supply lines in an offensive, even in winter."
#goodleader
#hp 12
#size 3
#prot 0
#mor 13
#mr 9
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#supplybonus 10
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 40
#end

-- General

#newmonster
#name "Infantry General"
#spr1 "./Firepower/ulmreich/officer2idle.tga"
#spr2 "./Firepower/ulmreich/officer2attack.tga"
#nametype 104
#descr "The Generals are a power to be reckoned with in the militaristic nation of Ulmreich. They have distinguished themselves in their long careers as expert logisticians and strategists, and the soldiers under their command never lack for supplies or morale. Most are happy to serve under the Airyan priesthood, although they resent the national adoration of the Brownshirts."
#expertleader
#inspirational 1
#hp 12
#size 3
#prot 0
#mor 14
#mr 9
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#supplybonus 30
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 50
#end

-- Field Artillery

#newmonster 6579
#name "Field Artillery"
#spr1 "./Firepower/ulmreich/artillery1idle.tga"
#spr2 "./Firepower/ulmreich/artillery1attack.tga"
#nametype 104
#descr "The Inventors have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges."
#okleader
#siegebonus 40
#hp 36
#size 8
#prot 0
#mor 13
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 11
#mapmove 10
#ap 4
#rpcost 10000
#gcost 250
#rcost 1
#weapon 1343
#weapon 1346
#weapon 1346
#weapon 1346
#armor 620
#armor 622
#startage 25
#maxage 500
#cleanshape
#secondshape 6580
#startitem 851
#xploss 100 -- xp gets wiped when crew dies
#end

-- Crewless Field Artillery

#newmonster 6580
#name "Crewless Artillery"
#spr1 "./Firepower/ulmreich/artillery1nocrew.tga"
#spr2 "./Firepower/ulmreich/artillery1nocrew.tga"
#nametype 104
#descr "The Inventors have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges. This particular piece has lost all its crew but it will be replenished after the battle ends."
#okleader
#siegebonus 40
#hp 20
#size 7
#prot 20
#mor 50
#mr 5
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 0
#rcost 0
#poisonres 25
#firstshape 6579
#miscshape
#itemslots 12288
#noweapon 1
#inanimate
#immobile
#woundfend 100
#neednoteat
#end

-- Nurse

#newmonster
#name "Nurse"
#spr1 "./Firepower/ulmreich/nurse1idle.tga"
#spr2 "./Firepower/ulmreich/nurse1attack.tga"
#nametype 132
#descr "Medicine is not as highly developed as engineering in Ulmreich, but the skills of Nurses are nonetheless appreciated by both citizens and soldiers of the Awakening God. The hierarchical social system in Ulmreich frowns upon women going to war or taking up the professions of men, but Nursing is one talent believed to be more suited to the fairer sex."
#female
#poorleader
#autohealer 1
#magicskill 6 1
#custommagic 34048 10 -- air, earth, blood
#hp 11
#size 3
#prot 0
#mor 9
#mr 11
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 9 -- dagger
#armor 626 -- glasses
#armor 627 -- clothes
#startage 45
#end

-- Ulmreich inventor

#newmonster
#name "Inventor"
#spr1 "./Firepower/ulmreich/inventor1idle.tga"
#spr2 "./Firepower/ulmreich/inventor1attack.tga"
#nametype 104
#descr "Inventors are wealthy and learned civilians drawn from workshops and factories across Ulmreich. They sometimes take to the field to lend their many skills to the armies. They have knowledge of elemental magic, especially Earth, and can assist in the production of war materiel. They should be kept out of harm's way as they have no martial training. It is said that some divinely inspired Inventors can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in factories with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 5
#hp 11
#size 3
#prot 0
#mor 9
#mr 11
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1363 -- walking stick
#armor 627 -- clothes
#armor 628 -- hat
#startage 40
#prophetshape 6557
#end

-- Prophet shape with STGW44 (Inventor)

#newmonster 6557
#name "Inventor-Prophet"
#spr1 "./Firepower/ulmreich/inventor3idle.tga"
#spr2 "./Firepower/ulmreich/inventor3attack.tga"
#nametype 104
#descr "Inventors are wealthy and learned civilians drawn from workshops and factories across Ulmreich. They sometimes take to the field to lend their many skills to the armies. They have knowledge of elemental magic, especially Earth, and can assist in the production of war materiel. They should be kept out of harm's way as they have no martial training. It is said that some divinely inspired Inventors can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in factories with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 30
#hp 11
#size 3
#prot 0
#mor 10
#mr 11
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1364 -- stgw44
#weapon 6 -- shortsword
#armor 627 -- clothes
#armor 628 -- hat
#startage 40
#end

-- Chief inventor

#newmonster
#name "Capitalist"
#spr1 "./Firepower/ulmreich/inventor2idle.tga"
#spr2 "./Firepower/ulmreich/inventor2attack.tga"
#nametype 104
#descr "The owners of the factories in Ulmreich are not pious or brave men, but they are very wealthy and powerful magi. Their gratitude for being saved from the Malediction has encouraged them to lend their support to the Airyan Sect. This makes Ulmreich very stable. One of the few frictions that remain is between the pragmatism of the Capitalists and the uncompromising zealousness of the Brownshirts. The Capitalists are close friends of the Generals and will assist in the production of war materiel. They should be kept out of harm's way as they have no martial training. It is said that some divinely inspired Capitalists can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in factories with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#resources 5
#mason
#hp 11
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 3
#gcost 10025
#rcost 1
#weapon 1363 -- walking stick
#armor 627 -- clothes
#armor 628 -- hat
#startage 50
#prophetshape 6556
#end

-- Prophet shape with STGW44 (Capitalist)

#newmonster 6556
#name "Capitalist-Prophet"
#spr1 "./Firepower/ulmreich/inventor4idle.tga"
#spr2 "./Firepower/ulmreich/inventor4attack.tga"
#nametype 104
#descr "The owners of the factories in Ulmreich are not pious or brave men, but they are very wealthy and powerful magi. Their gratitude for being saved from the Malediction has encouraged them to lend their support to the Airyan Sect. This makes Ulmreich very stable. One of the few frictions that remain is between the pragmatism of the Capitalists and the uncompromising zealousness of the Brownshirts. The Capitalists are close friends of the Generals and will assist in the production of war materiel. They should be kept out of harm's way as they have no martial training. It is said that some divinely inspired Capitalists can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged in factories with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#resources 30
#mason
#hp 11
#size 3
#prot 0
#mor 11
#mr 12
#enc 3
#str 10
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1364 -- stgw44
#weapon 6 -- shortsword
#armor 627 -- clothes
#armor 628 -- hat
#startage 50
#end

-- Rocket Launch Pad

#newmonster 6578
#name "Rocket Site"
#spr1 "./Firepower/ulmreich/rocket1.tga"
#spr2 "./Firepower/ulmreich/rocket1.tga"
#nametype 253
#descr "Rockets are magical constructs created by inventors out of powerful Air and Fire ensorcellments. Maintaining a rocket launch site is very expensive, but it can fire a steady stream of burning death at nearby armies opposed to the Awakening God. The site would be unable to fire during a pitched battle, although the launch site technicians would assist the defenders."
#poorleader
#hp 30
#size 10
#prot 20
#mor 50
#mr 5
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 1500
#rcost 0
#shockres -5
#coldres 5
#fireres 5
#poisonres 20
#miscshape
#itemslots 4096 -- 1 misc
#inanimate
#immobile
#woundfend 100
#startitem 852
#batstartsum5 6577
#pierceres
#slashres
#bluntres
#neednoteat
#nohof
#end

-- Launch Technician

#newmonster 6577
#name "Rocket Technician"
#spr1 "./Firepower/ulmreich/technician1idle.tga"
#spr2 "./Firepower/ulmreich/technician1attack.tga"
#nametype 104
#descr "Labour Servicemen are needed to haul rockets and magical components around the rocket battery, and will remain on site to prevent sabotage by enemy infiltrators or attacking armies."
#hp 12
#size 3
#prot 0
#mor 9
#mr 9
#enc 3
#str 11
#att 9
#def 9
#prec 10
#mapmove 14
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1340 -- revolver
#weapon 9 -- dagger
#armor 620
#armor 625 -- cap
#startage 22
#end

-- Secret Policeman

#newmonster
#name "Secret Policeman"
#spr1 "./Firepower/ulmreich/officer3idle.tga"
#spr2 "./Firepower/ulmreich/officer3attack.tga"
#nametype 131
#descr "The Airyan Sect have established a secret police to investigate impurities of the blood in the subjects of Ulmreich. The Malediction worked through those with bad blood: foreigners hiding in plain sight who spread their lies and dissent to harm Ulm. Even the apparently loyal could turn without warning as it was in the nature of their blood. The Secret Police strike without mercy, killing 10 deviants in their province every month, and by purging the nation of such liars and traitors, the Airyan Sect will ensure the Malediction never harms Ulmreich. The Policemen have knowledge of Blood magic and are considered to be engaged in a sacred duty."
#poorleader
#holy
#douse 1
#stealthy 10
#magicskill 8 1
#custommagic 34048 10 -- air, earth, blood
#popkill 1
#incunrest -10
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#armor 620
#armor 622
#startage 30
#end

-- Secret Police Chief

#newmonster
#name "Secret Police Chief"
#spr1 "./Firepower/ulmreich/officer4idle.tga"
#spr2 "./Firepower/ulmreich/officer4attack.tga"
#nametype 131
#descr "The Airyan Sect have established a secret police to investigate impurities of the blood in the subjects of Ulmreich. Leaders of the Secret Police oversee secret blood rituals and have some priestly authority of their own. They are very efficient at uncovering blood impurities and will kill 20 deviants and blood defilers every month. They can also use their oversight of the population to extract taxes from any provinces that have been cut off from the bureaucracy in the capital."
#okleader
#poorundeadleader
#holy
#douse 1
#taxcollector
#stealthy 20
#magicskill 8 2
#magicskill 9 1
#custommagic 34048 100 -- air, earth, blood
#custommagic 34048 10 -- air, earth, blood
#popkill 2
#incunrest -20
#hp 12
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#armor 620
#armor 622
#startage 35
#end

-- Brownshirt Leader

#newmonster
#name "Brownshirt Leader"
#spr1 "./Firepower/ulmreich/officer5idle.tga"
#spr2 "./Firepower/ulmreich/officer5attack.tga"
#nametype 131
#descr "The Brownshirts were formed as a popular militia for fending off the undead horrors of the Malediction when the Airyan Sect was young. Since then the Sect has become more refined and authoritative, and the Brownshirts are seen more and more as a liability. Still, they have an important role in the veneration of the Awakening God and are powerful priests, so it is unlikely that they will come to blows with the other arms of the Airyan Sect. The Leaders hold the dogma that their shirts are stained brown from the dried blood of past martyrs, although cynics say they just buy the cheapest dye colour."
#goodleader
#holy
#magicskill 9 2
#hp 12
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 35
#end

-- Light tank

#newmonster 6576
#name "Panzer Commander"
#spr1 "./Firepower/ulmreich/panzer1.tga"
#spr2 "./Firepower/ulmreich/panzer1.tga"
#nametype 104
#descr "While usually able to keep the enemy at bay with their superior firepower, the infantry are incredibly vulnerable when the distance is closed or the enemy has ranged units of their own. The Panzer light tank was developed to assist the infantry in punching holes through enemy lines. It is made of tough, magical steel, perfect for drawing arrow fire away from the footsloggers, and it carries a plethora of different weapons, such as autoguns, a cannon, guns for the crew, and of course the weight of the machine itself can scatter and smash enemies of the Awakening God. It is a terrifying weapon for those unaccustomed to the deafening roar of the magical engines. It is quite expensive to maintain, although crews bring their own food with them."
#okleader
#hp 60
#size 8
#prot 20
#mor 20
#mr 10
#enc 2
#str 20
#att 10
#def 5
#prec 10
#mapmove 20
#ap 14
#rpcost 10000
#gcost 90
#rcost 30
#itemslots 12288
#startage 35
#maxage 500
#weapon 1359 -- small tank cannon
#weapon 1358 -- tank autogun
#weapon 1349 -- vehicle ram
#shockres -5
#coldres 5
#fireres 5
#poisonres 20
#trample
#fear 5
#woundfend 100
#inanimate
#pierceres
#slashres
#bluntres
#neednoteat
#end

-- Airyan mage priest

#newmonster
#name "Airyan Mage-Priest"
#spr1 "./Firepower/ulmreich/officer6idle.tga"
#spr2 "./Firepower/ulmreich/officer6attack.tga"
#nametype 131
#descr "The Airyan Sect traces its origins to the Black Priests of old Ulm. Radicals who rejected the Iron Cult's derision of the weakness of the flesh formed a movement within the Black Temple and pushed for a synergy between flesh and iron, and thus the doctrine of Blood and Earth was born. This movement was barely tolerated by the authorities as it verged on heresy. The chaos of the Malediction gave the Airyan Sect the opportunity to grab what power they could, and they absorbed the fierce Brownshirt militias as their militant arm. Later they gave guidance and inspiration to the abandoned Ulmish armies crusading against the undead of Ermor, whose loyalty is now key to the Airyan Sect's dominance. Airyan Mage-Priests preach that true Ulmish blood descends from wingless Caelians and they revere Air magic."
#okleader
#holy
#magicskill 1 2
#magicskill 8 1
#magicskill 9 1
#magicskill 3 1
#custommagic 34048 10 -- air, earth, blood
#hp 12
#size 3
#prot 0
#mor 15
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 35
#end

-- Brownshirt Officer

#newmonster
#name "Brownshirt Officer"
#spr1 "./Firepower/ulmreich/subgun4idle.tga"
#spr2 "./Firepower/ulmreich/subgun4attack.tga"
#nametype 131
#descr "The Brownshirts were formed as a popular militia for fending off the undead horrors of the Malediction when the Airyan Sect was young. Officers in the organisation spread veneration of the Awakening God amongst the troops and people of Ulmreich. They are seen by the elites as unrefined provincials, rabblerousers and thugs."
#okleader
#holy
#magicskill 9 1
#hp 12
#size 3
#prot 0
#mor 13
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1357 -- mp40
#armor 620
#armor 622
#startage 30
#end

-- Pilot (priest)

#newmonster 6662
#name "Pilot"
#spr1 "./Firepower/ulmreich/pilot1idle.tga"
#spr2 "./Firepower/ulmreich/pilot1attack.tga"
#nametype 131
#descr "Pilots can be gifted engineers, technicians and mechanics, or fanatical Airyans that love to fly, but they all share a lack of combat training."
#okleader
#magicskill 9 1
#holy
#hp 12
#size 3
#prot 0
#mor 12
#mr 11
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 9 -- dagger
#weapon 1340 -- revolver
#armor 622 -- peaked cap
#armor 621 -- reinforced uniform
#startage 30
#end

-- Aircraft

#newmonster 6574
#name "Airyaplane"
#spr1 "./Firepower/ulmreich/aircraft.tga"
#spr2 "./Firepower/ulmreich/aircraft.tga"
#nametype 254
#descr "Quite possibly the pinnacle of the collaboration between the inventors and the Airyan Sect is the Airyaplane, a magical construct powered by exotic oils fed into elaborate furnaces that allow the device to fly. The close connection to the Divine prevents ordinary soldiers or leaders being transported within the Airyaplane. Only ritually prepared Air Infantry can survive flight without suffocating in the thin air of the near-void. The Pilot will lend his priestly authority to the fight, blessing the Air Infantrymen and banishing demons and undead. The Airyaplane is quick enough to return and collect more Air Infantrymen if they are killed, and crews bring their own food with them. It is very good at suppressing dissent and fighting bandits and infiltrators with its mounted autogun. It is constructed to withstand occasional blasts from thunder and lightning, allowing it to fly during storms."
#okleader
#patrolbonus 20
#shockres 15
#stormimmune
#holy
#hp 40
#size 9
#prot 15
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 35
#ap 2
#rpcost 10000
#gcost 450
#rcost 0
#miscshape
#itemslots 1 -- nothing, little point sending it to the arena
#startage 20
#maxage 500
#batstartsum5 6573
#weapon 1362 -- plane autogun
#weapon 1349 -- vehicle ram
#poisonres 25
#inanimate
#flying
#woundfend 100
#neednoteat
#pierceres
#slashres
#bluntres
#onebattlespell 2863
#end

-- Air Infantry

#newmonster 6573
#name "Air Infantryman"
#spr1 "./Firepower/ulmreich/subgun5idle.tga"
#spr2 "./Firepower/ulmreich/subgun5attack.tga"
#nametype 131
#descr "Air Infantry are drawn from the most zealous, fittest and brave of the Pioniers. They are typically used for sudden raids, strikes deep in the enemy's rear, or for quickly reinforcing threatened areas. Unlike the Lightning Guard, they do not wear thunder-proofed armour since they are protected in flight by their Airyaplane."
#holy
#hp 14
#size 3
#prot 0
#mor 13
#mr 10
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1357 -- mp40
#weapon 1351 -- grenade
#weapon 9 -- dagger
#armor 623 -- iron helmet
#armor 621 -- reinforced uniform
#startage 25
#end

-- Machinegun

#newmonster 6572
#name "Autogun Team"
#spr1 "./Firepower/ulmreich/machinegun1idle.tga"
#spr2 "./Firepower/ulmreich/machinegun1attack.tga"
#nametype 104
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build. While slow to set up and move on the battlefield, it can keep up with the Infantry during strategic manoeuvres."
#reclimit 1
#castledef 10
#hp 12
#size 5
#prot 0
#mor 12
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 14
#ap 8
#rpcost 50
#gcost 75
#rcost 1
#weapon 1360 -- autogun
#weapon 1346
#weapon 1346
#armor 621
#armor 623
#startage 25
#cleanshape
#secondshape 6571
#maxage 500
#xploss 50 -- xp gets wiped when crew dies
#end

-- Machinegun (1 dead)

#newmonster 6571
#name "Depleted Autogun"
#spr1 "./Firepower/ulmreich/machinegun2idle.tga"
#spr2 "./Firepower/ulmreich/machinegun2attack.tga"
#nametype 104
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#castledef 10
#hp 12
#size 4
#prot 0
#mor 11
#mr 9
#enc 3
#str 11
#att 10
#def 10
#prec 10
#mapmove 12
#ap 4
#rpcost 50
#gcost 0
#rcost 0
#weapon 1361
#weapon 1346
#armor 621
#armor 623
#cleanshape
#firstshape 6572
#secondshape 6570
#xploss 100 -- xp gets wiped when crew dies
#end

-- Machinegun (2 dead)

#newmonster 6570
#name "Crewless Autogun"
#spr1 "./Firepower/ulmreich/machinegun3.tga"
#spr2 "./Firepower/ulmreich/machinegun3.tga"
#nametype 104
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#hp 10
#size 3
#prot 15
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 50
#gcost 0
#rcost 0
#miscshape
#itemslots 12288
#noweapon 1
#poisonres 25
#cleanshape
#firstshape 6572
#inanimate
#immobile
#woundfend 100
#neednoteat
#end

-- Lightning Guard
-- a fatal attraction is holding me fast, how can i escape this irresistable grasp?

#newmonster 6569
#name "Lightning Guardsman"
#spr1 "./Firepower/ulmreich/subgun6idle.tga"
#spr2 "./Firepower/ulmreich/subgun6attack.tga"
#nametype 131
#descr "The Lightning Guard are the stuff of legends. They are the best Ulmreich has to offer in terms of physical fitness, training and bravery. They are outfitted with a device blessed by the Mage-Priests which expels burning oils to propel them through the air. These are combined with lightning-proofed armour to allow them to fly during storms, battered by rain and wind but unharmed by thunderstrikes. They are all firm believers in the doctrines of the Airyan priests and are sacred troops. They can fire their small autoguns in melee combat, although their lack of a shield results in heavy losses when the enemy recovers from the initial shock. They carry grenades to pulverise the enemy during air assaults."
#holy
#flying
#stormimmune
#hp 15
#size 3
#prot 0
#mor 14
#mr 11
#enc 3
#str 12
#att 12
#def 12
#prec 11
#mapmove 22
#ap 12
#rpcost 10000
#gcost 45
#rcost 1
#shockres 9
#weapon 1357 -- mp40
#weapon 1351 -- grenade
#weapon 6 -- short sword
#armor 623 -- iron helmet
#armor 629 -- lightning armour
#startage 25
#end

-- Valkyrie

#newmonster 6646
#name "Assault Valkyrie"
#spr1 "./Firepower/ulmreich/valkyrie1idle.tga"
#spr2 "./Firepower/ulmreich/valkyrie1attack.tga"
#nametype 119
#descr "The Valkyries are flying messengers of death from the lands of the Vanir. The Airyan Sect are deeply enamoured by the beauty and power of the Valkyries and use the purity of Ulmish blood to bind them to the Reich. The binding ritual makes them less effective at resisting magic but very loyal and they do not demand payment. Valkyries are equipped with experimental automatic rifles. They detest the cumbersome armour of the Lightning Guard, which would allow them to fly during storms but destroy their essence of grace."
#female
#holy
#flying
#hp 12
#size 4
#prot 0
#mor 16
#mr 12
#enc 3
#str 12
#att 14
#def 14
#prec 13
#mapmove 24
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1364 -- stgw44
#weapon 1351 -- grenade
#weapon 6 -- short sword
#armor 623 -- iron helmet
#armor 621 -- reinforced uniform
#startage 100
#maxage 300
#end

-- Vampir Guardsman

#newmonster 6656
#name "Vampir Guardsman"
#spr1 "./Firepower/ulmreich/vampir1idle.tga"
#spr2 "./Firepower/ulmreich/vampir1attack.tga"
#nametype 131
#descr "The Vampir Guard have been tasked by the leaders of Ulmreich with exploring and conquering the interior of the world. While they haven't yet found an entrance to the interior, they are very good at conquering cave provinces. They have magic masks which let them see in the dark, they are well trained mountaineers, and they are stealthy. They are equipped with experimental automatic rifles and tough leather uniforms for withstanding scrapes and falls. They are not actually vampires and cannot be banished."
#holy
#darkvision 100
#mountainsurvival
#stealthy 0
#hp 14
#size 3
#prot 0
#mor 13
#mr 11
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 30
#gcost 40
#rcost 1
#weapon 1364 -- stgw44
#weapon 1351 -- grenade
#weapon 6 -- short sword
#armor 10 -- leather hauberk, 8 prot 0 def 0 enc 2 res
#armor 619 -- vampir mask
#startage 25
#end

-- Vampir Officer

#newmonster 6657
#name "Vampir Officer"
#spr1 "./Firepower/ulmreich/vampir2idle.tga"
#spr2 "./Firepower/ulmreich/vampir2attack.tga"
#nametype 131
#descr "The Vampir Guard have been tasked by the leaders of Ulmreich with exploring and conquering the interior of the world. Officers in this elite formation are far better fighters than in regular Infantry regiments. They are used to getting their hands dirty during infiltrations and commando raids, although they are unsuited for commanding larger forces."
#okleader
#magicskill 9 1
#holy
#darkvision 100
#mountainsurvival
#stealthy 0
#hp 15
#size 3
#prot 0
#mor 14
#mr 12
#enc 3
#str 12
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1364 -- stgw44
#weapon 1351 -- grenade
#weapon 6 -- short sword
#armor 10 -- leather hauberk, 8 prot 0 def 0 enc 2 res
#armor 619 -- vampir mask
#startage 30
#end

-- Devil with STGW44

#newmonster 6565
#copystats 304
#spr1 "./Firepower/ulmreich/devil1idle.tga"
#spr2 "./Firepower/ulmreich/devil1attack.tga"
#name "Assault Devil"
#descr "Devils are infernal beings of great strength. Only with human sacrifice is it possible to summon and bind these evil beings. Devils are born in the fires of the Inferno and are impervious to heat and flame. Their glowing bodies radiate heat and bat-like wings grow from their shoulders. Assault Devils are armed with experimental automatic rifles and their barbed tails can sting opponents in close combat."
#clearweapons
#weapon 1364 -- stgw44
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#weapon 68 -- barbed tail
#end

-- Flamethrower (Ulmreich)

#newmonster 6564
#name "Pionier Flamethrower"
#spr1 "./Firepower/ulmreich/flamethroweridle.tga"
#spr2 "./Firepower/ulmreich/flamethrowerattack.tga"
#nametype 104
#descr "The flamethrower is a terror weapon used by specialist Pioniers to keep the enemy out of melee range. The Assault Flamethrower wears thick leather armour on top of a flame-proofed uniform and mask. Other friendly troops engulfed by the flamethrower may not be so fortunate, so care should be taken to position these Assault Flamethrowers in the frontmost ranks. The flames emitted by the weapon are imbued with the organic will of the Airyan people and will harm ethereal beings."
#hp 14
#size 3
#prot 0
#mor 12
#mr 9
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 45
#rcost 1
#fireres 12
#weapon 9 -- dagger
#weapon 1352
#armor 623
#armor 15 -- full leather, 9 prot -1 def 1 enc 3 res
#startage 30
#deathfire 3
#end

-- Deaths Head Hussar Soldier

#newmonster 6667
#name "Death's Head Hussar"
#spr1 "./Firepower/ulmreich/deaths_head_cavalry_idle.tga"
#spr2 "./Firepower/ulmreich/deaths_head_cavalry_attack.tga"
#nametype 131
#descr "The Death's Head Hussars are a venerable formation of elite cavalrymen, formerly used as bodyguards for Ulmish nobles and now fully indoctrinated with Airyan ideology. On the battlefield, they act as light cavalry, chasing down routing infantry with their curved sabres."
#mounted
#bodyguard 1
#holy
#hp 13
#size 3
#prot 0
#mor 13
#mr 11
#enc 4
#str 12
#att 13
#def 13
#prec 8
#mapmove 20
#ap 25
#rpcost 40
#gcost 35
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 623 -- iron helmet
#armor 621 -- reinforced uniform
#startage 25
#end

-- Deaths Head Hussar Officer

#newmonster 6668
#name "Death's Head Hussar Officer"
#spr1 "./Firepower/ulmreich/deaths_head_officer_idle.tga"
#spr2 "./Firepower/ulmreich/deaths_head_officer_attack.tga"
#nametype 131
#descr "The Death's Head Hussars are a venerable formation of elite cavalrymen, formerly used as bodyguards for Ulmish nobles and now fully indoctrinated with Airyan ideology. On the battlefield, they act as light cavalry, chasing down routing infantry with their curved sabres."
#okleader
#holy
#mounted
#hp 14
#size 3
#prot 0
#mor 15
#mr 11
#enc 4
#str 12
#att 14
#def 14
#prec 9
#mapmove 20
#ap 25
#rpcost 10000
#gcost 10025
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 622 -- peaked cap
#armor 621 -- reinforced uniform
#startage 30
#end

-- Ulmreich Supply Truck

#newmonster 6575
#name "Supply Truck"
#spr1 "./Firepower/ulmreich/truck_soldier_idle.tga"
#spr2 "./Firepower/ulmreich/truck_soldier_attack.tga"
#okleader
#nametype 131
#descr "This horseless carriage transports useful supplies to troops in the field. It has good speed and range thanks to its magically imbued engines which run on the power of Airyan racial purity."
#supplybonus 35
#hp 30
#size 8
#prot 15
#mor 12
#mr 10
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 22
#ap 16
#rpcost 30
#gcost 75
#rcost 30
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

-- Panzergrenadier Captain

#newmonster 6902
#name "Panzergrenadier Captain"
#spr1 "./Firepower/ulmreich/truck_officer_idle.tga"
#spr2 "./Firepower/ulmreich/truck_officer_attack.tga"
#okleader
#nametype 131
#descr "When the Panzers punch through the enemy lines to wreak havoc on the vulnerable rear areas, they often outrun the infantry and may themselves become vulnerable to encirclement. To prevent this, they are accompanied by Panzergrenadiers mounted in horseless carriages, who disembark to do battle with automatic rifles. The driver should be given orders to hide or retreat after arriving as the carriage itself is not useful in combat. Crews and passengers bring their own food with them."
#batstartsum5 6903
#castledef 5
#siegebonus 5
#patrolbonus 5
#hp 30
#size 8
#prot 15
#mor 14
#mr 11
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 24
#ap 16
#rpcost 10000
#gcost 75
#rcost 0
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

-- Panzergrenadier

#newmonster 6903
#name "Panzergrenadier"
#spr1 "./Firepower/ulmreich/soldier_stgw_idle.tga"
#spr2 "./Firepower/ulmreich/soldier_stgw_attack.tga"
#nametype 131
#descr "The Panzergrenadiers are soldiers who embark on horseless carriages for fast strikes into enemy lands and to quickly reinforce threatened provinces. They are better trained than the footsloggers and they are equipped with experimental automatic rifles."
#hp 13
#size 3
#prot 0
#mor 12
#mr 9
#enc 3
#str 12
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 15
#rcost 1
#weapon 1364 -- stgw44
#weapon 1351 -- grenade
#weapon 9 -- dagger
#armor 621
#armor 623
#startage 25
#end

----------------------------- Manica units -----------------------------

-- Slave Spearman

#newmonster
#name "Manchaka Spearman"
#spr1 "./Firepower/manica/soldier5idle.tga"
#spr2 "./Firepower/manica/soldier5attack.tga"
#nametype 126
#descr "The forefathers of the Manchaka people were Machakan slaves brought by landlords to work the plantations and serve the lords and ladies. They adopted their masters' language and customs and no longer remember the face of their fatherland. Recent political intrigue has officially freed the slaves, but old habits die hard and the Manchaka draftees are kept in line by officers with whips. Hard lives on the fields and in the slums have toughened them up."
#undisciplined
#slave
#hp 12
#size 3
#prot 0
#mor 6
#mr 10
#enc 3
#str 11
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 5
#gcost 6
#rcost 1
#weapon 1
#armor 625
#armor 620
#startage 22
#end

-- Drafted Spearman

#newmonster
#name "Drafted Spearman"
#spr1 "./Firepower/manica/soldier1idle.tga"
#spr2 "./Firepower/manica/soldier1attack.tga"
#nametype 255
#descr "Able bodied men are required to serve the armed forces when called upon by their duly elected Evangelists. When there are not enough rifles to go around, they are given spears and sent off with a minimum of training. They are slow to move strategically."
#undisciplined
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 5
#gcost 7
#rcost 1
#weapon 1
#armor 625
#armor 620
#startage 22
#end

-- Drafted Rifleman

#newmonster
#name "Drafted Rifleman"
#spr1 "./Firepower/manica/soldier2idle.tga"
#spr2 "./Firepower/manica/soldier2attack.tga"
#nametype 255
#descr "Able bodied men are required to serve in militia formations when called upon by their duly elected Evangelists. They fire powerful rifle volleys into the enemy when massed but lack fighting spirit in melee combat. They are slow to move strategically."
#undisciplined
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 8
#gcost 9
#rcost 1
#weapon 1365 -- garand
#weapon 1342 -- bayonet
#armor 620
#armor 625
#startage 22
#end

-- Infantry Rifleman

#newmonster
#name "Infantry Rifleman"
#spr1 "./Firepower/manica/soldier3idle.tga"
#spr2 "./Firepower/manica/soldier3attack.tga"
#nametype 255
#descr "The Infantry are a standing formation of recruits who have either volunteered for military service or chosen to remain in the army after their period of conscription ended. They have better training and discipline than ordinary draftees and are commensurately better paid."
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 15
#rcost 1
#weapon 1365 -- garand
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 25
#end

-- National Guard

#newmonster
#name "National Guardsman"
#spr1 "./Firepower/manica/soldier4idle.tga"
#spr2 "./Firepower/manica/soldier4attack.tga"
#nametype 255
#descr "The National Guard are the police of Manica. They are usually veterans of other branches of the armed forces. They are used to destroy domestic enemies, such as Manchakan revolts, heretics and peasant uprisings. Raiding the homes of such vermin and clearing dissidents from the streets requires a greater emphasis on melee combat than rifles allow, so they are equipped with small autoguns, stun grenades and thick leather hauberks for protection. Stun grenades can cause victims in a small area to become blinded. Guardsmen are more effective at patrolling provinces than other troops."
#patrolbonus 3
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 18
#rcost 1
#weapon 1366 -- thompson
#weapon 1374 -- stun grenade
#weapon 9 -- dagger
#armor 10 -- leather hauberk, 8 prot 0 def 0 enc 2 res
#armor 623 -- iron helmet
#startage 30
#end

-- Infantry Officer

#newmonster
#name "Infantry Officer"
#spr1 "./Firepower/manica/officer1idle.tga"
#spr2 "./Firepower/manica/officer1attack.tga"
#nametype 255
#descr "Officers of the regular forces are trained to lead large numbers of troops. They are usually selected from the more educated and wealthy citizens of Manica which ensures their loyalty. While not sacred, they have enough faith in the Awakening God for illusions and other harmful magic to be less effective - these are tests of the believer's faith, which inconvenient truths will not shake."
#goodleader
#hp 10
#size 3
#prot 0
#mor 12
#mr 11
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 30
#end

-- Manchakan Officer

#newmonster
#name "Manchaka Officer"
#spr1 "./Firepower/manica/officer2idle.tga"
#spr2 "./Firepower/manica/officer2attack.tga"
#nametype 255
#descr "The Manchakan freedmen are not exempt from service to the nation in militias but they are rarely promoted out of the rank and file. They receive officers from other regiments who have reputations for severity. In the past Manchakans were slaves and their new officers are often likened to the hated taskmasters of old."
#okleader
#taskmaster 2
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 40 -- whip
#weapon 1340
#armor 620
#armor 622
#startage 30
#end

-- Manica Scientist

#newmonster
#name "Scientist"
#spr1 "./Firepower/manica/scientist1idle.tga"
#spr2 "./Firepower/manica/scientist1attack.tga"
#nametype 255
#descr "Scientists are men of learning who delve into the secrets of elemental magic for the betterment of the nation or love of knowledge. Their scepticism is a cause of concern for the security apparatus but they are kept in line through stringent investigations and public denunciations of traitors. Scientists can also contribute towards the production of war materiel. It is said that some divinely inspired Scientists can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged by scientists with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 5
#hp 9
#size 3
#prot 0
#mor 9
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1370 -- clipboard
#armor 627 -- clothes
#armor 626 -- glasses
#startage 40
#prophetshape 6555
#end

-- Prophet shape with BAR (Scientist)

#newmonster 6555
#name "Prophet-Scientist"
#spr1 "./Firepower/manica/prophet1idle.tga"
#spr2 "./Firepower/manica/prophet1attack.tga"
#nametype 255
#descr "Scientists are men of learning who delve into the secrets of elemental magic for the betterment of the nation or love of knowledge. Their scepticism is a cause of concern for the security apparatus but they are kept in line through stringent investigations and public denunciations of traitors. Scientists can also contribute towards the production of war materiel. It is said that some divinely inspired Scientists can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged by scientists with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#poorleader
#magicskill 3 1
#magicskill 51 1
#magicskill 51 1
#custommagic 1920 10 -- fire, air, earth and water
#resources 30
#hp 9
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1369 -- bar
#weapon 6 -- shortsword
#armor 627 -- clothes
#armor 626 -- glasses
#startage 40
#end

-- Chief Scientist

#newmonster
#name "Academician"
#spr1 "./Firepower/manica/scientist2idle.tga"
#spr2 "./Firepower/manica/scientist2attack.tga"
#nametype 255
#descr "The best and brightest of the scientists gather together in academic societies to share knowledge. To the consternation of the Agents, they have shown signs of sympathy for false gods of foreign nations, some even going as far as learning forbidden magics, but they are very useful for casting complex spells so their leash has remained long thus far. It is said that some divinely inspired Academicians can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged by scientists with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#heretic 1
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#custommagic 36864 100 -- death, blood
#resources 5
#mason
#hp 9
#size 3
#prot 0
#mor 10
#mr 13
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 3
#gcost 10025
#rcost 1
#weapon 1370 -- clipboard
#armor 627 -- clothes
#armor 626 -- glasses
#startage 50
#prophetshape 6554
#end

-- Prophet shape with BAR (Academician)

#newmonster 6554
#name "Prophet-Academician"
#spr1 "./Firepower/manica/prophet2idle.tga"
#spr2 "./Firepower/manica/prophet2attack.tga"
#nametype 255
#descr "The best and brightest of the scientists gather together in academic societies to share knowledge. To the consternation of the Agents, they have shown signs of sympathy for false gods of foreign nations, some even going as far as learning forbidden magics, but they are very useful for casting complex spells so their leash has remained long thus far. It is said that some divinely inspired Academicians can produce masterpieces of the highest quality.


Rifles and other firearms are weapons forged by scientists with a combination of Fire, Air and Earth magic. While the weapon expels its projectiles magically, the bullet itself is mundane and will not harm ethereal beings."
#heretic 1
#poorleader
#magicskill 0 1
#magicskill 1 1
#magicskill 3 1
#custommagic 1920 200
#custommagic 1920 10 -- fire, air, earth and water
#custommagic 20480 100
#resources 30
#mason
#hp 9
#size 3
#prot 0
#mor 11
#mr 13
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1369 -- bar
#weapon 6 -- shortsword
#armor 627 -- clothes
#armor 626 -- glasses
#startage 50
#end

-- Machinegun

#newmonster 6650
#name "Autogun Team"
#spr1 "./Firepower/manica/machinegun1idle.tga"
#spr2 "./Firepower/manica/machinegun1attack.tga"
#nametype 255
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build. It has a metal shield to protect the crewmen, although this makes it quite slow both on the battlefield and during manoeuvres."
#reclimit 1
#castledef 10
#hp 10
#size 5
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 12
#ap 8
#rpcost 50
#gcost 75
#rcost 1
#weapon 1367
#weapon 1346
#weapon 1346
#armor 2 -- shield
#armor 621
#armor 623
#startage 25
#cleanshape
#secondshape 6651
#maxage 500
#xploss 50 -- xp gets wiped when crew dies
#end

-- Machinegun (1 dead)

#newmonster 6651
#name "Depleted Autogun"
#spr1 "./Firepower/manica/machinegun2idle.tga"
#spr2 "./Firepower/manica/machinegun2attack.tga"
#nametype 255
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#castledef 10
#hp 10
#size 4
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 12
#ap 4
#rpcost 50
#gcost 0
#rcost 0
#weapon 1368
#weapon 1346
#armor 2 -- shield
#armor 621
#armor 623
#cleanshape
#firstshape 6650
#secondshape 6652
#xploss 100 -- xp gets wiped when crew dies
#end

-- Machinegun (2 dead)

#newmonster 6652
#name "Crewless Autogun"
#spr1 "./Firepower/manica/machinegun3.tga"
#spr2 "./Firepower/manica/machinegun3.tga"
#nametype 255
#descr "The autogun is a very large rifle which can fire much faster than its smaller brethren. It is so large and fast firing it needs a crew to operate and feed it ammunition. These crewmen are vulnerable and if they die the autogun will slow and finally cease firing, although it is tough enough to survive stray arrows and be replenished after the fight is won. The intricate Air magic that goes into building the autogun, and the Fire magic eaten by it when it shoots, make it more expensive than an ordinary rifle to build."
#hp 10
#size 3
#prot 15
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 50
#gcost 0
#rcost 0
#miscshape
#itemslots 12288
#noweapon 1
#poisonres 25
#cleanshape
#firstshape 6650
#inanimate
#immobile
#woundfend 100
#neednoteat
#end

-- Agent

#newmonster 6550
#name "Agent"
#spr1 "./Firepower/manica/agent1idle.tga"
#spr2 "./Firepower/manica/agent1attack.tga"
#nametype 256
#descr "The Agency is responsible for intelligence and internal security. They are spies and spy catchers. The Agent is an initiate in the ways of espionage and serves mostly to infiltrate foreign provinces to report on troop movements, or friendly provinces to hunt for dangerous insurgents. The ingenious Water mages of Manica have devised a special ritual for Agents to discern the innermost secrets of suspected heretics. It involves placing a sacred shroud on the supplicant and pouring holy water over his head. It is believed that the magical interaction between the two turns the water into a truth serum of sorts."
#poorleader
#stealthy 10
#patrolbonus 20
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8
#weapon 1340
#weapon 1374 -- stun grenade
#armor 627 -- clothes
#armor 626 -- glasses
#startage 25
#end

-- Special Agent

#newmonster
#name "Special Agent"
#spr1 "./Firepower/manica/agent2idle.tga"
#spr2 "./Firepower/manica/agent2attack.tga"
#nametype 256
#descr "The Agency is responsible for intelligence and internal security. They are spies and spy catchers. The Special Agent is high ranking and well trained, an expert at information gathering and assassination. He is equipped with a prod which discharges lightning into those struck by it. It can incapacitate or kill depending on whether the target is wanted for questioning. He must rely on his handgun if the enemy is resistant to the effects of the stun prod, although a nonlethal takedown is always the most silent way to eliminate resistance."
#poorleader
#stealthy 20
#patrolbonus 30
#assassin
#patience 1
#spy
#hp 12
#size 3
#prot 0
#mor 14
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10000
#rcost 1
#weapon 1371 -- stun prod
#weapon 1340 -- revolver
#weapon 1374 -- stun grenade
#armor 627 -- clothes
#armor 626 -- glasses
#startage 30
#end

-- Augmented Agent

#newmonster 6653
#name "Augmented Agent"
#spr1 "./Firepower/manica/agent3idle.tga"
#spr2 "./Firepower/manica/agent3attack.tga"
#nametype 256
#descr "The Agency is responsible for intelligence and internal security. They are spies and spy catchers. The Augmented Agent is the product of secret magical rituals to strengthen an already well trained operative. His skin is an impenetrable barrier to enemy weapons and he heals at miraculous rates, even regrowing lost limbs. He is equipped with a prod which discharges lightning into those struck by it. It can incapacitate or kill depending on whether the target is wanted for questioning. The Augmented Agent is incredibly loyal and does not demand payment, as he tends to accumulate enough wealth in the field to carry out his missions. They are known for being patient men."
#okleader
#stealthy 40
#patrolbonus 40
#assassin
#patience 3
#scalewalls
#spy
#heal
#hp 16
#regeneration 30
#reinvigoration 4
#size 3
#prot 15
#mor 18
#mr 16
#enc 3
#str 14
#att 14
#def 14
#prec 14
#mapmove 18
#ap 20
#rpcost 10000
#gcost 0
#rcost 0
#coldres 10
#fireres 10
#shockres 10
#poisonres 10
#weapon 1371 -- stun prod
#weapon 1340 -- revolver
#weapon 1374 -- stun grenade
#armor 627 -- clothes
#armor 626 -- glasses
#startage 30
#maxage 200
#end

-- Field Artillery

#newmonster 6654
#name "Field Artillery"
#spr1 "./Firepower/manica/artillery1idle.tga"
#spr2 "./Firepower/manica/artillery1attack.tga"
#nametype 255
#descr "The Scientists have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges."
#okleader
#siegebonus 40
#hp 30
#size 8
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 10
#ap 4
#rpcost 10000
#gcost 250
#rcost 1
#weapon 1343
#weapon 1346
#weapon 1346
#weapon 1346
#armor 620
#armor 622
#startage 25
#maxage 500
#cleanshape
#secondshape 6655
#startitem 851
#xploss 100 -- xp gets wiped when crew dies
#end

-- Crewless Field Artillery

#newmonster 6655
#name "Crewless Artillery"
#spr1 "./Firepower/manica/artillery1nocrew.tga"
#spr2 "./Firepower/manica/artillery1nocrew.tga"
#nametype 255
#descr "The Scientists have taken the already impressive engineering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Field Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges. This particular piece has lost all its crew but it will be replenished after the battle ends."
#okleader
#siegebonus 40
#hp 20
#size 7
#prot 20
#mor 50
#mr 5
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 0
#rcost 0
#poisonres 25
#firstshape 6654
#miscshape
#itemslots 12288
#noweapon 1
#inanimate
#immobile
#woundfend 100
#neednoteat
#end

-- Evangelist-Elect

#newmonster
#name "Evangelist-Elect"
#spr1 "./Firepower/manica/priest1idle.tga"
#spr2 "./Firepower/manica/priest1attack.tga"
#nametype 255
#descr "The Evangelist-Elect is an elected priest and local politician of Manica who has not yet been deemed pious enough to join the senior priesthood of the House. Citizens tend to vote for charismatic individuals with good public speaking skills, so Evangelists are often actors and thespians, which helps them blend in to foreign populations while spreading the Word of God. Although the priestly authority of the leaders of Manica is an old tradition, it has recently been given the force of law thanks to the tireless work of the House Un-Manican Activities Committee. As they are local politicians, provinces do not need forts to elect them."
#stealthy 0
#poorleader
#holy
#magicskill 9 1
#custommagic 2048 10
#hp 9
#size 3
#prot 0
#mor 12
#mr 12
#enc 3
#str 9
#att 9
#def 9
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1373 -- holy book
#weapon 1340 -- revolver
#armor 627 -- clothes
#armor 626 -- glasses
#startage 30
#end

-- House Evangelist

#newmonster
#name "House Evangelist"
#spr1 "./Firepower/manica/priest2idle.tga"
#spr2 "./Firepower/manica/priest2attack.tga"
#nametype 255
#descr "The House of Evangelists is the senior body of elected representatives and priests in Manica. They create the laws that govern the nation through studious devotion to the Word of God. They form special communions called Committees to oversee various projects such as the implementation of legislation and the operations of the Agency. Recently, the House Un-Manican Activities Committee passed laws restricting the privileges of unbelievers in the nation, which has created a golden age of righteousness. The House was formed in response to what the citizens of Manica saw as the moral degeneration of the Kingdom of Man. They led the civil war that established Manica's independence and have upheld the righteousness and integrity of the nation ever since. Only important provinces with forts are represented in the House."
#stealthy 10
#okleader
#holy
#magicskill 9 2
#magicskill 4 2
#custommagic 2048 10
#hp 9
#size 3
#prot 0
#mor 13
#mr 13
#enc 3
#str 9
#att 9
#def 9
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10030
#rcost 1
#weapon 1373 -- holy book
#weapon 1340 -- revolver
#armor 627 -- clothes
#armor 626 -- glasses
#startage 35
#end

-- Supreme Court Judge

#newmonster
#name "Supreme Court Judge"
#spr1 "./Firepower/manica/priest3idle.tga"
#spr2 "./Firepower/manica/priest3attack.tga"
#nametype 255
#descr "The Supreme Court is a body of adjudicators who are the ultimate authority on whether legislation passed by the House is in accord with the desires of the Awakening God. Judges are appointed on the basis of their priestly authority. Communicating with the Divine has given them insight into the higher mysteries and they have a deep knowledge of Astral magic."
#okleader
#slowrec
#holy
#magicskill 9 3
#magicskill 4 3
#custommagic 2048 10
#hp 9
#size 3
#prot 0
#mor 14
#mr 14
#enc 3
#str 9
#att 9
#def 9
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10030
#rcost 1
#weapon 1373 -- holy book
#armor 627 -- clothes
#armor 626 -- glasses
#startage 50
#end

-- Doctor

#newmonster
#name "Doctor"
#spr1 "./Firepower/manica/doctor1idle.tga"
#spr2 "./Firepower/manica/doctor1attack.tga"
#nametype 259
#descr "Medicine is not as highly developed as engineering in Manica, but the skills of Doctors are nonetheless appreciated by both citizens and soldiers of the Awakening God. Many Manican citizens suffer from diseases of the mind which the Doctors cure through various rituals, such as confession, laying-on-hands, or the consumption of clay tablets inscribed with runes. The healing skills of Doctors are believed to be augmented by the payment of vast quantities of gold, which the Doctors are contractually obligated to receive from patients. This system often perplexes visitors to Manica, but the Doctors have the blessing of the Awakening God, so it is unlikely to change."
#female
#holy
#poorleader
#autohealer 1
#magicskill 6 1
#custommagic 2816 10
#hp 9
#size 3
#prot 0
#mor 9
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 9 -- dagger
#armor 626 -- glasses
#armor 627 -- clothes
#startage 45
#end

-- Marine Rifleman

#newmonster
#name "Marine Rifleman"
#spr1 "./Firepower/manica/soldier6idle.tga"
#spr2 "./Firepower/manica/soldier6attack.tga"
#nametype 257
#descr "The civil war against the Kingdom of Man involved several naval skirmishes. The Marines were formed during the war as a permanent force to defeat enemies of the Awakening God at sea. Since then they have been the staunchest defenders of Manica, winning accolades for their bravery and devotion. They wear antiquated uniforms to remind onlookers of the sacrifices of those who came before, and are considered sacred by the citizens. Some scientists mock the Marines for their single-mindedness but they are far from stupid - their resistance to harmful magic is a result of fervant belief in the victory of the Awakening God."
#holy
#formationfighter 1
#hp 12
#size 3
#prot 0
#mor 13
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 25
#rcost 1
#weapon 1365 -- garand
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623 -- iron helmet
#startage 25
#end

-- Revolutionary Standard

#newmonster 6904
#name "Revolutionary Standard"
#spr1 "./Firepower/manica/flag1idle.tga"
#spr2 "./Firepower/manica/flag1attack.tga"
#nametype 257
#descr "The history and battles of each Manican formation are proudly flown on intricate thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from a Marine regiment."
#aisinglerec
#formationfighter 1
#standard 1
#holy
#hp 12
#size 3
#prot 0
#mor 14
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 30
#rcost 4
#weapon 1365 -- garand
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623 -- iron helmet
#startage 30
#end

-- Regimental Standard (Manica)

#newmonster 6552
#name "Regimental Standard"
#spr1 "./Firepower/manica/flag2idle.tga"
#spr2 "./Firepower/manica/flag2attack.tga"
#nametype 255
#descr "The history and battles of each Manican formation are proudly flown on intricate thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from an Infantry regiment."
#aisinglerec
#standard 1
#hp 10
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 12
#gcost 20
#rcost 4
#weapon 1365 -- garand
#weapon 1351 -- grenade
#weapon 1342 -- bayonet
#armor 621
#armor 623
#startage 30
#end

-- Marine Officer

#newmonster 6905
#name "Marine Officer"
#spr1 "./Firepower/manica/officer3idle.tga"
#spr2 "./Firepower/manica/officer3attack.tga"
#nametype 257
#descr "Marines are deployed to secure Manica's interests abroad when diplomacy and assassination have failed. Officers of the Marines receive very extensive training. They are expert strategists and charismatic priests, skilled mages and fearless sailors. This makes Marine Officers very expensive to deploy, and also very vulnerable to precision strikes. Marine task forces are therefore usually composed of a large number of screens."
#expertleader
#inspirational 1
#magicskill 9 1
#magicskill 2 1
#custommagic 2816 200
#custommagic 2816 10
#sailing 400 5
#holy
#hp 12
#size 3
#prot 0
#mor 14
#mr 13
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10000
#rcost 1
#weapon 8
#weapon 1340
#armor 620
#armor 622
#startage 35
#end

-- Seal

#newmonster 6658
#name "Seal"
#spr1 "./Firepower/manica/seal1idle.tga"
#spr2 "./Firepower/manica/seal1attack.tga"
#nametype 257
#descr "The Seals are holy warriors of Manica who don vests and masks enchanted with Water and Air magic, allowing them to breathe underwater. Rifles do not work in the briny depths so Seals are outfitted with very short-ranged spearguns, powered by Air magic. Spearguns are vastly inferior to most ranged weapons on land but they give a small advantage under the sea."
#amphibian
#holy
#stealthy 0
#hp 12
#size 3
#prot 0
#mor 14
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 40
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#weapon 1351 -- grenade
#armor 617 -- seal armour
#armor 616 -- seal mask
#startage 30
#watershape 6659
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#end

#newmonster 6659
#name "Seal"
#spr1 "./Firepower/manica/seal2idle.tga"
#spr2 "./Firepower/manica/seal2attack.tga"
#nametype 257
#descr "The Seals are holy warriors of Manica who don vests and masks enchanted with Water and Air magic, allowing them to breathe underwater. Rifles do not work in the briny depths so Seals are outfitted with very short-ranged spearguns, powered by Air magic. Spearguns are vastly inferior to most ranged weapons on land but they give a small advantage under the sea."
#amphibian
#holy
#stealthy 0
#hp 12
#size 3
#prot 0
#mor 14
#mr 12
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 40
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#weapon 1351 -- grenade
#armor 617 -- seal armour
#armor 616 -- seal mask
#startage 30
#landshape 6658
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#end

-- Seal Officer

#newmonster 6660
#name "Seal Officer"
#spr1 "./Firepower/manica/seal3idle.tga"
#spr2 "./Firepower/manica/seal3attack.tga"
#nametype 257
#descr "Leaders of the Seals are trained to display initiative and courage, as they operate in isolation from other formations. They are firm believers in the republic and devout worshippers of the Awakening God. They learn many of the same Water, Air and Astral magics as the Marines. They cannot give up their armour or masks for other magic items."
#okleader
#magicskill 2 1
#magicskill 9 1
#custommagic 2816 100
#amphibian
#holy
#stealthy 0
#hp 14
#size 3
#prot 0
#mor 15
#mr 13
#enc 3
#str 12
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10030
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#weapon 1351 -- grenade
#armor 617 -- seal armour
#armor 616 -- seal mask
#startage 35
#watershape 6661
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#end

#newmonster 6661
#name "Seal Officer"
#spr1 "./Firepower/manica/seal4idle.tga"
#spr2 "./Firepower/manica/seal4attack.tga"
#nametype 257
#descr "Leaders of the Seals are trained to display initiative and courage, as they operate in isolation from other formations. They are firm believers in the republic and devout worshippers of the Awakening God. They learn many of the same Water, Air and Astral magics as the Marines. They cannot give up their armour or masks for other magic items."
#okleader
#magicskill 2 1
#magicskill 9 1
#custommagic 2816 100
#amphibian
#holy
#stealthy 0
#hp 14
#size 3
#prot 0
#mor 15
#mr 13
#enc 3
#str 12
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10030
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#weapon 1351 -- grenade
#armor 617 -- seal armour
#armor 616 -- seal mask
#startage 35
#landshape 6660
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#end

-- Flamethrower (Manica)

#newmonster 6563
#name "Flame Trooper"
#spr1 "./Firepower/manica/flamethroweridle.tga"
#spr2 "./Firepower/manica/flamethrowerattack.tga"
#nametype 255
#descr "The flamethrower is a terror weapon used by specialist National Guardsmen to keep the enemy out of melee range. The Flame Trooper wears thick leather armour on top of a flame-proofed uniform and mask. Other friendly troops engulfed by the flamethrower may not be so fortunate, so care should be taken to position these Troopers in the frontmost ranks. The flames emitted by the weapon are imbued with the power of democracy and will harm ethereal beings."
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 45
#rcost 1
#fireres 12
#weapon 9 -- dagger
#weapon 1352
#armor 623
#armor 15 -- full leather, 9 prot -1 def 1 enc 3 res
#startage 30
#deathfire 3
#end

-- Diving suit

#newmonster 6907
#name "Deep Sea Diver"
#spr1 "./Firepower/manica/divingsuitidle.tga"
#spr2 "./Firepower/manica/divingsuitattack.tga"
#nametype 257
#descr "These massive suits of bronze were originally developed by scientists to study underwater plants and recover shipwrecked valuables, but in the hands of a trained soldier they are another tool in the arsenal of the Awakening God. The cunning Air enchantments woven into the helmet allow the wearer of the suit to stay underwater for days at a time, although it is claustrophobic and very tiring to wear in combat. The Deep Sea Diver wields an enchanted speargun which can fire in the briny deeps, unlike the rifle which outclasses it in other ways."
#amphibian
#hp 12
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 11
#att 10
#def 10
#prec 8
#mapmove 14
#ap 12
#rpcost 12
#gcost 15
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#armor 615 -- diving helmet
#armor 618 -- diving suit
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#startage 25
#end

-- Diving suit officer

#newmonster 6906
#name "Deep Sea Officer"
#spr1 "./Firepower/manica/divingsuitidle.tga"
#spr2 "./Firepower/manica/divingsuitattack.tga"
#okleader
#nametype 257
#descr "These massive suits of bronze were originally developed by scientists to study underwater plants and recover shipwrecked valuables, but in the hands of a trained soldier they are another tool in the arsenal of the Awakening God. The cunning Air enchantments woven into the helmet allow the wearer of the suit to stay underwater for days at a time, although it is claustrophobic and very tiring to wear in combat. The Deep Sea Diver wields an enchanted speargun which can fire in the briny deeps, unlike the rifle which outclasses it in other ways. Officers of the divers receive limited training in the Marine schools but are selected for their strength and courage rather than any magical ability."
#amphibian
#hp 14
#size 3
#prot 0
#mor 12
#mr 11
#enc 3
#str 12
#att 11
#def 11
#prec 9
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1377 -- speargun tip
#weapon 1376 -- speargun
#armor 615 -- diving helmet
#armor 618 -- diving suit
#itemslots 786950 -- 2 hands, 1 bow, feet, 2 misc (head and body occupied by magic items)
#startage 30
#end

-- Motorised Infantry truck
-- Summons 5 Riflemen at battle start
-- 5 * 15 gold = 75 gold
-- 5 * 22 resources = 110 resources

#newmonster 6559
#name "Mounted Commander"
#spr1 "./Firepower/manica/truck_officer_idle.tga"
#spr2 "./Firepower/manica/truck_officer_attack.tga"
#okleader
#nametype 255
#descr "The armies of Manica do not often use cavalry in warfare. Instead, they place their faith in technological marvels such as this two and a half ton horseless carriage, developed by the finest scientists and academicians in the land. Tougher than a horse, it carries a small complement of mounted infantrymen who disembark from the carriage to do battle with their automatic rifles. The driver should be given orders to hide or retreat after arriving as the carriage itself is not useful in combat. Crews and passengers bring their own food with them."
#batstartsum5 6558
#castledef 5
#siegebonus 5
#patrolbonus 5
#hp 30
#size 8
#prot 15
#mor 14
#mr 11
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 24
#ap 16
#rpcost 10000
#gcost 75
#rcost 0
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

-- Motorised Rifleman

#newmonster 6558
#name "Mounted Infantryman"
#spr1 "./Firepower/manica/soldier7idle.tga"
#spr2 "./Firepower/manica/soldier7attack.tga"
#nametype 255
#descr "The Mounted Infantry are soldiers who embark on horseless carriages for fast strikes into enemy lands and to quickly reinforce threatened provinces. They are better trained than the footsloggers and they are equipped with experimental automatic rifles."
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 14
#ap 12
#rpcost 10000
#gcost 15
#rcost 1
#weapon 1369 -- bar
#weapon 9 -- dagger
#weapon 1351 -- grenade
#armor 621
#armor 623
#startage 25
#end

-- Manica Supply Truck

#newmonster 6898
#name "Supply Truck"
#spr1 "./Firepower/manica/truck_soldier_idle.tga"
#spr2 "./Firepower/manica/truck_soldier_attack.tga"
#nametype 255
#descr "This horseless carriage transports useful supplies to troops in the field. It has good speed and range thanks to its magic engine, imbued by the priests with the power of freedom."
#supplybonus 35
#hp 30
#size 8
#prot 15
#mor 12
#mr 10
#enc 2
#str 15
#att 10
#def 5
#prec 10
#mapmove 22
#ap 16
#rpcost 30
#gcost 75
#rcost 30
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1340 -- revolver
#weapon 1349 -- vehicle ram
#shockres -5
#fireres -5
#poisonres 10
#woundfend 100
#inanimate
#neednoteat
#end

----------------------------- Empire units -----------------------------

-- Sith Emperor

#newmonster 6816
#name "Dark Lord of the Sith"
#spr1 "./Firepower/Enclave/sith_emperor_idle.tga"
#spr2 "./Firepower/Enclave/sith_emperor_attack.tga"
#nametype 262
#descr "At first glance a decrepit and bent old man, this being is in fact the architect of the Sith Order and of the Empire it leads. His origins are lost to the shrouds of time but he has taken up the mantle of godhood on other worlds and now seeks to conquer this one."
#superiorleader
#okundeadleader
#okmagicleader
#pathcost 20
#startdom 2
#magicskill 1 1
#magicskill 4 1
#magicskill 5 1
#hp 12
#size 3
#prot 0
#mor 30
#mr 18
#enc 2
#str 10
#att 11
#def 12
#prec 12
#mapmove 16
#ap 9
#rpcost 10000
#gcost 10000
#rcost 1
#weapon 232 -- shock
#weapon 1306 -- force choke, tier 4
#armor 121 -- leather hood
#armor 158 -- robes
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 1000
#startage 400
#end

-- Darth Vader (hero)

#newmonster 6819
#name "Sith Apprentice"
#spr1 "./Firepower/Enclave/vader_idle.tga"
#spr2 "./Firepower/Enclave/vader_attack.tga"
#fixedname "Darth Vader"
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Darth Vader is the foremost of the Sith Lords. He is Apprentice to the Emperor himself. He is greatly feared by the Imperial generals and respected by the Lords and Masters as the epitome of Sith brutality and powerlust. His incredible martial and magical abilities are the result of an innate understanding of the Force, honed through centuries of tutelage under the Emperor. His rage is unquenchable and he will slay those around him on a whim. His many duels have resulted in the loss of several body parts which he has had replaced with magical constructs, which also serve to make him tougher. It is rumoured that he took his mask and name from his father, whom he killed in single combat at the Emperor's bidding."
#popkill 3
#goodleader
#holy
#magicskill 0 1 -- fire
#magicskill 1 1 -- air
#magicskill 4 4 -- astral
#magicskill 5 3 -- death
#magicskill 9 3 -- holy
#hp 16
#size 3
#prot 5 -- he's more machine than man
#mor 18
#mr 18
#enc 1
#str 13
#att 15
#def 16
#prec 13
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1306 -- force choke, tier 4
#weapon 397 -- bonus kick
#armor 21 -- full helmet
#armor 154 -- ancestor cuirass
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 1000
#startage 350
#end

-- Sith Overlord (multihero)

#newmonster 6818
#name "Sith Overlord"
#spr1 "./Firepower/Enclave/sith_overlord_idle.tga"
#spr2 "./Firepower/Enclave/sith_overlord_attack.tga"
#nametype 261 -- sith lord names
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Overlords are extremely old and powerful Sith Lords. Many of them were amongst the first students of the Force to lend their swords to the cause of the Empire. They have reaped rich rewards in the centuries that have passed, as they are second only to the Emperor himself in prestige and power. The junior Sith Lords, themselves ancient by human standards, have long since given up trying to usurp the Overlords."
#popkill 2
#goodleader
#holy
#magicskill 1 1 -- air
#magicskill 4 2 -- astral
#magicskill 5 2 -- death
#magicskill 9 2 -- holy
#custommagic 8064 100 -- fire/air/water/earth/astral/death
#custommagic 8064 100 -- fire/air/water/earth/astral/death
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 6144 100 -- astral/death
#hp 14
#size 3
#prot 0
#mor 16
#mr 17
#enc 1
#str 12
#att 14
#def 15
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1305 -- force choke, tier 3
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 750
#startage 350
#end

-- Sith Lord (str capital mage)

#newmonster 6813
#name "Sith Lord"
#spr1 "./Firepower/Enclave/sith_lord_idle.tga"
#spr2 "./Firepower/Enclave/sith_lord_attack.tga"
#nametype 261 -- sith lord names
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Sith Lords are the rulers of the Order. They command the loyalty of members of lesser rank, and compete against other Lords for power, influence, and prestige. Their knowledge of magic is vast, and as Masters of the Force they are entitled to use the ancient and noble honorific of Darth. They have unnaturally long lives, although they are not immortal."
#popkill 1
#slowrec
#goodleader
#holy
#magicskill 1 1 -- air
#magicskill 4 2 -- astral
#magicskill 5 2 -- death
#magicskill 9 1 -- holy
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 100 -- astral/death
#custommagic 6144 10 -- astral/death
#hp 13
#size 3
#prot 0
#mor 15
#mr 16
#enc 1
#str 11
#att 13
#def 14
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1305 -- force choke, tier 3
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 9
#fireres 9
#shockres 9
#poisonres 18
#invulnerable 18
#maxage 500
#startage 150
#end

-- Sith Master (capital priest)

#newmonster 6802
#name "Sith Master"
#spr1 "./Firepower/Enclave/sith_master_idle.tga"
#spr2 "./Firepower/Enclave/sith_master_attack.tga"
#nametype 261 -- sith lord names
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Sith Masters are some of the most senior members within the Order and are battle hardened leaders and powerful priests. This Master has chosen to dedicate her life to learning how to manipulate the Force, the energy field that binds and surrounds living beings. Against constructs and the undead she must use her Lightsabre or considerable priestly powers. She is entitled to use the ancient and noble honorific of Darth. It is said that some divinely inspired Force Masters can perform Battle Meditation, moving entire armies to great feats of heroism."
#female
#okleader
#holy
#magicskill 4 1 -- astral
#magicskill 9 3 -- holy
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 100 -- astral/death
#custommagic 6144 10 -- astral/death
#hp 13
#size 3
#prot 0
#mor 15
#mr 15
#enc 1
#str 11
#att 13
#def 14
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1305 -- force choke, tier 3
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 8
#fireres 8
#shockres 8
#poisonres 16
#invulnerable 16
#maxage 200
#startage 80
#end

-- Sith Assassin (doublebladed)

#newmonster 6808
#name "Sith Assassin"
#spr1 "./Firepower/Enclave/sith_double_idle.tga"
#spr2 "./Firepower/Enclave/sith_double_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. The Sith Assassins are experienced members of the Order who have proven themselves in single combat against both their Sith rivals and enemies outside the Order. They are greatly feared for their ability to infiltrate enemy lands through manipulation and camouflage. They often wield unorthodox weapons, such as Lightsabres with two blades. Such a weapon is so difficult to wield it is unlikely the Assassin's victims will have faced it before."
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 10 -- astral/death
#poorleader
#stealthy 20
#assassin
#patience 3
#ambidextrous 2
#holy
#hp 14
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 12
#att 14
#def 15
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10065
#rcost 1
#weapon 1303 -- doublebladed lightsabre
#weapon 1307 -- force choke, tier 2
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Sith Sorcerer (mage)

#newmonster 6817
#name "Sith Sorcerer"
#spr1 "./Firepower/Enclave/sith_knight_idle.tga"
#spr2 "./Firepower/Enclave/sith_knight_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Sith Sorcerers are journeymen members of the Order, skilled enough to achieve dominance over mere Blades and simple Warriors and ambitious enough to seek further advancement. Sorcerers are constantly manoeuvring against one another for the favour of their Lords and Masters, but also remain on the lookout for opportunities to eliminate their superiors and take their place. This is an accepted method of promotion within the Sith, as it demonstrates ability and initiative. Sorcerers have skill in wielding the Force, the energy field that surrounds all living things. This Sorcerer commands diverse magical abilities and she could serve well on the battlefield as the lynchpin of the field armies."
#female
#poorleader
#holy
#magicskill 4 1 -- astral
#magicskill 5 1 -- death
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 100 -- astral/death
#custommagic 6144 10 -- astral/death
#hp 12
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1307 -- force choke, tier 2
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Sith Inquisitor (priest)

#newmonster 6826
#name "Sith Inquisitor"
#spr1 "./Firepower/Enclave/sith_priest_idle.tga"
#spr2 "./Firepower/Enclave/sith_priest_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Sith Inquisitors are tasked with hunting down deserters from the Sith Order, searching for Jedi survivors, and spreading the dominion of the Awakening God. While the Empire is the hegemonic power and undisputed militarily, there are many pockets of rebels who continue to act as a thorn in the Empire's side. When rebel activity flares up and the local governor is unable to contain the threat, an Inquisitor is often brought in to lead the investigation and question suspects and sympathisers. On the battlefield, this Inquisitor can inspire his fellow Sith to great deeds of brutality and bravery."
#poorleader
#holy
#inquisitor
#magicskill 9 2 -- holy
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 10 -- astral/death
#hp 12
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1307 -- force choke, tier 2
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Sith Archaeologist

#newmonster 6805
#name "Sith Archaeologist"
#spr1 "./Firepower/Enclave/sith_archeologist_idle.tga"
#spr2 "./Firepower/Enclave/sith_archeologist_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. They have an ancient history on many planets and devote much time and effort to uncovering past artifacts, relics and tombs. Archaeology also takes members away from the cut throat politics of the Order. Although he has passed his training and is a competent fighter, this Sith Archaeologist has chosen to take up a quieter, less dangerous position in the Order."
#poorleader
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 6144 10 -- astral/death
#fixedresearch 6
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 13
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 70
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1304 -- force choke, tier 1
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 6
#fireres 6
#shockres 6
#poisonres 12
#invulnerable 12
#maxage 150
#startage 30
#end

-- Sith Initiate

#newmonster 6814
#name "Sith Initiate"
#spr1 "./Firepower/Enclave/sith_initiate_idle.tga"
#spr2 "./Firepower/Enclave/sith_initiate_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Inductees into the Order are all volunteers, but the training is incredibly harsh and many perish in their attempt to gain the skills and authority they covet. It is common to torture students who fail to answer questions satisfactorily. Novices are even pitted against one another in tests of courage, resolve and skill, or just to amuse their trainer. This environment encourages constantly shifting alliances and betrayals, which only become deadlier further up the ranks. A Sith Initiate is still undergoing training but has survived long enough to have some real skill and can be sent on field assignments.

If he reaches 30 points of experience, he will be promoted to the rank of Sith Marauder and will swap his mundane swords for Lightsabres."
#ambidextrous 1
#stealthy 0
#holy
#hp 11
#size 3
#prot 0
#mor 11
#mr 11
#enc 3
#str 10
#att 11
#def 12
#prec 10
#mapmove 14
#ap 12
#rpcost 20
#gcost 21
#rcost 1
#weapon 8 -- broadsword
#weapon 6 -- shortsword
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 4
#fireres 4
#shockres 4
#poisonres 8
#invulnerable 8
#startage 25
#xpshape 30
#end

-- Sith Marauder (dual wield)

#newmonster 6815
#name "Sith Marauder"
#spr1 "./Firepower/Enclave/sith_dual_idle.tga"
#spr2 "./Firepower/Enclave/sith_dual_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Experienced members are allowed some independence in how they go about achieving the goals set for them. This Marauder has mastered the art of wielding two Lightsabres at once, a feat which requires both martial skill and an uncanny awareness of his surroundings. He can accompany the Assassins during infiltrations, although he has not yet been deemed worthy of leading assassinations himself."
#stealthy 10
#ambidextrous 2
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 12
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 14
#ap 12
#rpcost 25
#gcost 45
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1302 -- short lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#invulnerable 10
#maxage 100
#startage 30
#end

-- Sith Acolyte

#newmonster 6800
#name "Sith Acolyte"
#spr1 "./Firepower/Enclave/sith_acolyte_idle.tga"
#spr2 "./Firepower/Enclave/sith_acolyte_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Inductees into the Order are all volunteers, but the training is incredibly harsh and many perish in their attempt to gain the skills and authority they covet. It is common to torture students who fail to answer questions satisfactorily. Novices are even pitted against one another in tests of courage, resolve and skill, or just to amuse their trainer. This environment encourages constantly shifting alliances and betrayals, which only become deadlier further up the ranks. A Sith Acolyte is still undergoing training but has survived long enough to understand the basics of protecting herself with the Force and can be sent on field assignments.

If she reaches 30 points of experience, she will be promoted to the rank of Sith Blade and will learn how to choke the life from distant enemies."
#female
#holy
#hp 11
#size 3
#prot 0
#mor 11
#mr 12
#enc 3
#str 10
#att 11
#def 12
#prec 10
#mapmove 14
#ap 12
#rpcost 18
#gcost 16
#rcost 1
#weapon 8 -- broadsword
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 4
#fireres 4
#shockres 4
#poisonres 8
#invulnerable 8
#startage 25
#xpshape 30
#end

-- Sith Blade (force user)

#newmonster 6801
#name "Sith Blade"
#spr1 "./Firepower/Enclave/sith_blade_idle.tga"
#spr2 "./Firepower/Enclave/sith_blade_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Experienced members are allowed some independence in how they go about achieving the goals set for them. This Blade has focused on the use of her psychic powers as her primary weapon. This is usually the first step on the long and dangerous path to becoming a Sith Lord. She is able to choke enemies to death from across the battlefield with the power of her mind. She will resort to using her Lightsabre if she is too exhausted to manipulate the Force."
#female
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 13
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 14
#ap 12
#rpcost 25
#gcost 45
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1304 -- force choke, tier 1
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#invulnerable 10
#maxage 100
#startage 30
#end

-- Sith Adept

#newmonster 6803
#name "Sith Adept"
#spr1 "./Firepower/Enclave/sith_acolyte_idle.tga"
#spr2 "./Firepower/Enclave/sith_acolyte_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Inductees into the Order are all volunteers, but the training is incredibly harsh and many perish in their attempt to gain the skills and authority they covet. It is common to torture students who fail to answer questions satisfactorily. Novices are even pitted against one another in tests of courage, resolve and skill, or just to amuse their trainer. This environment encourages constantly shifting alliances and betrayals, which only become deadlier further up the ranks. A Sith Adept is still undergoing training but has a vicious enough demeanour to have impressed his tutors and received the opportunity to prove himself.

If he reaches 30 points of experience, he will be promoted to the rank of Sith Warrior and will become deadlier in melee combat."
#holy
#hp 11
#size 3
#prot 0
#mor 11
#mr 11
#enc 3
#str 11
#att 12
#def 12
#prec 10
#mapmove 14
#ap 12
#rpcost 18
#gcost 16
#rcost 1
#weapon 8 -- broadsword
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 4
#fireres 4
#shockres 4
#poisonres 8
#invulnerable 8
#startage 25
#xpshape 30
#end

-- Sith Warrior (greatsword)

#newmonster 6804
#name "Sith Warrior"
#spr1 "./Firepower/Enclave/sith_great_idle.tga"
#spr2 "./Firepower/Enclave/sith_great_attack.tga"
#nametype 260
#descr "The Sith are a martial order of psychic warriors with a reputation for ruthlessness and brutality. Experienced members are allowed some independence in how they go about achieving the goals set for them. This Warrior uses a very large Lightsabre, requiring greater skill and strength to wield but inflicting hugely devastating strikes. The two quillons protruding from the hilt may appear dangerous to the user but they allow him greater flexibility both on the attack and the defence. Warriors tend to be simple brutes who love violence, and rarely achieve enough mastery over the Force to advance further."
#holy
#hp 14
#size 3
#prot 0
#mor 13
#mr 12
#enc 2
#str 12
#att 12
#def 13
#prec 11
#mapmove 14
#ap 12
#rpcost 25
#gcost 35
#rcost 1
#weapon 1301 -- two handed lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#invulnerable 10
#maxage 100
#startage 30
#end

-- Stormtrooper officer

#newmonster 6811
#name "Stormtrooper Officer"
#spr1 "./Firepower/Enclave/stormtrooper_general_idle.tga"
#spr2 "./Firepower/Enclave/stormtrooper_general_attack.tga"
#nametype 263
#descr "Officers of the Stormtrooper corps need to display great initiative, intelligence and loyalty to receive their commission. They are not expected to lead especially large formations, but the importance of the tasks designated to them ensures they are the cream of the Imperial crop. They are usually veterans even compared to the experienced enlisted Stormtroopers."
#patrolbonus 10
#goodleader
#hp 14
#size 3
#prot 0
#mor 14
#mr 12
#enc 2
#str 12
#att 13
#def 13
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10025
#rcost 1
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#weapon 1317 -- sonic blaster
#weapon 6 -- shortsword
#weapon 1313 -- poison grenade
#armor 21 -- full helmet
#armor 19 -- full plate
#startage 35
#end

-- Stormtrooper NCO

#newmonster 6824
#name "Stormtrooper Sergeant"
#spr1 "./Firepower/Enclave/stormtrooper_officer_idle.tga"
#spr2 "./Firepower/Enclave/stormtrooper_officer_attack.tga"
#nametype 260
#descr "Non-commissioned officers such as sergeants assist the platoon leader in implementing orders. The captain or lieutenant delegates responsibility over squads so that they can act independently of his supervision, making the formation as a whole more effective. This Stormtrooper Sergeant could turn even a rabble of conscripts into a determined force."
#bodyguard 2
#patrolbonus 4
#standard 1
#formationfighter 1
#aisinglerec
#hp 12
#size 3
#prot 0
#mor 13
#mr 11
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 24
#rcost 1
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#weapon 1317 -- sonic blaster
#weapon 6 -- shortsword
#weapon 1313 -- poison grenade
#armor 21 -- full helmet
#armor 19 -- full plate
#startage 30
#end

-- Stormtrooper, rifle

#newmonster 6810
#name "Stormtrooper"
#spr1 "./Firepower/Enclave/stormtrooper1_idle.tga"
#spr2 "./Firepower/Enclave/stormtrooper1_attack.tga"
#nametype 260
#descr "Stormtroopers are a specialist force of heavily indoctrinated veterans. Their reliability and fanaticism to the cause of the Awakening God make them well suited for use in critical tasks such as protecting Imperial dignitaries and assaulting rebel strongholds. Their heavy plate armour offers additional protection against elemental damage thanks to superior design by cunning Imperial craftsmen. Stormtroopers are also exposed to poisons during training to build up an immunity to them, and their masks filter out noxious fumes."
#bodyguard 2
#patrolbonus 4
#formationfighter 1
#hp 12
#size 3
#prot 0
#mor 12
#mr 11
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 18
#rcost 1
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#weapon 1310 -- blaster rifle
#weapon 9 -- dagger
#weapon 1313 -- poison grenade
#armor 21 -- full helmet
#armor 19 -- full plate
#startage 25
#end

-- Stormtrooper, carbine

#newmonster 6823
#name "Stormtrooper"
#spr1 "./Firepower/Enclave/stormtrooper2_idle.tga"
#spr2 "./Firepower/Enclave/stormtrooper2_attack.tga"
#nametype 260
#descr "Stormtroopers are a specialist force of heavily indoctrinated veterans. Their reliability and fanaticism to the cause of the Awakening God make them well suited for use in critical tasks such as protecting Imperial dignitaries and assaulting rebel strongholds. Their heavy plate armour offers additional protection against elemental damage thanks to superior design by cunning Imperial craftsmen. Stormtroopers are also exposed to poisons during training to build up an immunity to them, and their masks filter out noxious fumes.

Blaster carbines can be fired at point blank range in melee combat."
#bodyguard 2
#patrolbonus 4
#formationfighter 1
#hp 12
#size 3
#prot 0
#mor 12
#mr 11
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 14
#ap 12
#rpcost 20
#gcost 20
#rcost 1
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#weapon 1314 -- blaster carbine
#weapon 9 -- dagger
#weapon 1319 -- sonic grenade
#armor 21 -- full helmet
#armor 19 -- full plate
#startage 25
#end

-- Grand Moff (multihero)

#newmonster 6828
#name "Imperial Overseer"
#spr1 "./Firepower/Enclave/grandmoff_idle.tga"
#spr2 "./Firepower/Enclave/grandmoff_attack.tga"
#descr "The Grand Moffs are the leaders of the Imperial army and bureaucracy. They have authority over large regions of liberated territory, with a mandate to improve local logistics, weapons production, taxation and conscription. They can bring vast resources to bear on problems that need solving. These administrators are also experienced military leaders with deep knowledge of strategy and tactics."
#nametype 265 -- grand moff names
#superiorleader
#resources 40
#incprovdef 2
#taxcollector
#hp 10
#size 3
#prot 0
#mor 15
#mr 11
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 0
#weapon 1311 -- blaster pistol
#weapon 9 -- dagger
#armor 662 -- cap
#armor 660 -- uniform
#startage 45
#end

-- Imperial Governor

#newmonster 6820
#name "Imperial Governor"
#spr1 "./Firepower/Enclave/general_idle.tga"
#spr2 "./Firepower/Enclave/general_attack.tga"
#nametype 264 -- senior officer names
#descr "Newly liberated provinces are assigned to a governor, a senior Imperial figure selected from the armed forces or bureaucracy as the situation requires. They have a great deal of independence in how they implement Imperial rule, which allows them to increase productivity while respecting local customs and cultural boundaries."
#expertleader
#resources 20
#incprovdef 1
#taxcollector
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1311 -- blaster pistol
#weapon 9 -- dagger
#armor 662 -- cap
#armor 660 -- uniform
#startage 40
#end

-- Imperial Officer

#newmonster 6806
#name "Imperial Officer"
#spr1 "./Firepower/Enclave/officer_idle.tga"
#spr2 "./Firepower/Enclave/officer_attack.tga"
#nametype 263
#descr "Officers of the Imperial Infantry are competent field commanders who have graduated from a military academy. Their duties typically involve overseeing routine garrison and police work, and rebuilding communities after natural disasters."
#goodleader
#hp 10
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1311 -- blaster pistol
#weapon 6 -- shortsword
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 30
#end

-- Infantry NCO

#newmonster 6825
#name "Infantry Sergeant"
#spr1 "./Firepower/Enclave/sergeant_idle.tga"
#spr2 "./Firepower/Enclave/sergeant_attack.tga"
#nametype 260
#descr "Non-commissioned officers such as sergeants assist the platoon leader in implementing orders. The captain or lieutenant delegates responsibility over squads so that they can act independently of his supervision, making the formation as a whole more effective. This Infantry Sergeant will stiffen the resistance of the soldiers fighting alongside him.

After completing their tour of duty, Imperial soldiers have skills and training that can be put to use in civilian life, such as starting a business."
#standard 1
#aisinglerec
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 20
#rcost 1
#weapon 1310 -- blaster rifle
#weapon 6 -- shortsword
#weapon 1319 -- sonic grenade
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 25
#end

-- Imperial Infantry

#newmonster 6807
#name "Imperial Infantryman"
#spr1 "./Firepower/Enclave/trooper_idle.tga"
#spr2 "./Firepower/Enclave/trooper_attack.tga"
#nametype 260
#descr "The Imperial Infantry is the mainstay of the Empire's field armies. Infantrymen receive several months of training, including marksmanship, physical conditioning, and field manoeuvres. They are given a tough helmet and chest piece for protection and a powerful blaster for pouring fire into the enemy from a distance. This equipment is fairly expensive to produce because, although it often uses prison labour, only the highest quality is accepted from Imperial military contractors.

Blaster carbines can be fired at point blank range in melee combat."
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 15
#rcost 1
#weapon 1314 -- blaster carbine
#weapon 9 -- dagger
#weapon 1319 -- sonic grenade
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 22
#end

-- Imperial Conscript

#newmonster 6812
#name "Imperial Conscript"
#spr1 "./Firepower/Enclave/conscript_idle.tga"
#spr2 "./Firepower/Enclave/conscript_attack.tga"
#nametype 260
#descr "Conscripts are men hastily drafted into the army by the Empire and given little training beyond which end of a blaster to point at the enemy. Their massed fire is useful for destroying leaderless mobs of dissidents, but against an enemy making use of decoys and cover, lack of discipline would seriously impede the conscripts' effectiveness. Conscription helps forge individuals into Imperial citizens, reforms young criminal offenders, gives surge capability for wars abroad and shares the burden of defending the Empire.

Blaster carbines can be fired at point blank range in melee combat."
#undisciplined
#hp 10
#size 3
#prot 0
#mor 7
#mr 10
#enc 3
#str 9
#att 8
#def 8
#prec 9
#mapmove 12
#ap 12
#rpcost 8
#gcost 10
#rcost 1
#weapon 1314 -- blaster carbine
#weapon 9 -- dagger
#armor 118 -- half helmet
#armor 660 -- uniform
#startage 22
#end

-- Bounty Hunter

#newmonster 6822
#name "Bounty Hunter"
#spr1 "./Firepower/Enclave/bounty_hunter_idle.tga"
#spr2 "./Firepower/Enclave/bounty_hunter_attack.tga"
#nametype 260
#descr "Bounty Hunters are very experienced mercenaries who can be sent on missions against individual targets. They share the strengths and weaknesses of the mercenaries: higher pay, lower morale and an unusual skillset. They have seen enough battle to recognise the need for protection and tend to acquire military grade armour. This Bounty Hunter has managed to get his hands on a Disruptor Carbine. These nominally outlawed weapons inflict terrible wounds by flaying apart matter at the atomic level.

Disruptor carbines can be fired at point blank range in melee combat. Unlike conventional blasters, they are effective in storms."
#okleader
#stealthy 10
#assassin
#patience 1
#hp 12
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 11
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1312 -- disruptor carbine
#weapon 1313 -- poison grenade
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 9 -- plate cuirass
#startage 30
#end

-- Mercenary Captain

#newmonster 6809
#name "Mercenary Captain"
#spr1 "./Firepower/Enclave/merc_captain_idle.tga"
#spr2 "./Firepower/Enclave/merc_captain_attack.tga"
#nametype 260
#descr "Mercenaries need oversight to ensure their company's policies and procedures are being implemented. Mercenary Captains are also responsible for delivering service to meet the individual needs of all customers and wherever possible resolving enquiries at first point of contact."
#okleader
#stealthy 10
#hp 12
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 11
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1325 -- disruptor rifle
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 9 -- plate cuirass
#startage 30
#end

-- Mercenary Thug, acid variant

#newmonster 6821
#name "Mercenary Thug"
#spr1 "./Firepower/Enclave/mercenary_idle.tga"
#spr2 "./Firepower/Enclave/mercenary_attack.tga"
#nametype 260
#descr "Whether they are drawn from the Black Suns, the Zann Consortium, the Red Eclipse, or the Exchange, mercenary companies have similar capabilities. They tend to use unorthodox weapons and equipment, such as disruptors, sonic and poison weapons, and vibroblades. This can help the Empire overcome enemies with unusual strengths. However, their short-term contracts make them more expensive than standing armies, and they have lower morale than a trained force of Infantry. Mercenary companies rarely outfit their members with standardised armour. Many liberals in the Empire complain that mercenaries commit 'human rights abuses', but the rebels and terrorists the mercenaries fight are guilty of far worse, and the Empire must protect its citizens and interests abroad.

Disruptor carbines can be fired at point blank range in melee combat. Unlike conventional blasters, they are effective in storms."
#stealthy 0
#hp 10
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 16
#rcost 1
#weapon 1312 -- disruptor carbine
#weapon 1319 -- sonic grenade
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 660 -- uniform
#startage 22
#end

-- Mercenary Thug, sonic variant

#newmonster 6829
#name "Mercenary Thug"
#spr1 "./Firepower/Enclave/mercenary_idle.tga"
#spr2 "./Firepower/Enclave/mercenary_attack.tga"
#nametype 260
#descr "Whether they are drawn from the Black Suns, the Zann Consortium, the Red Eclipse, or the Exchange, mercenary companies have similar capabilities. They tend to use unorthodox weapons and equipment, such as disruptors, sonic and poison weapons, and vibroblades. This can help the Empire overcome enemies with unusual strengths. However, their short-term contracts make them more expensive than standing armies, and they have lower morale than a trained force of Infantry. Mercenary companies rarely outfit their members with standardised armour. Many liberals in the Empire complain that mercenaries commit 'human rights abuses', but the rebels and terrorists the mercenaries fight are guilty of far worse, and the Empire must protect its citizens and interests abroad.

Sonic carbines can be fired at point blank range in melee combat. Unlike conventional blasters, they are effective in storms."
#stealthy 0
#hp 10
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 16
#rcost 1
#weapon 1318 -- sonic carbine
#weapon 1313 -- poison grenade
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 660 -- uniform
#startage 22
#end

-- AT-ST

#newmonster 6827
#name "ATT Walker" -- it's not a scout, how can i call it an at-st
#spr1 "./Firepower/Enclave/at-st_idle.tga"
#spr2 "./Firepower/Enclave/at-st_idle.tga"
#nametype 263 -- junior officer names
#descr "The Imperial armies do not often use cavalry in warfare. Instead, they place their faith in technological marvels such as this All Terrain Transport Walker, developed by the finest magi and engineers in the land. Tougher than a horse, it carries a heavy blaster which can be fired against distant enemies, although it is far more useful running down small, vulnerable foes such as archers and wizards by walking over them. It costs 12 pounds of gold for maintenance and wages every month, although crews bring their own food with them."
#okleader
#hp 60
#size 8
#prot 20
#mor 16
#mr 10
#enc 2
#str 20
#att 10
#def 5
#prec 10
#mapmove 24
#ap 16
#rpcost 10000
#gcost 180
#rcost 80
#miscshape
#itemslots 12288
#startage 30
#maxage 500
#weapon 1315 -- walker kick
#weapon 1316 -- heavy blaster
#shockres -5
#coldres 5
#fireres 5
#poisonres 20
#trample
#woundfend 100
#inanimate
#pierceres
#slashres
#bluntres
#neednoteat
#mounted
#secondshape 6806 -- imperial officer
#cleanshape
#forestsurvival
#wastesurvival
#end

----------------------------- Republic units -----------------------------

-- Darth Traya

#newmonster 6858
#name "Knower of Betrayals"
#spr1 "./Firepower/Republic/hero_traya_idle.tga"
#spr2 "./Firepower/Republic/hero_traya_attack.tga"
#fixedname "Darth Traya"
#descr "Darth Traya is an ancient Sith Lord who was betrayed by her allies and betrayed them in turn. Now she seeks a worthy disciple to learn the lessons that cost her so much."
#stealthy 20
#assassin
#glamour
#poorleader
#blind
#female
#batstartsum3 6863
#magicskill 1 1 -- air
#magicskill 4 3 -- astral
#magicskill 5 2 -- death
#magicskill 6 2 -- nature
#hp 14
#size 3
#prot 0
#mor 15
#mr 15
#enc 1
#str 12
#att 15
#def 16
#prec 13
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 238 -- magic staff
#weapon 1306 -- force choke, tier 4
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 300
#startage 150
#end

-- Kreia

#newmonster 6857
#name "Blind Teacher"
#spr1 "./Firepower/Republic/hero_kreia_idle.tga"
#spr2 "./Firepower/Republic/hero_kreia_attack.tga"
#fixedname "Kreia"
#descr "Kreia is a Grey Jedi who claims to have taught many Force sensitive individuals in her time. The Council does not remember her and the Archivists can find no record of her students, but she is a very talented mage and wise philosopher so she is surely telling the truth."
#stealthy 20
#glamour
#poorleader
#blind
#female
#magicskill 1 1 -- air
#magicskill 4 3 -- astral
#magicskill 5 2 -- death
#magicskill 6 2 -- nature
#hp 14
#size 3
#prot 0
#mor 15
#mr 15
#enc 1
#str 12
#att 15
#def 16
#prec 13
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 238 -- magic staff
#weapon 1306 -- force choke, tier 4
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 300
#startage 150
#end

-- Grey Jedi Hero

#newmonster 6856
#name "Grey Battlemaster"
#spr1 "./Firepower/Republic/hero_kyle_idle.tga"
#spr2 "./Firepower/Republic/hero_kyle_attack.tga"
#fixedname "Kyle Katarn"
#descr "Kyle Katarn was once a junior officer in the Empire, until he defected to the rebels. The stress of fighting for survival allowed his latent Force sensitivity to surface and he quickly became adept at tapping into both the Light and Dark sides of the Force. His formal training was erratic and he never studied in the Jedi Temple, but his skill in battle is too great for the Council to overlook."
#stealthy 20
#glamour
#expertleader
#magicskill 0 1 -- fire
#magicskill 1 2 -- air
#magicskill 5 1 -- death
#magicskill 6 1 -- nature
#hp 16
#size 3
#prot 0
#mor 15
#mr 15
#enc 1
#str 13
#att 15
#def 16
#prec 13
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1307 -- force choke, tier 2
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 10
#fireres 10
#shockres 10
#poisonres 20
#invulnerable 20
#maxage 150
#startage 35
#end

-- Commando Hero

#newmonster 6855
#name "Commander-in-Chief"
#spr1 "./Firepower/Republic/hero_general_idle.tga"
#spr2 "./Firepower/Republic/hero_general_attack.tga"
#fixedname "General Madine"
#descr "Crix Madine was an Imperial officer who grew sick of the barbarism and tyranny of the Empire and defected to the rebels. He has fought a multitude of battles in numerous environments, and usually helped win them. Now he is one of the most senior generals in the New Republic, thanks to his expertise in strategy, tactics and logistics. He prefers to use surgical strikes with Commando teams but is also adept at organising large scale operations."
#superiorleader
#stealthy 20
#snow
#forestsurvival
#mountainsurvival
#swampsurvival 
#wastesurvival 
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1311 -- blaster pistol
#weapon 6 -- shortsword
#armor 662 -- cap
#armor 660 -- uniform
#startage 40
#end



-- Force Adept (recruit anywhere non-sacred)

#newmonster 6830
#name "Force Adept"
#spr1 "./Firepower/Republic/force_adept_idle.tga"
#spr2 "./Firepower/Republic/force_adept_attack.tga"
#nametype 260
#descr "Many of the individuals who have sensitivity to the Force are never discovered by the Jedi and must learn to unlock their potential by themselves. They are often persecuted for their strange abilities, and much of their latent talent is channelled into self-preservation. Force Adepts are very good at manipulating the minds of others in order to avoid detection and to survive encounters they cannot escape. As she was never trained in the Jedi Temple, this Force Adept is not a firm believer in the Jedi Code or the Awakening God and she is not considered sacred.

If she reaches 30 points of experience, she will be recognised as a Grey Jedi and will construct a Lightsabre."
#female
#glamour
#stealthy 0
#hp 11
#size 3
#prot 0
#mor 11
#mr 11
#enc 3
#str 10
#att 11
#def 12
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 15
#rcost 1
#weapon 8 -- broadsword
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 4
#fireres 4
#shockres 4
#poisonres 8
#invulnerable 8
#startage 25
#xpshape 30
#end

-- Grey Jedi (recruit anywhere non-sacred)

#newmonster 6831
#name "Grey Jedi"
#spr1 "./Firepower/Republic/grey_jedi_idle.tga"
#spr2 "./Firepower/Republic/grey_jedi_attack.tga"
#nametype 260
#descr "Grey Jedi either lost faith in the Jedi Code and have left the Order, became sick of the politics of the Council, or were never members to begin with. The Order usually tolerates its members going into exile in this way, as the Grey Jedi rarely side with the Sith, and often assist in missions when called upon. Thanks to many years spent hiding from Sith Inquisitors and Imperial Governors, they are very good at manipulating the minds of those around them in order to avoid detection. In combat, they can use this skill to great effect, tricking enemies into attacking thin air and effortlessly dodging blows. This Grey Jedi has either kept the Lightsabre she created during her time in the Order, or has constructed one from crystals she found in her travels."
#female
#glamour
#stealthy 10
#hp 12
#size 3
#prot 0
#mor 12
#mr 13
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 25
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#invulnerable 10
#maxage 100
#startage 30
#end

-- Grey Paladin

#newmonster 6837
#name "Grey Paladin"
#spr1 "./Firepower/Republic/grey_paladin_idle.tga"
#spr2 "./Firepower/Republic/grey_paladin_attack.tga"
#nametype 260
#descr "Some especially wilful and charismatic Grey Jedi are esteemed enough to be recognised as leaders of the otherwise individualist batch of dissidents and deserters. They are dubbed Grey Paladins, and walk the path of both the light and dark sides of the Force, exploiting the techniques of Jedi and Sith alike while rejecting their religious dogmas. They are difficult for the Jedi Order to control, as the Grey Paladins often have fundamental disagreements with the Council on policy, but when one can be recruited to the cause of the Awakening God, the Council rarely turns down the offer."
#heretic 1
#glamour
#stealthy 20
#okleader
#custommagic 12288 20 -- nature/death
#hp 14
#size 3
#prot 0
#mor 13
#mr 14
#enc 1
#str 12
#att 13
#def 14
#prec 12
#mapmove 14
#ap 12
#rpcost 10000
#gcost 85
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1307 -- force choke, tier 2
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 6
#fireres 6
#shockres 6
#poisonres 12
#invulnerable 12
#maxage 150
#startage 40
#end

-- Jedi Apprentice

#newmonster 6832
#name "Jedi Apprentice"
#spr1 "./Firepower/Republic/jedi_apprentice_idle.tga"
#spr2 "./Firepower/Republic/jedi_apprentice_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. An Apprentice is a gifted individual picked for having a connexion to the Force, the energy field that surrounds all living things. The Apprentices usually spend their time in the temples and academies, learning combat, diplomacy and the philosophy of the Jedi Code. The eldest of them may be allowed to gain experience in the field, if times are dire and the Sith are on the march. This Apprentice has been given a vibrosword, although he is not very skilled with it.

If he reaches 15 points of experience, he will be promoted to the rank of Jedi Padawan and will be allowed to construct a Lightsabre."
#holy
#hp 10
#size 3
#prot 0
#mor 11
#mr 11
#enc 3
#str 10
#att 10
#def 11
#prec 10
#mapmove 14
#ap 12
#rpcost 20
#gcost 15
#rcost 1
#weapon 8 -- broadsword
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 3
#fireres 3
#shockres 3
#poisonres 6
#invulnerable 6
#startage 16
#xpshape 15
#end

-- Jedi Padawan

#newmonster 6833
#name "Jedi Padawan"
#spr1 "./Firepower/Republic/jedi_padawan_idle.tga"
#spr2 "./Firepower/Republic/jedi_padawan_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. A Jedi Padawan has passed the basic tests of skill and knowledge, such as manipulating the Force and reciting the Jedi Code. Padawans are usually assigned to a fully trained Knight for more advanced lessons in the field. These vary according to the circumstances and the whims of the Knight, ranging from arbitrating legal disputes to hunting down bandits. The Padawan has enough weapons training to fight alongside his Knight in battle, armed with the Lightsabre he crafted to gain the rank of Padawan.

If he reaches 30 points of experience, he will be promoted to Jedi Knight, a prestigious rank awarded only to veteran warriors."
#holy
#hp 11
#size 3
#prot 0
#mor 12
#mr 12
#enc 3
#str 10
#att 11
#def 12
#prec 10
#mapmove 14
#ap 12
#rpcost 25
#gcost 25
#rcost 1
#weapon 1300 -- lightsabre
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 4
#fireres 4
#shockres 4
#poisonres 8
#invulnerable 8
#startage 20
#xpshape 30
#end

-- Jedi Knight

#newmonster 6834
#name "Jedi Knight"
#spr1 "./Firepower/Republic/jedi_knight_idle.tga"
#spr2 "./Firepower/Republic/jedi_knight_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. The Jedi Knight is a veteran member of the Order, with at least a decade of experience manipulating the Force, the energy field that binds and surrounds all living things. The Force powers learned by the Knight allow him to perform incredible feats on the battlefield. While the Sith use crude methods such as choking their enemies with brute strength, the Jedi prefer more refined techniques such as trickery and illusion. This Knight is able to manipulate the minds of enemies and deliver strikes with his Lightsabre while his foe is flailing at thin air. Knights are also respected off the field of battle for the ethical teachings of the Jedi Code. Warfare, Force-use, magic and politics are all open as avenues for advancement depending upon the skills of the Knight."
#glamour
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 13
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 14
#ap 12
#rpcost 30
#gcost 40
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 5
#fireres 5
#shockres 5
#poisonres 10
#invulnerable 10
#maxage 100
#startage 30
#end

-- Wookie Militia

#newmonster 6838
#name "Wookie Militia"
#spr1 "./Firepower/Republic/wookie_militia_idle.tga"
#spr2 "./Firepower/Republic/wookie_militia_attack.tga"
#nametype 267 -- wookie names
#descr "The Wookies are a race of demi-humans recruited by the Republic after being freed from slavery in the Empire. The Wookie Militia are lightly armed troops who seek to repay the life debt they owe to the rebels. Only spilled blood can remove the life debt - their own or the enemy's. Their greatest desire, even beyond returning to their native forest, is to slay the soldiers of the Empire which enslaved them."
#forestsurvival
#hp 22
#size 4
#prot 5
#mor 10
#mr 10
#enc 3
#str 15
#att 11
#def 11
#prec 10
#mapmove 14
#ap 12
#rpcost 5
#gcost 10
#rcost 1
#weapon 1 -- spear
#armor 1 -- buckler
#armor 120 -- leather cap
#startage 20
#end

-- Wookie Warrior

#newmonster 6839
#name "Wookie Warrior"
#spr1 "./Firepower/Republic/wookie_warrior_idle.tga"
#spr2 "./Firepower/Republic/wookie_warrior_attack.tga"
#nametype 267 -- wookie names
#descr "The Wookies are a race of demi-humans recruited by the Republic after being freed from slavery in the Empire. The Wookie Warriors are well trained troops of the Chieftains, equipped with ornate blaster rifles designed to look like crossbows. They can pour accurate fire from long ranges upon the enemies of the Republic and in doing so win acclaim for their tribes and families."
#forestsurvival
#hp 24
#size 4
#prot 5
#mor 12
#mr 10
#enc 2
#str 16
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 15
#gcost 20
#rcost 1
#weapon 1324 -- bowcaster
#weapon 8 -- broad sword
#armor 1 -- buckler
#armor 120 -- leather cap
#startage 25
#end

-- Wookie Madclaw

#newmonster 6840
#name "Wookie Madclaw"
#spr1 "./Firepower/Republic/wookie_madclaw_idle.tga"
#spr2 "./Firepower/Republic/wookie_madclaw_attack.tga"
#nametype 267 -- wookie names
#descr "The Wookies are a race of demi-humans recruited by the Republic after being freed from slavery in the Empire. The Madclaws are exiles from their tribes. They have committed the heinous crime of attacking another Wookie with their claws, rather than using ritual duelling swords as is customary. The Madclaws are thus shunned for abandoning civilised values and reverting to animal savagery. The Republic sees only the military potential these powerful berserkers represent and eagerly recruits them."
#reclimit 4
#forestsurvival
#berserk 4
#undisciplined
#animal
#hp 25
#size 4
#prot 5
#mor 15
#mr 10
#enc 2
#str 17
#att 12
#def 12
#prec 10
#mapmove 18
#ap 12
#rpcost 12
#gcost 20
#rcost 1
#weapon 33 -- claws
#weapon 20 -- bite
#startage 30
#end

-- Wookie Chieftain

#newmonster 6841
#name "Wookie Chieftain"
#spr1 "./Firepower/Republic/wookie_chieftain_idle.tga"
#spr2 "./Firepower/Republic/wookie_chieftain_attack.tga"
#nametype 267 -- wookie names
#descr "The Wookies are a race of demi-humans recruited by the Republic after being freed from slavery in the Empire. The Chieftains lead their tribes in war and peace. Leadership of a tribe is not hereditary. Contenders can challenge a Chieftain to a ritual duel to first blood. This makes them not only competent tacticians and skilful shots, but also devious swordsmen. They are willing to fight alongside their fellow tribesmen to prove their loyalty to the Republic and to seek revenge against the Empire's slavers."
#goodleader
#forestsurvival
#hp 25
#size 4
#prot 5
#mor 15
#mr 10
#enc 2
#str 17
#att 13
#def 13
#prec 12
#mapmove 18
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1310 -- blaster rifle
#weapon 8 -- broad sword
#armor 1 -- buckler
#armor 120 -- leather cap
#startage 35
#end

-- Jedi Consular (mage)

#newmonster 6835
#name "Jedi Consular"
#spr1 "./Firepower/Republic/jedi_consular_idle.tga"
#spr2 "./Firepower/Republic/jedi_consular_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. The Jedi Consulars are senior members of the Order. They are experienced at manipulating the Force, but are not yet considered Masters. Their great wisdom was once called upon for legal disputes and ethical dilemmas, but in these times of war they are more likely to find themselves wreaking havoc upon enemies of the Awakening God with the powers of the mind, or studying new methods of unleashing the destructive potential of the Force."
#poorleader
#glamour
#holy
#magicskill 4 1 -- astral
#magicskill 6 1 -- nature
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 100 -- astral/nature
#custommagic 10240 10 -- astral/nature
#hp 12
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Jedi Peacekeeper (priest)

#newmonster 6836
#name "Jedi Peacekeeper"
#spr1 "./Firepower/Republic/jedi_peacekeeper_idle.tga"
#spr2 "./Firepower/Republic/jedi_peacekeeper_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. The Peacekeepers are senior Jedi responsible for adjudicating trials, resolving disputes, and spreading the word of the Awakening God. They are powerful Force users and have an uncanny knack for telling truth from lies. They often work closely with Republic militias and lawmen."
#female
#poorleader
#glamour
#holy
#magicskill 9 2 -- holy
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 10 -- astral/nature
#hp 12
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Jedi Archivist

#newmonster 6847
#name "Jedi Archivist"
#spr1 "./Firepower/Republic/jedi_archivist_idle.tga"
#spr2 "./Firepower/Republic/jedi_archivist_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. The Archivists are journeymen members of the Jedi Order. They are researchers and administrators, although they have passed their training and can defend themselves in a fair fight. The work they perform allows more senior Jedi, such as Consulars and Peacekeepers, to carry out missions with greater knowledge of the difficulties they may face."
#glamour
#poorleader
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 10 -- astral/nature
#fixedresearch 6
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 13
#enc 2
#str 11
#att 12
#def 13
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 70
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 6
#fireres 6
#shockres 6
#poisonres 12
#invulnerable 12
#maxage 150
#startage 30
#end

-- Jedi Sentinel (spy)

#newmonster 6848
#name "Jedi Sentinel"
#spr1 "./Firepower/Republic/jedi_sentinel_idle.tga"
#spr2 "./Firepower/Republic/jedi_sentinel_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. Sentinels are senior Jedi whose Force powers manifest less in combat ability and raw magic, but rather in subtler ways. They have the patience to become experts in fields other Jedi consider beneath them. Many Sentinels cultivate contacts with criminals and shady organisations so that they can learn practical skills like lockpicking and thievery."
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 10 -- astral/nature
#poorleader
#glamour
#stealthy 20
#spy
#ambidextrous 2
#holy
#hp 14
#size 3
#prot 0
#mor 14
#mr 14
#enc 2
#str 12
#att 14
#def 15
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1302 -- short lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Jedi Councillor (str capital mage)

#newmonster 6849
#name "Jedi Councillor"
#spr1 "./Firepower/Republic/jedi_councillor_idle.tga"
#spr2 "./Firepower/Republic/jedi_councillor_attack.tga"
#nametype 266 -- jedi master names
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. Councillors sit on the Jedi High Council, and are selected for their wisdom and long decades of service to the Order. The decisions made by the Council are law within the Order, and have a great deal of influence on the law of the wider Republic. Councillors are usually selected from the ranks of the Consulars and are powerful magi, but have a number of other skills besides. Their vast knowledge of the Force entitles them to use the ancient and noble honorific of Master. It also grants them unusually long lives, and the ability to heal afflictions of body and mind."
#autohealer 1
#glamour
#slowrec
#okleader
#holy
#magicskill 1 1 -- air
#magicskill 4 2 -- astral
#magicskill 6 2 -- nature
#magicskill 9 1 -- holy
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 100 -- astral/nature
#custommagic 10240 10 -- astral/nature
#hp 13
#size 3
#prot 0
#mor 15
#mr 16
#enc 1
#str 11
#att 13
#def 14
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 9
#fireres 9
#shockres 9
#poisonres 18
#invulnerable 18
#maxage 200
#startage 150
#end

-- Jedi Master (capital priest)

#newmonster 6850
#name "Jedi Master"
#spr1 "./Firepower/Republic/jedi_master_idle.tga"
#spr2 "./Firepower/Republic/jedi_master_attack.tga"
#nametype 266 -- jedi master names
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. Some Jedi achieve a deep enough knowledge of the Force to be entitled to use the ancient and noble honorific of Master. They can sense the lifeforce of other beings, predict the future, perform incredible feats of physical strength, and to a certain extent bend reality to their will. It is said that some divinely inspired Force Masters can perform Battle Meditation, moving entire armies to great feats of heroism."
#autohealer 1
#glamour
#female
#okleader
#holy
#magicskill 4 1 -- astral
#magicskill 9 3 -- holy
#custommagic 1920 100 -- fire/air/water/earth
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 100 -- astral/nature
#custommagic 10240 10 -- astral/nature
#hp 13
#size 3
#prot 0
#mor 15
#mr 15
#enc 1
#str 11
#att 13
#def 14
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10035
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 8
#fireres 8
#shockres 8
#poisonres 16
#invulnerable 16
#maxage 175
#startage 80
#end

-- Jedi Guardian (general)

#newmonster 6851
#name "Jedi Guardian"
#spr1 "./Firepower/Republic/jedi_guardian_idle.tga"
#spr2 "./Firepower/Republic/jedi_guardian_attack.tga"
#nametype 260
#descr "The Jedi are a martial order of psychic warriors who claim to be the heirs of a plane-spanning Republic. Guardians are senior Jedi who have a proven ability to lead troops in the field. They are expert tacticians and master duellists. Their incredible prowess in melee fighting is thanks to years of training and practice, and innate ability stemming from their connexion to the Force, the energy field that surrounds and binds all living beings."
#glamour
#expertleader
#holy
#custommagic 1920 10 -- fire/air/water/earth
#custommagic 10240 10 -- astral/nature
#hp 14
#size 3
#prot 0
#mor 15
#mr 14
#enc 1
#str 12
#att 14
#def 15
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10025
#rcost 1
#weapon 1300 -- lightsabre
#weapon 397 -- bonus kick
#armor 121 -- leather hood
#armor 5 -- leather cuirass
#coldres 7
#fireres 7
#shockres 7
#poisonres 14
#invulnerable 14
#maxage 150
#startage 35
#end

-- Republic Soldier

#newmonster 6842
#name "Republic Soldier"
#spr1 "./Firepower/Republic/republic_soldier_idle.tga"
#spr2 "./Firepower/Republic/republic_soldier_attack.tga"
#nametype 260
#descr "Soldiers of the New Republic range from volunteers defending their homes, to mercenaries looking for steady pay, revolutionaries seeking political change and adventurers hunting for glory. They tend to have higher morale than the conscripts the Empire forces into battle, but their training is irregular at best and they are no match for dedicated melee troops, should their volleys of inaccurate blaster fire not deter a charge.

Blaster carbines can be fired at point blank range in melee combat."
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 14
#ap 12
#rpcost 12
#gcost 12
#rcost 1
#weapon 1314 -- blaster carbine
#weapon 9 -- dagger
#weapon 1319 -- sonic grenade
#armor 118 -- half helmet
#armor 660 -- uniform
#startage 22
#end

-- Republic Commando

#newmonster 6843
#name "Republic Commando"
#spr1 "./Firepower/Republic/republic_commando_idle.tga"
#spr2 "./Firepower/Republic/republic_commando_attack.tga"
#nametype 260
#descr "Veteran Republic soldiers are recruited into the Commandos, a formation used for important tasks such as sabotage missions and raids on Imperial facilities. They have extensive training that allows them to operate in almost any environment and fight for long periods before becoming exhausted.

Blaster carbines can be fired at point blank range in melee combat."
#stealthy 0
#formationfighter 1
#snow
#forestsurvival
#mountainsurvival 
#swampsurvival 
#wastesurvival 
#hp 12
#size 3
#prot 0
#mor 13
#mr 10
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 20
#rcost 1
#weapon 1314 -- blaster carbine
#weapon 9 -- dagger
#weapon 1319 -- sonic grenade
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 25
#end

-- Republic Sergeant

#newmonster 6844
#name "Republic Sergeant"
#spr1 "./Firepower/Republic/republic_sergeant_idle.tga"
#spr2 "./Firepower/Republic/republic_sergeant_attack.tga"
#nametype 260
#descr "Non-commissioned officers such as sergeants assist the platoon leader in implementing orders. The captain or lieutenant delegates responsibility over squads so that they can act independently of his supervision, making the formation as a whole more effective. This Sergeant will stiffen the resistance of the soldiers fighting alongside him."
#standard 1
#aisinglerec
#stealthy 0
#formationfighter 1
#snow
#forestsurvival
#mountainsurvival 
#swampsurvival 
#wastesurvival 
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 14
#ap 12
#rpcost 15
#gcost 25
#rcost 1
#weapon 1310 -- blaster rifle
#weapon 6 -- shortsword
#weapon 1319 -- sonic grenade
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 30
#end

-- Republic Officer

#newmonster 6845
#name "Republic Officer"
#spr1 "./Firepower/Republic/republic_officer_idle.tga"
#spr2 "./Firepower/Republic/republic_officer_attack.tga"
#nametype 263 -- junior officer names
#descr "The New Republic awards commissions to only the most intelligent, daring and charismatic candidates. Their job is to mobilise the troops for attacks, organise garrisons and oversee defences. They are not expected to lead from the front and carry only light weapons."
#goodleader
#hp 10
#size 3
#prot 0
#mor 14
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1311 -- blaster pistol
#weapon 6 -- shortsword
#armor 118 -- half helmet
#armor 660 -- uniform
#startage 30
#end

-- Commando Officer

#newmonster 6864
#name "Commando Officer"
#spr1 "./Firepower/Republic/commando_officer_idle.tga"
#spr2 "./Firepower/Republic/commando_officer_attack.tga"
#nametype 263 -- junior officer names
#descr "Commando units are led by veteran officers with extra training. These formations are sent to destroy installations, reconnoitre enemy defences, and seize important objectives in a variety of climates. Officers of the Commandos are much more heavily armed and armoured than their line infantry counterparts."
#stealthy 10
#goodleader
#snow
#forestsurvival
#mountainsurvival
#swampsurvival 
#wastesurvival 
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 2
#str 11
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1311 -- blaster pistol
#weapon 6 -- shortsword
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 35
#end

-- Republic Sniper

#newmonster 6846
#name "Republic Sniper"
#spr1 "./Firepower/Republic/republic_sergeant_idle.tga"
#spr2 "./Firepower/Republic/republic_sergeant_attack.tga"
#nametype 260
#descr "Veterans with steady aim and proven initiative are designated as Snipers. They move behind enemy lines, attempting to scout enemy formations and assassinate leaders. They do not receive training in the military academies and cannot lead large numbers of soldiers, but are very good shots with their blaster rifles. Although the Jedi are far stealthier and better skilled duellists, they refuse to engage in assassinations as this goes against the Jedi Code, thus the Republic military is forced to perform this vital task."
#poorleader
#stealthy 10
#assassin
#patience 2
#snow
#forestsurvival
#mountainsurvival
#swampsurvival
#wastesurvival
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 2
#str 11
#att 12
#def 12
#prec 12
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1310 -- blaster rifle
#weapon 6 -- shortsword
#armor 118 -- half helmet
#armor 9 -- plate cuirass
#startage 35
#end

-- Mercenary Captain

#newmonster 6852
#name "Mercenary Captain"
#spr1 "./Firepower/Enclave/merc_captain_idle.tga"
#spr2 "./Firepower/Enclave/merc_captain_attack.tga"
#nametype 260
#descr "Mercenaries need oversight to ensure their company's policies and procedures are being implemented. Mercenary Captains are also responsible for delivering service to meet the individual needs of all customers and wherever possible resolving enquiries at the first point of contact."
#okleader
#stealthy 10
#hp 12
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 11
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1325 -- disruptor rifle
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 9 -- plate cuirass
#startage 30
#end

-- Mercenary Thug, acid variant

#newmonster 6853
#name "Mercenary Thug"
#spr1 "./Firepower/Enclave/mercenary_idle.tga"
#spr2 "./Firepower/Enclave/mercenary_attack.tga"
#nametype 260
#descr "Whether they are drawn from the Black Suns, the Zann Consortium, the Red Eclipse, or the Exchange, mercenary companies have similar capabilities. They tend to use unorthodox weapons and equipment, such as disruptors, sonic and poison weapons, and vibroblades. This can help the Republic overcome enemies with unusual strengths. However, their short-term contracts make them more expensive than standing armies, and they have lower morale than a trained force of Soldiers. Mercenary companies rarely outfit their members with standardised armour. Mercenaries go where ever they can be paid, and so long as the Republic can afford them, Mercs have no qualms changing their loyalties.

Disruptor carbines can be fired at point blank range in melee combat. Unlike conventional blasters, they are effective in storms."
#stealthy 0
#hp 10
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 16
#rcost 1
#weapon 1312 -- disruptor carbine
#weapon 1319 -- sonic grenade
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 660 -- uniform
#startage 22
#end

-- Mercenary Thug, sonic variant

#newmonster 6854
#name "Mercenary Thug"
#spr1 "./Firepower/Enclave/mercenary_idle.tga"
#spr2 "./Firepower/Enclave/mercenary_attack.tga"
#nametype 260
#descr "Whether they are drawn from the Black Suns, the Zann Consortium, the Red Eclipse, or the Exchange, mercenary companies have similar capabilities. They tend to use unorthodox weapons and equipment, such as disruptors, sonic and poison weapons, and vibroblades. This can help the Republic overcome enemies with unusual strengths. However, their short-term contracts make them more expensive than standing armies, and they have lower morale than a trained force of Soldiers. Mercenary companies rarely outfit their members with standardised armour. Mercenaries go where ever they can be paid, and so long as the Republic can afford them, Mercs have no qualms changing their loyalties.

Sonic carbines can be fired at point blank range in melee combat. Unlike conventional blasters, they are effective in storms."
#stealthy 0
#hp 10
#size 3
#prot 0
#mor 8
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 15
#gcost 16
#rcost 1
#weapon 1318 -- sonic carbine
#weapon 1313 -- poison grenade
#weapon 6 -- shortsword
#armor 661 -- visor
#armor 660 -- uniform
#startage 22
#end

----------------------------- Shared units -----------------------------

-- Floating Lightsabre (purple)

#newmonster 6859
#name "Floating Lightsabre"
#spr1 "./Firepower/floating_lightsabre_purple_idle.tga"
#spr2 "./Firepower/floating_lightsabre_purple_attack.tga"
#descr "A Lightsabre animated by strong Force magic."
#montag 1138
#magicbeing
#inanimate
#blind
#float
#woundfend 100
#itemslots 12288
#hp 5
#size 1
#prot 10
#mor 50
#mr 10
#enc 0
#str 10
#att 10
#def 10
#prec 10
#mapmove 30
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1326 -- bash
#maxage 500
#startage 20
#end

-- Floating Lightsabre (blue)

#newmonster 6860
#name "Floating Lightsabre"
#spr1 "./Firepower/floating_lightsabre_blue_idle.tga"
#spr2 "./Firepower/floating_lightsabre_blue_attack.tga"
#descr "A Lightsabre animated by strong Force magic."
#montag 1138
#magicbeing
#inanimate
#blind
#float
#woundfend 100
#itemslots 12288
#hp 5
#size 1
#prot 10
#mor 50
#mr 10
#enc 0
#str 10
#att 10
#def 10
#prec 10
#mapmove 30
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1326 -- bash
#maxage 500
#startage 20
#end

-- Floating Lightsabre (yellow)

#newmonster 6861
#name "Floating Lightsabre"
#spr1 "./Firepower/floating_lightsabre_yellow_idle.tga"
#spr2 "./Firepower/floating_lightsabre_yellow_attack.tga"
#descr "A Lightsabre animated by strong Force magic."
#montag 1138
#magicbeing
#inanimate
#float
#blind
#woundfend 100
#itemslots 12288
#hp 5
#size 1
#prot 10
#mor 50
#mr 10
#enc 0
#str 10
#att 10
#def 10
#prec 10
#mapmove 30
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1326 -- bash
#maxage 500
#startage 20
#end

-- Floating Lightsabre (green)

#newmonster 6862
#name "Floating Lightsabre"
#spr1 "./Firepower/floating_lightsabre_green_idle.tga"
#spr2 "./Firepower/floating_lightsabre_green_attack.tga"
#descr "A Lightsabre animated by strong Force magic."
#montag 1138
#magicbeing
#inanimate
#float
#blind
#woundfend 100
#itemslots 12288
#hp 5
#size 1
#prot 10
#mor 50
#mr 10
#enc 0
#str 10
#att 10
#def 10
#prec 10
#mapmove 30
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1326 -- bash
#maxage 500
#startage 20
#end

-- Floating Lightsabre (red)

#newmonster 6863
#name "Floating Lightsabre"
#spr1 "./Firepower/floating_lightsabre_red_idle.tga"
#spr2 "./Firepower/floating_lightsabre_red_attack.tga"
#descr "A Lightsabre animated by strong Force magic."
#montag 1138
#magicbeing
#inanimate
#float
#blind
#woundfend 100
#itemslots 12288
#hp 5
#size 1
#prot 10
#mor 50
#mr 10
#enc 0
#str 10
#att 10
#def 10
#prec 10
#mapmove 30
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1300 -- lightsabre
#weapon 1326 -- bash
#maxage 500
#startage 20
#end

-------- Anglia units ----------

-- Queen Victoria, Eternal Empress

#newmonster 6892
#copystats 179 -- Master Lich
#nametype 272
#spr1 "./Firepower/Anglia/queen_victoria_idle.tga"
#spr2 "./Firepower/Anglia/queen_victoria_attack.tga"
#name "Eternal Empress"
#female
#startage 130
#descr "The Eternal Empress is the sovereign of Anglia. She has ruled the nation for almost a century. After the tragic death of her husband, the Prince Consort, she realised the path she had to walk and took up the practice of Necromancy to preserve the gains of her nation from the ravages of time and misfortune. Her growing power would have surely brought her to blows with the old Pantokrator eventually, but now her ascent to godhood is open."
#homerealm 0
#armor 148 -- crown
#armor 666 -- mourning robes, how portentous
#end

-- Sherlock Holmes hero

#newmonster 6893
#name "Master Detective"
#spr1 "./Firepower/Anglia/sherlock_idle.tga"
#spr2 "./Firepower/Anglia/sherlock_attack.tga"
#descr "Detectives are senior members of the Constabularies, with the duty of catching criminals and conducting covert investigations. Sherlock is one of the most senior and celebrated Detectives in Anglia, and is a master at uncovering the truth about plots and crimes."
#fixedname "Sherlock"
#poorleader
#spy
#stealthy 50
#patrolbonus 50
#hp 11
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 12
#def 12
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1340 -- revolver
#weapon 1334 -- sword cane
#armor 668 -- suit
#armor 670 -- hat
#startage 35
#end

-- Lord Cardigan, cavalry hero

#newmonster 6896
#name "Inspector of Cavalry"
#spr1 "./Firepower/Anglia/lord_cardigan_idle.tga"
#spr2 "./Firepower/Anglia/lord_cardigan_attack.tga"
#nametype 269
#descr "The Earl of Cardigan was appointed Inspector-General of Cavalry after demonstrating his battle prowess in a heroic charge against the sovereign's enemies in the lands of the Rus. While the cavalry brigade under his command was all but destroyed in the charge, Lord Cardigan was unscathed and personally slew dozens of Druzhina. The glory he won for himself more than made up for the loss of the brigade. While less capable as a commander than the rest of the General Staff, he is the finest cavalryman in Anglia."
#fixedname "Earl Cardigan"
#magicskill 9 2 -- holy
#goodleader
#mounted
#airshield 80
#awe 2
#holy
#hp 15
#size 3
#prot 0
#mor 15
#mr 12
#enc 4
#str 13
#att 14
#def 14
#prec 9
#mapmove 20
#ap 22
#rpcost 10000
#gcost 0
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 9 -- cuirass
#armor 118 -- half helmet
#startage 40
#end

-- Redcoat Rifleman

#newmonster 6865
#name "Redcoat Rifleman"
#spr1 "./Firepower/Anglia/redcoat_rifleman_idle.tga"
#spr2 "./Firepower/Anglia/redcoat_rifleman_attack.tga"
#nametype 268
#descr "Ordinary infantrymen are nicknamed Redcoats for the ubiquitousness of their bright red or scarlet uniforms. They are deployed all over the world to colonial skirmishes, native rebellions and wars of honour and prestige. They deliver accurate volleys of rifle fire but are not well equipped for the melee should the enemy brave the gunfire and close the distance. Recruited from the lower classes, their discipline comes more from repeated floggings than from patriotism or piety."
#formationfighter 1
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 14
#ap 12
#rpcost 10
#gcost 10
#rcost 1
#weapon 1327 -- bayonet
#weapon 1328 -- rifle
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#end

-- Green Jacket

#newmonster 6909
#name "Green Jacket"
#spr1 "./Firepower/Anglia/green_jacket_idle.tga"
#spr2 "./Firepower/Anglia/green_jacket_attack.tga"
#nametype 268
#descr "Soldiers with especially good eyesight and steady hands are selected for the Light Infantry. Wearing dark green uniforms and equipped with better rifles with experimental telescopic sights, these specialists can pick off enemy officers with ease. They have the skills and intelligence to infiltrate enemy lands while moving quickly through difficult terrain thanks to lighter equipment and a more ambitious training regime. All this freedom makes for decidedly poor discipline, with soldiers being less deferential to authority, and aristocratic officers are loathe to lead them."
#wastesurvival
#forestsurvival
#mountainsurvival 
#stealthy 0
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 12
#mapmove 16
#ap 12
#rpcost 15
#gcost 15
#rcost 1
#weapon 1353 -- scoped rifle
#weapon 1342 -- bayonet
#armor 663 -- uniform
#armor 665 -- shako
#startage 25
#end

-- Green Jacket Officer

#newmonster 6910
#name "Green Jacket Officer"
#spr1 "./Firepower/Anglia/green_jacket_idle.tga"
#spr2 "./Firepower/Anglia/green_jacket_attack.tga"
#nametype 271 -- British junior officer name
#descr "The Light Infantry is a somewhat more 'meritocratic' branch than the regular Infantry, which contributes to its poor standing in the army. Officers of the Light Infantry therefore tend to be promoted from the ranks. Being more hands-on than their aristocratic superiors or middle class peers, they have better combat abilities but less authority in leading troops. Disgracefully, they are willing to use underhanded tactics such as not marching in the open with colours flying."
#okleader
#wastesurvival
#forestsurvival
#mountainsurvival 
#stealthy 10
#assassin
#patience 2
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 13
#mapmove 18
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1353 -- scoped rifle
#weapon 1342 -- bayonet
#armor 663 -- uniform
#armor 665 -- shako
#startage 30
#end

-- Foot Guard

#newmonster 6894
#name "Grenadier Guard"
#spr1 "./Firepower/Anglia/grenadier_guard_idle.tga"
#spr2 "./Firepower/Anglia/grenadier_guard_attack.tga"
#nametype 268
#descr "Foot regiments of the Guard are extremely well drilled and loyal troops totally dedicated to protecting the sovereign. They have fought in numerous battles to acquire a reputation as the best of the infantry. Grenadier Guardsmen wear distinctive bearskin hats to make them look taller and more intimidating, with an iron skullcap underneath for protection. The small explosives that lend them their name are useful for softening up enemies before a bayonet charge."
#formationfighter 1
#bodyguard 2
#holy
#hp 12
#size 3
#prot 0
#mor 12
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 12
#mapmove 14
#ap 12
#rpcost 20
#gcost 25
#rcost 1
#weapon 1327 -- bayonet
#weapon 1328 -- rifle
#weapon 1351 -- grenade
#armor 663 -- uniform
#armor 671 -- bearskin hat
#startage 30
#end

-- Foot Guard Colours

#newmonster 6895
#name "Guard Colours"
#spr1 "./Firepower/Anglia/guard_colours_idle.tga"
#spr2 "./Firepower/Anglia/guard_colours_attack.tga"
#nametype 268
#descr "The history and battles of each Anglian formation are proudly flown on gilt-thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from a Grenadier Guards regiment."
#aisinglerec
#standard 1
#formationfighter 1
#bodyguard 2
#holy
#hp 12
#size 3
#prot 0
#mor 13
#mr 11
#enc 3
#str 11
#att 11
#def 11
#prec 12
#mapmove 14
#ap 12
#rpcost 20
#gcost 30
#rcost 3
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#weapon 1351 -- grenade
#armor 663 -- uniform
#armor 671 -- bearskin hat
#startage 30
#end

-- Redcoat Officer

#newmonster 6866
#name "Redcoat Officer"
#spr1 "./Firepower/Anglia/redcoat_officer_idle.tga"
#spr2 "./Firepower/Anglia/redcoat_officer_attack.tga"
#nametype 271 -- British junior officer name
#descr "Officers of the infantry are well trained and educated professionals from the middle classes, often with years of service in less glamorous positions in the colonial gendarmerie. They are rarely promoted into the general staff as they lack noble birth or the money to buy further commissions."
#goodleader
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10005
#rcost 1
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#armor 663 -- uniform
#startage 30
#end

-- Cuirassier

#newmonster 6867
#name "Cuirassier"
#spr1 "./Firepower/Anglia/cuirassier_idle.tga"
#spr2 "./Firepower/Anglia/cuirassier_attack.tga"
#nametype 268
#descr "Amongst the heaviest cavalry available to Anglia, these shock forces have enough armour to resist enemy ranged fire and engage in close combat with their heavy cavalry sabres and pistols. Cavalry troopers are recruited from the middle classes and look down on the footsloggers in many ways."
#formationfighter 1
#mounted
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 5
#str 11
#att 12
#def 12
#prec 8
#mapmove 20
#ap 22
#rpcost 40
#gcost 35
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 25
#end

-- Cavalry Captain

#newmonster 6868
#name "Cavalry Captain"
#spr1 "./Firepower/Anglia/cavalry_captain_idle.tga"
#spr2 "./Firepower/Anglia/cavalry_captain_attack.tga"
#nametype 269
#descr "Drawn from wealthy aristocrats with a desire to win glory in the field, cavalry officers have bought a commission to lead troops as head of a regiment or company. In the traditionally minded Anglian society, this combination of birth and money is better proof of a candidate's potential than any amount of training."
#okleader
#mounted
#hp 13
#size 3
#prot 0
#mor 14
#mr 10
#enc 5
#str 12
#att 13
#def 13
#prec 9
#mapmove 20
#ap 22
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 30
#end

-- Household Guard

#newmonster 6869
#name "Household Cavalry"
#spr1 "./Firepower/Anglia/household_guard_idle.tga"
#spr2 "./Firepower/Anglia/household_guard_attack.tga"
#nametype 268
#descr "Mounted regiments of the Guard have the highest order of precedence in the army. These elites are drawn from the sons of minor nobility and the bastards of dukes and princes. Equipped as Cuirassiers, they have the trust of the royal family and serve as their personal bodyguards. With their absolute faith in the righteousness of the Anglian cause, they are sacred troops."
#mounted
#holy
#bodyguard 3
#formationfighter 1
#hp 13
#size 3
#prot 0
#mor 14
#mr 11
#enc 4
#str 12
#att 13
#def 13
#prec 8
#mapmove 20
#ap 22
#rpcost 45
#gcost 50
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 30
#end

-- Household Guard Captain

#newmonster 6870
#name "Captain of the Guard"
#spr1 "./Firepower/Anglia/household_captain_idle.tga"
#spr2 "./Firepower/Anglia/household_captain_attack.tga"
#nametype 269
#descr "The leaders of the formations with the highest order of precedence in the Anglian army, Captains of the Guard have absolute certainty in their abilities. Some of them have even attended military classes in between bouts of martial sports and hunts. Their headstrong mentality together with valiantly leading from the front tends to make up for the frequent shortcomings in their strategies."
#okleader
#mounted
#magicskill 9 1
#holy
#hp 14
#size 3
#prot 0
#mor 15
#mr 12
#enc 4
#str 13
#att 14
#def 14
#prec 9
#mapmove 20
#ap 22
#rpcost 10000
#gcost 10020
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 35
#end

-- Hussar

#newmonster 6871
#name "Hussar"
#spr1 "./Firepower/Anglia/hussar_idle.tga"
#spr2 "./Firepower/Anglia/hussar_attack.tga"
#nametype 268
#descr "The most prestigious light cavalry of Anglia, Hussars dress in flamboyant uniforms of blue and gold, and have reputations as hard drinkers and womanisers. Their task in combat, if they can overcome their headaches, is to outflank enemy formations and chase down routing infantry with their curved sabres."
#mounted
#hp 11
#size 3
#prot 0
#mor 13
#mr 10
#enc 4
#str 10
#att 12
#def 12
#prec 8
#mapmove 20
#ap 26
#rpcost 35
#gcost 25
#rcost 1
#pillagebonus 2
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 665 -- shako
#armor 663 -- uniform
#startage 25
#end

-- Police Constable

#newmonster 6872
#name "Police Constable"
#spr1 "./Firepower/Anglia/constable_idle.tga"
#spr2 "./Firepower/Anglia/constable_attack.tga"
#nametype 268
#descr "Constabularies are established by Anglia to maintain order amongst the lower classes. They vary in organisation from province to province, taking the form of paramilitary gendarmes in the colonies and civilian thiefcatchers in the imperial core. They are lightly armed with truncheons and pistols."
#patrolbonus 1
#hp 10
#size 3
#prot 0
#mor 9
#mr 10
#enc 3
#str 10
#att 9
#def 9
#prec 10
#mapmove 12
#ap 12
#rpcost 5
#gcost 9
#rcost 1
#weapon 252 -- club
#weapon 1340 -- revolver
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#end

-- Lancer

#newmonster 6873
#name "Uhlan"
#spr1 "./Firepower/Anglia/lancer_idle.tga"
#spr2 "./Firepower/Anglia/lancer_attack.tga"
#nametype 268
#descr "Light cavalrymen armed with lances and sabres, the role of Uhlan units is to charge into vulnerable points in the enemy's line and open them up for exploitation. Cavalry troopers are recruited from the middle classes and look down on the footsloggers in many ways."
#mounted
#hp 11
#size 3
#prot 0
#mor 12
#mr 10
#enc 4
#str 10
#att 12
#def 12
#prec 8
#mapmove 20
#ap 24
#rpcost 35
#gcost 25
#rcost 1
#weapon 4 -- lance
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 665 -- shako
#armor 663 -- uniform
#startage 25
#end

-- Maxim Gun

#newmonster 6874
#name "Maxim Gun Team"
#spr1 "./Firepower/Anglia/maxim_gun_2_crew_idle.tga"
#spr2 "./Firepower/Anglia/maxim_gun_2_crew_attack.tga"
#nametype 268
#descr "'Whatever happens, we have got,
The Maxim Gun, and they have not.'

A masterpiece of the Anglian gunsmiths, this fast-firing gun uses so much ammunition it needs a team to feed it fresh magazines. These crewmen are vulnerable and if they die the gun will slow and finally cease firing, although it is tough enough to withstand stray arrows and be replenished after the battle."
#reclimit 1
#castledef 10
#formationfighter 1
#hp 10
#size 5
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 10
#rpcost 50
#gcost 75
#rcost 1
#weapon 1330 -- maxim gun
#weapon 1332 -- crewman's sword
#weapon 1332 -- crewman's sword
#armor 663 -- uniform
#armor 664 -- pith helmet
#cleanshape
#secondshape 6875
#startage 25
#maxage 500
#xploss 50 -- xp gets wiped when crew dies
#end

-- Maxim Gun (1 dead)

#newmonster 6875
#name "Depleted Maxim Gun"
#spr1 "./Firepower/Anglia/maxim_gun_1_crew_idle.tga"
#spr2 "./Firepower/Anglia/maxim_gun_1_crew_attack.tga"
#nametype 268
#descr "'Whatever happens, we have got,

The Maxim Gun, and they have not.'

A masterpiece of the Anglian gunsmiths, this fast-firing gun uses so much ammunition it needs a team to feed it fresh magazines. These crewmen are vulnerable and if they die the gun will slow and finally cease firing, although it is tough enough to withstand stray arrows and be replenished after the battle."
#castledef 10
#formationfighter 1
#hp 10
#size 4
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 6
#rpcost 60
#gcost 0
#rcost 0
#weapon 1331 -- slowed maxim gun
#weapon 1332 -- crewman's sword
#armor 663 -- uniform
#armor 664 -- pith helmet
#cleanshape
#firstshape 6874
#secondshape 6876
#startage 25
#maxage 500
#xploss 100 -- xp gets wiped when crew dies
#end

-- Maxim Gun (2 dead)

#newmonster 6876
#name "Crewless Maxim Gun"
#spr1 "./Firepower/Anglia/maxim_gun_0_crew_idle.tga"
#spr2 "./Firepower/Anglia/maxim_gun_0_crew_idle.tga"
#nametype 268
#descr "'Whatever happens, we have got,

The Maxim Gun, and they have not.'

A masterpiece of the Anglian gunsmiths, this fast-firing gun uses so much ammunition it needs a team to feed it fresh magazines. These crewmen are vulnerable and if they die the gun will slow and finally cease firing, although it is tough enough to withstand stray arrows and be replenished after the battle."
#formationfighter 1
#hp 10
#size 3
#prot 15
#mor 50
#mr 10
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 60
#gcost 0
#rcost 0
#miscshape
#itemslots 12288
#noweapon 1
#poisonres 25
#cleanshape
#firstshape 6874
#inanimate
#immobile
#woundfend 100
#neednoteat
#startage 25
#maxage 500
#end

-- Dragoon

#newmonster 6877
#name "Dragoon"
#spr1 "./Firepower/Anglia/dragoon_idle.tga"
#spr2 "./Firepower/Anglia/dragoon_attack.tga"
#nametype 268
#descr "With a role somewhere between a heavy cavalryman and a light infantryman, the Dragoon has a social status likewise in-between, and Dragoon units constantly seek to demonstrate their horsemanship to prove themselves the equal of other cavalry formations. They carry shorter firearms than the footsloggers, firing a less powerful round, but the weapon is much more wieldy on horseback and can be fired in the melee like a pistol. Cavalry troopers are recruited from the middle classes and look down on the footsloggers in many ways."
#mounted
#hp 11
#size 3
#prot 0
#mor 12
#mr 10
#enc 4
#str 10
#att 12
#def 12
#prec 9
#mapmove 20
#ap 24
#rpcost 35
#gcost 25
#rcost 1
#weapon 1333 -- carbine
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 663 -- uniform
#startage 25
#end

-- General Staff Officer

#newmonster 6878
#name "General Staff Officer"
#spr1 "./Firepower/Anglia/general_staff_idle.tga"
#spr2 "./Firepower/Anglia/general_staff_attack.tga"
#nametype 269
#descr "The most senior commanders in Anglia, the General Staff formulate the grand strategies that will defeat the nation's enemies. By expertly plotting out the intricate manoeuvres and encirclements on maps and charts, the generals have a good idea of how battles ought to go."
#expertleader
#mounted
#hp 12
#size 3
#prot 0
#mor 14
#mr 10
#enc 4
#str 11
#att 12
#def 12
#prec 9
#mapmove 20
#ap 24
#rpcost 10000
#gcost 10005
#rcost 1
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 665 -- shako
#armor 663 -- uniform
#startage 40
#end

-- Camel Rider

#newmonster 6879
#name "Camelier"
#spr1 "./Firepower/Anglia/camel_rider_idle.tga"
#spr2 "./Firepower/Anglia/camel_rider_attack.tga"
#nametype 268
#descr "The Imperial Camel Corps is a recent innovation and the traditional cavalry refuse to be classified alongside them. They fall under the command of the colonial authorities and are experts at waging war in the deserts and wastes of the far peripheries. Camels are not as fast as horses but are tougher and have better endurance."
#mounted
#wastesurvival
#hp 11
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 11
#def 11
#prec 9
#mapmove 20
#ap 18
#rpcost 35
#gcost 25
#rcost 1
#weapon 8 -- broadsword
#weapon 1333 -- carbine
#weapon 1335 -- camel bite
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#end

-- Camel Commander

#newmonster 6880
#name "Camel Commander"
#spr1 "./Firepower/Anglia/camel_captain_idle.tga"
#spr2 "./Firepower/Anglia/camel_captain_attack.tga"
#nametype 271 -- British junior officer name
#descr "The Imperial Camel Corps is a recent innovation and the traditional cavalry refuse to be classified alongside them. They fall under the command of the colonial authorities and are experts at waging war in the deserts and wastes of the far peripheries. Camels are not as fast as horses but are tougher and have better endurance."
#okleader
#mounted
#wastesurvival
#hp 12
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 11
#att 12
#def 12
#prec 9
#mapmove 20
#ap 18
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#weapon 1335 -- camel bite
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#end

-- Psychic Medium (Astral/Death)

#newmonster 6881
#name "Medium"
#spr1 "./Firepower/Anglia/mystic_idle.tga"
#spr2 "./Firepower/Anglia/mystic_attack.tga"
#nametype 270 -- British women names
#descr "Since the untimely passing of the prince consort several decades ago, Anglian society has become obsessed with seances and supernatural mysticism. Contacting the dead for advice and solace is a common social ritual, and the psychic Mediums who lead these rituals are honoured and rewarded."
#poorleader
#magicskill 4 1 -- astral
#magicskill 5 1 -- death
#custommagic 6144 100 -- astral/death
#custommagic 6144 10 -- astral/death
#nobadevents 3
#hp 9
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 238 -- magic staff
#armor 666 -- mourning robes
#armor 667 -- mourning hood
#startage 35
#end

-- Engineer (Elemental)

#newmonster 6882
#name "Engineer"
#spr1 "./Firepower/Anglia/engineer_idle.tga"
#spr2 "./Firepower/Anglia/engineer_attack.tga"
#nametype 268
#descr "Equal parts inventor, architect and businessman, this Engineer is one of the men at the centre of the ongoing industrial revolution in Anglia. He plans and builds the great works of the nation: iron bridges, factories, roads and seaports."
#poorleader
#magicskill 3 1 -- earth
#magicskill 51 1 -- elemental
#magicskill 51 1 -- elemental
#custommagic 1920 10 -- fire, air, earth and water
#drainimmune
#resources 5
#hp 9
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 1334 -- sword cane
#armor 668 -- suit
#armor 669 -- top hat
#startage 35
#end

-- Great Engineer (Elemental, capital)

#newmonster 6883
#name "Great Engineer"
#spr1 "./Firepower/Anglia/great_engineer_idle.tga"
#spr2 "./Firepower/Anglia/great_engineer_attack.tga"
#nametype 268
#descr "The Great Engineer is an accomplished elementalist who has overseen the construction of massive artifices. The largest public buildings in Anglia owe their dignified sturdiness to these geniuses."
#poorleader
#magicskill 0 1 -- fire
#magicskill 1 1 -- air
#magicskill 3 1 -- earth
#custommagic 1920 200 -- fire, air, earth and water
#custommagic 1920 10 -- fire, air, earth and water
#drainimmune
#resources 5
#mason
#hp 9
#size 3
#prot 0
#mor 10
#mr 15
#enc 3
#str 9
#att 8
#def 8
#prec 10
#mapmove 16
#ap 12
#rpcost 3
#gcost 10025
#rcost 1
#weapon 1334 -- sword cane
#armor 668 -- suit
#armor 669 -- top hat
#startage 40
#end

-- Rector

#newmonster 6884
#name "Rector"
#spr1 "./Firepower/Anglia/rector_idle.tga"
#spr2 "./Firepower/Anglia/rector_attack.tga"
#nametype 268
#descr "The Rector is a local parish priest. He leads the holy communions held to celebrate every birth, wedding and death."
#poorleader
#holy
#magicskill 9 1
#hp 9
#size 3
#prot 0
#mor 10
#mr 12
#enc 3
#str 9
#att 9
#def 9
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10000
#rcost 1
#weapon 9 -- dagger
#armor 158 -- robes
#startage 30
#end

-- Dean

#newmonster 6885
#name "Dean"
#spr1 "./Firepower/Anglia/dean_idle.tga"
#spr2 "./Firepower/Anglia/dean_attack.tga"
#nametype 268
#descr "A Dean is appointed by the sovereign to lead cathedrals in major cities. He has much more priestly authority than a Rector and has skill at organising large numbers of worshippers."
#okleader
#holy
#magicskill 9 2
#hp 9
#size 3
#prot 0
#mor 12
#mr 15
#enc 3
#str 9
#att 9
#def 9
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10000
#rcost 1
#weapon 9 -- dagger
#armor 158 -- robes
#startage 40
#end

-- Detective

#newmonster 6886
#name "Detective"
#spr1 "./Firepower/Anglia/detective_idle.tga"
#spr2 "./Firepower/Anglia/detective_attack.tga"
#nametype 268
#descr "Detectives are senior members of the Constabularies, with the duty of catching criminals and conducting covert investigations. Some of the more adventurous Detectives have even been known to travel abroad to act as spies for the government."
#poorleader
#spy
#stealthy 30
#patrolbonus 30
#hp 10
#size 3
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 11
#def 11
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 80 -- autocalc says 50
#rcost 1
#weapon 1340 -- revolver
#weapon 1334 -- sword cane
#armor 668 -- suit
#armor 670 -- hat
#startage 35
#end

-- Light Artillery

#newmonster 6887
#name "Light Artillery"
#spr1 "./Firepower/Anglia/light_artillery_idle.tga"
#spr2 "./Firepower/Anglia/light_artillery_attack.tga"
#nametype 271 -- British junior officer name
#descr "The Engineers have taken the already impressive ironmongering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Light Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges."
#okleader
#siegebonus 30
#hp 30
#size 7
#prot 0
#mor 12
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 12
#ap 6
#rpcost 10000
#gcost 200
#rcost 1
#weapon 1336 -- light artillery tube
#weapon 1332 -- crewman's sword
#weapon 1332 -- crewman's sword
#weapon 1332 -- crewman's sword
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#maxage 500
#cleanshape
#secondshape 6888
#xploss 100 -- xp gets wiped when crew dies
#end

-- Crewless Light Artillery

#newmonster 6888
#name "Crewless Artillery"
#spr1 "./Firepower/Anglia/light_artillery_crewless.tga"
#spr2 "./Firepower/Anglia/light_artillery_crewless.tga"
#nametype 271 -- British junior officer name
#descr "The Engineers have taken the already impressive ironmongering of the rifle and vastly increased its size. Firing explosive shells that rip apart enemies and fortifications alike with fire and shrapnel, Light Artillery is a slow but steady means of pushing back the enemies of the Awakening God. Each piece should be kept far away from melee combat, especially enemy cavalry charges. This particular piece has lost all its crew but it will be replenished after the battle ends."
#okleader
#siegebonus 30
#hp 20
#size 6
#prot 20
#mor 50
#mr 5
#enc 0
#str 10
#att 5
#def 0
#prec 10
#mapmove 0
#ap 2
#rpcost 10000
#gcost 0
#rcost 0
#poisonres 25
#miscshape
#firstshape 6887
#itemslots 12288
#noweapon 1
#inanimate
#immobile
#woundfend 100
#neednoteat
#maxage 500
#end

-- Regimental Colours

#newmonster 6889
#name "Regimental Colours"
#spr1 "./Firepower/Anglia/redcoat_standard_idle.tga"
#spr2 "./Firepower/Anglia/redcoat_standard_attack.tga"
#nametype 268
#descr "The history and battles of each Anglian formation are proudly flown on gilt-thread banners fluttering above the soldiers as they march. This display improves their morale. The standard bearer is usually a low ranking officer, in this case from a line infantry regiment."
#aisinglerec
#standard 1
#formationfighter 1
#hp 10
#size 3
#prot 0
#mor 11
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 14
#ap 12
#rpcost 10
#gcost 15
#rcost 3
#weapon 8 -- broadsword
#weapon 1340 -- revolver
#armor 663 -- uniform
#armor 664 -- pith helmet
#startage 25
#end

-- Light Cornet

#newmonster 6890
#name "Light Cornet"
#spr1 "./Firepower/Anglia/cavalry_cornet_idle.tga"
#spr2 "./Firepower/Anglia/cavalry_cornet_attack.tga"
#nametype 268
#descr "Musicians accompany Anglian troops to help them keep time, to relay orders, and to improve morale. This cavalryman uses a cornet, and the cheerful tunes he plays are likely the last thing his enemies will hear before the charge bursts through their lines."
#aisinglerec
#standard 1
#mounted
#hp 11
#size 3
#prot 0
#mor 13
#mr 10
#enc 4
#str 10
#att 12
#def 12
#prec 8
#mapmove 20
#ap 24
#rpcost 35
#gcost 30
#rcost 3
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 663 -- uniform
#startage 25
#end

-- Heavy Cornet

#newmonster 6891
#name "Heavy Cornet"
#spr1 "./Firepower/Anglia/cuirassier_cornet_idle.tga"
#spr2 "./Firepower/Anglia/cuirassier_cornet_attack.tga"
#nametype 268
#descr "Musicians accompany Anglian troops to help them keep time, to relay orders, and to improve morale. This cuirassier uses a cornet, and the cheerful tunes he plays are likely the last thing his enemies will hear before the charge bursts through their lines."
#formationfighter 1
#aisinglerec
#standard 1
#mounted
#hp 12
#size 3
#prot 0
#mor 13
#mr 10
#enc 5
#str 11
#att 12
#def 12
#prec 8
#mapmove 20
#ap 22
#rpcost 40
#gcost 40
#rcost 3
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 25
#end

-- Household Guard Cornet

#newmonster 6897
#name "Guard Cornet"
#spr1 "./Firepower/Anglia/household_cornet_idle.tga"
#spr2 "./Firepower/Anglia/household_cornet_attack.tga"
#nametype 268
#descr "Musicians accompany Anglian troops to help them keep time, to relay orders, and to improve morale. This Guardsman uses a cornet, and the cheerful tunes he plays are likely the last thing his enemies will hear before the charge bursts through their lines."
#mounted
#holy
#bodyguard 3
#formationfighter 1
#aisinglerec
#standard 1
#hp 13
#size 3
#prot 0
#mor 15
#mr 11
#enc 4
#str 12
#att 13
#def 13
#prec 8
#mapmove 20
#ap 22
#rpcost 45
#gcost 55
#rcost 3
#weapon 1340 -- revolver
#weapon 8 -- broadsword
#weapon 56 -- hoof
#armor 118 -- half helmet
#armor 9 -- cuirass
#startage 30
#end

-- Gunslinger

#newmonster 6911
#name "Gunslinger"
#spr1 "./Firepower/Gilead/gunman_red_idle.tga"
#spr2 "./Firepower/Gilead/gunman_red_attack.tga"
#nametype 273
#descr "d."
#okleader
#hp 12
#size 3
#prot 0
#mor 13
#mr 10
#enc 3
#str 11
#att 11
#def 11
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1329 -- pistol
#armor 672 -- cowboy hat
#armor 673 -- poncho
#startage 30
#end

-- Hired Gun

#newmonster 6912
#name "Hired Gun"
#spr1 "./Firepower/Gilead/gunman_brown_idle.tga"
#spr2 "./Firepower/Gilead/gunman_brown_attack.tga"
#nametype 273
#descr "d."
#hp 10
#size 3
#prot 0
#mor 10
#mr 10
#enc 3
#str 10
#att 10
#def 10
#prec 10
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1329 -- pistol
#armor 672 -- cowboy hat
#armor 673 -- poncho
#startage 30
#end

-- Innkeeper 

#newmonster 6913
#name "Innkeeper"
#spr1 "./Firepower/Gilead/gunman_grey_idle.tga"
#spr2 "./Firepower/Gilead/gunman_grey_attack.tga"
#nametype 273
#descr "d."
#poorleader
#magicskill 2 1
#magicskill 6 1
#hp 11
#size 3
#prot 0
#mor 12
#mr 13
#enc 3
#str 10
#att 10
#def 10
#prec 11
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1329 -- pistol
#armor 672 -- cowboy hat
#armor 674 -- clothes
#startage 30
#end

-- Sheriff 

#newmonster 6914
#name "Sheriff"
#spr1 "./Firepower/Gilead/gunman_blue_idle.tga"
#spr2 "./Firepower/Gilead/gunman_blue_attack.tga"
#nametype 273
#descr "d."
#goodleader
#magicskill 9 2
#holy
#hp 13
#size 3
#prot 0
#mor 14
#mr 12
#enc 3
#str 11
#att 12
#def 12
#prec 13
#mapmove 16
#ap 12
#rpcost 10000
#gcost 10010
#rcost 1
#weapon 6 -- shortsword
#weapon 1329 -- pistol
#armor 672 -- cowboy hat
#armor 674 -- clothes
#startage 30
#end

-------- NAME TYPES --------

-- Random names for bunkers

#selectnametype 251
#addname "Strongpoint Anna"
#addname "Strongpoint Boris"
#addname "Strongpoint Vasily"
#addname "Strongpoint Gregory"
#addname "Strongpoint Dmitri"
#addname "Strongpoint Elena"
#addname "Strongpoint Zhenya"
#addname "Strongpoint Zinaida"
#addname "Strongpoint Ivan"
#addname "Strongpoint Konstantin"
#addname "Strongpoint Leonid"
#addname "Strongpoint Mikhail"
#addname "Strongpoint Nikolai"
#addname "Strongpoint Olga"
#addname "Strongpoint Pavel"
#addname "Strongpoint Roman"
#addname "Strongpoint Semyon"
#addname "Strongpoint Tatyana"
#addname "Strongpoint Ulyana"
#addname "Strongpoint Fyodor"
#addname "Strongpoint Khariton"
#addname "Strongpoint Tsaplya"
#addname "Strongpoint Chelovek"
#addname "Strongpoint Shura"
#addname "Strongpoint Shchuka"
#addname "Strongpoint Tvyordiy"
#addname "Strongpoint Ery"
#addname "Strongpoint Myagkiy"
#addname "Strongpoint Echo"
#addname "Strongpoint Yury"
#addname "Strongpoint Yakov"
#addname "Hill 48"
#addname "Hill 74"
#addname "Hill 100"
#addname "Hill 101"
#addname "Hill 102"
#addname "Hill 104"
#addname "Hill 105"
#addname "Hill 117"
#addname "Hill 175"
#addname "Hill 176"
#addname "Hill 184"
#addname "Hill 212"
#addname "Hill 225"
#addname "Hill 252"
#addname "Hill 274"
#addname "Hill 281"
#addname "Strongpoint Gurda"
#addname "Strongpoint Elsa"
#end

-- Random names for Transcendent Glyphs

#selectnametype 252
#addname "Socialism"
#addname "Revolutionary Socialism"
#addname "The Revolution"
#addname "The Party"
#addname "Communism"
#addname "Dialectical Materialism"
#addname "Secular Humanism"
#addname "Anarcho-Syndicalism"
#addname "Peace, Land and Bread"
#addname "Bolshevism"
#addname "Internationalism"
#addname "Proletarianism"
#addname "Equality"
#addname "Class Consciousness"
#addname "Utopia"
#addname "Cultural Marxism"
#addname "The People"
#end

-- Random names for rocket bases

#selectnametype 253
#addname "Battery Anton"
#addname "Battery Berta"
#addname "Battery Charlotte"
#addname "Battery Schule"
#addname "Battery Dora"
#addname "Battery Emil"
#addname "Battery Friedrich"
#addname "Battery Gustav"
#addname "Battery Heinrich"
#addname "Battery Ida"
#addname "Battery Julius"
#addname "Battery Kaufmann"
#addname "Battery Konrad"
#addname "Battery Ludwig"
#addname "Battery Martha"
#addname "Battery Nordpol"
#addname "Battery Otto"
#addname "Battery Paula"
#addname "Battery Quelle"
#addname "Battery Richard"
#addname "Battery Siegfried"
#addname "Battery Theodor"
#addname "Battery Ulrich"
#addname "Battery Viktor"
#addname "Battery Wilhelm"
#addname "Battery Xanthippe"
#addname "Battery Xaver"
#addname "Battery Ypsilon"
#addname "Battery Zacharias"
#end

-- Random names for aeroplanes

#selectnametype 254
#addname "Condor"
#addname "Falcon"
#addname "Eagle"
#addname "Hawk"
#addname "Harrier"
#addname "Skua"
#addname "Fulmar"
#addname "Griffon"
#addname "Vulture"
#addname "Osprey"
#addname "Buzzard"
#addname "Kite"
#end

-- American names (mostly presidents)

#selectnametype 255
#addname "George"
#addname "John"
#addname "Thomas"
#addname "James"
#addname "Quincy"
#addname "Andrew"
#addname "Martin"
#addname "William"
#addname "Henry"
#addname "Zachary"
#addname "Millard"
#addname "Franklin"
#addname "Abraham"
#addname "Ulysses"
#addname "Grover"
#addname "Benjamin"
#addname "Chester"
#addname "Abram"
#addname "Alan"
#addname "Theodore"
#addname "Woodrow"
#addname "Warren"
#addname "Gamaliel"
#addname "Calvin"
#addname "Herbert"
#addname "Harry"
#addname "Shipp"
#addname "Dwight"
#addname "Fitzgerald"
#addname "Lyndon"
#addname "Baines"
#addname "Richard"
#addname "Gerald"
#addname "Ronald"
#addname "Bill"
#addname "Walker"
#addname "Adam"
#addname "Harris"
#addname "Tyler"
#addname "Jeff"
#addname "Scott"
#addname "Tony"
#addname "Morgan"
#addname "Louis"
#end

-- Random names for Agents

#selectnametype 256
#addname "Denton"
#addname "Simons"
#addname "Page"
#addname "Carter"
#addname "Manderley"
#addname "Jacobson"
#addname "Jensen"
#addname "Reed"
#addname "Pritchard"
#addname "Darrow"
#addname "Renton"
#addname "Hilton"
#addname "Harrison"
#addname "Greene"
#addname "Collins"
#addname "Brown"
#addname "Schick"
#addname "Savage"
#end

-- Nautical names

#selectnametype 257
#addname "Hornblower" -- forester
#addname "Ahab" -- moby dick
#addname "Davos" -- game of thrones
#addname "Horatio" -- nelson
#addname "Pellew" -- napoleonic admirals
#addname "Jervis" -- napoleonic admiral
#addname "Vandegrift" -- marine corps general
#addname "Morgan" -- rum
#addname "Jellicoe" -- ww1 admiral
#addname "Beatty" -- ww1 admiral
#addname "Arleigh" -- burke, ww2 admiral
#addname "Chester" -- nimitz, ww2 admiral
#addname "Halsey" -- ww2 admiral
#end

-- Communist dictators

#selectnametype 258
#addname "Kadar" -- e ad to go
#addname "Zhivkov" -- e ad to go
#addname "Husak" -- e ad to go
#addname "Honecker" -- e ad to go
#addname "Ceausescu" -- e ad to go
#addname "Lenin" -- just like apartheid
#addname "Gorbachev" -- soon gone
#end

-- Female American names

#selectnametype 259
#addname "Mary"
#addname "Patricia"
#addname "Barbara"
#addname "Elizabeth"
#addname "Jennifer"
#addname "Maria"
#addname "Susan"
#addname "Margaret"
#addname "Dorothy"
#addname "Lisa"
#addname "Nancy"
#addname "Betty"
#addname "Karen"
#addname "Helen"
#addname "Sandra"
#addname "Donna"
#end


-- Star Wars sounding names

#selectnametype 260
#addname "Kadar"
#addname "Zhivkov"
#addname "Vaxo"
#addname "Ewatia"
#addname "Uvoxkia"
#addname "Uvuvzun"
#addname "Chennu"
#addname "Rearae"
#addname "Rheadia"
#addname "Jehosh"
#addname "Husak"
#addname "Sroso"
#addname "Tagsiu"
#addname "Aqinus"
#addname "Demzea"
#addname "Jarpua"
#addname "Yilaz"
#addname "Motsin"
#addname "Molum"
#addname "Wumo"
#addname "Yusa"
#addname "Nulus"
#addname "Hatszar"
#addname "Rintsu"
#addname "Tsalan"
#addname "Totua"
#addname "Axasuom"
#addname "Ezhideatiuth"
#addname "Zrito"
#addname "Tashoim"
#addname "Chaimuts"
#addname "Azeva"
#addname "Khamqain"
#addname "Simorick"
#addname "Corgar"
#addname "Curvdan"
#addname "Garlhawk"
#addname "Horcan"
#addname "Talvic"
#addname "Cordes"
#addname "Corsam"
#addname "Sethkel"
#addname "Finmas"
#addname "Sanem"
#addname "Lecol"
#addname "Ocam"
#addname "Kantoo"
#addname "Baird"
#addname "Haaran"
#addname "Balmor"
#addname "Depa"
#addname "Billaba"
#addname "Bolla"
#addname "Ropal"
#addname "Chuang"
#addname "Ima-Gun"
#addname "Di"
#addname "Drallig"
#addname "Drei"
#addname "Gallia"
#addname "Adi"
#addname "Uvell"
#addname "Jocasta"
#addname "Even"
#addname "Piell"
#addname "Phin-Law"
#addname "Tera"
#addname "Plape"
#addname "Tane"
#addname "Blomby"
#end

-- Sith Lord names

#selectnametype 261
#addname "Darth Maul"
#addname "Darth Krayt"
#addname "Darth Ajunta"
#addname "Darth Kressh"
#addname "Darth Ragnos"
#addname "Darth Sadow"
#addname "Darth Hord"
#addname "Darth Bane"
#addname "Darth Xaan"
#addname "Darth Ruin"
#addname "Darth Baras"
#addname "Darth Malgus"
#addname "Darth Malak"
#addname "Darth Caedus"
#addname "Darth Talon"
#addname "Darth Tane"
#addname "Darth Icky"
#addname "Darth Insanius"
#end

-- Sith Emperor names

#selectnametype 262
#addname "Emperor Palpatine"
#addname "Emperor Exar Kun"
#addname "Emperor Revan"
#addname "Emperor Vitiate"
#end

-- Junior Officer names

#selectnametype 263
#addname "Lt. Kadar"
#addname "Lt. Zhivkov"
#addname "Cpt. Vaxo"
#addname "Cpt. Ewatia"
#addname "Cpt. Uvoxkia"
#addname "Lt. Uvuvzun"
#addname "Lt. Chennu"
#addname "Lt. Rearae"
#addname "Lt. Rheadia"
#addname "Lt. Jehosh"
#addname "Maj. Husak"
#addname "Maj. Sroso"
#addname "Lt. Tagsiu"
#addname "Lt. Aqinus"
#addname "Lt. Demzea"
#addname "Cpt. Jarpua"
#addname "Cpt. Yilaz"
#addname "Cpt. Motsin"
#addname "Lt. Molum"
#addname "Lt. Wumo"
#addname "Maj. Yusa"
#addname "Maj. Nulus"
#addname "Lt. Hatszar"
#addname "Lt. Rintsu"
#addname "Cpt. Tsalan"
#addname "Cpt. Totua"
#addname "Lt. Axasuom"
#addname "Lt. Zrito"
#addname "Maj. Tashoim"
#addname "Cpt. Chaimuts"
#addname "Lt. Azeva"
#addname "Maj. Khamqain"
#addname "Lt. Simorick"
#addname "Lt. Corgar"
#addname "Lt. Curvdan"
#addname "Lt. Garlhawk"
#addname "Lt. Horcan"
#addname "Lt. Talvic"
#addname "Lt. Cordes"
#addname "Lt. Corsam"
#addname "Lt. Sethkel"
#addname "Lt. Finmas"
#addname "Lt. Sanem"
#addname "Lt. Lecol"
#addname "Lt. Ocam"
#addname "Cpt. Simorick"
#addname "Cpt. Corgar"
#addname "Cpt. Curvdan"
#addname "Cpt. Garlhawk"
#addname "Cpt. Horcan"
#addname "Cpt. Talvic"
#addname "Cpt. Cordes"
#addname "Cpt. Corsam"
#addname "Maj. Sethkel"
#addname "Maj. Finmas"
#addname "Maj. Sanem"
#addname "Maj. Lecol"
#addname "Maj. Ocam"
#end

-- Senior Officer names

#selectnametype 264
#addname "General Kadar"
#addname "General Zhivkov"
#addname "Moff Vaxo"
#addname "Moff Ewatia"
#addname "Moff Uvoxkia"
#addname "General Uvuvzun"
#addname "General Chennu"
#addname "General Rearae"
#addname "General Rheadia"
#addname "General Jehosh"
#addname "Admiral Husak"
#addname "Admiral Sroso"
#addname "General Tagsiu"
#addname "General Aqinus"
#addname "General Demzea"
#addname "Moff Jarpua"
#addname "Moff Yilaz"
#addname "Moff Motsin"
#addname "General Molum"
#addname "General Wumo"
#addname "Admiral Yusa"
#addname "Admiral Nulus"
#addname "General Hatszar"
#addname "General Rintsu"
#addname "Moff Tsalan"
#addname "Moff Totua"
#addname "General Axasuom"
#addname "General Zrito"
#addname "Admiral Tashoim"
#addname "Moff Chaimuts"
#addname "General Azeva"
#addname "Admiral Khamqain"
#end

-- Grand Moff names

#selectnametype 265
#addname "Grand Moff Tarkin"
#addname "Grand Moff Karath"
#addname "Grand Moff Edge"
#addname "Grand Moff Ordo"
#addname "Grand Moff Kang"
#end

-- Jedi Master names

#selectnametype 266
#addname "Master Kantoo"
#addname "Master Baird"
#addname "Master Haaran"
#addname "Master Balmor"
#addname "Master Depa"
#addname "Master Billaba"
#addname "Master Bolla"
#addname "Master Ropal"
#addname "Master Chuang"
#addname "Master Ima-Gun"
#addname "Master Di"
#addname "Master Drallig"
#addname "Master Drei"
#addname "Master Gallia"
#addname "Master Adi"
#addname "Master Uvell"
#addname "Master Jocasta"
#addname "Master Even"
#addname "Master Piell"
#addname "Master Phin-Law"
#addname "Master Tera"
#addname "Master Lamar"
#addname "Master Tokare"
#addname "Master Vandar"
#addname "Master Vrook"
#addname "Master Zez-Kai"
#addname "Master Kavar"
#addname "Master Lonna"
#addname "Master Vash"
#addname "Master Kace"
#end

-- Wookie names

#selectnametype 267
#addname "Wruhr"
#addname "Urrord"
#addname "Krroh"
#addname "Aympuaa"
#addname "Wriccerca"
#addname "Grrwayek"
#addname "Utber"
#addname "Krsaarkysch"
#addname "Bliwl"
#addname "Baakihr"
#addname "Greokku"
#addname "Shoadrl"
#addname "Whekk"
#addname "Tvroadrrl"
#addname "Tvrenk"
#addname "Krihn"
#addname "Blir"
#addname "Fouh"
#addname "Jashk"
#end

-- British sounding names

#selectnametype 268
#addname "George"
#addname "Henry"
#addname "Robert"
#addname "John"
#addname "Charles"
#addname "Arthur"
#addname "William"
#addname "Frederick"
#addname "Hugh"
#addname "Herbert"
#addname "Percy"
#addname "Alexander"
#addname "Kenneth"
#addname "Donald"
#addname "Richard"
#addname "Michael"
#addname "James"
#addname "Arnold"
#addname "Hanson"
#addname "Harry"
#addname "Edward"
#addname "Benjamin"
#addname "Archibald"
#addname "Stanley"
#addname "Ramsay"
#addname "Neville"
#addname "Winston"
#addname "Eric"
#end

-- British nobility

#selectnametype 269
#addname "Baron Rossmore"
#addname "Earl Carhampton"
#addname "Viscount Lake"
#addname "Viscount Wolseley"
#addname "Baron Grenfell"
#addname "Earl Rothes"
#addname "Viscount Cathcart"
#addname "Earl Hopetoun"
#addname "Viscount Combermere"
#addname "Marquess Conyngham"
#addname "Baron Brudenell"
#addname "Earl Harrington"
#addname "Duke Montagu"
#addname "Baron Wharton"
#addname "Earl Abingdon"
#addname "Earl Huntingdon"
#addname "Viscount Sydney"
#addname "Earl Rutland"
#addname "Baron Lovelace"
#addname "Baron Hunsdon"
#addname "Duke Beaufort"
#addname "Marquess Hartington"
#addname "Earl Burlington"
#addname "Viscount Edgcumbe"
#addname "Marquess Townshend"
#addname "Baron Bletso"
#addname "Baron Foley"
#addname "Baron Forester"
#addname "Viscount Hinchingbrooke"
#addname "Viscount Normanby"
#end

-- British women names

#selectnametype 270
#addname "Catherine"
#addname "Harriet"
#addname "Charlotte"
#addname "Mary"
#addname "Elizabeth"
#addname "Hester"
#addname "Henrietta"
#addname "Anne"
#addname "Lucy"
#addname "Sophia"
#addname "Dorothy"
#addname "Margaret"
#addname "Ursula"
#addname "Jane"
#addname "Sarah"
#end

-- British junior officers

#selectnametype 271
#addname "Colonel Wood"
#addname "Colonel Turner"
#addname "Colonel Bolton"
#addname "Colonel Smith"
#addname "Colonel Cooke"
#addname "Colonel Adams"
#addname "Major Wood"
#addname "Major Turner"
#addname "Major Carmichael"
#addname "Major Smith"
#addname "Major Cooke"
#addname "Major Adams"
#addname "Major Bolton"
#addname "Major Sandham"
#addname "Captain Wood"
#addname "Captain Turner"
#addname "Captain Carmichael"
#addname "Captain Smith"
#addname "Captain Cooke"
#addname "Captain Askew"
#addname "Captain Maitland"
#addname "Captain Sandham"
#addname "Captain Hepburn"
#addname "Captain Grant"
#addname "Captain Bolton"
#addname "Captain Macdonnell"
#addname "Captain Halkett"
#addname "Captain Morice"
#addname "Captain Hill"
#addname "Captain Williamson"
#addname "Captain Clinton"
#addname "Captain Adams"
#end

-- Eternal Empress names

#selectnametype 272
#addname "Queen Victoria"
#end

-- Cowboy names

#selectnametype 273
#addname "Clint"
#addname "Gringo"
#addname "Manco"
#addname "Ramón"
#addname "Piripero"
#addname "Silvanito"
#addname "John"
#addname "Don Miguel"
#addname "Esteban"
#addname "Antonio"
#addname "Rubio"
#addname "Lorenzo"
#addname "Antoñito"
#addname "Fernando"
#end

-------- SITES -----------

#newsite
#name "House of Evangelists"
#path 8
#level 0
#rarity 5
#homecom "Supreme Court Judge"
#end

#newsite
#name "Agency Headquarters"
#path 3
#level 1
#rarity 5
#scry 1
#homecom "Special Agent"
#homemon "National Guardsman"
#end

#newsite
#name "Academic Society"
#path 4
#level 2
#rarity 5
#res 50
#gems 0 1
#gems 1 1
#gems 3 1
#homecom "Academician"
#homecom 6654
#end

#newsite
#name "Marine School"
#path 2
#level 2
#rarity 5
#xp 4
#gems 2 1
#homemon 6898 -- supply truck
#homecom 6905 -- Marine Officer
#homemon "Marine Rifleman"
#homemon 6904 -- Revolutionary Standard
#end

#newsite
#name "Factories of Ulmreich"
#path 0
#level 2
#rarity 5
#res 50
#gems 0 1
#gems 1 1
#gems 3 1
#homemon 6575 -- supply truck
#homecom 6579 -- artillery
#homecom "Capitalist"
#end

#newsite
#name "Airyan Sect"
#path 1
#level 2
#rarity 5
#scry 1
#gems 1 1
#homemon "Airyan Guardsman"
#homemon "Airyan Standard"
#homecom "Brownshirt Leader"
#homecom "Airyan Mage-Priest"
#homecom "Secret Police Chief"
#end

#newsite
#name "Ulmreich Officer School"
#path 8
#level 0
#rarity 5
#xp 4
#homecom "Infantry General"
#homecom 6668 -- deaths head officer
#homemon 6667 -- deaths head hussar
#end

#newsite
#name "National Bureau"
#path 0
#level 2
#rarity 5
#res 50
#gems 0 1
#gems 1 1
#gems 3 1
#homemon 6899 -- supply truck
#homecom "Bureau Foreman"
#homecom 6595
#end

#newsite
#name "Sovirus Military Academy"
#path 8
#level 0
#rarity 5
#xp 4
#homemon "Assault Engineer"
#homemon "Assault Banner"
#homecom "Guards Commander"
#homemon 6551 -- Guards Rifleman
#homemon "Guards Banner"
#end

#newsite
#name "Cheka Headquarters"
#path 7
#level 0
#rarity 5
#scry 1
#gems 5 1
#homecom "Chekist Executioner"
#end

#newsite
#name "Enclave Academy"
#path 8
#level 0
#rarity 5
#xp 4
#homemon 6810 -- stormtrooper
#homemon 6823 -- stormtrooper
#homemon 6824 -- stormtrooper sergeant
#homecom 6811 -- stormtrooper officer
#end

#newsite
#name "Sith Temple"
#path 7
#level 2
#rarity 5
#adventureruin 10
#gems 0 1
#homemon 6801 -- sith blade
#homemon 6804 -- sith warrior
#homemon 6815 -- sith marauder
#homecom 6808 -- sith assassin
#homecom 6802 -- sith master, priest
#homecom 6813 -- sith lord, mage
#end

#newsite
#name "Jedi Temple"
#path 8
#level 0
#rarity 5
#xp 4
#homemon 6834 -- jedi knight
#homecom 6850 -- jedi master
#homecom 6849 -- jedi councillor
#end

#newsite
#name "Wroshyr Grove"
#path 6
#level 2
#rarity 5
#adventureruin 10
#gems 6 1
#homemon 6838 -- wookie militia
#homemon 6839 -- wookie warrior
#homemon 6840 -- wookie madclaw
#homecom 6841 -- wookie chieftain
#end

#newsite
#name "Crystal Caves"
#path 4
#level 2
#rarity 5
#scry 1
#gems 1 1
#gems 4 2
#end

#newsite
#name "Crystal Palace"
#path 1
#level 2
#rarity 5
#scry 1
#gems 1 1
#gems 2 1
#end

#newsite
#name "Knightsbridge"
#path 8
#level 0
#rarity 5
#xp 4
#homemon 6869 -- household guard
#homemon 6897 -- household cornet
#homecom 6870 -- household captain
#end

#newsite
#name "Iron Foundry"
#path 0
#level 0
#rarity 5
#res 50
#gems 0 1
#gems 3 1
#homecom 6883 -- great engineer
#end


-------- NATIONS ---------

------- NATION: SOVIRUS

#selectnation 450
#clearnation
#name "Sovirus"
#epithet "For the Motherland"
#era 3
#idealcold 1
#brief "Sovirus is a nation formed after a civil war in Bogarus that deposed the princes. The brutal Chekists conscript troops into the army with weapons produced by engineers and magi in factories."
#descr "When the humans of Bogarus threw off their Vanir masters, human princes took the place of the Vanjarl lords. The common folk of Rus chafed under the taxes, levies and abuses of the princes until the unrest of the people became so great a civil war broke out. Forest bandits, peasant Voi and city dwelling Peshtsi joined in rising up to create a new system. In the brutal land of Rus, the most brutal men lead. The Chekists organise the conscription of soldiers and set the best and brightest minds to the task of destroying the enemies of the Awakening God."
#summary "Race: Cold resistant humans. Prefers Cold scale +1.
Military: Powerful ranged infantry, weak melee infantry, summonable specialist troops.
Magic: Strong Fire, Air and Earth. Weak Water, Nature, Death and Blood.
Priests: Weak. Can reanimate the undead."
#flag "./Firepower/sovirus/flag_128.tga"

#likesterr 0
#hatesterr 4208

#priestreanim

---- GODS

#homerealm 10
#addgod 6589 -- Transcendent Glyph (divine glyph)
#cheapgod20 6589
#addgod 6588 -- Divine Leader (divine emperor)
#cheapgod20 6588
#addgod 215 -- Virtue

---- RECRUITS

#addforeignunit "Conscript Spearman"
#addrecunit "Conscript Spearman"
#addforeignunit "Conscript Rifleman"
#addrecunit "Conscript Rifleman"
#addrecunit "Rifle Infantryman"
#addrecunit "Regimental Banner"
#addrecunit "Marksman"
#addrecunit 6597
#addrecunit 6665 -- cossack soldier

---- LEADERS

#addreccom "Infantry Commander"
#addreccom "Sniper"
#addreccom "Chekist Investigator"
#addreccom "Bureau Engineer"
#addreccom "Surgeon"
#forestcom "Forest Anarch"
#addreccom 6666 -- cossack officer

#addreccom "Command Bunker"
#addforeigncom "Command Bunker"

----- HEROES

#hero1 6594
#hero2 6591
#hero3 6585
#hero4 6583
#hero5 6582

----- STARTSITES

#clearsites
#startsite "Sovirus Military Academy"
#startsite "Cheka Headquarters"
#startsite "National Bureau"

#templepic 4

----- FORTS
#fortera 3

----- WALL DEFENCE

#wallcom "Infantry Commander"
#wallunit "Conscript Rifleman"
#wallmult 12
#guardcom "Infantry Commander"
#guardunit "Conscript Spearman"
#guardmult 12

---- COLOR

#color 1.0 0.2 0.1
#secondarycolor 1.0 1.0 0

------- PROVINCE DEFENCE

--Sets the units to be used in province defense.
#defcom1 "Infantry Commander"
#defcom2 "Command Bunker"
#defunit1 "Conscript Spearman"
#defunit1b "Conscript Rifleman"
#defunit2 "Rifle Infantryman"
#defunit2b "Marksman"

--Sets how many of the units to appear per 10 points.
#defmult1 10
#defmult1b 10
#defmult2 8
#defmult2b 5

------- STARTING UNITS

#startcom "Infantry Commander"
#startscout "Sniper"
#startunittype1 "Conscript Spearman"
#startunitnbrs1 15
#startunittype2 "Rifle Infantryman"
#startunitnbrs2 10

#end

------- NATION: ULMREICH

#selectnation 451
#clearnation
#name "Ulmreich"
#epithet "Blood and Earth"
#era 3
#brief "Ulmreich are militaristic survivors of the Malediction. They believe their nation only fell due to the intrigues of internal enemies and devote much time and expense to proving the purity, and therefore loyalty, of their blood. Their mages have unlocked the secrets of their ancient Airyan heritage."
#descr "The Airyan Sect began as a movement in Ulm devoted to proving the lineage of the Ulmish people from Caelum's most sacred tribe, those who cut off their wings and returned to the earth. When the Malediction swept through Ulm and left the nation broken, the Sect wrested away command of many of the soldiers fighting the holy war against the undead Ermorian legions. Undefeated in battle, the people of Ulmreich knew the fall to be the fault of the intrigues of foreign spies and traitors. Now they seek revenge, and the Airyan Sect say they have the power of Blood, Earth and Air to take it."
#summary "Race: Stocky humans vulnerable to magic.
Military: Powerful ranged infantry, weak melee infantry, summonable specialist troops.
Magic: Strong Fire, Air, Earth and Blood. Weak Water and Nature.
Priests: Average. Can sacrifice blood slaves to extend dominion."
#flag "./Firepower/ulmreich/flag_128.tga"

#bloodnation
#sacrificedom
#likesterr 0
#hatesterr 4208

---- GODS

#homerealm 10
#addgod 1561 -- Father of Winters
#addgod 501 -- Allfather
#addgod 1379 -- Keeper of the Bridge
#addgod 1229 -- Son of Fenrer
#addgod 215 -- Virtue
#addgod 6663 -- Colossal Hitler
#cheapgod20 6663

---- RECRUITS

#addforeignunit "Labour Serviceman"
#addrecunit "Labour Serviceman"
#addforeignunit "Reserve Rifleman"
#addrecunit "Reserve Rifleman"
#addrecunit "Grenadier"
#addrecunit 6553 -- Regimental Standard
#addrecunit "Pionier"
#addrecunit 6572 -- Autogun Team
#addrecunit "Brownshirt Militiaman"
#caverec "Vampir Guardsman"

---- LEADERS

#addreccom "Inventor"
#addreccom "Nurse"
#addreccom "Infantry Captain"
#addforeigncom "Infantry Captain"

#addreccom "Infantry Colonel"
#cavecom "Vampir Officer"
#addreccom "Secret Policeman"
#addreccom "Brownshirt Officer"

----- HEROES

#hero1 6647
#hero2 6648
#hero3 6649

----- STARTSITES

#startsite "Ulmreich Officer School"
#startsite "Airyan Sect"
#startsite "Factories of Ulmreich"

#templepic 23

----- FORTS
#fortera 3

----- WALL DEFENCE

#wallcom "Infantry Captain"
#wallunit "Reserve Rifleman"
#wallmult 12
#guardcom "Infantry Captain"
#guardunit "Labour Serviceman"
#guardmult 12

---- COLOR

#color 0.1 0.1 0.1
#secondarycolor 0.6 0.6 0.6

------- PROVINCE DEFENCE

--Sets the units to be used in province defense.
#defcom1 "Infantry Colonel"
#defcom2 "Brownshirt Officer"
#defunit1 "Labour Serviceman"
#defunit1b "Reserve Rifleman"
#defunit2 "Grenadier"
#defunit2b "Brownshirt Militiaman"

--Sets how many of the units to appear per 10 points.
#defmult1 10
#defmult1b 10
#defmult2 5
#defmult2b 8

------- STARTING UNITS

#startcom "Infantry Colonel"
#startscout "Secret Policeman"
#startunittype1 "Labour Serviceman"
#startunitnbrs1 15
#startunittype2 "Grenadier"
#startunitnbrs2 10

#end

------- NATION: MANICA

#selectnation 452
#clearnation
#name "Manica"
#epithet "Order from Chaos"
#era 3
#brief "Civil war raged in Man between the Kingdom and colonial republicans. The new republic of Manica is a bastion of righteousness which has merged political and religious power."
#descr "The moral degeneration of the King of Man caused great dissent in the overseas colonies. Resenting the influence of the pagan Witches in the King's court, they declared an independent republic to ensure religion was never separated from the state again. The House of Evangelists are the charismatic leaders, elected by the landed citizens to protect the minds and souls of the people. Their eyes and ears are the Agents, who can assassinate problematic individuals. The Agency keeps a close watch over the activities of the scientists and academicians, lest their sceptical minds fall prey to heresy. The scientists produce state of the art weapons for the military such as Manica's elite Marines, who are able to launch invasions across the seas."
#summary "Race: Humans.
Military: Powerful ranged infantry, weak melee infantry, summonable specialist troops.
Magic: Strong Fire, Air, Water, Earth and Astral. Weak Nature, Death and Blood.
Priests: Strong."
#flag "./Firepower/manica/flag_128.tga"

#coastnation
#likesterr 0
#hatesterr 6900

#templecost 200

---- GODS

#homerealm 10
#addgod 215 -- Virtue
#cheapgod20 215

---- RECRUITS

#addforeignunit "Manchaka Spearman"
#addrecunit "Manchaka Spearman"
#addforeignunit "Drafted Spearman"
#addrecunit "Drafted Spearman"
#addforeignunit "Drafted Rifleman"
#addrecunit "Drafted Rifleman"
#addrecunit "Infantry Rifleman"
#addrecunit 6552 -- Regimental Standard
#addrecunit 6650 -- Autogun Team
#coastunit1 6907 -- Deep Sea Diver

---- LEADERS

#addreccom 6550 -- Agent
#addreccom "Manchaka Officer"
#addreccom "Infantry Officer"
#addreccom "Scientist"
#addreccom "Doctor"
#addreccom "Evangelist-Elect"
#addforeigncom "Evangelist-Elect"
#addreccom "House Evangelist"
#coastcom1 6906 -- Deep Sea Officer

----- HEROES

#hero1 6562
#hero2 6561
#hero3 6560

----- STARTSITES

#clearsites
#startsite "House of Evangelists"
#startsite "Marine School"
#startsite "Agency Headquarters"
#startsite "Academic Society"

#templepic 1

----- FORTS
#fortera 3

----- WALL DEFENCE

#wallcom "Infantry Officer"
#wallunit "Drafted Rifleman"
#wallmult 12
#guardcom "Infantry Officer"
#guardunit "Drafted Spearman"
#guardmult 12

---- COLOR

#color 0.3 0.3 0.8
#secondarycolor 0.8 0.4 0.4

------- PROVINCE DEFENCE

--Sets the units to be used in province defense.
#defcom1 "Infantry Officer"
#defcom2 "House Evangelist"
#defunit1 "Drafted Spearman"
#defunit1b "Drafted Rifleman"
#defunit2 "Infantry Rifleman"
#defunit2b "National Guardsman"

--Sets how many of the units to appear per 10 points.
#defmult1 10
#defmult1b 10
#defmult2 8
#defmult2b 5

------- STARTING UNITS

#startcom "Infantry Officer"
#startscout 6550 -- Agent
#startunittype1 "Drafted Spearman"
#startunitnbrs1 15
#startunittype2 "Infantry Rifleman"
#startunitnbrs2 10

#end

------- NATION: IMPERIAL ENCLAVE

#selectnation 453
#clearnation
#name "Imperial Enclave"
#epithet "Victory through Strength"
#era 3
#brief "The Imperial Enclave is an expedition from far away, with soldiers wielding powerful ranged weapons and led by psychic warriors called Sith."
#descr "While the Pantokrator had ultimate authority on this world, there are other worlds than this. The disappearance of the Pantokrator has allowed a powerful Empire from another plane to send an expedition, an Imperial Enclave, to conquer this world in the name of its own god. Ordinary humans by any other measure, they understand and navigate the Astral Plane unlike anything seen on this world. Their soldiers are a mixture of local conscripts and veterans of a thousand conquests. Their leaders are psychic priests, hardened fighters and powerful mages wielding dazzling swords of light. Their Awakening God has tasted victory elsewhere and demands that this world bow to the Empire."
#summary "Race: Humans. Force-using Sith have innate protection from mundane weapons, poisons and the elements.
Military: Powerful ranged infantry, tough Stormtroopers, sacred Sith warriors.
Magic: Strong Air, Astral and Death. Weak Fire, Water and Earth.
Priests: Strong. Can reanimate the undead."
#flag "./Firepower/Enclave/flag_128.tga"

#priestreanim

---- GODS

#homerealm 10
#addgod 120 -- Moloch
#addgod 472 -- Statue of Order
#addgod 874 -- Divine Emperor
#cheapgod20 874
#addgod 905 -- Jade Emperor
#cheapgod20 905
#addgod 1025 -- Divine Glyph
#addgod 2447 -- Idol of Men
#addgod 2448 -- Idol of Beasts
#addgod 2449 -- Idol of Sorcery
#addgod 2463 -- Statue of War
#addgod 6816 -- Dark Lord of the Sith
#cheapgod20 6816

---- RECRUITS

#addforeignunit 6812 -- imperial conscript
#addrecunit 6812 -- imperial conscript
#addrecunit 6807 -- imperial infantryman
#addrecunit 6825 -- infantry sergeant
#addrecunit 6821 -- mercenary thug, disruptor
#addforeignunit 6821 -- mercenary thug, disruptor
#addrecunit 6829 -- mercenary thug, sonic
#addforeignunit 6829 -- mercenary thug, sonic
#addrecunit 6800 -- sith acolyte
#addrecunit 6803 -- sith adept
#addrecunit 6814 -- sith initiate

---- LEADERS

#addreccom 6806 -- imperial officer
#addreccom 6820 -- imperial governor
#addforeigncom 6809 -- mercenary captain
#addreccom 6809 -- mercenary captain
#addreccom 6822 -- bounty hunter
#addreccom 6805 -- sith archeologist
#addforeigncom 6805 -- sith archeologist
#addreccom 6826 -- sith inquisitor
#addreccom 6817 -- sith sorcerer

----- HEROES

#multihero1 6818 -- sith overlord
#multihero2 6828 -- imperial overseer
#hero1 6819 -- darth vader

----- STARTSITES

#clearsites
#startsite "Enclave Academy"
#startsite "Sith Temple"
#startsite "Crystal Caves"

#templepic 17

----- FORTS
#fortera 3

----- WALL DEFENCE

#wallcom 6806 -- imperial officer
#wallunit 6812 -- imperial conscript
#wallmult 10
#guardcom 6806 -- imperial officer
#guardunit 6812 -- imperial conscript
#guardmult 10

---- COLOR

#color 0.75 0.17 0.17
#secondarycolor 0.1 0.1 0.1

------- PROVINCE DEFENCE

#defcom1 6806 -- imperial officer
#defcom2 6826 -- sith inquisitor
#defunit1 6812 -- imperial conscript
#defunit1b 6807 -- imperial infantryman
#defunit2 6810 -- stormtrooper
#defunit2b 6803 -- sith adept
#defmult1 10
#defmult1b 8
#defmult2 5
#defmult2b 5

------- STARTING UNITS

#startcom 6806 -- imperial officer
#startscout 6822 -- bounty hunter
#startunittype1 6812 -- imperial conscript
#startunitnbrs1 15
#startunittype2 6807 -- imperial infantryman
#startunitnbrs2 10

#end

------- NATION: NEW REPUBLIC

#selectnation 454
#clearnation
#name "New Republic"
#epithet "Guardians of Peace"
#era 3
#brief "The New Republic are revolutionaries led by Jedi, a monastic order of psychic warriors."
#descr "The Sith mostly succeeded in stamping out dissent against their Empire, but there are still pockets of rebels and revolutionaries who seek to overthrow the Emperor. This rebel alliance is led by a monastic order of psychic warriors called Jedi, who claim to have battled the Sith for thousands of years in a doctrinal conflict. The disappearance of the Pantokrator has left this world open to attack by the Empire, and the New Republic has arrived to save the denizens from slavery, or so they say."
#summary "Race: Humans and demi-humans. Force-using Jedi have innate protection from mundane weapons, poisons and the elements.
Military: Powerful ranged infantry, bestial Wookies, sacred Jedi warriors.
Magic: Strong Air, Astral and Nature. Weak Fire, Water and Earth.
Priests: Strong."
#flag "./Firepower/Republic/flag_128.tga"

---- GODS

#homerealm 10
#addgod 215 -- Virtue
#cheapgod20 215
#addgod 472 -- Statue of Order
#addgod 657 -- Monolith
#addgod 1025 -- Divine Glyph
#addgod 1343 -- Titan of Love
#addgod 1345 -- Celestial General
#addgod 2234 -- Irminsul
#addgod 2435 -- Annunaki of Love and War
#addgod 2447 -- Idol of Men
#addgod 2448 -- Idol of Beasts
#addgod 2449 -- Idol of Sorcery
#addgod 2463 -- Statue of War

---- RECRUITS

#addrecunit 6842 -- republic soldier
#addrecunit 6843 -- republic commando
#addrecunit 6844 -- republic sergeant
#addrecunit 6853 -- mercenary thug, disruptor
#addforeignunit 6853 -- mercenary thug, disruptor
#addrecunit 6854 -- mercenary thug, sonic
#addforeignunit 6854 -- mercenary thug, sonic
#addforeignunit 6830 -- force adept
#addforeignunit 6831 -- grey jedi
#addrecunit 6832 -- jedi apprentice
#addrecunit 6833 -- jedi padawan

---- LEADERS

#addreccom 6845 -- republic officer
#addreccom 6846 -- republic sniper
#addreccom 6864 -- commando officer
#addforeigncom 6852 -- mercenary captain
#addreccom 6852 -- mercenary captain
#addforeigncom 6837 -- grey paladin
#addreccom 6847 -- jedi archivist
#addreccom 6848 -- jedi sentinel
#addreccom 6851 -- jedi guardian
#addreccom 6835 -- jedi consular
#addreccom 6836 -- jedi peacekeeper

----- HEROES

#hero1 6856 -- kyle katarn
#hero2 6855 -- general crix madine
#hero3 6857 -- kreia

----- STARTSITES

#clearsites
#startsite "Jedi Temple"
#startsite "Wroshyr Grove"
#startsite "Crystal Caves"

#templepic 9

----- FORTS
#fortera 3

----- WALL DEFENCE

#wallcom 6845 -- republic officer
#wallunit 6842 -- republic soldier
#wallmult 9
#guardcom 6845 -- republic officer
#guardunit 6842 -- republic soldier
#guardmult 9

---- COLOR

#color 0.9 0.9 0.9
#secondarycolor 0.9 0.9 0.5

------- PROVINCE DEFENCE

#defcom1 6845 -- republic officer
#defcom2 6836 -- jedi peacekeeper
#defunit1 6842 -- republic soldier
#defunit1b 6832 -- jedi apprentice
#defunit2 6843 -- republic commando
#defunit2b 6833 -- jedi padawan
#defmult1 8
#defmult1b 5
#defmult2 5
#defmult2b 5

------- STARTING UNITS

#startcom 6845 -- republic officer
#startscout 6846 -- republic sniper
#startunittype1 6842 -- republic soldier
#startunitnbrs1 10
#startunittype2 6839 -- wookie warrior
#startunitnbrs2 10

#end

------- NATION: ANGLIA

#selectnation 455
#clearnation
#name "Anglia"
#epithet "Dark Satanic Mills"
#era 3
#brief "Anglia is a modern nation, with machines and great feats of engineering serving as dazzling demonstrations of her understanding of the mundane and arcane sciences."
#descr "The old kingdom of Man has seen many changes. Her society now seeks to understand the phenomena of the world, where before her bards and spellsingers merely repeated their dogmas and legends. Despite feudalism dying to the onslaught of modernity, society remains stratified, with a large lower class working in the mines and factories for the profit of the landlords and propertied nobles. Anglia's armies have carved out an empire from the unlucky primitives she has discovered overseas, and her clergymen are eager to enlighten the natives to the truth of the Awakening God. Should they resist this enlightenment, the Engineers have produced weapons of terrible destruction to rain fire on enemies from afar."
#summary "Race: Humans.
Military: Powerful ranged infantry. Versatile cavalry.
Magic: Strong Fire, Air and Earth. Weak Water, Astral and Death.
Priests: Average."
#flag "./Firepower/Anglia/flag_128.tga"

#likesterr 0
#hatesterr 6900

---- GODS

#homerealm 10
#addgod 472 -- Statue of Order
#addgod 2447 -- Idol of Men
#addgod 2448 -- Idol of Beasts
#addgod 2449 -- Idol of Sorcery
#addgod 2463 -- Statue of War
#addgod 215 -- Virtue
#addgod 6892 -- Queen Victoria, Eternal Empress
#cheapgod40 6892
#addgod 874 -- Divine Emperor
#cheapgod20 874
#addgod 905 -- Jade Emperor
#cheapgod20 905

---- RECRUITS

#addforeignunit 6872 -- police constable
#addrecunit 6872 -- police constable
#addrecunit 6865 -- redcoat rifleman
#addrecunit 6889 -- regimental colours
#addrecunit 6874 -- maxim gun
#addrecunit 6909 -- green jacket
#addrecunit 6879 -- camel rider
#addrecunit 6877 -- dragoon
#addrecunit 6873 -- lancer
#addrecunit 6871 -- hussar
#addrecunit 6890 -- light cornet
#addrecunit 6867 -- cuirassier
#addrecunit 6891 -- heavy cornet
#addrecunit 6894 -- foot guardsman
#addrecunit 6895 -- guard colours

---- LEADERS

#addreccom 6886 -- detective
#addreccom 6866 -- redcoat officer
#addreccom 6910 -- green jacket captain
#addreccom 6880 -- camel captain
#addreccom 6868 -- cavalry captain
#addreccom 6878 -- general staff officer
#addreccom 6884 -- rector
#addforeigncom 6884 -- rector
#addreccom 6885 -- dean
#addreccom 6881 -- medium
#addreccom 6882 -- engineer
#addreccom 6887 -- light artillery

----- HEROES

#hero1 6893
#hero2 6896

----- STARTSITES

#clearsites
#startsite "Crystal Palace"
#startsite "Knightsbridge"
#startsite "Iron Foundry"

#templepic 9

----- FORTS

#fortera 3

----- WALL DEFENCE

#wallcom 6866 -- redcoat officer
#wallunit 6865 -- redcoat rifleman
#wallmult 10
#guardcom 6866 -- redcoat officer
#guardunit 6865 -- redcoat rifleman
#guardmult 10

---- COLOR

#color 0.8 0 0.4
#secondarycolor 0.9 0.8 0.3

------- PROVINCE DEFENCE

#defcom1 6866 -- redcoat officer
#defcom2 6868 -- cavalry captain
#defunit1 6872 -- police constable
#defunit1b 6865 -- redcoat rifleman
#defunit2 6877 -- dragoon
#defunit2b 6874 -- maxim gun
#defmult1 10
#defmult1b 6
#defmult2 5
#defmult2b 2

------- STARTING UNITS

#startcom 6866 -- redcoat officer
#startscout 6886 -- detective
#startunittype1 6865 -- redcoat rifleman
#startunitnbrs1 15
#startunittype2 6877 -- dragoon
#startunitnbrs2 10

#end

-------- SPELLS -----------

#newspell
#restricted 450
#name "Construct BT-36 Medium Tank"
#descr "The tank is a huge weapon of war armed with a cannon, autogun and the ability to crush the frightened enemy beneath its treads. While knowledge of Fire magic is essential for the many weapons it carries, the bulk of the work during construction consists of manipulating Earth gems to build the hulking chassis, armour and turret. The construct requires 8 pounds of gold for maintenance every month."
#school 3
#researchlevel 5
#path 0 3
#path 1 0
#pathlevel 0 3
#pathlevel 1 1
#effect 10021
#damage 6592
#nreff 1
#fatiguecost 3500
#end

#newspell
#restricted 450
#name "Construct Katyusha Launcher"
#descr "The field artillery is very slow to position, and vulnerable to melee strikes and counter-battery fire. We could build a device of Fire and Air magic which will pulverise the enemy from afar while having the mobility and speed of the mechanised units. Maintenance and supply of the device will cost us 6 pounds of gold every month."
#school 3
#researchlevel 5
#path 0 0
#path 1 1
#pathlevel 0 3
#pathlevel 1 1
#effect 10001
#damage 6908
#nreff 1
#fatiguecost 1800
#end

#newspell
#restricted 450
#name "Construct BZ-16 Armoured Car"
#descr "The armoured car fills the equivalent role of cavalry in the Sovirus armies, destroying vulnerable targets in the enemy's rear. It carries an autogun but it is more effective at driving over smaller enemies. Most of the magic goes into propelling the device with great rapidity, so the main magical components are Air gems. The construct requires 4 pounds of gold for maintenance every month."
#school 3
#researchlevel 3
#path 0 1
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10001
#damage 6581
#nreff 1
#fatiguecost 800
#end

#newspell
#restricted 450
#name "Peasant Banquet"
#descr "Starving peasants are given gifts of tainted human flesh by the necromancer, and compelled to eat if they refuse. The ghouls thus created are more loyal to Sovirus, and therefore better citizens. They are equipped for combat in heavy armour and given small autoguns to destroy the enemies of the Awakening God."
#school 1
#researchlevel 3
#path 0 5
#pathlevel 0 1
#effect 10001
#damage 6590
#nreff 5
#fatiguecost 1000
#end

#newspell
#restricted 450
#name "Anti-Magic Infantry"
#descr "The many dangers facing Sovirus infantry are not limited to physical weapons. Poisons and elemental magic have been identified as a major threat to the success of the armies of the Awakening God. Our Surgeons are able to produce equipment for ordinary infantrymen to mitigate some of these risks. Each Infantryman will draw wages of 2 pounds of gold each month."
#school 4
#researchlevel 3
#path 0 6
#path 1 3
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#damage 6587
#nreff 5
#fatiguecost 1200
#end

#newspell
#restricted 450
#name "Build Flamethrowers"
#descr "The armies of Sovirus tend to be vulnerable to melee charges. The need has arisen for a means of keeping the enemy at arm's length. The construction of a magical weapon that spews flames short distances to terrorise the enemy will meet this need. This will also add to the effectiveness of our forces against ethereal enemies. Each Flame Engineer will draw wages of 3 pounds of gold each month."
#school 3
#researchlevel 1
#path 0 0
#pathlevel 0 1
#effect 10001
#damage 6586
#nreff 2
#fatiguecost 500
#end

#newspell
#restricted 451
#name "Produce Flamethrowers"
#descr "The armies of Ulmreich tend to be vulnerable to melee charges. The need has arisen for a means of keeping the enemy at arm's length. The construction of a magical weapon that spews flames short distances to terrorise the enemy will meet this need. This will also add to the effectiveness of our forces against ethereal enemies. Each Assault Flamethrower will draw wages of 3 pounds of gold each month."
#school 3
#researchlevel 1
#path 0 0
#pathlevel 0 1
#effect 10001
#damage 6564
#nreff 2
#fatiguecost 400
#end

#newspell
#restricted 452
#name "Construct Flamethrowers"
#descr "The armies of Manica tend to be vulnerable to melee charges. The need has arisen for a means of keeping the enemy at arm's length. The construction of a magical weapon that spews flames short distances to terrorise the enemy will meet this need. This will also add to the effectiveness of our forces against ethereal enemies. Each Flame Trooper will draw wages of 3 pounds of gold each month."
#school 3
#researchlevel 1
#path 0 0
#pathlevel 0 1
#effect 10001
#damage 6563
#nreff 2
#fatiguecost 400
#end

#newspell
#restricted 451
#name "Construct Rocket Launch Site"
#descr "Rockets are magical constructs created from powerful Fire and Air ensorcellments. A rocket battery, manned by technicians, could fire a steady stream of fiery death at nearby enemy armies. Its power would be to the artillery what an autogun is to a rifle. It would be self-sustaining and need no further oversight from its creators but would cost 100 gold every month to maintain."
#school 3
#researchlevel 7
#path 0 0
#path 1 1
#pathlevel 0 5
#pathlevel 1 1
#effect 10021
#damage 6578
#nreff 1
#fatiguecost 8000
#end

#newspell
#restricted 451
#name "Construct Panzer Light Tank"
#descr "The tank is a huge weapon of war armed with a cannon, autogun and the ability to crush the frightened enemy beneath its treads. While knowledge of Fire magic is essential for the many weapons it carries, the bulk of the work during construction consists of manipulating Earth gems to build the hulking chassis, armour and turret. The construct requires 6 pounds of gold for maintenance every month"
#school 3
#researchlevel 3
#path 0 3
#path 1 0
#pathlevel 0 2
#pathlevel 1 1
#effect 10021
#damage 6576
#nreff 1
#fatiguecost 2500
#end

#newspell
#restricted 451
#name "Lightning Guard"
#descr "The Airyan Mage-Priests can create divinely powered devices capable of propelling soldiers through the air. Resistant to thunder and lightning, they could even fly during storms. This will give them an incredible advantage for manoeuvring, both tactically and strategically. There's no sensation to compare with this. Suspended animation, a state of bliss. Each Lightning Guardsman will draw wages of 18 pounds of gold each year."
#school 4
#researchlevel 3
#path 0 1
#pathlevel 0 2
#effect 10001
#damage 6569
#nreff 3
#fatiguecost 800
#end

#newspell
#restricted 451
#name "Bind Valkyrie"
#descr "The Valkyries are flying messengers of death from the lands of the Vanir. The Airyan Sect are deeply enamoured by the beauty and power of the Valkyries and will use the purity of Ulmish blood to bind them to the Reich. Valkyries are equipped with experimental automatic rifles. They are not demons and cannot be banished."
#school 6
#researchlevel 3
#path 0 8
#path 1 1
#pathlevel 0 3
#pathlevel 1 1
#effect 10001
#damage 6646
#nreff 1
#fatiguecost 800
#end

#newspell
#restricted 451
#name "Construct Airyaplane"
#descr "A sacred, magical construct capable of ferrying around a small complement of dedicated Air Infantrymen very quickly. It would carry an autogun and be a capable patroller, in addition to serving as the command element for Lightning Guard and Assault Valkyries. Resistant to thunder and lightning, it could even fly during storms. The construct, Air Infantry and crew together require 15 pounds of gold in wages and maintenance costs each month."
#school 3
#researchlevel 5
#path 0 1
#pathlevel 0 3
#effect 10021
#damage 6574
#nreff 1
#fatiguecost 3000
#end

#newspell
#restricted 451
#name "Hollow World Expedition"
#descr "Senior officers in the Secret Police are convinced Ulmreich would massively benefit from the exploration and conquest of the world beneath this one. Magic equipment will be produced that will allow specially trained mountaineers to see in the utter darkness of the caves leading to the interior of the world. This will give Ulmreich an easily defendable network of passages and hidden cities to retreat to. Each Vampir Guardsman will draw wages of 16 pounds of gold each year, while the Officer receives twice that."
#school 4
#researchlevel 5
#path 0 3
#path 1 1
#pathlevel 0 3
#pathlevel 1 1
#effect 10001
#damage 6656
#nreff 7
#fatiguecost 2400
#nextspell 2861
#end

#selectspell 2861
#clearspell
#restricted 451
#name "Expedition Leader"
#descr "Senior officers in the Secret Police are convinced Ulmreich would massively benefit from the exploration and conquest of the world beneath this one. Magic equipment will be produced that will allow specially trained mountaineers to see in the utter darkness of the caves leading to the interior of the world. This will give Ulmreich an easily defendable network of passages and hidden cities to retreat to."
#school -1
#researchlevel 0
#path 0 -1
#pathlevel 0 0
#effect 10021
#damage 6657
#nreff 1
#end

#newspell
#restricted 452
#name "Augmentation"
#descr "A Special Agent, selected for his skill and loyalty, is enhanced with magical rituals, each more exhausting than the last. These rituals involve the creation of tiny beings of Air magic too small to see. The tiny beings alter the Agent's body in various ways. His skin is made an impenetrable barrier to enemy weapons and highly resistant to elemental magic and poison. His body heals battle wounds and afflictions at miraculous rates. He is made stronger and faster, able to outrun a horse and march for weeks without sleeping. He is more than human, but care should be taken as he could still be killed in a single strike by a powerful enemy, which would be fifty magical gems down the drain."
#school 1
#researchlevel 5
#path 0 1
#path 1 3
#pathlevel 0 4
#pathlevel 1 3
#effect 10021
#damage 6653
#nreff 1
#fatiguecost 5000
#end

#newspell
#restricted 452
#name "Outfit Seals"
#descr "The coasts of Manica are a fine defence against invasions from other nations, but taking the fight to the enemy is vital for enforcing God's will upon the world. We can use our Air and Water magic to build masks and vests for our holy troops, allowing them to march under the waves and bring the light of the Awakening God to the murky depths. Seals are equipped with short ranged spearguns which fire projectiles underwater. The Seals will be led by a holy officer with training in Air, Water or Astral magic. Each Seal will draw wages of 16 pounds of gold each year.""
#school 4
#researchlevel 4
#path 0 2
#path 1 1
#pathlevel 0 2
#pathlevel 1 1
#effect 10001
#damage 6658
#nreff 7
#fatiguecost 2000 -- fairly bad troops with limited item slots
#nextspell 2862
#end

#selectspell 2862
#clearspell
#restricted 452
#name "Seal Leader"
#descr "The coasts of Manica are a fine defence against invasions from other nations, but taking the fight to the enemy is vital for enforcing God's will upon the world. We can use our Air and Water magic to build masks and vests for our holy troops, allowing them to march under the waves and bring the light of the Awakening God to the murky depths. Seals are equipped with short ranged spearguns which fire projectiles underwater. The Seals will be led by a holy officer with training in Air, Water or Astral magic."
#school -1
#researchlevel 0
#path 0 -1
#pathlevel 0 0
#effect 10021
#damage 6660
#nreff 1
#end

#selectspell 2863
#clearspell
#restricted 451
#name "Summon Priest"
#descr "Creates a pilot-priest"
#school -1
#researchlevel 0
#path 0 -1
#pathlevel 0 0
#effect 21
#damage 6662
#nreff 1
#end

#newspell
#restricted 450
#name "Bind Assault Devil"
#descr "The caster sacrifices several blood slaves to contact and bind a Devil. Devils are infernal beings of great strength. They are born in the fires of the Inferno and are impervious to heat and flame. Their glowing bodies radiate heat and bat-like wings grow from their shoulders. Assault Devils are armed with experimental automatic rifles and their barbed tails can sting opponents in close combat."
#school 6
#researchlevel 4
#path 0 8
#path 1 0
#pathlevel 0 3
#pathlevel 1 2
#effect 10001
#damage 6566
#nreff 1
#fatiguecost 1000
#end

#newspell
#restricted 451
#name "Bind Assault Devil"
#descr "The caster sacrifices several blood slaves to contact and bind a Devil. Devils are infernal beings of great strength. They are born in the fires of the Inferno and are impervious to heat and flame. Their glowing bodies radiate heat and bat-like wings grow from their shoulders. Assault Devils are armed with experimental automatic rifles and their barbed tails can sting opponents in close combat."
#school 6
#researchlevel 4
#path 0 8
#path 1 0
#pathlevel 0 3
#pathlevel 1 2
#effect 10001
#damage 6565
#nreff 1
#fatiguecost 1000
#end

#newspell
#restricted 450
#name "Build Horseless Carriage"
#descr "The horseless carriage is an automaton propelled on tough wheels instead of being pulled by horses. Quick and reliable, it carries five Motorised Riflemen into combat, and is fast enough to quickly replenish them if they are lost in action. It is often used to rapidly reinforce threatened provinces. The magic engine requires a combination of Air and Earth magic to build, and is fuelled by Air gems. The driver and Riflemen together draw wages of 5 pounds of gold each month."
#school 3
#researchlevel 3
#path 0 1
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10021
#damage 6900
#nreff 1
#fatiguecost 1200
#end

#newspell
#restricted 451
#name "Produce Horseless Carriage"
#descr "The horseless carriage is an automaton propelled on tough wheels instead of being pulled by horses. Quick and reliable, it carries five Panzergrenadiers into combat, and is fast enough to quickly replenish them if they are lost in action. It is often used to rapidly reinforce threatened provinces. The magic engine requires a combination of Air and Earth magic to build, and is fuelled by Air gems. The driver and Panzergrenadiers together draw wages of 5 pounds of gold each month."
#school 3
#researchlevel 3
#path 0 1
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10021
#damage 6902
#nreff 1
#fatiguecost 1200
#end

#newspell
#restricted 452
#name "Construct Horseless Carriage"
#descr "The horseless carriage is an automaton propelled on tough wheels instead of being pulled by horses. Quick and reliable, it carries five Mounted Infantrymen into combat, and is fast enough to quickly replenish them if they are lost in action. It is often used to rapidly reinforce threatened provinces. The magic engine requires a combination of Air and Earth magic to build, and is fuelled by Air gems. The driver and Infantrymen together draw wages of 5 pounds of gold each month."
#school 3
#researchlevel 3
#path 0 1
#path 1 3
#pathlevel 0 1
#pathlevel 1 1
#effect 10021
#damage 6559
#nreff 1
#fatiguecost 1200
#end

#newspell
#restricted 453
#name "Construct Walker"
#descr "The All Terrain Transport Walker fills the equivalent role of cavalry in the Imperial armies, destroying vulnerable targets in the enemy's rear. It carries a heavy blaster but it is more effective at walking over smaller enemies. The construct requires 12 pounds of gold for maintenance and crew wages every month."
#school 3
#researchlevel 5
#path 0 0
#pathlevel 0 2
#effect 10021
#damage 6827
#nreff 1
#fatiguecost 2500
#end

#newspell
#copyspell "Divine Blessing"
#restricted 453
#restricted 454
#name "Battle Meditation"
#descr "The Force Master inspires the entire army with a blessing and increased courage."
#fatiguecost 50
#school 7
#path 0 9
#pathlevel 0 4
#nextspell "Fanaticism"
#end

#newspell
#restricted 453
#restricted 454
#name "Floating Lightsabres"
#descr "The Force user animates a small number of Lightsabres to harass the enemy. They are floating, mindless, lifeless weapons that are fragile but inflict deadly strikes."
#school 0
#researchlevel 3
#path 0 4
#pathlevel 0 2
#effect 1
#damage -1138
#nreff 1000
#fatiguecost 100
#sound 22
#end

-------- ITEMS ------

#newitem 850
#spr "./Firepower/rifle.tga"
#constlevel 4
#restricted 450
#restricted 451
#restricted 452
#name "Anti-Materiel Rifle"
#descr "Where the common rifle is mass produced and utilitarian, this scoped rifle is a masterpiece lovingly crafted by an artisan. It fires incredibly accurate miniature shells which explode upon striking their target. Both the casing and explosive within are magic weapons which can harm ethereal beings, unlike ordinary rifles and artillery shells."
#mainpath 1
#mainlevel 1
#secondarypath 0
#secondarylevel 1
#weapon 1355
#type 2
#end

#newitem 853
#spr "./Firepower/anti-magic_uniform.tga"
#constlevel 4
#restricted 450
#restricted 451
#restricted 452
#name "Anti-Magic Uniform"
#descr "The many dangers facing our commanders are not limited to physical weapons. Poisons and elemental magic have been identified as a major threat to the success of the armies of the Awakening God. This protective suit has been developed to mitigate some of the risks posed by poison, fire, cold, shock and other forms of magic. It is still not very effective against blades and bolts, and it is very bulky and tiring to wear in battle."
#coldres 10
#fireres 10
#shockres 10
#poisonres 10
#mr 3
#mainpath 6
#mainlevel 2
#secondarypath 3
#secondarylevel 1
#armor 624
#type 5
#end

#newspell
#copyspell 688 -- fires from afar
#nreff 20
#name "Long Range Bombardment"
#descr "Rain shrapnel-laced death upon the enemies of the Awakening God. As many as 20 enemies will be struck for 15 points of damage."
--#effect 2 -- physical damage
--#spec 2097152 -- not magic
#damage 15
#school -1
#provrange 1
#nowatertrace 1
#fatiguecost 0
#end

#newspell
#copyspell 748 -- flames from the sky
#name "Rocket Bombardment"
#descr "Fire a rocket into an enemy army. As much as half of the army will be struck for 15 points of armour piercing damage."
#school -1
#provrange 2
#nowatertrace 1
#fatiguecost 0
#end

#selectitem 851
#spr "./Firepower/shell.tga"
#name "Bombardment"
#type 8
#nofind
#cursed
#constlevel 11
#spell "Long Range Bombardment"
#mainpath -1
#mainlevel 0
#end

#selectitem 852
#spr "./Firepower/rocket.tga"
#name "Rockets"
#type 8
#nofind
#cursed
#constlevel 11
#spell "Rocket Bombardment"
#mainpath -1
#mainlevel 0
#end

-- 1 handed Lightsabre

#newitem
#spr "./Firepower/sabre.tga"
#constlevel 4
#restricted 453
#restricted 454
#name "Masterwork Lightsabre"
#descr "Within the various orders of Force users, creating a Lightsabre is considered an act of deep spiritual significance. The supplicant sequesters himself for a month of meditation and artisanship in a crystal-bearing cave where acts of courage, kindness or slaughter have been committed, such as ancient battlefields or sites of duels between heroes and villains. The ambient Force aura seeps into the crystals, allowing the warrior-monk to project his or her Force ability into a shaft of pure energy, a Lightsabre, emitted from the harvested crystal. The hue of the blade depends upon both the aura of the crystal and the emotions of the Force user. For example, a warrior-monk dominated by great hatred and anger may project a red blade whereas blue signifies inner peace and calm. A crystal from a site of justice or injustice yields a blade coloured yellow, while a place that saw the blossoming of love or respect may produce a green blade.


This masterwork one-handed Lightsabre performs well enough in the melee, and it focuses its wielder's Force abilities, granting him or her a bonus to magic paths at the start of a battle."
#mainpath 4
#mainlevel 3
#secondarypath 0
#secondarylevel 1
#weapon 1320
#autospell "Power of the Spheres"
#type 1
#end

-- 2 handed Lightsabre

#newitem
#spr "./Firepower/heavy_sabre.tga"
#constlevel 2
#restricted 453
#restricted 454
#name "Masterwork two-handed Lightsabre"
#descr "Within the various orders of Force users, creating a Lightsabre is considered an act of deep spiritual significance. The supplicant sequesters himself for a month of meditation and artisanship in a crystal-bearing cave where acts of courage, kindness or slaughter have been committed, such as ancient battlefields or sites of duels between heroes and villains. The ambient Force aura seeps into the crystals, allowing the warrior-monk to project his or her Force ability into a shaft of pure energy, a Lightsabre, emitted from the harvested crystal. The hue of the blade depends upon both the aura of the crystal and the emotions of the Force user. For example, a warrior-monk dominated by great hatred and anger may project a red blade whereas blue signifies inner peace and calm. A crystal from a site of justice or injustice yields a blade coloured yellow, while a place that saw the blossoming of love or respect may produce a green blade.


This masterwork two-handed Lightsabre is the mark of a warrior who loses himself in battle, letting neither blade, bolt or spell stand in the way of victory."
#mainpath 0
#mainlevel 2
#weapon 1321
#autospell "Air Shield"
#bers
#mr 3
#type 2
#end

-- Short Lightsabre

#newitem
#spr "./Firepower/small_sabre.tga"
#constlevel 2
#restricted 453
#restricted 454
#name "Masterwork short Lightsabre"
#descr "Within the various orders of Force users, creating a Lightsabre is considered an act of deep spiritual significance. The supplicant sequesters himself for a month of meditation and artisanship in a crystal-bearing cave where acts of courage, kindness or slaughter have been committed, such as ancient battlefields or sites of duels between heroes and villains. The ambient Force aura seeps into the crystals, allowing the warrior-monk to project his or her Force ability into a shaft of pure energy, a Lightsabre, emitted from the harvested crystal. The hue of the blade depends upon both the aura of the crystal and the emotions of the Force user. For example, a warrior-monk dominated by great hatred and anger may project a red blade whereas blue signifies inner peace and calm. A crystal from a site of justice or injustice yields a blade coloured yellow, while a place that saw the blossoming of love or respect may produce a green blade.


This masterwork shortened Lightsabre is more suited than the longer variants for fighting styles that use two weapons."
#mainpath 0
#mainlevel 1
#weapon 1322
#luck
#type 1
#end

-- Double-bladed Lightsabre

#newitem
#spr "./Firepower/doublebladed.tga"
#constlevel 4
#restricted 453
#restricted 454
#name "Masterwork double-bladed Lightsabre"
#descr "Within the various orders of Force users, creating a Lightsabre is considered an act of deep spiritual significance. The supplicant sequesters himself for a month of meditation and artisanship in a crystal-bearing cave where acts of courage, kindness or slaughter have been committed, such as ancient battlefields or sites of duels between heroes and villains. The ambient Force aura seeps into the crystals, allowing the warrior-monk to project his or her Force ability into a shaft of pure energy, a Lightsabre, emitted from the harvested crystal. The hue of the blade depends upon both the aura of the crystal and the emotions of the Force user. For example, a warrior-monk dominated by great hatred and anger may project a red blade whereas blue signifies inner peace and calm. A crystal from a site of justice or injustice yields a blade coloured yellow, while a place that saw the blossoming of love or respect may produce a green blade.


This masterwork double-bladed Lightsabre turns the wielder into a dodging, weaving blur of action, leaving the enemy overwhelmed by the myriad strikes."
#mainpath 0
#mainlevel 2
#weapon 1323
#quickness
#type 2
#end

-- Small shuttle

#newitem
#spr "./Firepower/transport_shuttle.tga"
#name "Personal Shuttle"
#descr "The Lambda class personal shuttle is a large construct designed for flying commanders and their entourage from province to province, giving the Empire's leaders greater mobility."
#type 8
#constlevel 11 -- change to 2 when flytr works
#restricted 453
#restricted 454
#mainpath 1
#mainlevel 2
#flytr 12 -- not yet implemented
#end

-- Big shuttle

#newitem
#spr "./Firepower/transport_shuttle.tga"
#name "Transport Shuttle"
#descr "The Sentinel class transport shuttle is a very large construct designed for flying small armies from province to province, both for reinforcing garrisons and for raiding the enemy's rear areas."
#type 8
#constlevel 11 -- change to 4 when flytr works
#restricted 453
#restricted 454
#mainpath 1
#mainlevel 3
#flytr 24 -- not yet implemented
#end



-------- MERCENARIES ---------

#newmerc
#name "The Contras"
#bossname "Ronnie Raygun"
#com "Infantry Officer"
#unit "Infantry Rifleman"
#nrunits 15
#level 0
#minpay 250
#minmen 12
#xp 5
#randequip 0
#recrate 300
#eramask 4
#end

#newmerc
#name "The Freikorps"
#bossname "Waldemar Pabst"
#com "Brownshirt Leader"
#unit "Brownshirt Militiaman"
#nrunits 15
#level 0
#minpay 250
#minmen 12
#xp 5
#randequip 0
#recrate 300
#eramask 4
#end

#newmerc
#name "The Communards"
#bossname "Louis Delescluze"
#com "Regimental Banner"
#unit "Rifle Infantryman"
#nrunits 15
#level 0
#minpay 250
#minmen 12
#xp 5
#randequip 0
#item "Crown of Command"
#recrate 300
#eramask 4
#end

#newmerc
#name "Pavlov's Company"
#bossname "Sergeant Pavlov"
#com "Assault Banner"
#unit "Rifle Infantryman"
#nrunits 20
#level 1
#minmen 15
#minpay 350
#xp 5
#randequip 0
#item "Pendant of Luck"
#recrate 500
#eramask 4
#end

#newmerc
#name "International Brigade"
#bossname "Hans Marchwitza"
#com "Infantry Commander"
#unit "Rifle Infantryman"
#nrunits 40
#level 2
#minmen 30
#minpay 600
#xp 5
#randequip 0
#item "Shroud of the Battle Saint"
#recrate 1000
#eramask 4
#end

#newmerc
#name "Pazaak Prowler"
#bossname "Atton"
#com 6822 -- bounty hunter
#level 1
#minpay 40
#xp 5
#randequip 0
#eramask 4
#end

#newmerc
#name "Cloud City Crushers"
#bossname "Lando"
#com 6820 -- imperial governor
#unit 6821 -- mercenary thug
#nrunits 30
#level 2
#minmen 10
#minpay 400
#xp 5
#randequip 0
#recrate 1000
#eramask 4
#end



-------- EVENTS ---------

#newevent
#rarity 			1		-- province event, common bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6837	-- grey paladin
#msg "One of your Grey Paladins in ##landname## found a place powerful in the Dark Side of the Force and suffered a vision of an old blind woman. 'Apathy is death,' she says, before attacking!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			2		-- province event, uncommon bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6847 	-- jedi archivist
#msg "One of your Jedi Archivists in ##landname## finds a place powerful in the Dark Side of the Force and suffers a vision of an old blind woman. 'There must always be a Darth Traya, someone who holds the knowledge of betrayal. Who has been betrayed in their heart, and will betray in turn,' she says. She reveals herself as a Sith Lord!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			2		-- province event, uncommon bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6848 	-- jedi sentinel
#msg "One of your Jedi Sentinels in ##landname## finds a place powerful in the Dark Side of the Force and suffers a vision of an old blind woman. 'There must always be a Darth Traya, someone who holds the knowledge of betrayal. Who has been betrayed in their heart, and will betray in turn,' she says. She reveals herself as a Sith Lord!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			2		-- province event, uncommon bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6851 	-- jedi guardian
#msg "One of your Jedi Guardians in ##landname## finds a place powerful in the Dark Side of the Force and suffers a vision of an old blind woman. 'There must always be a Darth Traya, someone who holds the knowledge of betrayal. Who has been betrayed in their heart, and will betray in turn,' she says. She reveals herself as a Sith Lord!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			2		-- province event, uncommon bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6835 	-- jedi consular
#msg "One of your Jedi Consulars in ##landname## finds a place powerful in the Dark Side of the Force and suffers a vision of an old blind woman. 'There must always be a Darth Traya, someone who holds the knowledge of betrayal. Who has been betrayed in their heart, and will betray in turn,' she says. She reveals herself as a Sith Lord!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			2		-- province event, uncommon bad
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6836 	-- jedi peacekeeper
#msg "One of your Jedi Peacekeepers in ##landname## finds a place powerful in the Dark Side of the Force and suffers a vision of an old blind woman. 'There must always be a Darth Traya, someone who holds the knowledge of betrayal. Who has been betrayed in their heart, and will betray in turn,' she says. She reveals herself as a Sith Lord!"
#assassin 			6858	-- darth traya
#end

#newevent
#rarity 			-2		-- province event, uncommon good
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6847 	-- jedi archivist
#msg "One of your Jedi Archivists in ##landname## finds a place powerful in the Dark Side of the Force and encounters an old blind woman. 'Am I Jedi or Sith? Perhaps I am neither and I hold both as what they are: pieces of a whole. Know that I am your teacher, and that is enough,' she says. Your Jedi learns many dark secrets."
#pathboost 5
#end

#newevent
#rarity 			-2		-- province event, uncommon good
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6848 	-- jedi sentinel
#msg "One of your Jedi Sentinels in ##landname## finds a place powerful in the Dark Side of the Force and encounters an old blind woman. 'Am I Jedi or Sith? Perhaps I am neither and I hold both as what they are: pieces of a whole. Know that I am your teacher, and that is enough,' she says. Your Jedi learns many dark secrets."
#pathboost 5
#end

#newevent
#rarity 			-2		-- province event, uncommon good
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6851 	-- jedi guardian
#msg "One of your Jedi Guardians in ##landname## finds a place powerful in the Dark Side of the Force and encounters an old blind woman. 'Am I Jedi or Sith? Perhaps I am neither and I hold both as what they are: pieces of a whole. Know that I am your teacher, and that is enough,' she says. Your Jedi learns many dark secrets."
#pathboost 5
#end

#newevent
#rarity 			-2		-- province event, uncommon good
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6835 	-- jedi consular
#msg "One of your Jedi Consulars in ##landname## finds a place powerful in the Dark Side of the Force and encounters an old blind woman. 'Am I Jedi or Sith? Perhaps I am neither and I hold both as what they are: pieces of a whole. Know that I am your teacher, and that is enough,' she says. Your Jedi learns many dark secrets."
#pathboost 5
#end

#newevent
#rarity 			-2		-- province event, uncommon good
#req_land 			1		-- requires a land province
#req_monster 		6857	-- kreia
#req_targmnr 		6836 	-- jedi peacekeeper
#msg "One of your Jedi Peacekeepers in ##landname## finds a place powerful in the Dark Side of the Force and encounters an old blind woman. 'Am I Jedi or Sith? Perhaps I am neither and I hold both as what they are: pieces of a whole. Know that I am your teacher, and that is enough,' she says. Your Jedi learns many dark secrets."
#pathboost 5
#end
