--------- mod info
#modname "Sheseba"
#description "Adds a nation of artificial men with control over weather and beast."
#icon "./EA_Sheseba/Logo.tga"
#version 1.1

--------- weapons
#newweapon
#copyweapon 172 --magic scepter
#name "Magic Wand"
#rcost 3
#skip
#end

#newweapon
#name "Magical Bolt"
#dmg 8
#nratt 1
#sound 3
#range 45
#ammo 1005
#armorpiercing
#magic
#nostr
#mrnegates
#norepel
#unrepel
-- #explspr 10141
#flyspr 10065 9
#uwok
#end

#newweapon
#copyweapon 7 --staff
#name "Staff of Knowledge"
#magic
#secondaryeffect 468 --halt demon
#end

#newweapon
#copyweapon 746 --scimitar
#name "Flaming Scimitar"
#secondaryeffect 216
#magic
#end

--------- armors
#newarmor
#copyarmor 2
#name "Mirror Shield"
#rcost 5
#magic
#end

--------- units
#newmonster 8140 --Sol Aut carrier
#spr1 "./EA_Sheseba/Solaut Carrier.png"
#spr2 "./EA_Sheseba/Solaut Carrier.png"
#name "Sol Aut Carrier"
#descr "Carrier of a Great Vessel containing a bound spirit."
#gcost 10017
#rpcost 10
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 9
#def 9
#prec 11
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon 92 --fist
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#nobarding
#end

#newmonster 8141 --Sol Aut Archer
#spr1 "./EA_Sheseba/Solaut Archer.png"
#spr2 "./EA_Sheseba/Solaut Archer2.png"
#name "Sol Aut Archer"
#descr "Magic Wands are the dominant ranged weapon in the arsenal of Sheseba but bows haven't entirely fallen out of favor. Inspired by the humans that dwell in the lands surrounding them some Sol Aut are trained to wield stiff metal bows. This allows them to outrange their kin that rely on wands. They're exceptionally accurate with their untiring eyes."
#gcost 10019
#rpcost 10
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 10
#def 10
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon 266 --great bow
#weapon 6 --short sword
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8142 --Sol Aut caster
#spr1 "./EA_Sheseba/Solaut Caster.png"
#spr2 "./EA_Sheseba/Solaut Caster2.png"
#name "Sol Aut Caster"
#descr "Archery is common in the lands around Sheseba but the Sol Aut themselves prefer the magic wands from their vaults. Invented by their creators these devices harness arcane energies and unleash them as a projectile. In a pinch the heavy crystal topped wands work fine as an improviced mace. On campaigns each soldier carries two wands at once to maximize the firepower."
#gcost 10035
#rpcost 30
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 10
#def 10
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon "Magic Wand"
#weapon "Magical Bolt"
#weapon "Magic Wand"
#weapon "Magical Bolt"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8143 --Sol Aut guard
#spr1 "./EA_Sheseba/Solaut Guard.png"
#spr2 "./EA_Sheseba/Solaut Guard2.png"
#name "Sol Aut Guard"
#descr "The Sol Aut were originally created as guards. Meant to protect the towers and palaces of their creators. Some still retain these duties, protect their leaders from the enemies that surround Sheseba.

Armed with a glaive these men strike an imposing image for anyone attempting to sneak into the rooms they protect. Like all of their kin, animals find it hard to strike at them. They seek to innately command the animal world."
#gcost 10025
#rpcost 15
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 11
#def 11
#prec 11
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon 308 --glaive
#nametype 163 --naba male
#patrolbonus 5
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8144 --Sol Aut spell guard
#spr1 "./EA_Sheseba/Spell Guard.png"
#spr2 "./EA_Sheseba/Spell Guard2.png"
#name "Spell Guard"
#descr "Mirror Shields are another invention of the creators. Shields that reflect magical energy, allowing the wielder to withstand spells more easily. They also shine brightly in the abundant sun of Sheseba, making it hard to strike them at times. The Spell Guard are considered superior to most other soldiers deployed by the kingdom. Veterans of great skill are sometimes repaired and outfitted with new limbs."
#gcost 10042
#rpcost 18
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 11
#def 12
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 16
#weapon 746 --scimitar
#armor "Mirror Shield"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#sunawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8145 --Sol Aut elite
#spr1 "./EA_Sheseba/Solaut Champion.png"
#spr2 "./EA_Sheseba/Solaut Champion2.png"
#name "Sol Aut Champion"
#descr "Champions are those who proven themselves. They wield both deadly wands and swords of magical fire. The people of Sheseba aren't particularly superstitious but these have proven themselves exceptional even to their kin. So they're held in the highest regard, seen as the sword of the Awakened God itself."
#gcost 10050
#rpcost 25
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 13
#def 11
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 13
#weapon "Magic Wand"
#weapon "Magical Bolt"
#weapon "Flaming Scimitar"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#holy
#end


-----COMMANDERS

#newmonster 8146 --Sol Aut scout
#spr1 "./EA_Sheseba/Scout Flock.png"
#spr2 "./EA_Sheseba/Scout Flock2.png"
#name "Flock of Birds"
#descr "A flock of birds controlled by magic. Not brave, they break apart on attack but often reform. Scholomanic sorcery has extensive powers over the animal kingdom. This includes bird speak, allowing the Sol Aut to rely on the reports of birds to scout the lands around them."
#gcost 10017
#rpcost 10000
#rcost 1
#miscshape
#size 2
#hp 3
#prot 1
#mor 8
#str 5
#att 14
#def 14
#prec 13
#mapmove 22
#ap 4
#enc 2
#mr 5
#weapon 753 --dive
#weapon 408 --talon
#nametype 163 --naba male
#flying
#stealthy 20
#animal
#wastesurvival
#forestsurvival
#noleader
#reform 70
#startage 2
#maxage 15
#end

#newmonster 8147 --Sol Aut scout
#spr1 "./EA_Sheseba/Scout Bird.png"
#spr2 "./EA_Sheseba/Scout Bird2.png"
#name "Mechanical Bird"
#descr "Tireless bird of the creators. The Sol Aut aren't the only constructs made by the creators. They make both large and small creators, including imitation birds. Unlike living birds this thing never tires. It can fly and spy all day long. But their supply isn't endless, only the vaults of the capital have sufficient numbers to send them out."
#gcost 10025
#rpcost 10000
#bird
#rcost 1
#size 4
#hp 8
#prot 16
#mor 50
#str 7
#att 9
#def 13
#prec 14
#mapmove 28
#ap 6
#enc 0
#mr 11
#weapon 753 --dive
#weapon 408 --talon
#nametype 163 --naba male
#flying
#spy
#stealthy 20
#spiritsight
#neednoteat
#magicbeing
#noheal
#inanimate
#slashres
#acidres -5
#noleader
#startage 0
#end


#newmonster 8148 --Sol Aut captain
#spr1 "./EA_Sheseba/Solaut Captain.png"
#spr2 "./EA_Sheseba/Solaut Captain2.png"
#name "Sol Aut Captain"
#descr "Captains are the lowest ranking commander in the Sheseban military. Traditionally outfitted with a wand and a shield for protection they direct their troops from the back."
#gcost 10017
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 11
#def 11
#prec 11
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon "Magic Wand"
#weapon "Magical Bolt"
#armor 2 --shield
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#goodmagicleader
#end

#newmonster 8149 --Sol Aut caster
#spr1 "./EA_Sheseba/Solaut Sorcerer.png"
#spr2 "./EA_Sheseba/Solaut Sorcerer2.png"
#name "Sol Aut Sorcerer"
#descr "With the disappearance of the creators Sol Aut have picked up their mantel. Engaging in magical research they seek to recreate the knowledge of their creators. Sorcerers carry wands and tomes with magical knowledge. Their magic grants them control over air and fire."
#gcost 10017
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 9
#def 9
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 14
#weapon "Magic Wand"
#weapon "Magical Bolt"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 0 1
#magicskill 1 1
#magicskill 7 1
#custommagic 384 100 --AF1
#magicstudy 1
#poorleader
#poormagicleader
#end

#newmonster 8150 --Sol Aut high sorc
#spr1 "./EA_Sheseba/Solaut High Sorcerer.png"
#spr2 "./EA_Sheseba/Solaut High Sorcerer2.png"
#name "Sol Aut High Sorcerer"
#descr "High Sorcerers are the masters of their school. They've taken of residence in the empty towers of the creators. They lead lesser sorcerers in their research, taking on students as they see fit. As a badge of their office they carry might staves instead of mere wands.

They wield significant power over air and fire but also the secrets of pure astral and illusory glamour magic is known to them. Control over animals comes them easier than most and they have hardly anything to fear from them."
#gcost 10017
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 9
#def 9
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 16
#weapon 238 --magic staff
#weapon "Magical Bolt"
#nametype 163 --naba male
#slowrec
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 3
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 0 1
#magicskill 1 1
#magicskill 4 2
#magicskill 7 1
#custommagic 384 100 --AF1
#magicstudy 2
#poorleader
#poormagicleader
#batstartsum5 -18001 --batstart animals
#end

#newmonster 8151 --Sol Aut commander
#spr1 "./EA_Sheseba/Solaut Commander.png"
#spr2 "./EA_Sheseba/Solaut Commander2.png"
#name "Sol Aut Commander"
#descr "Commanders outrank captains, easily recognized by their brass face plate. Designating their rank closer to the High Sorcerer. 

Armed with a scimitar and a wand their focus is on offensive magic. They're trained by High Sorcerers in air and fire."
#gcost 10017
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 12
#def 11
#prec 11
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon "Magic Wand"
#weapon "Magical Bolt"
#weapon 746 --scimitar
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 3
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 7 1
#custommagic 384 200 --AF2
#expertmagicleader
#goodleader
#end

#newmonster 8152 --Sol Aut priest
#spr1 "./EA_Sheseba/Solaut Priest.png"
#spr2 "./EA_Sheseba/Solaut Priest.png"
#name "Sol Aut Priest"
#descr "The Sol Aut were never religious people unlike their creators. They just served them till they left. Now with the Awakened God their is a new need to spread the word of truth. Priests carry the symbol of the creators which still holds strong sway over evil spirits.

All priests are also taught the secret of animal speech. They're accompanied by animals entralled by their sermons."
#gcost 10029
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 10
#def 10
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 14
#weapon "Staff of Knowledge"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 9 1
#holy
#beastmaster 3
#poorleader
#poormagicleader
#batstartsum3 -18001 -- animals? N1?
#end

#newmonster 8153 --great spirit
#copystats 3465
#clearmagic
#clearweapons
#spr1 "./EA_Sheseba/Djinn.png"
#spr2 "./EA_Sheseba/Djinn2.png"
#name "Great Jinnun"
#descr "In the vaults of Sheseba lay large bronze vessels. Inside the creators sealed great spirits they'd battled with for control of the land. Trapped inside the vessel they're unable to escape, coerced to wield their magic but their prison dampens their power. Should the vessel be breached the great spirit will escape, it might still aid the battle in full power but afterwards disappears.

Properly secured spirits can't be banished for the container works both ways, sealing the being within."
#weapon 92 --fist
#magicskill 0 4
#magicskill 1 3
#magicskill 6 2
#magicskill 7 2
#magicskill 4 3
#magicboost 0 2
#magicboost 1 1
#magicboost 6 1
#magicboost 7 1
#magicboost 4 1
#magicboost 3 1
#cleanshape
#end


#newmonster 8154 --djinn lamp carried
#spr1 "./EA_Sheseba/Great Vessel.png"
#spr2 "./EA_Sheseba/Great Vessel.png"
#unmountedspr1 "./EA_Sheseba/LooseVessel.png"
#unmountedspr2 "./EA_Sheseba/LooseVessel.png"
#name "Great Vessel"
#descr "In the vaults of Sheseba lay large bronze vessels. Inside the creators sealed great spirits they'd battled with for control of the land. Trapped inside the vessel they're unable to escape, coerced to wield their magic but their prison dampens their power. Should the vessel be breached the great spirit will escape, it might still aid the battle in full power but afterwards disappears.

Properly secured spirits can't be banished for the container works both ways, sealing the being within. It's carried into battle by the Sol Aut to unleash their significant magical powers onto the enemy."
#gcost 10247
#rpcost 10007
#rcost 40
#slowrec
#miscshape
#noweapon 1
#size 7
#hp 45
#prot 18
#mor 18
#str 10
#att 5
#def 0
#prec 11
#mapmove 4
#ap 2
#enc 2
#mr 18
-- #weapon -1
#nametype 163 --naba male
#maxage 1000
#blind
#neednoteat
#pooramphibian
#magicbeing
#noheal
#wastesurvival
#immobile
#poisonres 25
#slashres
#magicskill 0 2
#magicskill 1 2
-- #magicskill 6 1
#magicskill 7 1
#magicskill 4 2
#custommagic 9216 100
#bonusspells 1
#poorleader
#goodmagicleader
#mountmnr "Sol Aut Carrier"
#nofmounts 2
#regainmount 1
#secondtmpshape 8153 --Great Jinnun
#end
--------SUMMONS
#newmonster 8155 --brass head
#spr1 "./EA_Sheseba/Brazen Head.png"
#spr2 "./EA_Sheseba/Brazen Head2.png"
#name "Brazen Head"
#descr "Brazen Heads are another invention of the creators. They trapped a demon inside a face of brass. When asked it is compelled to share knowledge about the universe. However if left alone it's free to whisper lies. Should the demon be free by the destruction of the face he will drag his savior with them to his infernal home."
#gcost 0
#rpcost 0
#rcost 0
#miscshape
#noweapon 1
#size 7
#hp 65
#prot 20
#mor 30
#str 10
#att 5
#def 0
#prec 10
#mapmove 4
#ap 2
#enc 0
#mr 18
-- #weapon -1
#nametype 140 --demons
#maxage 3000
#blind
#spiritsight
#neednoteat
#amphibian
#magicbeing
#noheal
#immobile
#poisonres 25
#bluntres
#pierceres
#inanimate
#fixedresearch 14
#inspiringres 1
#goodmagicleader
#inspirational -2
#deathbanish 12
#incunrest 10
#end

#newmonster 8156 --Sol Aut spell guard centaur
#spr1 "./EA_Sheseba/Solaut Centaur.png"
#spr2 "./EA_Sheseba/Solaut Centaur2.png"
#name "Spell Guard Veteran"
#descr "Veterans of the Spell Guard are sometimes deemed worthy of being repaired with limbs and parts from the vaults. This veteran is repaired and moved onto a larger chassis that mimics the legs of a lion and a bull. This should give him greater mobility, thus he has forsaken his scimitar for a lance."
#gcost 0
#rpcost 10007
#rcost 17
#mountedhumanoid
#itemslots 852486 --no feet no head
#size 7
#hp 45
#prot 16
#mor 14
#str 18
#att 12
#def 14
#prec 12
#mapmove 20
#ap 28
#enc 0
#mr 16
#weapon 357 --light lance
#weapon 236 --claw
#armor "Mirror Shield"
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#sunawe 1
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8157  --brass sphynx
#spr1 "./EA_Sheseba/Brass Sphynx.png"
#spr2 "./EA_Sheseba/Brass Sphynx2.png"
#name "Brazen Sphinx"
#descr "A construct of magical energies and brass. An imitation of what the creators used to make. It resembles a great sphinx with the paws of a lion and the hind legs of a bull. It sports two great mechanical wings allowing it fly itself into hordes of enemy troops. 

It's face is a mask suspended in magical blue flames. It speaks only in riddles but holds arcane secrets it will share with those who indulge it's riddles. This makes it a frustrating commander but useful to assist some sorcerers."
#gcost 0
#rpcost 10007
#rcost 17
#quadruped
#size 9
#hp 45
#prot 20
#mor 14
#str 18
#att 12
#def 14
#prec 12
#mapmove 26
#ap 22
#enc 0
#mr 16
#weapon 823 --claw magic
#weapon 823 --claw magic
#nametype 163 --naba male
#blind
#spiritsight --blind?
#neednoteat
#pooramphibian
#magicbeing
#noheal
#inanimate
#flying
#trample
#acidres -5
#poisonres 25
#fireres 15
#heat 3
#slashres
#pierceres
#fixedresearch 9
#poorleader
#inspirational -1
#goodmagicleader
#end

#newmonster 8158 --world tome
#spr1 "./EA_Sheseba/Walking Tome.png"
#spr2 "./EA_Sheseba/Walking Tome2.png"
#name "Walking Tome"
#descr "The towers and vaults of Sheseba are filled with forgotten tomes of magical knowledge. Over time the secrets in them leaked into the books themselves, gifting some sentience. The Sol Aut mount these tomes on walking stands, allowing them to follow the armies of the Awakened God. They throw spells on the approaching enemies but tomes aren't particularly smart so the spells appear largely random."
#gcost 0
#rpcost 10007
#rcost 17
#miscshape
#noweapon 1
#size 2
#hp 9
#prot 14
#mor 50
#str 9
#att 5
#def 5
#prec 10
#mapmove 12
#ap 10
#enc 0
#mr 16
#nametype 163 --naba male
#blind
#spiritsight --blind?
#neednoteat
#magicbeing
#noheal
#inanimate
#poisonres 15
#fireres -5
#fixedresearch 9
#noleader
#nomagicleader
#noundeadleader
#bonusspells 1
#randomspell 100
#magicskill 0 1
#magicskill 1 1
#magicskill 2 1
#magicskill 3 1
#magicskill 4 1
#magicskill 5 1
#magicskill 6 1
#magicskill 7 1
#magicskill 8 1
#magicboost 0 -5
#magicboost 1 -5
#magicboost 2 -5
#magicboost 3 -5
#magicboost 4 -5
#magicboost 5 -5
#magicboost 6 -5
#magicboost 7 -5
#magicboost 8 -5
#battleshape 8159
#end

#newmonster 8159 --battle tome
#spr1 "./EA_Sheseba/Walking Tome.png"
#spr2 "./EA_Sheseba/Walking Tome2.png"
#name "Walking Tome"
#descr "The towers and vaults of Sheseba are filled with forgotten tomes of magical knowledge. Over time the secrets in them leaked into the books themselves, gifting some sentience. The Sol Aut mount these tomes on walking stands, allowing them to follow the armies of the Awakened God. They throw spells on the approaching enemies but tomes aren't particularly smart so the spells appear largely random.

In combat the tomes have significant magical paths to cast spells, outside of combat these disappear for the tomes lack the understanding of casting rituals."
#gcost 0
#rpcost 10007
#rcost 17
#miscshape
#noweapon 1
#size 2
#hp 9
#prot 14
#mor 50
#str 9
#att 5
#def 5
#prec 10
#mapmove 12
#ap 10
#enc 0
#mr 16
#nametype 163 --naba male
#blind
#spiritsight --blind?
#neednoteat
#magicbeing
#noheal
#inanimate
#poisonres 15
#fireres -5
#fixedresearch 9
#noleader
#nomagicleader
#noundeadleader
#bonusspells 1
#randomspell 100
#magicboost 0 1
#magicboost 1 1
#magicboost 2 1
#magicboost 3 1
#magicboost 4 1
#magicboost 5 1
#magicboost 6 1
#magicboost 7 1
#magicboost 8 1
#firstshape 8158
#end

#newmonster 8160 --Sol Aut ancient
#spr1 "./EA_Sheseba/Solaut Ancient.png"
#spr2 "./EA_Sheseba/Solaut Ancient2.png"
#name "Ancient Sol Aut"
#descr "The oldest of the Sol Aut have generally slipped into a slumber. Even the potent spirits inside them can't fuel them forever. These constructs wield flaming blades and should they be destroyed the spirit inside them is freed, taking it's savior down to it's infernal home. While contained by the spells of the creators not even banishing magic can touch the spirit but it's incapable of harming beings on the mortal plane."
#gcost 0
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 18
#mor 12
#str 20
#att 13
#def 12
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 14
#older 500
#weapon "Flaming Scimitar"
#armor 2 --shield
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 3
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#holy
#deathbanish 12
#end

#newmonster 8161
#spr1 "./EA_Sheseba/AnimalWolf.png"
#spr2 "./EA_Sheseba/AnimalWolf2.png"
#copystats 284
#montag 18001
#montagweight 2
#end

#newmonster 8162
#copyspr 3371 --falcon
#copystats 3371
#name "kestrel"
#descr "The kestrel is a small bird of prey that favors woodlands nesting and hunts small prey animals."
#montag 18001
#montagweight 3
#end

#newmonster 8163
#copyspr 2294 --hyena
#copystats 2294
#clearspec
#clearmagic
#clearweapons
#name "Hyena"
#descr "Hyenas are communal carnivores that compete with lions into the grasslands near Machaka. They have a powerful bite that snaps bones."
#weapon 20 --bite
#animal
#wastesurvival
#stealthy
#montag 18001
#montagweight 2
#end

#newmonster 8164
#copystats 3371
#spr1 "./EA_Sheseba/AnimalVulture.png"
#spr2 "./EA_Sheseba/AnimalVulture2.png"
#name "Vulture"
#descr "The vulture is a medium sized carrior eater that devours carcasses in the dry grasslands and mountains."
#hp 5
#str 5
#neednoteat
#montag 18001
#montagweight 3
#end

#newmonster 8165
#copyspr 2133 --lioness
#copystats 2133
#montag 18001
#montagweight 1
#end

#newmonster 8166
#spr1 "./EA_Sheseba/AnimalJackal.png"
#spr2 "./EA_Sheseba/AnimalJackal2.png"
#name "Jackal"
#descr "The jackal is a common predator of dry climates. Jackals are sometimes venerated as guardians of the dead but mostly seen as scavengers."
#copystats 284
#montag 18001
#montagweight 2
#end

#newmonster 8167
#spr1 "./EA_Sheseba/AnimalMangoose.png"
#spr2 "./EA_Sheseba/AnimalMangoose2.png"
#copystats 284
#name "Mangoose"
#descr "Mangoose are small predators that are particularly suited for fighting snakes are they're extremely resilient against snake venom."
#hp 5
#size 2
#str 5
#att 13
#poisonres 10
#montag 18001
#montagweight 1
#end

#newmonster 8168
#spr1 "./EA_Sheseba/AnimalDibatag.png"
#spr2 "./EA_Sheseba/AnimalDibatag2.png"
#clearweapons
#name "Dibatag"
#descr "A herbivore, a small deer like creature that favors flight over fight."
#copystats 2228 --deer
#hp 10
#ap 24
#mapmove 22
#weapon 331
#montag 18001
#montagweight 2
#end

#newmonster 8169
#spr1 "./EA_Sheseba/AnimalRabbit.png"
#spr2 "./EA_Sheseba/AnimalRabbit2.png"
#name "Desert Rabbit"
#descr "A small herbivore. Rabbits aren't meant for combat."
#copystats 2228
#hp 4
#size 1
#prot 1
#mor 5
#str 5
#ap 18
#mapmove 18
#weapon 397 --kick
#montag 18001
#montagweight 3
#end

#newmonster 8170 --ostrich
#spr1 "./EA_Sheseba/OstrichB1.png"
#spr2 "./EA_Sheseba/OstrichB2.png"
#name "Ostrich"
#descr "Beyond the forests of Machake lay great fields of dry grassland. Here the lion is king, to survive one must outwit him. Or outrun him, the ostrich are great flightless birds specialized in running. They're not brave but should one be cornered they can deliver a great kick from their large clawed talons."
#gcost 0
#rpcost 10000
#hp 18
#size 4
#prot 3
#mr 5
#mor 9
#str 14
#att 11
#def 12
#prec 5
#ap 24
#mapmove 22
#enc 3
#weapon	583 --talon kick
#fireres 3
#wastesurvival 
#animal
#undisciplined
#bird
#lanceok
#nametype 144 --animals
#montag 18001
#montagweight 3
#end

#newmonster 8171 --pet rhino
#spr1 "./EA_Sheseba/AnimalRhino.png"
#spr2 "./EA_Sheseba/AnimalRhino2.png"
#name "Rhinoceros"
#descr "Rhinoceroses are large and heavy animals protected by a thick hide. They charge and trample any perceived threat."
#hp 35
#size 6
#prot 14
#mr 6
#mor 10
#str 16
#prec 5
#enc 4
#mapmove 12
#ap 15
#weapon 331 --gore
#slashres
#quadruped
#swimming
#forestsurvival
#swampsurvival
#animal
#trample
#nametype 144 --animals
#montag 18001
#montagweight 1
#end

#newmonster 8172  --brass sphynx god
#spr1 "./EA_Sheseba/Brass Sphynx God.png"
#spr2 "./EA_Sheseba/Brass Sphynx God2.png"
#name "Brazen Sphinx"
#descr "The Brazen Sphinx is an ancient construct by a forgotten race of sorcerers. As they abandoned with alongside their other servants it lay dorment in dusty vaults. Over time the other servants looked at it an marveled at the mechanical perfection. None of their imitations had the quality of the original. They saw it as a divine creation and started to pray to it for guidance in their own creative efforts. 

It's shaped like a giant sphinx with the front legs of a lion and the behind of a bull. It's great face sports horns and a large beard runs down it's neck. Over time it gained sentience but like it's lesser kin prefers to speak in riddles. It has absorbed many secrets over the centuries and easily uncovers magical knowledge."
#gcost 10000
#rpcost 10007
#rcost 17
#quadruped
#size 9
#hp 145
#prot 20
#mor 30
#str 18
#att 12
#def 14
#prec 12
#mapmove 26
#ap 22
#enc 0
#mr 18
#weapon 823 --claw magic
#weapon 823 --claw magic
#weapon 830 --gore
#nametype 163 --naba male
#blind
#spiritsight --blind?
#neednoteat
#pooramphibian
#magicbeing
#noheal
#inanimate
#flying
#trample
#mastersmith -1
#acidres -5
#poisonres 25
#slashres
#pierceres
#startdom 2
#pathcost 80
#magicskill 0 1
#magicskill 3 1
#researchbonus 7
#inspirational -1
#goodmagicleader
#end

#newmonster 8173  --shamir
#copystats 2526
#spr1 "./EA_Sheseba/Shamir.png"
#spr2 "./EA_Sheseba/Shamir.png"
#name "Shamir"
#descr "The Shamir appear related to the cave grubs that dwell deep in the caverns of the earth. The creators drew them to the surface to aid them in the construction of their palaces. Shamir eat as easily through stone as a goat does grass. 

Their backs are covered in crystaline growths, useful for wand production."
#gcost 0
#prot 10
#mr 9
#siegebonus 15
#end

--------- heroes
#newmonster 8175 --Sol Aut spell guard centaur
#spr1 "./EA_Sheseba/Solaut Sorcerer Centaur.png"
#spr2 "./EA_Sheseba/Solaut Sorcerer Centaur2.png"
#name "Repaired"
#descr "Iohé Grevis is a High Sorcerer of great reknown. Famed for his ability to decypher the tomes left behind by the creators he was held in the highest esteem. When he was wounded during an attack he was the first high sorcerer to ever be outfitted in the way of the Spell Guard Veterans. He augmented his new form with magical claws and the horns in the image of the creators.

A master in all ways of magic his animal control displays a particular fondness for lions."
#gcost 0
#rpcost 10007
#rcost 17
#mountedhumanoid
#itemslots 852486 --no feet no head
#size 7
#hp 45
#prot 16
#mor 14
#str 18
#att 12
#def 14
#prec 12
#mapmove 20
#ap 28
#enc 0
#mr 18
#weapon 238 --magic staff
#weapon "Magical Bolt"
#weapon 823 -- magic claw
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 0 2
#magicskill 1 2
#magicskill 4 2
#magicskill 7 2
#magicstudy 2
#fixedname "Iohé Grevis"
#batstartsum4 628 --great lion
#end

#newmonster 8176 --Sol Aut high sorc
#spr1 "./EA_Sheseba/Solaut Higher Sorcerer.png"
#spr2 "./EA_Sheseba/Solaut Higher Sorcerer2.png"
#name "Highest Sorcerer"
#descr "Rehoboam is the highest ranking sorcerer in Sheseba. He is a master of magic and collector of great tomes. He has adorned his shoulders with two sentient tomes that cast spells on their own. Allowing him to bring unrivalled power to the battlefield."
#gcost 0
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 26
#prot 16
#mor 12
#str 18
#att 10
#def 10
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 18
#weapon 238 --magic staff
#weapon "Magical Bolt"
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 3
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 0 1
#magicskill 1 2
#magicskill 4 3
#magicskill 7 2
#magicstudy 2
#bonusspells 2
#poorleader
#poormagicleader
#batstartsum5 -18001 --batstart animals
#fixedname "Rehoboam"
#end

#newmonster 8177 --Sol Aut dawn guard
#spr1 "./EA_Sheseba/Dawn Guard.png"
#spr2 "./EA_Sheseba/Dawn Guard2.png"
#name "Dawn Guard"
#descr "The armies of Sheseba wield many artefacts left behind by the creators. Among the greatest treasures of the Vault of Sheseba is the armory of the original royal guard. Stocked with Dawn shields and blades these horned guards would protect the palaces of the creators. Now only a select few Sol Aut have the honor of wielding the remaining weapons."
#gcost 0
#rpcost 18
#rcost 17
#troglodyte
#size 5
#hp 27
#prot 16
#mor 15
#str 18
#att 14
#def 14
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 16
#weapon 520
#armor 166
#nametype 163 --naba male
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#end

#newmonster 8178 --Sol Aut spell guard
#spr1 "./EA_Sheseba/CaptainBenaiah.png"
#spr2 "./EA_Sheseba/CaptainBenaiah2.png"
#name "Dawn Guard Captain"
#descr "Benaiah is the captain of the Dawn Guard. The greatest general of Sheseba when the Awakened God declared their holy war."
#gcost 0
#rpcost 18
#rcost 17
#troglodyte
#size 5
#hp 27
#prot 16
#mor 15
#str 18
#att 14
#def 14
#prec 12
#mapmove 16
#ap 14
#enc 0
#mr 16
#weapon 520
#armor 166
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 2
#magicbeing
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#goodmagicleader
#expertleader
#fixedname "Benaiah"
#end

#newmonster 8179 --corrupted
#spr1 "./EA_Sheseba/Corrupted.png"
#spr2 "./EA_Sheseba/Corrupted2.png"
#name "Corrupted"
#descr "Ephippas was a rather unremarkable Sol Aut, one of the older ones created. Things changed when the demonic energies inside them managed to break containment. Instead of fleeing they took control of his mind. As a corrupted being he's easily recognized by his skirt of human limbs and the flickering of his banefire blade.

He's loathed by his kind but his dabbling in forbidden magic made them unwilling to openly move against him. He has now pledged himself to the Awakened God, may his service redeem him from his wicked ways."
#gcost 0
#rpcost 10007
#rcost 17
#troglodyte
#size 5
#hp 25
#prot 16
#mor 12
#str 18
#att 12
#def 11
#prec 11
#mapmove 16
#ap 14
#enc 0
#mr 12
#weapon 42 --bane blade
#armor 2 --shield
#spiritsight --blind?
#neednoteat
#pooramphibian
#animalawe 1
#magicbeing
#demon
#noheal
#inanimate
#wastesurvival
#acidres -5
#poisonres 15
#slashres
#magicskill 0 2
#magicskill 1 3
#magicskill 8 2
#magicskill 7 2
#goodmagicleader
#goodundeadleader
#fixedname "Ephippas"
#end

--------- names


--------- blessings


--------- sites
#newsite 
#name "Pillar of Knowledge"
#path 3
#level 0
#rarity 5
#gems 6 1
#allrange 1
#end

#newsite 
#name "Vault of Sheseba"
#path 7
#level 0
#rarity 5
#gems 0 2
#gems 1 2
#gems 7 1
#homemon "Sol Aut Champion"
#homecom "Mechanical Bird"
#homecom "Great Vessel"
#end

--------- nations
#selectnation 401
#name "Sheseba"
#epithet "Vessels of Might"
#era 1
#descr "Sheseba is a nation of constructs abandoned by their forgotten creators. It was a unity of two great lineages gifting their descendents with great magical power. This Scholomanic tradition allowed them to control the weather, speak to animals and bind spirits to metallic containers. Now the palaces and towers lay largely abandoned. As the Pantokrator send the creators away with a great task their servants remained. Metal men powered by the spirits trapped within their shells.

The constructs of Sol Aut tirelessly await the return of their creators. The arrival of the Awakened God has given them a new purpose. They now serve the holy war of their new patron, fielding the many wonders from the vaults of their creators against the enemies of the Awakened God." 

#summary "Race: Metal constructs, only heal in labs.

Military: Everyone is equally armored, wands to launch magical projectiles.

Magic: Air, Fire, Glamour, some Astral and Earth.

Priests: Poor, religion offers little to them."

#brief "A nation of artificial men with control over weather and beast."
#color 0.29 0.2 0.52
#secondarycolor 0.22 0.6 0.58
#flag "./EA_Sheseba/Flag.tga" --flag
#startsite "Pillar of Knowledge"
#startsite "Vault of Sheseba"
#idealcold -1
#defdrain -1

#aiairnation
#aiheavyrec 50

#startcom "Sol Aut Captain"
#startscout "Mechanical Bird"
#startunittype1 "Sol Aut Guard"
#startunitnbrs1 16
#startunittype2 "Sol Aut Caster"
#startunitnbrs2 16

#addrecunit "Sol Aut Archer"
#addrecunit "Sol Aut Caster"
#addrecunit "Sol Aut Guard"
#addrecunit "Spell Guard"
#addreccom "Flock of Birds"
#addreccom "Sol Aut Captain"
#addreccom "Sol Aut Sorcerer"
#addreccom "Sol Aut High Sorcerer"
#addreccom "Sol Aut Commander"
#addreccom "Sol Aut Priest"
-- #addreccom --great vessel
-- #addreccom "Walking Tome"

#hero1 8179 --corrupted
#hero2 8178
#hero3 8176
#hero4 8175
#multihero1 8177 --Sol Aut dawn guard

#defcom1 "Sol Aut Captain"
#defcom2 "Sol Aut Sorcerer"
#defunit1 "Sol Aut Guard"
#defunit1b "Sol Aut Archer"
#defunit2 "Sol Aut Caster"
-- #defunit2b
#defmult1 9
#defmult1b 9
#defmult2 9
#wallcom "Sol Aut Captain"
#wallunit "Sol Aut Caster"
#wallmult 9
#guardcom "Sol Aut Captain"
#guardunit "Sol Aut Guard"
#guardmult 9

-- #addgod
#homerealm 10
#homerealm 5
#homerealm 7

#addgod 607
#addgod 1025
#addgod 3346
#delgod 3651
#delgod 2446
#delgod 179
#delgod 2462
#delgod 265
#addgod 8172  --brass sphynx god
#cheapgod20 661
#cheapgod20 2137
#cheapgod20 2138
#cheapgod20 384
#cheapgod40 387
#cheapgod40 607

#fortera 1
#templepic 28

#halfdeathinc
#halfdeathpop
#end

--------- spells
#selectspell 542 --hinn
#restricted 401
#end

#selectspell 548 --smokeless fire
#restricted 401
#end

#selectspell 553 --binn
#restricted 401
#end

#selectspell 956 --pride lions
#restricted 401
#end

#selectspell 359 --lilot
#restricted 401
#end

#newspell
#name "Construct Brazen Head"
#descr "The mage constructs a great face from bronze and binds a spirit to it. The spirit will aid the mages of the lab in their researchy but will also cause unrest with it's lies."
#details "Brazen Head, inspire research 1, increases unrest."
#school 5 --thaum
#researchlevel 4
#path 0 4
#pathlevel 0 3
#fatiguecost 1000
#damage 8155 --brass head
#effect 10021 --sum com
#nreff 1
#restricted 401
#end

#newspell
#name "Repair Spell Guard Veteran"
#descr "The mage repairs a damaged Spell Guard, giving them great new legs fashioned like the front paws of a lion and the hind quarters of a bull."
#school 3 -- constr
#researchlevel 4
#path 0 0
#pathlevel 0 3
#fatiguecost 1500
#damage 8156 --Sol Aut spell guard centaur
#effect 10001 --sum mon
#nreff 503
#restricted 401
#end

#newspell
#name "Construct Brazen Sphinx"
#descr "The caster creates a vast creature from bronze and fills it with magical energies. It imitates a sphinx and it's riddle speak make it a poor leader."
#details "Large flier with trample."
#school 3
#researchlevel 6
#path 0 0
#pathlevel 0 4
#fatiguecost 3000
#damage 8157  --brass sphynx
#effect 10021 --sum com
#nreff 1
#restricted 401
#end

#newspell
#name "Construct Walking Tome"
#descr "The caster fashions a great tome to a walking platform creating a mobile construct that randomly fires spells in battle."
#details "The commander only has magic paths in combat."
#school 3
#researchlevel 4
#path 0 4
#pathlevel 0 2
#fatiguecost 500
#damage 8158 --world tome
#effect 10021 --sum com
#nreff 1
#restricted 401
#end

#newspell
#name "Call Ancient Sol Aut"
#descr "The mage awakens ancient Sol Aut from the catacombs. These ancient warriors wield magical flaming swords and are superior to their lesser kin."
#school 4 --ench
#researchlevel 6
#path 0 0
#pathlevel 0 3
#fatiguecost 1000
#damage 8160 --Sol Aut ancient
#effect 10001 --sum mon
#nreff 1003
#restricted 401
#end

#newspell
#copyspell 919 --cave grubs
#name "Summon Shamir"
#descr "In the deep caverns of the earth strange worms and crawling beasts can be found. Among them dwell the Shamir, beings once used by the creators of the Sol Aut. They require magical leadership to be compelled but are skilled in breaking down stone and metal with ease. This makes them useful in sieges."
#damage 8173  --shamir
#restricted 401
#end

#newspell
#name "Rouse Shamir"
#descr "Unable to find a cave entrance to travel down the mage instead goes into the cellars of the great palaces in search of a nest of Shamir. They're rare and only a single Shamir can be summoned this way. Shamir are beings once used by the creators of the Sol Aut to dig their vaults and build their palaces. They're exceptional in breaking down stone and metal."
#school 0 --conj?
#researchlevel 0
#path 6
#pathlevel 0 1
#fatiguecost 0 1
#damage 8173  --shamir
#effect 10001 --sum mon
#nreff 1
#onlyatsite "Vault of Sheseba"
#restricted 401
#end




--------- magic items
#newitem
#constlevel 5
#mainpath 7
#mainlevel 2
#spr "./EA_Sheseba/SpiritVessel.png"
#type 8
#name "Spirit Bottle"
#descr "A small bottle capped to trap a spirit inside. In battle it can be released to aid the wielder."
#batstartsum1 3463 --jinn
#researchbonus 7
#restricted 401
#end

#newitem
#constlevel 7
#mainpath 4
#mainlevel 4
#secondarypath 7
#secondarylevel 2
#spr "./EA_Sheseba/BookDeadlyNames.png"
#type 8
#name "Book of Deadly Names"
#descr "Book with the names and secrets of countless demons. Creator by the creators and copied by the Sol Aut."
#tainted 5
#magicboost 52 1
#restricted 401
#end

#newitem
#constlevel 5
#mainpath 1
#mainlevel 3
#secondarypath 7
#secondarylevel 1
#spr "./EA_Sheseba/RingPower.png"
#type 8
#name "Ring of Power"
#descr "Ring with the power over the weather, birds and demons. No demon can wield such power over their kin."
#nodemon
#beastmaster 2
#stormpower 2
#magicboost 1 1
#magicboost 7 1
#restricted 401
#end

#newitem
#constlevel 5
#mainpath 4
#mainlevel 2
#spr "./EA_Sheseba/Wand.png"
#type 1
#name "Casting Wand"
#descr "A perfectly balanced wand to aid in spellcasting."
#weapon "Wand"
#fastcast 50
#nationrebate 401
#restricted 401
#end

#selectitem 478
#restricted 401
#end

--------- general


--------- poptypes


--------- mercenaries


--------- events